﻿function CodeHandler(params) {
    this.btnNuevoCodigo = params.btnNuevoCodigo;
    this.formCodeModal = params.formCodeModal;
    this.tblCodigos = params.tblCodigos;
    this.codeForm = params.codeForm;
    this.btnSave = params.btnSave;
    this.txtCode = params.txtCode;
    this.txtDiscount = params.txtDiscount;
    this.txtStartDate = params.txtstartDate;
    this.txtEndDate = params.txtendDate;
    this.txtId = params.txtId;
    this.txtActive = params.txtActive;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.coderErrors = params.codeErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Codes/${id}`,
        Root: () => `${apiUrl}/Codes`,
    };
}
CodeHandler.prototype.Initialize = function () {
    this.SetupTable();
    this.TableEvents();
    this.SetupDatePicker();
    this.RegisterEvents();
}

CodeHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.formCodeModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoCodigo).click(() => {
        $('#code-modal-title').text('Nuevo Codigo');
        $(this.formCodeModal).find('.status').hide();
        $(this.formCodeModal).modal('show');
    });
    $(this.btnSave).unbind();
        $(this.codeForm).submit(event => {
            event.preventDefault();
            this.ClearError();
            this.Add(this);
        });
    //$(this.btnSave).click((evt) => {
    //    evt.stopImmediatePropagation();
    //});
}

CodeHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#code-modal-title').text('Actualizar Codigo');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    var endDate = Window.dateService.DisplayFormat(data.endDate);
                    var startDate = Window.dateService.DisplayFormat(data.startDate);
                    $(this.txtId).val(data.id);
                    $(this.txtEndDate).val(endDate);
                    $(this.txtCode).val(data.code);
                    $(this.txtDiscount).val(data.discount);
                    $(this.txtStartDate).val(startDate);
                    var active = data.active ? 1 : 0;
                    $(this.txtActive).val(active);
                    $(this.txtActive).change();
                    this.ClearError();
                    $(this.formCodeModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const code = $(element).parent().parent().find('td').get(3).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el codigo <strong>${code}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

CodeHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.active = u.active ? 'Activo' : 'Inactivo';
                u.createdAt = Window.dateService.DisplayFormat(u.createdAt);
                u.startDate = Window.dateService.DisplayFormat(u.startDate);
                u.endDate = Window.dateService.DisplayFormat(u.EndDate);
                u.discount = `${u.discount}%`;
                return u;
            })
            const datatable = $(this.tblCodigos).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}
CodeHandler.prototype.SetupDatePicker = function () {
    $(this.txtStartDate).datepicker({
        dateFormat: "dd/mm/yy"
    });
    $(this.txtEndDate).datepicker({
        dateFormat: "dd/mm/yy"
    });;
}

CodeHandler.prototype.SetupTable = () => {
    // Configure datatables
    //$(self.tblCodigos).DataTable();
    $(self.tblCodigos).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "createdAt" },
            { data: "createdBy" },
            { data: "code" },
            { data: "discount" },
            { data: "startDate" },
            { data: "endDate" },
            { data: "active" },
            { data: "action" }
        ],
    });
}
CodeHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Usuario eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
CodeHandler.prototype.Add = (params) => {

    const EndDate = $(params.txtEndDate).val() ? new Date(Window.dateService.SaveFormat($(params.txtEndDate).val())) : null,
        Code = $(params.txtCode).val(),
        Discount = $(params.txtDiscount).val() ? $(params.txtDiscount).val() : 0,
        StartDate = $(params.txtStartDate).val() ? new Date(Window.dateService.SaveFormat($(params.txtStartDate).val())) : null,
        Active = true;
    const code = {
        EndDate,
        Code: Code.trim(),
        Discount,
        StartDate,
        Active
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Codigo ${id ? 'actualizado' : 'creado'} correctamente`,

    };
    const args = {
        url: params.Urls.Root(),
        data: code,
        done: (data) => {
            $(this.formCodeModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.Get();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id != 0)  {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

CodeHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtEndDate).val('');
    $(this.txtCode).val('');
    $(this.txtDiscount).val('');
    $(this.txtStartDate).val('');
    $(this.txtRole).val('');
    $(this.txtRole).change();
}

CodeHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                ${Object.keys(errors).map(key => {
            return `<p>${key}</p>
                         <ul>
                            ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
                         </ul>`
        }).join('')
            }
            </div>
        `;
        $(this.coderErrors).append(errorHTML);
    }
}
CodeHandler.prototype.ClearError = function () {
    $(this.coderErrors).empty();
}
CodeHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}