﻿function RequestsHandler(params) {
    this.tipoPropiedad = params.tipoPropiedad;
    this.txtPredial = params.txtPredial;
    this.selectEdo = params.selectEdo;
    this.selectMpio = params.selectMpio;
    this.selectCd = params.selectCd;
    this.txtDireccion = params.txtDireccion;
    this.coloniaId = params.coloniaId;
    this.condicionInmueble = params.condicionInmueble;
    this.txtTotalArea = params.txtTotalArea;
    this.txtConsArea = params.txtConsArea;
    this.statusProcessoId = params.statusProcessoId;
    this.txtSuperfAd = params.txtSuperfAd;
    this.tstSuperfPro = params.tstSuperfPro;
    this.txtCocheraTer = params.txtCocheraTer;
    this.txtCocheraPro = params.txtCocheraPro;
    this.txtCuartoUtTer = params.txtCuartoUtTer;
    this.txtCuartoUtPro = params.txtCuartoUtPro;
    this.txtPasilloTer = params.txtPasilloTer;
    this.txtPasilloPro = params.txtPasilloPro;
    this.txtPorcheTer = params.txtPorcheTer;
    this.txtPorchePro = params.txtPorchePro;
    this.txtMallaSomTer = params.txtMallaSomTer;
    this.txtMallaSomPro = params.txtMallaSomPro;
    this.txtTejabanTer = params.txtTejabanTer;
    this.txtTejabanPro = params.txtTejabanPro;
    this.txtTerrazaTer = params.txtTerrazaTer;
    this.txtTerrazaPro = params.txtTerrazaPro;
    this.txtVoladoTer = params.txtVoladoTer;
    this.txtVoladoPro = params.txtVoladoPro;
    this.requestForm = params.requestForm;
    this.btnEnviarSolicitud = params.btnEnviarSolicitud
    this.user = params.user;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Codes/${id}`,
        Root: () => `${apiUrl}/Requests`,
        Estados: (id) => `${apiUrl}/Locations/Estados/${id}`,
        Ciudaded: (id) => `${apiUrl}/Locations/Ciudades/${id}`,
        BuildingProcess: () => `${apiUrl}/Catalogs/GetBuildingProcess`,
        Colonias: id => `${apiUrl}/Catalogs/Colonias/${id}`,
        BuildingStatus: () => `${apiUrl}/Catalogs/GetBuildingStatus`,
    };
}

RequestsHandler.prototype.Initialize = function () {
    this.GetEstados();
    this.GetBuildingProcess();
    this.GetBuildingStatus();
    //this.SetupTable();
    //this.TableEvents();
    //this.SetupDatePicker();
    this.RegisterEvents();
}
RequestsHandler.prototype.SetOptions = function (selectId, data) {
    const options = data.map(d => `<option value="${d.id}">${d.text}</option>`).join('');
    $(selectId).empty();
    $(selectId).append(options);
}
RequestsHandler.prototype.GetEstados = function () {
    const args = {
        url: this.Urls.Estados(159),
        done: (data) => {
            this.SetOptions(this.selectEdo, data);
            var cd = data.find(d => d.text.toLowerCase() === 'chihuahua');
            $(this.selectEdo).val(cd.id);
            $(this.selectEdo).change();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

RequestsHandler.prototype.GetCiudades = function (id) {
    const args = {
        url: this.Urls.Ciudaded(id),
        done: (data) => {
            this.SetOptions(this.selectMpio, data);
            var cd = data.find(d => d.text.toLowerCase() === 'chihuahua');
            $(this.selectMpio).val(cd.id);
            $(this.selectMpio).change();
            this.SetOptions(this.selectCd, data);
            $(this.selectCd).val(cd.id);
            $(this.selectCd).change();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

RequestsHandler.prototype.GetColonias = function (id) {
    const args = {
        url: this.Urls.Colonias(id),
        done: (data) => {
            this.SetOptions(this.coloniaId, data);
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

RequestsHandler.prototype.GetBuildingProcess = function () {
    const args = {
        url: this.Urls.BuildingProcess(),
        done: (data) => {
            this.SetOptions(this.statusProcessoId, data);
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}
RequestsHandler.prototype.GetBuildingStatus = function () {
    const args = {
        url: this.Urls.BuildingStatus(),
        done: (data) => {
            this.SetOptions(this.condicionInmueble, data);
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}
RequestsHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.selectEdo).select2();
    $(this.selectMpio).select2();
    $(this.statusProcessoId).select2();
    $(this.coloniaId).select2();
    $(this.selectEdo).change(function (e) {
        self.GetCiudades(e.target.value);
    });
    $(this.selectMpio).change(function (e) {
        self.GetColonias(e.target.value);
    });
    $(this.btnEnviarSolicitud).click(function (e) {
      
        var isValid = self.ValidateForm();
        if (isValid) {
            var obj = self.GetFormJosn();
            self.Add(obj);
        }
    })
}
RequestsHandler.prototype.ValidateForm = function () {
    var isNotValid = [];
    var validationService = new ValidationService();
    const fields = [
        $(this.tipoPropiedad),
        $(this.txtPredial),
        $(this.selectEdo),
        $(this.selectMpio),
        $(this.selectCd),
        $(this.txtDireccion),
        $(this.coloniaId),
        //$(this.condicionInmueble),
        //$(this.txtTotalArea),
        //$(this.txtConsArea),
        //$(this.statusProcessoId),
        //$(this.txtSuperfAd),
        //$(this.tstSuperfPro),
        //$(this.txtCocheraTer),
        //$(this.txtCocheraPro),
        //$(this.txtCuartoUtTer),
        //$(this.txtCuartoUtPro),
        //$(this.txtPasilloTer),
        //$(this.txtPasilloPro),
        //$(this.txtPorcheTer),
        //$(this.txtPorchePro),
        //$(this.txtMallaSomTer),
        //$(this.txtMallaSomPro),
        //$(this.txtTejabanTer),
        //$(this.txtTejabanPro),
        //$(this.txtTerrazaTer),
        //$(this.txtTerrazaPro),
        //$(this.txtVoladoTer),
        //$(this.txtVoladoPro)
    ];
    fields.forEach(e => {
        var valid = false;
        var isInput = e.is('input');
        if (isInput) {
            var type = e.attr('type');
            if (type.toLocaleLowerCase() === 'text') {
                if (e.attr('required')) {
                    valid = validationService.ValidString(e.val())
                    if (!valid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }

            } else if (type.toLocaleLowerCase() === 'number') {
                if(e.attr('required')) {
                    isValid = validationService.ValidNumber(e.val())
                    if (!isValid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }
            }
        } else {
            if(e.attr('required')) {
                    var val = e.val();
                    isValid = validationService.ValidNumber(val);
                    if (!isValid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }
        }
    });
    return isNotValid.length === 0;
}
RequestsHandler.prototype.GetFormJosn = function () {
    var User = $(this.user).val();
    var PropertyType = $(this.tipoPropiedad).val();
    var PropertyAccount = $(this.txtPredial).val();
    var StateId = $(this.selectEdo).val();
    var TownId = $(this.selectMpio).val();
    var City = $(this.selectCd).val();
    var Address = $(this.txtDireccion).val();
    var SuburbId = $(this.coloniaId).val();
    var PropertyCondition = $(this.condicionInmueble).val();
    var BuildingStatusId = $(this.condicionInmueble).val();
    var LandArea = parseFloat($(this.txtTotalArea).val()) || 0;
    var ConstructionArea = parseFloat($(this.txtConsArea).val()) || 0;
    var BuildingProcessId = $(this.statusProcessoId).val();
    var FinishedAdditionalArea = parseFloat($(this.txtSuperfAd).val()) || 0;
    var InConstructionAdditionalArea = parseFloat($(this.tstSuperfPro).val()) || 0;
    var FinishedGarage = parseFloat($(this.txtCocheraTer).val()) || 0;
    var InConstructionGarage = parseFloat($(this.txtCocheraPro).val()) || 0;
    var FinishedUtilityRoom = parseFloat($(this.txtCuartoUtTer).val()) || 0;
    var InConstructionAUtilityRoom = parseFloat($(this.txtCuartoUtPro).val()) || 0;
    var FinishedHallway = parseFloat($(this.txtPasilloTer).val()) || 0;
    var InConstructionHallway = parseFloat($(this.txtPasilloPro).val()) || 0;
    var FinishedPorch = parseFloat($(this.txtPorcheTer).val()) || 0;
    var InConstructionPorch = parseFloat($(this.txtPorchePro).val()) || 0;
    var FinishedShadeMeshSurface = parseFloat($(this.txtMallaSomTer).val()) || 0;
    var InConstructionShadeMeshSurface = parseFloat($(this.txtMallaSomPro).val()) || 0;
    var FinishedRoofTiles = parseFloat($(this.txtTejabanTer).val()) || 0;
    var InConstructionRoofTiles = parseFloat($(this.txtTejabanPro).val()) || 0;
    var FinishedTerrace = parseFloat($(this.txtTerrazaTer).val()) || 0;
    var InConstructionTerrace = parseFloat($(this.txtTerrazaPro).val()) || 0;
    var FinishedFlown = parseFloat($(this.txtVoladoTer).val()) || 0;
    var InConstructionFlown = parseFloat($(this.txtVoladoPro).val()) || 0;
    return {
        User,
        PropertyType,
        PropertyAccount,
        StateId,
        TownId,
        City,
        Address,
        SuburbId,
        PropertyCondition,
        LandArea,
        ConstructionArea,
        BuildingProcessId,
        FinishedAdditionalArea,
        InConstructionAdditionalArea,
        FinishedGarage,
        InConstructionGarage,
        FinishedUtilityRoom,
        InConstructionAUtilityRoom,
        FinishedHallway,
        InConstructionHallway,
        FinishedPorch,
        InConstructionPorch,
        FinishedShadeMeshSurface,
        InConstructionShadeMeshSurface,
        FinishedRoofTiles,
        InConstructionRoofTiles,
        FinishedTerrace,
        InConstructionTerrace,
        FinishedFlown,
        InConstructionFlown,
        BuildingStatusId
    };

}
RequestsHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#code-modal-title').text('Actualizar Codigo');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    var endDate = Window.dateService.DisplayFormat(data.endDate);
                    var startDate = Window.dateService.DisplayFormat(data.startDate);
                    $(this.txtId).val(data.id);
                    $(this.txtEndDate).val(endDate);
                    $(this.txtCode).val(data.code);
                    $(this.txtDiscount).val(data.discount);
                    $(this.txtStartDate).val(startDate);
                    var active = data.active ? 1 : 0;
                    $(this.txtActive).val(active);
                    $(this.txtActive).change();
                    this.ClearError();
                    $(this.formCodeModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const code = $(element).parent().parent().find('td').get(3).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el codigo <strong>${code}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

RequestsHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.active = u.active ? 'Activo' : 'Inactivo';
                u.createdAt = Window.dateService.DisplayFormat(u.createdAt);
                u.startDate = Window.dateService.DisplayFormat(u.startDate);
                u.endDate = Window.dateService.DisplayFormat(u.EndDate);
                u.discount = `${u.discount}%`;
                return u;
            })
            const datatable = $(this.tblCodigos).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}
RequestsHandler.prototype.SetupDatePicker = function () {
    $(this.txtStartDate).datepicker({
        dateFormat: "dd/mm/yy"
    });
    $(this.txtEndDate).datepicker({
        dateFormat: "dd/mm/yy"
    });;
}

RequestsHandler.prototype.SetupTable = () => {
    // Configure datatables
    //$(self.tblCodigos).DataTable();
    $(self.tblCodigos).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "createdAt" },
            { data: "createdBy" },
            { data: "code" },
            { data: "discount" },
            { data: "startDate" },
            { data: "endDate" },
            { data: "active" },
            { data: "action" }
        ],
    });
}
RequestsHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Usuario eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
RequestsHandler.prototype.Add = function(request) {
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Su solicitud ha sido creada correctamente`,

    };
    const args = {
        url: this.Urls.Root(),
        data: request,
        done: (data) => {
            this.ClearFields();
            iziToast.show(notificationParams);
            /*params.Get();*/
        }
    };
    Window.dataService.Post(args);
}

RequestsHandler.prototype.ClearFields = function () {
    $(this.tipoPropiedad).val('');
    $(this.txtPredial).val('');
    //$(this.selectEdo).val('');
    //$(this.selectMpio).val('');
    //$(this.selectCd).val('');
    $(this.txtDireccion).val('');
    $(this.coloniaId).val('');
    //$(this.condicionInmueble).val('');
    $(this.txtTotalArea).val('');
    $(this.txtConsArea).val('');
    //$(this.statusProcessoId).val('');
    $(this.txtSuperfAd).val('');
    $(this.tstSuperfPro).val('');
    $(this.txtCocheraTer).val('');
    $(this.txtCocheraPro).val('');
    $(this.txtCuartoUtTer).val('');
    $(this.txtCuartoUtPro).val('');
    $(this.txtPasilloTer).val('');
    $(this.txtPasilloPro).val('');
    $(this.txtPorcheTer).val('');
    $(this.txtPorchePro).val('');
    $(this.txtMallaSomTer).val('');
    $(this.txtMallaSomPro).val('');
    $(this.txtTejabanTer).val('');
    $(this.txtTejabanPro).val('');
    $(this.txtTerrazaTer).val('');
    $(this.txtTerrazaPro).val('');
    $(this.txtVoladoTer).val('');
    $(this.txtVoladoPro).val('');
}

RequestsHandler.prototype.DisplayErrors = function (element, errorMsg) {
    if (!$(element).hasClass('invalid')) {
        $(element).parent().append(`<span class="feedback">${errorMsg}</span>`);
        $(element).addClass('invalid');
    }
}
RequestsHandler.prototype.ClearError = function () {
    $(this.coderErrors).empty();
}
RequestsHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}