﻿function UserHandler(params) {
    this.btnNuevoUsuarioId = params.btnNuevoUsuarioId;
    this.formUserModal = params.formUserModal;
    this.tblUsuarios = params.tblUsuarios;
    this.userForm = params.userForm;
    this.btnSave = params.btnSave;
    this.txtCorreo = params.txtCorreo;
    this.txtNombre = params.txtNombre;
    this.txtApellido = params.txtApellido;
    this.txtPassword = params.txtPassword;
    this.txtRole = params.txtRole;
    this.txtId = params.txtId;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.userErrors = params.userErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Users/${id}`,
        Root: () => `${apiUrl}/Users`,
    };
}
UserHandler.prototype.Initialize = function () {
    this.SetupUsersTable();
    this.RegisterEvents();
}

UserHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.formUserModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoUsuarioId).click(() => {
        $('#user-modal-title').text('Nuevo Usuario');
        $(this.formUserModal).modal('show');
    });
    $(this.btnSave).unbind();
        $(this.userForm).submit(event => {
            this.ClearError();
            event.preventDefault();
            this.AddUser(this);
        });
    //$(this.btnSave).click((evt) => {
    //    evt.stopImmediatePropagation();
    //});
    $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#user-modal-title').text('Actualizar Usuario');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    $(this.txtId).val(data.id);
                    $(this.txtPassword).val(data.password);
                    $(this.txtCorreo).val(data.correo);
                    $(this.txtNombre).val(data.nombre);
                    $(this.txtApellido).val(data.apellido);
                    $(this.txtRole).val(data.role);
                    $(this.txtRole).change();
                    $(this.txtRole).attr('readonly', true);
                    this.ClearError();
                    $(this.formUserModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar al usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.DeleteUser(id);
                    }
                }
            });
        });
    });
}
UserHandler.prototype.GetUsers = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                return u;
            })
            const datatable = $(this.tblUsuarios).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.RegisterEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

UserHandler.prototype.SetupUsersTable = () => {
    // Configure datatables
    self.usersTable = $(self.tblUsuarios).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "userName" },
            { data: "nombre" },
            { data: "apellido" },
            { data: "correo" },
            { data: "role" },
            { data: "action" },
        ],
    });
}
UserHandler.prototype.DeleteUser = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.GetUsers();
            iziToast.show({ position: 'topRight', title: "Usuario eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
UserHandler.prototype.AddUser = (params) => {
    const user = {
        Password: $(params.txtPassword).val(),
        Correo: $(params.txtCorreo).val(),
        Nombre: $(params.txtNombre).val(),
        Apellido: $(params.txtApellido).val(),
        Role: $(params.txtRole).val(),
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Usuario ${id ? 'actualizado' : 'creado'} correctamente`,
        message: id ? '' : 'Se ha enviado un correo de confirmacion a ' + user.Correo

    };
    const args = {
        url: params.Urls.Root(),
        data: user,
        done: (data) => {
            $(this.formUserModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.GetUsers();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id) {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

UserHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtPassword).val('');
    $(this.txtCorreo).val('');
    $(this.txtNombre).val('');
    $(this.txtApellido).val('');
    $(this.txtRole).val('');
    $(this.txtRole).change();
}

UserHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                ${Object.keys(errors).map(key => {
            return `<p>${key}</p>
                         <ul>
                            ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
                         </ul>`
        }).join('')
            }
            </div>
        `;
        $(this.userErrors).append(errorHTML);
    }
}
UserHandler.prototype.ClearError = function () {
    $(this.userErrors).empty();
}
UserHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.userErrors).append(errorHTML);
    }
}