﻿function ValidationService() {

}

ValidationService.prototype.ValidRequiredString = function (str) {
    var isValid = v8n().string()
        .not.null()
        .not.empty()
        .test(str);
    return isValid;
}

ValidationService.prototype.ValidString = function (str) {
    var isValid = v8n().string()
        .test(str);
    return isValid;
}

ValidationService.prototype.ValidStringLength = function (str, length) {
    var isValid = v8n().string()
        .maxLength(length)
        .test(str);
    return isValid;
}

ValidationService.prototype.ValidRequiredNumber = function (str) {
    var isValid = v8n().numeric()
        .not.null()
        .not.empty()
        .test(str);
    return isValid;
}
ValidationService.prototype.ValidNumber = function (str) {
    var isValid = v8n().number()
        .test(str);
    return isValid;
}
ValidationService.prototype.ValidMaxNumber = function (str, maxValue) {
    var isValid = v8n().lessThanOrEqual(maxValue).test(str);
    return isValid;
}