﻿function EditRequestsHandler(params) {
    this.selectMotivoConsulta = params.selectMotivoConsulta;
    this.tipoPropiedad = params.tipoPropiedad;
    this.txtPropietario = params.txtPropietario;
    this.txtPredial = params.txtPredial;
    this.selectEdo = params.selectEdo;
    this.selectMpio = params.selectMpio;
    this.selectCd = params.selectCd;
    this.txtDireccion = params.txtDireccion;
    this.txtNumExt = params.txtNumExt;
    this.txtNumInt = params.txtNumInt;
    this.coloniaId = params.coloniaId;
    this.txtCP = params.txtCP;
    this.condicionInmueble = params.condicionInmueble;
    this.txtTotalArea = params.txtTotalArea;
    this.txtConsArea = params.txtConsArea;
    this.txtAreaComun = params.txtAreaComun;
    this.statusProcessoId = params.statusProcessoId;
    this.inConstructionProcess = params.inConstructionProcess;
    this.txtSuperfAd = params.txtSuperfAd;
    this.tstSuperfPro = params.tstSuperfPro;
    this.txtCocheraTer = params.txtCocheraTer;
    this.txtCocheraPro = params.txtCocheraPro;
    this.txtCuartoUtTer = params.txtCuartoUtTer;
    this.txtCuartoUtPro = params.txtCuartoUtPro;
    this.txtPasilloTer = params.txtPasilloTer;
    this.txtPasilloPro = params.txtPasilloPro;
    this.txtPorcheTer = params.txtPorcheTer;
    this.txtPorchePro = params.txtPorchePro;
    this.txtMallaSomTer = params.txtMallaSomTer;
    this.txtMallaSomPro = params.txtMallaSomPro;
    this.txtTejabanTer = params.txtTejabanTer;
    this.txtTejabanPro = params.txtTejabanPro;
    this.txtTerrazaTer = params.txtTerrazaTer;
    this.txtTerrazaPro = params.txtTerrazaPro;
    this.txtVoladoTer = params.txtVoladoTer;
    this.txtVoladoPro = params.txtVoladoPro;
    this.txtAlbercaTer = params.txtAlbercaTer;
    this.txtAlbercaPro = params.txtAlbercaPro;
    this.requestForm = params.requestForm;
    this.btnEnviarSolicitud = params.btnEnviarSolicitud;

    this.chkDetalleValorPropuesto = params.chkDetalleValorPropuesto;
    this.chkDetalleValorTerreno = params.chkDetalleValorTerreno;
    this.chkDetalleValorConstruccion = params.chkDetalleValorConstruccion;
    this.DivDetalleValorPropuesto = params.DivDetalleValorPropuesto;
    this.DivDetalleValorTerreno = params.DivDetalleValorTerreno;
    this.DivDetalleValorConstruccion = params.DivDetalleValorConstruccion;

    this.SelectEdadVivienda = params.SelectEdadVivienda;
    this.SelectMantenimiento = params.SelectMantenimiento;
    this.SelectTipoAcabado = params.SelectTipoAcabado;
    this.SelectInstalacionEspecial = params.SelectInstalacionEspecial;

    this.SelectCondicionTopografica = params.SelectCondicionTopografica;
    this.SelectFactorTopografico = params.SelectFactorTopografico;
    this.SelectFactorUbicacion = params.SelectFactorUbicacion;
    this.SelectFactorSuperficie = params.SelectFactorSuperficie;
    this.SelectInfraestructuraServicios = params.SelectInfraestructuraServicios;
    this.SelectServiciosBasicos = params.SelectServiciosBasicos;

    this.SelectFactorTipoTecho = params.SelectFactorTipoTecho;
    this.SelectFactorMaterialConstruccion = params.SelectFactorMaterialConstruccion;
    this.SelectFactorEspecial = params.SelectFactorEspecial;

    this.user = params.user;
    this.requestUrl = params.requestUrl;
    this.lat = params.lat;
    this.lng = params.lng;
    this.mapDiv = params.mapDiv;
    this.requestId = params.requestId;
    const { apiUrl } = params;
    this.map = null;
    this.geocode = null;
    this.marker = new google.maps.Marker({
        draggable: true
    });
    this.Urls = {
        ById: (id) => `${apiUrl}/Requests/${id}`,
        Root: () => `${apiUrl}/Requests`,
        Estados: (id) => `${apiUrl}/Locations/Estados/${id}`,
        Ciudaded: (id) => `${apiUrl}/Locations/Ciudades/${id}`,
        BuildingProcess: () => `${apiUrl}/Catalogs/GetBuildingProcess`,
        Colonias: id => `${apiUrl}/Catalogs/Colonias/${id}`,
        BuildingStatus: () => `${apiUrl}/Catalogs/GetBuildingStatus`,
    };
}

EditRequestsHandler.prototype.Initialize = function () {
    this.InitMap();
    this.RegisterEvents();
    $(this.statusProcessoId).change();
    $(this.chkDetalleValorPropuesto).change();
    $(this.chkDetalleValorTerreno).change();
    $(this.chkDetalleValorConstruccion).change();
    const previousValue = $(self.SelectFactorTopografico).val();
    $(this.SelectCondicionTopografica).change();
    $(self.SelectFactorTopografico).val(previousValue);

    $(this.selectMpio).style.display= 'none;'
    
}
EditRequestsHandler.prototype.InitMap = function () {
    var mapDiv = document.getElementById('map');
    this.map = new google.maps.Map(mapDiv, {
        center: { lng: -106.1228103, lat: 28.6830972 },
        zoom: 15,
        streetViewControl: false,
        fullscreenControl: false,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    });
    var lat = $(this.lat).val();
    var lng = $(this.lng).val();
    var position = {};
    if (lat && lng) {
        position.lat = +lat;
        position.lng = +lng;
        this.marker.setDraggable(false);
        this.map.setCenter(position);
        this.marker.setPosition(position);
        this.marker.setMap(this.map);
        this.map.setZoom(18);
    }
    this.geocoder = new google.maps.Geocoder();
}
EditRequestsHandler.prototype.GeocodeAddress = function (address) {
    this.geocoder.geocode({ address: address }, (results, status) => {
        console.log(results, status)
        if (status === "OK") {
            this.map.setCenter(results[0].geometry.location);
            this.marker.setPosition(results[0].geometry.location);
            this.marker.setMap(this.map);
            this.map.setZoom(18);
        } else {
            alert("Geocode was not successful for the following reason: " + status);
        }
    });
}

EditRequestsHandler.prototype.RegisterEvents = function () {
    self = this;
    google.maps.event.addListener(this.marker, 'dragend', function(ev){
        var position = self.marker.getPosition();
        $(self.lat).val(position.lat());
        $(self.lng).val(position.lng());
    });
    $(this.selectMotivoConsulta).select2();
    //$(this.selectEdo).select2();
    //$(this.selectMpio).select2();
    $(this.statusProcessoId).select2();
    //$(this.coloniaId).select2();

    $(this.btnEnviarSolicitud).click(function (e) {

        var isValid = self.ValidateForm();
        if (isValid) {
            var obj = self.GetFormJosn();
            self.Add(obj);
        }
    });
    $(this.statusProcessoId).change(function (e) {
        const fields = [
            self.inConstructionProcess,
            self.txtCocheraPro,
            self.txtCuartoUtPro,
            self.txtPasilloPro,
            self.txtPorchePro,
            self.txtMallaSomPro,
            self.txtTejabanPro,
            self.txtTerrazaPro,
            self.txtVoladoPro,
            self.txtAlbercaPro];
        if (e.target.value != -1) {
            fields.forEach(f => {
                if ($(f).attr('disabled')) {
                    $(f).removeAttr('disabled');
                }
            });
        } else {
            fields.forEach(f => {
                $(f).val('');
                $(f).attr('disabled', '');
                $(self.tstSuperfPro).val('');
            });
        }
    });

    $(this.inConstructionProcess).blur(function (e){
        var value = e.target.value
        $(self.tstSuperfPro).val(value);
    })
    $('.aditional').blur(function (e) {
        var elements = document.getElementsByClassName('aditional');
        var aF = 0
        var aC = 0;
        for (var e of elements) {
            var name = e.attributes.name.value.toLowerCase();
            if (name.indexOf('finished') !== -1 && e.value) {
                aF += parseFloat(e.value);
            } else {
                if (e.value) {
                    aC += parseFloat(e.value);
                }
            }
        }
        $(self.txtSuperfAd).val(aF);
        var valueInConstruction = $(self.inConstructionProcess).val();
        if (valueInConstruction) {
            aC += parseFloat(valueInConstruction);
        }
        $(self.tstSuperfPro).val(aC);
    });

    $(self.SelectCondicionTopografica).change(function (e) {
        const text = $(self.SelectCondicionTopografica + " option:selected").text();
        if (text == "Normal") {
            $(self.SelectFactorTopografico + " option[value=0]").prop("disabled", false);
        }
        else {
            $(self.SelectFactorTopografico + " option[value=0]").prop("disabled", true);
            $(self.SelectFactorTopografico).val('');
        }
       
    });

    $(self.chkDetalleValorPropuesto).change(function (e) {
        if (!$(self.chkDetalleValorPropuesto).is(':checked')) {
            $(self.SelectEdadVivienda).val('');
            $(self.SelectEdadVivienda).prop("disabled", true);
            $(self.SelectMantenimiento).val('');
            $(self.SelectMantenimiento).prop("disabled", true);
            $(self.SelectTipoAcabado).val('');
            $(self.SelectTipoAcabado).prop("disabled", true);
            $(self.SelectInstalacionEspecial).val('');
            $(self.SelectInstalacionEspecial).prop("disabled", true);
        }
        else {
            $(self.SelectEdadVivienda).prop("disabled", false);
            $(self.SelectMantenimiento).prop("disabled", false);
            $(self.SelectTipoAcabado).prop("disabled", false);
            $(self.SelectInstalacionEspecial).prop("disabled", false);
        }
    });
    $(self.chkDetalleValorConstruccion).change(function (e) {
        if (!$(self.chkDetalleValorConstruccion).is(':checked')) {
            $(self.SelectFactorTipoTecho).val('');
            $(self.SelectFactorTipoTecho).prop("disabled", true);
            $(self.SelectFactorMaterialConstruccion).val('');
            $(self.SelectFactorMaterialConstruccion).prop("disabled", true);
            $(self.SelectFactorEspecial).val('');
            $(self.SelectFactorEspecial).prop("disabled", true);

        }
        else {
            $(self.SelectFactorTipoTecho).prop("disabled", false);
            $(self.SelectFactorMaterialConstruccion).prop("disabled", false);
            $(self.SelectFactorEspecial).prop("disabled", false);
        }
    });
    $(self.chkDetalleValorTerreno).change(function (e) {
        if (!$(self.chkDetalleValorTerreno).is(':checked')) {
            $(self.SelectFactorUbicacion).val('');
            $(self.SelectFactorUbicacion).prop("disabled", true);
            $(self.SelectFactorSuperficie).val('');
            $(self.SelectFactorSuperficie).prop("disabled", true);
            $(self.SelectInfraestructuraServicios).val('');
            $(self.SelectInfraestructuraServicios).prop("disabled", true);
            $(self.SelectServiciosBasicos).val('');
            $(self.SelectServiciosBasicos).prop("disabled", true);
            $(self.SelectCondicionTopografica).val('');
            $(self.SelectCondicionTopografica).prop("disabled", true);
            $(self.SelectFactorTopografico).val('');
            $(self.SelectFactorTopografico).prop("disabled", true);
        }
        else {
            $(self.SelectFactorUbicacion).prop("disabled", false);
            $(self.SelectFactorSuperficie).prop("disabled", false);
            $(self.SelectInfraestructuraServicios).prop("disabled", false);
            $(self.SelectServiciosBasicos).prop("disabled", false);
            $(self.SelectCondicionTopografica).prop("disabled", false);
            $(self.SelectFactorTopografico).prop("disabled", false);
        }
    });

}
EditRequestsHandler.prototype.ValidateForm = function () {
    var isNotValid = [];
    var validationService = new ValidationService();
    const fields = [
        $(this.selectMotivoConsulta),
        $(this.tipoPropiedad),
        $(this.txtPredial),
        $(this.selectEdo),
        //$(this.selectMpio),
        $(this.selectCd),
        $(this.txtDireccion),
        $(this.txtNumExt),
        $(this.coloniaId),
        $(this.txtSuperfAd),
        $(this.tstSuperfPro),
        $(this.txtCocheraTer),
        $(this.txtCocheraPro),
        $(this.txtCuartoUtTer),
        $(this.txtCuartoUtPro),
        $(this.txtPasilloTer),
        $(this.txtPasilloPro),
        $(this.txtPorcheTer),
        $(this.txtPorchePro),
        $(this.txtMallaSomTer),
        $(this.txtMallaSomPro),
        $(this.txtTejabanTer),
        $(this.txtTejabanPro),
        $(this.txtTerrazaTer),
        $(this.txtTerrazaPro),
        $(this.txtVoladoTer),
        $(this.txtVoladoPro),
        $(this.txtAlbercaTer),
        $(this.txtAlbercaPro)
    ];

    const DetalleValorPropuesto = $(this.chkDetalleValorPropuesto).is(':checked');
    const DetalleValorConstruccion = $(this.chkDetalleValorConstruccion).is(':checked');
    const DetalleValorTerreno = $(this.chkDetalleValorTerreno).is(':checked');
    const IdEdadVivienda = $(this.SelectEdadVivienda).val();
    const IdMantenimiento = $(this.SelectMantenimiento).val();
    const IdTipoAcabado = $(this.SelectTipoAcabado).val();
    const IdInstalacionEspecial = $(this.SelectInstalacionEspecial).val();
    const IdFactorSuperficie = $(this.SelectFactorSuperficie).val();
    const IdFactorUbicacion = $(this.SelectFactorUbicacion).val();
    const IdInfraestructuraServicios = $(this.SelectInfraestructuraServicios).val();
    const IdFactorTipoTecho = $(this.SelectFactorTipoTecho).val();
    const IdFactorMaterialConstruccion = $(this.SelectFactorMaterialConstruccion).val();
    const IdFactorEspecial = $(this.SelectFactorEspecial).val();
    const ServiciosBasicos = $(this.SelectServiciosBasicos).val();
    const IdFactorTopografia = $(this.SelectCondicionTopografica).val() ;
    const PorcentajeInclinacion = $(this.SelectFactorTopografico).val() ;

    if (DetalleValorConstruccion) {
        if (!IdFactorTipoTecho) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorTipoTecho), 'Campo Requerido');
        }
        if (!IdFactorMaterialConstruccion) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorMaterialConstruccion), 'Campo Requerido');
        }
        if (!IdFactorEspecial) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorEspecial), 'Campo Requerido');
        }

    }
    if (DetalleValorPropuesto) {
        if (!IdEdadVivienda) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectEdadVivienda), 'Campo Requerido');
        }
        if (!IdMantenimiento) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectMantenimiento), 'Campo Requerido');
        }
        if (!IdTipoAcabado) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectTipoAcabado), 'Campo Requerido');
        }
        if (!IdInstalacionEspecial) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectInstalacionEspecial), 'Campo Requerido');
        }
    }

    if (DetalleValorTerreno) {
        if (!IdFactorUbicacion) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorUbicacion), 'Campo Requerido');
        }
        if (!IdFactorSuperficie) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorSuperficie), 'Campo Requerido');
        }
        if (!IdInfraestructuraServicios) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectInfraestructuraServicios), 'Campo Requerido');
        }
        if (!ServiciosBasicos) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectServiciosBasicos), 'Campo Requerido');
        }
        if (!IdFactorTopografia) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectCondicionTopografica), 'Campo Requerido');
        }
        if (!PorcentajeInclinacion) {
            isNotValid.push(false);
            this.DisplayErrors($(this.SelectFactorTopografico), 'Campo Requerido');
        }
    }

    fields.forEach(e => {
        var valid = false;
        var isInput = e.is('input');
        if (isInput) {
            var type = e.attr('type');
            if (type.toLocaleLowerCase() === 'text') {
                if (e.attr('required')) {
                    valid = validationService.ValidRequiredString(e.val());
                    if (!valid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                } else {
                    valid = validationService.ValidString(e.val())
                    if (!valid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'No es un texto valido');
                    }
                }

            } else if (type.toLocaleLowerCase() === 'number') {
                if (e.attr('required')) {
                    isValid = validationService.ValidRequiredNumber(+e.val());
                    if (!isValid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                } else {
                    isValid = validationService.ValidNumber(+e.val());
                    if (!isValid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'No es un numero valido');
                    }
                }
            }
        } else {
            if(e.attr('required')) {
                    var val = e.val();
                    isValid = validationService.ValidNumber(+val);
                    if (!isValid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }
        }
    });
    return isNotValid.length === 0;
}
EditRequestsHandler.prototype.GetFormJosn = function () {
    var User = $(this.user).val();
    var PropertyType = $(this.tipoPropiedad).val();
    var PropertyOwner = $(this.txtPropietario).val();
    var PropertyAccount = $(this.txtPredial).val();
    var StateId = $(this.selectEdo).val();
    var TownId = $(this.selectCd).val();
    var City = $(this.selectCd).val();
    var Address = $(this.txtDireccion).val();
    var ExternalNumber = $(this.txtNumExt).val();
    var InternalNumber = $(this.txtNumInt).val();
    var ZipCode = $(this.txtCP).val() || null;
    var SuburbId = $(this.coloniaId).val();
    var PropertyCondition = $(this.condicionInmueble).val();
    var BuildingStatusId = $(this.condicionInmueble).val();
    var LandArea = parseFloat($(this.txtTotalArea).val()) || 0;
    var ConstructionArea = parseFloat($(this.txtConsArea).val()) || 0;
    var CommonArea = parseFloat($(this.txtAreaComun).val()) || 0;
    var BuildingProcessId = $(this.statusProcessoId).val() == -1 ? null : $(this.statusProcessoId).val();
    var FinishedAdditionalArea = parseFloat($(this.txtSuperfAd).val()) || 0;
    var InConstructionAdditionalArea = parseFloat($(this.tstSuperfPro).val()) || 0;
    var FinishedGarage = parseFloat($(this.txtCocheraTer).val()) || 0;
    var InConstructionGarage = parseFloat($(this.txtCocheraPro).val()) || 0;
    var FinishedUtilityRoom = parseFloat($(this.txtCuartoUtTer).val()) || 0;
    var InConstructionAUtilityRoom = parseFloat($(this.txtCuartoUtPro).val()) || 0;
    var FinishedHallway = parseFloat($(this.txtPasilloTer).val()) || 0;
    var InConstructionHallway = parseFloat($(this.txtPasilloPro).val()) || 0;
    var FinishedPorch = parseFloat($(this.txtPorcheTer).val()) || 0;
    var InConstructionPorch = parseFloat($(this.txtPorchePro).val()) || 0;
    var FinishedShadeMeshSurface = parseFloat($(this.txtMallaSomTer).val()) || 0;
    var InConstructionShadeMeshSurface = parseFloat($(this.txtMallaSomPro).val()) || 0;
    var FinishedRoofTiles = parseFloat($(this.txtTejabanTer).val()) || 0;
    var InConstructionRoofTiles = parseFloat($(this.txtTejabanPro).val()) || 0;
    var FinishedTerrace = parseFloat($(this.txtTerrazaTer).val()) || 0;
    var InConstructionTerrace = parseFloat($(this.txtTerrazaPro).val()) || 0;
    var FinishedFlown = parseFloat($(this.txtVoladoTer).val()) || 0;
    var InConstructionFlown = parseFloat($(this.txtVoladoPro).val()) || 0;
    var FinishedPool = parseFloat($(this.txtAlbercaTer).val()) || 0;
    var InConstructionPool = parseFloat($(this.txtAlbercaPro).val()) || 0;
    var Latitude = $(this.lat).val();
    var Longitude = $(this.lng).val();
    var InConstructionProcess = parseFloat($(this.inConstructionProcess).val()) || 0;
    var DetalleValorPropuesto = $(this.chkDetalleValorPropuesto).is(':checked');
    var DetalleValorConstruccion = $(this.chkDetalleValorConstruccion).is(':checked');
    var DetalleValorTerreno = $(this.chkDetalleValorTerreno).is(':checked');
    var IdEdadVivienda = $(this.SelectEdadVivienda).val() || null;
    var IdMantenimiento = $(this.SelectMantenimiento).val() || null;
    var IdTipoAcabado = $(this.SelectTipoAcabado).val() || null;
    var IdInstalacionEspecial = $(this.SelectInstalacionEspecial).val() || null;
    var IdFactorSuperficie = $(this.SelectFactorSuperficie).val() || null;
    var IdFactorUbicacion = $(this.SelectFactorUbicacion).val() || null;
    var IdInfraestructuraServicios = $(this.SelectInfraestructuraServicios).val() || null;
    var IdFactorTipoTecho = $(this.SelectFactorTipoTecho).val() || null;
    var IdFactorMaterialConstruccion = $(this.SelectFactorMaterialConstruccion).val() || null;
    var IdFactorEspecial = $(this.SelectFactorEspecial).val() || null;
    var IdMotivoConsulta = $(this.selectMotivoConsulta).val();
    var ServiciosBasicos = $(this.SelectServiciosBasicos).val() || null;
    var IdFactorTopografia = $(this.SelectCondicionTopografica).val() || null;
    var PorcentajeInclinacion = $(this.SelectFactorTopografico).val() || 0;
    ServiciosBasicos = ServiciosBasicos ? ServiciosBasicos === "true" : ServiciosBasicos;
    
    return {
        User,
        PropertyType,
        PropertyAccount,
        PropertyOwner,
        StateId,
        TownId,
        City,
        Address,
        ExternalNumber,
        InternalNumber,
        ZipCode,
        SuburbId,
        PropertyCondition,
        LandArea,
        ConstructionArea,
        CommonArea,
        BuildingProcessId,
        FinishedAdditionalArea,
        InConstructionAdditionalArea,
        FinishedGarage,
        InConstructionGarage,
        FinishedUtilityRoom,
        InConstructionAUtilityRoom,
        FinishedHallway,
        InConstructionHallway,
        FinishedPorch,
        InConstructionPorch,
        FinishedShadeMeshSurface,
        InConstructionShadeMeshSurface,
        FinishedRoofTiles,
        InConstructionRoofTiles,
        FinishedTerrace,
        InConstructionTerrace,
        FinishedFlown,
        InConstructionFlown,
        FinishedPool,
        InConstructionPool,
        BuildingStatusId,
        Latitude,
        Longitude,
        InConstructionProcess,
        DetalleValorPropuesto,
        DetalleValorConstruccion,
        DetalleValorTerreno,
        IdEdadVivienda,
        IdMantenimiento,
        IdTipoAcabado,
        IdInstalacionEspecial,
        IdFactorSuperficie,
        IdFactorUbicacion,
        IdInfraestructuraServicios,
        IdFactorTipoTecho,
        IdFactorMaterialConstruccion,
        IdFactorEspecial,
        ServiciosBasicos,
        IdFactorTopografia,
        PorcentajeInclinacion,
        IdMotivoConsulta
    };

}

EditRequestsHandler.prototype.Add = function(request) {
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Su solicitud ha sido Actualizada correctamente`,

    };
    var id = $(this.requestId).val();
    const args = {
        url: this.Urls.ById(id),
        data: request,
        done: (data) => {
            //this.ClearFields();
            iziToast.show(notificationParams);
            var url = $(this.requestUrl).val().replace('ID', data.id);
            window.location = url;
        }
    };
    Window.dataService.Put(args);
}

EditRequestsHandler.prototype.ClearFields = function () {
    $(this.tipoPropiedad).val('');
    $(this.txtPredial).val('');
    $(this.txtPropietario).val('');
    //$(this.selectEdo).val('');
    //$(this.selectMpio).val('');
    //$(this.selectCd).val('');
    $(this.txtDireccion).val('');
    $(this.coloniaId).val('');
    //$(this.condicionInmueble).val('');
    $(this.txtTotalArea).val('');
    $(this.txtNumExt).val('');
    $(this.txtNumInt).val('');
    $(this.txtCP).val('');
    $(this.txtConsArea).val('');
    $(this.txtAreaComun).val('');
    //$(this.statusProcessoId).val('');
    $(this.txtSuperfAd).val('');
    $(this.tstSuperfPro).val('');
    $(this.txtCocheraTer).val('');
    $(this.txtCocheraPro).val('');
    $(this.txtCuartoUtTer).val('');
    $(this.txtCuartoUtPro).val('');
    $(this.txtPasilloTer).val('');
    $(this.txtPasilloPro).val('');
    $(this.txtPorcheTer).val('');
    $(this.txtPorchePro).val('');
    $(this.txtMallaSomTer).val('');
    $(this.txtMallaSomPro).val('');
    $(this.txtTejabanTer).val('');
    $(this.txtTejabanPro).val('');
    $(this.txtTerrazaTer).val('');
    $(this.txtTerrazaPro).val('');
    $(this.txtVoladoTer).val('');
    $(this.txtVoladoPro).val('');
    $(this.txtAlbercaTer).val('');
    $(this.txtAlbercaPro).val('');
}

EditRequestsHandler.prototype.DisplayErrors = function (element, errorMsg) {
    if (!$(element).hasClass('invalid')) {
        $(element).parent().append(`<span class="feedback">${errorMsg}</span>`);
        $(element).addClass('invalid');
    }
}
EditRequestsHandler.prototype.ClearError = function () {
    $(this.coderErrors).empty();
}