﻿function MotivoConsultaHandler(params) {
    this.btnNuevoCodigo = params.btnNuevoCodigo;
    this.formMotivoConsultaModal = params.formMotivoConsultaModal;
    this.tblMotivoConsulta = params.tblMotivoConsulta;
    this.MotivoConsultaForm = params.MotivoConsultaForm;
    this.btnSave = params.btnSave;
    this.txtMotivoConsulta = params.txtMotivoConsulta;
   
    
    this.txtId = params.txtId;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.MotivoConsultarErrors = params.MotivoConsultaErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/requests/MotivosConsulta/${id}`,
        Root: () => `${apiUrl}/requests/MotivosConsulta`
    };
}
MotivoConsultaHandler.prototype.Initialize = function () {
    this.SetupTable(this);
    this.RegisterEvents();
}

MotivoConsultaHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.formMotivoConsultaModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoCodigo).click(() => {
        $('#MotivoConsulta-modal-title').text('Agregar Tipo de Plan');
        
        $(this.formMotivoConsultaModal).modal('show');
    });
    $(this.btnSave).unbind();
        $(this.MotivoConsultaForm).submit(event => {
            event.preventDefault();
            this.ClearError();
            this.Add(this);
        });
    
}

MotivoConsultaHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#MotivoConsulta-modal-title').text('Actualizar Tipo de Plan');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    $(this.txtId).val(data.id);
                   
                    $(this.txtMotivoConsulta).val(data.descripcion);
                    
                    this.ClearError();
                    $(this.formMotivoConsultaModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const MotivoConsulta = $(element).parent().parent().find('td').get(1).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el tipo de consulta <strong>${MotivoConsulta}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

MotivoConsultaHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.deleted = u.deleted ? 'Inactivo' : 'Activo';
                u.showEdit = u.showEdit ? "Si" : "No";
                return u;
            })
            const datatable = $(this.tblMotivoConsulta).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}


MotivoConsultaHandler.prototype.SetupTable = (objThis) => {
    // Configure datatables
    $(self.tblMotivoConsulta).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "descripcion" },
            { data: "deleted" },
            { data: "action" }
        ],
        drawCallback: function (settings) {
            objThis.TableEvents();
        }
    });
}
MotivoConsultaHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Tipo de plan eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
MotivoConsultaHandler.prototype.Add = (params) => {

    const
        Description = $(params.txtMotivoConsulta).val();
    const MotivoConsulta = {
        Descripcion: Description.trim()
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Motivo de consulta ${id ? 'actualizado' : 'creado'} correctamente`,

    };
    const args = {
        url: params.Urls.Root(),
        data: MotivoConsulta,
        done: (data) => {
            $(this.formMotivoConsultaModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.Get();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id != 0)  {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

MotivoConsultaHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtMotivoConsulta).val('');
}

MotivoConsultaHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.MotivoConsultarErrors).append(errorHTML);
    }
}
MotivoConsultaHandler.prototype.ClearError = function () {
    $(this.MotivoConsultarErrors).empty();
}
MotivoConsultaHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}