﻿function PaymentHandler(params) {
    this.tblPays = params.tblPays;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Codes/${id}`,
        Root: () => `${apiUrl}/Codes`,
    };
}
PaymentHandler.prototype.Initialize = function () {
    this.SetupTable();
    //this.TableEvents();
    this.RegisterEvents();
}

PaymentHandler.prototype.RegisterEvents = function () {
    self = this;
}

PaymentHandler.prototype.SetupTable = () => {
    // Configure datatables
    //$(self.tblPays).DataTable();
    $(self.tblPays).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "Id" },
            { data: "User.Name" },
            { data: "CreatedAt" },
            { data: "Plan.Description" },
            { data: "Plan.AvailableCertificates" },
            { data: "Code.Code" },
            { data: "Total" },
        ],
    });
}