﻿function PlanHandler(params) {
    this.btnNuevoPlan = params.btnNuevoPlan;
    this.formPlanModal = params.formPlanModal;
    this.tblPlans = params.tblPlans;
    this.planForm = params.planForm;
    this.btnSave = params.btnSave;
    this.txtCosto = params.txtCosto;
    this.txtDescripcion = params.txtDescripcion;
    this.txtCertificados = params.txtCertificados;
    this.txtMonthsAvailable = params.txtMonthsAvailable;
    this.SelectTipoPlan = params.SelectTipoPlan;
    this.SelectTipoConsulta = params.SelectTipoConsulta;
    this.SelectSpecialPrice = params.SelectSpecialPrice;
    this.SelectOpcionExpiracion = params.SelectOpcionExpiracion;
    this.txtId = params.txtId;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.coderErrors = params.codeErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Plans/${id}`,
        Root: () => `${apiUrl}/Plans`,
    };
}
PlanHandler.prototype.Initialize = function () {
    this.SetupTable(this);
   
    this.RegisterEvents();
}

PlanHandler.prototype.RegisterEvents = function () {
    const self = this;
    $(this.formPlanModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoPlan).click(() => {
        $('#code-modal-title').text('Nuevo Plan');
        $(this.formPlanModal).find('.status').hide();
        $(this.formPlanModal).modal('show');
    });

    $(this.SelectOpcionExpiracion).change(() => {
        const selection = $(self.SelectOpcionExpiracion).val();
        if (selection== "1") {
            $(self.txtCertificados).prop("disabled", true);
            $(self.txtCertificados).val('');
            $(self.txtMonthsAvailable).prop("disabled", false);
        } else {
            $(self.txtCertificados).prop("disabled", false);
            $(self.txtMonthsAvailable).prop("disabled", true);
            $(self.txtMonthsAvailable).val('');
        }
    });
    $(this.btnSave).unbind();
        $(this.planForm).submit(event => {
            event.preventDefault();
            this.ClearError();
            this.Add(this);
        });
    
}

PlanHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#code-modal-title').text('Actualizar Codigo');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    console.log(data);
                    $(this.txtId).val(data.id);
                    $(this.txtCosto).val(data.price);
                    $(this.txtDescripcion).val(data.description);
                    $(this.txtCertificados).val(data.availableCertificates);
                    $(this.txtMonthsAvailable).val(data.monthsAvailable);
                    $(this.SelectTipoPlan).val(data.idTipoPlan);
                    $(this.SelectTipoConsulta).val(data.idConsulta);
                    $(this.SelectSpecialPrice).val(data.specialPrice.toString());
                    $(this.SelectOpcionExpiracion).val(data.monthsAvailable ? "1" : "0");
                    $(this.SelectOpcionExpiracion).change();
                    this.ClearError();
                    $(this.formPlanModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const code = $(element).parent().parent().find('td').get(1).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el Plan <strong>${code}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

PlanHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.price = `$${u.price.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}`;
                u.deleted = u.deleted ? 'Inactivo' : 'Activo';
                u.specialPrice = u.specialPrice ? "Si" : "No";
                return u;
            })
            const datatable = $(this.tblPlans).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

PlanHandler.prototype.SetupTable = (objThis) => {
    // Configure datatables
    $(self.tblPlans).DataTable({
        pageLength: 25,
        order: [[0, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "consulta" },
            { data: "tipoPlan" },
            { data: "description" },
            { data: "price" },
            { data: "specialPrice" },
            { data: "availableCertificates" },
            { data: "monthsAvailable" },
            { data: "deleted" },
            { data: "action" }
        ],
        drawCallback: function (settings) {
            objThis.TableEvents();
        }
        
    });
}
PlanHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Plan eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
PlanHandler.prototype.Add = (params) => {

    const
        Price = $(params.txtCosto).val() || 0,
        Description = $(params.txtDescripcion).val(),
        AvailableCertificates = $(params.txtCertificados).val() || null;
        MonthsAvailable = $(params.txtMonthsAvailable).val() || null;
        IdTipoPlan = $(params.SelectTipoPlan).val();
        IdConsulta = $(params.SelectTipoConsulta).val();
        SpecialPrice = $(params.SelectSpecialPrice).val() === 'true';
    const code = {
        Price,
        Description,
        AvailableCertificates,
        MonthsAvailable,
        IdTipoPlan,
        IdConsulta,
        SpecialPrice
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Plan ${id ? 'actualizado' : 'creado'} correctamente`,

    };
    const args = {
        url: params.Urls.Root(),
        data: code,
        done: (data) => {
            $(this.formPlanModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.Get();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id != 0)  {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

PlanHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtCosto).val('');
    $(this.txtDescripcion).val('');
    $(this.txtCertificados).val('');
    $(this.txtMonthsAvailable).val('');
    $(this.SelectTipoPlan).val('');
    $(this.SelectTipoConsulta).val('');
    $(this.SelectSpecialPrice).val('');
    $(this.SelectOpcionExpiracion).val("0");
    $(this.SelectOpcionExpiracion).change();
}

PlanHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.coderErrors).append(errorHTML);
    }
}
PlanHandler.prototype.ClearError = function () {
    $(this.coderErrors).empty();
}
PlanHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}