﻿function TipoConsultaHandler(params) {
    this.btnNuevoCodigo = params.btnNuevoCodigo;
    this.formTipoConsultaModal = params.formTipoConsultaModal;
    this.tblTipoConsulta = params.tblTipoConsulta;
    this.TipoConsultaForm = params.TipoConsultaForm;
    this.btnSave = params.btnSave;
    this.txtTipoConsulta = params.txtTipoConsulta;
    this.ShowPropValueSelect = params.ShowPropValueSelect;
    this.ShowMinPropValueSelect = params.ShowMinPropValueSelect;
    this.ShowMaxPropValueSelect = params.ShowMaxPropValueSelect;
    this.ShowRentValueSelect = params.ShowRentValueSelect;
    this.ShowCatValueSelect = params.ShowCatValueSelect;
    this.ShowEscValueSelect = params.ShowEscValueSelect;
    this.ShowGraphsSelect = params.ShowGraphsSelect;
    this.txtId = params.txtId;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.TipoConsultaErrors = params.TipoConsultaErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Plans/TipoConsulta/${id}`,
        Root: () => `${apiUrl}/Plans/TipoConsulta`
    };
}
TipoConsultaHandler.prototype.Initialize = function () {
    this.SetupTable(this);
    this.RegisterEvents();
}

TipoConsultaHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.formTipoConsultaModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoCodigo).click(() => {
        $('#TipoConsulta-modal-title').text('Nuevo Tipo de consulta');
        $(this.formTipoConsultaModal).find('.status').hide();
        $(this.formTipoConsultaModal).modal('show');
    });
    $(this.btnSave).unbind();
        $(this.TipoConsultaForm).submit(event => {
            event.preventDefault();
            this.ClearError();
            this.Add(this);
        });
    
}

TipoConsultaHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#TipoConsulta-modal-title').text('Actualizar Tipo de Consulta');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                   
                    $(this.txtId).val(data.id);
                    $(this.ShowMaxPropValueSelect).val(data.showMaxPropValue.toString());
                    $(this.txtTipoConsulta).val(data.description);
                    $(this.ShowPropValueSelect).val(data.showPropValue.toString());
                    $(this.ShowMinPropValueSelect).val(data.showMinPropValue.toString());
                    $(this.ShowRentValueSelect).val(data.showRentValue.toString());
                    $(this.ShowCatValueSelect).val(data.showCatValue.toString());
                    $(this.ShowEscValueSelect).val(data.showEscValue.toString());
                    $(this.ShowGraphsSelect).val(data.showGraphs.toString());

                    this.ClearError();
                    $(this.formTipoConsultaModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const TipoConsulta = $(element).parent().parent().find('td').get(1).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el tipo de consulta <strong>${TipoConsulta}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

TipoConsultaHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.deleted = u.deleted ? 'Inactivo' : 'Activo';
                u.ShowPropValue = u.showPropValue ? "Si" : "No";
                u.ShowMinPropValue = u.showMinPropValue ? "Si" : "No";
                u.ShowMaxPropValue = u.showMaxPropValue ? "Si" : "No";
                u.ShowRentValue = u.showRentValue ? "Si" : "No";
                u.ShowCatValue = u.showCatValue ? "Si" : "No";
                u.ShowEscValue = u.showEscValue ? "Si" : "No";
                u.ShowGraphs = u.showGraphs ? "Si" : "No";
                return u;
            });
            const datatable = $(this.tblTipoConsulta).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
    
}


TipoConsultaHandler.prototype.SetupTable = (objThis) => {
    // Configure datatables
    //$(self.tblTipoConsulta).DataTable();
    $(self.tblTipoConsulta).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "description" },
            { data: "ShowPropValue" },
            { data: "ShowMinPropValue" },
            { data: "ShowMaxPropValue" },
            { data: "ShowRentValue" },
            { data: "ShowCatValue" },
            { data: "ShowEscValue" },
            { data: "ShowGraphs" },
            { data: "deleted" },
            { data: "action" }
        ],
        drawCallback: function (settings) {
            objThis.TableEvents();
        }
    });
}
TipoConsultaHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Tipo de consulta eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
TipoConsultaHandler.prototype.Add = (params) => {

    const ShowMaxPropValue = $(params.ShowMaxPropValueSelect).val() === 'true',
        Description = $(params.txtTipoConsulta).val(),
        ShowPropValue = $(params.ShowPropValueSelect).val() === 'true',
        ShowMinPropValue = $(params.ShowMinPropValueSelect).val() === 'true',
        ShowRentValue = $(params.ShowRentValueSelect).val() === 'true',
        ShowCatValue = $(params.ShowCatValueSelect).val() === 'true',
        ShowEscValue = $(params.ShowEscValueSelect).val() === 'true',
        ShowGraphs = $(params.ShowGraphsSelect).val() === 'true';
    const TipoConsulta = {
        Description: Description.trim(),
        ShowPropValue,
        ShowMaxPropValue,
        ShowMinPropValue,
        ShowRentValue,
        ShowCatValue,
        ShowEscValue,
        ShowGraphs
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Tipo de consulta ${id ? 'actualizado' : 'creado'} correctamente`,

    };
    const args = {
        url: params.Urls.Root(),
        data: TipoConsulta,
        done: (data) => {
            $(this.formTipoConsultaModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.Get();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id != 0)  {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

TipoConsultaHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.ShowMaxPropValueSelect).val('');
    $(this.txtTipoConsulta).val('');
    $(this.ShowPropValueSelect).val('');
    $(this.ShowMinPropValueSelect).val('');
    $(this.ShowRentValueSelect).val('');
    $(this.ShowCatValueSelect).val('');
    $(this.ShowEscValueSelect).val('');
    $(this.ShowGraphsSelect).val('');

}

TipoConsultaHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.TipoConsultaErrors).append(errorHTML);
    }
}
TipoConsultaHandler.prototype.ClearError = function () {
    $(this.TipoConsultaErrors).empty();
}
TipoConsultaHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}