﻿function UserHandler(params) {
    this.btnNuevoUsuarioId = params.btnNuevoUsuarioId;
    this.formUserModal = params.formUserModal;
    this.formCertificadoModal = params.formCertificadoModal;
    this.formAsignarCertificadoModal = params.formAsignarCertificadoModal;
    this.formReagendarPagoModal = params.formReagendarPagoModal;
    this.tblUsuarios = params.tblUsuarios;
    this.userForm = params.userForm;
    this.certificateForm = params.certificateForm;
    this.asignarSolicitudForm = params.asignarSolicitudForm;
    this.reagendarPagoForm = params.reagendarPagoForm;
    this.btnSave = params.btnSave;
    this.txtCorreo = params.txtCorreo;
    this.txtNombre = params.txtNombre;
    this.txtApellido = params.txtApellido;
    this.txtPassword = params.txtPassword;
    this.txtTelefono = params.txtTelefono;
    this.txtEmpresa = params.txtEmpresa;
    this.txtRole = params.txtRole;
    this.txtId = params.txtId;
    this.selectPlan = params.selectPlan;
    this.txtOrderId = params.txtOrderId;
    this.txtTotal = params.txtTotal;
    this.chkPagoPendiente = params.chkPagoPendiente;
    this.txtFechaPago = params.txtFechaPago;
    this.txtIdSolicitud = params.txtIdSolicitud;
    this.txtNuevaFechaPago = params.txtNuevaFechaPago;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.btnAddCertificate = params.btnAddCertificate;
    this.btnSendEmail = params.btnSendEmail;
    this.btnConfirm = params.btnConfirm;
    this.btnAsignarCert = params.btnAsignarCert;
    this.btnPassDefault = params.btnPassDefault;
    this.btnDesbloquear = params.btnDesbloquear;
    this.btnActivarUsuario = params.btnActivarUsuario;
    this.btnReagendarPago = params.btnReagendarPago;
    this.btnPago = params.btnPago;

    this.userErrors = params.userErrors;
    this.userId = 0;
    const { apiUrl } = params;
    const { identityUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Users/${id}`,
        Root: () => `${apiUrl}/Users`,
        Certificate: () => `${apiUrl}/Payments/`,
        Email: (id) => `${identityUrl}/Account/ResendConfirmationEmail/?email=${id}`,
        Activate: (id) => `${apiUrl}/Users/Activate/${id}`,
        Unblock: (id) => `${apiUrl}/Users/Unblock/${id}`,
        Confirm: (id) => `${apiUrl}/Users/Confirm/${id}`,
        AssignCertificate: () => `${apiUrl}/Requests/AssignOwner`,
    };
}
UserHandler.prototype.Initialize = function () {
    this.SetupUsersTable(this);
    this.SetupDatePicker();
    this.RegisterEvents();
}

UserHandler.prototype.RegisterEvents = function () {
    
    $(this.formUserModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });

    $(this.formCertificadoModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });

    $(this.formAsignarCertificadoModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });

    $(this.formReagendarPagoModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });

    $(this.btnNuevoUsuarioId).click(() => {
        $('#user-modal-title').text('Nuevo Usuario');
        $(this.txtCorreo).attr('readonly', false);
        $(this.txtRole).attr('disabled', false);
        $(this.txtRole).val('Selecciona un rol');
        $(this.txtRole).change();
        $(this.formUserModal).modal('show');
    });

    $(this.certificateForm).submit(event => {
        this.ClearError();
        event.preventDefault();
        this.AddCertificate(this);
    });

    $(this.asignarSolicitudForm).submit(event => {
        this.ClearError();
        event.preventDefault();
        this.AssignRequest(this);
    });

    $(this.reagendarPagoForm).submit(event => {
        this.ClearError();
        event.preventDefault();
        this.ReschedulePayment(this);
    });

    $(this.chkPagoPendiente).change(function (e) {
        if (!(document.getElementById("chkPagoPendiente").checked)) {
            document.getElementById("txtFechaPago").value = "";
            document.getElementById("txtFechaPago").disabled = true;
        }
        else {
            document.getElementById("txtFechaPago").disabled = false;
        }
    });

    $(this.btnSave).unbind();

    $(this.userForm).submit(event => {
        this.ClearError();
        event.preventDefault();
        this.AddUser(this);
    });
    
}

UserHandler.prototype.RegisterTableEvents = function() {
    self = this;
    $(this.btnAddCertificate).each((index, element) => {
        $(element).click(e => {
            this.userId = $(element).data('key');
            $(this.formCertificadoModal).modal('show');

        });

    });

    $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#user-modal-title').text('Actualizar Usuario');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    $(this.txtId).val(data.id);
                    $(this.txtPassword).val(data.password);
                    $(this.txtCorreo).val(data.correo);
                    $(this.txtCorreo).attr('readonly', true);
                    $(this.txtNombre).val(data.nombre);
                    $(this.txtApellido).val(data.apellido);
                    $(this.txtTelefono).val(data.phoneNumber);
                    $(this.txtEmpresa).val(data.company);
                    $(this.txtRole).val(data.role);
                    $(this.txtRole).change();
                    $(this.txtRole).attr('disabled', true);
                    this.ClearError();
                    $(this.formUserModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });
    });

    $(this.btnAsignarCert).each((index, element) => {
        $(element).click(e => {
            this.userId = $(element).data('key');
            this.idPagoActivo = $(element).data('idpagoactivo');
            this.userName = $(element).data('user');
            $(this.formAsignarCertificadoModal).modal('show');
        });
    });

    $(this.btnReagendarPago).each((index, element) => {
        $(element).click(e => {
            this.idPayment = $(element).data('idpago');
            this.userId = $(element).data('key');
            $(this.formReagendarPagoModal).modal('show');
        });
    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar al usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.DeleteUser(id);
                    }
                }
            });
        });
    });

    $(this.btnSendEmail).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas reenviar el correo de confirmacion al usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.SendConfirmationEmail(id);
                    }
                }
            });
        });
    });

    $(this.btnPago).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const idpagopendiente = $(element).data('idpago');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas confirmar el pago pendiente del usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.ConfirmPendingPayment(id, idpagopendiente);
                    }
                }
            });
        });
    });

    $(this.btnConfirm).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas confirmar el acceso del usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.ConfirmUserAccess(id);
                    }
                }
            });
        });
    });

    $(this.btnPassDefault).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas reestablecer la contraseña del usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.SetDefaultPassword(id, username);
                    }
                }
            });
        });
    });

    $(this.btnDesbloquear).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas desbloquear el usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.UnlockUser(id);
                    }
                }
            });
        });
    });

    $(this.btnActivarUsuario).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const username = $(element).parent().parent().find('td').get(0).innerText;
            bootbox.confirm({
                message: `Deseas permitir el acceso al usuario <strong>${username}</strong>`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Si',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        self.ActivateUser(id);
                    }
                }
            });
        });
    });
}

UserHandler.prototype.GetUsers = function () {
    this.RemoverListeners();
    
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
                var rows = data.map(u => {
                    u.status = (!u.deleted ? (u.lockDateTime == null ? (u.idPendingPayment == null ? "Activo" : "Pago Pendiente") : "Bloqueado") : "Inactivo");
                    u.action = this.Botonera(u.id, u.idPendingPayment, u.correo, u.deleted, u.role, u.lockDateTime, u.isConfirmed, (u.activePlan == null ? 0 : u.activePlan));
                    u.createdAt = Window.dateService.DisplayFormat(u.registerDate);
                return u;
            })
            const datatable = $(this.tblUsuarios).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.RegisterEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}

UserHandler.prototype.Botonera = function (id, idPayment, correo, deleted, rol, locked, confirm, activePlan) {
    var botones = `<button class="btn btn-primary btn-update" data-key="${id}"><i class="bi bi-pencil-fill"></i></button>`;
    if (deleted) {
        botones += `<button class="btn btn-unblock btn-allow" data-key="${id}" title="Activar Usuario"><i class="bi bi-person-check"></i></button>`;
    }
    else {
        botones += `<button class="btn btn-danger btn-delete" data-key="${id}" title="Borrar usuario"><i class="bi bi-trash-fill"></i></button>`;
        if (rol == 'Cliente') {
            botones += `<button class="btn btn-primary btn-add" data-key="${id}" title="Agregar Certificado"><i class="bi bi-plus-square"></i></button>`;
            if (activePlan > 0) {
                botones += `<button class="btn btn-danger btn-asignar" data-key="${id}" data-idpagoactivo="${activePlan}" data-user="${correo}" title="Descontar Certificado"><i class="bi bi-file-earmark-minus"></i></button>`;
            }
            if (idPayment != null) {
                botones += `<button class="btn btn-primary btn-reagendar" data-key="${id}" data-idpago="${idPayment}" title="Reagendar Pago"><i class="bi bi-calendar-event"></i></button><button class="btn btn-unblock btn-pago" data-key="${id}" data-idpago="${idPayment}" title="Pago Realizado"><i class="bi bi-receipt"></i></button>`;
            }
        }
        if (!confirm) {
            botones += `<button class="btn btn-primary btn-email" data-key="${correo}" title="Reenviar Correo de confirmacion"><i class="bi bi-mailbox"></i></button><button class="btn btn-primary btn-confirm" data-key="${id}" title="Confirmar Usuario"><i class="bi bi-check2-circle"></i></button>`;
        }
        botones += `<button class="btn btn-danger btn-default-pass" data-key="${id}" title="Reiniciar Contraseña"><i class="bi bi-key"></i></button>`;
        if (locked != null) {
            botones += `<button class="btn btn-lock btn-unlock" data-key="${id}" title="Desbloquear Usuario"><i class="bi bi-unlock"></i></button>`;
        }
    }
    return botones;
};

UserHandler.prototype.RemoverListeners = function () {
    $(this.btnSave).unbind();
    $(this.userForm).unbind();
    $(this.certificateForm).unbind();
    $(this.asignarSolicitudForm).unbind();
    $(this.reagendarPagoForm).unbind();
    $(this.btnUpdate).unbind(); 
    $(this.btnDelete).unbind();
    $(this.btnAddCertificate).unbind();
    $(this.btnSendEmail).unbind();
    $(this.btnConfirm).unbind();
    $(this.btnAsignarCert).unbind();
    $(this.btnPassDefault).unbind();
    $(this.btnDesbloquear).unbind();
    $(this.btnActivarUsuario).unbind();
    $(this.btnReagendarPago).unbind();
    $(this.btnPago).unbind();
}

UserHandler.prototype.SetupUsersTable = (objThis) => {
    // Configure datatables
   
    self.usersTable = $(self.tblUsuarios).DataTable({
        pageLength: 25,
        order: [[2, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "userName" },
            { data: "createdAt" },
            { data: "nombre" },
            { data: "apellido" },
            { data: "phoneNumber" },
            { data: "role" },
            { data: "status" },
            { data: "action" }
        ],
        drawCallback: function(settings) {
            objThis.RegisterTableEvents();
        }
    });
}
UserHandler.prototype.DeleteUser = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.GetUsers();
            iziToast.show({ position: 'topRight', title: "Usuario eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
UserHandler.prototype.SendConfirmationEmail = function (id) {
    const args = {
        url: self.Urls.Email(id),
        done: (data) => {
            iziToast.show({ position: 'topRight', title: "Correo Enviado correctamente", color: 'green' });
        }
    };

    Window.dataService.Get(args);
}

UserHandler.prototype.ConfirmPendingPayment = function (id, paymentId) {
    const payment = {
        Id: paymentId,
        FechaPago: null,
    };

    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Pago Pendiente Confirmado correctamente`,
        message: ''
    };

    const args = {
        url: self.Urls.Certificate(),
        data: payment,
        done: (data) => {
            iziToast.show(notificationParams);
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };

    Window.dataService.Put(args);
}

UserHandler.prototype.ConfirmUserAccess = function (id) {
    const args = {
        url: self.Urls.Confirm(id),
        done: (data) => {
            this.GetUsers();
            iziToast.show({ position: 'topRight', title: "Usuario Confirmado correctamente", color: 'green' });
        }
    };
    Window.dataService.Put(args);
}

UserHandler.prototype.SetDefaultPassword = function (id, correo) {
    const user = {
        Id: id,
        Password: '',
        Correo: correo,
        onlyPassword : true,
    };

    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Password Actualizado correctamente`,
        message: ''

    };

    const args = {
        url: self.Urls.ById(id),
        data: user,
        done: (data) => {
            iziToast.show(notificationParams);
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };

    Window.dataService.Put(args);
}

UserHandler.prototype.UnlockUser = function (id) {
    const args = {
        url: self.Urls.Unblock(id),
        done: (data) => {
            this.GetUsers();
            iziToast.show({ position: 'topRight', title: "Usuario Desbloqueado correctamente", color: 'green' });
        }
    };
    Window.dataService.Put(args);
}

UserHandler.prototype.ActivateUser = function (id) {
    const args = {
        url: self.Urls.Activate(id),
        done: (data) => {
            this.GetUsers();
            iziToast.show({ position: 'topRight', title: "Usuario Activado correctamente", color: 'green' });
        }
    };
    Window.dataService.Put(args);
}

UserHandler.prototype.SetupDatePicker = function () {
    $(this.txtFechaPago).datepicker({
        dateFormat: "dd/mm/yy"
    });
    $(this.txtNuevaFechaPago).datepicker({
        dateFormat: "dd/mm/yy"
    });
}

UserHandler.prototype.AddCertificate = (params) => {

    const order = $(params.txtOrderId).val();
    const plan = $(params.selectPlan).val();
    const total = $(params.txtTotal).val();
    const pendiente = $(params.chkPagoPendiente).is(':checked');
    const fechapago = $(params.txtFechaPago).val() == "" ? null : new Date(Window.dateService.SaveFormat($(params.txtFechaPago).val()));
    const fechaactual = new Date();

    let message = "";
    let error = false;

    if (!order) {
        message = message + "Especificar Número de Transacción/ \n";
        error = true;
    }
    if (!plan || plan == "-1") {
        message = message + "Especificar el plan a agregar/ \n";
        error = true;
    }
    if (!total || total<=0) {
        message = message + "Especificar una cantidad mayor a 0/ \n";
        error = true;
    }

    if (pendiente) {
        if (!fechapago) {
            message = message + "Especificar una Fecha de Pago";
            error = true;
        }
        if (fechapago <= fechaactual) {
            message = message + "La Fecha de Pago debe ser superior a la Fecha Actual";
            error = true;
        }
    }

    if (error) {
        const errorNotificationParams = {
            position: 'topRight',
            color: 'red',
            title: `Falta información para certificado`,
            message: message
        };

        iziToast.show(errorNotificationParams);
        return;
    }

    const payment = {
        UserId: params.userId,
        CodeId: null,
        OrderId: order,
        PlanId: plan,
        SubTotal: total ,
        Total: total,
        PagoPendiente: pendiente,
        FechaLimitePago: fechapago,
    };
 
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Certificado Agregado correctamente`,
        message: ''

    };
    const args = {
        url: params.Urls.Certificate(),
        data: payment,
        done: (data) => {
            $(this.formCertificadoModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    Window.dataService.Post(args);
}

UserHandler.prototype.AddUser = (params) => {
    const user = {
        Password: $(params.txtPassword).val(),
        Correo: $(params.txtCorreo).val(),
        Nombre: $(params.txtNombre).val(),
        Apellido: $(params.txtApellido).val(),
        PhoneNumber: $(params.txtTelefono).val(),
        Company: $(params.txtEmpresa).val(),
        Role: $(params.txtRole).val(),
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Usuario ${id ? 'actualizado' : 'creado'} correctamente`,
        message: id ? '' : 'Se ha enviado un correo de confirmacion a ' + user.Correo

    };
    const args = {
        url: params.Urls.Root(),
        data: user,
        done: (data) => {
            $(this.formUserModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.GetUsers();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id) {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

UserHandler.prototype.AssignRequest = (params) => {
    const requestId = $(params.txtIdSolicitud).val();
    const userId = params.userId;
    const idPagoActivo = params.idPagoActivo;
    const usuario = params.userName;

    let message = "";
    let error = false;

    if (!requestId) {
        message = message + "Especificar Número de Certificado/ \n";
        error = true;
    }

    if (error) {
        const errorNotificationParams = {
            position: 'topRight',
            color: 'red',
            title: `Falta información para asignar`,
            message: message
        };

        iziToast.show(errorNotificationParams);
        return;
    }

    const certificate = {
        Id: requestId,
        User: userId,
        ActivePlan: idPagoActivo,
    };

    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Certificado Descontado correctamente`,
        message: `El Certificado <strong>${requestId}</strong> ha sido asignado al usuario <strong>${usuario}</strong> con éxito.`
    };

    const args = {
        url: self.Urls.AssignCertificate(),
        data: certificate,
        done: (data) => {
            iziToast.show(notificationParams);
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };

    Window.dataService.Put(args);
    $(this.formAsignarCertificadoModal).modal('hide');
    params.ClearFields();

}

UserHandler.prototype.ReschedulePayment = (params) => {
    const nuevaFechaPago = $(params.txtNuevaFechaPago).val() == "" ? null : new Date(Window.dateService.SaveFormat($(params.txtNuevaFechaPago).val()));
    const userId = params.userId;
    const idPayment = params.idPayment;
    const fechaactual = new Date();

    let message = "";
    let error = false;

    if (!nuevaFechaPago) {
        message = message + "Especificar la nueva Fecha Compromiso de Pago \n";
        error = true;
    }

    if (nuevaFechaPago <= fechaactual) {
        message = message + "La Fecha de Pago debe ser superior a la Fecha Actual";
        error = true;
    }

    if (error) {
        const errorNotificationParams = {
            position: 'topRight',
            color: 'red',
            title: `Falta información para asignar`,
            message: message
        };

        iziToast.show(errorNotificationParams);
        return;
    }

    const payment = {
        Id: idPayment,
        FechaPago: nuevaFechaPago,
    };

    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Pago Pendiente Confirmado correctamente`,
        message: ''
    };

    const args = {
        url: self.Urls.Certificate(),
        data: payment,
        done: (data) => {
            iziToast.show(notificationParams);
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };

    Window.dataService.Put(args);
    $(this.formReagendarPagoModal).modal('hide');
    params.ClearFields();
}

UserHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtPassword).val('');
    $(this.txtCorreo).val('');
    $(this.txtNombre).val('');
    $(this.txtApellido).val('');
    $(this.txtTelefono).val('');
    $(this.txtEmpresa).val('');
    $(this.txtRole).val('');
    $(this.txtOrderId).val('');
    $(this.txtTotal).val('');
    $(this.selectPlan).val('');
    $(this.txtRole).change();
    //$(this.chkPagoPendiente).checked(false);
    $(this.txtFechaPago).val('');
    $(this.txtIdSolicitud).val('');
    $(this.txtNuevaFechaPago).val('');
}

UserHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.userErrors).append(errorHTML);
    }
}
UserHandler.prototype.ClearError = function () {
    $(this.userErrors).empty();
}
UserHandler.prototype.DisplayErrors2 = function (errors) {
   
    if (errors) {
       
        Object.keys(errors).map(key => {
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
       
    }
}