"use strict";import Chart from"../Core/Chart/Chart.js";import ChartUtilities from"./Utils/ChartUtilities.js";import H from"../Core/Globals.js";var doc=H.doc;import KeyboardNavigationHandler from"./KeyboardNavigationHandler.js";import D from"../Core/DefaultOptions.js";var defaultOptions=D.defaultOptions;import Point from"../Core/Series/Point.js";import Series from"../Core/Series/Series.js";import U from"../Core/Utilities.js";var addEvent=U.addEvent,extend=U.extend,fireEvent=U.fireEvent,merge=U.merge;import AccessibilityComponent from"./AccessibilityComponent.js";import KeyboardNavigation from"./KeyboardNavigation.js";import LegendComponent from"./Components/LegendComponent.js";import MenuComponent from"./Components/MenuComponent.js";import SeriesComponent from"./Components/SeriesComponent/SeriesComponent.js";import ZoomComponent from"./Components/ZoomComponent.js";import RangeSelectorComponent from"./Components/RangeSelectorComponent.js";import InfoRegionsComponent from"./Components/InfoRegionsComponent.js";import ContainerComponent from"./Components/ContainerComponent.js";import whcm from"./HighContrastMode.js";import highContrastTheme from"./HighContrastTheme.js";import defaultOptionsA11Y from"./Options/Options.js";import defaultLangOptions from"./Options/LangOptions.js";import copyDeprecatedOptions from"./Options/DeprecatedOptions.js";import HTMLUtilities from"./Utils/HTMLUtilities.js";import"./A11yI18n.js";import"./FocusBorder.js";function Accessibility(t){this.init(t)}merge(!0,defaultOptions,defaultOptionsA11Y,{accessibility:{highContrastTheme:highContrastTheme},lang:defaultLangOptions}),H.A11yChartUtilities=ChartUtilities,H.A11yHTMLUtilities=HTMLUtilities,H.KeyboardNavigationHandler=KeyboardNavigationHandler,H.AccessibilityComponent=AccessibilityComponent,Accessibility.prototype={init:function(t){this.chart=t,doc.addEventListener&&t.renderer.isSVG?(copyDeprecatedOptions(t),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(t,this.components),this.update()):t.renderTo.setAttribute("aria-hidden",!0)},initComponents:function(){var e=this.chart,t=e.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},t.customComponents&&extend(this.components,t.customComponents);var i=this.components;this.getComponentOrder().forEach(function(t){i[t].initBase(e),i[t].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var t=Object.keys(this.components).filter(function(t){return"series"!==t});return["series"].concat(t)},update:function(){var e=this.components,i=this.chart,t=i.options.accessibility;fireEvent(i,"beforeA11yUpdate"),i.types=this.getChartTypes(),this.getComponentOrder().forEach(function(t){e[t].onChartUpdate(),fireEvent(i,"afterA11yComponentUpdate",{name:t,component:e[t]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!i.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(i),fireEvent(i,"afterA11yUpdate",{accessibility:this})},destroy:function(){var t=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),t.renderTo&&t.renderTo.setAttribute("aria-hidden",!0),t.focusElement&&t.focusElement.removeFocusBorder()},getChartTypes:function(){var e={};return this.chart.series.forEach(function(t){e[t.type]=1}),Object.keys(e)}},Chart.prototype.updateA11yEnabled=function(){var t=this.accessibility,e=this.options.accessibility;e&&e.enabled?t?t.update():this.accessibility=t=new Accessibility(this):t?(t.destroy&&t.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)},addEvent(Chart,"render",function(t){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var e=this.accessibility;e&&e.getComponentOrder().forEach(function(t){e.components[t].onChartRender()})}),addEvent(Chart,"update",function(t){t=t.options.accessibility;t&&(t.customComponents&&(this.options.accessibility.customComponents=t.customComponents,delete t.customComponents),merge(!0,this.options.accessibility,t),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0}),addEvent(Point,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}),["addSeries","init"].forEach(function(t){addEvent(Chart,t,function(){this.a11yDirty=!0})}),["update","updatedData","remove"].forEach(function(t){addEvent(Series,t,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})}),["afterDrilldown","drillupall"].forEach(function(t){addEvent(Chart,t,function(){this.accessibility&&this.accessibility.update()})}),addEvent(Chart,"destroy",function(){this.accessibility&&this.accessibility.destroy()});