"use strict";import AnnotationsA11y from"../AnnotationsA11y.js";var getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts;import ChartUtilities from"../../Utils/ChartUtilities.js";var getAxisDescription=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT;import F from"../../../Core/FormatUtilities.js";var format=F.format,numberFormat=F.numberFormat;import HTMLUtilities from"../../Utils/HTMLUtilities.js";var reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString;import Tooltip from"../../../Core/Tooltip.js";import U from"../../../Core/Utilities.js";var find=U.find,isNumber=U.isNumber,pick=U.pick,defined=U.defined;function findFirstPointWithGraphic(i){var e=i.index;return i.series&&i.series.data&&defined(e)&&find(i.series.data,function(i){return!!(i&&void 0!==i.index&&i.index>e&&i.graphic&&i.graphic.element)})||null}function shouldAddDummyPoint(i){var e=i.series&&i.series.is("sunburst");return i.isNull&&!e}function makeDummyElement(i,e){e=i.series.chart.renderer.rect(e.x,e.y,1,1);return e.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),e}function addDummyPointElement(i){var e=i.series,t=findFirstPointWithGraphic(i),r=t&&t.graphic,e=r?r.parentGroup:e.graph||e.group,t=makeDummyElement(i,t?{x:pick(i.plotX,t.plotX,0),y:pick(i.plotY,t.plotY,0)}:{x:pick(i.plotX,0),y:pick(i.plotY,0)});if(e&&e.element)return i.graphic=t,i.hasDummyGraphic=!0,t.add(e),e.element.insertBefore(t.element,r?r.element:null),t.element}function hasMorePointsThanDescriptionThreshold(i){var e=i.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==e&&i.points&&i.points.length>=e)}function shouldSetScreenReaderPropsOnPoints(i){var e=i.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(i)&&!e.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(i){var e=i.chart.options.accessibility.keyboardNavigation.seriesNavigation;return!(!i.points||!(i.points.length<e.pointNavigationEnabledThreshold||!1===e.pointNavigationEnabledThreshold))}function shouldDescribeSeriesElement(i){var e=i.chart,t=e.options.chart,r=t.options3d&&t.options3d.enabled,s=1<e.series.length,t=e.options.accessibility.series.describeSingleSeries,e=(i.options.accessibility||{}).exposeAsGroupOnly;return!(r&&s)&&(s||t||e||hasMorePointsThanDescriptionThreshold(i))}function pointNumberToString(i,e){var t=i.series.chart,r=t.options.accessibility.point||{},i=i.series.tooltipOptions||{},t=t.options.lang;return isNumber(e)?numberFormat(e,r.valueDecimals||i.valueDecimals||-1,t.decimalPoint,t.accessibility.thousandsSep||t.thousandsSep):e}function getSeriesDescriptionText(i){var e=(i.options.accessibility||{}).description;return e&&i.chart.langFormat("accessibility.series.description",{description:e,series:i})||""}function getSeriesAxisDescriptionText(i,e){var t=i[e];return i.chart.langFormat("accessibility.series."+e+"Description",{name:getAxisDescription(t),series:i})}function getPointA11yTimeDescription(i){var e=i.series,t=e.chart,r=t.options.accessibility.point||{};if(e.xAxis&&e.xAxis.dateTime){e=Tooltip.prototype.getXDateFormat.call({getDateFormat:Tooltip.prototype.getDateFormat,chart:t},i,t.options.tooltip,e.xAxis),e=r.dateFormatter&&r.dateFormatter(i)||r.dateFormat||e;return t.time.dateFormat(e,i.x,void 0)}}function getPointXDescription(i){var e=getPointA11yTimeDescription(i),t=(i.series.xAxis||{}).categories&&defined(i.category)&&(""+i.category).replace("<br/>"," "),r=i.id&&i.id.indexOf("highcharts-")<0,s="x, "+i.x;return i.name||e||t||(r?i.id:s)}function getPointArrayMapValueDescription(t,i,e){var r=i||"",s=e||"";return t.series.pointArrayMap.reduce(function(i,e){return i+(i.length?", ":"")+(e=pointNumberToString(t,pick(t[i=e],t.options[i])),i+": "+r+e+s)},"")}function getPointValue(i){var e=i.series,t=e.chart.options.accessibility.point||{},r=e.tooltipOptions||{},s=t.valuePrefix||r.valuePrefix||"",t=t.valueSuffix||r.valueSuffix||"",r=pointNumberToString(i,i[void 0!==i.value?"value":"y"]);return i.isNull?e.chart.langFormat("accessibility.series.nullPointValue",{point:i}):e.pointArrayMap?getPointArrayMapValueDescription(i,s,t):s+r+t}function getPointAnnotationDescription(i){var e=i.series.chart,t=getPointAnnotationTexts(i);return t.length?e.langFormat("accessibility.series.pointAnnotationsDescription",{point:i,annotations:t}):""}function getPointValueDescription(i){var e=i.series,t=e.chart,r=t.options.accessibility.point.valueDescriptionFormat,s=pick(e.xAxis&&e.xAxis.options.accessibility&&e.xAxis.options.accessibility.enabled,!t.angular),e=s?getPointXDescription(i):"",s={point:i,index:defined(i.index)?i.index+1:"",xDescription:e,value:getPointValue(i),separator:s?", ":""};return format(r,s,t)}function defaultPointDescriptionFormatter(i){var e=i.series,t=e.chart,r=getPointValueDescription(i),s=i.options&&i.options.accessibility&&i.options.accessibility.description,s=s?" "+s:"",t=1<t.series.length&&e.name?" "+e.name+".":"",e=getPointAnnotationDescription(i),e=e?" "+e:"";return i.accessibility=i.accessibility||{},(i.accessibility.valueDescription=r)+s+t+e}function setPointScreenReaderAttribs(i,e){var t=i.series,r=t.chart.options.accessibility.point||{},t=t.options.accessibility||{},i=stripHTMLTags(t.pointDescriptionFormatter&&t.pointDescriptionFormatter(i)||r.descriptionFormatter&&r.descriptionFormatter(i)||defaultPointDescriptionFormatter(i));e.setAttribute("role","img"),e.setAttribute("aria-label",i)}function describePointsInSeries(i){var r=shouldSetScreenReaderPropsOnPoints(i),e=shouldSetKeyboardNavPropsOnPoints(i);(r||e)&&i.points.forEach(function(i){var e=i.graphic&&i.graphic.element||shouldAddDummyPoint(i)&&addDummyPointElement(i),t=i.options&&i.options.accessibility&&!1===i.options.accessibility.enabled;e&&(e.setAttribute("tabindex","-1"),e.style.outline="0",r&&!t?setPointScreenReaderAttribs(i,e):e.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter(e){function i(i){return t[i]&&1<t[i].length&&e[i]}var t=e.chart,r=t.types||[],s=getSeriesDescriptionText(e),n=getSeriesAxisDescriptionText(e,"xAxis"),o=getSeriesAxisDescriptionText(e,"yAxis"),a={name:e.name||"",ix:e.index+1,numSeries:t.series&&t.series.length,numPoints:e.points&&e.points.length,series:e},r=1<r.length?"Combination":"";return(t.langFormat("accessibility.series.summary."+e.type+r,a)||t.langFormat("accessibility.series.summary.default"+r,a))+(s?" "+s:"")+(i("yAxis")?" "+o:"")+(i("xAxis")?" "+n:"")}function describeSeriesElement(i,e){var t=i.options.accessibility||{},r=i.chart.options.accessibility,s=r.landmarkVerbosity;t.exposeAsGroupOnly?e.setAttribute("role","img"):"all"===s&&e.setAttribute("role","region"),e.setAttribute("tabindex","-1"),e.style.outline="0",e.setAttribute("aria-label",stripHTMLTags(r.series.descriptionFormatter&&r.series.descriptionFormatter(i)||defaultSeriesDescriptionFormatter(i)))}function describeSeries(i){var e=i.chart,t=getSeriesFirstPointElement(i),r=getSeriesA11yElement(i),s=e.is3d&&e.is3d();r&&(r.lastChild!==t||s||reverseChildNodes(r),describePointsInSeries(i),unhideChartElementFromAT(e,r),shouldDescribeSeriesElement(i)?describeSeriesElement(i,r):r.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter,getPointA11yTimeDescription:getPointA11yTimeDescription,getPointXDescription:getPointXDescription,getPointValue:getPointValue,getPointValueDescription:getPointValueDescription};export default SeriesDescriber;