"use strict";import HTMLUtilities from"./HTMLUtilities.js";var stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString;import U from"../../Core/Utilities.js";var defined=U.defined,find=U.find,fireEvent=U.fireEvent;function getChartTitle(e){return stripHTMLTags(e.options.title.text||e.langFormat("accessibility.defaultChartTitle",{chart:e}))}function getAxisDescription(e){return e&&(e.userOptions&&e.userOptions.accessibility&&e.userOptions.accessibility.description||e.axisTitle&&e.axisTitle.textStr||e.options.id||e.categories&&"categories"||e.dateTime&&"Time"||"values")}function getAxisRangeDescription(e){var t=e.options||{};return t.accessibility&&void 0!==t.accessibility.rangeDescription?t.accessibility.rangeDescription:(e.categories?getCategoryAxisRangeDesc:!e.dateTime||0!==e.min&&0!==e.dataMin?getAxisFromToDescription:getAxisTimeLengthDesc)(e)}function getCategoryAxisRangeDesc(e){var t=e.chart;return e.dataMax&&e.dataMin?t.langFormat("accessibility.axis.rangeCategories",{chart:t,axis:e,numCategories:e.dataMax-e.dataMin+1}):""}function getAxisTimeLengthDesc(e){var t=e.chart,i={},r="Seconds";i.Seconds=((e.max||0)-(e.min||0))/1e3,i.Minutes=i.Seconds/60,i.Hours=i.Minutes/60,i.Days=i.Hours/24,["Minutes","Hours","Days"].forEach(function(e){2<i[e]&&(r=e)});var n=i[r].toFixed("Seconds"!==r&&"Minutes"!==r?1:0);return t.langFormat("accessibility.axis.timeRange"+r,{chart:t,axis:e,range:n.replace(".0","")})}function getAxisFromToDescription(t){function e(e){return t.dateTime?i.time.dateFormat(r,t[e]):t[e]}var i=t.chart,r=i.options&&i.options.accessibility&&i.options.accessibility.screenReaderSection.axisRangeDateFormat||"";return i.langFormat("accessibility.axis.rangeFromTo",{chart:i,axis:t,rangeFrom:e("min"),rangeTo:e("max")})}function getSeriesFirstPointElement(e){if(e.points&&e.points.length){e=find(e.points,function(e){return!!e.graphic});return e&&e.graphic&&e.graphic.element}}function getSeriesA11yElement(e){var t=getSeriesFirstPointElement(e);return t&&t.parentNode||e.graph&&e.graph.element||e.group&&e.group.element}function unhideChartElementFromAT(e,t){t.setAttribute("aria-hidden",!1),t!==e.renderTo&&t.parentNode&&(Array.prototype.forEach.call(t.parentNode.childNodes,function(e){e.hasAttribute("aria-hidden")||e.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT(e,t.parentNode))}function hideSeriesFromAT(e){e=getSeriesA11yElement(e);e&&e.setAttribute("aria-hidden",!0)}function getSeriesFromName(e,t){return t?(e.series||[]).filter(function(e){return e.name===t}):e.series}function getPointFromXY(e,t,i){for(var r,n=e.length;n--;)if(r=find(e[n].points||[],function(e){return e.x===t&&e.y===i}))return r}function getRelativePointAxisPosition(e,t){if(!defined(e.dataMin)||!defined(e.dataMax))return 0;var i=e.toPixels(e.dataMin),r=e.toPixels(e.dataMax),n="xAxis"===e.coll?"x":"y";return(e.toPixels(t[n]||0)-i)/(r-i)}function scrollToPoint(e){var t=e.series.xAxis,i=e.series.yAxis,r=t&&t.scrollbar?t:i,t=r&&r.scrollbar;t&&defined(t.to)&&defined(t.from)&&(i=t.to-t.from,e=getRelativePointAxisPosition(r,e),t.updatePosition(e-i/2,e+i/2),fireEvent(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:null}))}var ChartUtilities={getChartTitle:getChartTitle,getAxisDescription:getAxisDescription,getAxisRangeDescription:getAxisRangeDescription,getPointFromXY:getPointFromXY,getSeriesFirstPointElement:getSeriesFirstPointElement,getSeriesFromName:getSeriesFromName,getSeriesA11yElement:getSeriesA11yElement,unhideChartElementFromAT:unhideChartElementFromAT,hideSeriesFromAT:hideSeriesFromAT,scrollToPoint:scrollToPoint};export default ChartUtilities;