"use strict";import A from"../Animation/AnimationUtilities.js";import Color from"../Color/Color.js";import Palette from"../Color/Palette.js";import D from"../DefaultOptions.js";import F from"../Foundation.js";import H from"../Globals.js";import U from"../Utilities.js";import AxisDefaults from"./AxisDefaults.js";import Tick from"./Tick.js";var animObject=A.animObject,registerEventOptions=F.registerEventOptions,deg2rad=H.deg2rad,defaultOptions=D.defaultOptions,arrayMax=U.arrayMax,arrayMin=U.arrayMin,clamp=U.clamp,correctFloat=U.correctFloat,defined=U.defined,destroyObjectProperties=U.destroyObjectProperties,erase=U.erase,error=U.error,extend=U.extend,fireEvent=U.fireEvent,getMagnitude=U.getMagnitude,isArray=U.isArray,isNumber=U.isNumber,isString=U.isString,merge=U.merge,normalizeTickInterval=U.normalizeTickInterval,objectEach=U.objectEach,pick=U.pick,relativeLength=U.relativeLength,removeEvent=U.removeEvent,splat=U.splat,syncTimeout=U.syncTimeout,Axis=function(){function t(t,i){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(t,i)}return t.prototype.init=function(t,i){var e=i.isX,s=this;s.chart=t,s.horiz=t.inverted&&!s.isZAxis?!e:e,s.isXAxis=e,s.coll=s.coll||(e?"xAxis":"yAxis"),fireEvent(this,"init",{userOptions:i}),s.opposite=pick(i.opposite,s.opposite),s.side=pick(i.side,s.side,s.horiz?s.opposite?0:2:s.opposite?1:3),s.setOptions(i);var n=this.options,a=n.labels,o=n.type;s.userOptions=i,s.minPixelPadding=0,s.reversed=pick(n.reversed,s.reversed),s.visible=n.visible,s.zoomEnabled=n.zoomEnabled,s.hasNames="category"===o||!0===n.categories,s.categories=n.categories||s.hasNames,s.names||(s.names=[],s.names.keys={}),s.plotLinesAndBandsGroups={},s.positiveValuesOnly=!!s.logarithmic,s.isLinked=defined(n.linkedTo),s.ticks={},s.labelEdge=[],s.minorTicks={},s.plotLinesAndBands=[],s.alternateBands={},s.len=0,s.minRange=s.userMinRange=n.minRange||n.maxZoom,s.range=n.range,s.offset=n.offset||0,s.max=null,s.min=null;o=pick(n.crosshair,splat(t.options.tooltip.crosshairs)[e?0:1]);s.crosshair=!0===o?{}:o,-1===t.axes.indexOf(s)&&(e?t.axes.splice(t.xAxis.length,0,s):t.axes.push(s),t[s.coll].push(s)),s.series=s.series||[],t.inverted&&!s.isZAxis&&e&&void 0===s.reversed&&(s.reversed=!0),s.labelRotation=isNumber(a.rotation)?a.rotation:void 0,registerEventOptions(s,n),fireEvent(this,"afterInit")},t.prototype.setOptions=function(t){this.options=merge(AxisDefaults.defaultXAxisOptions,"yAxis"===this.coll&&AxisDefaults.defaultYAxisOptions,[AxisDefaults.defaultTopAxisOptions,AxisDefaults.defaultRightAxisOptions,AxisDefaults.defaultBottomAxisOptions,AxisDefaults.defaultLeftAxisOptions][this.side],merge(defaultOptions[this.coll],t)),fireEvent(this,"afterSetOptions",{userOptions:t})},t.prototype.defaultLabelFormatter=function(t){var i,e,s=this.axis,n=this.chart.numberFormatter,a=isNumber(this.value)?this.value:NaN,o=s.chart.time,r=s.categories,h=this.dateTimeLabelFormat,l=defaultOptions.lang,c=l.numericSymbols,d=l.numericSymbolMagnitude||1e3,m=s.logarithmic?Math.abs(a):s.tickInterval,p=c&&c.length;if(r)e=""+this.value;else if(h)e=o.dateFormat(h,a);else if(p&&1e3<=m)for(;p--&&void 0===e;)(i=Math.pow(d,p+1))<=m&&10*a%i==0&&null!==c[p]&&0!==a&&(e=n(a/i,-1)+c[p]);return e=void 0===e?1e4<=Math.abs(a)?n(a,-1):n(a,-1,void 0,""):e},t.prototype.getSeriesExtremes=function(){var o,r=this,h=r.chart;fireEvent(this,"getSeriesExtremes",null,function(){r.hasVisibleSeries=!1,r.dataMin=r.dataMax=r.threshold=null,r.softThreshold=!r.isXAxis,r.stacking&&r.stacking.buildStacks(),r.series.forEach(function(t){var i,e,s,n,a;!t.visible&&h.options.chart.ignoreHiddenSeries||(e=(i=t.options).threshold,r.hasVisibleSeries=!(a=n=s=void 0),r.positiveValuesOnly&&e<=0&&(e=null),r.isXAxis?(s=t.xData).length&&(s=r.logarithmic?s.filter(r.validatePositiveValue):s,n=(o=t.getXExtremes(s)).min,a=o.max,isNumber(n)||n instanceof Date||(s=s.filter(isNumber),n=(o=t.getXExtremes(s)).min,a=o.max),s.length&&(r.dataMin=Math.min(pick(r.dataMin,n),n),r.dataMax=Math.max(pick(r.dataMax,a),a))):(t=t.applyExtremes(),isNumber(t.dataMin)&&(n=t.dataMin,r.dataMin=Math.min(pick(r.dataMin,n),n)),isNumber(t.dataMax)&&(a=t.dataMax,r.dataMax=Math.max(pick(r.dataMax,a),a)),defined(e)&&(r.threshold=e),i.softThreshold&&!r.positiveValuesOnly||(r.softThreshold=!1)))})}),fireEvent(this,"afterGetSeriesExtremes")},t.prototype.translate=function(t,i,e,s,n,a){var o=this.linkedParent||this,r=(s&&o.old?o.old:o).min,h=o.minPixelPadding,l=(o.isOrdinal||o.brokenAxis&&o.brokenAxis.hasBreaks||o.logarithmic&&n)&&o.lin2val,c=1,d=0,n=0,s=(s=(s&&o.old?o.old:o).transA)||o.transA;return e&&(c*=-1,d=o.len),o.reversed&&(d-=(c*=-1)*(o.sector||o.len)),i?(t=t*c+d,n=(t-=h)/s+r,l&&(n=o.lin2val(n))):(l&&(t=o.val2lin(t)),n=isNumber(r)?c*(t-r)*s+d+c*h+(isNumber(a)?s*a:0):void 0),n},t.prototype.toPixels=function(t,i){return this.translate(t,!1,!this.horiz,null,!0)+(i?0:this.pos)},t.prototype.toValue=function(t,i){return this.translate(t-(i?0:this.pos),!0,!this.horiz,null,!0)},t.prototype.getPlotLinePath=function(t){var i,e,s,n,a,o=this,r=o.chart,h=o.left,l=o.top,c=t.old,d=t.value,m=t.lineWidth,p=c&&r.oldChartHeight||r.chartHeight,f=c&&r.oldChartWidth||r.chartWidth,u=o.transB,g=t.translatedValue,x=t.force;function v(t,i,e){return("pass"!==x&&t<i||e<t)&&(x?t=clamp(t,i,e):a=!0),t}t={value:d,lineWidth:m,old:c,force:x,acrossPanes:t.acrossPanes,translatedValue:g};return fireEvent(this,"getPlotLinePath",t,function(t){g=pick(g,o.translate(d,null,null,c)),g=clamp(g,-1e5,1e5),i=s=Math.round(g+u),e=n=Math.round(p-g-u),isNumber(g)?o.horiz?(e=l,n=p-o.bottom,i=s=v(i,h,h+o.width)):(i=h,s=f-o.right,e=n=v(e,l,l+o.height)):x=!(a=!0),t.path=a&&!x?null:r.renderer.crispLine([["M",i,e],["L",s,n]],m||1)}),t.path},t.prototype.getLinearTickPositions=function(t,i,e){var s,n,a,o=correctFloat(Math.floor(i/t)*t),r=correctFloat(Math.ceil(e/t)*t),h=[];if(correctFloat(o+t)===o&&(a=20),this.single)return[i];for(s=o;s<=r&&(h.push(s),(s=correctFloat(s+t,a))!==n);)n=s;return h},t.prototype.getMinorTickInterval=function(){var t=this.options;return!0===t.minorTicks?pick(t.minorTickInterval,"auto"):!1===t.minorTicks?null:t.minorTickInterval},t.prototype.getMinorTickPositions=function(){var t,i=this,e=i.options,s=i.tickPositions,n=i.minorTickInterval,a=i.pointRangePadding||0,o=i.min-a,r=i.max+a,a=r-o,h=[];if(a&&a/n<i.len/3){var l=i.logarithmic;if(l)this.paddedTicks.forEach(function(t,i,e){i&&h.push.apply(h,l.getLogTickPositions(n,e[i-1],e[i],!0))});else if(i.dateTime&&"auto"===this.getMinorTickInterval())h=h.concat(i.getTimeTicks(i.dateTime.normalizeTimeTickInterval(n),o,r,e.startOfWeek));else for(t=o+(s[0]-o)%n;t<=r&&t!==h[0];t+=n)h.push(t)}return 0!==h.length&&i.trimTicks(h),h},t.prototype.adjustForMinRange=function(){var t,i,e,s,n,a,o,r,h=this,l=h.options,c=h.logarithmic,d=h.min,m=h.max,p=0;h.isXAxis&&void 0===h.minRange&&!c&&(defined(l.min)||defined(l.max)?h.minRange=null:(h.series.forEach(function(t){if(s=t.xData,n=t.xIncrement?1:s.length-1,1<s.length)for(i=n;0<i;i--)e=s[i]-s[i-1],(!p||e<p)&&(p=e)}),h.minRange=Math.min(5*p,h.dataMax-h.dataMin))),m-d<h.minRange&&(t=h.dataMax-h.dataMin>=h.minRange,a=[d-(o=((r=h.minRange)-m+d)/2),pick(l.min,d-o)],t&&(a[2]=h.logarithmic?h.logarithmic.log2lin(h.dataMin):h.dataMin),o=[(d=arrayMax(a))+r,pick(l.max,d+r)],t&&(o[2]=c?c.log2lin(h.dataMax):h.dataMax),(m=arrayMin(o))-d<r&&(a[0]=m-r,a[1]=pick(l.min,m-r),d=arrayMax(a))),h.min=d,h.max=m},t.prototype.getClosest=function(){var s;return this.categories?s=1:this.series.forEach(function(t){var i=t.closestPointRange,e=t.visible||!t.chart.options.chart.ignoreHiddenSeries;!t.noSharedTooltip&&defined(i)&&e&&(s=defined(s)?Math.min(s,i):i)}),s},t.prototype.nameToX=function(t){var i,e=isArray(this.categories),s=e?this.categories:this.names,n=t.options.x;return t.series.requireSorting=!1,-1===(n=!defined(n)?this.options.uniqueNames?e?s.indexOf(t.name):pick(s.keys[t.name],-1):t.series.autoIncrement():n)?e||(i=s.length):i=n,void 0!==i&&(this.names[i]=t.name,this.names.keys[t.name]=i),i},t.prototype.updateNames=function(){var n=this,i=this.names;0<i.length&&(Object.keys(i.keys).forEach(function(t){delete i.keys[t]}),i.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(s){s.xIncrement=null,s.points&&!s.isDirtyData||(n.max=Math.max(n.max,s.xData.length-1),s.processData(),s.generatePoints()),s.data.forEach(function(t,i){var e;t&&t.options&&void 0!==t.name&&void 0!==(e=n.nameToX(t))&&e!==t.x&&(t.x=e,s.xData[i]=e)})}))},t.prototype.setAxisTranslation=function(){var s,t,n=this,i=n.max-n.min,e=n.linkedParent,a=!!n.categories,o=n.isXAxis,r=n.axisPointRange||0,h=0,l=0;n.transA;(o||a||r)&&(s=n.getClosest(),e?(h=e.minPointOffset,l=e.pointRangePadding):n.series.forEach(function(t){var i=a?1:o?pick(t.options.pointRange,s,0):n.axisPointRange||0,e=t.options.pointPlacement;r=Math.max(r,i),n.single&&!a||(t=t.is("xrange")?!o:o,h=Math.max(h,t&&isString(e)?0:i/2),l=Math.max(l,t&&"on"===e?0:i))}),e=n.ordinal&&n.ordinal.slope&&s?n.ordinal.slope/s:1,n.minPointOffset=h*=e,n.pointRangePadding=l*=e,n.pointRange=Math.min(r,n.single&&a?1:i),o&&(n.closestPointRange=s)),n.translationSlope=n.transA=t=n.staticScale||n.len/(i+l||1),n.transB=n.horiz?n.left:n.bottom,n.minPixelPadding=t*h,fireEvent(this,"afterSetAxisTranslation")},t.prototype.minFromRange=function(){return this.max-this.range},t.prototype.setTickInterval=function(t){var i,e,s,n,a,o=this,r=o.chart,h=o.logarithmic,l=o.options,c=o.isXAxis,d=o.isLinked,m=l.tickPixelInterval,p=o.categories,f=o.softThreshold,u=l.maxPadding,g=l.minPadding,x=l.tickInterval,v=isNumber(o.threshold)?o.threshold:null;o.dateTime||p||d||this.getTickAmount(),n=pick(o.userMin,l.min),a=pick(o.userMax,l.max),d?(o.linkedParent=r[o.coll][l.linkedTo],i=o.linkedParent.getExtremes(),o.min=pick(i.min,i.dataMin),o.max=pick(i.max,i.dataMax),l.type!==o.linkedParent.options.type&&error(11,1,r)):(f&&defined(v)&&(o.dataMin>=v?(e=v,g=0):o.dataMax<=v&&(s=v,u=0)),o.min=pick(n,e,o.dataMin),o.max=pick(a,s,o.dataMax)),h&&(o.positiveValuesOnly&&!t&&Math.min(o.min,pick(o.dataMin,o.min))<=0&&error(10,1,r),o.min=correctFloat(h.log2lin(o.min),16),o.max=correctFloat(h.log2lin(o.max),16)),o.range&&defined(o.max)&&(o.userMin=o.min=n=Math.max(o.dataMin,o.minFromRange()),o.userMax=a=o.max,o.range=null),fireEvent(o,"foundExtremes"),o.beforePadding&&o.beforePadding(),o.adjustForMinRange(),p||o.axisPointRange||o.stacking&&o.stacking.usePercentage||d||!defined(o.min)||!defined(o.max)||(h=o.max-o.min)&&(!defined(n)&&g&&(o.min-=h*g),!defined(a)&&u&&(o.max+=h*u)),isNumber(o.userMin)||(isNumber(l.softMin)&&l.softMin<o.min&&(o.min=n=l.softMin),isNumber(l.floor)&&(o.min=Math.max(o.min,l.floor))),isNumber(o.userMax)||(isNumber(l.softMax)&&l.softMax>o.max&&(o.max=a=l.softMax),isNumber(l.ceiling)&&(o.max=Math.min(o.max,l.ceiling))),f&&defined(o.dataMin)&&(v=v||0,!defined(n)&&o.min<v&&o.dataMin>=v?o.min=o.options.minRange?Math.min(v,o.max-o.minRange):v:!defined(a)&&o.max>v&&o.dataMax<=v&&(o.max=o.options.minRange?Math.max(v,o.min+o.minRange):v)),isNumber(o.min)&&isNumber(o.max)&&!this.chart.polar&&o.min>o.max&&(defined(o.options.min)?o.max=o.min:defined(o.options.max)&&(o.min=o.max)),o.min===o.max||void 0===o.min||void 0===o.max?o.tickInterval=1:d&&o.linkedParent&&!x&&m===o.linkedParent.options.tickPixelInterval?o.tickInterval=x=o.linkedParent.tickInterval:o.tickInterval=pick(x,this.tickAmount?(o.max-o.min)/Math.max(this.tickAmount-1,1):void 0,p?1:(o.max-o.min)*m/Math.max(o.len,m)),c&&!t&&o.series.forEach(function(t){t.processData(o.min!==(o.old&&o.old.min)||o.max!==(o.old&&o.old.max))}),o.setAxisTranslation(),fireEvent(this,"initialAxisTranslation"),o.pointRange&&!x&&(o.tickInterval=Math.max(o.pointRange,o.tickInterval));t=pick(l.minTickInterval,o.dateTime&&!o.series.some(function(t){return t.noSharedTooltip})?o.closestPointRange:0);!x&&o.tickInterval<t&&(o.tickInterval=t),o.dateTime||o.logarithmic||x||(o.tickInterval=normalizeTickInterval(o.tickInterval,void 0,getMagnitude(o.tickInterval),pick(l.allowDecimals,o.tickInterval<.5||void 0!==this.tickAmount),!!this.tickAmount)),this.tickAmount||(o.tickInterval=o.unsquish()),this.setTickPositions()},t.prototype.setTickPositions=function(){var t=this,i=this.options,e=i.tickPositions,s=this.getMinorTickInterval(),n=this.hasVerticalPanning(),a="colorAxis"===this.coll,o=(a||!n)&&i.startOnTick,a=(a||!n)&&i.endOnTick,n=i.tickPositioner;this.tickmarkOffset=this.categories&&"between"===i.tickmarkPlacement&&1===this.tickInterval?.5:0,this.minorTickInterval="auto"===s&&this.tickInterval?this.tickInterval/5:s,this.single=this.min===this.max&&defined(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||!1!==i.allowDecimals),this.tickPositions=s=e&&e.slice(),s||(t.ordinal&&t.ordinal.positions||!((this.max-this.min)/this.tickInterval>Math.max(2*this.len,200))?s=t.dateTime?t.getTimeTicks(t.dateTime.normalizeTimeTickInterval(this.tickInterval,i.units),this.min,this.max,i.startOfWeek,t.ordinal&&t.ordinal.positions,this.closestPointRange,!0):t.logarithmic?t.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):this.getLinearTickPositions(this.tickInterval,this.min,this.max):(s=[this.min,this.max],error(19,!1,this.chart)),s.length>this.len&&(s=[s[0],s.pop()])[0]===s[1]&&(s.length=1),this.tickPositions=s,(n=n&&n.apply(t,[this.min,this.max]))&&(this.tickPositions=s=n)),this.paddedTicks=s.slice(0),this.trimTicks(s,o,a),this.isLinked||(this.single&&s.length<2&&!this.categories&&!this.series.some(function(t){return t.is("heatmap")&&"between"===t.options.pointPlacement})&&(this.min-=.5,this.max+=.5),e||n||this.adjustTickAmount()),fireEvent(this,"afterSetTickPositions")},t.prototype.trimTicks=function(t,i,e){var s=t[0],n=t[t.length-1],a=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent(this,"trimTicks"),!this.isLinked){if(i&&s!==-1/0)this.min=s;else for(;this.min-a>t[0];)t.shift();if(e)this.max=n;else for(;this.max+a<t[t.length-1];)t.pop();0===t.length&&defined(s)&&!this.options.tickPositions&&t.push((n+s)/2)}},t.prototype.alignToOthers=function(){var e,s={},t=this.options;return!1!==this.chart.options.chart.alignTicks&&t.alignTicks&&!1!==t.startOnTick&&!1!==t.endOnTick&&!this.logarithmic&&this.chart[this.coll].forEach(function(t){var i=t.options,i=[t.horiz?i.left:i.top,i.width,i.height,i.pane].join(",");t.series.length&&(s[i]?e=!0:s[i]=1)}),e},t.prototype.getTickAmount=function(){var t=this.options,i=t.tickPixelInterval,e=t.tickAmount;(e=!(e=!defined(t.tickInterval)&&!e&&this.len<i&&!this.isRadial&&!this.logarithmic&&t.startOnTick&&t.endOnTick?2:e)&&this.alignToOthers()?Math.ceil(this.len/i)+1:e)<4&&(this.finalTickAmt=e,e=5),this.tickAmount=e},t.prototype.adjustTickAmount=function(){var t,i,e=this,s=e.options,n=e.tickInterval,a=e.tickPositions,o=e.tickAmount,r=e.finalTickAmt,h=a&&a.length,l=pick(e.threshold,e.softThreshold?0:null);if(e.hasData()&&isNumber(e.min)&&isNumber(e.max)){if(h<o){for(;a.length<o;)a.length%2||e.min===l?a.push(correctFloat(a[a.length-1]+n)):a.unshift(correctFloat(a[0]-n));e.transA*=(h-1)/(o-1),e.min=s.startOnTick?a[0]:Math.min(e.min,a[0]),e.max=s.endOnTick?a[a.length-1]:Math.max(e.max,a[a.length-1])}else o<h&&(e.tickInterval*=2,e.setTickPositions());if(defined(r)){for(i=t=a.length;i--;)(3===r&&i%2==1||r<=2&&0<i&&i<t-1)&&a.splice(i,1);e.finalTickAmt=void 0}}},t.prototype.setScale=function(){var t=this,i=!1,e=!1;t.series.forEach(function(t){i=i||t.isDirtyData||t.isDirty,e=e||t.xAxis&&t.xAxis.isDirty||!1}),t.setAxisSize();var s=t.len!==(t.old&&t.old.len);s||i||e||t.isLinked||t.forceRedraw||t.userMin!==(t.old&&t.old.userMin)||t.userMax!==(t.old&&t.old.userMax)||t.alignToOthers()?(t.stacking&&t.stacking.resetStacks(),t.forceRedraw=!1,t.getSeriesExtremes(),t.setTickInterval(),t.isDirty||(t.isDirty=s||t.min!==(t.old&&t.old.min)||t.max!==(t.old&&t.old.max))):t.stacking&&t.stacking.cleanStacks(),i&&t.panningState&&(t.panningState.isDirty=!0),fireEvent(this,"afterSetScale")},t.prototype.setExtremes=function(t,i,e,s,n){var a=this,o=a.chart;e=pick(e,!0),a.series.forEach(function(t){delete t.kdTree}),n=extend(n,{min:t,max:i}),fireEvent(a,"setExtremes",n,function(){a.userMin=t,a.userMax=i,a.eventArgs=n,e&&o.redraw(s)})},t.prototype.zoom=function(t,i){var s=this,n=this.dataMin,a=this.dataMax,e=this.options,o=Math.min(n,pick(e.min,n)),r=Math.max(a,pick(e.max,a)),i={newMin:t,newMax:i};return fireEvent(this,"zoom",i,function(t){var i=t.newMin,e=t.newMax;i===s.min&&e===s.max||(s.allowZoomOutside||(defined(n)&&r<(i=i<o?o:i)&&(i=r),defined(a)&&r<(e=e<o?o:e)&&(e=r)),s.displayBtn=void 0!==i||void 0!==e,s.setExtremes(i,e,!1,void 0,{trigger:"zoom"})),t.zoomed=!0}),i.zoomed},t.prototype.setAxisSize=function(){var t=this.chart,i=this.options,e=i.offsets||[0,0,0,0],s=this.horiz,n=this.width=Math.round(relativeLength(pick(i.width,t.plotWidth-e[3]+e[1]),t.plotWidth)),a=this.height=Math.round(relativeLength(pick(i.height,t.plotHeight-e[0]+e[2]),t.plotHeight)),o=this.top=Math.round(relativeLength(pick(i.top,t.plotTop+e[0]),t.plotHeight,t.plotTop)),e=this.left=Math.round(relativeLength(pick(i.left,t.plotLeft+e[3]),t.plotWidth,t.plotLeft));this.bottom=t.chartHeight-a-o,this.right=t.chartWidth-n-e,this.len=Math.max(s?n:a,0),this.pos=s?e:o},t.prototype.getExtremes=function(){var t=this,i=t.logarithmic;return{min:i?correctFloat(i.lin2log(t.min)):t.min,max:i?correctFloat(i.lin2log(t.max)):t.max,dataMin:t.dataMin,dataMax:t.dataMax,userMin:t.userMin,userMax:t.userMax}},t.prototype.getThreshold=function(t){var i=this,e=i.logarithmic,s=e?e.lin2log(i.min):i.min,e=e?e.lin2log(i.max):i.max;return null===t||t===-1/0?t=s:t===1/0?t=e:t<s?t=s:e<t&&(t=e),i.translate(t,0,1,0,1)},t.prototype.autoLabelAlign=function(t){var i=(pick(t,0)-90*this.side+720)%360,t={align:"center"};return fireEvent(this,"autoLabelAlign",t,function(t){15<i&&i<165?t.align="right":195<i&&i<345&&(t.align="left")}),t.align},t.prototype.tickSize=function(t){var i=this.options,e=pick(i["tick"===t?"tickWidth":"minorTickWidth"],"tick"===t&&this.isXAxis&&!this.categories?1:0),s=i["tick"===t?"tickLength":"minorTickLength"],n={tickSize:n=e&&s?[s="inside"===i[t+"Position"]?-s:s,e]:n};return fireEvent(this,"afterTickSize",n),n.tickSize},t.prototype.labelMetrics=function(){var t=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[t]&&this.ticks[t].label)},t.prototype.unsquish=function(){function e(t){var i=1<(i=t/(r||1))?Math.ceil(i):1;return c<i*o&&t!==1/0&&r!=1/0&&c&&(i=Math.ceil(c/o)),correctFloat(i*o)}var s,n,t,i=this.options.labels,a=this.horiz,o=this.tickInterval,r=this.len/(((this.categories?1:0)+this.max-this.min)/o),h=i.rotation,l=this.labelMetrics(),c=Math.max(this.max-this.min,0),d=o,m=Number.MAX_VALUE;return a?(i.staggerLines||i.step||(isNumber(h)?t=[h]:r<i.autoRotationLimit&&(t=i.autoRotation)),t&&t.forEach(function(t){var i;(t===h||t&&-90<=t&&t<=90)&&(i=(n=e(Math.abs(l.h/Math.sin(deg2rad*t))))+Math.abs(t/360))<m&&(m=i,s=t,d=n)})):i.step||(d=e(l.h)),this.autoRotation=t,this.labelRotation=pick(s,isNumber(h)?h:0),d},t.prototype.getSlotWidth=function(t){var i=this.chart,e=this.horiz,s=this.options.labels,n=Math.max(this.tickPositions.length-(this.categories?0:1),1),a=i.margin[3];if(t&&isNumber(t.slotWidth))return t.slotWidth;if(e&&s.step<2)return s.rotation?0:(this.staggerLines||1)*this.len/n;if(!e){s=s.style.width;if(void 0!==s)return parseInt(String(s),10);if(a)return a-i.spacing[3]}return.33*i.chartWidth},t.prototype.renderUnsquish=function(){var n,a,t,i,e=this.chart,s=e.renderer,o=this.tickPositions,r=this.ticks,h=this.options.labels,l=h.style,c=this.horiz,d=this.getSlotWidth(),m=Math.max(1,Math.round(d-2*h.padding)),p={},f=this.labelMetrics(),u=l.textOverflow,g=0;if(isString(h.rotation)||(p.rotation=h.rotation||0),o.forEach(function(t){t=r[t];t.movedLabel&&t.replaceMovedLabel(),t&&t.label&&t.label.textPxLength>g&&(g=t.label.textPxLength)}),this.maxLabelLength=g,this.autoRotation)m<g&&g>f.h?p.rotation=this.labelRotation:this.labelRotation=0;else if(d&&(n=m,!u))for(a="clip",t=o.length;!c&&t--;)i=o[t],(i=r[i].label)&&(i.styles&&"ellipsis"===i.styles.textOverflow?i.css({textOverflow:"clip"}):i.textPxLength>d&&i.css({width:d+"px"}),i.getBBox().height>this.len/o.length-(f.h-f.f)&&(i.specificTextOverflow="ellipsis"));p.rotation&&(n=g>.5*e.chartHeight?.33*e.chartHeight:g,u||(a="ellipsis")),this.labelAlign=h.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(p.align=this.labelAlign),o.forEach(function(t){var i=r[t],e=i&&i.label,s=l.width,t={};e&&(e.attr(p),i.shortenLabel?i.shortenLabel():n&&!s&&"nowrap"!==l.whiteSpace&&(n<e.textPxLength||"SPAN"===e.element.tagName)?(t.width=n+"px",u||(t.textOverflow=e.specificTextOverflow||a),e.css(t)):e.styles&&e.styles.width&&!t.width&&!s&&e.css({width:null}),delete e.specificTextOverflow,i.rotation=p.rotation)},this),this.tickRotCorr=s.rotCorr(f.b,this.labelRotation||0,0!==this.side)},t.prototype.hasData=function(){return this.series.some(function(t){return t.hasData()})||this.options.showEmpty&&defined(this.min)&&defined(this.max)},t.prototype.addTitle=function(t){var i,e=this,s=e.chart.renderer,n=e.horiz,a=e.opposite,o=e.options.title,r=e.chart.styledMode;e.axisTitle||(i=(i=o.textAlign)||(n?{low:"left",middle:"center",high:"right"}:{low:a?"right":"left",middle:"center",high:a?"left":"right"})[o.align],e.axisTitle=s.text(o.text||"",0,0,o.useHTML).attr({zIndex:7,rotation:o.rotation,align:i}).addClass("highcharts-axis-title"),r||e.axisTitle.css(merge(o.style)),e.axisTitle.add(e.axisGroup),e.axisTitle.isNew=!0),r||o.style.width||e.isRadial||e.axisTitle.css({width:e.len+"px"}),e.axisTitle[t?"show":"hide"](t)},t.prototype.generateTick=function(t){var i=this.ticks;i[t]?i[t].addLabel():i[t]=new Tick(this,t)},t.prototype.getOffset=function(){var t,s=this,i=this,e=i.chart,n=e.renderer,a=i.options,o=i.tickPositions,r=i.ticks,h=i.horiz,l=i.side,c=e.inverted&&!i.isZAxis?[1,0,3,2][l]:l,d=i.hasData(),m=a.title,p=a.labels,f=e.axisOffset,u=e.clipOffset,g=[-1,1,1,-1][l],x=a.className,v=i.axisParent,k=0,M=0,y=0;i.showAxis=t=d||a.showEmpty,i.staggerLines=i.horiz&&p.staggerLines||void 0,i.axisGroup||(i.gridGroup=(e=function(t,i,e){return n.g(t).attr({zIndex:e}).addClass("highcharts-"+s.coll.toLowerCase()+i+" "+(s.isRadial?"highcharts-radial-axis"+i+" ":"")+(x||"")).add(v)})("grid","-grid",a.gridZIndex),i.axisGroup=e("axis","",a.zIndex),i.labelGroup=e("axis-labels","-labels",p.zIndex)),d||i.isLinked?(o.forEach(function(t){i.generateTick(t)}),i.renderUnsquish(),i.reserveSpaceDefault=0===l||2===l||{1:"left",3:"right"}[l]===i.labelAlign,pick(p.reserveSpace,"center"===i.labelAlign||null,i.reserveSpaceDefault)&&o.forEach(function(t){y=Math.max(r[t].getLabelSize(),y)}),i.staggerLines&&(y*=i.staggerLines),i.labelOffset=y*(i.opposite?-1:1)):objectEach(r,function(t,i){t.destroy(),delete r[i]}),m&&m.text&&!1!==m.enabled&&(i.addTitle(t),t&&!1!==m.reserveSpace&&(i.titleOffset=k=i.axisTitle.getBBox()[h?"height":"width"],T=m.offset,M=defined(T)?0:pick(m.margin,h?5:10))),i.renderLine(),i.offset=g*pick(a.offset,f[l]?f[l]+(a.margin||0):0),i.tickRotCorr=i.tickRotCorr||{x:0,y:0},m=0===l?-i.labelMetrics().h:2===l?i.tickRotCorr.y:0,M=Math.abs(y)+M,y&&(M-=m,M+=g*(h?pick(p.y,i.tickRotCorr.y+8*g):p.x)),i.axisTitleMargin=pick(T,M),i.getMaxLabelDimensions&&(i.maxLabelDimensions=i.getMaxLabelDimensions(r,o));var T=this.tickSize("tick");f[l]=Math.max(f[l],(i.axisTitleMargin||0)+k+g*i.offset,M,o&&o.length&&T?T[0]+g*i.offset:0);a=a.offset?0:2*Math.floor(i.axisLine.strokeWidth()/2);u[c]=Math.max(u[c],a),fireEvent(this,"afterGetOffset")},t.prototype.getLinePath=function(t){var i=this.chart,e=this.opposite,s=this.offset,n=this.horiz,a=this.left+(e?this.width:0)+s,s=i.chartHeight-this.bottom-(e?this.height:0)+s;return e&&(t*=-1),i.renderer.crispLine([["M",n?this.left:a,n?s:this.top],["L",n?i.chartWidth-this.right:a,n?s:i.chartHeight-this.bottom]],t)},t.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},t.prototype.getTitlePosition=function(){var t=this.horiz,i=this.left,e=this.top,s=this.len,n=this.options.title,a=t?i:e,o=this.opposite,r=this.offset,h=n.x,l=n.y,c=this.axisTitle,d=this.chart.renderer.fontMetrics(n.style.fontSize,c),c=Math.max(c.getBBox(null,0).height-d.h-1,0),n={low:a+(t?0:s),middle:a+s/2,high:a+(t?s:0)}[n.align],c=(t?e+this.height:i)+(t?1:-1)*(o?-1:1)*this.axisTitleMargin+[-c,c,d.f,-c][this.side],l={x:t?n+h:c+(o?this.width:0)+r+h,y:t?c+l-(o?this.height:0)+r:n+l};return fireEvent(this,"afterGetTitlePosition",{titlePosition:l}),l},t.prototype.renderMinorTick=function(t,i){var e=this.minorTicks;e[t]||(e[t]=new Tick(this,t,"minor")),i&&e[t].isNew&&e[t].render(null,!0),e[t].render(null,!1,1)},t.prototype.renderTick=function(t,i,e){var s=this,n=s.isLinked,a=s.ticks;(!n||t>=s.min&&t<=s.max||s.grid&&s.grid.isColumn)&&(a[t]||(a[t]=new Tick(s,t)),e&&a[t].isNew&&a[t].render(i,!0,-1),a[t].render(i))},t.prototype.render=function(){var e,s,n,a=this,o=a.chart,r=a.logarithmic,t=o.renderer,i=a.options,h=a.isLinked,l=a.tickPositions,c=a.axisTitle,d=a.ticks,m=a.minorTicks,p=a.alternateBands,f=i.stackLabels,u=i.alternateGridColor,g=a.tickmarkOffset,x=a.axisLine,v=a.showAxis,k=animObject(t.globalAnimation);a.labelEdge.length=0,a.overlap=!1,[d,m,p].forEach(function(t){objectEach(t,function(t){t.isActive=!1})}),(a.hasData()||h)&&(n=a.chart.hasRendered&&a.old&&isNumber(a.old.min),a.minorTickInterval&&!a.categories&&a.getMinorTickPositions().forEach(function(t){a.renderMinorTick(t,n)}),l.length&&(l.forEach(function(t,i){a.renderTick(t,i,n)}),g&&(0===a.min||a.single)&&(d[-1]||(d[-1]=new Tick(a,-1,null,!0)),d[-1].render(-1))),u&&l.forEach(function(t,i){s=void 0!==l[i+1]?l[i+1]+g:a.max-g,i%2==0&&t<a.max&&s<=a.max+(o.polar?-g:g)&&(p[t]||(p[t]=new H.PlotLineOrBand(a)),e=t+g,p[t].options={from:r?r.lin2log(e):e,to:r?r.lin2log(s):s,color:u,className:"highcharts-alternate-grid"},p[t].render(),p[t].isActive=!0)}),a._addedPlotLB||(a._addedPlotLB=!0,(i.plotLines||[]).concat(i.plotBands||[]).forEach(function(t){a.addPlotBandOrLine(t)}))),[d,m,p].forEach(function(i){var e=[],t=k.duration;objectEach(i,function(t,i){t.isActive||(t.render(i,!1,0),t.isActive=!1,e.push(i))}),syncTimeout(function(){for(var t=e.length;t--;)i[e[t]]&&!i[e[t]].isActive&&(i[e[t]].destroy(),delete i[e[t]])},i!==p&&o.hasRendered&&t?t:0)}),x&&(x[x.isPlaced?"animate":"attr"]({d:this.getLinePath(x.strokeWidth())}),x.isPlaced=!0,x[v?"show":"hide"](v)),c&&v&&(v=a.getTitlePosition(),isNumber(v.y)?(c[c.isNew?"attr":"animate"](v),c.isNew=!1):(c.attr("y",-9999),c.isNew=!0)),f&&f.enabled&&a.stacking&&a.stacking.renderStackTotals(),a.old={len:a.len,max:a.max,min:a.min,transA:a.transA,userMax:a.userMax,userMin:a.userMin},a.isDirty=!1,fireEvent(this,"afterRender")},t.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(t){t.render()})),this.series.forEach(function(t){t.isDirty=!0})},t.prototype.getKeepProps=function(){return this.keepProps||t.keepProps},t.prototype.destroy=function(t){var i,e=this,s=e.plotLinesAndBands,n=this.eventOptions;if(fireEvent(this,"destroy",{keepEvents:t}),t||removeEvent(e),[e.ticks,e.minorTicks,e.alternateBands].forEach(function(t){destroyObjectProperties(t)}),s)for(var a=s.length;a--;)s[a].destroy();for(i in["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(t){e[t]&&(e[t]=e[t].destroy())}),e.plotLinesAndBandsGroups)e.plotLinesAndBandsGroups[i]=e.plotLinesAndBandsGroups[i].destroy();objectEach(e,function(t,i){-1===e.getKeepProps().indexOf(i)&&delete e[i]}),this.eventOptions=n},t.prototype.drawCrosshair=function(t,i){var e,s,n,a=this.crosshair,o=pick(a&&a.snap,!0),r=this.chart,h=this.cross;if(fireEvent(this,"drawCrosshair",{e:t,point:i}),t=t||this.cross&&this.cross.e,a&&!1!==(defined(i)||!o)){if(o?defined(i)&&(s=pick("colorAxis"!==this.coll?i.crosshairPos:null,this.isXAxis?i.plotX:this.len-i.plotY)):s=t&&(this.horiz?t.chartX-this.pos:this.len-t.chartY+this.pos),defined(s)&&(n={value:i&&(this.isXAxis?i.x:pick(i.stackY,i.y)),translatedValue:s},r.polar&&extend(n,{isCrosshair:!0,chartX:t&&t.chartX,chartY:t&&t.chartY,point:i}),e=this.getPlotLinePath(n)||null),!defined(e))return void this.hideCrosshair();n=this.categories&&!this.isRadial,h||(this.cross=h=r.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(n?"category ":"thin ")+(a.className||"")).attr({zIndex:pick(a.zIndex,2)}).add(),r.styledMode||(h.attr({stroke:a.color||(n?Color.parse(Palette.highlightColor20).setOpacity(.25).get():Palette.neutralColor20),"stroke-width":pick(a.width,1)}).css({"pointer-events":"none"}),a.dashStyle&&h.attr({dashstyle:a.dashStyle}))),h.show().attr({d:e}),n&&!a.width&&h.attr({"stroke-width":this.transA}),this.cross.e=t}else this.hideCrosshair();fireEvent(this,"afterDrawCrosshair",{e:t,point:i})},t.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent(this,"afterHideCrosshair")},t.prototype.hasVerticalPanning=function(){var t=this.chart.options.chart.panning;return Boolean(t&&t.enabled&&/y/.test(t.type))},t.prototype.validatePositiveValue=function(t){return isNumber(t)&&0<t},t.prototype.update=function(t,i){var e=this.chart;t=merge(this.userOptions,t),this.destroy(!0),this.init(e,t),e.isDirtyBox=!0,pick(i,!0)&&e.redraw()},t.prototype.remove=function(t){for(var i=this.chart,e=this.coll,s=this.series,n=s.length;n--;)s[n]&&s[n].remove(!1);erase(i.axes,this),erase(i[e],this),i[e].forEach(function(t,i){t.options.index=t.userOptions.index=i}),this.destroy(),i.isDirtyBox=!0,pick(t,!0)&&i.redraw()},t.prototype.setTitle=function(t,i){this.update({title:t},i)},t.prototype.setCategories=function(t,i){this.update({categories:t},i)},t.defaultOptions=AxisDefaults.defaultXAxisOptions,t.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],t}();export default Axis;