"use strict";import A from"../Animation/AnimationUtilities.js";var animate=A.animate,animObject=A.animObject,setAnimation=A.setAnimation;import Axis from"../Axis/Axis.js";import FormatUtilities from"../FormatUtilities.js";var numberFormat=FormatUtilities.numberFormat;import Foundation from"../Foundation.js";var registerEventOptions=Foundation.registerEventOptions;import H from"../Globals.js";var charts=H.charts,doc=H.doc,marginNames=H.marginNames,win=H.win;import Legend from"../Legend.js";import MSPointer from"../MSPointer.js";import D from"../DefaultOptions.js";var defaultOptions=D.defaultOptions,defaultTime=D.defaultTime;import palette from"../../Core/Color/Palette.js";import Pointer from"../Pointer.js";import RendererRegistry from"../Renderer/RendererRegistry.js";import SeriesRegistry from"../Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import Time from"../Time.js";import U from"../Utilities.js";import AST from"../Renderer/HTML/AST.js";var addEvent=U.addEvent,attr=U.attr,cleanRecursively=U.cleanRecursively,createElement=U.createElement,css=U.css,defined=U.defined,discardElement=U.discardElement,erase=U.erase,error=U.error,extend=U.extend,find=U.find,fireEvent=U.fireEvent,getStyle=U.getStyle,isArray=U.isArray,isFunction=U.isFunction,isNumber=U.isNumber,isObject=U.isObject,isString=U.isString,merge=U.merge,objectEach=U.objectEach,pick=U.pick,pInt=U.pInt,relativeLength=U.relativeLength,removeEvent=U.removeEvent,splat=U.splat,syncTimeout=U.syncTimeout,uniqueKey=U.uniqueKey,Chart=function(){function o(t,e,i){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(t,e,i)}return o.chart=function(t,e,i){return new o(t,e,i)},o.prototype.getArgs=function(t,e,i){isString(t)||t.nodeName?(this.renderTo=t,this.init(e,i)):this.init(t,e)},o.prototype.init=function(i,o){var r=i.plotOptions||{};fireEvent(this,"init",{args:arguments},function(){var t=merge(defaultOptions,i),e=t.chart;objectEach(t.plotOptions,function(t,e){isObject(t)&&(t.tooltip=r[e]&&merge(r[e].tooltip)||void 0)}),t.tooltip.userOptions=i.chart&&i.chart.forExport&&i.tooltip.userOptions||i.tooltip,this.userOptions=i,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=o,this.isResizing=0,this.options=t,this.axes=[],this.series=[],this.time=i.time&&Object.keys(i.time).length?new Time(i.time):H.time,this.numberFormatter=e.numberFormatter||numberFormat,this.styledMode=e.styledMode,this.hasCartesianSeries=e.showAxes;t=this;t.index=charts.length,charts.push(t),H.chartCount++,registerEventOptions(this,e),t.xAxis=[],t.yAxis=[],t.pointCount=t.colorCounter=t.symbolCounter=0,fireEvent(t,"afterInit"),t.firstRender()})},o.prototype.initSeries=function(t){var e=this,i=e.options.chart,o=t.type||i.type||i.defaultSeriesType,i=seriesTypes[o];i||error(17,!0,e,{missingModuleFor:o});i=new i;return"function"==typeof i.init&&i.init(e,t),i},o.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(t){t.points||t.data||!t.enabledDataSorting||t.setData(t.options.data,!1)})},o.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(t,e){return t.linkedSeries.length||e.linkedSeries.length?e.linkedSeries.length-t.linkedSeries.length:0})},o.prototype.orderSeries=function(t){for(var e=this.series,i=t||0,o=e.length;i<o;++i)e[i]&&(e[i].index=i,e[i].name=e[i].getName())},o.prototype.isInsidePlot=function(t,e,i){var o=this,r=o.inverted,n=o.plotBox,s=o.plotLeft,a=o.plotTop,h=o.scrollablePlotBox,d=0,l=0;(i=void 0===i?{}:i).visiblePlotOnly&&this.scrollingContainer&&(d=(c=this.scrollingContainer).scrollLeft,l=c.scrollTop);var o=i.series,c=i.visiblePlotOnly&&h||n,h=i.inverted?e:t,n=i.inverted?t:e,t={x:h,y:n,isInsidePlot:!0};return i.ignoreX||(e=o&&(r?o.yAxis:o.xAxis)||{pos:s,len:1/0},(h=i.paneCoordinates?e.pos+h:s+h)>=Math.max(d+s,e.pos)&&h<=Math.min(d+s+c.width,e.pos+e.len)||(t.isInsidePlot=!1)),!i.ignoreY&&t.isInsidePlot&&(o=o&&(r?o.xAxis:o.yAxis)||{pos:a,len:1/0},(n=i.paneCoordinates?o.pos+n:a+n)>=Math.max(l+a,o.pos)&&n<=Math.min(l+a+c.height,o.pos+o.len)||(t.isInsidePlot=!1)),fireEvent(this,"afterIsInsidePlot",t),t.isInsidePlot},o.prototype.redraw=function(t){fireEvent(this,"beforeRedraw");var e,i,o,r,n=this,s=n.hasCartesianSeries?n.axes:n.colorAxis||[],a=n.series,h=n.pointer,d=n.legend,l=n.userOptions.legend,c=n.renderer,p=c.isHidden(),f=[],g=n.isDirtyBox,u=n.isDirtyLegend;for(n.setResponsive&&n.setResponsive(!1),setAnimation(!!n.hasRendered&&t,n),p&&n.temporaryDisplay(),n.layOutTitles(),o=a.length;o--;)if(((r=a[o]).options.stacking||r.options.centerInCategory)&&(i=!0,r.isDirty)){e=!0;break}if(e)for(o=a.length;o--;)(r=a[o]).options.stacking&&(r.isDirty=!0);a.forEach(function(t){t.isDirty&&("point"===t.options.legendType?("function"==typeof t.updateTotals&&t.updateTotals(),u=!0):l&&(l.labelFormatter||l.labelFormat)&&(u=!0)),t.isDirtyData&&fireEvent(t,"updatedData")}),u&&d&&d.options.enabled&&(d.render(),n.isDirtyLegend=!1),i&&n.getStacks(),s.forEach(function(t){t.updateNames(),t.setScale()}),n.getMargins(),s.forEach(function(t){t.isDirty&&(g=!0)}),s.forEach(function(t){var e=t.min+","+t.max;t.extKey!==e&&(t.extKey=e,f.push(function(){fireEvent(t,"afterSetExtremes",extend(t.eventArgs,t.getExtremes())),delete t.eventArgs})),(g||i)&&t.redraw()}),g&&n.drawChartBox(),fireEvent(n,"predraw"),a.forEach(function(t){(g||t.isDirty)&&t.visible&&t.redraw(),t.isDirtyData=!1}),h&&h.reset(!0),c.draw(),fireEvent(n,"redraw"),fireEvent(n,"render"),p&&n.temporaryDisplay(!0),f.forEach(function(t){t.call()})},o.prototype.get=function(e){var t=this.series;function i(t){return t.id===e||t.options&&t.options.id===e}for(var o=find(this.axes,i)||find(this.series,i),r=0;!o&&r<t.length;r++)o=find(t[r].points||[],i);return o},o.prototype.getAxes=function(){var e=this,t=this.options,i=t.xAxis=splat(t.xAxis||{}),t=t.yAxis=splat(t.yAxis||{});fireEvent(this,"getAxes"),i.forEach(function(t,e){t.index=e,t.isX=!0}),t.forEach(function(t,e){t.index=e}),i.concat(t).forEach(function(t){new Axis(e,t)}),fireEvent(this,"afterGetAxes")},o.prototype.getSelectedPoints=function(){var e=[];return this.series.forEach(function(t){e=e.concat(t.getPointsCollection().filter(function(t){return pick(t.selectedStaging,t.selected)}))}),e},o.prototype.getSelectedSeries=function(){return this.series.filter(function(t){return t.selected})},o.prototype.setTitle=function(t,e,i){this.applyDescription("title",t),this.applyDescription("subtitle",e),this.applyDescription("caption",void 0),this.layOutTitles(i)},o.prototype.applyDescription=function(e,t){var i=this,o="title"===e?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},r=this.options[e]=merge(!this.styledMode&&{style:o},this.options[e],t),o=this[e];o&&t&&(this[e]=o=o.destroy()),r&&!o&&((o=this.renderer.text(r.text,0,0,r.useHTML).attr({align:r.align,class:"highcharts-"+e,zIndex:r.zIndex||4}).add()).update=function(t){i[{title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[e]](t)},this.styledMode||o.css(r.style),this[e]=o)},o.prototype.layOutTitles=function(t){var s=[0,0,0],a=this.renderer,h=this.spacingBox;["title","subtitle","caption"].forEach(function(t){var e,i=this[t],o=this.options[t],r=o.verticalAlign||"top",n="title"===t?"top"===r?-3:0:"top"===r?s[0]+2:0;i&&(this.styledMode||(e=o.style&&o.style.fontSize),e=a.fontMetrics(e,i).b,i.css({width:(o.width||h.width+(o.widthAdjust||0))+"px"}),t=Math.round(i.getBBox(o.useHTML).height),i.align(extend({y:"bottom"===r?e:n+e,height:t},o),!1,"spacingBox"),o.floating||("top"===r?s[0]=Math.ceil(s[0]+t):"bottom"===r&&(s[2]=Math.ceil(s[2]+t))))},this),s[0]&&"top"===(this.options.title.verticalAlign||"top")&&(s[0]+=this.options.title.margin),s[2]&&"bottom"===this.options.caption.verticalAlign&&(s[2]+=this.options.caption.margin);var e=!this.titleOffset||this.titleOffset.join(",")!==s.join(",");this.titleOffset=s,fireEvent(this,"afterLayOutTitles"),!this.isDirtyBox&&e&&(this.isDirtyBox=this.isDirtyLegend=e,this.hasRendered&&pick(t,!0)&&this.isDirtyBox&&this.redraw())},o.prototype.getChartSize=function(){var t=this,e=t.options.chart,i=e.width,o=e.height,e=t.renderTo;defined(i)||(t.containerWidth=getStyle(e,"width")),defined(o)||(t.containerHeight=getStyle(e,"height")),t.chartWidth=Math.max(0,i||t.containerWidth||600),t.chartHeight=Math.max(0,relativeLength(o,t.chartWidth)||(1<t.containerHeight?t.containerHeight:400))},o.prototype.temporaryDisplay=function(t){var e,i=this.renderTo;if(t)for(;i&&i.style;)i.hcOrigStyle&&(css(i,i.hcOrigStyle),delete i.hcOrigStyle),i.hcOrigDetached&&(doc.body.removeChild(i),i.hcOrigDetached=!1),i=i.parentNode;else for(;i&&i.style&&(doc.body.contains(i)||i.parentNode||(i.hcOrigDetached=!0,doc.body.appendChild(i)),"none"!==getStyle(i,"display",!1)&&!i.hcOricDetached||(i.hcOrigStyle={display:i.style.display,height:i.style.height,overflow:i.style.overflow},e={display:"block",overflow:"hidden"},i!==this.renderTo&&(e.height=0),css(i,e),i.offsetWidth||i.style.setProperty("display","block","important")),(i=i.parentNode)!==doc.body););},o.prototype.setClassName=function(t){this.container.className="highcharts-container "+(t||"")},o.prototype.getContainer=function(){var t=this,e=t.options,i=e.chart,o="data-highcharts-chart",r=uniqueKey(),n=t.renderTo;n||(t.renderTo=n=i.renderTo),isString(n)&&(t.renderTo=n=doc.getElementById(n)),n||error(13,!0,t);var s=pInt(attr(n,o));isNumber(s)&&charts[s]&&charts[s].hasRendered&&charts[s].destroy(),attr(n,o,t.index),n.innerHTML="",i.skipClone||n.offsetWidth||t.temporaryDisplay(),t.getChartSize();s=t.chartWidth,o=t.chartHeight;css(n,{overflow:"hidden"}),t.styledMode||(a=extend({position:"relative",overflow:"hidden",width:s+"px",height:o+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},i.style||{}));var a=createElement("div",{id:r},a,n);t.container=a,t._cursor=a.style.cursor;n=RendererRegistry.getRendererType(i.renderer);if(t.renderer=new n(a,s,o,void 0,i.forExport,e.exporting&&e.exporting.allowHTML,t.styledMode),setAnimation(void 0,t),t.setClassName(i.className),t.styledMode)for(var h in e.defs)this.renderer.definition(e.defs[h]);else t.renderer.setStyle(i.style);t.renderer.chartIndex=t.index,fireEvent(this,"afterGetContainer")},o.prototype.getMargins=function(t){var e=this.spacing,i=this.margin,o=this.titleOffset;this.resetMargins(),o[0]&&!defined(i[0])&&(this.plotTop=Math.max(this.plotTop,o[0]+e[0])),o[2]&&!defined(i[2])&&(this.marginBottom=Math.max(this.marginBottom,o[2]+e[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(i,e),fireEvent(this,"getMargins"),t||this.getAxisMargins()},o.prototype.getAxisMargins=function(){function t(t){t.forEach(function(t){t.visible&&t.getOffset()})}var i=this,o=i.axisOffset=[0,0,0,0],e=i.colorAxis,r=i.margin;i.hasCartesianSeries?t(i.axes):e&&e.length&&t(e),marginNames.forEach(function(t,e){defined(r[e])||(i[t]+=o[e])}),i.setChartSize()},o.prototype.reflow=function(t){var e=this,i=e.options.chart,o=e.renderTo,r=defined(i.width)&&defined(i.height),n=i.width||getStyle(o,"width"),i=i.height||getStyle(o,"height"),o=t?t.target:win;delete e.pointer.chartPosition,r||e.isPrinting||!n||!i||o!==win&&o!==doc||(n===e.containerWidth&&i===e.containerHeight||(U.clearTimeout(e.reflowTimeout),e.reflowTimeout=syncTimeout(function(){e.container&&e.setSize(void 0,void 0,!1)},t?100:0)),e.containerWidth=n,e.containerHeight=i)},o.prototype.setReflow=function(t){var e=this;!1===t||this.unbindReflow?!1===t&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow()):(this.unbindReflow=addEvent(win,"resize",function(t){e.options&&e.reflow(t)}),addEvent(this,"destroy",this.unbindReflow))},o.prototype.setSize=function(t,e,i){var o=this,r=o.renderer;o.isResizing+=1,setAnimation(i,o);i=r.globalAnimation;o.oldChartHeight=o.chartHeight,o.oldChartWidth=o.chartWidth,void 0!==t&&(o.options.chart.width=t),void 0!==e&&(o.options.chart.height=e),o.getChartSize(),o.styledMode||(i?animate:css)(o.container,{width:o.chartWidth+"px",height:o.chartHeight+"px"},i),o.setChartSize(!0),r.setSize(o.chartWidth,o.chartHeight,i),o.axes.forEach(function(t){t.isDirty=!0,t.setScale()}),o.isDirtyLegend=!0,o.isDirtyBox=!0,o.layOutTitles(),o.getMargins(),o.redraw(i),o.oldChartHeight=null,fireEvent(o,"resize"),syncTimeout(function(){o&&fireEvent(o,"endResize",null,function(){--o.isResizing})},animObject(i).duration)},o.prototype.setChartSize=function(t){var e,i=this,o=i.inverted,r=i.renderer,n=i.chartWidth,s=i.chartHeight,a=i.options.chart,h=i.spacing,d=i.clipOffset;i.plotLeft=e=Math.round(i.plotLeft),i.plotTop=l=Math.round(i.plotTop),i.plotWidth=c=Math.max(0,Math.round(n-e-i.marginRight)),i.plotHeight=p=Math.max(0,Math.round(s-l-i.marginBottom)),i.plotSizeX=o?p:c,i.plotSizeY=o?c:p,i.plotBorderWidth=a.plotBorderWidth||0,i.spacingBox=r.spacingBox={x:h[3],y:h[0],width:n-h[3]-h[1],height:s-h[0]-h[2]},i.plotBox=r.plotBox={x:e,y:l,width:c,height:p};var l=2*Math.floor(i.plotBorderWidth/2),c=Math.ceil(Math.max(l,d[3])/2),p=Math.ceil(Math.max(l,d[0])/2);i.clipBox={x:c,y:p,width:Math.floor(i.plotSizeX-Math.max(l,d[1])/2-c),height:Math.max(0,Math.floor(i.plotSizeY-Math.max(l,d[2])/2-p))},t||(i.axes.forEach(function(t){t.setAxisSize(),t.setAxisTranslation()}),r.alignElements()),fireEvent(i,"afterSetChartSize",{skipAxes:t})},o.prototype.resetMargins=function(){fireEvent(this,"resetMargins");var r=this,n=r.options.chart;["margin","spacing"].forEach(function(i){var t=n[i],o=isObject(t)?t:[t,t,t,t];["Top","Right","Bottom","Left"].forEach(function(t,e){r[i][e]=pick(n[i+t],o[e])})}),marginNames.forEach(function(t,e){r[t]=pick(r.margin[e],r.spacing[e])}),r.axisOffset=[0,0,0,0],r.clipOffset=[0,0,0,0]},o.prototype.drawChartBox=function(){var t,e,i=this,o=i.options.chart,r=i.renderer,n=i.chartWidth,s=i.chartHeight,a=i.styledMode,h=i.plotBGImage,d=o.backgroundColor,l=o.plotBackgroundColor,c=o.plotBackgroundImage,p=i.plotLeft,f=i.plotTop,g=i.plotWidth,u=i.plotHeight,m=i.plotBox,y=i.clipRect,v=i.clipBox,x=i.chartBackground,S=i.plotBackground,E=i.plotBorder,b="animate";x||(i.chartBackground=x=r.rect().addClass("highcharts-background").add(),b="attr"),a?t=e=x.strokeWidth():(e=(t=o.borderWidth||0)+(o.shadow?8:0),d={fill:d||"none"},(t||x["stroke-width"])&&(d.stroke=o.borderColor,d["stroke-width"]=t),x.attr(d).shadow(o.shadow)),x[b]({x:e/2,y:e/2,width:n-e-t%2,height:s-e-t%2,r:o.borderRadius}),b="animate",S||(b="attr",i.plotBackground=S=r.rect().addClass("highcharts-plot-background").add()),S[b](m),a||(S.attr({fill:l||"none"}).shadow(o.plotShadow),c&&(h?(c!==h.attr("href")&&h.attr("href",c),h.animate(m)):i.plotBGImage=r.image(c,p,f,g,u).add())),y?y.animate({width:v.width,height:v.height}):i.clipRect=r.clipRect(v),b="animate",E||(b="attr",i.plotBorder=E=r.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),a||E.attr({stroke:o.plotBorderColor,"stroke-width":o.plotBorderWidth||0,fill:"none"}),E[b](E.crisp({x:p,y:f,width:g,height:u},-E.strokeWidth())),i.isDirtyBox=!1,fireEvent(this,"afterDrawChartBox")},o.prototype.propFromSeries=function(){var e,i,o,r=this,n=r.options.chart,s=r.options.series;["inverted","angular","polar"].forEach(function(t){for(i=seriesTypes[n.type||n.defaultSeriesType],o=n[t]||i&&i.prototype[t],e=s&&s.length;!o&&e--;)(i=seriesTypes[s[e].type])&&i.prototype[t]&&(o=!0);r[t]=o})},o.prototype.linkSeries=function(){var i=this,t=i.series;t.forEach(function(t){t.linkedSeries.length=0}),t.forEach(function(t){var e=t.options.linkedTo;isString(e)&&(e=":previous"===e?i.series[t.index-1]:i.get(e))&&e.linkedParent!==t&&(e.linkedSeries.push(t),(t.linkedParent=e).enabledDataSorting&&t.setDataSortingOptions(),t.visible=pick(t.options.visible,e.options.visible,t.visible))}),fireEvent(this,"afterLinkSeries")},o.prototype.renderSeries=function(){this.series.forEach(function(t){t.translate(),t.render()})},o.prototype.renderLabels=function(){var r=this,n=r.options.labels;n.items&&n.items.forEach(function(t){var e=extend(n.style,t.style),i=pInt(e.left)+r.plotLeft,o=pInt(e.top)+r.plotTop+12;delete e.left,delete e.top,r.renderer.text(t.html,i,o).attr({zIndex:2}).css(e).add()})},o.prototype.render=function(){function t(t){t.forEach(function(t){t.visible&&t.render()})}var e=this,i=e.axes,o=e.colorAxis,r=e.renderer,n=e.options,s=0;e.setTitle(),e.legend=new Legend(e,n.legend),e.getStacks&&e.getStacks(),e.getMargins(!0),e.setChartSize();var a=e.plotWidth;i.some(function(t){if(t.horiz&&t.visible&&t.options.labels.enabled&&t.series.length)return s=21,!0}),e.plotHeight=Math.max(e.plotHeight-s,0);n=e.plotHeight;i.forEach(function(t){t.setScale()}),e.getAxisMargins();var h=1.1<a/e.plotWidth,d=1.05<n/e.plotHeight;(h||d)&&(i.forEach(function(t){(t.horiz&&h||!t.horiz&&d)&&t.setTickInterval(!0)}),e.getMargins()),e.drawChartBox(),e.hasCartesianSeries?t(i):o&&o.length&&t(o),e.seriesGroup||(e.seriesGroup=r.g("series-group").attr({zIndex:3}).add()),e.renderSeries(),e.renderLabels(),e.addCredits(),e.setResponsive&&e.setResponsive(),e.hasRendered=!0},o.prototype.addCredits=function(t){var e=this,i=merge(!0,this.options.credits,t);i.enabled&&!this.credits&&(this.credits=this.renderer.text(i.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){i.href&&(win.location.href=i.href)}).attr({align:i.position.align,zIndex:8}),e.styledMode||this.credits.css(i.style),this.credits.add().align(i.position),this.credits.update=function(t){e.credits=e.credits.destroy(),e.addCredits(t)})},o.prototype.destroy=function(){var t,i=this,e=i.axes,o=i.series,r=i.container,n=r&&r.parentNode;for(fireEvent(i,"destroy"),i.renderer.forExport?erase(charts,i):charts[i.index]=void 0,H.chartCount--,i.renderTo.removeAttribute("data-highcharts-chart"),removeEvent(i),t=e.length;t--;)e[t]=e[t].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),t=o.length;t--;)o[t]=o[t].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(t){var e=i[t];e&&e.destroy&&(i[t]=e.destroy())}),r&&(r.innerHTML="",removeEvent(r),n&&discardElement(r)),objectEach(i,function(t,e){delete i[e]})},o.prototype.firstRender=function(){var e=this,t=e.options;e.isReadyToRender&&!e.isReadyToRender()||(e.getContainer(),e.resetMargins(),e.setChartSize(),e.propFromSeries(),e.getAxes(),(isArray(t.series)?t.series:[]).forEach(function(t){e.initSeries(t)}),e.linkSeries(),e.setSeriesData(),fireEvent(e,"beforeRender"),Pointer&&(MSPointer.isRequired()?e.pointer=new MSPointer(e,t):e.pointer=new Pointer(e,t)),e.render(),e.pointer.getChartPosition(),e.renderer.imgCount||e.hasLoaded||e.onload(),e.temporaryDisplay(!0))},o.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(t){t&&void 0!==this.index&&t.apply(this,[this])},this),fireEvent(this,"load"),fireEvent(this,"render"),defined(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},o.prototype.addSeries=function(t,e,i){var o,r=this;return t&&(e=pick(e,!0),fireEvent(r,"addSeries",{options:t},function(){o=r.initSeries(t),r.isDirtyLegend=!0,r.linkSeries(),o.enabledDataSorting&&o.setData(t.data,!1),fireEvent(r,"afterAddSeries",{series:o}),e&&r.redraw(i)})),o},o.prototype.addAxis=function(t,e,i,o){return this.createAxis(e?"xAxis":"yAxis",{axis:t,redraw:i,animation:o})},o.prototype.addColorAxis=function(t,e,i){return this.createAxis("colorAxis",{axis:t,redraw:e,animation:i})},o.prototype.createAxis=function(t,e){var i="colorAxis"===t,o=e.axis,r=e.redraw,e=e.animation,t=merge(o,{index:this[t].length,isX:"xAxis"===t}),t=new(i?H.ColorAxis:Axis)(this,t);return i&&(this.isDirtyLegend=!0,this.axes.forEach(function(t){t.series=[]}),this.series.forEach(function(t){t.bindAxes(),t.isDirtyData=!0})),pick(r,!0)&&this.redraw(e),t},o.prototype.showLoading=function(t){function e(){n&&css(n,{left:i.plotLeft+"px",top:i.plotTop+"px",width:i.plotWidth+"px",height:i.plotHeight+"px"})}var i=this,o=i.options,r=o.loading,n=i.loadingDiv,s=i.loadingSpan;n||(i.loadingDiv=n=createElement("div",{className:"highcharts-loading highcharts-loading-hidden"},null,i.container)),s||(i.loadingSpan=s=createElement("span",{className:"highcharts-loading-inner"},null,n),addEvent(i,"redraw",e)),n.className="highcharts-loading",AST.setElementHTML(s,pick(t,o.lang.loading,"")),i.styledMode||(css(n,extend(r.style,{zIndex:10})),css(s,r.labelStyle),i.loadingShown||(css(n,{opacity:0,display:""}),animate(n,{opacity:r.style.opacity||.5},{duration:r.showDuration||0}))),i.loadingShown=!0,e()},o.prototype.hideLoading=function(){var t=this.options,e=this.loadingDiv;e&&(e.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(e,{opacity:0},{duration:t.loading.hideDuration||100,complete:function(){css(e,{display:"none"})}})),this.loadingShown=!1},o.prototype.update=function(i,t,s,e){var o,r,a=this,n={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},h=i.isResponsiveOptions,d=[];fireEvent(a,"update",{options:i}),h||a.setResponsive(!1,!0),i=cleanRecursively(i,a.options),a.userOptions=merge(a.userOptions,i);var l=i.chart;l&&(merge(!0,a.options.chart,l),"className"in l&&a.setClassName(l.className),"reflow"in l&&a.setReflow(l.reflow),("inverted"in l||"polar"in l||"type"in l)&&(a.propFromSeries(),c=!0),"alignTicks"in l&&(c=!0),"events"in l&&registerEventOptions(this,l),objectEach(l,function(t,e){-1!==a.propsRequireUpdateSeries.indexOf("chart."+e)&&(o=!0),-1!==a.propsRequireDirtyBox.indexOf(e)&&(a.isDirtyBox=!0),-1!==a.propsRequireReflow.indexOf(e)&&(h?a.isDirtyBox=!0:r=!0)}),!a.styledMode&&"style"in l&&a.renderer.setStyle(l.style)),!a.styledMode&&i.colors&&(this.options.colors=i.colors),i.time&&(this.time===defaultTime&&(this.time=new Time(i.time)),merge(!0,a.options.time,i.time)),objectEach(i,function(t,e){a[e]&&"function"==typeof a[e].update?a[e].update(t,!1):"function"==typeof a[n[e]]?a[n[e]](t):"colors"!==e&&-1===a.collectionsWithUpdate.indexOf(e)&&merge(!0,a.options[e],i[e]),"chart"!==e&&-1!==a.propsRequireUpdateSeries.indexOf(e)&&(o=!0)}),this.collectionsWithUpdate.forEach(function(r){var n;i[r]&&(n=[],a[r].forEach(function(t,e){t.options.isInternal||n.push(pick(t.options.index,e))}),splat(i[r]).forEach(function(t,e){var i,o=defined(t.id);(i=!(i=o?a.get(t.id):i)&&a[r]&&(i=a[r][n?n[e]:e])&&o&&defined(i.options.id)?void 0:i)&&i.coll===r&&(i.update(t,!1),s&&(i.touched=!0)),!i&&s&&a.collectionsWithInit[r]&&(a.collectionsWithInit[r][0].apply(a,[t].concat(a.collectionsWithInit[r][1]||[]).concat([!1])).touched=!0)}),s&&a[r].forEach(function(t){t.touched||t.options.isInternal?delete t.touched:d.push(t)}))}),d.forEach(function(t){t.chart&&t.remove(!1)}),c&&a.axes.forEach(function(t){t.update({},!1)}),o&&a.getSeriesOrderByLinks().forEach(function(t){t.chart&&t.update({},!1)},this);var c=l&&l.width,l=l&&(isString(l.height)?relativeLength(l.height,c||a.chartWidth):l.height);r||isNumber(c)&&c!==a.chartWidth||isNumber(l)&&l!==a.chartHeight?a.setSize(c,l,e):pick(t,!0)&&a.redraw(e),fireEvent(a,"afterUpdate",{options:i,redraw:t,animation:e})},o.prototype.setSubtitle=function(t,e){this.applyDescription("subtitle",t),this.layOutTitles(e)},o.prototype.setCaption=function(t,e){this.applyDescription("caption",t),this.layOutTitles(e)},o.prototype.showResetZoom=function(){var t=this,e=defaultOptions.lang,i=t.options.chart.resetZoomButton,o=i.theme,r=o.states,n="chart"===i.relativeTo||"spacingBox"===i.relativeTo?null:"scrollablePlotBox";function s(){t.zoomOut()}fireEvent(this,"beforeShowResetZoom",null,function(){t.resetZoomButton=t.renderer.button(e.resetZoom,null,null,s,o,r&&r.hover).attr({align:i.position.align,title:e.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(i.position,!1,n)}),fireEvent(this,"afterShowResetZoom")},o.prototype.zoomOut=function(){fireEvent(this,"selection",{resetSelection:!0},this.zoom)},o.prototype.zoom=function(t){var s,a=this,h=a.pointer,d=a.inverted?h.mouseDownX:h.mouseDownY,l=!1;!t||t.resetSelection?(a.axes.forEach(function(t){s=t.zoom()}),h.initiated=!1):t.xAxis.concat(t.yAxis).forEach(function(t){var e=t.axis,i=a.inverted?e.left:e.top,o=a.inverted?i+e.width:i+e.height,r=e.isXAxis,n=!1;(!r&&i<=d&&d<=o||r||!defined(d))&&(n=!0),h[r?"zoomX":"zoomY"]&&n&&(s=e.zoom(t.min,t.max),e.displayBtn&&(l=!0))});var e=a.resetZoomButton;l&&!e?a.showResetZoom():!l&&isObject(e)&&(a.resetZoomButton=e.destroy()),s&&a.redraw(pick(a.options.chart.animation,t&&t.animation,a.pointCount<100))},o.prototype.pan=function(p,t){var f=this,e=f.hoverPoints,i="object"==typeof t?t:{enabled:t,type:"x"},t=f.options.chart,g=f.options.mapNavigation&&f.options.mapNavigation.enabled;t&&t.panning&&(t.panning=i);var u,m=i.type;fireEvent(this,"pan",{originalEvent:p},function(){e&&e.forEach(function(t){t.setState()});var t=f.xAxis;"xy"===m?t=t.concat(f.yAxis):"y"===m&&(t=f.yAxis);var c={};t.forEach(function(t){var e,i,o,r,n,s,a,h,d,l;t.options.panningEnabled&&!t.options.isInternal&&(r=t.horiz,e=p[r?"chartX":"chartY"],l=f[i=r?"mouseDownX":"mouseDownY"],h=t.minPointOffset||0,n=t.reversed&&!f.inverted||!t.reversed&&f.inverted?-1:1,o=t.getExtremes(),s=t.toValue(l-e,!0)+h*n,r=(d=t.toValue(l+t.len-e,!0)-(h*n||t.isXAxis&&t.pointRangePadding||0))<s,l=t.hasVerticalPanning(),n=r?d:s,s=r?s:d,a=t.panningState,!l||t.isXAxis||a&&!a.isDirty||t.series.forEach(function(t){var e=t.getProcessedData(!0),e=t.getExtremes(e.yData,!0);a=a||{startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE},isNumber(e.dataMin)&&isNumber(e.dataMax)&&(a.startMin=Math.min(pick(t.options.threshold,1/0),e.dataMin,a.startMin),a.startMax=Math.max(pick(t.options.threshold,-1/0),e.dataMax,a.startMax))}),d=Math.min(pick(a&&a.startMin,o.dataMin),h?o.min:t.toValue(t.toPixels(o.min)-t.minPixelPadding)),l=Math.max(pick(a&&a.startMax,o.dataMax),h?o.max:t.toValue(t.toPixels(o.max)+t.minPixelPadding)),t.panningState=a,t.isOrdinal||(0<(h=d-n)&&(s+=h,n=d),0<(h=s-l)&&(s=l,n-=h),t.series.length&&n!==o.min&&s!==o.max&&d<=n&&s<=l&&(t.setExtremes(n,s,!1,!1,{trigger:"pan"}),f.resetZoomButton||g||n===d||s===l||!m.match("y")||(f.showResetZoom(),t.displayBtn=!1),u=!0),c[i]=e))}),objectEach(c,function(t,e){f[e]=t}),u&&f.redraw(!1),css(f.container,{cursor:"move"})})},o}();extend(Chart.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart.prototype.addAxis,[!0]],yAxis:[Chart.prototype.addAxis,[!1]],series:[Chart.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","zAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});export default Chart;