"use strict";import Axis from"./Axis/Axis.js";import Chart from"./Chart/Chart.js";import Color from"./Color/Color.js";var color=Color.parse;import H from"./Globals.js";var hasTouch=H.hasTouch,isTouchDevice=H.isTouchDevice;import NavigatorAxis from"./Axis/NavigatorAxis.js";import D from"./DefaultOptions.js";var defaultOptions=D.defaultOptions;import Palette from"./Color/Palette.js";import RendererRegistry from"./Renderer/RendererRegistry.js";import Scrollbar from"./Scrollbar.js";import Series from"./Series/Series.js";import SeriesRegistry from"./Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import U from"./Utilities.js";var addEvent=U.addEvent,clamp=U.clamp,correctFloat=U.correctFloat,defined=U.defined,destroyObjectProperties=U.destroyObjectProperties,erase=U.erase,extend=U.extend,find=U.find,isArray=U.isArray,isNumber=U.isNumber,merge=U.merge,pick=U.pick,removeEvent=U.removeEvent,splat=U.splat,numExt=function(e){for(var t=[],i=1;i<arguments.length;i++)t[i-1]=arguments[i];var a=[].filter.call(t,isNumber);if(a.length)return Math[e].apply(0,a)},defaultSeriesType=void 0===seriesTypes.areaspline?"line":"areaspline";extend(defaultOptions,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:Palette.neutralColor5,borderColor:Palette.neutralColor40},maskFill:color(Palette.highlightColor60).setOpacity(.3).get(),outlineColor:Palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:Palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:Palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),RendererRegistry.getRendererType().prototype.symbols["navigator-handle"]=function(e,t,i,a,s){var r=(s&&s.width||0)/2,o=Math.round(r/3)+.5,s=s&&s.height||0;return[["M",-r-1,.5],["L",r,.5],["L",r,s+.5],["L",-r-1,s+.5],["L",-r-1,.5],["M",-o,4],["L",-o,s-3],["M",o-1,4],["L",o-1,s-3]]};var Navigator=function(){function e(e){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(e)}return e.prototype.drawHandle=function(e,t,i,a){var s=this,r=s.navigatorOptions.handles.height;s.handles[t][a](i?{translateX:Math.round(s.left+s.height/2),translateY:Math.round(s.top+parseInt(e,10)+.5-r)}:{translateX:Math.round(s.left+parseInt(e,10)),translateY:Math.round(s.top+s.height/2-r/2-1)})},e.prototype.drawOutline=function(e,t,i,a){var s,r=this,o=r.navigatorOptions.maskInside,n=r.outline.strokeWidth(),d=n/2,h=n%2/2,l=r.outlineHeight,g=r.scrollbarHeight||0,v=r.size,p=r.left-g,n=r.top;i?(s=[["M",(p-=d)+l,n-g-h],["L",p+l,i=n+t+h],["L",p,i],["L",p,t=n+e+h],["L",p+l,t],["L",p+l,n+v+g]],o&&s.push(["M",p+l,i-d],["L",p+l,t+d])):(s=[["M",p,n+=d],["L",e+=p+g-h,n],["L",e,n+l],["L",t+=p+g-h,n+l],["L",t,n],["L",p+v+2*g,n]],o&&s.push(["M",e-d,n],["L",t+d,n])),r.outline[a]({d:s})},e.prototype.drawMasks=function(e,t,i,a){var s,r,o,n=this,d=n.left,h=n.top,l=n.height,g=i?(r=[d,d,d],o=[h,h+e,h+t],s=[l,l,l],[e,t-e,n.size-t]):(r=[d,d+e,d+t],o=[h,h,h],s=[e,t-e,n.size-t],[l,l,l]);n.shades.forEach(function(e,t){e[a]({x:r[t],y:o[t],width:s[t],height:g[t]})})},e.prototype.renderElements=function(){var i,a=this,s=a.navigatorOptions,e=s.maskInside,r=a.chart,t=r.inverted,o=r.renderer,n={cursor:t?"ns-resize":"ew-resize"};a.navigatorGroup=i=o.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!e,e,!e].forEach(function(e,t){a.shades[t]=o.rect().addClass("highcharts-navigator-mask"+(1===t?"-inside":"-outside")).add(i),r.styledMode||a.shades[t].attr({fill:e?s.maskFill:"rgba(0,0,0,0)"}).css(1===t&&n)}),a.outline=o.path().addClass("highcharts-navigator-outline").add(i),r.styledMode||a.outline.attr({"stroke-width":s.outlineWidth,stroke:s.outlineColor}),s.handles.enabled&&[0,1].forEach(function(e){var t;s.handles.inverted=r.inverted,a.handles[e]=o.symbol(s.handles.symbols[e],-s.handles.width/2-1,0,s.handles.width,s.handles.height,s.handles),a.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(i),r.styledMode||(t=s.handles,a.handles[e].attr({fill:t.backgroundColor,stroke:t.borderColor,"stroke-width":t.lineWidth}).css(n))})},e.prototype.update=function(e){(this.series||[]).forEach(function(e){e.baseSeries&&delete e.baseSeries.navigatorSeries}),this.destroy();var t=this.chart.options;merge(!0,t.navigator,this.options,e),this.init(this.chart)},e.prototype.render=function(e,t,i,a){var s,r,o,n,d,h=this,l=h.chart,g=h.scrollbarHeight,v=h.xAxis,p=v.pointRange||0,c=v.navigatorAxis.fake?l.xAxis[0]:v,x=h.navigatorEnabled,u=h.rendered,m=l.inverted,f=l.xAxis[0].minRange,b=l.xAxis[0].options.maxRange;if(!this.hasDragged||defined(i)){if(e=correctFloat(e-p/2),t=correctFloat(t+p/2),!isNumber(e)||!isNumber(t)){if(!u)return;i=0,a=pick(v.width,c.width)}h.left=pick(v.left,l.plotLeft+g+(m?l.plotWidth:0)),h.size=d=n=pick(v.len,(m?l.plotHeight:l.plotWidth)-2*g),s=m?g:n+2*g,i=pick(i,v.toPixels(e,!0)),a=pick(a,v.toPixels(t,!0)),isNumber(i)&&Math.abs(i)!==1/0||(i=0,a=s),l=v.toValue(i,!0),e=v.toValue(a,!0),(t=Math.abs(correctFloat(e-l)))<f?this.grabbedLeft?i=v.toPixels(e-f-p,!0):this.grabbedRight&&(a=v.toPixels(l+f+p,!0)):defined(b)&&correctFloat(t-p)>b&&(this.grabbedLeft?i=v.toPixels(e-b-p,!0):this.grabbedRight&&(a=v.toPixels(l+b+p,!0))),h.zoomedMax=clamp(Math.max(i,a),0,d),h.zoomedMin=clamp(h.fixedWidth?h.zoomedMax-h.fixedWidth:Math.min(i,a),0,d),h.range=h.zoomedMax-h.zoomedMin,d=Math.round(h.zoomedMax),a=Math.round(h.zoomedMin),x&&(h.navigatorGroup.attr({visibility:"visible"}),u=u&&!h.hasDragged?"animate":"attr",h.drawMasks(a,d,m,u),h.drawOutline(a,d,m,u),h.navigatorOptions.handles.enabled&&(h.drawHandle(a,0,m,u),h.drawHandle(d,1,m,u))),h.scrollbar&&(m?(o=h.top-g,r=h.left-g+(x||!c.opposite?0:(c.titleOffset||0)+c.axisTitleMargin),g=n+2*g):(o=h.top+(x?h.height:-g),r=h.left-g),h.scrollbar.position(r,o,s,g),h.scrollbar.setRange(h.zoomedMin/(n||1),h.zoomedMax/(n||1))),h.rendered=!0}},e.prototype.addMouseEvents=function(){var e,t,i=this,a=i.chart,s=a.container,r=[];i.mouseMoveHandler=e=function(e){i.onMouseMove(e)},i.mouseUpHandler=t=function(e){i.onMouseUp(e)},(r=i.getPartsEvents("mousedown")).push(addEvent(a.renderTo,"mousemove",e),addEvent(s.ownerDocument,"mouseup",t)),hasTouch&&(r.push(addEvent(a.renderTo,"touchmove",e),addEvent(s.ownerDocument,"touchend",t)),r.concat(i.getPartsEvents("touchstart"))),i.eventsToUnbind=r,i.series&&i.series[0]&&r.push(addEvent(i.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(a){var s=this,r=[];return["shades","handles"].forEach(function(i){s[i].forEach(function(e,t){r.push(addEvent(e.element,a,function(e){s[i+"Mousedown"](e,t)}))})}),r},e.prototype.shadesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var i,a,s=this,r=s.chart,o=s.xAxis,n=s.zoomedMin,d=s.left,h=s.size,l=s.range,g=e.chartX;r.inverted&&(g=e.chartY,d=s.top),1===t?(s.grabbedCenter=g,s.fixedWidth=l,s.dragOffset=g-n):(d=g-d-l/2,0===t?d=Math.max(0,d):2===t&&h<=d+l&&(d=h-l,s.reversedExtremes?(d-=l,i=s.getUnionExtremes().dataMin):a=s.getUnionExtremes().dataMax),d!==n&&(s.fixedWidth=l,a=o.navigatorAxis.toFixedRange(d,d+l,i,a),defined(a.min)&&r.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"})))},e.prototype.handlesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var i=this,a=i.chart,s=a.xAxis[0],e=i.reversedExtremes;0===t?(i.grabbedLeft=!0,i.otherHandlePos=i.zoomedMax,i.fixedExtreme=e?s.min:s.max):(i.grabbedRight=!0,i.otherHandlePos=i.zoomedMin,i.fixedExtreme=e?s.max:s.min),a.fixedRange=null},e.prototype.onMouseMove=function(e){var t=this,i=t.chart,a=t.left,s=t.navigatorSize,r=t.range,o=t.dragOffset,n=i.inverted;e.touches&&0===e.touches[0].pageX||(i=(e=i.pointer.normalize(e)).chartX,n&&(a=t.top,i=e.chartY),t.grabbedLeft?(t.hasDragged=!0,t.render(0,0,i-a,t.otherHandlePos)):t.grabbedRight?(t.hasDragged=!0,t.render(0,0,t.otherHandlePos,i-a)):t.grabbedCenter&&(t.hasDragged=!0,i<o?i=o:s+o-r<i&&(i=s+o-r),t.render(0,0,i-o,i-o+r)),t.hasDragged&&t.scrollbar&&pick(t.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice&&!this.chart.isBoosting)&&(e.DOMType=e.type,setTimeout(function(){t.onMouseUp(e)},0)))},e.prototype.onMouseUp=function(e){var t,i,a=this,s=a.chart,r=a.xAxis,o=a.scrollbar,n=e.DOMEvent||e,d=s.inverted,h=a.rendered&&!a.hasDragged?"animate":"attr";(!a.hasDragged||o&&o.hasDragged)&&"scrollbar"!==e.trigger||(o=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?t=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(i=a.fixedExtreme),a.zoomedMax===a.size&&(i=a.reversedExtremes?o.dataMin:o.dataMax),0===a.zoomedMin&&(t=a.reversedExtremes?o.dataMax:o.dataMin),i=r.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,t,i),defined(i.min)&&s.xAxis[0].setExtremes(Math.min(i.min,i.max),Math.max(i.min,i.max),!0,!a.hasDragged&&null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:n})),"mousemove"!==e.DOMType&&"touchmove"!==e.DOMType&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber(a.zoomedMin)&&isNumber(a.zoomedMax)&&(n=Math.round(a.zoomedMin),e=Math.round(a.zoomedMax),a.shades&&a.drawMasks(n,e,d,h),a.outline&&a.drawOutline(n,e,d,h),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(n,0,d,h),a.drawHandle(e,1,d,h)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(e){e()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var e=this.baseSeries||[];this.navigatorEnabled&&e[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&e.forEach(function(e){removeEvent(e,"updatedData",this.updatedDataHandler)},this),e[0].xAxis&&removeEvent(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.init=function(o){var e=o.options,t=e.navigator,i=t.enabled,a=e.scrollbar,s=a.enabled,r=i?t.height:0,n=s?a.height:0;this.handles=[],this.shades=[],this.chart=o,this.setBaseSeries(),this.height=r,this.scrollbarHeight=n,this.scrollbarEnabled=s,this.navigatorEnabled=i,this.navigatorOptions=t,this.scrollbarOptions=a,this.outlineHeight=r+n,this.opposite=pick(t.opposite,Boolean(!i&&o.inverted));var d=this,e=d.baseSeries,s=o.xAxis.length,a=o.yAxis.length,i=e&&e[0]&&e[0].xAxis||o.xAxis[0]||{options:{}};o.isDirtyBox=!0,d.navigatorEnabled?(d.xAxis=new Axis(o,merge({breaks:i.options.breaks,ordinal:i.options.ordinal},t.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:s,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},o.inverted?{offsets:[n,0,-n,0],width:r}:{offsets:[0,-n,0,n],height:r})),d.yAxis=new Axis(o,merge(t.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:a,isInternal:!0,reversed:pick(t.yAxis&&t.yAxis.reversed,o.yAxis[0]&&o.yAxis[0].reversed,!1),zoomEnabled:!1},o.inverted?{width:r}:{height:r})),e||t.series.data?d.updateNavigatorSeries(!1):0===o.series.length&&(d.unbindRedraw=addEvent(o,"beforeRedraw",function(){0<o.series.length&&!d.series&&(d.setBaseSeries(),d.unbindRedraw())})),d.reversedExtremes=o.inverted&&!d.xAxis.reversed||!o.inverted&&d.xAxis.reversed,d.renderElements(),d.addMouseEvents()):(d.xAxis={chart:o,navigatorAxis:{fake:!0},translate:function(e,t){var i=o.xAxis[0],a=i.getExtremes(),s=i.len-2*n,r=numExt("min",i.options.min,a.dataMin),a=numExt("max",i.options.max,a.dataMax)-r;return t?e*a/s+r:s*(e-r)/a},toPixels:function(e){return this.translate(e)},toValue:function(e){return this.translate(e,!0)}},d.xAxis.navigatorAxis.axis=d.xAxis,d.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(d.xAxis.navigatorAxis)),o.options.scrollbar.enabled&&(o.scrollbar=d.scrollbar=new Scrollbar(o.renderer,merge(o.options.scrollbar,{margin:d.navigatorEnabled?0:10,vertical:o.inverted}),o),addEvent(d.scrollbar,"changed",function(e){var t=d.size,i=t*this.to,t=t*this.from;d.hasDragged=d.scrollbar.hasDragged,d.render(0,0,t,i),this.shouldUpdateExtremes(e.DOMType)&&setTimeout(function(){d.onMouseUp(e)})})),d.addBaseSeriesEvents(),d.addChartEvents()},e.prototype.getUnionExtremes=function(e){var t,i=this.chart.xAxis[0],a=this.xAxis,s=a.options,r=i.options;return t=!e||null!==i.dataMin?{dataMin:pick(s&&s.min,numExt("min",r.min,i.dataMin,a.dataMin,a.min)),dataMax:pick(s&&s.max,numExt("max",r.max,i.dataMax,a.dataMax,a.max))}:t},e.prototype.setBaseSeries=function(i,e){var t=this.chart,a=this.baseSeries=[];i=i||t.options&&t.options.navigator.baseSeries||(t.series.length?find(t.series,function(e){return!e.options.isInternal}).index:0),(t.series||[]).forEach(function(e,t){e.options.isInternal||!e.options.showInNavigator&&(t!==i&&e.options.id!==i||!1===e.options.showInNavigator)||a.push(e)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)},e.prototype.updateNavigatorSeries=function(e,a){var s,r,o,n=this,d=n.chart,h=n.baseSeries,l=n.navigatorOptions.series,g={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},v=n.series=(n.series||[]).filter(function(e){var t=e.baseSeries;return!(h.indexOf(t)<0)||(t&&(removeEvent(t,"updatedData",n.updatedDataHandler),delete t.navigatorSeries),e.chart&&e.destroy(),!1)});h&&h.length&&h.forEach(function(e){var t=e.navigatorSeries,i=extend({color:e.color,visible:e.visible},isArray(l)?defaultOptions.navigator.series:l);t&&!1===n.navigatorOptions.adaptToUpdatedData||(g.name="Navigator "+h.length,s=e.options||{},o=s.navigatorOptions||{},i.dataLabels=splat(i.dataLabels),(r=merge(s,g,i,o)).pointRange=pick(i.pointRange,o.pointRange,defaultOptions.plotOptions[r.type||"line"].pointRange),i=o.data||i.data,n.hasNavigatorData=n.hasNavigatorData||!!i,r.data=i||s.data&&s.data.slice(0),t&&t.options?t.update(r,a):(e.navigatorSeries=d.initSeries(r),e.navigatorSeries.baseSeries=e,v.push(e.navigatorSeries)))}),(!l.data||h&&h.length)&&!isArray(l)||(n.hasNavigatorData=!1,(l=splat(l)).forEach(function(e,t){g.name="Navigator "+(v.length+1),(r=merge(defaultOptions.navigator.series,{color:d.series[t]&&!d.series[t].options.isInternal&&d.series[t].color||d.options.colors[t]||d.options.colors[0]},g,e)).data=e.data,r.data&&(n.hasNavigatorData=!0,v.push(d.initSeries(r)))})),e&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,e=t.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(addEvent(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(addEvent(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(addEvent(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==this.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(addEvent(e,"updatedData",this.updatedDataHandler)),e.eventsToUnbind.push(addEvent(e,"remove",function(){this.navigatorSeries&&(erase(t.series,this.navigatorSeries),defined(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},e.prototype.getBaseSeriesMin=function(e){return this.baseSeries.reduce(function(e,t){return Math.min(e,t.xData?t.xData[0]:e)},e)},e.prototype.modifyNavigatorAxisExtremes=function(){var e,t=this.xAxis;void 0!==t.getExtremes&&(!(e=this.getUnionExtremes(!0))||e.dataMin===t.min&&e.dataMax===t.max||(t.min=e.dataMin,t.max=e.dataMax))},e.prototype.modifyBaseAxisExtremes=function(){var e,t,i=this,a=i.chart.navigator,s=i.getExtremes(),r=s.min,o=s.max,n=s.dataMin,d=s.dataMax,h=o-r,l=a.stickToMin,g=a.stickToMax,s=pick(i.options.overscroll,0),o=a.series&&a.series[0],r=!!i.setExtremes;i.eventArgs&&"rangeSelectorButton"===i.eventArgs.trigger||(l&&(e=(t=n)+h),g&&(e=d+s,l||(t=Math.max(n,e-h,a.getBaseSeriesMin(o&&o.xData?o.xData[0]:-Number.MAX_VALUE)))),r&&(l||g)&&isNumber(t)&&(i.min=i.userMin=t,i.max=i.userMax=e)),a.stickToMin=a.stickToMax=null},e.prototype.updatedDataHandler=function(){var e=this.chart.navigator,t=this.navigatorSeries;e.stickToMax=e.reversedExtremes?0===Math.round(e.zoomedMin):Math.round(e.zoomedMax)>=Math.round(e.size),e.stickToMin=e.shouldStickToMin(this,e),t&&!e.hasNavigatorData&&(t.options.pointStart=this.xData[0],t.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(e,t){var i=t.getBaseSeriesMin(e.xData[0]),a=e.xAxis,s=a.max,t=a.min,e=a.options.range,a=!0;return a=isNumber(s)&&isNumber(t)?e&&0<s-i?s-i<e&&!this.chart.fixedRange:t<=i:a},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent(this.chart,"redraw",function(){var e=this.navigator,t=e&&(e.baseSeries&&e.baseSeries[0]&&e.baseSeries[0].xAxis||this.xAxis[0]);t&&e.render(t.min,t.max)}),addEvent(this.chart,"getMargins",function(){var e=this,t=e.navigator,i=t.opposite?"plotTop":"marginBottom";e[i=e.inverted?t.opposite?"marginRight":"plotLeft":i]=(e[i]||0)+(t.navigatorEnabled||!e.inverted?t.outlineHeight:0)+t.navigatorOptions.margin}))},e.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase(this.chart.xAxis,this.xAxis),erase(this.chart.axes,this.xAxis)),this.yAxis&&(erase(this.chart.yAxis,this.yAxis),erase(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(e){e.destroy&&e.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(e){this[e]&&this[e].destroy&&this[e].destroy(),this[e]=null},this),[this.handles].forEach(function(e){destroyObjectProperties(e)},this)},e}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent(Chart,"beforeShowResetZoom",function(){var e=this.options,t=e.navigator,i=e.rangeSelector;if((t&&t.enabled||i&&i.enabled)&&(!isTouchDevice&&"x"===e.chart.zoomType||isTouchDevice&&"x"===e.chart.pinchType))return!1}),addEvent(Chart,"beforeRender",function(){var e=this.options;(e.navigator.enabled||e.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent(Chart,"afterSetChartSize",function(){var e,t,i,a,s=this.legend,r=this.navigator;r&&(t=s&&s.options,i=r.xAxis,a=r.yAxis,e=r.scrollbarHeight,this.inverted?(r.left=r.opposite?this.chartWidth-e-r.height:this.spacing[3]+e,r.top=this.plotTop+e):(r.left=pick(i.left,this.plotLeft+e),r.top=r.navigatorOptions.top||this.chartHeight-r.height-e-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(t&&"bottom"===t.verticalAlign&&"proximate"!==t.layout&&t.enabled&&!t.floating?s.legendHeight+pick(t.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),i&&a&&(this.inverted?i.options.left=a.options.left=r.left:i.options.top=a.options.top=r.top,i.setAxisSize(),a.setAxisSize()))}),addEvent(Chart,"update",function(e){var t=e.options.navigator||{},i=e.options.scrollbar||{};this.navigator||this.scroller||!t.enabled&&!i.enabled||(merge(!0,this.options.navigator,t),merge(!0,this.options.scrollbar,i),delete e.options.navigator,delete e.options.scrollbar)}),addEvent(Chart,"afterUpdate",function(e){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new Navigator(this),pick(e.redraw,!0)&&this.redraw(e.animation))}),addEvent(Chart,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent(Series,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart.prototype.callbacks.push(function(e){var t=e.navigator;t&&e.xAxis[0]&&(e=e.xAxis[0].getExtremes(),t.render(e.min,e.max))})),H.Navigator=Navigator;export default H.Navigator;