"use strict";import F from"./FormatUtilities.js";var format=F.format;import H from"./Globals.js";var doc=H.doc;import palette from"./Color/Palette.js";import RendererRegistry from"./Renderer/RendererRegistry.js";import U from"./Utilities.js";var clamp=U.clamp,css=U.css,defined=U.defined,discardElement=U.discardElement,extend=U.extend,fireEvent=U.fireEvent,isArray=U.isArray,isNumber=U.isNumber,isString=U.isString,merge=U.merge,pick=U.pick,splat=U.splat,syncTimeout=U.syncTimeout,timeUnits=U.timeUnits,Tooltip=function(){function t(t,e){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=t,this.init(t,e)}return t.prototype.applyFilter=function(){var t=this.chart;t.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+t.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},t.prototype.bodyFormatter=function(t){return t.map(function(t){var e=t.series.tooltipOptions;return(e[(t.point.formatPrefix||"point")+"Formatter"]||t.point.tooltipFormatter).call(t.point,e[(t.point.formatPrefix||"point")+"Format"]||"")})},t.prototype.cleanSplit=function(o){this.chart.series.forEach(function(t){var e=t&&t.tt;e&&(!e.isActive||o?t.tt=e.destroy():e.isActive=!1)})},t.prototype.defaultFormatter=function(t){var e=this.points||splat(this),o=[t.tooltipFooterHeaderFormatter(e[0])];return(o=o.concat(t.bodyFormatter(e))).push(t.tooltipFooterHeaderFormatter(e[0],!0)),o},t.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement(this.container)),U.clearTimeout(this.hideTimer),U.clearTimeout(this.tooltipTimeout)},t.prototype.getAnchor=function(t,e){var o,i,r,s=this.chart,a=s.pointer,n=s.inverted,l=s.plotTop,h=s.plotLeft,c=0,p=0;return t=splat(t),this.followPointer&&e?o=[(e=void 0===e.chartX?a.normalize(e):e).chartX-h,e.chartY-l]:t[0].tooltipPos?o=t[0].tooltipPos:(t.forEach(function(t){i=t.series.yAxis,r=t.series.xAxis,c+=t.plotX||0,p+=t.plotLow?(t.plotLow+(t.plotHigh||0))/2:t.plotY||0,r&&i&&(n?(c+=l+s.plotHeight-r.len-r.pos,p+=h+s.plotWidth-i.len-i.pos):(c+=r.pos-h,p+=i.pos-l))}),c/=t.length,p/=t.length,o=[n?s.plotWidth-p:c,n?s.plotHeight-c:p],this.shared&&1<t.length&&e&&(n?o[0]=e.chartX-h:o[1]=e.chartY-l)),o.map(Math.round)},t.prototype.getDateFormat=function(t,e,o,i){var r,s,a=this.chart.time,n=a.dateFormat("%m-%d %H:%M:%S.%L",e),l="01-01 00:00:00.000",h={millisecond:15,second:12,minute:9,hour:6,day:3},c="millisecond";for(s in timeUnits){if(t===timeUnits.week&&+a.dateFormat("%w",e)===o&&n.substr(6)===l.substr(6)){s="week";break}if(timeUnits[s]>t){s=c;break}if(h[s]&&n.substr(h[s])!==l.substr(h[s]))break;"week"!==s&&(c=s)}return r=s?a.resolveDTLFormat(i[s]).main:r},t.prototype.getLabel=function(){var e,t,o,i,r,s,a=this,n=this.chart.renderer,l=this.chart.styledMode,h=this.options,c="tooltip"+(defined(h.className)?" "+h.className:""),p=h.style&&h.style.pointerEvents||(!this.followPointer&&h.stickOnContact?"auto":"none");return this.label||(this.outside&&(t=this.chart.options.chart.style,o=RendererRegistry.getRendererType(),this.container=e=H.doc.createElement("div"),e.className="highcharts-tooltip-container",css(e,{position:"absolute",top:"1px",pointerEvents:p,zIndex:Math.max(this.options.style&&this.options.style.zIndex||0,(t&&t.zIndex||0)+3)}),H.doc.body.appendChild(e),this.renderer=n=new o(e,0,0,t,void 0,void 0,n.styledMode)),this.split?this.label=n.g(c):(this.label=n.label("",0,0,h.shape||"callout",null,null,h.useHTML,null,c).attr({padding:h.padding,r:h.borderRadius}),l||this.label.attr({fill:h.backgroundColor,"stroke-width":h.borderWidth}).css(h.style).css({pointerEvents:p}).shadow(h.shadow)),l&&h.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),a.outside&&!a.split&&(i=this.label,r=i.xSetter,s=i.ySetter,i.xSetter=function(t){r.call(i,a.distance),e.style.left=t+"px"},i.ySetter=function(t){s.call(i,a.distance),e.style.top=t+"px"}),this.label.on("mouseenter",function(){a.inContact=!0}).on("mouseleave",function(){var t=a.chart.hoverSeries;a.inContact=!1,t&&t.onMouseOut&&t.onMouseOut()}).attr({zIndex:8}).add()),this.label},t.prototype.getPosition=function(o,i,r){function d(t){return t*h.scaleX}function u(t){return t*h.scaleY}function t(t){var e="x"===t;return[t,e?n:l,e?o:i].concat(y?[e?d(o):u(i),e?h.left-f+d(r.plotX+a.plotLeft):h.top-f+u(r.plotY+a.plotTop),0,e?n:l]:[e?o:i,e?r.plotX+a.plotLeft:r.plotY+a.plotTop,e?a.plotLeft:a.plotTop,e?a.plotLeft+a.plotWidth:a.plotTop+a.plotHeight])}function e(t){var e=c;c=p,p=e,s=t}var s,a=this.chart,f=this.distance,m={},g=a.inverted&&r.h||0,y=this.outside,n=y?doc.documentElement.clientWidth-2*f:a.chartWidth,l=y?Math.max(doc.body.scrollHeight,doc.documentElement.scrollHeight,doc.body.offsetHeight,doc.documentElement.offsetHeight,doc.documentElement.clientHeight):a.chartHeight,h=a.pointer.getChartPosition(),c=t("y"),p=t("x"),x=!this.followPointer&&pick(r.ttBelow,!a.inverted==!!r.negative),b=function(){!1!==function(t,e,o,i,r,s,a){var n=y?("y"===t?u:d)(f):f,l=(o-i)/2,h=i<r-f,c=r+f+i<e,p=r-n-o+l,l=r+n-l;if(x&&c)m[t]=l;else if(!x&&h)m[t]=p;else if(h)m[t]=Math.min(a-i,p-g<0?p:p-g);else{if(!c)return!1;m[t]=Math.max(s,e<l+g+o?l:l+g)}}.apply(0,c)?!1!==function(t,e,o,i,r){var s;return r<f||e-f<r?s=!1:m[t]=r<o/2?1:e-i/2<r?e-i-2:r-o/2,s}.apply(0,p)||s||(e(!0),b()):s?m.x=m.y=0:(e(!0),b())};return(a.inverted||1<this.len)&&e(),b(),m},t.prototype.getXDateFormat=function(t,e,o){var i=e.dateTimeLabelFormats,e=o&&o.closestPointRange,o=e?this.getDateFormat(e,t.x,o.options.startOfWeek,i):i.day;return o||i.year},t.prototype.hide=function(t){var e=this;U.clearTimeout(this.hideTimer),t=pick(t,this.options.hideDelay,500),this.isHidden||(this.hideTimer=syncTimeout(function(){e.getLabel().fadeOut(t&&void 0),e.isHidden=!0},t))},t.prototype.init=function(t,e){this.chart=t,this.options=e,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=e.split&&!t.inverted&&!t.polar,this.shared=e.shared||this.split,this.outside=pick(e.outside,Boolean(t.scrollablePixelsX||t.scrollablePixelsY))},t.prototype.isStickyOnContact=function(){return!(this.followPointer||!this.options.stickOnContact||!this.inContact)},t.prototype.move=function(t,e,o,i){var r=this,s=r.now,a=!1!==r.options.animation&&!r.isHidden&&(1<Math.abs(t-s.x)||1<Math.abs(e-s.y)),n=r.followPointer||1<r.len;extend(s,{x:a?(2*s.x+t)/3:t,y:a?(s.y+e)/2:e,anchorX:n?void 0:a?(2*s.anchorX+o)/3:o,anchorY:n?void 0:a?(s.anchorY+i)/2:i}),r.getLabel().attr(s),r.drawTracker(),a&&(U.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){r&&r.move(t,e,o,i)},32))},t.prototype.refresh=function(t,e){var o,i,r,s=this,a=this.chart,n=s.options,l=splat(t),h=l[0],c={},p=[],d=n.formatter||s.defaultFormatter,u=s.shared,f=a.styledMode;if(n.enabled){U.clearTimeout(this.hideTimer),s.followPointer=!s.split&&h.series.tooltipOptions.followPointer,o=(r=s.getAnchor(t,e))[0],i=r[1],!u||!isArray(t)&&t.series&&t.series.noSharedTooltip?c=h.getLabelConfig():(a.pointer.applyInactiveState(l),l.forEach(function(t){t.setState("hover"),p.push(t.getLabelConfig())}),(c={x:h.category,y:h.y}).points=p),this.len=p.length;t=d.call(c,s),d=h.series;if(this.distance=pick(d.tooltipOptions.distance,16),!1===t)this.hide();else{if(s.split)this.renderSplit(t,l);else{c=o,l=i;if(e&&a.pointer.isDirectTouch&&(c=e.chartX-a.plotLeft,l=e.chartY-a.plotTop),!a.polar&&!1!==d.options.clip&&!d.shouldShowTooltip(c,l))return void s.hide();l=s.getLabel();n.style.width&&!f||l.css({width:this.chart.spacingBox.width+"px"}),l.attr({text:t&&t.join?t.join(""):t}),l.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick(h.colorIndex,d.colorIndex)),f||l.attr({stroke:n.borderColor||h.color||d.color||palette.neutralColor60}),s.updatePosition({plotX:o,plotY:i,negative:h.negative,ttBelow:h.ttBelow,h:r[2]||0})}s.isHidden&&s.label&&s.label.attr({opacity:1}).show(),s.isHidden=!1}fireEvent(this,"refresh")}},t.prototype.renderSplit=function(t,u){var f,m=this,e=m.chart,o=m.chart,i=o.chartWidth,r=o.chartHeight,g=o.plotHeight,y=o.plotLeft,x=o.plotTop,s=o.pointer,a=o.scrollablePixelsY,n=void 0===a?0:a,l=o.scrollablePixelsX,h=o.scrollingContainer,a=void 0===h?{scrollLeft:0,scrollTop:0}:h,h=a.scrollLeft,a=a.scrollTop,b=o.styledMode,v=m.distance,w=m.options,T=m.options.positioner,k=m.outside&&"number"!=typeof l?doc.documentElement.getBoundingClientRect():{left:h,right:h+i,top:a,bottom:a+r},M=m.getLabel(),F=this.renderer||e.renderer,X=Boolean(e.xAxis[0]&&e.xAxis[0].opposite),i=s.getChartPosition(),c=i.left,r=i.top,C=x+a,P=g-n;function S(t,e,o,i,r){var s,a;return void 0===r&&(r=!0),{x:a=o?(s=X?0:P,clamp(t-i/2,k.left,k.right-i-(m.outside?c:0))):(s=e-C,clamp(a=r?t-i-v:t+v,r?a:k.left,k.right)),y:s}}e=(t=isString(t)?[!1,t]:t).slice(0,u.length+1).reduce(function(t,e,o){var i,r,s,a,n,l,h,c,p,d;return!1!==e&&""!==e&&(d=(p=(e=(d=(r=(i=u[o-1]||{isHeader:!0,plotX:u[0].plotX,plotY:g,series:{}}).isHeader)?m:i.series).tt=(n=d.tt,l=i,h=e.toString(),c=n,p=l.isHeader,o=l.series,d="highcharts-color-"+pick(l.colorIndex,o.colorIndex,"none"),c||(n={padding:w.padding,r:w.borderRadius},b||(n.fill=w.backgroundColor,n["stroke-width"]=w.borderWidth),c=F.label("",0,0,w[p?"headerShape":"shape"]||"callout",void 0,void 0,w.useHTML).addClass((p?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+d).attr(n).add(M)),c.isActive=!0,c.attr({text:h}),b||c.css(w.style).shadow(w.shadow).attr({stroke:w.borderColor||l.color||o.color||palette.neutralColor80}),c)).getBBox()).width+e.strokeWidth(),r&&(f=p.height,P+=f,X&&(C-=f)),h=(n=i).isHeader,o=void 0===(l=n.plotX)?0:l,l=void 0===(c=n.plotY)?0:c,c=n.series,h?(a=y+o,s=x+g/2):(n=c.xAxis,h=c.yAxis,a=n.pos+clamp(o,-v,n.len+v),c.shouldShowTooltip(0,h.pos-x+l,{ignoreX:!0})&&(s=h.pos+l)),a=(l={anchorX:a=clamp(a,k.left-v,k.right+v),anchorY:s}).anchorX,"number"==typeof(s=l.anchorY)?(l=p.height+1,p=T?T.call(m,d,l,i):S(a,s,r,d),t.push({align:T?0:void 0,anchorX:a,anchorY:s,boxWidth:d,point:i,rank:pick(p.rank,r?1:0),size:l,target:p.y,tt:e,x:p.x})):e.isActive=!1),t},[]);!T&&e.some(function(t){var e=(m.outside?c:0)+t.anchorX;return e<k.left&&e+t.boxWidth<k.right||e<c-k.left+t.boxWidth&&k.right-e>e})&&(e=e.map(function(t){var e=S(t.anchorX,t.anchorY,t.point.isHeader,t.boxWidth,!1),o=e.x,e=e.y;return extend(t,{target:e,x:o})})),m.cleanSplit(),H.distribute(e,P);var p={left:c,right:c};e.forEach(function(t){var e=t.x,o=t.boxWidth,t=t.isHeader;t||(m.outside&&c+e<p.left&&(p.left=c+e),!t&&m.outside&&p.left+o>p.right&&(p.right=c+e))}),e.forEach(function(t){var e=t.x,o=t.anchorX,i=t.anchorY,r=t.pos,s=t.point.isHeader,r={visibility:void 0===r?"hidden":"inherit",x:e,y:r+C,anchorX:o,anchorY:i};m.outside&&e<o&&(0<(i=c-p.left)&&(s||(r.x=e+i,r.anchorX=o+i),s&&(r.x=(p.right-p.left)/2,r.anchorX=o+i))),t.tt.attr(r)});s=m.container,i=m.outside,a=m.renderer;i&&s&&a&&(t=(n=M.getBBox()).width,e=n.height,i=n.x,n=n.y,a.setSize(t+i,e+n,!1),s.style.left=p.left+"px",s.style.top=r+"px")},t.prototype.drawTracker=function(){var t,e,o,i,r,s=this;!s.followPointer&&s.options.stickOnContact?(t=s.chart,e=s.label,r=s.shared?t.hoverPoints:t.hoverPoint,e&&r&&(o={x:0,y:0,width:0,height:0},i=this.getAnchor(r),r=e.getBBox(),i[0]+=t.plotLeft-e.translateX,i[1]+=t.plotTop-e.translateY,o.x=Math.min(0,i[0]),o.y=Math.min(0,i[1]),o.width=i[0]<0?Math.max(Math.abs(i[0]),r.width-i[0]):Math.max(Math.abs(i[0]),r.width),o.height=i[1]<0?Math.max(Math.abs(i[1]),r.height-Math.abs(i[1])):Math.max(Math.abs(i[1]),r.height),s.tracker?s.tracker.attr(o):(s.tracker=e.renderer.rect(o).addClass("highcharts-tracker").add(e),t.styledMode||s.tracker.attr({fill:"rgba(0,0,0,0)"})))):s.tracker&&s.tracker.destroy()},t.prototype.styledModeFormat=function(t){return t.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},t.prototype.tooltipFooterHeaderFormatter=function(e,t){var o=t?"footer":"header",i=e.series,r=i.tooltipOptions,s=r.xDateFormat,a=i.xAxis,n=a&&"datetime"===a.options.type&&isNumber(e.key),l=r[o+"Format"],t={isFooter:t,labelConfig:e};return fireEvent(this,"headerFormatter",t,function(t){n&&!s&&(s=this.getXDateFormat(e,r,a)),n&&s&&(e.point&&e.point.tooltipDateKeys||["key"]).forEach(function(t){l=l.replace("{point."+t+"}","{point."+t+":"+s+"}")}),i.chart.styledMode&&(l=this.styledModeFormat(l)),t.text=format(l,{point:e,series:i},this.chart)}),t.text},t.prototype.update=function(t){this.destroy(),merge(!0,this.chart.options.tooltip.userOptions,t),this.init(this.chart,merge(!0,this.options,t))},t.prototype.updatePosition=function(t){var e=this.chart,o=e.pointer,i=this.getLabel(),r=t.plotX+e.plotLeft,s=t.plotY+e.plotTop,e=o.getChartPosition(),o=(this.options.positioner||this.getPosition).call(this,i.width,i.height,t);this.outside&&(t=(this.options.borderWidth||0)+2*this.distance,this.renderer.setSize(i.width+t,i.height+t,!1),1===e.scaleX&&1===e.scaleY||(css(this.container,{transform:"scale("+e.scaleX+", "+e.scaleY+")"}),r*=e.scaleX,s*=e.scaleY),r+=e.left-o.x,s+=e.top-o.y),this.move(Math.round(o.x),Math.round(o.y||0),r,s)},t}();H.Tooltip=Tooltip;export default H.Tooltip;