"use strict";import A from"../../Core/Animation/AnimationUtilities.js";var getDeferredAnimation=A.getDeferredAnimation;import Chart from"../../Core/Chart/Chart.js";var chartProto=Chart.prototype;import ControllableMixin from"./Mixins/ControllableMixin.js";import ControllableRect from"./Controllables/ControllableRect.js";import ControllableCircle from"./Controllables/ControllableCircle.js";import ControllablePath from"./Controllables/ControllablePath.js";import ControllableImage from"./Controllables/ControllableImage.js";import ControllableLabel from"./Controllables/ControllableLabel.js";import ControlPoint from"./ControlPoint.js";import EventEmitterMixin from"./Mixins/EventEmitterMixin.js";import H from"../../Core/Globals.js";import MockPoint from"./MockPoint.js";import Pointer from"../../Core/Pointer.js";import U from"../../Core/Utilities.js";import palette from"../../Core/Color/Palette.js";var addEvent=U.addEvent,defined=U.defined,destroyObjectProperties=U.destroyObjectProperties,erase=U.erase,extend=U.extend,find=U.find,fireEvent=U.fireEvent,merge=U.merge,pick=U.pick,splat=U.splat,wrap=U.wrap,Annotation=function(){function i(t,o){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0,this.chart=t,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge(this.defaultOptions,o),this.userOptions=o,o=this.getLabelsAndShapesOptions(this.options,o),this.options.labels=o.labels,this.options.shapes=o.shapes,this.init(t,this.options)}return i.prototype.init=function(){var t=this.chart,o=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(t,o)},i.prototype.getLabelsAndShapesOptions=function(n,t){var o={};return["labels","shapes"].forEach(function(i){n[i]&&(o[i]=splat(t[i]).map(function(t,o){return merge(n[i][o],t)}))}),o},i.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(t,o){t=this.initShape(t,o);merge(!0,this.options.shapes[o],t.options)},this)},i.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(t,o){t=this.initLabel(t,o);merge(!0,this.options.labels[o],t.options)},this)},i.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},i.prototype.setClipAxes=function(){var i=this.chart.xAxis,n=this.chart.yAxis,t=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(t,o){return[i[o&&o.point&&o.point.xAxis]||t[0],n[o&&o.point&&o.point.yAxis]||t[1]]},[]);this.clipXAxis=t[0],this.clipYAxis=t[1]},i.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},i.prototype.setLabelCollector=function(){var t=this;t.labelCollector=function(){return t.labels.reduce(function(t,o){return o.options.allowOverlap||t.push(o.graphic),t},[])},t.chart.labelCollectors.push(t.labelCollector)},i.prototype.setOptions=function(t){this.options=merge(this.defaultOptions,t)},i.prototype.redraw=function(t){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,t),this.redrawItems(this.labels,t),ControllableMixin.redraw.call(this,t)},i.prototype.redrawItems=function(t,o){for(var i=t.length;i--;)this.redrawItem(t[i],o)},i.prototype.renderItems=function(t){for(var o=t.length;o--;)this.renderItem(t[o])},i.prototype.render=function(){var t=this.chart.renderer;this.graphic=t.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=t.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=t.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),ControllableMixin.render.call(this)},i.prototype.setVisibility=function(t){var o=this.options,t=pick(t,!o.visible);this.graphic.attr("visibility",t?"visible":"hidden"),t||this.setControlPointsVisibility(!1),o.visible=t},i.prototype.setControlPointsVisibility=function(o){function t(t){t.setControlPointsVisibility(o)}ControllableMixin.setControlPointsVisibility.call(this,o),this.shapes.forEach(t),this.labels.forEach(t)},i.prototype.destroy=function(){function t(t){t.destroy()}var o=this.chart;this.labels.forEach(t),this.shapes.forEach(t),this.clipXAxis=null,this.clipYAxis=null,erase(o.labelCollectors,this.labelCollector),EventEmitterMixin.destroy.call(this),ControllableMixin.destroy.call(this),destroyObjectProperties(this,o)},i.prototype.remove=function(){return this.chart.removeAnnotation(this)},i.prototype.update=function(t,o){var i=this.chart,n=this.getLabelsAndShapesOptions(this.userOptions,t),e=i.annotations.indexOf(this),t=merge(!0,this.userOptions,t);t.labels=n.labels,t.shapes=n.shapes,this.destroy(),this.constructor(i,t),i.options.annotations[e]=t,this.isUpdating=!0,pick(o,!0)&&i.redraw(),fireEvent(this,"afterUpdate"),this.isUpdating=!1},i.prototype.initShape=function(t,o){t=merge(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},t),o=new i.shapesMap[t.type](this,t,o);return o.itemType="shape",this.shapes.push(o),o},i.prototype.initLabel=function(t,o){t=merge(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},t),o=new ControllableLabel(this,t,o);return o.itemType="label",this.labels.push(o),o},i.prototype.redrawItem=function(t,o){t.linkPoints(),t.shouldBeDrawn()?(t.graphic||this.renderItem(t),t.redraw(pick(o,!0)&&t.graphic.placed),t.points.length&&this.adjustVisibility(t)):this.destroyItem(t)},i.prototype.adjustVisibility=function(t){var o=!1,i=t.graphic;t.points.forEach(function(t){!1!==t.series.visible&&!1!==t.visible&&(o=!0)}),o?"hidden"===i.visibility&&i.show():i.hide()},i.prototype.destroyItem=function(t){erase(this[t.itemType+"s"],t),t.destroy()},i.prototype.renderItem=function(t){t.render("label"===t.itemType?this.labelsGroup:this.shapesGroup)},i.ControlPoint=ControlPoint,i.MockPoint=MockPoint,i.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},i.types={},i}();merge(!0,Annotation.prototype,ControllableMixin,EventEmitterMixin,merge(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}})),H.extendAnnotation=function(t,o,i,n){extend(t.prototype,merge((o=o||Annotation).prototype,i)),t.prototype.defaultOptions=merge(t.prototype.defaultOptions,n||{})},extend(chartProto,{initAnnotation:function(t){t=new(Annotation.types[t.type]||Annotation)(this,t);return this.annotations.push(t),t},addAnnotation:function(t,o){t=this.initAnnotation(t);return this.options.annotations.push(t.options),pick(o,!0)&&(t.redraw(),t.graphic.attr({opacity:1})),t},removeAnnotation:function(o){var t=this.annotations,i="annotations"===o.coll?o:find(t,function(t){return t.options.id===o});i&&(fireEvent(i,"remove"),erase(this.options.annotations,i.options),erase(t,i),i.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(t){t.redraw(),t.graphic.animate({opacity:1},t.animationConfig)})}}),chartProto.collectionsWithUpdate.push("annotations"),chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation],addEvent(Chart,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])}),chartProto.callbacks.push(function(f){f.plotBoxClip=this.renderer.clipRect(this.plotBox),f.controlPointsGroup=f.renderer.g("control-points").attr({zIndex:99}).clip(f.plotBoxClip).add(),f.options.annotations.forEach(function(o,t){var i;f.annotations.some(function(t){return t.options===o})||(i=f.initAnnotation(o),f.options.annotations[t]=i.options)}),f.drawAnnotations(),addEvent(f,"redraw",f.drawAnnotations),addEvent(f,"destroy",function(){f.plotBoxClip.destroy(),f.controlPointsGroup.destroy()}),addEvent(f,"exportData",function(l){var t=f.annotations,o=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,i=!l.dataRows[1].xValues,n=f.options.lang&&f.options.lang.exportData&&f.options.lang.exportData.annotationHeader,p=l.dataRows[0].length,h=f.options.exporting&&f.options.exporting.csv&&f.options.exporting.csv.annotations&&f.options.exporting.csv.annotations.itemDelimiter,c=f.options.exporting&&f.options.exporting.csv&&f.options.exporting.csv.annotations&&f.options.exporting.csv.annotations.join;t.forEach(function(t){t.options.labelOptions.includeInDataExport&&t.labels.forEach(function(t){var a;t.options.text&&(a=t.options.text,t.points.forEach(function(t){var i=t.x,n=t.series.xAxis?t.series.xAxis.options.index:-1,e=!1;if(-1===n){for(var o=l.dataRows[0].length,s=new Array(o),r=0;r<o;++r)s[r]="";s.push(a),s.xValues=[],s.xValues[n]=i,l.dataRows.push(s),e=!0}if(e||l.dataRows.forEach(function(t,o){!e&&t.xValues&&void 0!==n&&i===t.xValues[n]&&(c&&t.length>p?t[t.length-1]+=h+a:t.push(a),e=!0)}),!e){for(o=l.dataRows[0].length,s=new Array(o),r=0;r<o;++r)s[r]="";s[0]=i,s.push(a),s.xValues=[],void 0!==n&&(s.xValues[n]=i),l.dataRows.push(s)}}))})});var e=0;l.dataRows.forEach(function(t){e=Math.max(e,t.length)});for(var s,r,a=e-l.dataRows[0].length,d=0;d<a;d++){var u=(s=d+1,r=void 0,o&&!1!==(r=o(s))?r:(r=n+" "+s,i?{columnTitle:r,topLevelColumnTitle:r}:r));i?(l.dataRows[0].push(u.topLevelColumnTitle),l.dataRows[1].push(u.columnTitle)):l.dataRows[0].push(u)}})}),wrap(Pointer.prototype,"onContainerMouseDown",function(t){this.chart.hasDraggedAnnotation||t.apply(this,Array.prototype.slice.call(arguments,1))});export default H.Annotation=Annotation;