"use strict";import A from"../Core/Animation/AnimationUtilities.js";var animObject=A.animObject;import Axis from"../Core/Axis/Axis.js";import Chart from"../Core/Chart/Chart.js";import Color from"../Core/Color/Color.js";import ColumnSeries from"../Series/Column/ColumnSeries.js";import F from"../Core/FormatUtilities.js";var format=F.format;import H from"../Core/Globals.js";var noop=H.noop;import D from"../Core/DefaultOptions.js";var defaultOptions=D.defaultOptions;import palette from"../Core/Color/Palette.js";import Point from"../Core/Series/Point.js";import Series from"../Core/Series/Series.js";import SeriesRegistry from"../Core/Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import SVGRenderer from"../Core/Renderer/SVG/SVGRenderer.js";import Tick from"../Core/Axis/Tick.js";import U from"../Core/Utilities.js";var addEvent=U.addEvent,removeEvent=U.removeEvent,extend=U.extend,fireEvent=U.fireEvent,merge=U.merge,objectEach=U.objectEach,pick=U.pick,syncTimeout=U.syncTimeout;import"../Series/Column/ColumnSeries.js";var PieSeries=seriesTypes.pie,ddSeriesId=1;extend(defaultOptions.lang,{drillUpText:"◁ Back to {series.name}"}),defaultOptions.drilldown={activeAxisLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},activeDataLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},animation:{duration:500},drillUpButton:{position:{align:"right",x:-10,y:10}}},SVGRenderer.prototype.Element.prototype.fadeIn=function(e){this.attr({opacity:.1,visibility:"inherit"}).animate({opacity:pick(this.newOpacity,1)},e||{duration:250})},Chart.prototype.addSeriesAsDrilldown=function(e,t){this.addSingleSeriesAsDrilldown(e,t),this.applyDrilldown()},Chart.prototype.addSingleSeriesAsDrilldown=function(e,t){var i,o,r,n=e.series,s=n.xAxis,l=n.yAxis,a=[],d=[],p=this.styledMode?{colorIndex:pick(e.colorIndex,n.colorIndex)}:{color:e.color||n.color};this.drilldownLevels||(this.drilldownLevels=[]),o=n.options._levelNumber||0,(r=this.drilldownLevels[this.drilldownLevels.length-1])&&r.levelNumber!==o&&(r=void 0),t=extend(extend({_ddSeriesId:ddSeriesId++},p),t),i=n.points.indexOf(e),n.chart.series.forEach(function(e){e.xAxis!==s||e.isDrilling||(e.options._ddSeriesId=e.options._ddSeriesId||ddSeriesId++,e.options._colorIndex=e.userOptions._colorIndex,e.options._levelNumber=e.options._levelNumber||o,r?(a=r.levelSeries,d=r.levelSeriesOptions):(a.push(e),e.purgedOptions=merge({_ddSeriesId:e.options._ddSeriesId,_levelNumber:e.options._levelNumber,selected:e.options.selected},e.userOptions),d.push(e.purgedOptions)))}),p=extend({levelNumber:o,seriesOptions:n.options,seriesPurgedOptions:n.purgedOptions,levelSeriesOptions:d,levelSeries:a,shapeArgs:e.shapeArgs,bBox:e.graphic?e.graphic.getBBox():{},color:e.isNull?new Color(p.color).setOpacity(0).get():p.color,lowerSeriesOptions:t,pointOptions:n.options.data[i],pointIndex:i,oldExtremes:{xMin:s&&s.userMin,xMax:s&&s.userMax,yMin:l&&l.userMin,yMax:l&&l.userMax},resetZoomButton:this.resetZoomButton},p),this.drilldownLevels.push(p),s&&s.names&&(s.names.length=0),(t=p.lowerSeries=this.addSeries(t,!1)).options._levelNumber=o+1,s&&(s.oldPos=s.pos,s.userMin=s.userMax=null,l.userMin=l.userMax=null),n.type===t.type&&(t.animate=t.animateDrilldown||noop,t.options.animation=!0)},Chart.prototype.applyDrilldown=function(){var t,e=this.drilldownLevels;e&&0<e.length&&(t=e[e.length-1].levelNumber,this.drilldownLevels.forEach(function(e){e.levelNumber===t&&e.levelSeries.forEach(function(e){e.options&&e.options._levelNumber===t&&e.remove(!1)})})),this.resetZoomButton&&(this.resetZoomButton.hide(),delete this.resetZoomButton),this.pointer.reset(),this.redraw(),this.showDrillUpButton(),fireEvent(this,"afterDrilldown")},Chart.prototype.getDrilldownBackText=function(){var e=this.drilldownLevels;if(e&&0<e.length)return(e=e[e.length-1]).series=e.seriesOptions,format(this.options.lang.drillUpText,e)},Chart.prototype.showDrillUpButton=function(){var e,t,i=this,o=this.getDrilldownBackText(),r=i.options.drilldown.drillUpButton,n="chart"===r.relativeTo||"spacingBox"===r.relativeTo?null:"scrollablePlotBox";this.drillUpButton?this.drillUpButton.attr({text:o}).align():(t=(e=r.theme)&&e.states,this.drillUpButton=this.renderer.button(o,null,null,function(){i.drillUp()},e,t&&t.hover,t&&t.select).addClass("highcharts-drillup-button").attr({align:r.position.align,zIndex:7}).add().align(r.position,!1,n))},Chart.prototype.drillUp=function(){if(this.drilldownLevels&&0!==this.drilldownLevels.length){for(var e,o,r,n,t,s=this,i=s.drilldownLevels,l=i[i.length-1].levelNumber,a=i.length,d=s.series,p=function(t){var i;d.forEach(function(e){e.options._ddSeriesId===t._ddSeriesId&&(i=e)}),(i=i||s.addSeries(t,!1)).type===r.type&&i.animateDrillupTo&&(i.animate=i.animateDrillupTo),t===o.seriesPurgedOptions&&(n=i)};a--;)if((o=i[a]).levelNumber===l){if(i.pop(),!(r=o.lowerSeries).chart)for(e=d.length;e--;)if(d[e].options.id===o.lowerSeriesOptions.id&&d[e].options._levelNumber===l+1){r=d[e];break}r.xData=[],o.levelSeriesOptions.forEach(p),fireEvent(s,"drillup",{seriesOptions:o.seriesPurgedOptions||o.seriesOptions}),this.resetZoomButton&&this.resetZoomButton.destroy(),n.type===r.type&&(n.drilldownLevel=o,n.options.animation=s.options.drilldown.animation,r.animateDrillupFrom&&r.chart&&r.animateDrillupFrom(o)),n.options._levelNumber=l,r.remove(!1),n.xAxis&&(t=o.oldExtremes,n.xAxis.setExtremes(t.xMin,t.xMax,!1),n.yAxis.setExtremes(t.yMin,t.yMax,!1)),o.resetZoomButton&&(s.resetZoomButton=o.resetZoomButton,s.resetZoomButton.show())}this.redraw(),0===this.drilldownLevels.length?this.drillUpButton=this.drillUpButton.destroy():this.drillUpButton.attr({text:this.getDrilldownBackText()}).align(),this.ddDupes.length=[],fireEvent(s,"drillupall")}},addEvent(Chart,"afterInit",function(){var i=this;i.drilldown={update:function(e,t){merge(!0,i.options.drilldown,e),pick(t,!0)&&i.redraw()}}}),addEvent(Chart,"afterShowResetZoom",function(){var e=this,t=e.resetZoomButton&&e.resetZoomButton.getBBox(),e=e.options.drilldown&&e.options.drilldown.drillUpButton;this.drillUpButton&&t&&e&&e.position&&e.position.x&&this.drillUpButton.align({x:e.position.x-t.width-10,y:e.position.y,align:e.position.align},!1,e.relativeTo||"plotBox")}),addEvent(Chart,"render",function(){(this.xAxis||[]).forEach(function(n){n.ddPoints={},n.series.forEach(function(e){for(var t,i=e.xData||[],o=e.points,r=0;r<i.length;r++)"number"!=typeof(t=e.options.data[r])&&(t=e.pointClass.prototype.optionsToObject.call({series:e},t)).drilldown&&(n.ddPoints[i[r]]||(n.ddPoints[i[r]]=[]),t=r-(e.cropStart||0),n.ddPoints[i[r]].push(!(o&&0<=t&&t<o.length)||o[t]))}),objectEach(n.ticks,Tick.prototype.drillable)})}),ColumnSeries.prototype.animateDrillupTo=function(e){var i,o;e||(o=(i=this).drilldownLevel,this.points.forEach(function(e){var t=e.dataLabel;e.graphic&&e.graphic.hide(),t&&(t.hidden="hidden"===t.attr("visibility"),t.hidden||(t.hide(),e.connector&&e.connector.hide()))}),syncTimeout(function(){var t;i.points&&(t=[],i.data.forEach(function(e){t.push(e)}),(t=i.nodes?t.concat(i.nodes):t).forEach(function(e,t){var i=t===(o&&o.pointIndex)?"show":"fadeIn",t=e.dataLabel;e.graphic&&e.graphic[i]("show"==i||void 0),t&&!t.hidden&&(t.fadeIn(),e.connector&&e.connector.fadeIn())}))},Math.max(this.chart.options.drilldown.animation.duration-50,0)),delete this.animate)},ColumnSeries.prototype.animateDrilldown=function(e){var i,o=this,t=this.chart,r=t.drilldownLevels,n=animObject(t.options.drilldown.animation),s=this.xAxis,l=t.styledMode;e||(r.forEach(function(e){o.options._ddSeriesId===e.lowerSeriesOptions._ddSeriesId&&(i=e.shapeArgs,l||(i.fill=e.color))}),i.x+=pick(s.oldPos,s.pos)-s.pos,this.points.forEach(function(e){var t=e.shapeArgs;l||(t.fill=e.color),e.graphic&&e.graphic.attr(i).animate(extend(e.shapeArgs,{fill:e.color||o.color}),n),e.dataLabel&&e.dataLabel.fadeIn(n)}),delete this.animate)},ColumnSeries.prototype.animateDrillupFrom=function(r){var n=animObject(this.chart.options.drilldown.animation),s=this.group,l=s!==this.chart.columnGroup,a=this;a.trackerGroups.forEach(function(e){a[e]&&a[e].on("mouseover")}),l&&delete this.group,this.points.forEach(function(e){function t(){i.destroy(),s&&l&&(s=s.destroy())}var i=e.graphic,o=r.shapeArgs;i&&o&&(delete e.graphic,a.chart.styledMode||(o.fill=r.color),n.duration?i.animate(o,merge(n,{complete:t})):(i.attr(o),t()))})},PieSeries&&extend(PieSeries.prototype,{animateDrillupTo:ColumnSeries.prototype.animateDrillupTo,animateDrillupFrom:ColumnSeries.prototype.animateDrillupFrom,animateDrilldown:function(e){var o,r,n,s,l=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],a=this.chart.options.drilldown.animation;this.is("item")&&(a.duration=0),this.center&&(o=l.shapeArgs,r=o.start,n=(o.end-r)/this.points.length,s=this.chart.styledMode,e||(this.points.forEach(function(e,t){var i=e.shapeArgs;s||(o.fill=l.color,i.fill=e.color),e.graphic&&e.graphic.attr(merge(o,{start:r+t*n,end:r+(t+1)*n}))[a?"animate":"attr"](i,a)}),delete this.animate))}}),Point.prototype.doDrilldown=function(){this.runDrilldown()},Point.prototype.runDrilldown=function(o,e,t){var i,r=this.series.chart,n=r.options.drilldown,s=(n.series||[]).length;for(r.ddDupes||(r.ddDupes=[]);s--&&!i;)n.series[s].id===this.drilldown&&-1===r.ddDupes.indexOf(this.drilldown)&&(i=n.series[s],r.ddDupes.push(this.drilldown));fireEvent(r,"drilldown",{point:this,seriesOptions:i,category:e,originalEvent:t,points:void 0!==e&&this.series.xAxis.getDDPoints(e).slice(0)},function(e){var t=e.point.series&&e.point.series.chart,i=e.seriesOptions;t&&i&&(o?t.addSingleSeriesAsDrilldown(e.point,i):t.addSeriesAsDrilldown(e.point,i))})},Axis.prototype.drilldownCategory=function(t,i){this.getDDPoints(t).forEach(function(e){e&&e.series&&e.series.visible&&e.runDrilldown&&e.runDrilldown(!0,t,i)}),this.chart.applyDrilldown()},Axis.prototype.getDDPoints=function(e){return this.ddPoints&&this.ddPoints[e]||[]},Tick.prototype.drillable=function(){var t=this.pos,e=this.label,i=this.axis,o="xAxis"===i.coll&&i.getDDPoints,r=o&&i.getDDPoints(t),n=i.chart.styledMode;o&&(e&&r&&r.length?(e.drillable=!0,e.basicStyles||n||(e.basicStyles=merge(e.styles)),e.addClass("highcharts-drilldown-axis-label"),e.removeOnDrillableClick&&removeEvent(e.element,"click"),e.removeOnDrillableClick=addEvent(e.element,"click",function(e){e.preventDefault(),i.drilldownCategory(t,e)}),n||e.css(i.chart.options.drilldown.activeAxisLabelStyle)):e&&e.drillable&&e.removeOnDrillableClick&&(n||(e.styles={},e.css(e.basicStyles)),e.removeOnDrillableClick(),e.removeClass("highcharts-drilldown-axis-label")))},addEvent(Point,"afterInit",function(){var e=this;return e.drilldown&&!e.unbindDrilldownClick&&(e.unbindDrilldownClick=addEvent(e,"click",handlePointClick)),e}),addEvent(Point,"update",function(e){var t=this,e=e.options||{};e.drilldown&&!t.unbindDrilldownClick?t.unbindDrilldownClick=addEvent(t,"click",handlePointClick):!e.drilldown&&void 0!==e.drilldown&&t.unbindDrilldownClick&&(t.unbindDrilldownClick=t.unbindDrilldownClick())});var handlePointClick=function(e){var t=this.series;t.xAxis&&!1===t.chart.options.drilldown.allowPointDrilldown?t.xAxis.drilldownCategory(this.x,e):this.runDrilldown(void 0,void 0,e)};addEvent(Series,"afterDrawDataLabels",function(){var o=this.chart.options.drilldown.activeDataLabelStyle,r=this.chart.renderer,n=this.chart.styledMode;this.points.forEach(function(e){var t=e.options.dataLabels,i=pick(e.dlOptions,t&&t.style,{});e.drilldown&&e.dataLabel&&("contrast"!==o.color||n||(i.color=r.getContrast(e.color||this.color)),t&&t.color&&(i.color=t.color),e.dataLabel.addClass("highcharts-drilldown-data-label"),n||e.dataLabel.css(o).css(i))},this)});var applyCursorCSS=function(e,t,i,o){e[i?"addClass":"removeClass"]("highcharts-drilldown-point"),o||e.css({cursor:t})};addEvent(Series,"afterDrawTracker",function(){var t=this.chart.styledMode;this.points.forEach(function(e){e.drilldown&&e.graphic&&applyCursorCSS(e.graphic,"pointer",!0,t)})}),addEvent(Point,"afterSetState",function(){var e=this.series.chart.styledMode;this.drilldown&&this.series.halo&&"hover"===this.state?applyCursorCSS(this.series.halo,"pointer",!0,e):this.series.halo&&applyCursorCSS(this.series.halo,"auto",!1,e)}),addEvent(Chart,"selection",function(e){!0!==e.resetSelection||!this.drillUpButton||(e=this.options.drilldown&&this.options.drilldown.drillUpButton)&&e.position&&this.drillUpButton.align({x:e.position.x,y:e.position.y,align:e.position.align},!1,e.relativeTo||"plotBox")}),addEvent(Chart,"drillup",function(){this.resetZoomButton&&(this.resetZoomButton=this.resetZoomButton.destroy())});