"use strict";import Axis from"../Core/Axis/Axis.js";import Chart from"../Core/Chart/Chart.js";import AST from"../Core/Renderer/HTML/AST.js";import H from"../Core/Globals.js";var doc=H.doc,seriesTypes=H.seriesTypes,win=H.win;import D from"../Core/DefaultOptions.js";var getOptions=D.getOptions,setOptions=D.setOptions;import U from"../Core/Utilities.js";var addEvent=U.addEvent,defined=U.defined,extend=U.extend,find=U.find,fireEvent=U.fireEvent,isNumber=U.isNumber,pick=U.pick;import DownloadURL from"../Extensions/DownloadURL.js";var downloadURL=DownloadURL.downloadURL;function getBlobFromContent(t,e){var a=win.navigator,o=-1<a.userAgent.indexOf("WebKit")&&a.userAgent.indexOf("Chrome")<0,i=win.URL||win.webkitURL||win;try{if(a.msSaveOrOpenBlob&&win.MSBlobBuilder){var n=new win.MSBlobBuilder;return n.append(t),n.getBlob("image/svg+xml")}if(!o)return i.createObjectURL(new win.Blob(["\ufeff"+t],{type:e}))}catch(t){}}setOptions({exporting:{csv:{annotations:{itemDelimiter:"; ",join:!1},columnHeaderFormatter:null,dateFormat:"%Y-%m-%d %H:%M:%S",decimalPoint:null,itemDelimiter:null,lineDelimiter:"\n"},showTable:!1,useMultiLevelHeaders:!0,useRowspanHeaders:!0},lang:{downloadCSV:"Download CSV",downloadXLS:"Download XLS",exportData:{annotationHeader:"Annotations",categoryHeader:"Category",categoryDatetimeHeader:"DateTime"},viewData:"View data table",hideData:"Hide data table"}}),addEvent(Chart,"render",function(){this.options&&this.options.exporting&&this.options.exporting.showTable&&!this.options.chart.forExport&&!this.dataTableDiv&&this.viewData()}),Chart.prototype.setUpKeyToAxis=function(){seriesTypes.arearange&&(seriesTypes.arearange.prototype.keyToAxis={low:"y",high:"y"}),seriesTypes.gantt&&(seriesTypes.gantt.prototype.keyToAxis={start:"x",end:"x"})},Chart.prototype.getDataRows=function(i){function e(t,e,a){if(b.columnHeaderFormatter){var o=b.columnHeaderFormatter(t,e,a);if(!1!==o)return o}return t?t instanceof Axis?t.options.title&&t.options.title.text||(t.dateTime?d:c):i?{columnTitle:1<a?e:t.name,topLevelColumnTitle:t.name}:t.name+(1<a?" ("+e+")":""):c}function x(a,t,o){var i={},n={};return t.forEach(function(t){var e=(a.keyToAxis&&a.keyToAxis[t]||t)+"Axis",e=isNumber(o)?a.chart[e][o]:a[e];i[t]=e&&e.categories||[],n[t]=e&&e.dateTime}),{categoryMap:i,dateTimeValueAxisMap:n}}var a,t,o,n,r,s,l,f=this.hasParallelCoordinates,g=this.time,b=this.options.exporting&&this.options.exporting.csv||{},y=this.xAxis,v={},p=[],T=[],w=[],h=this.options.lang.exportData,c=h.categoryHeader,d=h.categoryDatetimeHeader,D=[],C=0;for(n in this.setUpKeyToAxis(),this.series.forEach(function(r){var s,l,t=r.options.keys,p=r.xAxis,h=t||function(t,e){if(!t.data.filter(function(t){return void 0!==t.y&&t.name}).length||!e||e.categories||t.keyToAxis)return t.pointArrayMap||["y"];if(t.pointArrayMap&&t.pointArrayMap.filter(function(t){return"x"===t}).length)return t.pointArrayMap.unshift("x"),t.pointArrayMap;return["x","y"]}(r,p),c=h.length,d=!r.requireSorting&&{},m=y.indexOf(p),u=x(r,h);if(!1!==r.options.includeInDataExport&&!r.options.isInternal&&!1!==r.visible){for(find(D,function(t){return t[0]===m})||D.push([m,C]),l=0;l<c;)o=e(r,h[l],h.length),w.push(o.columnTitle||o),i&&T.push(o.topLevelColumnTitle||o),l++;s={chart:r.chart,autoIncrement:r.autoIncrement,options:r.options,pointArrayMap:r.pointArrayMap},r.options.data.forEach(function(t,e){var a,o,i,n;for(f&&(u=x(r,h,e)),r.pointClass.prototype.applyOptions.apply(n={series:s},[t]),a=n.x,t=r.data[e]&&r.data[e].name,l=0,(!p||"name"===r.exportKey||!f&&p&&p.hasNames&&t)&&(a=t),d&&(d[a]&&(a+="|"+e),d[a]=!0),v[a]||(v[a]=[],v[a].xValues=[]),v[a].x=n.x,v[a].name=t,v[a].xValues[m]=n.x;l<c;)o=h[l],v[a][C+l]=pick(u.categoryMap[o][i=n[o]],u.dateTimeValueAxisMap[o]?g.dateFormat(b.dateFormat,i):null,i),l++}),C+=l}}),v)Object.hasOwnProperty.call(v,n)&&p.push(v[n]);for(t=i?[T,w]:[w],C=D.length;C--;)s=D[C][0],l=D[C][1],a=y[s],p.sort(function(t,e){return t.xValues[s]-e.xValues[s]}),r=e(a),t[0].splice(l,0,r),i&&t[1]&&t[1].splice(l,0,r),p.forEach(function(t){var e=t.name;a&&!defined(e)&&(e=a.dateTime?(t.x instanceof Date&&(t.x=t.x.getTime()),g.dateFormat(b.dateFormat,t.x)):a.categories?pick(a.names[t.x],a.categories[t.x],t.x):t.x),t.splice(l,0,e)});return t=t.concat(p),fireEvent(this,"exportData",{dataRows:t}),t},Chart.prototype.getCSV=function(t){var i="",n=this.getDataRows(),e=this.options.exporting.csv,r=pick(e.decimalPoint,","!==e.itemDelimiter&&t?1.1.toLocaleString()[1]:"."),s=pick(e.itemDelimiter,","===r?";":","),l=e.lineDelimiter;return n.forEach(function(t,e){for(var a="",o=t.length;o--;)"number"==typeof(a="string"==typeof(a=t[o])?'"'+a+'"':a)&&"."!==r&&(a=a.toString().replace(".",r)),t[o]=a;i+=t.join(s),e<n.length-1&&(i+=l)}),i},Chart.prototype.getTable=function(t){var e=function(t){if(!t.tagName||"#text"===t.tagName)return t.textContent||"";var a=t.attributes,o="<"+t.tagName;return a&&Object.keys(a).forEach(function(t){var e=a[t];o+=" "+t+'="'+e+'"'}),o+=">",o+=t.textContent||"",(t.children||[]).forEach(function(t){o+=e(t)}),o+="</"+t.tagName+">"},t=this.getTableAST(t);return e(t)},Chart.prototype.getTableAST=function(t){function h(t,e,a,o){var i=pick(o,""),e="text"+(e?" "+e:"");return"number"==typeof i?(i=i.toString(),","===n&&(i=i.replace(".",n)),e="number"):o||(e="empty"),{tagName:t,attributes:a=extend({class:e},a),textContent:i}}var o=0,e=[],c=this.options,n=t?1.1.toLocaleString()[1]:".",d=pick(c.exporting.useMultiLevelHeaders,!0),a=this.getDataRows(d),i=d?a.shift():null,t=a.shift();!1!==c.exporting.tableCaption&&e.push({tagName:"caption",attributes:{class:"highcharts-table-caption"},textContent:pick(c.exporting.tableCaption,c.title.text||"Chart")});for(var r=0,s=a.length;r<s;++r)a[r].length>o&&(o=a[r].length);e.push(function(t,e,a){var o,i=[],n=0,r=a||e&&e.length,s=0;if(d&&t&&e&&!function(t,e){var a=t.length;if(e.length!==a)return!1;for(;a--;)if(t[a]!==e[a])return!1;return!0}(t,e)){for(var l,p=[];n<r;++n)(l=t[n])===t[n+1]?++s:s?(p.push(h("th","highcharts-table-topheading",{scope:"col",colspan:s+1},l)),s=0):(l===e[n]?c.exporting.useRowspanHeaders?(o=2,delete e[n]):(o=1,e[n]=""):o=1,l=h("th","highcharts-table-topheading",{scope:"col"},l),1<o&&l.attributes&&(l.attributes.valign="top",l.attributes.rowspan=o),p.push(l));i.push({tagName:"tr",children:p})}if(e){for(p=[],n=0,r=e.length;n<r;++n)void 0!==e[n]&&p.push(h("th",null,{scope:"col"},e[n]));i.push({tagName:"tr",children:p})}return{tagName:"thead",children:i}}(i,t,Math.max(o,t.length)));var l=[];a.forEach(function(t){for(var e=[],a=0;a<o;a++)e.push(h(a?"td":"th",null,a?{}:{scope:"row"},t[a]));l.push({tagName:"tr",children:e})}),e.push({tagName:"tbody",children:l});e={tree:{tagName:"table",id:"highcharts-data-table-"+this.index,children:e}};return fireEvent(this,"aftergetTableAST",e),e.tree},Chart.prototype.downloadCSV=function(){var t=this.getCSV(!0);downloadURL(getBlobFromContent(t,"text/csv")||"data:text/csv,\ufeff"+encodeURIComponent(t),this.getFilename()+".csv")},Chart.prototype.downloadXLS=function(){var t='<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head>\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>Ark1</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e<style>td{border:none;font-family: Calibri, sans-serif;} .number{mso-number-format:"0.00";} .text{ mso-number-format:"@";}</style><meta name=ProgId content=Excel.Sheet><meta charset=UTF-8></head><body>'+this.getTable(!0)+"</body></html>";downloadURL(getBlobFromContent(t,"application/vnd.ms-excel")||"data:application/vnd.ms-excel;base64,"+win.btoa(unescape(encodeURIComponent(t))),this.getFilename()+".xls")},Chart.prototype.viewData=function(){this.toggleDataTable(!0)},Chart.prototype.hideData=function(){this.toggleDataTable(!1)},Chart.prototype.toggleDataTable=function(t){(t=pick(t,!this.isDataTableVisible))&&!this.dataTableDiv&&(this.dataTableDiv=doc.createElement("div"),this.dataTableDiv.className="highcharts-data-table",this.renderTo.parentNode.insertBefore(this.dataTableDiv,this.renderTo.nextSibling)),this.dataTableDiv&&(this.dataTableDiv.style.display=t?"block":"none",t&&(this.dataTableDiv.innerHTML="",new AST([this.getTableAST()]).addToDOM(this.dataTableDiv),fireEvent(this,"afterViewData",this.dataTableDiv))),this.isDataTableVisible=t;var e=this.exportDivElements,a=this.options.exporting,t=a&&a.buttons&&a.buttons.contextButton.menuItems,a=this.options.lang;exportingOptions&&exportingOptions.menuItemDefinitions&&a&&a.viewData&&a.hideData&&t&&e&&e.length&&AST.setElementHTML(e[t.indexOf("viewData")],this.isDataTableVisible?a.hideData:a.viewData)};var exportingOptions=getOptions().exporting;exportingOptions&&(extend(exportingOptions.menuItemDefinitions,{downloadCSV:{textKey:"downloadCSV",onclick:function(){this.downloadCSV()}},downloadXLS:{textKey:"downloadXLS",onclick:function(){this.downloadXLS()}},viewData:{textKey:"viewData",onclick:function(){this.toggleDataTable()}}}),exportingOptions.buttons&&exportingOptions.buttons.contextButton.menuItems.push("separator","downloadCSV","downloadXLS","viewData")),seriesTypes.map&&(seriesTypes.map.prototype.exportKey="name"),seriesTypes.mapbubble&&(seriesTypes.mapbubble.prototype.exportKey="name"),seriesTypes.treemap&&(seriesTypes.treemap.prototype.exportKey="name");