"use strict";import H from"../../Core/Globals.js";import Point from"../../Core/Series/Point.js";import U from"../../Core/Utilities.js";var find=U.find,isArray=U.isArray,merge=U.merge,pick=U.pick,splat=U.splat,objectEach=U.objectEach;import utilities from"./Utilities.js";function getPointTimeValue(n,t){return"function"==typeof t?t(n):pick(n[t],n.options[t])}function getTimeExtremes(n,i){return n.points.reduce(function(n,t){t=getPointTimeValue(t,i);return n.min=Math.min(n.min,t),n.max=Math.max(n.max,t),n},{min:1/0,max:-1/0})}function getExtremesForInstrumentProps(e,n,t){function i(n){return{instrumentMapping:n.mapping}}var o=(n||[]).slice(0),n=e.options.sonification&&e.options.sonification.defaultInstrumentOptions;return n&&o.push(i(n)),e.series.forEach(function(n){n=n.options.sonification&&n.options.sonification.instruments;n&&(o=o.concat(n.map(i)))}),o.reduce(function(t,i){return Object.keys(i.instrumentMapping||{}).forEach(function(n){n=i.instrumentMapping[n];"string"!=typeof n||t[n]||(t[n]=utilities.calculateDataExtremes(e,n))}),t},merge(t))}function getPointEarcons(o,n){return n.reduce(function(n,t){var i,e=t.earcon;return t.condition?(i=t.condition(o))instanceof H.sonification.Earcon?n.push(i):i&&n.push(e):t.onPoint&&o.id===t.onPoint&&n.push(e),n},[])}function makeInstrumentCopies(n){return n.map(function(n){var t=n.instrument,t=("string"==typeof t?H.sonification.instruments[t]:t).copy();return merge(n,{instrument:t})})}function applyMasterVolumeToInstruments(n,t){return n.forEach(function(n){n=n.instrument;"string"!=typeof n&&n.setMasterVolume(t)}),n}function getFinalNoteDuration(n,t,i){var e=n.points[n.points.length-1];return t.reduce(function(n,t){t=t.instrumentMapping.duration,t="string"==typeof t?0:"function"==typeof t?t(e,i):t;return Math.max(n,t)},0)}function buildTimelinePathFromSeries(n,s){var r=s.timeExtremes||getTimeExtremes(n,s.pointPlayTime),a=getExtremesForInstrumentProps(n.chart,s.instruments,s.dataExtremes),u=getFinalNoteDuration(n,s.instruments,a),m=pick(s.masterVolume,1),c=applyMasterVolumeToInstruments(makeInstrumentCopies(s.instruments),m),t=n.points.reduce(function(n,t){var i,e=getPointEarcons(t,s.earcons||[]),o=(i=t,utilities.virtualAxisTranslate(getPointTimeValue(i,s.pointPlayTime),r,{min:0,max:Math.max(s.duration-u,10)}));return n.concat(new H.sonification.TimelineEvent({eventObject:t,time:o,id:t.id,playOptions:{instruments:c,dataExtremes:a,masterVolume:m}}),e.map(function(n){return new H.sonification.TimelineEvent({eventObject:n,time:o,playOptions:{volume:m}})}))},[]);return new H.sonification.TimelinePath({events:t,onStart:function(){s.onStart&&s.onStart(n)},onEventStart:function(n){var t=n.options&&n.options.eventObject;if(t instanceof Point){if(!t.series.visible&&!t.series.chart.series.some(function(n){return n.visible}))return n.timelinePath.timeline.pause(),n.timelinePath.timeline.resetCursor(),!1;s.onPointStart&&s.onPointStart(n,t)}},onEventEnd:function(n){var t=n.event&&n.event.options&&n.event.options.eventObject;t instanceof Point&&s.onPointEnd&&s.onPointEnd(n.event,t)},onEnd:function(){s.onEnd&&s.onEnd(n)},targetDuration:s.duration})}function seriesSonify(n){var t=getSeriesSonifyOptions(this,n),i=buildTimelinePathFromSeries(this,t),n=this.chart.sonification;n.timeline&&n.timeline.pause(),n.duration=t.duration,n.timeline=new H.sonification.Timeline({paths:[i]}),n.timeline.play()}function buildChartSonifySeriesOptions(t,n,i){var e=i.seriesOptions||{},o=t.chart.options.sonification&&t.chart.options.sonification.defaultInstrumentOptions&&t.chart.options.sonification.defaultInstrumentOptions.mapping&&t.chart.options.sonification.defaultInstrumentOptions.mapping.pointPlayTime||"x",s=chartOptionsToSonifySeriesOptions(t);return merge(s,{dataExtremes:n,timeExtremes:getTimeExtremes(t,o),instruments:i.instruments||s.instruments,onStart:i.onSeriesStart||s.onStart,onEnd:i.onSeriesEnd||s.onEnd,earcons:i.earcons||s.earcons,masterVolume:pick(i.masterVolume,s.masterVolume)},isArray(e)?find(e,function(n){return n.id===pick(t.id,t.options.id)})||{}:e,{pointPlayTime:o})}function buildPathOrder(n,o,s){var t;return"sequential"===n||"simultaneous"===n?(t=o.series.reduce(function(n,t){return t.visible&&!1!==(t.options.sonification&&t.options.sonification.enabled)&&n.push({series:t,seriesOptions:s(t)}),n},[]),"simultaneous"===n&&(t=[t])):t=n.reduce(function(n,t){t=splat(t).reduce(function(n,t){var i,e;return"string"==typeof t?(e=o.get(t)).visible&&(i={series:e,seriesOptions:s(e)}):t instanceof H.sonification.Earcon&&(i=new H.sonification.TimelinePath({events:[new H.sonification.TimelineEvent({eventObject:t})]})),(i=t.silentWait?new H.sonification.TimelinePath({silentWait:t.silentWait}):i)&&n.push(i),n},[]);return t.length&&n.push(t),n},[]),t}function addAfterSeriesWaits(e,o){return o?e.reduce(function(n,t,i){t=splat(t);return n.push(t),i<e.length-1&&t.some(function(n){return n.series})&&n.push(new H.sonification.TimelinePath({silentWait:o})),n},[]):e}function getWaitTime(n){return n.reduce(function(n,t){t=splat(t);return n+(1===t.length&&t[0].options&&t[0].options.silentWait||0)},0)}function syncSimultaneousPaths(n){var o=n.reduce(function(n,t){t=t.events;return t&&t.length&&(n.min=Math.min(t[0].time,n.min),n.max=Math.max(t[t.length-1].time,n.max)),n},{min:1/0,max:-1/0});n.forEach(function(n){var t=n.events,i=t&&t.length,e=[];i&&t[0].time<=o.min||e.push(new H.sonification.TimelineEvent({time:o.min})),i&&t[t.length-1].time>=o.max||e.push(new H.sonification.TimelineEvent({time:o.max})),e.length&&n.addTimelineEvents(e)})}function getSimulPathDurationTotal(n){return n.reduce(function(n,t){return n+splat(t).reduce(function(n,t){t=t.series&&t.seriesOptions&&t.seriesOptions.timeExtremes;return t?Math.max(n,t.max-t.min):n},0)},0)}function getSeriesDurationMs(n,t,i){return utilities.virtualAxisTranslate(n,{min:0,max:t},{min:0,max:i})}function buildPathsFromOrder(n,t){var i=Math.max(t-getWaitTime(n),0),e=getSimulPathDurationTotal(n);return n.reduce(function(n,t){t=splat(t).reduce(function(n,t){return t instanceof H.sonification.TimelinePath?n.push(t):t.series&&(t.seriesOptions.duration=t.seriesOptions.duration||getSeriesDurationMs(t.seriesOptions.timeExtremes.max-t.seriesOptions.timeExtremes.min,e,i),n.push(buildTimelinePathFromSeries(t.series,t.seriesOptions))),n},[]);return n.push(t),n},[])}function getSeriesInstrumentOptions(n,t){if(t&&t.instruments)return t.instruments;function i(i){objectEach(i,function(n,t){null===n&&delete i[t]})}var e=n.chart.options.sonification&&n.chart.options.sonification.defaultInstrumentOptions||{},n=n.options.sonification&&n.options.sonification.instruments||[{}];return n.map(function(n){return i(n.mapping||{}),i(n),{instrument:n.instrument||e.instrument,instrumentOptions:merge(e,n,{mapping:void 0,instrument:void 0}),instrumentMapping:merge(e.mapping,n.mapping)}})}function chartOptionsToSonifySeriesOptions(n){var t=n.options.sonification||{},i=n.chart.options.sonification||{},e=i.events||{},o=t.events||{};return{onEnd:o.onSeriesEnd||e.onSeriesEnd,onStart:o.onSeriesStart||e.onSeriesStart,onPointEnd:o.onPointEnd||e.onPointEnd,onPointStart:o.onPointStart||e.onPointStart,pointPlayTime:i.defaultInstrumentOptions&&i.defaultInstrumentOptions.mapping&&i.defaultInstrumentOptions.mapping.pointPlayTime,masterVolume:i.masterVolume,instruments:getSeriesInstrumentOptions(n),earcons:t.earcons||i.earcons}}function getSeriesSonifyOptions(n,t){var i=n.chart.options.sonification,e=n.options.sonification;return merge({duration:e&&e.duration||i&&i.duration},chartOptionsToSonifySeriesOptions(n),t)}function getChartSonifyOptions(n,t){n=n.options.sonification||{};return merge({duration:n.duration,afterSeriesWait:n.afterSeriesWait,pointPlayTime:n.defaultInstrumentOptions&&n.defaultInstrumentOptions.mapping&&n.defaultInstrumentOptions.mapping.pointPlayTime,order:n.order,onSeriesStart:n.events&&n.events.onSeriesStart,onSeriesEnd:n.events&&n.events.onSeriesEnd,onEnd:n.events&&n.events.onEnd},t)}function chartSonify(n){var t=getChartSonifyOptions(this,n);this.sonification.timeline&&this.sonification.timeline.pause(),this.sonification.duration=t.duration;var i=getExtremesForInstrumentProps(this,t.instruments,t.dataExtremes),n=buildPathsFromOrder(addAfterSeriesWaits(buildPathOrder(t.order,this,function(n){return buildChartSonifySeriesOptions(n,i,t)}),t.afterSeriesWait||0),t.duration);n.forEach(function(n){syncSimultaneousPaths(n)}),this.sonification.timeline=new H.sonification.Timeline({paths:n,onEnd:t.onEnd}),this.sonification.timeline.play()}function getCurrentPoints(){var t;return this.sonification.timeline?(t=this.sonification.timeline.getCursor(),Object.keys(t).map(function(n){return t[n].eventObject}).filter(function(n){return n instanceof Point})):[]}function setCursor(n){var t=this.sonification.timeline;t&&splat(n).forEach(function(n){t.setCursor(n.id)})}function pause(n){this.sonification.timeline?this.sonification.timeline.pause(pick(n,!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(n)}function resume(n){this.sonification.timeline&&this.sonification.timeline.play(n)}function rewind(n){this.sonification.timeline&&this.sonification.timeline.rewind(n)}function cancel(n){this.pauseSonify(n),this.resetSonifyCursor()}function resetCursor(){this.sonification.timeline&&this.sonification.timeline.resetCursor()}function resetCursorEnd(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}var chartSonifyFunctions={chartSonify:chartSonify,seriesSonify:seriesSonify,pause:pause,resume:resume,rewind:rewind,cancel:cancel,getCurrentPoints:getCurrentPoints,setCursor:setCursor,resetCursor:resetCursor,resetCursorEnd:resetCursorEnd};export default chartSonifyFunctions;