"use strict";import H from"../../Core/Globals.js";import U from"../../Core/Utilities.js";var error=U.error,merge=U.merge,pick=U.pick,uniqueKey=U.uniqueKey,defaultOptions={type:"oscillator",playCallbackInterval:20,masterVolume:1,oscillator:{waveformShape:"sine"}};function Instrument(t){this.init(t)}Instrument.prototype.init=function(t){var e;this.initAudioContext()?(this.options=merge(defaultOptions,t),this.id=this.options.id=t&&t.id||uniqueKey(),this.masterVolume=this.options.masterVolume||0,e=H.audioContext,t=this.destinationNode||e.destination,this.gainNode=e.createGain(),this.setGain(0),this.panNode=e.createStereoPanner&&e.createStereoPanner(),this.panNode?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(t)):this.gainNode.connect(t),"oscillator"===this.options.type&&this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):error(29)},Instrument.prototype.copy=function(t){return new Instrument(merge(this.options,{id:null},t))},Instrument.prototype.initAudioContext=function(){var t=H.win.AudioContext||H.win.webkitAudioContext,e=!!H.audioContext;return!!t&&(H.audioContext=H.audioContext||new t,!e&&H.audioContext&&"running"===H.audioContext.state&&H.audioContext.suspend(),!!(H.audioContext&&H.audioContext.createOscillator&&H.audioContext.createGain))},Instrument.prototype.initOscillator=function(t){var e=H.audioContext;this.oscillator=e.createOscillator(),this.oscillator.type=t.waveformShape,this.oscillator.connect(this.gainNode),this.oscillatorStarted=!1},Instrument.prototype.setPan=function(t){this.panNode&&this.panNode.pan.setValueAtTime(t,H.audioContext.currentTime)},Instrument.prototype.setGain=function(t,e){var o=this.gainNode,t=t*this.masterVolume;o&&(1.2<t&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),t=1.2),e?(o.gain.setValueAtTime(o.gain.value,H.audioContext.currentTime),o.gain.linearRampToValueAtTime(t,H.audioContext.currentTime+e/1e3)):o.gain.setValueAtTime(t,H.audioContext.currentTime))},Instrument.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)},Instrument.prototype.setMasterVolume=function(t){this.masterVolume=t||0},Instrument.prototype.getValidFrequency=function(o,t,e){var i=this.options.allowedFrequencies,n=pick(e,1/0),a=pick(t,-1/0);return i&&i.length?i.reduce(function(t,e){return Math.abs(e-o)<Math.abs(t-o)&&e<n&&a<e?e:t},1/0):o},Instrument.prototype.clearPlayCallbackTimers=function(){this.playCallbackTimers.forEach(function(t){clearInterval(t)}),this.playCallbackTimers=[]},Instrument.prototype.setFrequency=function(t,e){e=e||{},e=this.getValidFrequency(t,e.min,e.max);"oscillator"===this.options.type&&this.oscillatorPlay(e)},Instrument.prototype.oscillatorPlay=function(t){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0),this.oscillator.frequency.setValueAtTime(t,H.audioContext.currentTime)},Instrument.prototype.preparePlay=function(){this.setGain(.001),"suspended"===H.audioContext.state&&H.audioContext.resume(),this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)},Instrument.prototype.play=function(t){function e(e,o,i){var n,a=t.duration,s=0,r=l.options.playCallbackInterval;"function"==typeof e?(n=setInterval(function(){var t=++s*r/a;1<=t?(l[o](e(1),i),clearInterval(n)):l[o](e(t),i)},r),l.playCallbackTimers.push(n)):l[o](e,i)}var l=this,o=t.duration||0;if(l.id){if("suspended"===H.audioContext.state||this.oscillator&&!this.oscillatorStarted)return l.preparePlay(),void setTimeout(function(){l.play(t)},10);l.playCallbackTimers.length&&l.clearPlayCallbackTimers(),l.cancelGainRamp(),l.stopOscillatorTimeout&&(clearTimeout(l.stopOscillatorTimeout),delete l.stopOscillatorTimeout),l.stopTimeout&&(clearTimeout(l.stopTimeout),delete l.stopTimeout,l.stopCallback&&(l._play=l.play,l.play=function(){},l.stopCallback("cancelled"),l.play=l._play));var i=o<H.sonification.fadeOutDuration+20;l.stopCallback=t.onEnd;var n=function(){delete l.stopTimeout,l.stop(i)};o?(l.stopTimeout=setTimeout(n,i?o:o-H.sonification.fadeOutDuration),e(t.frequency,"setFrequency",{minFrequency:t.minFrequency,maxFrequency:t.maxFrequency}),e(pick(t.volume,1),"setGain",4),e(pick(t.pan,0),"setPan")):n()}},Instrument.prototype.mute=function(){this.setGain(1e-4,.8*H.sonification.fadeOutDuration)},Instrument.prototype.stop=function(t,e,o){function i(){n.stopOscillatorTimeout&&delete n.stopOscillatorTimeout;try{n.oscillator.stop()}catch(t){}n.oscillator.disconnect(n.gainNode),n.initOscillator(n.options.oscillator),e&&e(o),n.stopCallback&&n.stopCallback(o)}var n=this;n.playCallbackTimers.length&&n.clearPlayCallbackTimers(),n.stopTimeout&&clearTimeout(n.stopTimeout),t?(n.setGain(0),i()):(n.mute(),n.stopOscillatorTimeout=setTimeout(i,H.sonification.fadeOutDuration+100))};export default Instrument;