"use strict";var __extends=this&&this.__extends||function(){var r=function(t,o){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var e in o)o.hasOwnProperty(e)&&(t[e]=o[e])})(t,o)};return function(t,o){function e(){this.constructor=t}r(t,o),t.prototype=null===o?Object.create(o):(e.prototype=o.prototype,new e)}}();import A from"../../Core/Animation/AnimationUtilities.js";var animObject=A.animObject;import Color from"../../Core/Color/Color.js";var color=Color.parse;import H from"../../Core/Globals.js";var hasTouch=H.hasTouch,noop=H.noop;import LegendSymbolMixin from"../../Mixins/LegendSymbol.js";import palette from"../../Core/Color/Palette.js";import Series from"../../Core/Series/Series.js";import SeriesRegistry from"../../Core/Series/SeriesRegistry.js";import U from"../../Core/Utilities.js";var clamp=U.clamp,css=U.css,defined=U.defined,extend=U.extend,fireEvent=U.fireEvent,isArray=U.isArray,isNumber=U.isNumber,merge=U.merge,pick=U.pick,objectEach=U.objectEach,ColumnSeries=function(r){function t(){var t=null!==r&&r.apply(this,arguments)||this;return t.borderWidth=void 0,t.data=void 0,t.group=void 0,t.options=void 0,t.points=void 0,t}return __extends(t,r),t.prototype.animate=function(t){var e,r=this,i=this.yAxis,o=r.options,s=this.chart.inverted,n={},a=s?"translateX":"translateY";t?(n.scaleY=.001,o=clamp(i.toPixels(o.threshold),i.pos,i.pos+i.len),s?n.translateX=o-i.len:n.translateY=o,r.clipBox&&r.setClip(),r.group.attr(n)):(e=Number(r.group.attr(a)),r.group.animate({scaleY:1},extend(animObject(r.options.animation),{step:function(t,o){r.group&&(n[a]=e+o.pos*(i.pos-e),r.group.attr(n))}})))},t.prototype.init=function(t,o){r.prototype.init.apply(this,arguments);var e=this;(t=e.chart).hasRendered&&t.series.forEach(function(t){t.type===e.type&&(t.isDirty=!0)})},t.prototype.getColumnMetrics=function(){var i,s=this,t=s.options,o=s.xAxis,n=s.yAxis,e=o.options.reversedStacks,r=o.reversed&&!e||!o.reversed&&e,a={},p=0;!1===t.grouping?p=1:s.chart.series.forEach(function(t){var o,e=t.yAxis,r=t.options;t.type!==s.type||!t.visible&&s.chart.options.chart.ignoreHiddenSeries||n.len!==e.len||n.pos!==e.pos||(r.stacking&&"group"!==r.stacking?(i=t.stackKey,void 0===a[i]&&(a[i]=p++),o=a[i]):!1!==r.grouping&&(o=p++),t.columnIndex=o)});var d=Math.min(Math.abs(o.transA)*(o.ordinal&&o.ordinal.slope||t.pointRange||o.closestPointRange||o.tickInterval||1),o.len),l=d*t.groupPadding,e=(d-2*l)/(p||1),o=Math.min(t.maxPointWidth||o.len,pick(t.pointWidth,e*(1-2*t.pointPadding))),t=(s.columnIndex||0)+(r?1:0);return s.columnMetrics={width:o,offset:(e-o)/2+(l+t*e-d/2)*(r?-1:1),paddedWidth:e,columnCount:p},s.columnMetrics},t.prototype.crispCol=function(t,o,e,r){var i=this.chart,s=this.borderWidth,n=-(s%2?.5:0),s=s%2?.5:1;return i.inverted&&i.renderer.isVML&&(s+=1),this.options.crisp&&(e=Math.round(t+e)+n-(t=Math.round(t)+n)),i=Math.round(o+r)+s,n=Math.abs(o)<=.5&&.5<i,r=i-(o=Math.round(o)+s),n&&r&&(--o,r+=1),{x:t,y:o,width:e,height:r}},t.prototype.adjustForMissingColumns=function(t,o,r,e){var i,s,n,a=this,p=this.options.stacking;return!r.isNull&&1<e.columnCount&&(s=i=0,objectEach(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(t){var o,e;"number"!=typeof r.x||(o=t[r.x.toString()])&&(e=o.points[a.index],t=o.total,p?(e&&(i=s),o.hasValidPoints&&s++):isArray(e)&&(i=e[1],s=t||0))}),n=(s-1)*e.paddedWidth+o,t=(r.plotX||0)+n/2-o-i*e.paddedWidth),t},t.prototype.translate=function(){var d=this,l=d.chart,c=d.options,t=d.dense=d.closestPointRange*d.xAxis.transA<2,t=d.borderWidth=pick(c.borderWidth,t?0:1),h=d.xAxis,u=d.yAxis,g=c.threshold,m=d.translatedThreshold=u.getThreshold(g),y=pick(c.minPointLength,5),f=d.getColumnMetrics(),v=f.width,b=d.barW=Math.max(v,1+2*t),C=d.pointXOffset=f.offset,x=d.dataMin,k=d.dataMax;l.inverted&&(m-=.5),c.pointPadding&&(b=Math.ceil(b)),Series.prototype.translate.apply(d),d.points.forEach(function(t){var o=pick(t.yBottom,m),e=999+Math.abs(o),r=v,i=t.plotX||0,s=clamp(t.plotY,-e,u.len+e),n=i+C,a=b,p=Math.min(s,o),e=Math.max(s,o)-p;y&&Math.abs(e)<y&&(e=y,i=!u.reversed&&!t.negative||u.reversed&&t.negative,isNumber(g)&&isNumber(k)&&t.y===g&&k<=g&&(u.min||0)<g&&(x!==k||(u.max||0)<=g)&&(i=!i),p=Math.abs(p-m)>y?o-y:m-(i?y:0)),defined(t.options.pointWidth)&&(r=a=Math.ceil(t.options.pointWidth),n-=Math.round((r-v)/2)),c.centerInCategory&&(n=d.adjustForMissingColumns(n,r,t,f)),t.barX=n,t.pointWidth=r,t.tooltipPos=l.inverted?[clamp(u.len+u.pos-l.plotLeft-s,u.pos-l.plotLeft,u.len+u.pos-l.plotLeft),h.len+h.pos-l.plotTop-n-a/2,e]:[h.left-l.plotLeft+n+a/2,clamp(s+u.pos-l.plotTop,u.pos-l.plotTop,u.len+u.pos-l.plotTop),e],t.shapeType=d.pointClass.prototype.shapeType||"rect",t.shapeArgs=d.crispCol.apply(d,t.isNull?[n,m,a,0]:[n,p,a,e])})},t.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},t.prototype.pointAttribs=function(t,o){var e=this.options,r=this.pointAttrToOptions||{},i=r.stroke||"borderColor",s=r["stroke-width"]||"borderWidth",n=t&&t.color||this.color,a=t&&t[i]||e[i]||n,p=t&&t[s]||e[s]||this[s]||0,d=t&&t.options.dashStyle||e.dashStyle,l=pick(t&&t.opacity,e.opacity,1);return t&&this.zones.length&&(r=t.getZone(),n=t.options.color||r&&(r.color||t.nonZonedColor)||this.color,r&&(a=r.borderColor||a,d=r.dashStyle||d,p=r.borderWidth||p)),o&&t&&(o=(t=merge(e.states[o],t.options.states&&t.options.states[o]||{})).brightness,n=t.color||void 0!==o&&color(n).brighten(t.brightness).get()||n,a=t[i]||a,p=t[s]||p,d=t.dashStyle||d,l=pick(t.opacity,l)),l={fill:n,stroke:a,"stroke-width":p,opacity:l},d&&(l.dashstyle=d),l},t.prototype.drawPoints=function(){var s,n=this,a=this.chart,p=n.options,d=a.renderer,l=p.animationLimit||250;n.points.forEach(function(t){var o=t.plotY,e=t.graphic,r=!!e,i=e&&a.pointCount<l?"animate":"attr";isNumber(o)&&null!==t.y?(s=t.shapeArgs,e&&t.hasNewShapeType()&&(e=e.destroy()),n.enabledDataSorting&&(t.startXPos=n.xAxis.reversed?-(s&&s.width||0):n.xAxis.width),e||(t.graphic=e=d[t.shapeType](s).add(t.group||n.group),e&&n.enabledDataSorting&&a.hasRendered&&a.pointCount<l&&(e.attr({x:t.startXPos}),r=!0,i="animate")),e&&r&&e[i](merge(s)),p.borderRadius&&e[i]({r:p.borderRadius}),a.styledMode||e[i](n.pointAttribs(t,t.selected&&"select")).shadow(!1!==t.allowShadow&&p.shadow,null,p.stacking&&!p.borderRadius),e&&(e.addClass(t.getClassName(),!0),e.attr({visibility:t.visible?"inherit":"hidden"}))):e&&(t.graphic=e.destroy())})},t.prototype.drawTracker=function(){function o(t){var o=i.getPointFromEvent(t);void 0!==o&&(i.isDirectTouch=!0,o.onMouseOver(t))}var t,e=this,r=e.chart,i=r.pointer;e.points.forEach(function(o){t=isArray(o.dataLabels)?o.dataLabels:o.dataLabel?[o.dataLabel]:[],o.graphic&&(o.graphic.element.point=o),t.forEach(function(t){t.div?t.div.point=o:t.element.point=o})}),e._hasTracking||(e.trackerGroups.forEach(function(t){e[t]&&(e[t].addClass("highcharts-tracker").on("mouseover",o).on("mouseout",function(t){i.onTrackerMouseOut(t)}),hasTouch&&e[t].on("touchstart",o),!r.styledMode&&e.options.cursor&&e[t].css(css).css({cursor:e.options.cursor}))}),e._hasTracking=!0),fireEvent(this,"afterDrawTracker")},t.prototype.remove=function(){var o=this,t=o.chart;t.hasRendered&&t.series.forEach(function(t){t.type===o.type&&(t.isDirty=!0)}),Series.prototype.remove.apply(o,arguments)},t.defaultOptions=merge(Series.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),t}(Series);extend(ColumnSeries.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbolMixin.drawRectangle,getSymbol:noop,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]}),SeriesRegistry.registerSeriesType("column",ColumnSeries);export default ColumnSeries;