"use strict";var __extends=this&&this.__extends||function(){var i=function(t,e){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)};return function(t,e){function r(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}}();import ColorMapMixin from"../../Mixins/ColorMapSeries.js";var colorMapSeriesMixin=ColorMapMixin.colorMapSeriesMixin;import H from"../../Core/Globals.js";var noop=H.noop;import LegendSymbolMixin from"../../Mixins/LegendSymbol.js";import MapChart from"../../Core/Chart/MapChart.js";var maps=MapChart.maps,splitPath=MapChart.splitPath;import MapPoint from"./MapPoint.js";import palette from"../../Core/Color/Palette.js";import Series from"../../Core/Series/Series.js";import SeriesRegistry from"../../Core/Series/SeriesRegistry.js";var _a=SeriesRegistry.seriesTypes,ColumnSeries=_a.column,ScatterSeries=_a.scatter;import SVGRenderer from"../../Core/Renderer/SVG/SVGRenderer.js";import U from"../../Core/Utilities.js";var extend=U.extend,fireEvent=U.fireEvent,getNestedProperty=U.getNestedProperty,isArray=U.isArray,isNumber=U.isNumber,merge=U.merge,objectEach=U.objectEach,pick=U.pick,splat=U.splat,MapSeries=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t.baseTrans=void 0,t.chart=void 0,t.data=void 0,t.group=void 0,t.joinBy=void 0,t.options=void 0,t.points=void 0,t.transformGroup=void 0,t}return __extends(t,e),t.prototype.animate=function(t){var e=this.chart,r=this.options.animation,i=this.group,a=this.xAxis,o=this.yAxis,s=a.pos,n=o.pos;e.renderer.isSVG&&(!0===r&&(r={duration:1e3}),t?i.attr({translateX:s+a.len/2,translateY:n+o.len/2,scaleX:.001,scaleY:.001}):i.animate({translateX:s,translateY:n,scaleX:1,scaleY:1},r))},t.prototype.animateDrilldown=function(t){var e=this.chart.plotBox,r=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],i=r.bBox,a=this.chart.options.drilldown.animation;t||(e=Math.min(i.width/e.width,i.height/e.height),r.shapeArgs={scaleX:e,scaleY:e,translateX:i.x,translateY:i.y},this.points.forEach(function(t){t.graphic&&t.graphic.attr(r.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},a)}))},t.prototype.animateDrillupFrom=function(t){ColumnSeries.prototype.animateDrillupFrom.call(this,t)},t.prototype.animateDrillupTo=function(t){ColumnSeries.prototype.animateDrillupTo.call(this,t)},t.prototype.doFullTranslate=function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||!this.baseTrans},t.prototype.drawMapDataLabels=function(){Series.prototype.drawDataLabels.call(this),this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},t.prototype.drawPoints=function(){var r,i,a,o,s,n,p,l,h,c=this,t=c.xAxis,e=c.yAxis,m=c.group,d=c.chart,u=d.renderer,f=this.baseTrans;c.transformGroup||(c.transformGroup=u.g().attr({scaleX:1,scaleY:1}).add(m),c.transformGroup.survive=!0),c.doFullTranslate()?(d.hasRendered&&!d.styledMode&&c.points.forEach(function(t){t.shapeArgs&&(t.shapeArgs.fill=c.pointAttribs(t,t.state).fill)}),c.group=c.transformGroup,ColumnSeries.prototype.drawPoints.apply(c),c.group=m,c.points.forEach(function(t){var e;t.graphic&&(e="",t.name&&(e+="highcharts-name-"+t.name.replace(/ /g,"-").toLowerCase()),t.properties&&t.properties["hc-key"]&&(e+=" highcharts-key-"+t.properties["hc-key"].toLowerCase()),e&&t.graphic.addClass(e),d.styledMode&&t.graphic.css(c.pointAttribs(t,t.selected?"select":void 0)))}),this.baseTrans={originX:t.min-t.minPixelPadding/t.transA,originY:e.min-e.minPixelPadding/e.transA+(e.reversed?0:e.len/e.transA),transAX:t.transA,transAY:e.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,scaleY:1})):(r=t.transA/f.transAX,i=e.transA/f.transAY,a=t.toPixels(f.originX,!0),o=e.toPixels(f.originY,!0),.99<r&&r<1.01&&.99<i&&i<1.01&&(i=r=1,a=Math.round(a),o=Math.round(o)),s=this.transformGroup,d.renderer.globalAnimation?(n=s.attr("translateX"),p=s.attr("translateY"),l=s.attr("scaleX"),h=s.attr("scaleY"),s.attr({animator:0}).animate({animator:1},{step:function(t,e){s.attr({translateX:n+(a-n)*e.pos,translateY:p+(o-p)*e.pos,scaleX:l+(r-l)*e.pos,scaleY:h+(i-h)*e.pos})}})):s.attr({translateX:a,translateY:o,scaleX:r,scaleY:i})),d.styledMode||m.element.setAttribute("stroke-width",pick(c.options[c.pointAttrToOptions&&c.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(r||1)),this.drawMapDataLabels()},t.prototype.getBox=function(t){var n,p=Number.MAX_VALUE,l=-p,h=p,c=-p,m=p,d=p,e=this.xAxis,r=this.yAxis;(t||[]).forEach(function(t){var e,r,i,a,o,s;t.path&&("string"==typeof t.path?t.path=splitPath(t.path):"M"===t.path[0]&&(t.path=SVGRenderer.prototype.pathToSegments(t.path)),e=t.path||[],r=-p,a=-(i=p),o=p,s=t.properties,t._foundBox||(e.forEach(function(t){var e=t[t.length-2],t=t[t.length-1];"number"==typeof e&&"number"==typeof t&&(i=Math.min(i,e),r=Math.max(r,e),o=Math.min(o,t),a=Math.max(a,t))}),t._midX=i+(r-i)*pick(t.middleX,s&&s["hc-middle-x"],.5),t._midY=o+(a-o)*pick(t.middleY,s&&s["hc-middle-y"],.5),t._maxX=r,t._minX=i,t._maxY=a,t._minY=o,t.labelrank=pick(t.labelrank,(r-i)*(a-o)),t._foundBox=!0),l=Math.max(l,t._maxX),h=Math.min(h,t._minX),c=Math.max(c,t._maxY),m=Math.min(m,t._minY),d=Math.min(t._maxX-t._minX,t._maxY-t._minY,d),n=!0)}),n&&(this.minY=Math.min(m,pick(this.minY,p)),this.maxY=Math.max(c,pick(this.maxY,-p)),this.minX=Math.min(h,pick(this.minX,p)),this.maxX=Math.max(l,pick(this.maxX,-p)),e&&void 0===e.options.minRange&&(e.minRange=Math.min(5*d,(this.maxX-this.minX)/5,e.minRange||p)),r&&void 0===r.options.minRange&&(r.minRange=Math.min(5*d,(this.maxY-this.minY)/5,r.minRange||p)))},t.prototype.getExtremes=function(){var t=Series.prototype.getExtremes.call(this,this.valueData),e=t.dataMin,t=t.dataMax;return this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data),isNumber(e)&&(this.valueMin=e),isNumber(t)&&(this.valueMax=t),{dataMin:this.minY,dataMax:this.maxY}},t.prototype.hasData=function(){return!!this.processedXData.length},t.prototype.pointAttribs=function(t,e){e=t.series.chart.styledMode?this.colorAttribs(t):ColumnSeries.prototype.pointAttribs.call(this,t,e);return e["stroke-width"]=pick(t.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],"inherit"),e},t.prototype.render=function(){var t=this,e=Series.prototype.render;t.chart.renderer.isVML&&3e3<t.data.length?setTimeout(function(){e.call(t)}):e.call(t)},t.prototype.setData=function(a,t,e,r){var i,o,s,n,p,l=this.options,h=this.chart.options.chart,c=h&&h.map,m=l.mapData,d=this.joinBy,u=l.keys||this.pointArrayMap,f=[],y={},g=this.chart.mapTransforms;if(!m&&c&&(m="string"==typeof c?maps[c]:c),a&&a.forEach(function(t,e){var r=0;if(isNumber(t))a[e]={value:t};else if(isArray(t)){a[e]={},!l.keys&&t.length>u.length&&"string"==typeof t[0]&&(a[e]["hc-key"]=t[0],++r);for(var i=0;i<u.length;++i,++r)u[i]&&void 0!==t[r]&&(0<u[i].indexOf(".")?MapPoint.prototype.setNestedProperty(a[e],t[r],u[i]):a[e][u[i]]=t[r])}d&&"_i"===d[0]&&(a[e]._i=e)}),this.getBox(a),this.chart.mapTransforms=g=h.mapTransforms||m&&m["hc-transform"]||g,g&&objectEach(g,function(t){t.rotation&&(t.cosAngle=Math.cos(t.rotation),t.sinAngle=Math.sin(t.rotation))}),m){for("FeatureCollection"===m.type&&(this.mapTitle=m.title,m=H.geojson(m,this.type,this)),this.mapData=m,this.mapMap={},s=0;s<m.length;s++)o=(i=m[s]).properties,i._i=s,d[0]&&o&&o[d[0]]&&(i[d[0]]=o[d[0]]),y[i[d[0]]]=i;this.mapMap=y,a&&d[1]&&(n=d[1],a.forEach(function(t){t=getNestedProperty(n,t);y[t]&&f.push(y[t])})),l.allAreas?(this.getBox(m),a=a||[],d[1]&&(p=d[1],a.forEach(function(t){f.push(getNestedProperty(p,t))})),f="|"+f.map(function(t){return t&&t[d[0]]}).join("|")+"|",m.forEach(function(t){d[0]&&-1!==f.indexOf("|"+t[d[0]]+"|")||(a.push(merge(t,{value:null})),r=!1)})):this.getBox(f)}Series.prototype.setData.call(this,a,t,e,r)},t.prototype.setOptions=function(t){var e=Series.prototype.setOptions.call(this,t),t=e.joinBy;return(t=this.joinBy=splat(t=null===t?"_i":t))[1]||(t[1]=t[0]),e},t.prototype.translate=function(){var e=this,r=e.xAxis,i=e.yAxis,a=e.doFullTranslate();e.generatePoints(),e.data.forEach(function(t){isNumber(t._midX)&&isNumber(t._midY)&&(t.plotX=r.toPixels(t._midX,!0),t.plotY=i.toPixels(t._midY,!0)),a&&(t.shapeType="path",t.shapeArgs={d:e.translatePath(t.path)})}),fireEvent(e,"afterTranslate")},t.prototype.translatePath=function(t){var e=this.xAxis,r=this.yAxis,i=e.min,a=e.transA,o=e.minPixelPadding,s=r.min,n=r.transA,p=r.minPixelPadding,l=[];return t&&t.forEach(function(t){"M"===t[0]?l.push(["M",(t[1]-(i||0))*a+o,(t[2]-(s||0))*n+p]):"L"===t[0]?l.push(["L",(t[1]-(i||0))*a+o,(t[2]-(s||0))*n+p]):"C"===t[0]?l.push(["C",(t[1]-(i||0))*a+o,(t[2]-(s||0))*n+p,(t[3]-(i||0))*a+o,(t[4]-(s||0))*n+p,(t[5]-(i||0))*a+o,(t[6]-(s||0))*n+p]):"Q"===t[0]?l.push(["Q",(t[1]-(i||0))*a+o,(t[2]-(s||0))*n+p,(t[3]-(i||0))*a+o,(t[4]-(s||0))*n+p]):"Z"===t[0]&&l.push(["Z"])}),l},t.defaultOptions=merge(ScatterSeries.defaultOptions,{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:palette.neutralColor3,stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:palette.neutralColor20,borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:palette.neutralColor20},inactive:{opacity:1}}}),t}(ScatterSeries);extend(MapSeries.prototype,{type:"map",axisTypes:colorMapSeriesMixin.axisTypes,colorAttribs:colorMapSeriesMixin.colorAttribs,colorKey:colorMapSeriesMixin.colorKey,directTouch:!0,drawDataLabels:noop,drawGraph:noop,drawLegendSymbol:LegendSymbolMixin.drawRectangle,forceDL:!0,getExtremesFromAll:!0,getSymbol:colorMapSeriesMixin.getSymbol,parallelArrays:colorMapSeriesMixin.parallelArrays,pointArrayMap:colorMapSeriesMixin.pointArrayMap,pointClass:MapPoint,preserveAspectRatio:!0,searchPoint:noop,trackerGroups:colorMapSeriesMixin.trackerGroups,useMapGeometry:!0}),SeriesRegistry.registerSeriesType("map",MapSeries);export default MapSeries;