"use strict";import Chart from"../../Core/Chart/Chart.js";import A from"../../Core/Animation/AnimationUtilities.js";var setAnimation=A.setAnimation;import H from"../../Core/Globals.js";import U from"../../Core/Utilities.js";var addEvent=U.addEvent,clamp=U.clamp,defined=U.defined,extend=U.extend,isFunction=U.isFunction,pick=U.pick;import"./Integrations.js";import"./QuadTree.js";H.layouts={"reingold-fruchterman":function(){}},extend(H.layouts["reingold-fruchterman"].prototype,{init:function(t){this.options=t,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[t.integration],this.enableSimulation=t.enableSimulation,this.attractiveForce=pick(t.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick(t.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=t.approximation},updateSimulation:function(t){this.enableSimulation=pick(t,this.options.enableSimulation)},start:function(){var t=this,i=this.series,e=this.options;t.currentStep=0,t.forces=i[0]&&i[0].forces||[],t.chart=i[0]&&i[0].chart,t.initialRendering&&(t.initPositions(),i.forEach(function(t){t.finishedAnimating=!0,t.render()})),t.setK(),t.resetSimulation(e),t.enableSimulation&&t.step()},step:function(){var i=this,t=this.series;this.options;i.currentStep++,"barnes-hut"===i.approximation&&(i.createQuadTree(),i.quadTree.calculateMassAndCenter()),i.forces.forEach(function(t){i[t+"Forces"](i.temperature)}),i.applyLimits(i.temperature),i.temperature=i.coolDown(i.startTemperature,i.diffTemperature,i.currentStep),i.prevSystemTemperature=i.systemTemperature,i.systemTemperature=i.getSystemTemperature(),i.enableSimulation&&(t.forEach(function(t){t.chart&&t.render()}),i.maxIterations--&&isFinite(i.temperature)&&!i.isStable()?(i.simulation&&H.win.cancelAnimationFrame(i.simulation),i.simulation=H.win.requestAnimationFrame(function(){i.step()})):i.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(t,i,e,n){this.box={left:t,top:i,width:e,height:n}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(t,i){t.forEach(function(t){-1===i.indexOf(t)&&i.push(t)})},removeElementFromCollection:function(t,i){t=i.indexOf(t);-1!==t&&i.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(t){this.maxIterations=pick(t,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(t){this.initialRendering=t},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var t=this.options.initialPositions;isFunction(t)?(t.call(this),this.nodes.forEach(function(t){defined(t.prevX)||(t.prevX=t.plotX),defined(t.prevY)||(t.prevY=t.plotY),t.dispX=0,t.dispY=0})):"circle"===t?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var e=this.box,t=this.nodes,i=t.length+1,n=2*Math.PI/i,i=t.filter(function(t){return 0===t.linksTo.length}),o=[],r={},s=this.options.initialPositionRadius;i.forEach(function(t){o.push(t),function i(t){t.linksFrom.forEach(function(t){r[t.toNode.id]||(r[t.toNode.id]=!0,o.push(t.toNode),i(t.toNode))})}(t)}),o.length?t.forEach(function(t){-1===o.indexOf(t)&&o.push(t)}):o=t,o.forEach(function(t,i){t.plotX=t.prevX=pick(t.plotX,e.width/2+s*Math.cos(i*n)),t.plotY=t.prevY=pick(t.plotY,e.height/2+s*Math.sin(i*n)),t.dispX=0,t.dispY=0})},setRandomPositions:function(){var e=this.box,t=this.nodes,n=t.length+1;function o(t){t=t*t/Math.PI;return t-=Math.floor(t)}t.forEach(function(t,i){t.plotX=t.prevX=pick(t.plotX,e.width*o(i)),t.plotY=t.prevY=pick(t.plotY,e.height*o(n+i)),t.dispX=0,t.dispY=0})},force:function(t){this.integration[t].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var i=0,e=0,n=0;return this.nodes.forEach(function(t){e+=t.plotX*t.mass,n+=t.plotY*t.mass,i+=t.mass}),this.barycenter={x:e,y:n,xFactor:e/i,yFactor:n/i},this.barycenter},barnesHutApproximation:function(t,i){var e,n,o=this,r=o.getDistXY(t,i),s=o.vectorLength(r);return t!==i&&0!==s&&(i.isInternal?e=!(i.boxSize/s<o.options.theta&&0!==s)||(n=o.repulsiveForce(s,o.k),o.force("repulsive",t,n*i.mass,r,s),!1):(n=o.repulsiveForce(s,o.k),o.force("repulsive",t,n*i.mass,r,s))),e},repulsiveForces:function(){var r=this;"barnes-hut"===r.approximation?r.nodes.forEach(function(i){r.quadTree.visitNodeRecursive(null,function(t){return r.barnesHutApproximation(i,t)})}):r.nodes.forEach(function(o){r.nodes.forEach(function(t){var i,e,n;o===t||o.fixedPosition||(n=r.getDistXY(o,t),0!==(e=r.vectorLength(n))&&(i=r.repulsiveForce(e,r.k),r.force("repulsive",o,i*t.mass,n,e)))})})},attractiveForces:function(){var i,e,n,o=this;o.links.forEach(function(t){t.fromNode&&t.toNode&&(i=o.getDistXY(t.fromNode,t.toNode),0!==(e=o.vectorLength(i))&&(n=o.attractiveForce(e,o.k),o.force("attractive",t,n,i,e)))})},applyLimits:function(){var i=this;i.nodes.forEach(function(t){t.fixedPosition||(i.integration.integrate(i,t),i.applyLimitBox(t,i.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(t,i){var e=t.radius;t.plotX=clamp(t.plotX,i.left+e,i.width-e),t.plotY=clamp(t.plotY,i.top+e,i.height-e)},coolDown:function(t,i,e){return t-i*e},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(t,i){return t+i.temperature},0)},vectorLength:function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},getDistR:function(t,i){i=this.getDistXY(t,i);return this.vectorLength(i)},getDistXY:function(t,i){var e=t.plotX-i.plotX,i=t.plotY-i.plotY;return{x:e,y:i,absX:Math.abs(e),absY:Math.abs(i)}}}),addEvent(Chart,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.stop()})}),addEvent(Chart,"render",function(){var i,e=!1;function t(t){t.maxIterations--&&isFinite(t.temperature)&&!t.isStable()&&!t.enableSimulation&&(t.beforeStep&&t.beforeStep(),t.step(),e=!(i=!1))}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(t){t.start()});!i;)i=!0,this.graphLayoutsLookup.forEach(t);e&&this.series.forEach(function(t){t&&t.layout&&t.render()})}}),addEvent(Chart,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation(!1)}),this.redraw())}),addEvent(Chart,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.updateSimulation()}),this.redraw()});