/*
 Highstock JS v9.1.2 (2021-06-16)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Rafal Sebestjanski

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/dmi",["highcharts","highcharts/modules/stock"],function(h){a(h);a.Highcharts=h;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function h(a,f,h,d){a.hasOwnProperty(f)||(a[f]=d.apply(null,h))}a=a?a._modules:{};h(a,"Mixins/MultipleLines.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,f){var h=
f.defined,d=f.error,w=f.merge,u=a.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(g){var a=[];(this.pointArrayMap||[]).forEach(function(l){l!==g&&a.push("plot"+l.charAt(0).toUpperCase()+l.slice(1))});return a},toYData:function(g){var a=[];(this.pointArrayMap||[]).forEach(function(l){a.push(g[l])});return a},translate:function(){var g=this,a=g.pointArrayMap,l=[],d;l=g.getTranslatedLinesNames();u.prototype.translate.apply(g,
arguments);g.points.forEach(function(m){a.forEach(function(a,e){d=m[a];null!==d&&(m[l[e]]=g.yAxis.toPixels(d,!0))})})},drawGraph:function(){var a=this,f=a.linesApiNames,l=a.points,v=l.length,m=a.options,c=a.graph,e={options:{gapSize:m.gapSize}},b=[],n;a.getTranslatedLinesNames(a.pointValKey).forEach(function(a,e){for(b[e]=[];v--;)n=l[v],b[e].push({x:n.x,plotX:n.plotX,plotY:n[a],isNull:!h(n[a])});v=l.length});f.forEach(function(n,c){b[c]?(a.points=b[c],m[n]?a.options=w(m[n].styles,e):d('Error: "There is no '+
n+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+n],u.prototype.drawGraph.call(a),a["graph"+n]=a.graph):d('Error: "'+n+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=l;a.options=m;a.graph=c;u.prototype.drawGraph.call(a)}}});h(a,"Stock/Indicators/DMI/DMIIndicator.js",[a["Mixins/MultipleLines.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],
a["Core/Utilities.js"]],function(a,f,h,d){var w=this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var b in e)e.hasOwnProperty(b)&&(a[b]=e[b])};return a(c,e)};return function(c,e){function b(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),u=h.seriesTypes.sma,g=d.correctFloat,x=d.extend,l=d.isArray,v=d.merge;d=function(a){function c(){return null!==
a&&a.apply(this,arguments)||this}w(c,a);c.prototype.calculateDM=function(a,b,n){var e=a[b][1],c=a[b][2],d=a[b-1][1];a=a[b-1][2];return g(e-d>a-c?n?Math.max(e-d,0):0:n?0:Math.max(a-c,0))};c.prototype.calculateDI=function(a,b){return a/b*100};c.prototype.calculateDX=function(a,b){return g(Math.abs(a-b)/Math.abs(a+b)*100)};c.prototype.smoothValues=function(a,b,c){return g(a-a/c+b)};c.prototype.getTR=function(a,b){return g(Math.max(a[1]-a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};c.prototype.getValues=
function(a,b){b=b.period;var c=a.xData,e=(a=a.yData)?a.length:0,d=[],g=[],h=[];if(!(c.length<=b)&&l(a[0])&&4===a[0].length){var f=0,m=0,t=0,k;for(k=1;k<e;k++)if(k<=b){var p=this.calculateDM(a,k,!0);var q=this.calculateDM(a,k);var r=this.getTR(a[k],a[k-1]);f+=p;m+=q;t+=r;k===b&&(r=this.calculateDI(f,t),q=this.calculateDI(m,t),p=this.calculateDX(f,m),d.push([c[k],p,r,q]),g.push(c[k]),h.push([p,r,q]))}else p=this.calculateDM(a,k,!0),q=this.calculateDM(a,k),r=this.getTR(a[k],a[k-1]),f=this.smoothValues(f,
p,b),m=this.smoothValues(m,q,b),t=this.smoothValues(t,r,b),r=this.calculateDI(f,t),q=this.calculateDI(m,t),p=this.calculateDX(f,m),d.push([c[k],p,r,q]),g.push(c[k]),h.push([p,r,q]);return{values:d,xData:g,yData:h}}};c.defaultOptions=v(u.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},
plusDILine:{styles:{lineWidth:1,lineColor:f.positiveColor}},minusDILine:{styles:{lineWidth:1,lineColor:f.negativeColor}},dataGrouping:{approximation:"averages"}});return c}(u);x(d.prototype,{nameBase:"DMI",pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y",linesApiNames:["plusDILine","minusDILine"],drawGraph:a.drawGraph,getTranslatedLinesNames:a.getTranslatedLinesNames,translate:a.translate,toYData:a.toYData});h.registerSeriesType("dmi",d);"";return d});
h(a,"masters/indicators/dmi.src.js",[],function(){})});
//# sourceMappingURL=dmi.js.map