/*
 Highcharts Stock JS v9.1.2 (2021-06-16)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Karol Kolodziej

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/klinger",["highcharts","highcharts/modules/stock"],function(c){a(c);a.Highcharts=c;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function c(a,e,n,b){a.hasOwnProperty(e)||(a[e]=b.apply(null,n))}a=a?a._modules:{};c(a,"Mixins/IndicatorRequired.js",[a["Core/Utilities.js"]],function(a){var e=a.error;return{isParentLoaded:function(a,
b,c,f,g){if(a)return f?f(a):!0;e(g||this.generateMessage(c,b));return!1},generateMessage:function(a,b){return'Error: "'+a+'" indicator type requires "'+b+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+a}}});c(a,"Mixins/MultipleLines.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,e){var c=e.defined,b=e.error,v=e.merge,f=a.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(a){var g=
[];(this.pointArrayMap||[]).forEach(function(b){b!==a&&g.push("plot"+b.charAt(0).toUpperCase()+b.slice(1))});return g},toYData:function(a){var g=[];(this.pointArrayMap||[]).forEach(function(b){g.push(a[b])});return g},translate:function(){var a=this,b=a.pointArrayMap,e=[],c;e=a.getTranslatedLinesNames();f.prototype.translate.apply(a,arguments);a.points.forEach(function(g){b.forEach(function(b,f){c=g[b];null!==c&&(g[e[f]]=a.yAxis.toPixels(c,!0))})})},drawGraph:function(){var a=this,e=a.linesApiNames,
k=a.points,p=k.length,l=a.options,n=a.graph,x={options:{gapSize:l.gapSize}},q=[],d;a.getTranslatedLinesNames(a.pointValKey).forEach(function(a,t){for(q[t]=[];p--;)d=k[p],q[t].push({x:d.x,plotX:d.plotX,plotY:d[a],isNull:!c(d[a])});p=k.length});e.forEach(function(d,t){q[t]?(a.points=q[t],l[d]?a.options=v(l[d].styles,x):b('Error: "There is no '+d+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+d],f.prototype.drawGraph.call(a),
a["graph"+d]=a.graph):b('Error: "'+d+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=k;a.options=l;a.graph=n;f.prototype.drawGraph.call(a)}}});c(a,"Stock/Indicators/Klinger/KlingerIndicator.js",[a["Mixins/IndicatorRequired.js"],a["Mixins/MultipleLines.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,e,c,b){var n=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,d){a.__proto__=d}||function(a,d){for(var h in d)d.hasOwnProperty(h)&&(a[h]=d[h])};return a(b,d)};return function(b,d){function h(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(h.prototype=d.prototype,new h)}}(),f=c.seriesTypes,g=f.sma,r=f.ema,k=b.correctFloat,p=b.error;f=b.extend;var l=b.isArray,w=b.merge;b=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}n(c,b);
c.prototype.init=function(){var d=arguments,h=this;a.isParentLoaded(r,"ema",h.type,function(a){a.prototype.init.apply(h,d)})};c.prototype.calculateTrend=function(a,h){return a[h][1]+a[h][2]+a[h][3]>a[h-1][1]+a[h-1][2]+a[h-1][3]?1:-1};c.prototype.isValidData=function(a){var d=this.chart,b=this.options,c=this.linkedParent;a=l(a)&&4===a.length;(d=this.volumeSeries||(this.volumeSeries=d.get(b.params.volumeSeriesID)))||p("Series "+b.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c.chart);
return!(![c,d].every(function(a){return a&&a.xData&&a.xData.length>=b.params.slowAvgPeriod})||!a)};c.prototype.getCM=function(a,b,c,e,f){return k(b+(c===e?a:f))};c.prototype.getDM=function(a,b){return k(a-b)};c.prototype.getVolumeForce=function(a){var b=[],d=1;var c=0;var e=a[0][1]-a[0][2];var f=0;for(d;d<a.length;d++){var g=this.calculateTrend(a,d);var y=this.getDM(a[d][1],a[d][2]);c=this.getCM(c,y,g,f,e);f=this.volumeSeries.yData[d]*g*Math.abs(2*(y/c-1))*100;b.push([f]);f=g;e=y}return b};c.prototype.getEMA=
function(a,b,c,e,f,g,k){return r.prototype.calculateEma(k||[],a,"undefined"===typeof g?1:g,e,b,"undefined"===typeof f?-1:f,c)};c.prototype.getSMA=function(a,b,c){return r.prototype.accumulatePeriodPoints(a,b,c)/a};c.prototype.getValues=function(a,b){var c=[],d=a.xData;a=a.yData;var e=[],f=[],g=[],h,m=0,l=0,n=void 0,p=void 0,q=null;if(this.isValidData(a[0])){var u=this.getVolumeForce(a),r=this.getSMA(b.fastAvgPeriod,0,u),v=this.getSMA(b.slowAvgPeriod,0,u),w=2/(b.fastAvgPeriod+1),x=2/(b.slowAvgPeriod+
1);for(m;m<a.length;m++)m>=b.fastAvgPeriod&&(n=l=this.getEMA(u,n,r,w,0,m,d)[1]),m>=b.slowAvgPeriod&&(p=h=this.getEMA(u,p,v,x,0,m,d)[1],h=k(l-h),g.push(h),g.length>=b.signalPeriod&&(q=g.slice(-b.signalPeriod).reduce(function(a,b){return a+b})/b.signalPeriod),c.push([d[m],h,q]),e.push(d[m]),f.push([h,q]));return{values:c,xData:e,yData:f}}};c.defaultOptions=w(g.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},
dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});return c}(g);f(b.prototype,{linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y",
drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,translate:e.translate,toYData:e.toYData});c.registerSeriesType("klinger",b);"";return b});c(a,"masters/indicators/klinger.src.js",[],function(){})});
//# sourceMappingURL=klinger.js.map