/*
 Highcharts JS v9.1.2 (2021-06-16)

 Annotations module

 (c) 2009-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/annotations-advanced",["highcharts"],function(u){d(u);d.Highcharts=u;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function u(f,d,l,m){f.hasOwnProperty(d)||(f[d]=m.apply(null,l))}d=d?d._modules:{};u(d,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[d["Core/Globals.js"],d["Core/Utilities.js"]],function(f,
d){var k=d.addEvent,m=d.fireEvent,n=d.objectEach,q=d.pick,e=d.removeEvent;return{addEvents:function(){var b=this,a=function(c){k(c,f.isTouchDevice?"touchstart":"mousedown",function(c){b.onMouseDown(c)},{passive:!1})};a(this.graphic.element);(b.labels||[]).forEach(function(c){c.options.useHTML&&c.graphic.text&&a(c.graphic.text.element)});n(b.options.events,function(c,a){var g=function(g){"click"===a&&b.cancelClick||c.call(b,b.chart.pointer.normalize(g),b.target)};if(-1===(b.nonDOMEvents||[]).indexOf(a))b.graphic.on(a,
g);else k(b,a,g,{passive:!1})});if(b.options.draggable&&(k(b,"drag",b.onDrag),!b.graphic.renderer.styledMode)){var c={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[b.options.draggable]};b.graphic.css(c);(b.labels||[]).forEach(function(a){a.options.useHTML&&a.graphic.text&&a.graphic.text.css(c)})}b.isUpdating||m(b,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(b){var a=this,
c=a.chart.pointer;b.preventDefault&&b.preventDefault();if(2!==b.button){b=c.normalize(b);var h=b.chartX;var g=b.chartY;a.cancelClick=!1;a.chart.hasDraggedAnnotation=!0;a.removeDrag=k(f.doc,f.isTouchDevice?"touchmove":"mousemove",function(b){a.hasDragged=!0;b=c.normalize(b);b.prevChartX=h;b.prevChartY=g;m(a,"drag",b);h=b.chartX;g=b.chartY},f.isTouchDevice?{passive:!1}:void 0);a.removeMouseUp=k(f.doc,f.isTouchDevice?"touchend":"mouseup",function(c){a.cancelClick=a.hasDragged;a.hasDragged=!1;a.chart.hasDraggedAnnotation=
!1;m(q(a.target,a),"afterUpdate");a.onMouseUp(c)},f.isTouchDevice?{passive:!1}:void 0)}},onMouseUp:function(b){var a=this.chart;b=this.target||this;var c=a.options.annotations;a=a.annotations.indexOf(b);this.removeDocEvents();c[a]=b.options},onDrag:function(b){if(this.chart.isInsidePlot(b.chartX-this.chart.plotLeft,b.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var a=this.mouseMoveToTranslation(b);"x"===this.options.draggable&&(a.y=0);"y"===this.options.draggable&&(a.x=0);this.points.length?this.translate(a.x,
a.y):(this.shapes.forEach(function(c){c.translate(a.x,a.y)}),this.labels.forEach(function(c){c.translate(a.x,a.y)}));this.redraw(!1)}},mouseMoveToRadians:function(b,a,c){var h=b.prevChartY-c,g=b.prevChartX-a;c=b.chartY-c;b=b.chartX-a;this.chart.inverted&&(a=g,g=h,h=a,a=b,b=c,c=a);return Math.atan2(c,b)-Math.atan2(h,g)},mouseMoveToTranslation:function(b){var a=b.chartX-b.prevChartX;b=b.chartY-b.prevChartY;if(this.chart.inverted){var c=b;b=a;a=c}return{x:a,y:b}},mouseMoveToScale:function(b,a,c){a=(b.chartX-
a||1)/(b.prevChartX-a||1);b=(b.chartY-c||1)/(b.prevChartY-c||1);this.chart.inverted&&(c=b,b=a,a=c);return{x:a,y:b}},destroy:function(){this.removeDocEvents();e(this);this.hcEvents=null}}});u(d,"Extensions/Annotations/ControlPoint.js",[d["Core/Utilities.js"],d["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],function(f,d){var k=f.merge,m=f.pick;return function(){function f(f,e,b,a){this.addEvents=d.addEvents;this.graphic=void 0;this.mouseMoveToRadians=d.mouseMoveToRadians;this.mouseMoveToScale=
d.mouseMoveToScale;this.mouseMoveToTranslation=d.mouseMoveToTranslation;this.onDrag=d.onDrag;this.onMouseDown=d.onMouseDown;this.onMouseUp=d.onMouseUp;this.removeDocEvents=d.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=f;this.target=e;this.options=b;this.index=m(b.index,a)}f.prototype.setVisibility=function(f){this.graphic.attr("visibility",f?"visible":"hidden");this.options.visible=f};f.prototype.render=function(){var f=this.chart,e=this.options;this.graphic=f.renderer.symbol(e.symbol,0,
0,e.width,e.height).add(f.controlPointsGroup).css(e.style);this.setVisibility(e.visible);this.addEvents()};f.prototype.redraw=function(f){this.graphic[f?"animate":"attr"](this.options.positioner.call(this,this.target))};f.prototype.destroy=function(){d.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};f.prototype.update=function(f){var e=this.chart,b=this.target,a=this.index;f=k(!0,this.options,f);this.destroy();this.constructor(e,b,f,
a);this.render(e.controlPointsGroup);this.redraw()};return f}()});u(d,"Extensions/Annotations/MockPoint.js",[d["Core/Series/Series.js"],d["Core/Utilities.js"],d["Core/Axis/Axis.js"]],function(f,d,l){var k=d.defined,n=d.fireEvent;return function(){function d(e,b,a){this.y=this.x=this.ttBelow=this.plotY=this.plotX=this.negative=this.isInside=void 0;this.mock=!0;this.series={visible:!0,chart:e,getPlotBox:f.prototype.getPlotBox};this.target=b||null;this.options=a;this.applyOptions(this.getOptions())}
d.fromPoint=function(e){return new d(e.series.chart,null,{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis})};d.pointToPixels=function(e,b){var a=e.series,c=a.chart,h=e.plotX,g=e.plotY;c.inverted&&(e.mock?(h=e.plotY,g=e.plotX):(h=c.plotWidth-e.plotY,g=c.plotHeight-e.plotX));a&&!b&&(e=a.getPlotBox(),h+=e.translateX,g+=e.translateY);return{x:h,y:g}};d.pointToOptions=function(e){return{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis}};d.prototype.hasDynamicOptions=function(){return"function"===
typeof this.options};d.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options};d.prototype.applyOptions=function(e){this.command=e.command;this.setAxis(e,"x");this.setAxis(e,"y");this.refresh()};d.prototype.setAxis=function(e,b){b+="Axis";e=e[b];var a=this.series.chart;this.series[b]=e instanceof l?e:k(e)?a[b][e]||a.get(e):null};d.prototype.toAnchor=function(){var e=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(e[0]=this.plotY,e[1]=this.plotX);
return e};d.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};d.prototype.isInsidePlot=function(){var e=this.plotX,b=this.plotY,a=this.series.xAxis,c=this.series.yAxis,h={x:e,y:b,isInsidePlot:!0};a&&(h.isInsidePlot=k(e)&&0<=e&&e<=a.len);c&&(h.isInsidePlot=h.isInsidePlot&&k(b)&&0<=b&&b<=c.len);n(this.series.chart,"afterIsInsidePlot",h);return h.isInsidePlot};d.prototype.refresh=function(){var e=this.series,b=e.xAxis;e=e.yAxis;var a=this.getOptions();b?(this.x=a.x,this.plotX=
b.toPixels(a.x,!0)):(this.x=null,this.plotX=a.x);e?(this.y=a.y,this.plotY=e.toPixels(a.y,!0)):(this.y=null,this.plotY=a.y);this.isInside=this.isInsidePlot()};d.prototype.translate=function(e,b,a,c){this.hasDynamicOptions()||(this.plotX+=a,this.plotY+=c,this.refreshOptions())};d.prototype.scale=function(e,b,a,c){if(!this.hasDynamicOptions()){var h=this.plotY*c;this.plotX=(1-a)*e+this.plotX*a;this.plotY=(1-c)*b+h;this.refreshOptions()}};d.prototype.rotate=function(e,b,a){if(!this.hasDynamicOptions()){var c=
Math.cos(a);a=Math.sin(a);var h=this.plotX,g=this.plotY;h-=e;g-=b;this.plotX=h*c-g*a+e;this.plotY=h*a+g*c+b;this.refreshOptions()}};d.prototype.refreshOptions=function(){var e=this.series,b=e.xAxis;e=e.yAxis;this.x=this.options.x=b?this.options.x=b.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=e?e.toValue(this.plotY,!0):this.plotY};return d}()});u(d,"Extensions/Annotations/Mixins/ControllableMixin.js",[d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/MockPoint.js"],
d["Core/Tooltip.js"],d["Core/Utilities.js"]],function(f,d,l,m){var k=m.isObject,q=m.isString,e=m.merge,b=m.splat;return{init:function(a,c,b){this.annotation=a;this.chart=a.chart;this.options=c;this.points=[];this.controlPoints=[];this.index=b;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var a=this.options;return a.points||a.point&&b(a.point)},attrsFromOptions:function(a){var c=this.constructor.attrsMap,b={},
g,r=this.chart.styledMode;for(g in a){var e=c[g];!e||r&&-1!==["fill","stroke","stroke-width"].indexOf(e)||(b[e]=a[g])}return b},anchor:function(a){var c=a.series.getPlotBox(),b=a.series.chart,g=a.mock?a.toAnchor():l.prototype.getAnchor.call({chart:a.series.chart},a);g={x:g[0]+(this.options.x||0),y:g[1]+(this.options.y||0),height:g[2]||0,width:g[3]||0};return{relativePosition:g,absolutePosition:e(g,{x:g.x+(a.mock?c.translateX:b.plotLeft),y:g.y+(a.mock?c.translateY:b.plotTop)})}},point:function(a,c){if(a&&
a.series)return a;c&&null!==c.series||(k(a)?c=new d(this.chart,this,a):q(a)?c=this.chart.get(a)||null:"function"===typeof a&&(c=a.call(c,this),c=c.series?c:new d(this.chart,this,a)));return c},linkPoints:function(){var a=this.getPointsOptions(),c=this.points,b=a&&a.length||0,g;for(g=0;g<b;g++){var r=this.point(a[g],c[g]);if(!r){c.length=0;return}r.mock&&r.refresh();c[g]=r}return c},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(c,b){c=e(this.options.controlPointOptions,
c);c.index||(c.index=b);a[b]=c;this.controlPoints.push(new f(this.chart,this,c))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(a){this.controlPoints.forEach(function(c){c.render()})},redraw:function(a){this.controlPoints.forEach(function(c){c.redraw(a)})},transform:function(a,c,b,g,r){if(this.chart.inverted){var h=c;c=b;b=h}this.points.forEach(function(h,e){this.transformPoint(a,c,b,g,r,e)},this)},transformPoint:function(a,c,b,g,r,e){var h=this.points[e];h.mock||(h=
this.points[e]=d.fromPoint(h));h[a](c,b,g,r)},translate:function(a,c){this.transform("translate",null,null,a,c)},translatePoint:function(a,c,b){this.transformPoint("translate",null,null,a,c,b)},translateShape:function(a,c){var b=this.annotation.chart,g=this.annotation.userOptions,r=b.annotations.indexOf(this.annotation);b=b.options.annotations[r];this.translatePoint(a,c,0);b[this.collection][this.index].point=this.options.point;g[this.collection][this.index].point=this.options.point},rotate:function(a,
c,b){this.transform("rotate",a,c,b)},scale:function(a,c,b,g){this.transform("scale",a,c,b,g)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(c){c.setVisibility(a)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var c=this.annotation;
a=e(!0,this.options,a);var b=this.graphic.parentGroup;this.destroy();this.constructor(c,a,this.index);this.render(b);this.redraw()}}});u(d,"Extensions/Annotations/Mixins/MarkerMixin.js",[d["Core/Chart/Chart.js"],d["Core/Renderer/SVG/SVGRenderer.js"],d["Core/Utilities.js"]],function(f,d,l){function k(c){return function(a){this.attr(c,"url(#"+a+")")}}var n=l.addEvent,q=l.defined,e=l.merge,b=l.uniqueKey,a={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",
attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};d.prototype.addMarker=function(c,a){var b={attributes:{id:c}},r={stroke:a.color||"none",fill:a.color||"rgba(0, 0, 0, 0.75)"};b.children=a.children&&a.children.map(function(a){return e(r,a)});a=e(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,
refY:0,orient:"auto"}},a,b);a=this.definition(a);a.id=c;return a};d={markerEndSetter:k("marker-end"),markerStartSetter:k("marker-start"),setItemMarkers:function(a){var c=a.options,g=a.chart,r=g.options.defs,f=c.fill,d=q(f)&&"none"!==f?f:c.stroke;["markerStart","markerEnd"].forEach(function(h){var f=c[h],w;if(f){for(w in r){var A=r[w];if((f===(A.attributes&&A.attributes.id)||f===A.id)&&"marker"===A.tagName){var p=A;break}}p&&(f=a[h]=g.renderer.addMarker((c.id||b())+"-"+f,e(p,{color:d})),a.attr(h,f.getAttribute("id")))}})}};
n(f,"afterGetContainer",function(){this.options.defs=e(a,this.options.defs||{})});return d});u(d,"Extensions/Annotations/Controllables/ControllablePath.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Core/Globals.js"],d["Extensions/Annotations/Mixins/MarkerMixin.js"],d["Core/Utilities.js"]],function(f,d,l,m){var k=m.extend,q="rgba(192,192,192,"+(d.svg?.0001:.002)+")";return function(){function e(b,a,c){this.addControlPoints=f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;
this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=f.setControlPointsVisibility;this.setMarkers=l.setItemMarkers;this.transform=f.transform;this.transformPoint=f.transformPoint;this.translate=f.translate;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;this.update=f.update;this.type="path";
this.init(b,a,c);this.collection="shapes"}e.prototype.toD=function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;b=this.points;var a=b.length,c=a,h=b[0],g=c&&this.anchor(h).absolutePosition,r=0,e=[];if(g)for(e.push(["M",g.x,g.y]);++r<a&&c;)h=b[r],c=h.command||"L",g=this.anchor(h).absolutePosition,"M"===c?e.push([c,g.x,g.y]):"L"===c?e.push([c,g.x,g.y]):"Z"===c&&e.push([c]),c=h.series.visible;return c?this.chart.renderer.crispLine(e,this.graphic.strokeWidth()):null};e.prototype.shouldBeDrawn=
function(){return f.shouldBeDrawn.call(this)||!!this.options.d};e.prototype.render=function(b){var a=this.options,c=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(c).add(b);a.className&&this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(b);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:q,fill:q,"stroke-width":this.graphic.strokeWidth()+
2*a.snap});f.render.call(this);k(this.graphic,{markerStartSetter:l.markerStartSetter,markerEndSetter:l.markerEndSetter});this.setMarkers(this)};e.prototype.redraw=function(b){var a=this.toD(),c=b?"animate":"attr";a?(this.graphic[c]({d:a}),this.tracker[c]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!a;f.redraw.call(this,b)};e.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",
zIndex:"zIndex"};return e}()});u(d,"Extensions/Annotations/Controllables/ControllableRect.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Core/Utilities.js"]],function(f,d,l){var k=l.merge;return function(){function l(d,e,b){this.addControlPoints=f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;
this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=f.setControlPointsVisibility;this.shouldBeDrawn=f.shouldBeDrawn;this.transform=f.transform;this.transformPoint=f.transformPoint;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;this.update=f.update;this.type="rect";this.translate=f.translateShape;this.init(d,e,b);this.collection="shapes"}l.prototype.render=function(d){var e=this.attrsFromOptions(this.options);
this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(e).add(d);f.render.call(this)};l.prototype.redraw=function(d){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[d?"animate":"attr"]({x:e.x,y:e.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!e;f.redraw.call(this,d)};l.attrsMap=k(d.attrsMap,{width:"width",height:"height"});return l}()});u(d,"Extensions/Annotations/Controllables/ControllableCircle.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],
d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Core/Utilities.js"]],function(f,d,l){var k=l.merge;return function(){function l(d,e,b){this.addControlPoints=f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=f.setControlPointsVisibility;
this.shouldBeDrawn=f.shouldBeDrawn;this.transform=f.transform;this.transformPoint=f.transformPoint;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;this.update=f.update;this.type="circle";this.translate=f.translateShape;this.init(d,e,b);this.collection="shapes"}l.prototype.render=function(d){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(e).add(d);f.render.call(this)};l.prototype.redraw=function(d){var e=this.anchor(this.points[0]).absolutePosition;
if(e)this.graphic[d?"animate":"attr"]({x:e.x,y:e.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!e;f.redraw.call(this,d)};l.prototype.setRadius=function(d){this.options.r=d};l.attrsMap=k(d.attrsMap,{r:"r"});return l}()});u(d,"Extensions/Annotations/Controllables/ControllableLabel.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Core/FormatUtilities.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Renderer/SVG/SVGRenderer.js"],d["Core/Tooltip.js"],
d["Core/Utilities.js"]],function(d,k,l,m,n,q){var e=k.format;k=m.prototype.symbols;var b=q.extend,a=q.isNumber,c=q.pick;q=function(){function a(a,c,b){this.addControlPoints=d.addControlPoints;this.attr=d.attr;this.attrsFromOptions=d.attrsFromOptions;this.destroy=d.destroy;this.getPointsOptions=d.getPointsOptions;this.init=d.init;this.linkPoints=d.linkPoints;this.point=d.point;this.rotate=d.rotate;this.scale=d.scale;this.setControlPointsVisibility=d.setControlPointsVisibility;this.shouldBeDrawn=d.shouldBeDrawn;
this.transform=d.transform;this.transformPoint=d.transformPoint;this.translateShape=d.translateShape;this.update=d.update;this.init(a,c,b);this.collection="labels"}a.alignedPosition=function(a,c){var b=a.align,g=a.verticalAlign,r=(c.x||0)+(a.x||0),h=(c.y||0)+(a.y||0),d,e;"right"===b?d=1:"center"===b&&(d=2);d&&(r+=(c.width-(a.width||0))/d);"bottom"===g?e=1:"middle"===g&&(e=2);e&&(h+=(c.height-(a.height||0))/e);return{x:Math.round(r),y:Math.round(h)}};a.justifiedOptions=function(a,c,b,h){var g=b.align,
r=b.verticalAlign,d=c.box?0:c.padding||0,e=c.getBBox();c={align:g,verticalAlign:r,x:b.x,y:b.y,width:c.width,height:c.height};b=(h.x||0)-a.plotLeft;h=(h.y||0)-a.plotTop;var f=b+d;0>f&&("right"===g?c.align="left":c.x=(c.x||0)-f);f=b+e.width-d;f>a.plotWidth&&("left"===g?c.align="right":c.x=(c.x||0)+a.plotWidth-f);f=h+d;0>f&&("bottom"===r?c.verticalAlign="top":c.y=(c.y||0)-f);f=h+e.height-d;f>a.plotHeight&&("top"===r?c.verticalAlign="bottom":c.y=(c.y||0)+a.plotHeight-f);return c};a.prototype.translatePoint=
function(a,c){d.translatePoint.call(this,a,c,0)};a.prototype.translate=function(a,c){var b=this.annotation.chart,g=this.annotation.userOptions,h=b.annotations.indexOf(this.annotation);h=b.options.annotations[h];b.inverted&&(b=a,a=c,c=b);this.options.x+=a;this.options.y+=c;h[this.collection][this.index].x=this.options.x;h[this.collection][this.index].y=this.options.y;g[this.collection][this.index].x=this.options.x;g[this.collection][this.index].y=this.options.y};a.prototype.render=function(c){var b=
this.options,g=this.attrsFromOptions(b),h=b.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,b.shape,null,null,b.useHTML,null,"annotation-label").attr(g).add(c);this.annotation.chart.styledMode||("contrast"===h.color&&(h.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(b.shape)?"#FFFFFF":b.backgroundColor)),this.graphic.css(b.style).shadow(b.shadow));b.className&&this.graphic.addClass(b.className);this.graphic.labelrank=b.labelrank;d.render.call(this)};
a.prototype.redraw=function(a){var c=this.options,b=this.text||c.format||c.text,g=this.graphic,h=this.points[0];g.attr({text:b?e(b,h.getLabelConfig(),this.annotation.chart):c.formatter.call(h,this)});c=this.anchor(h);(b=this.position(c))?(g.alignAttr=b,b.anchorX=c.absolutePosition.x,b.anchorY=c.absolutePosition.y,g[a?"animate":"attr"](b)):g.attr({x:0,y:-9999});g.placed=!!b;d.redraw.call(this,a)};a.prototype.anchor=function(a){var c=d.anchor.apply(this,arguments),b=this.options.x||0,g=this.options.y||
0;c.absolutePosition.x-=b;c.absolutePosition.y-=g;c.relativePosition.x-=b;c.relativePosition.y-=g;return c};a.prototype.position=function(g){var h=this.graphic,d=this.annotation.chart,e=this.points[0],f=this.options,k=g.absolutePosition,q=g.relativePosition,m=e.series.visible&&l.prototype.isInsidePlot.call(e);g=h.width;g=void 0===g?0:g;var p=h.height;p=void 0===p?0:p;if(m){if(f.distance)var x=n.prototype.getPosition.call({chart:d,distance:c(f.distance,16)},g,p,{plotX:q.x,plotY:q.y,negative:e.negative,
ttBelow:e.ttBelow,h:q.height||q.width});else f.positioner?x=f.positioner.call(this):(e={x:k.x,y:k.y,width:0,height:0},x=a.alignedPosition(b(f,{width:g,height:p}),e),"justify"===this.options.overflow&&(x=a.alignedPosition(a.justifiedOptions(d,h,f,x),e)));f.crop&&(h=x.x-d.plotLeft,f=x.y-d.plotTop,m=d.isInsidePlot(h,f)&&d.isInsidePlot(h+g,f+p))}return m?x:null};a.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};a.shapesWithoutBackground=
["connector"];return a}();k.connector=function(c,b,d,e,f){var g=f&&f.anchorX;f=f&&f.anchorY;var h=d/2;if(a(g)&&a(f)){var r=[["M",g,f]];var w=b-f;0>w&&(w=-e-w);w<d&&(h=g<c+d/2?w:d-w);f>b+e?r.push(["L",c+h,b+e]):f<b?r.push(["L",c+h,b]):g<c?r.push(["L",c,b+e/2]):g>c+d&&r.push(["L",c+d,b+e/2])}return r||[]};return q});u(d,"Extensions/Annotations/Controllables/ControllableImage.js",[d["Extensions/Annotations/Controllables/ControllableLabel.js"],d["Extensions/Annotations/Mixins/ControllableMixin.js"]],
function(d,k){return function(){function f(d,f,l){this.addControlPoints=k.addControlPoints;this.anchor=k.anchor;this.attr=k.attr;this.attrsFromOptions=k.attrsFromOptions;this.destroy=k.destroy;this.getPointsOptions=k.getPointsOptions;this.init=k.init;this.linkPoints=k.linkPoints;this.point=k.point;this.rotate=k.rotate;this.scale=k.scale;this.setControlPointsVisibility=k.setControlPointsVisibility;this.shouldBeDrawn=k.shouldBeDrawn;this.transform=k.transform;this.transformPoint=k.transformPoint;this.translatePoint=
k.translatePoint;this.translateShape=k.translateShape;this.update=k.update;this.type="image";this.translate=k.translateShape;this.init(d,f,l);this.collection="shapes"}f.prototype.render=function(d){var f=this.attrsFromOptions(this.options),l=this.options;this.graphic=this.annotation.chart.renderer.image(l.src,0,-9E9,l.width,l.height).attr(f).add(d);this.graphic.width=l.width;this.graphic.height=l.height;k.render.call(this)};f.prototype.redraw=function(f){var l=this.anchor(this.points[0]);if(l=d.prototype.position.call(this,
l))this.graphic[f?"animate":"attr"]({x:l.x,y:l.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!l;k.redraw.call(this,f)};f.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return f}()});u(d,"Extensions/Annotations/Annotations.js",[d["Core/Animation/AnimationUtilities.js"],d["Core/Chart/Chart.js"],d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Extensions/Annotations/Controllables/ControllableRect.js"],d["Extensions/Annotations/Controllables/ControllableCircle.js"],
d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Extensions/Annotations/Controllables/ControllableImage.js"],d["Extensions/Annotations/Controllables/ControllableLabel.js"],d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/Mixins/EventEmitterMixin.js"],d["Core/Globals.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Pointer.js"],d["Core/Utilities.js"],d["Core/Color/Palette.js"]],function(d,k,l,m,n,q,e,b,a,c,h,g,r,w,A){var f=d.getDeferredAnimation;d=k.prototype;
var v=w.addEvent,z=w.defined,C=w.destroyObjectProperties,p=w.erase,x=w.extend,D=w.find,E=w.fireEvent,t=w.merge,y=w.pick,G=w.splat;w=w.wrap;var F=function(){function h(c,a){this.annotation=void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=this.collection=void 0;this.chart=c;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=t(this.defaultOptions,a);this.userOptions=a;
a=this.getLabelsAndShapesOptions(this.options,a);this.options.labels=a.labels;this.options.shapes=a.shapes;this.init(c,this.options)}h.prototype.init=function(){var c=this.chart,a=this.options.animation;this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=f(c,a)};h.prototype.getLabelsAndShapesOptions=function(c,a){var b={};["labels","shapes"].forEach(function(g){c[g]&&(b[g]=G(a[g]).map(function(a,b){return t(c[g][b],a)}))});return b};
h.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(a,c){a=this.initShape(a,c);t(!0,this.options.shapes[c],a.options)},this)};h.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(a,c){a=this.initLabel(a,c);t(!0,this.options.labels[c],a.options)},this)};h.prototype.addClipPaths=function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};h.prototype.setClipAxes=function(){var a=this.chart.xAxis,
c=this.chart.yAxis,b=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(b,g){return[a[g&&g.point&&g.point.xAxis]||b[0],c[g&&g.point&&g.point.yAxis]||b[1]]},[]);this.clipXAxis=b[0];this.clipYAxis=b[1]};h.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};h.prototype.setLabelCollector=function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,
c){c.options.allowOverlap||a.push(c.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)};h.prototype.setOptions=function(a){this.options=t(this.defaultOptions,a)};h.prototype.redraw=function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);l.redraw.call(this,a)};h.prototype.redrawItems=function(a,c){for(var b=a.length;b--;)this.redrawItem(a[b],c)};h.prototype.renderItems=
function(a){for(var c=a.length;c--;)this.renderItem(a[c])};h.prototype.render=function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);
this.renderItems(this.labels);this.addEvents();l.render.call(this)};h.prototype.setVisibility=function(a){var c=this.options;a=y(a,!c.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);c.visible=a};h.prototype.setControlPointsVisibility=function(a){var c=function(c){c.setControlPointsVisibility(a)};l.setControlPointsVisibility.call(this,a);this.shapes.forEach(c);this.labels.forEach(c)};h.prototype.destroy=function(){var a=this.chart,b=function(a){a.destroy()};
this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;p(a.labelCollectors,this.labelCollector);c.destroy.call(this);l.destroy.call(this);C(this,a)};h.prototype.remove=function(){return this.chart.removeAnnotation(this)};h.prototype.update=function(a,c){var b=this.chart,g=this.getLabelsAndShapesOptions(this.userOptions,a),h=b.annotations.indexOf(this);a=t(!0,this.userOptions,a);a.labels=g.labels;a.shapes=g.shapes;this.destroy();this.constructor(b,a);b.options.annotations[h]=
a;this.isUpdating=!0;y(c,!0)&&b.redraw();E(this,"afterUpdate");this.isUpdating=!1};h.prototype.initShape=function(a,c){a=t(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},a);c=new h.shapesMap[a.type](this,a,c);c.itemType="shape";this.shapes.push(c);return c};h.prototype.initLabel=function(a,c){a=t(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);c=new b(this,a,c);c.itemType="label";this.labels.push(c);return c};h.prototype.redrawItem=
function(a,c){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(y(c,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)};h.prototype.adjustVisibility=function(a){var c=!1,b=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(c=!0)});c?"hidden"===b.visibility&&b.show():b.hide()};h.prototype.destroyItem=function(a){p(this[a.itemType+"s"],a);a.destroy()};h.prototype.renderItem=function(a){a.render("label"===a.itemType?
this.labelsGroup:this.shapesGroup)};h.ControlPoint=a;h.MockPoint=g;h.shapesMap={rect:m,circle:n,path:q,image:e};h.types={};return h}();t(!0,F.prototype,l,c,t(F.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:A.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return z(this.y)?this.y:
"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:A.neutralColor100,"stroke-width":2,fill:A.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));h.extendAnnotation=function(a,
c,b,g){c=c||F;x(a.prototype,t(c.prototype,b));a.prototype.defaultOptions=t(a.prototype.defaultOptions,g||{})};x(d,{initAnnotation:function(a){a=new (F.types[a.type]||F)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,c){a=this.initAnnotation(a);this.options.annotations.push(a.options);y(c,!0)&&(a.redraw(),a.graphic.attr({opacity:1}));return a},removeAnnotation:function(a){var c=this.annotations,b="annotations"===a.coll?a:D(c,function(c){return c.options.id===a});b&&(E(b,"remove"),
p(this.options.annotations,b.options),p(c,b),b.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw();a.graphic.animate({opacity:1},a.animationConfig)})}});d.collectionsWithUpdate.push("annotations");d.collectionsWithInit.annotations=[d.addAnnotation];v(k,"afterInit",function(){this.annotations=[];this.options.annotations||(this.options.annotations=[])});d.callbacks.push(function(a){a.plotBoxClip=this.renderer.clipRect(this.plotBox);
a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(c,b){if(!a.annotations.some(function(a){return a.options===c})){var g=a.initAnnotation(c);a.options.annotations[b]=g.options}});a.drawAnnotations();v(a,"redraw",a.drawAnnotations);v(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()});v(a,"exportData",function(c){var b=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,
g=!c.dataRows[1].xValues,h=a.options.lang&&a.options.lang.exportData&&a.options.lang.exportData.annotationHeader,d=function(a){if(b){var c=b(a);if(!1!==c)return c}c=h+" "+a;return g?{columnTitle:c,topLevelColumnTitle:c}:c},e=c.dataRows[0].length,f=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.itemDelimiter,r=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.join;
a.annotations.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var b=a.options.text;a.points.forEach(function(a){var g=a.x,h=a.series.xAxis?a.series.xAxis.options.index:-1,d=!1;if(-1===h){a=c.dataRows[0].length;for(var t=Array(a),y=0;y<a;++y)t[y]="";t.push(b);t.xValues=[];t.xValues[h]=g;c.dataRows.push(t);d=!0}d||c.dataRows.forEach(function(a,c){!d&&a.xValues&&void 0!==h&&g===a.xValues[h]&&(r&&a.length>e?a[a.length-1]+=f+b:a.push(b),d=
!0)});if(!d){a=c.dataRows[0].length;t=Array(a);for(y=0;y<a;++y)t[y]="";t[0]=g;t.push(b);t.xValues=[];void 0!==h&&(t.xValues[h]=g);c.dataRows.push(t)}})}})});var t=0;c.dataRows.forEach(function(a){t=Math.max(t,a.length)});for(var E=t-c.dataRows[0].length,y=0;y<E;y++){var p=d(y+1);g?(c.dataRows[0].push(p.topLevelColumnTitle),c.dataRows[1].push(p.columnTitle)):c.dataRows[0].push(p)}})});w(r.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||a.apply(this,Array.prototype.slice.call(arguments,
1))});return h.Annotation=F});u(d,"Extensions/Annotations/Types/BasicAnnotation.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,k,l){var f=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=
null===b?Object.create(b):(a.prototype=b.prototype,new a)}}();l=l.merge;var n=function(l){function e(b,a){return l.call(this,b,a)||this}f(e,l);e.prototype.addControlPoints=function(){var b=this.options,a=e.basicControlPoints,c=this.basicType;(b.labels||b.shapes).forEach(function(b){b.controlPoints=a[c]})};e.prototype.init=function(){var b=this.options;b.shapes?(delete b.labelOptions,this.basicType="circle"===b.shapes[0].type?"circle":"rectangle"):(delete b.shapes,this.basicType="label");d.prototype.init.apply(this,
arguments)};e.basicControlPoints={label:[{symbol:"triangle-down",positioner:function(b){if(!b.graphic.placed)return{x:0,y:-9E7};b=k.pointToPixels(b.points[0]);return{x:b.x-this.graphic.width/2,y:b.y-this.graphic.height/2}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translatePoint(b.x,b.y);a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}},{symbol:"square",positioner:function(b){return b.graphic.placed?{x:b.graphic.alignAttr.x-this.graphic.width/2,y:b.graphic.alignAttr.y-
this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translate(b.x,b.y);a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}}],rectangle:[{positioner:function(b){b=k.pointToPixels(b.points[2]);return{x:b.x-4,y:b.y-4}},events:{drag:function(b,a){var c=a.annotation,h=this.chart.pointer.getCoordinates(b);b=h.xAxis[0].value;h=h.yAxis[0].value;var g=a.options.points;g[1].x=b;g[2].x=b;g[2].y=h;g[3].y=h;c.userOptions.shapes[0].points=a.options.points;
c.redraw(!1)}}}],circle:[{positioner:function(b){var a=k.pointToPixels(b.points[0]);b=b.options.r;return{x:a.x+b*Math.cos(Math.PI/4)-this.graphic.width/2,y:a.y+b*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(b,a){var c=a.annotation;b=this.mouseMoveToTranslation(b);a.setRadius(Math.max(a.options.r+b.y/Math.sin(Math.PI/4),5));c.userOptions.shapes[0].r=a.options.r;c.userOptions.shapes[0].point=a.options.point;a.redraw(!1)}}}]};return e}(d);n.prototype.defaultOptions=l(d.prototype.defaultOptions,
{});return d.types.basicAnnotation=n});u(d,"Extensions/Annotations/Types/CrookedLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,k,l,m){var f=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,
a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),q=m.merge;m=function(d){function b(a,c){return d.call(this,a,c)||this}f(b,d);b.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=this.chart.yAxis[this.options.typeOptions.yAxis]};b.prototype.getPointsOptions=function(){var a=this.options.typeOptions;return(a.points||[]).map(function(c){c.xAxis=a.xAxis;c.yAxis=a.yAxis;return c})};
b.prototype.getControlPointsOptions=function(){return this.getPointsOptions()};b.prototype.addControlPoints=function(){this.getControlPointsOptions().forEach(function(a,c){c=new k(this.chart,this,q(this.options.controlPointOptions,a.controlPoint),c);this.controlPoints.push(c);a.controlPoint=c.options},this)};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=this.initShape(q(a.line,{type:"path",points:this.points.map(function(a,c){return function(a){return a.annotation.points[c]}})}),
!1);a.line=c.options};return b}(d);m.prototype.defaultOptions=q(d.prototype.defaultOptions,{typeOptions:{xAxis:0,yAxis:0,line:{fill:"none"}},controlPointOptions:{positioner:function(d){var b=this.graphic;d=l.pointToPixels(d.points[this.index]);return{x:d.x-b.width/2,y:d.y-b.height/2}},events:{drag:function(d,b){b.chart.isInsidePlot(d.chartX-b.chart.plotLeft,d.chartY-b.chart.plotTop,{visiblePlotOnly:!0})&&(d=this.mouseMoveToTranslation(d),b.translatePoint(d.x,d.y,this.index),b.options.typeOptions.points[this.index].x=
b.points[this.index].x,b.options.typeOptions.points[this.index].y=b.points[this.index].y,b.redraw(!1))}}}});return d.types.crookedLine=m});u(d,"Extensions/Annotations/Types/ElliottWave.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/CrookedLine.js"],d["Core/Utilities.js"]],function(d,k,l){var f=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&
(a[b]=c[b])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),n=l.merge;l=function(d){function e(b,a){return d.call(this,b,a)||this}f(e,d);e.prototype.addLabels=function(){this.getPointsOptions().forEach(function(b,a){var c=this.initLabel(n(b.label,{text:this.options.typeOptions.labels[a],point:function(c){return c.annotation.points[a]}}),!1);b.label=c.options},this)};return e}(k);l.prototype.defaultOptions=
n(k.prototype.defaultOptions,{typeOptions:{labels:"(0) (A) (B) (C) (D) (E)".split(" "),line:{strokeWidth:1}},labelOptions:{align:"center",allowOverlap:!0,crop:!0,overflow:"none",type:"rect",backgroundColor:"none",borderWidth:0,y:-5}});return d.types.elliottWave=l});u(d,"Extensions/Annotations/Types/Tunnel.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/Types/CrookedLine.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],
function(d,k,l,m,n){var f=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,c)};return function(a,c){function d(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),e=n.merge;n=function(b){function a(a,d){return b.call(this,a,d)||this}f(a,b);a.prototype.getPointsOptions=function(){var a=
l.prototype.getPointsOptions.call(this);a[2]=this.heightPointOptions(a[1]);a[3]=this.heightPointOptions(a[0]);return a};a.prototype.getControlPointsOptions=function(){return this.getPointsOptions().slice(0,2)};a.prototype.heightPointOptions=function(a){a=e(a);a.y+=this.options.typeOptions.height;return a};a.prototype.addControlPoints=function(){l.prototype.addControlPoints.call(this);var a=this.options,b=a.typeOptions;a=new k(this.chart,this,e(a.controlPointOptions,b.heightControlPoint),2);this.controlPoints.push(a);
b.heightControlPoint=a.options};a.prototype.addShapes=function(){this.addLine();this.addBackground()};a.prototype.addLine=function(){var a=this.initShape(e(this.options.typeOptions.line,{type:"path",points:[this.points[0],this.points[1],function(a){a=m.pointToOptions(a.annotation.points[2]);a.command="M";return a},this.points[3]]}),!1);this.options.typeOptions.line=a.options};a.prototype.addBackground=function(){var a=this.initShape(e(this.options.typeOptions.background,{type:"path",points:this.points.slice()}));
this.options.typeOptions.background=a.options};a.prototype.translateSide=function(a,b,g){g=Number(g);var c=0===g?3:2;this.translatePoint(a,b,g);this.translatePoint(a,b,c)};a.prototype.translateHeight=function(a){this.translatePoint(0,a,2);this.translatePoint(0,a,3);this.options.typeOptions.height=this.points[3].y-this.points[0].y};return a}(l);n.prototype.defaultOptions=e(l.prototype.defaultOptions,{typeOptions:{xAxis:0,yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},line:{strokeWidth:1},
height:-2,heightControlPoint:{positioner:function(b){var a=m.pointToPixels(b.points[2]);b=m.pointToPixels(b.points[3]);var c=(a.x+b.x)/2;return{x:c-this.graphic.width/2,y:(b.y-a.y)/(b.x-a.x)*(c-a.x)+a.y-this.graphic.height/2}},events:{drag:function(b,a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,b.chartY-a.chart.plotTop,{visiblePlotOnly:!0})&&(a.translateHeight(this.mouseMoveToTranslation(b).y),a.redraw(!1))}}}},controlPointOptions:{events:{drag:function(b,a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,
b.chartY-a.chart.plotTop,{visiblePlotOnly:!0})&&(b=this.mouseMoveToTranslation(b),a.translateSide(b.x,b.y,this.index),a.redraw(!1))}}}});return d.types.tunnel=n});u(d,"Extensions/Annotations/Types/InfinityLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/CrookedLine.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,k,l,m){var f=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),q=m.merge;m=function(d){function b(a,c){return d.call(this,a,c)||this}f(b,d);b.edgePoint=function(a,c){return function(d){d=d.annotation;var g=d.points,h=d.options.typeOptions.type;if("horizontalLine"===h||"verticalLine"===h)g=[g[0],new l(d.chart,g[0].target,
{x:g[0].x+ +("horizontalLine"===h),y:g[0].y+ +("verticalLine"===h),xAxis:g[0].options.xAxis,yAxis:g[0].options.yAxis})];return b.findEdgePoint(g[a],g[c])}};b.findEdgeCoordinate=function(a,c,b,g){var d="x"===b?"y":"x";return(c[b]-a[b])*(g-a[d])/(c[d]-a[d])+a[b]};b.findEdgePoint=function(a,c){var d=a.series.chart,g=a.series.xAxis,e=c.series.yAxis,f=l.pointToPixels(a);c=l.pointToPixels(c);var k=c.x-f.x,B=c.y-f.y,v=g.left,m=v+g.width;g=e.top;e=g+e.height;m=0>k?v:m;var q=0>B?g:e;v={x:0===k?f.x:m,y:0===
B?f.y:q};0!==k&&0!==B&&(k=b.findEdgeCoordinate(f,c,"y",m),f=b.findEdgeCoordinate(f,c,"x",q),k>=g&&k<=e?(v.x=m,v.y=k):(v.x=f,v.y=q));v.x-=d.plotLeft;v.y-=d.plotTop;a.series.chart.inverted&&(a=v.x,v.x=v.y,v.y=a);return v};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=[this.points[0],b.endEdgePoint];a.type.match(/line/gi)&&(c[0]=b.startEdgePoint);c=this.initShape(q(a.line,{type:"path",points:c}),!1);a.line=c.options};b.endEdgePoint=b.edgePoint(0,1);b.startEdgePoint=b.edgePoint(1,
0);return b}(k);m.prototype.defaultOptions=q(k.prototype.defaultOptions,{});d.types.infinityLine=m;"";return m});u(d,"Extensions/Annotations/Types/Fibonacci.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Extensions/Annotations/Types/Tunnel.js"],d["Core/Utilities.js"],d["Core/Color/Palette.js"]],function(d,k,l,m,n){var f=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=
c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),e=m.merge,b=function(a,c){return function(){var b=this.annotation;if(!b.startRetracements||!b.endRetracements)return[];var d=this.anchor(b.startRetracements[a]).absolutePosition,e=this.anchor(b.endRetracements[a]).absolutePosition;d=[["M",Math.round(d.x),Math.round(d.y)],["L",Math.round(e.x),
Math.round(e.y)]];c&&(e=this.anchor(b.endRetracements[a-1]).absolutePosition,b=this.anchor(b.startRetracements[a-1]).absolutePosition,d.push(["L",Math.round(e.x),Math.round(e.y)],["L",Math.round(b.x),Math.round(b.y)]));return d}};m=function(a){function c(c,b){return a.call(this,c,b)||this}f(c,a);c.prototype.linkPoints=function(){a.prototype.linkPoints.call(this);this.linkRetracementsPoints()};c.prototype.linkRetracementsPoints=function(){var a=this.points,b=a[0].y-a[3].y,d=a[1].y-a[2].y,e=a[0].x,
f=a[1].x;c.levels.forEach(function(c,g){var h=a[0].y-b*c;c=a[1].y-d*c;this.startRetracements=this.startRetracements||[];this.endRetracements=this.endRetracements||[];this.linkRetracementPoint(g,e,h,this.startRetracements);this.linkRetracementPoint(g,f,c,this.endRetracements)},this)};c.prototype.linkRetracementPoint=function(a,c,b,d){var g=d[a],e=this.options.typeOptions;g?(g.options.x=c,g.options.y=b,g.refresh()):d[a]=new k(this.chart,this,{x:c,y:b,xAxis:e.xAxis,yAxis:e.yAxis})};c.prototype.addShapes=
function(){c.levels.forEach(function(a,c){var d=this.options.typeOptions;a=d.backgroundColors;var g=d.lineColor;d=d.lineColors;this.initShape({type:"path",d:b(c),stroke:d[c]||g},!1);0<c&&this.initShape({type:"path",fill:a[c-1],strokeWidth:0,d:b(c,!0)})},this)};c.prototype.addLabels=function(){c.levels.forEach(function(a,c){var b=this.options.typeOptions;a=this.initLabel(e(b.labels[c],{point:function(a){return k.pointToOptions(a.annotation.startRetracements[c])},text:a.toString()}));b.labels[c]=a.options},
this)};c.levels=[0,.236,.382,.5,.618,.786,1];return c}(l);m.prototype.defaultOptions=e(l.prototype.defaultOptions,{typeOptions:{height:2,backgroundColors:"rgba(130, 170, 255, 0.4);rgba(139, 191, 216, 0.4);rgba(150, 216, 192, 0.4);rgba(156, 229, 161, 0.4);rgba(162, 241, 130, 0.4);rgba(169, 255, 101, 0.4)".split(";"),lineColor:n.neutralColor40,lineColors:[],labels:[]},labelOptions:{allowOverlap:!0,align:"right",backgroundColor:"none",borderWidth:0,crop:!1,overflow:"none",shape:"rect",style:{color:"grey"},
verticalAlign:"middle",y:0}});return d.types.fibonacci=m});u(d,"Extensions/Annotations/Types/Pitchfork.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/InfinityLine.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,k,l,m){var f=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,
a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),q=m.merge;m=function(d){function b(a,c){return d.call(this,a,c)||this}f(b,d);b.outerLineEdgePoint=function(a){return function(c){var d=c.annotation,g=d.points;return b.findEdgePoint(g[a],g[0],new l(d.chart,c,d.midPointOptions()))}};b.findEdgePoint=function(a,c,b){c=Math.atan2(b.plotY-c.plotY,b.plotX-c.plotX);return{x:a.plotX+1E7*Math.cos(c),y:a.plotY+1E7*Math.sin(c)}};
b.middleLineEdgePoint=function(a){var c=a.annotation;return k.findEdgePoint(c.points[0],new l(c.chart,a,c.midPointOptions()))};b.prototype.midPointOptions=function(){var a=this.points;return{x:(a[1].x+a[2].x)/2,y:(a[1].y+a[2].y)/2,xAxis:a[0].series.xAxis,yAxis:a[0].series.yAxis}};b.prototype.addShapes=function(){this.addLines();this.addBackgrounds()};b.prototype.addLines=function(){this.initShape({type:"path",points:[this.points[0],b.middleLineEdgePoint]},!1);this.initShape({type:"path",points:[this.points[1],
b.topLineEdgePoint]},!1);this.initShape({type:"path",points:[this.points[2],b.bottomLineEdgePoint]},!1)};b.prototype.addBackgrounds=function(){var a=this.shapes,c=this.options.typeOptions,b=this.initShape(q(c.innerBackground,{type:"path",points:[function(a){var c=a.annotation;a=c.points;c=c.midPointOptions();return{x:(a[1].x+c.x)/2,y:(a[1].y+c.y)/2,xAxis:c.xAxis,yAxis:c.yAxis}},a[1].points[1],a[2].points[1],function(a){var c=a.annotation;a=c.points;c=c.midPointOptions();return{x:(c.x+a[2].x)/2,y:(c.y+
a[2].y)/2,xAxis:c.xAxis,yAxis:c.yAxis}}]}));a=this.initShape(q(c.outerBackground,{type:"path",points:[this.points[1],a[1].points[1],a[2].points[1],this.points[2]]}));c.innerBackground=b.options;c.outerBackground=a.options};b.topLineEdgePoint=b.outerLineEdgePoint(1);b.bottomLineEdgePoint=b.outerLineEdgePoint(0);return b}(k);m.prototype.defaultOptions=q(k.prototype.defaultOptions,{typeOptions:{innerBackground:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},outerBackground:{fill:"rgba(156, 229, 161, 0.4)",
strokeWidth:0}}});return d.types.pitchfork=m});u(d,"Extensions/Annotations/Types/VerticalLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,k,l){var f=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,
a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),n=l.merge,q=l.pick;l=function(d){function b(a,c){return d.call(this,a,c)||this}f(b,d);b.connectorFirstPoint=function(a){var c=a.annotation;a=c.chart;var b=a.inverted,d=c.points[0],e=q(d.series.yAxis&&d.series.yAxis.left,0),f=q(d.series.yAxis&&d.series.yAxis.top,0);c=c.options.typeOptions.label.offset;var l=k.pointToPixels(d,!0)[b?"x":"y"];return{x:d.x,xAxis:d.series.xAxis,y:l+c+(b?e-a.plotLeft:f-a.plotTop)}};b.connectorSecondPoint=
function(a){var c=a.annotation;a=c.chart;var b=a.inverted,d=c.options.typeOptions;c=c.points[0];var e=q(c.series.yAxis&&c.series.yAxis.left,0),f=q(c.series.yAxis&&c.series.yAxis.top,0),l=d.yOffset,m=k.pointToPixels(c,!0)[b?"x":"y"];0>d.label.offset&&(l*=-1);return{x:c.x,xAxis:c.series.xAxis,y:m+l+(b?e-a.plotLeft:f-a.plotTop)}};b.prototype.getPointsOptions=function(){return[this.options.typeOptions.point]};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=this.initShape(n(a.connector,
{type:"path",points:[b.connectorFirstPoint,b.connectorSecondPoint]}),!1);a.connector=c.options};b.prototype.addLabels=function(){var a=this.options.typeOptions,c=a.label,b=0,d=c.offset,e=0>c.offset?"bottom":"top",f="center";this.chart.inverted&&(b=c.offset,d=0,e="middle",f=0>c.offset?"right":"left");c=this.initLabel(n(c,{verticalAlign:e,align:f,x:b,y:d}));a.label=c.options};return b}(d);l.prototype.defaultOptions=n(d.prototype.defaultOptions,{typeOptions:{yOffset:10,label:{offset:-40,point:function(d){return d.annotation.points[0]},
allowOverlap:!0,backgroundColor:"none",borderWidth:0,crop:!0,overflow:"none",shape:"rect",text:"{y:.2f}"},connector:{strokeWidth:1,markerEnd:"arrow"}}});return d.types.verticalLine=l});u(d,"Extensions/Annotations/Types/Measure.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Core/Utilities.js"]],function(d,k,l){var f=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=
c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),n=l.extend,q=l.isNumber,e=l.merge,b=l.pick,a=function(a){function c(c,b){return a.call(this,c,b)||this}f(c,a);c.prototype.init=function(a,b,e){d.prototype.init.call(this,a,b,e);this.resizeY=this.resizeX=this.offsetY=this.offsetX=0;c.calculations.init.call(this);this.addValues();this.addShapes()};
c.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=this.chart.yAxis[this.options.typeOptions.yAxis]};c.prototype.pointsOptions=function(){return this.options.points};c.prototype.shapePointsOptions=function(){var a=this.options.typeOptions,c=a.xAxis;a=a.yAxis;return[{x:this.xAxisMin,y:this.yAxisMin,xAxis:c,yAxis:a},{x:this.xAxisMax,y:this.yAxisMin,xAxis:c,yAxis:a},{x:this.xAxisMax,y:this.yAxisMax,xAxis:c,yAxis:a},{x:this.xAxisMin,y:this.yAxisMax,
xAxis:c,yAxis:a}]};c.prototype.addControlPoints=function(){var a=this.options.typeOptions.selectType;var c=new k(this.chart,this,this.options.controlPointOptions,0);this.controlPoints.push(c);"xy"!==a&&(c=new k(this.chart,this,this.options.controlPointOptions,1),this.controlPoints.push(c))};c.prototype.addValues=function(a){var d=this.options.typeOptions,g=d.label.formatter;c.calculations.recalculate.call(this,a);d.label.enabled&&(0<this.labels.length?this.labels[0].text=g&&g.call(this)||c.calculations.defaultFormatter.call(this):
this.initLabel(n({shape:"rect",backgroundColor:"none",color:"black",borderWidth:0,dashStyle:"Dash",overflow:"allow",align:"left",y:0,x:0,verticalAlign:"top",crop:!0,xAxis:0,yAxis:0,point:function(a){var c=a.annotation;a=a.options;return{x:c.xAxisMin,y:c.yAxisMin,xAxis:b(d.xAxis,a.xAxis),yAxis:b(d.yAxis,a.yAxis)}},text:g&&g.call(this)||c.calculations.defaultFormatter.call(this)},d.label),void 0))};c.prototype.addShapes=function(){this.addCrosshairs();this.addBackground()};c.prototype.addBackground=
function(){"undefined"!==typeof this.shapePointsOptions()[0].x&&this.initShape(n({type:"path",points:this.shapePointsOptions()},this.options.typeOptions.background),!1)};c.prototype.addCrosshairs=function(){var a=this.chart,c=this.options.typeOptions,b=this.options.typeOptions.point,d=a.xAxis[c.xAxis],f=a.yAxis[c.yAxis],h=a.inverted;a=d.toPixels(this.xAxisMin);d=d.toPixels(this.xAxisMax);var k=f.toPixels(this.yAxisMin),l=f.toPixels(this.yAxisMax),p={point:b,type:"path"};b=[];f=[];h&&(h=a,a=k,k=h,
h=d,d=l,l=h);c.crosshairX.enabled&&(b=[["M",a,k+(l-k)/2],["L",d,k+(l-k)/2]]);c.crosshairY.enabled&&(f=[["M",a+(d-a)/2,k],["L",a+(d-a)/2,l]]);0<this.shapes.length?(this.shapes[0].options.d=b,this.shapes[1].options.d=f):(a=e(p,c.crosshairX),c=e(p,c.crosshairY),this.initShape(n({d:b},a),!1),this.initShape(n({d:f},c),!1))};c.prototype.onDrag=function(a){var c=this.mouseMoveToTranslation(a),b=this.options.typeOptions.selectType;a="y"===b?0:c.x;c="x"===b?0:c.y;this.translate(a,c);this.offsetX+=a;this.offsetY+=
c;this.redraw(!1,!1,!0)};c.prototype.resize=function(a,b,d,e){var g=this.shapes[2];"x"===e?0===d?(g.translatePoint(a,0,0),g.translatePoint(a,b,3)):(g.translatePoint(a,0,1),g.translatePoint(a,b,2)):"y"===e?0===d?(g.translatePoint(0,b,0),g.translatePoint(0,b,1)):(g.translatePoint(0,b,2),g.translatePoint(0,b,3)):(g.translatePoint(a,0,1),g.translatePoint(a,b,2),g.translatePoint(0,b,3));c.calculations.updateStartPoints.call(this,!1,!0,d,a,b);this.options.typeOptions.background.height=Math.abs(this.startYMax-
this.startYMin);this.options.typeOptions.background.width=Math.abs(this.startXMax-this.startXMin)};c.prototype.redraw=function(a,b,d){this.linkPoints();this.graphic||this.render();d&&c.calculations.updateStartPoints.call(this,!0,!1);this.clipRect&&this.clipRect.animate(this.getClipBox());this.addValues(b);this.addCrosshairs();this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);this.controlPoints.forEach(function(a){a.redraw()})};c.prototype.translate=function(a,c){this.shapes.forEach(function(b){b.translate(a,
c)});this.options.typeOptions.point.x=this.startXMin;this.options.typeOptions.point.y=this.startYMin};c.calculations={init:function(){var a=this.options.typeOptions,b=this.chart,d=c.calculations.getPointPos,e=b.inverted,f=b.xAxis[a.xAxis];b=b.yAxis[a.yAxis];var h=a.background,k=e?h.height:h.width;h=e?h.width:h.height;var l=a.selectType,p=e?f.left:b.top;e=e?b.top:f.left;this.startXMin=a.point.x;this.startYMin=a.point.y;q(k)?this.startXMax=this.startXMin+k:this.startXMax=d(f,this.startXMin,parseFloat(k));
q(h)?this.startYMax=this.startYMin-h:this.startYMax=d(b,this.startYMin,parseFloat(h));"x"===l?(this.startYMin=b.toValue(p),this.startYMax=b.toValue(p+b.len)):"y"===l&&(this.startXMin=f.toValue(e),this.startXMax=f.toValue(e+f.len))},recalculate:function(a){var b=c.calculations,d=this.options.typeOptions,e=this.chart.xAxis[d.xAxis];d=this.chart.yAxis[d.yAxis];var f=c.calculations.getPointPos,g=this.offsetX,h=this.offsetY;this.xAxisMin=f(e,this.startXMin,g);this.xAxisMax=f(e,this.startXMax,g);this.yAxisMin=
f(d,this.startYMin,h);this.yAxisMax=f(d,this.startYMax,h);this.min=b.min.call(this);this.max=b.max.call(this);this.average=b.average.call(this);this.bins=b.bins.call(this);a&&this.resize(0,0)},getPointPos:function(a,c,b){return a.toValue(a.toPixels(c)+b)},updateStartPoints:function(a,b,d,e,f){var g=this.options.typeOptions,h=g.selectType,k=this.chart.xAxis[g.xAxis];g=this.chart.yAxis[g.yAxis];var p=c.calculations.getPointPos,x=this.startXMin,l=this.startXMax,E=this.startYMin,t=this.startYMax,y=this.offsetX,
G=this.offsetY;b&&("x"===h?0===d?this.startXMin=p(k,x,e):this.startXMax=p(k,l,e):"y"===h?0===d?this.startYMin=p(g,E,f):this.startYMax=p(g,t,f):(this.startXMax=p(k,l,e),this.startYMax=p(g,t,f)));a&&(this.startXMin=p(k,x,y),this.startXMax=p(k,l,y),this.startYMin=p(g,E,G),this.startYMax=p(g,t,G),this.offsetY=this.offsetX=0)},defaultFormatter:function(){return"Min: "+this.min+"<br>Max: "+this.max+"<br>Average: "+this.average+"<br>Bins: "+this.bins},getExtremes:function(a,c,b,d){return{xAxisMin:Math.min(c,
a),xAxisMax:Math.max(c,a),yAxisMin:Math.min(d,b),yAxisMax:Math.max(d,b)}},min:function(){var a=Infinity,b=this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.y<a&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a=c.y,e=!0)})});e||(a="");return a},max:function(){var a=-Infinity,b=this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,
this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.y>a&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a=c.y,e=!0)})});e||(a="");return a},average:function(){var a="";""!==this.max&&""!==this.min&&(a=(this.max+this.min)/2);return a},bins:function(){var a=0,b=this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),
e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a++,e=!0)})});e||(a="");return a}};return c}(d);a.prototype.defaultOptions=e(d.prototype.defaultOptions,{typeOptions:{selectType:"xy",xAxis:0,yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0,stroke:void 0},crosshairX:{enabled:!0,zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},crosshairY:{enabled:!0,
zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},label:{enabled:!0,style:{fontSize:"11px",color:"#666666"},formatter:void 0}},controlPointOptions:{positioner:function(c){var b=this.index,d=c.chart,e=c.options,f=e.typeOptions,k=f.selectType;e=e.controlPointOptions;var l=d.inverted,m=d.xAxis[f.xAxis];d=d.yAxis[f.yAxis];f=c.xAxisMax;var q=c.yAxisMax,n=a.calculations.getExtremes(c.xAxisMin,c.xAxisMax,c.yAxisMin,c.yAxisMax);"x"===k&&(q=(n.yAxisMax-n.yAxisMin)/2,0===b&&(f=c.xAxisMin));"y"===k&&(f=n.xAxisMin+
(n.xAxisMax-n.xAxisMin)/2,0===b&&(q=c.yAxisMin));l?(c=d.toPixels(q),b=m.toPixels(f)):(c=m.toPixels(f),b=d.toPixels(q));return{x:c-e.width/2,y:b-e.height/2}},events:{drag:function(a,b){var c=this.mouseMoveToTranslation(a);a=b.options.typeOptions.selectType;var d="y"===a?0:c.x;c="x"===a?0:c.y;b.resize(d,c,this.index,a);b.resizeX+=d;b.resizeY+=c;b.redraw(!1,!0)}}}});return d.types.measure=a});u(d,"Mixins/Navigation.js",[],function(){return{initUpdate:function(d){d.navigation||(d.navigation={updates:[],
update:function(d,f){this.updates.forEach(function(k){k.update.call(k.context,d,f)})}})},addUpdate:function(d,k){k.navigation||this.initUpdate(k);k.navigation.updates.push({update:d,context:k})}}});u(d,"Extensions/Annotations/NavigationBindings.js",[d["Extensions/Annotations/Annotations.js"],d["Core/Chart/Chart.js"],d["Mixins/Navigation.js"],d["Core/FormatUtilities.js"],d["Core/Globals.js"],d["Core/DefaultOptions.js"],d["Core/Utilities.js"]],function(d,k,l,m,n,q,e){function b(a){var c=a.prototype.defaultOptions.events&&
a.prototype.defaultOptions.events.click;v(!0,a.prototype.defaultOptions.events,{click:function(a){var b=this,d=b.chart.navigationBindings,e=d.activeAnnotation;c&&c.call(b,a);e!==b?(d.deselectAnnotation(),d.activeAnnotation=b,b.setControlPointsVisibility(!0),g(d,"showPopup",{annotation:b,formType:"annotation-toolbar",options:d.annotationToFields(b),onSubmit:function(a){var c={};"remove"===a.actionType?(d.activeAnnotation=!1,d.chart.removeAnnotation(b)):(d.fieldsToOptions(a.fields,c),d.deselectAnnotation(),
a=c.typeOptions,"measure"===b.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),b.update(c))}})):g(d,"closePopup");a.activeAnnotation=!0}})}var a=m.format;m=q.setOptions;var c=e.addEvent,f=e.attr,g=e.fireEvent,r=e.isArray,w=e.isFunction,u=e.isNumber,B=e.isObject,v=e.merge,z=e.objectEach,C=e.pick,p=n.doc,x=n.win,D=function(){function b(a,c){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=c;this.eventsToUnbind=
[];this.container=p.getElementsByClassName(this.options.bindingsClassName||"")}b.prototype.initEvents=function(){var a=this,b=a.chart,d=a.container,e=a.options;a.boundClassNames={};z(e.bindings||{},function(c){a.boundClassNames[c.className]=c});[].forEach.call(d,function(b){a.eventsToUnbind.push(c(b,"click",function(c){var d=a.getButtonEvents(b,c);d&&-1===d.button.className.indexOf("highcharts-disabled-btn")&&a.bindingsButtonClick(d.button,d.events,c)}))});z(e.events||{},function(b,d){w(b)&&a.eventsToUnbind.push(c(a,
d,b,{passive:!1}))});a.eventsToUnbind.push(c(b.container,"click",function(c){!b.cancelClick&&b.isInsidePlot(c.chartX-b.plotLeft,c.chartY-b.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,c)}));a.eventsToUnbind.push(c(b.container,n.isTouchDevice?"touchmove":"mousemove",function(c){a.bindingsContainerMouseMove(this,c)},n.isTouchDevice?{passive:!1}:void 0))};b.prototype.initUpdate=function(){var a=this;l.addUpdate(function(c){a.update(c)},this.chart)};b.prototype.bindingsButtonClick=function(a,
c,b){var d=this.chart;this.selectedButtonElement&&(g(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&d.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=c;this.selectedButtonElement=a;g(this,"selectButton",{button:a});c.init&&c.init.call(this,a,b);(c.start||c.steps)&&d.renderer.boxWrapper.addClass("highcharts-draw-mode")};b.prototype.bindingsChartClick=
function(a,c){a=this.chart;var b=this.selectedButton;a=a.renderer.boxWrapper;var d;if(d=this.activeAnnotation&&!c.activeAnnotation&&c.target.parentNode){a:{d=c.target;var e=x.Element.prototype,f=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,h=null;if(e.closest)h=e.closest.call(d,".highcharts-popup");else{do{if(f.call(d,".highcharts-popup"))break a;d=d.parentElement||d.parentNode}while(null!==d&&1===d.nodeType)}d=h}d=!d}d&&g(this,"closePopup");b&&b.start&&(this.nextEvent?(this.nextEvent(c,
this.currentUserDetails),this.steps&&(this.stepIndex++,b.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=b.steps[this.stepIndex]:(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),b.end&&b.end.call(this,c,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=b.start.call(this,c))&&b.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=b.steps[this.stepIndex]):
(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,b.end&&b.end.call(this,c,this.currentUserDetails)))};b.prototype.bindingsContainerMouseMove=function(a,c){this.mouseMoveEvent&&this.mouseMoveEvent(c,this.currentUserDetails)};b.prototype.fieldsToOptions=function(a,c){z(a,function(a,b){var d=parseFloat(a),e=b.split("."),f=c,g=e.length-1;!u(d)||a.match(/px/g)||b.match(/format/g)||(a=d);""!==a&&"undefined"!==a&&e.forEach(function(c,
b){var d=C(e[b+1],"");g===b?f[c]=a:(f[c]||(f[c]=d.match(/\d/g)?[]:{}),f=f[c])})});return c};b.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};b.prototype.annotationToFields=function(c){function d(b,e,f,p){if(f&&b&&-1===t.indexOf(e)&&(0<=(f.indexOf&&f.indexOf(e))||f[e]||!0===f))if(r(b))p[e]=[],b.forEach(function(a,c){B(a)?(p[e][c]={},z(a,function(a,b){d(a,b,g[e],p[e][c])})):d(a,0,g[e],p[e])});else if(B(b)){var k=
{};r(p)?(p.push(k),k[e]={},k=k[e]):p[e]=k;z(b,function(a,c){d(a,c,0===e?f:g[e],k)})}else"format"===e?p[e]=[a(b,c.labels[0].points[0]).toString(),"text"]:r(p)?p.push([b,h(b)]):p[e]=[b,h(b)]}var e=c.options,f=b.annotationsEditable,g=f.nestedOptions,h=this.utils.getFieldType,p=C(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,e.labels&&e.labels[0]&&e.labels[0].itemType,"label"),t=b.annotationsNonEditable[e.langKey]||[],k={langKey:e.langKey,type:p};z(e,function(a,c){"typeOptions"===c?(k[c]={},z(e[c],function(a,
b){d(a,b,g,k[c],!0)})):d(a,c,f[p],k)});return k};b.prototype.getClickedClassNames=function(a,c){var b=c.target;c=[];for(var d;b&&((d=f(b,"class"))&&(c=c.concat(d.split(" ").map(function(a){return[a,b]}))),b=b.parentNode,b!==a););return c};b.prototype.getButtonEvents=function(a,c){var b=this,d;this.getClickedClassNames(a,c).forEach(function(a){b.boundClassNames[a[0]]&&!d&&(d={events:b.boundClassNames[a[0]],button:a[1]})});return d};b.prototype.update=function(a){this.options=v(!0,this.options,a);this.removeEvents();
this.initEvents()};b.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){a()})};b.prototype.destroy=function(){this.removeEvents()};b.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill",
"strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};b.annotationsNonEditable={rectangle:["crosshairX",
"crosshairY","label"]};return b}();D.prototype.utils={getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]},updateRectSize:function(a,c){var b=c.chart,d=c.options.typeOptions,e=b.pointer.getCoordinates(a);a=b.navigationBindings.utils.getAssignedAxis(e.xAxis);e=b.navigationBindings.utils.getAssignedAxis(e.yAxis);a&&e&&(a=a.value-d.point.x,d=d.point.y-e.value,c.update({typeOptions:{background:{width:b.inverted?d:a,height:b.inverted?a:d}}}))},getAssignedAxis:function(a){return a.filter(function(a){var c=
a.axis.min,b=a.axis.max,d=C(a.axis.minPointOffset,0);return u(c)&&u(b)&&a.value>=c-d&&a.value<=b+d&&!a.axis.options.isInternal})[0]}};k.prototype.initNavigationBindings=function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new D(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};c(k,"load",function(){this.initNavigationBindings()});c(k,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});
c(D,"deselectButton",function(){this.selectedButtonElement=null});c(d,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});n.Annotation&&(b(d),z(d.types,function(a){b(a)}));m({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",
labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);
c=this.utils.getAssignedAxis(c.yAxis);var b=this.chart.options.navigation;if(a&&c)return this.chart.addAnnotation(v({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:c.value,xAxis:a.axis.options.index,yAxis:c.axis.options.index},r:5}]},b.annotationsOptions,b.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,c){var b=c.options.shapes[0].point,d=this.chart.inverted;if(u(b.xAxis)&&u(b.yAxis)){var e=this.chart.xAxis[b.xAxis].toPixels(b.x);b=this.chart.yAxis[b.yAxis].toPixels(b.y);
e=Math.max(Math.sqrt(Math.pow(d?b-a.chartX:e-a.chartX,2)+Math.pow(d?e-a.chartY:b-a.chartY,2)),5)}c.update({shapes:[{r:e}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var c=this.utils.getAssignedAxis(a.xAxis),b=this.utils.getAssignedAxis(a.yAxis);if(c&&b){a=c.value;var d=b.value;c=c.axis.options.index;b=b.axis.options.index;var e=this.chart.options.navigation;return this.chart.addAnnotation(v({langKey:"rectangle",type:"basicAnnotation",
shapes:[{type:"path",points:[{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d}]}]},e.annotationsOptions,e.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(a,c){var b=c.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(d.xAxis);d=this.utils.getAssignedAxis(d.yAxis);a&&d&&(a=a.value,d=d.value,b[1].x=a,b[2].x=a,b[2].y=d,b[3].y=d,c.update({shapes:[{points:b}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",
start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);c=this.utils.getAssignedAxis(c.yAxis);var b=this.chart.options.navigation;if(a&&c)return this.chart.addAnnotation(v({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,x:a.value,y:c.value},overflow:"none",crop:!0}]},b.annotationsOptions,b.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});
c(k,"render",function(){var a=this,c=a.navigationBindings;if(a&&c){var b=!1;a.series.forEach(function(a){!a.options.isInternal&&a.visible&&(b=!0)});z(c.boundClassNames,function(c,d){a.navigationBindings&&a.navigationBindings.container&&a.navigationBindings.container[0]&&(d=a.navigationBindings.container[0].querySelectorAll("."+d))&&("normal"===c.noDataState?d.forEach(function(a){-1!==a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):b?d.forEach(function(a){-1!==
a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):d.forEach(function(a){-1===a.className.indexOf("highcharts-disabled-btn")&&(a.className+=" highcharts-disabled-btn")}))})}});c(D,"closePopup",function(){this.deselectAnnotation()});return D});u(d,"Extensions/Annotations/Popup.js",[d["Core/Globals.js"],d["Extensions/Annotations/NavigationBindings.js"],d["Core/DefaultOptions.js"],d["Core/Pointer.js"],d["Core/Utilities.js"]],function(d,k,l,m,n){var f=d.doc,
e=d.isFirefox,b=l.getOptions,a=n.addEvent,c=n.createElement,h=n.defined,g=n.fireEvent,r=n.isArray,u=n.isObject,A=n.isString,B=n.objectEach,v=n.pick,z=n.stableSort;l=n.wrap;var C=/\d/g;l(m.prototype,"onContainerMouseDown",function(a,c){var b=c.target&&c.target.className;A(b)&&0<=b.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,1))});d.Popup=function(a,c,b){this.init(a,c,b)};d.Popup.prototype={init:function(a,b,d){this.chart=d;this.container=c("div",{className:"highcharts-popup highcharts-no-tooltip"},
null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var b=this,d=this.iconsURL;var e=c("div",{className:"highcharts-popup-close"},null,this.container);e.style["background-image"]="url("+(d.match(/png|svg|jpeg|jpg|gif/ig)?d:d+"close.svg")+")";["click","touchstart"].forEach(function(c){a(e,c,function(){b.chart?g(b.chart.navigationBindings,"closePopup"):b.closePopup()})})},addColsContainer:function(a){var b=c("div",{className:"highcharts-popup-lhs-col"},null,
a);a=c("div",{className:"highcharts-popup-rhs-col"},null,a);c("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,b,d,e){var g=a.split(".");g=g[g.length-1];var h=this.lang;b="highcharts-"+b+"-"+g;b.match(C)||c("label",{htmlFor:b},void 0,d).appendChild(f.createTextNode(h[g]||g));c("input",{name:b,value:e[0],type:e[1],className:"highcharts-popup-field"},void 0,d).setAttribute("highcharts-data-name",a)},addButton:function(b,d,e,g,h){var k=this,
p=this.closePopup,l=this.getFields;var x=c("button",void 0,void 0,b);x.appendChild(f.createTextNode(d));["click","touchstart"].forEach(function(c){a(x,c,function(){p.call(k);return g(l(h,e))})});return x},getFields:function(a,c){var b=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,f;var g={actionType:c,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(b,function(a){f=
a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?g.seriesId=a.value:f?g.fields[f]=a.value:g.type=a.value});a&&(g.fields["params.volumeSeriesID"]=a.getAttribute("value"));return g},showPopup:function(){var a=this.container,c=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),a.removeAttribute("style"));a.appendChild(c);a.style.display="block";
a.style.height=""},closePopup:function(){v(this.popup&&this.popup.container,this.container).style.display="none"},showForm:function(a,c,b,d){c&&(this.popup=c.navigationBindings.popup,this.showPopup(),"indicators"===a&&this.indicators.addForm.call(this,c,b,d),"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,c,b,d),"annotation-edit"===a&&this.annotations.addForm.call(this,c,b,d),"flag"===a&&this.annotations.addForm.call(this,c,b,d,!0),this.container.style.height=this.container.offsetHeight+
"px")},getLangpack:function(){return b().lang.navigation.popup},annotations:{addToolbar:function(a,b,d){var e=this,g=this.lang,h=this.popup.container,k=this.showForm;-1===h.className.indexOf("highcharts-annotation-toolbar")&&(h.className+=" highcharts-annotation-toolbar");a&&(h.style.top=a.plotTop+10+"px");c("span",void 0,void 0,h).appendChild(f.createTextNode(v(g[b.langKey]||b.langKey,b.shapes&&b.shapes[0].type)));var l=this.addButton(h,g.removeButton||"remove","remove",d,h);l.className+=" highcharts-annotation-remove-button";
l.style["background-image"]="url("+this.iconsURL+"destroy.svg)";l=this.addButton(h,g.editButton||"edit","edit",function(){k.call(e,"annotation-edit",a,b,d)},h);l.className+=" highcharts-annotation-edit-button";l.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,d,e){var g=this.popup.container,h=this.lang;if(a){var k=c("h2",{className:"highcharts-popup-main-title"},void 0,g);k.appendChild(f.createTextNode(h[b.langKey]||b.langKey||""));k=c("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},
null,g);var l=c("div",{className:"highcharts-popup-bottom-row"},null,g);this.annotations.addFormFields.call(this,k,a,"",b,[],!0);this.addButton(l,e?h.addButton||"add":h.saveButton||"save",e?"add":"save",d,g)}},addFormFields:function(a,b,d,g,h,k){var l=this,p=this.annotations.addFormFields,x=this.addInput,m=this.lang,n,t;b&&(B(g,function(c,e){n=""!==d?d+"."+e:e;u(c)&&(!r(c)||r(c)&&u(c[0])?(t=m[e]||e,t.match(C)||h.push([!0,t,a]),p.call(l,a,b,n,c,h,!1)):h.push([l,n,"annotation",a,c]))}),k&&(z(h,function(a){return a[1].match(/format/g)?
-1:1}),e&&h.reverse(),h.forEach(function(a){!0===a[0]?c("span",{className:"highcharts-annotation-title"},void 0,a[2]).appendChild(f.createTextNode(a[1])):x.apply(a[0],a.splice(1))})))}},indicators:{addForm:function(a,c,b){var d=this.indicators,e=this.lang;if(a){this.tabs.init.call(this,a);c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(c[0]);d.addIndicatorList.call(this,a,c[0],"add");var f=c[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,
e.addButton||"add","add",b,f);this.addColsContainer(c[1]);d.addIndicatorList.call(this,a,c[1],"edit");f=c[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",b,f);this.addButton(f,e.removeButton||"remove","remove",b,f)}},addIndicatorList:function(b,d,e){var g=this,h=d.querySelectorAll(".highcharts-popup-lhs-col")[0];d=d.querySelectorAll(".highcharts-popup-rhs-col")[0];var k="edit"===e,l=k?b.series:b.options.plotOptions,p=this.indicators.addFormFields,x;
if(b){var m=c("ul",{className:"highcharts-indicator-list"},null,h);var n=d.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];B(l,function(d,e){var h=d.options;if(d.params||h&&h.params){var t=g.indicators.getNameType(d,e),q=t.type;x=c("li",{className:"highcharts-indicator-list"},void 0,m);x.appendChild(f.createTextNode(t.name));["click","touchstart"].forEach(function(e){a(x,e,function(){p.call(g,b,k?d:l[q],t.type,n);k&&d.options&&c("input",{type:"hidden",name:"highcharts-id-"+q,value:d.options.id},
null,n).setAttribute("highcharts-data-series-id",d.options.id)})})}});0<m.childNodes.length&&m.childNodes[0].click()}},getNameType:function(a,c){var b=a.options,e=d.seriesTypes;e=e[c]&&e[c].prototype.nameBase||c.toUpperCase();b&&b.type&&(c=a.options.type,e=a.name);return{name:e,type:c}},listAllSeries:function(a,b,d,e,g){a="highcharts-"+b+"-type-"+a;var k=this.lang,l;if(d){c("label",{htmlFor:a},null,e).appendChild(f.createTextNode(k[b]||b));var p=c("select",{name:a,className:"highcharts-popup-field"},
null,e);p.setAttribute("id","highcharts-select-"+b);d.series.forEach(function(a){l=a.options;!l.params&&l.id&&"highcharts-navigator-series"!==l.id&&c("option",{value:l.id},null,p).appendChild(f.createTextNode(l.name||l.id))});h(g)&&(p.value=g)}},addFormFields:function(a,b,d,e){var g=b.params||b.options.params,h=this.indicators.getNameType;e.innerHTML="";c("h3",{className:"highcharts-indicator-title"},void 0,e).appendChild(f.createTextNode(h(b,d).name));c("input",{type:"hidden",name:"highcharts-type-"+
d,value:d},null,e);this.indicators.listAllSeries.call(this,d,"series",a,e,b.linkedParent&&g.volumeSeriesID);g.volumeSeriesID&&this.indicators.listAllSeries.call(this,d,"volume",a,e,b.linkedParent&&b.linkedParent.options.id);this.indicators.addParamInputs.call(this,a,"params",g,d,e)},addParamInputs:function(a,b,c,d,e){var f=this,g=this.indicators.addParamInputs,h=this.addInput,k;a&&B(c,function(c,l){k=b+"."+l;void 0!==c&&(u(c)?g.call(f,a,k,c,d,e):"params.volumeSeriesID"!==k&&h.call(f,k,d,e,[c,"text"]))})},
getAmount:function(){var a=0;this.series.forEach(function(c){var b=c.options;(c.params||b&&b.params)&&a++});return a}},tabs:{init:function(a){var c=this.tabs,b=this.indicators.getAmount.call(a);a&&(a=c.addMenuItem.call(this,"add"),c.addMenuItem.call(this,"edit",b),c.addContentItem.call(this,"add"),c.addContentItem.call(this,"edit"),c.switchTabs.call(this,b),c.selectTab.call(this,a,0))},addMenuItem:function(a,b){var d=this.popup.container,e="highcharts-tab-item",g=this.lang;0===b&&(e+=" highcharts-tab-disabled");
b=c("span",{className:e},void 0,d);b.appendChild(f.createTextNode(g[a+"Button"]||a));b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return c("div",{className:"highcharts-tab-item-content highcharts-no-mousewheel"},null,this.popup.container)},switchTabs:function(b){var c=this,d;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(e,f){d=e.getAttribute("highcharts-data-tab-type");"edit"===d&&0===b||["click","touchstart"].forEach(function(b){a(e,
b,function(){c.tabs.deselectAll.call(c);c.tabs.selectTab.call(c,this,f)})})})},selectTab:function(a,c){var b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";b[c].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,c=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var b;for(b=0;b<c.length;b++)c[b].classList.remove("highcharts-tab-item-active"),a[b].classList.remove("highcharts-tab-item-show")}}};
a(k,"showPopup",function(a){this.popup||(this.popup=new d.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.1.2/gfx/stock-icons/",this.chart));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});a(k,"closePopup",function(){this.popup&&this.popup.closePopup()});return d.Popup});u(d,"masters/modules/annotations-advanced.src.js",[],function(){})});
//# sourceMappingURL=annotations-advanced.js.map