/*
 Highstock JS v9.1.2 (2021-06-16)

 Data grouping module

 (c) 2010-2021 Torstein Hnsi

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(x){c(x);c.Highcharts=x;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function x(c,x,t,D){c.hasOwnProperty(x)||(c[x]=D.apply(null,t))}c=c?c._modules:{};x(c,"Extensions/DataGrouping.js",[c["Core/Axis/Axis.js"],c["Core/Axis/DateTimeAxis.js"],c["Core/FormatUtilities.js"],
c["Core/Globals.js"],c["Core/Series/Point.js"],c["Core/Series/Series.js"],c["Core/Tooltip.js"],c["Core/DefaultOptions.js"],c["Core/Utilities.js"]],function(c,x,t,D,L,F,M,N,g){var K=t.format,y=F.prototype;t=g.addEvent;var O=g.arrayMax,P=g.arrayMin,Q=g.correctFloat,E=g.defined,H=g.error,R=g.extend,q=g.isNumber,G=g.merge,A=g.pick;"";var n=D.approximations={sum:function(a){var b=a.length;if(!b&&a.hasNulls)var d=null;else if(b)for(d=0;b--;)d+=a[b];return d},average:function(a){var b=a.length;a=n.sum(a);
q(a)&&b&&(a=Q(a/b));return a},averages:function(){var a=[];[].forEach.call(arguments,function(b){a.push(n.average(b))});return"undefined"===typeof a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?O(a):a.hasNulls?null:void 0},low:function(a){return a.length?P(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,b,d,h){a=n.open(a);b=n.high(b);d=n.low(d);h=n.close(h);if(q(a)||q(b)||
q(d)||q(h))return[a,b,d,h]},range:function(a,b){a=n.low(a);b=n.high(b);if(q(a)||q(b))return[a,b];if(null===a&&null===b)return null}};g=function(a,b,d,h){var f=this,c=f.data,e=f.options&&f.options.data,k=[],g=[],B=[],r=a.length,l=!!b,m=[],u=f.pointArrayMap,x=u&&u.length,v=["x"].concat(u||["y"]),t=this.options.dataGrouping&&this.options.dataGrouping.groupAll,y=0,C=0,w;h="function"===typeof h?h:n[h]?n[h]:n[f.getDGApproximation&&f.getDGApproximation()||"average"];x?u.forEach(function(){m.push([])}):m.push([]);
var D=x||1;for(w=0;w<=r&&!(a[w]>=d[0]);w++);for(w;w<=r;w++){for(;"undefined"!==typeof d[y+1]&&a[w]>=d[y+1]||w===r;){var p=d[y];f.dataGroupInfo={start:t?C:f.cropStart+C,length:m[0].length};var A=h.apply(f,m);f.pointClass&&!E(f.dataGroupInfo.options)&&(f.dataGroupInfo.options=G(f.pointClass.prototype.optionsToObject.call({series:f},f.options.data[f.cropStart+C])),v.forEach(function(a){delete f.dataGroupInfo.options[a]}));"undefined"!==typeof A&&(k.push(p),g.push(A),B.push(f.dataGroupInfo));C=w;for(p=
0;p<D;p++)m[p].length=0,m[p].hasNulls=!1;y+=1;if(w===r)break}if(w===r)break;if(u){p=f.options.dataGrouping&&f.options.dataGrouping.groupAll?w:f.cropStart+w;A=c&&c[p]||f.pointClass.prototype.applyOptions.apply({series:f},[e[p]]);var z=void 0;for(p=0;p<x;p++)z=A[u[p]],q(z)?m[p].push(z):null===z&&(m[p].hasNulls=!0)}else p=l?b[w]:null,q(p)?m[0].push(p):null===p&&(m[0].hasNulls=!0)}return{groupedXData:k,groupedYData:g,groupMap:B}};var I={approximations:n,groupData:g},S=y.processData,T=y.generatePoints,
z={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},J={line:{},spline:{},area:{},areaspline:{},
arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},U=D.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];y.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};y.groupData=g;y.processData=
function(){var a=this.chart,b=this.options.dataGrouping,d=!1!==this.allowDG&&b&&A(b.enabled,a.options.isStock),h=this.visible||!a.options.chart.ignoreHiddenSeries,f,c=this.currentDataGrouping,e=!1;this.forceCrop=d;this.groupPixelWidth=null;this.hasProcessed=!0;d&&!this.requireSorting&&(this.requireSorting=e=!0);d=!1===S.apply(this,arguments)||!d;e&&(this.requireSorting=!1);if(!d){this.destroyGroupedData();var k=b.groupAll?this.xData:this.processedXData,g=b.groupAll?this.yData:this.processedYData;
d=a.plotSizeX;e=this.xAxis;var B=e.options.ordinal,r=this.groupPixelWidth=e.getGroupPixelWidth&&e.getGroupPixelWidth();if(r&&k&&k.length){this.isDirty=f=!0;this.points=null;var l=e.getExtremes();var m=l.min;l=l.max;B=B&&e.ordinal&&e.ordinal.getGroupIntervalFactor(m,l,this)||1;d=e.getTimeTicks(x.AdditionsClass.prototype.normalizeTimeTickInterval(r*(l-m)/d*B,b.units||U),Math.min(m,k[0]),Math.max(l,k[k.length-1]),e.options.startOfWeek,k,this.closestPointRange);r=y.groupData.apply(this,[k,g,d,b.approximation]);
k=r.groupedXData;g=r.groupedYData;B=0;b&&b.smoothed&&k.length&&(b.firstAnchor="firstPoint",b.anchor="middle",b.lastAnchor="lastPoint",H(32,!1,a,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));a=k;var u=this.options.dataGrouping;m=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(u&&this.xData&&m&&this.groupMap){var n=a.length-1;var v=u.anchor;var t=A(u.firstAnchor,v);u=A(u.lastAnchor,v);if(v&&"start"!==v){var z=m*{middle:.5,end:1}[v];for(v=a.length-1;v--&&0<v;)a[v]+=z}if(t&&"start"!==
t&&this.xData[0]>=a[0]){v=this.groupMap[0].start;z=this.groupMap[0].length;var C=void 0;q(v)&&q(z)&&(C=v+(z-1));a[0]={middle:a[0]+.5*m,end:a[0]+m,firstPoint:this.xData[0],lastPoint:C&&this.xData[C]}[t]}u&&"start"!==u&&m&&a[n]>=l-m&&(l=this.groupMap[this.groupMap.length-1].start,a[n]={middle:a[n]+.5*m,end:a[n]+m,firstPoint:l&&this.xData[l],lastPoint:this.xData[this.xData.length-1]}[u])}for(l=1;l<d.length;l++)d.info.segmentStarts&&-1!==d.info.segmentStarts.indexOf(l)||(B=Math.max(d[l]-d[l-1],B));l=
d.info;l.gapSize=B;this.closestPointRange=d.info.totalRange;this.groupMap=r.groupMap;if(h){h=k;if(E(h[0])&&q(e.min)&&q(e.dataMin)&&h[0]<e.min){if(!E(e.options.min)&&e.min<=e.dataMin||e.min===e.dataMin)e.min=Math.min(h[0],e.min);e.dataMin=Math.min(h[0],e.dataMin)}if(E(h[h.length-1])&&q(e.max)&&q(e.dataMax)&&h[h.length-1]>e.max){if(!E(e.options.max)&&q(e.dataMax)&&e.max>=e.dataMax||e.max===e.dataMax)e.max=Math.max(h[h.length-1],e.max);e.dataMax=Math.max(h[h.length-1],e.dataMax)}}b.groupAll&&(b=this.cropData(k,
g,e.min,e.max,1),k=b.xData,g=b.yData,this.cropStart=b.start);this.processedXData=k;this.processedYData=g}else this.groupMap=null;this.hasGroupedData=f;this.currentDataGrouping=l;this.preventGraphAnimation=(c&&c.totalRange)!==(l&&l.totalRange)}};y.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,b){a&&(this.groupedData[b]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};y.generatePoints=function(){T.apply(this);this.destroyGroupedData();this.groupedData=
this.hasGroupedData?this.points:null};t(L,"update",function(){if(this.dataGroup)return H(24,!1,this.series.chart),!1});t(M,"headerFormatter",function(a){var b=this.chart,d=b.time,h=a.labelConfig,f=h.series,c=f.tooltipOptions,e=f.options.dataGrouping,k=c.xDateFormat,g=f.xAxis,n=c[(a.isFooter?"footer":"header")+"Format"];if(g&&"datetime"===g.options.type&&e&&q(h.key)){var r=f.currentDataGrouping;e=e.dateTimeLabelFormats||z.dateTimeLabelFormats;if(r)if(c=e[r.unitName],1===r.count)k=c[0];else{k=c[1];
var l=c[2]}else!k&&e&&(k=this.getXDateFormat(h,c,g));k=d.dateFormat(k,h.key);l&&(k+=d.dateFormat(l,h.key+r.totalRange-1));f.chart.styledMode&&(n=this.styledModeFormat(n));a.text=K(n,{point:R(h.point,{key:k}),series:f},b);a.preventDefault()}});t(F,"destroy",y.destroyGroupedData);t(F,"afterSetOptions",function(a){a=a.options;var b=this.type,d=this.chart.options.plotOptions,c=N.defaultOptions.plotOptions[b].dataGrouping,f=this.useCommonDataGrouping&&z;if(J[b]||f){c||(c=G(z,J[b]));var g=this.chart.rangeSelector;
a.dataGrouping=G(f,c,d.series&&d.series.dataGrouping,d[b].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&g&&q(g.selected)&&g.buttonOptions[g.selected].dataGrouping)}});t(c,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});c.prototype.getGroupPixelWidth=function(){var a=this.series,b=a.length,d,c=0,f=!1,g;for(d=b;d--;)(g=a[d].options.dataGrouping)&&(c=Math.max(c,A(g.groupPixelWidth,z.groupPixelWidth)));for(d=b;d--;)(g=a[d].options.dataGrouping)&&a[d].hasProcessed&&
(b=(a[d].processedXData||a[d].data).length,a[d].groupPixelWidth||b>this.chart.plotSizeX/c||b&&g.forced)&&(f=!0);return f?c:0};c.prototype.setDataGrouping=function(a,b){var d;b=A(b,!0);a||(a={forced:!1,units:null});if(this instanceof c)for(d=this.series.length;d--;)this.series[d].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(b){b.dataGrouping=a},!1);this.ordinal&&(this.ordinal.slope=void 0);b&&this.chart.redraw()};D.dataGrouping=I;"";return I});x(c,"masters/modules/datagrouping.src.js",
[c["Extensions/DataGrouping.js"]],function(c){return c})});
//# sourceMappingURL=datagrouping.js.map