"use strict";!function(i){"object"==typeof module&&module.exports?module.exports=i.default=i:"function"==typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(t){return i(t),i.Highcharts=t,i}):i("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){function i(t,i,e,o){t.hasOwnProperty(i)||(t[i]=o.apply(null,e))}i(t=t?t._modules:{},"Mixins/Nodes.js",[t["Core/Globals.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Utilities.js"]],function(t,o,s,i){var n=i.defined,r=i.extend,a=i.find,h=i.pick;return t.NodesMixin={createNode:function(t){function i(t,i){return a(t,function(t){return t.id===i})}var e,s=i(this.nodes,t),o=this.pointClass;return s||(e=this.options.nodes&&i(this.options.nodes,t),(s=(new o).init(this,r({className:"highcharts-node",isNode:!0,id:t,y:1},e))).linksTo=[],s.linksFrom=[],s.formatPrefix="node",s.name=s.name||s.options.id||"",s.mass=h(s.options.mass,s.options.marker&&s.options.marker.radius,this.options.marker&&this.options.marker.radius,4),s.getSum=function(){var i=0,e=0;return s.linksTo.forEach(function(t){i+=t.weight}),s.linksFrom.forEach(function(t){e+=t.weight}),Math.max(i,e)},s.offset=function(t,i){for(var e=0,o=0;o<s[i].length;o++){if(s[i][o]===t)return e;e+=s[i][o].weight}},s.hasShape=function(){var i=0;return s.linksTo.forEach(function(t){t.outgoing&&i++}),!s.linksTo.length||i!==s.linksTo.length},this.nodes.push(s)),s},generatePoints:function(){var i=this.chart,e={};s.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){n(t.from)&&(e[t.from]||(e[t.from]=this.createNode(t.from)),e[t.from].linksFrom.push(t),t.fromNode=e[t.from],i.styledMode?t.colorIndex=h(t.options.colorIndex,e[t.from].colorIndex):t.color=t.options.color||e[t.from].color),n(t.to)&&(e[t.to]||(e[t.to]=this.createNode(t.to)),e[t.to].linksTo.push(t),t.toNode=e[t.to]),t.name=t.name||t.id},this),this.nodeLookup=e},setData:function(){this.nodes&&(this.nodes.forEach(function(t){t.destroy()}),this.nodes.length=0),s.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),s.prototype.destroy.apply(this,arguments)},setNodeState:function(t){var i=arguments,e=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==t&&e.forEach(function(t){t&&t.series&&(o.prototype.setState.apply(t,i),t.isNode||(t.fromNode.graphic&&o.prototype.setState.apply(t.fromNode,i),t.toNode&&t.toNode.graphic&&o.prototype.setState.apply(t.toNode,i)))}),o.prototype.setState.apply(this,i)}}}),i(t,"Series/Networkgraph/Integrations.js",[t["Core/Globals.js"]],function(t){t.networkgraphIntegrations={verlet:{attractiveForceFunction:function(t,i){return(i-t)/t},repulsiveForceFunction:function(t,i){return(i-t)/t*(t<i?1:0)},barycenter:function(){var t=this.options.gravitationalConstant,i=this.barycenter.xFactor,e=this.barycenter.yFactor,i=(i-(this.box.left+this.box.width)/2)*t,e=(e-(this.box.top+this.box.height)/2)*t;this.nodes.forEach(function(t){t.fixedPosition||(t.plotX-=i/t.mass/t.degree,t.plotY-=e/t.mass/t.degree)})},repulsive:function(t,i,e){i=i*this.diffTemperature/t.mass/t.degree,t.fixedPosition||(t.plotX+=e.x*i,t.plotY+=e.y*i)},attractive:function(t,i,e){var o=t.getMass(),s=-e.x*i*this.diffTemperature;i=-e.y*i*this.diffTemperature,t.fromNode.fixedPosition||(t.fromNode.plotX-=s*o.fromNode/t.fromNode.degree,t.fromNode.plotY-=i*o.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.plotX+=s*o.toNode/t.toNode.degree,t.toNode.plotY+=i*o.toNode/t.toNode.degree)},integrate:function(t,i){var e=-t.options.friction,o=t.options.maxSpeed,s=(i.plotX+i.dispX-i.prevX)*e;e*=i.plotY+i.dispY-i.prevY;var n=(r=Math.abs)(s)/(s||1),r=r(e)/(e||1),s=n*Math.min(o,Math.abs(s)),e=r*Math.min(o,Math.abs(e));i.prevX=i.plotX+i.dispX,i.prevY=i.plotY+i.dispY,i.plotX+=s,i.plotY+=e,i.temperature=t.vectorLength({x:s,y:e})},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.5)}},euler:{attractiveForceFunction:function(t,i){return t*t/i},repulsiveForceFunction:function(t,i){return i*i/t},barycenter:function(){var e=this.options.gravitationalConstant,o=this.barycenter.xFactor,s=this.barycenter.yFactor;this.nodes.forEach(function(t){var i;t.fixedPosition||(i=t.getDegree(),t.dispX+=(o-t.plotX)*e*(i*=1+i/2)/t.degree,t.dispY+=(s-t.plotY)*e*i/t.degree)})},repulsive:function(t,i,e,o){t.dispX+=e.x/o*i/t.degree,t.dispY+=e.y/o*i/t.degree},attractive:function(t,i,e,o){var s=t.getMass(),n=e.x/o*i;i*=e.y/o,t.fromNode.fixedPosition||(t.fromNode.dispX-=n*s.fromNode/t.fromNode.degree,t.fromNode.dispY-=i*s.fromNode/t.fromNode.degree),t.toNode.fixedPosition||(t.toNode.dispX+=n*s.toNode/t.toNode.degree,t.toNode.dispY+=i*s.toNode/t.toNode.degree)},integrate:function(t,i){i.dispX+=i.dispX*t.options.friction,i.dispY+=i.dispY*t.options.friction;var e=i.temperature=t.vectorLength({x:i.dispX,y:i.dispY});0!==e&&(i.plotX+=i.dispX/e*Math.min(Math.abs(i.dispX),t.temperature),i.plotY+=i.dispY/e*Math.min(Math.abs(i.dispY),t.temperature))},getK:function(t){return Math.pow(t.box.width*t.box.height/t.nodes.length,.3)}}}}),i(t,"Series/Networkgraph/QuadTree.js",[t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,i){i=i.extend;var s=t.QuadTreeNode=function(t){this.box=t,this.boxSize=Math.min(t.width,t.height),this.nodes=[],this.body=this.isInternal=!1,this.isEmpty=!0};i(s.prototype,{insert:function(t,i){this.isInternal?this.nodes[this.getBoxPosition(t)].insert(t,i-1):(this.isEmpty=!1,this.body?i?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,i-1),this.body=!0),this.nodes[this.getBoxPosition(t)].insert(t,i-1)):((i=new s({top:t.plotX,left:t.plotY,width:.1,height:.1})).body=t,i.isInternal=!1,this.nodes.push(i)):(this.isInternal=!1,this.body=t))},updateMassAndCenter:function(){var i=0,e=0,o=0;this.isInternal?(this.nodes.forEach(function(t){t.isEmpty||(i+=t.mass,e+=t.plotX*t.mass,o+=t.plotY*t.mass)}),e/=i,o/=i):this.body&&(i=this.body.mass,e=this.body.plotX,o=this.body.plotY),this.mass=i,this.plotX=e,this.plotY=o},divideBox:function(){var t=this.box.width/2,i=this.box.height/2;this.nodes[0]=new s({left:this.box.left,top:this.box.top,width:t,height:i}),this.nodes[1]=new s({left:this.box.left+t,top:this.box.top,width:t,height:i}),this.nodes[2]=new s({left:this.box.left+t,top:this.box.top+i,width:t,height:i}),this.nodes[3]=new s({left:this.box.left,top:this.box.top+i,width:t,height:i})},getBoxPosition:function(t){var i=t.plotY<this.box.top+this.box.height/2;return t.plotX<this.box.left+this.box.width/2?i?0:3:i?1:2}}),i((t=t.QuadTree=function(t,i,e,o){this.box={left:t,top:i,width:e,height:o},this.maxDepth=25,this.root=new s(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()}).prototype,{insertNodes:function(t){t.forEach(function(t){this.root.insert(t,this.maxDepth)},this)},visitNodeRecursive:function(t,i,e){var o;t=t||this.root,!1!==(o=t===this.root&&i?i(t):o)&&(t.nodes.forEach(function(t){if(t.isInternal){if(!1===(o=i?i(t):o))return;this.visitNodeRecursive(t,i,e)}else t.body&&i&&i(t.body);e&&e(t)},this),t===this.root&&e&&e(t))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(t){t.updateMassAndCenter()})}})}),i(t,"Series/Networkgraph/Layouts.js",[t["Core/Chart/Chart.js"],t["Core/Animation/AnimationUtilities.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,i,e,o){var s=i.setAnimation;i=o.addEvent;var n=o.clamp,r=o.defined,a=o.extend,h=o.isFunction,p=o.pick;e.layouts={"reingold-fruchterman":function(){}},a(e.layouts["reingold-fruchterman"].prototype,{init:function(t){this.options=t,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=e.networkgraphIntegrations[t.integration],this.enableSimulation=t.enableSimulation,this.attractiveForce=p(t.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=p(t.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=t.approximation},updateSimulation:function(t){this.enableSimulation=p(t,this.options.enableSimulation)},start:function(){var t=this.series,i=this.options;this.currentStep=0,this.forces=t[0]&&t[0].forces||[],this.chart=t[0]&&t[0].chart,this.initialRendering&&(this.initPositions(),t.forEach(function(t){t.finishedAnimating=!0,t.render()})),this.setK(),this.resetSimulation(i),this.enableSimulation&&this.step()},step:function(){var i=this,t=this.series;i.currentStep++,"barnes-hut"===i.approximation&&(i.createQuadTree(),i.quadTree.calculateMassAndCenter()),i.forces.forEach(function(t){i[t+"Forces"](i.temperature)}),i.applyLimits(i.temperature),i.temperature=i.coolDown(i.startTemperature,i.diffTemperature,i.currentStep),i.prevSystemTemperature=i.systemTemperature,i.systemTemperature=i.getSystemTemperature(),i.enableSimulation&&(t.forEach(function(t){t.chart&&t.render()}),i.maxIterations--&&isFinite(i.temperature)&&!i.isStable()?(i.simulation&&e.win.cancelAnimationFrame(i.simulation),i.simulation=e.win.requestAnimationFrame(function(){i.step()})):i.simulation=!1)},stop:function(){this.simulation&&e.win.cancelAnimationFrame(this.simulation)},setArea:function(t,i,e,o){this.box={left:t,top:i,width:e,height:o}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(t,i){t.forEach(function(t){-1===i.indexOf(t)&&i.push(t)})},removeElementFromCollection:function(t,i){-1!==(t=i.indexOf(t))&&i.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(t){this.maxIterations=p(t,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(t){this.initialRendering=t},createQuadTree:function(){this.quadTree=new e.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var t=this.options.initialPositions;h(t)?(t.call(this),this.nodes.forEach(function(t){r(t.prevX)||(t.prevX=t.plotX),r(t.prevY)||(t.prevY=t.plotY),t.dispX=0,t.dispY=0})):"circle"===t?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var e=this.box,t=this.nodes,o=2*Math.PI/(t.length+1),i=t.filter(function(t){return 0===t.linksTo.length}),s=[],n={},r=this.options.initialPositionRadius;i.forEach(function(t){s.push(t),function i(t){t.linksFrom.forEach(function(t){n[t.toNode.id]||(n[t.toNode.id]=!0,s.push(t.toNode),i(t.toNode))})}(t)}),s.length?t.forEach(function(t){-1===s.indexOf(t)&&s.push(t)}):s=t,s.forEach(function(t,i){t.plotX=t.prevX=p(t.plotX,e.width/2+r*Math.cos(i*o)),t.plotY=t.prevY=p(t.plotY,e.height/2+r*Math.sin(i*o)),t.dispX=0,t.dispY=0})},setRandomPositions:function(){function e(t){return(t=t*t/Math.PI)-Math.floor(t)}var o=this.box,t=this.nodes,s=t.length+1;t.forEach(function(t,i){t.plotX=t.prevX=p(t.plotX,o.width*e(i)),t.plotY=t.prevY=p(t.plotY,o.height*e(s+i)),t.dispX=0,t.dispY=0})},force:function(t){this.integration[t].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var i=0,e=0,o=0;return this.nodes.forEach(function(t){e+=t.plotX*t.mass,o+=t.plotY*t.mass,i+=t.mass}),this.barycenter={x:e,y:o,xFactor:e/i,yFactor:o/i}},barnesHutApproximation:function(t,i){var e,o,s=this.getDistXY(t,i),n=this.vectorLength(s);return t!==i&&0!==n&&(i.isInternal?o=!(i.boxSize/n<this.options.theta&&0!==n)||(e=this.repulsiveForce(n,this.k),this.force("repulsive",t,e*i.mass,s,n),!1):(e=this.repulsiveForce(n,this.k),this.force("repulsive",t,e*i.mass,s,n))),o},repulsiveForces:function(){var n=this;"barnes-hut"===n.approximation?n.nodes.forEach(function(i){n.quadTree.visitNodeRecursive(null,function(t){return n.barnesHutApproximation(i,t)})}):n.nodes.forEach(function(s){n.nodes.forEach(function(t){var i,e,o;s===t||s.fixedPosition||(i=n.getDistXY(s,t),0!==(e=n.vectorLength(i))&&(o=n.repulsiveForce(e,n.k),n.force("repulsive",s,o*t.mass,i,e)))})})},attractiveForces:function(){var i,e,o,s=this;s.links.forEach(function(t){t.fromNode&&t.toNode&&(i=s.getDistXY(t.fromNode,t.toNode),0!==(e=s.vectorLength(i))&&(o=s.attractiveForce(e,s.k),s.force("attractive",t,o,i,e)))})},applyLimits:function(){var i=this;i.nodes.forEach(function(t){t.fixedPosition||(i.integration.integrate(i,t),i.applyLimitBox(t,i.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(t,i){var e=t.radius;t.plotX=n(t.plotX,i.left+e,i.width-e),t.plotY=n(t.plotY,i.top+e,i.height-e)},coolDown:function(t,i,e){return t-i*e},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(t,i){return t+i.temperature},0)},vectorLength:function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},getDistR:function(t,i){return t=this.getDistXY(t,i),this.vectorLength(t)},getDistXY:function(t,i){var e=t.plotX-i.plotX;return{x:e,y:t=t.plotY-i.plotY,absX:Math.abs(e),absY:Math.abs(t)}}}),i(t,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.stop()})}),i(t,"render",function(){function t(t){t.maxIterations--&&isFinite(t.temperature)&&!t.isStable()&&!t.enableSimulation&&(t.beforeStep&&t.beforeStep(),t.step(),i=!(e=!1))}var i=!1;if(this.graphLayoutsLookup){for(s(!1,this),this.graphLayoutsLookup.forEach(function(t){t.start()});!e;){var e=!0;this.graphLayoutsLookup.forEach(t)}i&&this.series.forEach(function(t){t&&t.layout&&t.render()})}}),i(t,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(t){t.updateSimulation(!1)}),this.redraw())}),i(t,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(t){t.updateSimulation()}),this.redraw()})}),i(t,"Series/Networkgraph/DraggableNodes.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,i,e){var n=e.addEvent;i.dragNodesMixin={onMouseDown:function(t,i){i=this.chart.pointer.normalize(i),t.fixedPosition={chartX:i.chartX,chartY:i.chartY,plotX:t.plotX,plotY:t.plotY},t.inDragMode=!0},onMouseMove:function(t,i){var e,o,s,n,r;t.fixedPosition&&t.inDragMode&&(o=(e=this.chart).pointer.normalize(i),i=t.fixedPosition.chartX-o.chartX,o=t.fixedPosition.chartY-o.chartY,n=s=void 0,r=e.graphLayoutsLookup,(5<Math.abs(i)||5<Math.abs(o))&&(s=t.fixedPosition.plotX-i,n=t.fixedPosition.plotY-o,e.isInsidePlot(s,n)&&(t.plotX=s,t.plotY=n,t.hasDragged=!0,this.redrawHalo(t),r.forEach(function(t){t.restartSimulation()}))))},onMouseUp:function(t,i){t.fixedPosition&&(t.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),t.inDragMode=t.hasDragged=!1,this.options.fixedDraggable||delete t.fixedPosition)},redrawHalo:function(t){t&&this.halo&&this.halo.attr({d:t.haloPath(this.options.states.hover.halo.size)})}},n(t,"load",function(){var t,e,o,s=this;s.container&&(t=n(s.container,"mousedown",function(t){var i=s.hoverPoint;i&&i.series&&i.series.hasDraggableNodes&&i.series.options.draggable&&(i.series.onMouseDown(i,t),e=n(s.container,"mousemove",function(t){return i&&i.series&&i.series.onMouseMove(i,t)}),o=n(s.container.ownerDocument,"mouseup",function(t){return e(),o(),i&&i.series&&i.series.onMouseUp(i,t)}))})),n(s,"destroy",function(){t()})})}),i(t,"Series/Networkgraph/Networkgraph.js",[t["Core/Globals.js"],t["Mixins/Nodes.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(n,e,t,r,i,o){var s,a,h,p=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)i.hasOwnProperty(e)&&(t[e]=i[e])})(t,i)},function(t,i){function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),d=i.seriesTypes,c=o.addEvent,u=o.css,l=o.defined,f=o.extend,m=o.merge,g=o.pick,y=n.dragNodesMixin;function v(){var t=null!==a&&a.apply(this,arguments)||this;return t.data=void 0,t.nodes=void 0,t.options=void 0,t.points=void 0,t}function b(){var t=null!==h&&h.apply(this,arguments)||this;return t.degree=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.radius=void 0,t.series=void 0,t.toNode=void 0,t}return p(v,a=r),v.defaultOptions=m(r.defaultOptions,{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1},style:{transition:"opacity 2000ms"}},link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1e3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1}),f((o=v).prototype,{forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,drawGraph:void 0,isCartesian:!1,requireSorting:!1,directTouch:!0,noSharedTooltip:!0,pointArrayMap:["from","to"],trackerGroups:["group","markerGroup","dataLabelsGroup"],drawTracker:d.column.prototype.drawTracker,animate:void 0,buildKDTree:n.noop,createNode:e.createNode,destroy:function(){this.layout&&this.layout.removeElementFromCollection(this,this.layout.series),e.destroy.call(this)},init:function(){var t=this;return r.prototype.init.apply(this,arguments),c(this,"updatedData",function(){t.layout&&t.layout.stop()}),c(this,"afterUpdate",function(){t.nodes.forEach(function(t){t&&t.series&&t.resolveColor()})}),this},generatePoints:function(){var t;for(e.generatePoints.apply(this,arguments),this.options.nodes&&this.options.nodes.forEach(function(t){this.nodeLookup[t.id]||(this.nodeLookup[t.id]=this.createNode(t.id))},this),t=this.nodes.length-1;0<=t;t--){var i=this.nodes[t];i.degree=i.getDegree(),i.radius=g(i.marker&&i.marker.radius,this.options.marker&&this.options.marker.radius,0),this.nodeLookup[i.id]||i.remove()}this.data.forEach(function(t){t.formatPrefix="link"}),this.indexateNodes()},getPointsCollection:function(){return this.nodes||[]},indexateNodes:function(){this.nodes.forEach(function(t,i){t.index=i})},markerAttribs:function(t,i){return i=r.prototype.markerAttribs.call(this,t,i),l(t.plotY)||(i.y=0),i.x=(t.plotX||0)-(i.width||0)/2,i},translate:function(){this.processedXData||this.processData(),this.generatePoints(),this.deferLayout(),this.nodes.forEach(function(t){t.isInside=!0,t.linksFrom.forEach(function(t){t.shapeType="path",t.y=1})})},deferLayout:function(){var t,i=this.options.layoutAlgorithm,e=this.chart.graphLayoutsStorage,o=this.chart.graphLayoutsLookup,s=this.chart.options.chart;this.visible&&(e||(this.chart.graphLayoutsStorage=e={},this.chart.graphLayoutsLookup=o=[]),(t=e[i.type])||(i.enableSimulation=l(s.forExport)?!s.forExport:i.enableSimulation,e[i.type]=t=new n.layouts[i.type],t.init(i),o.splice(t.index,0,t)),(this.layout=t).setArea(0,0,this.chart.plotWidth,this.chart.plotHeight),t.addElementsToCollection([this],t.series),t.addElementsToCollection(this.nodes,t.nodes),t.addElementsToCollection(this.points,t.links))},render:function(){var t=this.points,i=this.chart.hoverPoint,e=[];this.points=this.nodes,d.line.prototype.render.call(this),(this.points=t).forEach(function(t){t.fromNode&&t.toNode&&(t.renderLink(),t.redrawLink())}),i&&i.series===this&&this.redrawHalo(i),this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(t){t.dataLabel&&e.push(t.dataLabel)}),this.chart.hideOverlappingLabels(e))},drawDataLabels:function(){var t=this.options.dataLabels.textPath;r.prototype.drawDataLabels.apply(this,arguments),this.points=this.data,this.options.dataLabels.textPath=this.options.dataLabels.linkTextPath,r.prototype.drawDataLabels.apply(this,arguments),this.points=this.nodes,this.options.dataLabels.textPath=t},pointAttribs:function(t,i){var e=i||t&&t.state||"normal";return i=r.prototype.pointAttribs.call(this,t,e),e=this.options.states[e],t&&!t.isNode&&(i=t.getLinkAttributes(),e&&(i={stroke:e.linkColor||i.stroke,dashstyle:e.linkDashStyle||i.dashstyle,opacity:g(e.linkOpacity,i.opacity),"stroke-width":e.linkColor||i["stroke-width"]})),i},redrawHalo:y.redrawHalo,onMouseDown:y.onMouseDown,onMouseMove:y.onMouseMove,onMouseUp:y.onMouseUp,setState:function(t,i){i?(this.points=this.nodes.concat(this.data),r.prototype.setState.apply(this,arguments),this.points=this.data):r.prototype.setState.apply(this,arguments),this.layout.simulation||t||this.render()}}),h=r.prototype.pointClass,p(b,h),f((y=b).prototype,{setState:e.setNodeState,init:function(){return t.prototype.init.apply(this,arguments),this.series.options.draggable&&!this.series.chart.styledMode&&(c(this,"mouseOver",function(){u(this.series.chart.container,{cursor:"move"})}),c(this,"mouseOut",function(){u(this.series.chart.container,{cursor:"default"})})),this},getDegree:function(){var t=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===t?1:t},getLinkAttributes:function(){var t=this.series.options.link,i=this.options;return{"stroke-width":g(i.width,t.width),stroke:i.color||t.color,dashstyle:i.dashStyle||t.dashStyle,opacity:g(i.opacity,t.opacity,1)}},renderLink:function(){var i;this.graphic||(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).addClass(this.getClassName(),!0).add(this.series.group),this.series.chart.styledMode)||(i=this.series.pointAttribs(this),this.graphic.attr(i),(this.dataLabels||[]).forEach(function(t){t&&t.attr({opacity:i.opacity})}))},redrawLink:function(){var i,t,e=this.getLinkPath();this.graphic&&(this.shapeArgs={d:e},this.series.chart.styledMode||(i=this.series.pointAttribs(this),this.graphic.attr(i),(this.dataLabels||[]).forEach(function(t){t&&t.attr({opacity:i.opacity})})),this.graphic.animate(this.shapeArgs),t=e[0],e=e[1],"M"===t[0]&&"L"===e[0]&&(this.plotX=(t[1]+e[1])/2,this.plotY=(t[2]+e[2])/2))},getMass:function(){var t=this.fromNode.mass,i=this.toNode.mass,e=t+i;return{fromNode:1-t/e,toNode:1-i/e}},getLinkPath:function(){var t=this.fromNode,i=this.toNode;return t.plotX>i.plotX&&(t=this.toNode,i=this.fromNode),[["M",t.plotX||0,t.plotY||0],["L",i.plotX||0,i.plotY||0]]},isValid:function(){return!this.isNode||l(this.id)},remove:function(t,i){var e,o=this.series,s=o.options.nodes||[],n=s.length;if(this.isNode){for(o.points=[],[].concat(this.linksFrom).concat(this.linksTo).forEach(function(t){-1<(e=t.fromNode.linksFrom.indexOf(t))&&t.fromNode.linksFrom.splice(e,1),-1<(e=t.toNode.linksTo.indexOf(t))&&t.toNode.linksTo.splice(e,1),r.prototype.removePoint.call(o,o.data.indexOf(t),!1,!1)}),o.points=o.data.slice(),o.nodes.splice(o.nodes.indexOf(this),1);n--;)if(s[n].id===this.options.id){o.options.nodes.splice(n,1);break}this&&this.destroy(),o.isDirty=!0,o.isDirtyData=!0,t&&o.chart.redraw(t)}else o.removePoint(o.data.indexOf(this),t,i)},destroy:function(){return this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(t){t.destroyElements&&t.destroyElements()}),this.series.layout.removeElementFromCollection(this,this.series.layout[this.isNode?"nodes":"links"]),t.prototype.destroy.apply(this,arguments)}}),o.prototype.pointClass=y,i.registerSeriesType("networkgraph",o),o}),i(t,"masters/modules/networkgraph.src.js",[],function(){})});