﻿const DataService = function () {
    const self = this;

    function getToken(callback) {
        $.ajax({
            type: "GET",
            url: "/api/security/"
        }).done((token) => {
            callback(token);
        }).fail(() => {
            // Logout the user
        });
    }

    function xhrRequest(args, method, body) {
        const callback = (token) => {
            $.ajax({
                type: method,
                data: body,
                url: args.url,
                contentType: "application/json",
                headers: {
                    "Authorization": "Bearer " + token
                }
            }).done((data) => {
                if (typeof args.done === "function") {
                    args.done(data);
                }
            }).fail((error) => {
                if (error.responseJSON) {
                    if (error.responseJSON.messages) {
                        if (Array.isArray(error.responseJSON.messages)) {
                            error.responseJSON.messages.forEach(error => {
                                iziToast.show(
                                    {
                                        position: 'topRight',
                                        color: 'red', message: error
                                    });
                            });
                        } else {
                            iziToast.show(
                                    {
                                        position: 'topRight',
                                        color: 'red', message: error.responseJSON.messages
                                    });
                        }
                    } else {
                        if(error.responseJSON)
                        iziToast.show(
                                    {
                                        position: 'topRight',
                                        color: 'red', message: error.responseJSON.title
                                    });
                    }
                } else {
                    iziToast.show(
                                    {
                                        position: 'topRight',
                                        color: 'red', message: 'Ha ocurrido un error'
                                    });
                }

                if (typeof args.fail === "function") {
                    args.fail(error);
                }
            });
        };
        getToken(callback);
    }


    function xhrUploadRequest(args) {
        const callback = (token) => {
            $.ajax({
                method: 'post',
                cache: false,
                contentType: false,
                processData: false, 
                url: args.url,
                data: args.data,
                headers: {
                    "Authorization": "Bearer " + token
                }
            }).done((data) => {
                if (typeof args.done === "function") {
                    args.done(data);
                }
            }).fail((error) => {
                if (error.responseJSON) {
                    if (error.responseJSON.messages) {
                        if (Array.isArray(error.responseJSON.messages)) {
                            error.responseJSON.messages.forEach(error => {
                                $.notify(error, "error");
                            });
                        } else {
                            $.notify(error.responseJSON.messages, "error");
                        }
                    } else {
                        $.notify(error.responseJSON, "error");
                    }
                } else {
                    $.notify("Ha ocurrido un error", "error");
                }

                if (typeof args.fail === "function") {
                    args.fail(error);
                }
            });
        };
        getToken(callback);
    }

    function stringifyData(args) {
        if (typeof args.data !== "undefined") {
            return JSON.stringify(args.data);
        }

        return null;
    }

    self.Get = (args) => {
        xhrRequest(args, "GET", null);
    };

    self.Delete = (args) => {
        xhrRequest(args, "DELETE", null);
    };

    self.Patch = (args) => {
        xhrRequest(args, "PATCH", stringifyData(args));
    };

    self.Post = (args) => {
        xhrRequest(args, "POST", stringifyData(args));
    };

    self.Put = (args) => {
        xhrRequest(args, "PUT", stringifyData(args));
    };

    self.Upload = (args) => {
        xhrUploadRequest(args);
    };

};