/**
 * Minified by jsDelivr using Terser v5.3.5.
 * Original file: /npm/chart.js@3.3.2/dist/chart.esm.js
 *
 * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files
 */
/*!
 * Chart.js v3.3.2
 * https://www.chartjs.org
 * (c) 2021 Chart.js Contributors
 * Released under the MIT License
 */
import{r as requestAnimFrame,a as resolve,e as effects,c as color,i as isObject,b as isArray,d as defaults,v as valueOrDefault,u as unlistenArrayEvents,l as listenArrayEvents,f as resolveObjectKey,g as isNumberFinite,h as defined,s as sign,j as isNullOrUndef,k as clipArea,m as unclipArea,_ as _arrayUnique,t as toRadians,n as toPercentage,o as toDimension,T as TAU,p as formatNumber,q as _angleBetween,H as HALF_PI,P as PI,w as isNumber,x as _limitValue,y as _lookupByKey,z as getRelativePosition$1,A as _isPointInArea,B as _rlookupByKey,C as toPadding,D as each,E as getMaximumSize,F as _getParentNode,G as readUsedSize,I as throttled,J as supportsEventListenerOptions,K as log10,L as _factorize,M as finiteOrDefault,N as callback,O as _addGrace,Q as toDegrees,R as _measureText,S as _int16Range,U as _alignPixel,V as renderText,W as toFont,X as _toLeftRightCenter,Y as _alignStartEnd,Z as overrides,$ as merge,a0 as _capitalize,a1 as descriptors,a2 as isFunction,a3 as _attachContext,a4 as _createResolver,a5 as _descriptors,a6 as mergeIf,a7 as uid,a8 as debounce,a9 as retinaScale,aa as clearCanvas,ab as setsEqual,ac as _elementsEqual,ad as getAngleFromPoint,ae as _readValueToProps,af as _updateBezierControlPoints,ag as _computeSegments,ah as _boundSegments,ai as _steppedInterpolation,aj as _bezierInterpolation,ak as _pointInLine,al as _steppedLineTo,am as _bezierCurveTo,an as drawPoint,ao as addRoundedRectPath,ap as toTRBL,aq as toTRBLCorners,ar as _boundSegment,as as _normalizeAngle,at as getRtlAdapter,au as overrideTextDirection,av as _textX,aw as restoreTextDirection,ax as noop,ay as distanceBetweenPoints,az as _setMinAndMaxByKey,aA as niceNum,aB as almostWhole,aC as almostEquals,aD as _decimalPlaces,aE as _longestText,aF as _filterBetween,aG as _lookup}from"./chunks/helpers.segment.js";export{d as defaults}from"./chunks/helpers.segment.js";class Animator{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0}_notify(t,e,i,a){const n=e.listeners[a],o=e.duration;n.forEach((a=>a({chart:t,initial:e.initial,numSteps:o,currentStep:Math.min(i-e.start,o)})))}_refresh(){const t=this;t._request||(t._running=!0,t._request=requestAnimFrame.call(window,(()=>{t._update(),t._request=null,t._running&&t._refresh()})))}_update(t=Date.now()){const e=this;let i=0;e._charts.forEach(((a,n)=>{if(!a.running||!a.items.length)return;const o=a.items;let s,r=o.length-1,l=!1;for(;r>=0;--r)s=o[r],s._active?(s._total>a.duration&&(a.duration=s._total),s.tick(t),l=!0):(o[r]=o[o.length-1],o.pop());l&&(n.draw(),e._notify(n,a,t,"progress")),o.length||(a.running=!1,e._notify(n,a,t,"complete"),a.initial=!1),i+=o.length})),e._lastDate=t,0===i&&(e._running=!1)}_getAnims(t){const e=this._charts;let i=e.get(t);return i||(i={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},e.set(t,i)),i}listen(t,e,i){this._getAnims(t).listeners[e].push(i)}add(t,e){e&&e.length&&this._getAnims(t).items.push(...e)}has(t){return this._getAnims(t).items.length>0}start(t){const e=this._charts.get(t);e&&(e.running=!0,e.start=Date.now(),e.duration=e.items.reduce(((t,e)=>Math.max(t,e._duration)),0),this._refresh())}running(t){if(!this._running)return!1;const e=this._charts.get(t);return!!(e&&e.running&&e.items.length)}stop(t){const e=this._charts.get(t);if(!e||!e.items.length)return;const i=e.items;let a=i.length-1;for(;a>=0;--a)i[a].cancel();e.items=[],this._notify(t,e,Date.now(),"complete")}remove(t){return this._charts.delete(t)}}var animator=new Animator;const transparent="transparent",interpolators={boolean:(t,e,i)=>i>.5?e:t,color(t,e,i){const a=color(t||transparent),n=a.valid&&color(e||transparent);return n&&n.valid?n.mix(a,i).hexString():e},number:(t,e,i)=>t+(e-t)*i};class Animation{constructor(t,e,i,a){const n=e[i];a=resolve([t.to,a,n,t.from]);const o=resolve([t.from,n,a]);this._active=!0,this._fn=t.fn||interpolators[t.type||typeof o],this._easing=effects[t.easing]||effects.linear,this._start=Math.floor(Date.now()+(t.delay||0)),this._duration=this._total=Math.floor(t.duration),this._loop=!!t.loop,this._target=e,this._prop=i,this._from=o,this._to=a,this._promises=void 0}active(){return this._active}update(t,e,i){const a=this;if(a._active){a._notify(!1);const n=a._target[a._prop],o=i-a._start,s=a._duration-o;a._start=i,a._duration=Math.floor(Math.max(s,t.duration)),a._total+=o,a._loop=!!t.loop,a._to=resolve([t.to,e,n,t.from]),a._from=resolve([t.from,n,e])}}cancel(){const t=this;t._active&&(t.tick(Date.now()),t._active=!1,t._notify(!1))}tick(t){const e=this,i=t-e._start,a=e._duration,n=e._prop,o=e._from,s=e._loop,r=e._to;let l;if(e._active=o!==r&&(s||i<a),!e._active)return e._target[n]=r,void e._notify(!0);i<0?e._target[n]=o:(l=i/a%2,l=s&&l>1?2-l:l,l=e._easing(Math.min(1,Math.max(0,l))),e._target[n]=e._fn(o,r,l))}wait(){const t=this._promises||(this._promises=[]);return new Promise(((e,i)=>{t.push({res:e,rej:i})}))}_notify(t){const e=t?"res":"rej",i=this._promises||[];for(let t=0;t<i.length;t++)i[t][e]()}}const numbers=["x","y","borderWidth","radius","tension"],colors=["color","borderColor","backgroundColor"];defaults.set("animation",{delay:void 0,duration:1e3,easing:"easeOutQuart",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0});const animationOptions=Object.keys(defaults.animation);defaults.describe("animation",{_fallback:!1,_indexable:!1,_scriptable:t=>"onProgress"!==t&&"onComplete"!==t&&"fn"!==t}),defaults.set("animations",{colors:{type:"color",properties:colors},numbers:{type:"number",properties:numbers}}),defaults.describe("animations",{_fallback:"animation"}),defaults.set("transitions",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:"transparent"},visible:{type:"boolean",duration:0}}},hide:{animations:{colors:{to:"transparent"},visible:{type:"boolean",easing:"linear",fn:t=>0|t}}}});class Animations{constructor(t,e){this._chart=t,this._properties=new Map,this.configure(e)}configure(t){if(!isObject(t))return;const e=this._properties;Object.getOwnPropertyNames(t).forEach((i=>{const a=t[i];if(!isObject(a))return;const n={};for(const t of animationOptions)n[t]=a[t];(isArray(a.properties)&&a.properties||[i]).forEach((t=>{t!==i&&e.has(t)||e.set(t,n)}))}))}_animateOptions(t,e){const i=e.options,a=resolveTargetOptions(t,i);if(!a)return[];const n=this._createAnimations(a,i);return i.$shared&&awaitAll(t.options.$animations,i).then((()=>{t.options=i}),(()=>{})),n}_createAnimations(t,e){const i=this._properties,a=[],n=t.$animations||(t.$animations={}),o=Object.keys(e),s=Date.now();let r;for(r=o.length-1;r>=0;--r){const l=o[r];if("$"===l.charAt(0))continue;if("options"===l){a.push(...this._animateOptions(t,e));continue}const c=e[l];let d=n[l];const h=i.get(l);if(d){if(h&&d.active()){d.update(h,c,s);continue}d.cancel()}h&&h.duration?(n[l]=d=new Animation(h,t,l,c),a.push(d)):t[l]=c}return a}update(t,e){if(0===this._properties.size)return void Object.assign(t,e);const i=this._createAnimations(t,e);return i.length?(animator.add(this._chart,i),!0):void 0}}function awaitAll(t,e){const i=[],a=Object.keys(e);for(let e=0;e<a.length;e++){const n=t[a[e]];n&&n.active()&&i.push(n.wait())}return Promise.all(i)}function resolveTargetOptions(t,e){if(!e)return;let i=t.options;if(i)return i.$shared&&(t.options=i=Object.assign({},i,{$shared:!1,$animations:{}})),i;t.options=e}function scaleClip(t,e){const i=t&&t.options||{},a=i.reverse,n=void 0===i.min?e:0,o=void 0===i.max?e:0;return{start:a?o:n,end:a?n:o}}function defaultClip(t,e,i){if(!1===i)return!1;const a=scaleClip(t,i),n=scaleClip(e,i);return{top:n.end,right:a.end,bottom:n.start,left:a.start}}function toClip(t){let e,i,a,n;return isObject(t)?(e=t.top,i=t.right,a=t.bottom,n=t.left):e=i=a=n=t,{top:e,right:i,bottom:a,left:n}}function getSortedDatasetIndices(t,e){const i=[],a=t._getSortedDatasetMetas(e);let n,o;for(n=0,o=a.length;n<o;++n)i.push(a[n].index);return i}function applyStack(t,e,i,a){const n=t.keys,o="single"===a.mode;let s,r,l,c;if(null!==e){for(s=0,r=n.length;s<r;++s){if(l=+n[s],l===i){if(a.all)continue;break}c=t.values[l],isNumberFinite(c)&&(o||0===e||sign(e)===sign(c))&&(e+=c)}return e}}function convertObjectDataToArray(t){const e=Object.keys(t),i=new Array(e.length);let a,n,o;for(a=0,n=e.length;a<n;++a)o=e[a],i[a]={x:o,y:t[o]};return i}function isStacked(t,e){const i=t&&t.options.stacked;return i||void 0===i&&void 0!==e.stack}function getStackKey(t,e,i){return`${t.id}.${e.id}.${i.stack||i.type}`}function getUserBounds(t){const{min:e,max:i,minDefined:a,maxDefined:n}=t.getUserBounds();return{min:a?e:Number.NEGATIVE_INFINITY,max:n?i:Number.POSITIVE_INFINITY}}function getOrCreateStack(t,e,i){const a=t[e]||(t[e]={});return a[i]||(a[i]={})}function getLastIndexInStack(t,e,i){for(const a of e.getMatchingVisibleMetas("bar").reverse()){const e=t[a.index];if(i&&e>0||!i&&e<0)return a.index}return null}function updateStacks(t,e){const{chart:i,_cachedMeta:a}=t,n=i._stacks||(i._stacks={}),{iScale:o,vScale:s,index:r}=a,l=o.axis,c=s.axis,d=getStackKey(o,s,a),h=e.length;let u;for(let t=0;t<h;++t){const i=e[t],{[l]:a,[c]:o}=i;u=(i._stacks||(i._stacks={}))[c]=getOrCreateStack(n,d,a),u[r]=o,u._top=getLastIndexInStack(u,s,!0),u._bottom=getLastIndexInStack(u,s,!1)}}function getFirstScaleId(t,e){const i=t.scales;return Object.keys(i).filter((t=>i[t].axis===e)).shift()}function createDatasetContext(t,e){return Object.assign(Object.create(t),{active:!1,dataset:void 0,datasetIndex:e,index:e,mode:"default",type:"dataset"})}function createDataContext(t,e,i){return Object.assign(Object.create(t),{active:!1,dataIndex:e,parsed:void 0,raw:void 0,element:i,index:e,mode:"default",type:"data"})}function clearStacks(t,e){const i=t.vScale&&t.vScale.axis;if(i){e=e||t._parsed;for(const a of e){const e=a._stacks;if(!e||void 0===e[i]||void 0===e[i][t.index])return;delete e[i][t.index]}}}const isDirectUpdateMode=t=>"reset"===t||"none"===t,cloneIfNotShared=(t,e)=>e?t:Object.assign({},t);class DatasetController{constructor(t,e){this.chart=t,this._ctx=t.ctx,this.index=e,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.$context=void 0,this._syncList=[],this.initialize()}initialize(){const t=this,e=t._cachedMeta;t.configure(),t.linkScales(),e._stacked=isStacked(e.vScale,e),t.addElements()}updateIndex(t){this.index!==t&&clearStacks(this._cachedMeta),this.index=t}linkScales(){const t=this,e=t.chart,i=t._cachedMeta,a=t.getDataset(),n=(t,e,i,a)=>"x"===t?e:"r"===t?a:i,o=i.xAxisID=valueOrDefault(a.xAxisID,getFirstScaleId(e,"x")),s=i.yAxisID=valueOrDefault(a.yAxisID,getFirstScaleId(e,"y")),r=i.rAxisID=valueOrDefault(a.rAxisID,getFirstScaleId(e,"r")),l=i.indexAxis,c=i.iAxisID=n(l,o,s,r),d=i.vAxisID=n(l,s,o,r);i.xScale=t.getScaleForId(o),i.yScale=t.getScaleForId(s),i.rScale=t.getScaleForId(r),i.iScale=t.getScaleForId(c),i.vScale=t.getScaleForId(d)}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(t){return this.chart.scales[t]}_getOtherScale(t){const e=this._cachedMeta;return t===e.iScale?e.vScale:e.iScale}reset(){this._update("reset")}_destroy(){const t=this._cachedMeta;this._data&&unlistenArrayEvents(this._data,this),t._stacked&&clearStacks(t)}_dataCheck(){const t=this,e=t.getDataset(),i=e.data||(e.data=[]),a=t._data;if(isObject(i))t._data=convertObjectDataToArray(i);else if(a!==i){if(a){unlistenArrayEvents(a,t);const e=t._cachedMeta;clearStacks(e),e._parsed=[]}i&&Object.isExtensible(i)&&listenArrayEvents(i,t),t._syncList=[],t._data=i}}addElements(){const t=this,e=t._cachedMeta;t._dataCheck(),t.datasetElementType&&(e.dataset=new t.datasetElementType)}buildOrUpdateElements(t){const e=this,i=e._cachedMeta,a=e.getDataset();let n=!1;e._dataCheck();const o=i._stacked;i._stacked=isStacked(i.vScale,i),i.stack!==a.stack&&(n=!0,clearStacks(i),i.stack=a.stack),e._resyncElements(t),(n||o!==i._stacked)&&updateStacks(e,i._parsed)}configure(){const t=this,e=t.chart.config,i=e.datasetScopeKeys(t._type),a=e.getOptionScopes(t.getDataset(),i,!0);t.options=e.createResolver(a,t.getContext()),t._parsing=t.options.parsing}parse(t,e){const i=this,{_cachedMeta:a,_data:n}=i,{iScale:o,_stacked:s}=a,r=o.axis;let l,c,d,h=0===t&&e===n.length||a._sorted,u=t>0&&a._parsed[t-1];if(!1===i._parsing)a._parsed=n,a._sorted=!0,d=n;else{d=isArray(n[t])?i.parseArrayData(a,n,t,e):isObject(n[t])?i.parseObjectData(a,n,t,e):i.parsePrimitiveData(a,n,t,e);const o=()=>null===c[r]||u&&c[r]<u[r];for(l=0;l<e;++l)a._parsed[l+t]=c=d[l],h&&(o()&&(h=!1),u=c);a._sorted=h}s&&updateStacks(i,d)}parsePrimitiveData(t,e,i,a){const{iScale:n,vScale:o}=t,s=n.axis,r=o.axis,l=n.getLabels(),c=n===o,d=new Array(a);let h,u,g;for(h=0,u=a;h<u;++h)g=h+i,d[h]={[s]:c||n.parse(l[g],g),[r]:o.parse(e[g],g)};return d}parseArrayData(t,e,i,a){const{xScale:n,yScale:o}=t,s=new Array(a);let r,l,c,d;for(r=0,l=a;r<l;++r)c=r+i,d=e[c],s[r]={x:n.parse(d[0],c),y:o.parse(d[1],c)};return s}parseObjectData(t,e,i,a){const{xScale:n,yScale:o}=t,{xAxisKey:s="x",yAxisKey:r="y"}=this._parsing,l=new Array(a);let c,d,h,u;for(c=0,d=a;c<d;++c)h=c+i,u=e[h],l[c]={x:n.parse(resolveObjectKey(u,s),h),y:o.parse(resolveObjectKey(u,r),h)};return l}getParsed(t){return this._cachedMeta._parsed[t]}getDataElement(t){return this._cachedMeta.data[t]}applyStack(t,e,i){const a=this.chart,n=this._cachedMeta,o=e[t.axis];return applyStack({keys:getSortedDatasetIndices(a,!0),values:e._stacks[t.axis]},o,n.index,{mode:i})}updateRangeFromParsed(t,e,i,a){const n=i[e.axis];let o=null===n?NaN:n;const s=a&&i._stacks[e.axis];a&&s&&(a.values=s,t.min=Math.min(t.min,o),t.max=Math.max(t.max,o),o=applyStack(a,n,this._cachedMeta.index,{all:!0})),t.min=Math.min(t.min,o),t.max=Math.max(t.max,o)}getMinMax(t,e){const i=this,a=i._cachedMeta,n=a._parsed,o=a._sorted&&t===a.iScale,s=n.length,r=i._getOtherScale(t),l=e&&a._stacked&&{keys:getSortedDatasetIndices(i.chart,!0),values:null},c={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:d,max:h}=getUserBounds(r);let u,g,p,f;function m(){return p=n[u],g=p[t.axis],f=p[r.axis],!isNumberFinite(g)||d>f||h<f}for(u=0;u<s&&(m()||(i.updateRangeFromParsed(c,t,p,l),!o));++u);if(o)for(u=s-1;u>=0;--u)if(!m()){i.updateRangeFromParsed(c,t,p,l);break}return c}getAllParsedValues(t){const e=this._cachedMeta._parsed,i=[];let a,n,o;for(a=0,n=e.length;a<n;++a)o=e[a][t.axis],isNumberFinite(o)&&i.push(o);return i}getMaxOverflow(){return!1}getLabelAndValue(t){const e=this._cachedMeta,i=e.iScale,a=e.vScale,n=this.getParsed(t);return{label:i?""+i.getLabelForValue(n[i.axis]):"",value:a?""+a.getLabelForValue(n[a.axis]):""}}_update(t){const e=this,i=e._cachedMeta;e.configure(),e._cachedDataOpts={},e.update(t||"default"),i._clip=toClip(valueOrDefault(e.options.clip,defaultClip(i.xScale,i.yScale,e.getMaxOverflow())))}update(t){}draw(){const t=this,e=t._ctx,i=t.chart,a=t._cachedMeta,n=a.data||[],o=i.chartArea,s=[],r=t._drawStart||0,l=t._drawCount||n.length-r;let c;for(a.dataset&&a.dataset.draw(e,o,r,l),c=r;c<r+l;++c){const t=n[c];t.active?s.push(t):t.draw(e,o)}for(c=0;c<s.length;++c)s[c].draw(e,o)}getStyle(t,e){const i=e?"active":"default";return void 0===t&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(i):this.resolveDataElementOptions(t||0,i)}getContext(t,e,i){const a=this,n=a.getDataset();let o;if(t>=0&&t<a._cachedMeta.data.length){const e=a._cachedMeta.data[t];o=e.$context||(e.$context=createDataContext(a.getContext(),t,e)),o.parsed=a.getParsed(t),o.raw=n.data[t],o.index=o.dataIndex=t}else o=a.$context||(a.$context=createDatasetContext(a.chart.getContext(),a.index)),o.dataset=n,o.index=o.datasetIndex=a.index;return o.active=!!e,o.mode=i,o}resolveDatasetElementOptions(t){return this._resolveElementOptions(this.datasetElementType.id,t)}resolveDataElementOptions(t,e){return this._resolveElementOptions(this.dataElementType.id,e,t)}_resolveElementOptions(t,e="default",i){const a=this,n="active"===e,o=a._cachedDataOpts,s=t+"-"+e,r=o[s],l=a.enableOptionSharing&&defined(i);if(r)return cloneIfNotShared(r,l);const c=a.chart.config,d=c.datasetElementScopeKeys(a._type,t),h=n?[t+"Hover","hover",t,""]:[t,""],u=c.getOptionScopes(a.getDataset(),d),g=Object.keys(defaults.elements[t]),p=c.resolveNamedOptions(u,g,(()=>a.getContext(i,n)),h);return p.$shared&&(p.$shared=l,o[s]=Object.freeze(cloneIfNotShared(p,l))),p}_resolveAnimations(t,e,i){const a=this,n=a.chart,o=a._cachedDataOpts,s="animation-"+e,r=o[s];if(r)return r;let l;if(!1!==n.options.animation){const n=a.chart.config,o=n.datasetAnimationScopeKeys(a._type,e),s=n.getOptionScopes(a.getDataset(),o);l=n.createResolver(s,a.getContext(t,i,e))}const c=new Animations(n,l&&l.animations);return l&&l._cacheable&&(o[s]=Object.freeze(c)),c}getSharedOptions(t){if(t.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},t))}includeOptions(t,e){return!e||isDirectUpdateMode(t)||this.chart._animationsDisabled}updateElement(t,e,i,a){isDirectUpdateMode(a)?Object.assign(t,i):this._resolveAnimations(e,a).update(t,i)}updateSharedOptions(t,e,i){t&&!isDirectUpdateMode(e)&&this._resolveAnimations(void 0,e).update(t,i)}_setStyle(t,e,i,a){t.active=a;const n=this.getStyle(e,a);this._resolveAnimations(e,i,a).update(t,{options:!a&&this.getSharedOptions(n)||n})}removeHoverStyle(t,e,i){this._setStyle(t,i,"active",!1)}setHoverStyle(t,e,i){this._setStyle(t,i,"active",!0)}_removeDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!1)}_setDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!0)}_resyncElements(t){const e=this,i=e._data,a=e._cachedMeta.data;for(const[t,i,a]of e._syncList)e[t](i,a);e._syncList=[];const n=a.length,o=i.length,s=Math.min(o,n);s&&e.parse(0,s),o>n?e._insertElements(n,o-n,t):o<n&&e._removeElements(o,n-o)}_insertElements(t,e,i=!0){const a=this,n=a._cachedMeta,o=n.data,s=t+e;let r;const l=t=>{for(t.length+=e,r=t.length-1;r>=s;r--)t[r]=t[r-e]};for(l(o),r=t;r<s;++r)o[r]=new a.dataElementType;a._parsing&&l(n._parsed),a.parse(t,e),i&&a.updateElements(o,t,e,"reset")}updateElements(t,e,i,a){}_removeElements(t,e){const i=this._cachedMeta;if(this._parsing){const a=i._parsed.splice(t,e);i._stacked&&clearStacks(i,a)}i.data.splice(t,e)}_onDataPush(){const t=arguments.length;this._syncList.push(["_insertElements",this.getDataset().data.length-t,t])}_onDataPop(){this._syncList.push(["_removeElements",this._cachedMeta.data.length-1,1])}_onDataShift(){this._syncList.push(["_removeElements",0,1])}_onDataSplice(t,e){this._syncList.push(["_removeElements",t,e]),this._syncList.push(["_insertElements",t,arguments.length-2])}_onDataUnshift(){this._syncList.push(["_insertElements",0,arguments.length])}}function getAllScaleValues(t){if(!t._cache.$bar){const e=t.getMatchingVisibleMetas("bar");let i=[];for(let a=0,n=e.length;a<n;a++)i=i.concat(e[a].controller.getAllParsedValues(t));t._cache.$bar=_arrayUnique(i.sort(((t,e)=>t-e)))}return t._cache.$bar}function computeMinSampleSize(t){const e=getAllScaleValues(t);let i,a,n,o,s=t._length;const r=()=>{32767!==n&&-32768!==n&&(defined(o)&&(s=Math.min(s,Math.abs(n-o)||s)),o=n)};for(i=0,a=e.length;i<a;++i)n=t.getPixelForValue(e[i]),r();for(o=void 0,i=0,a=t.ticks.length;i<a;++i)n=t.getPixelForTick(i),r();return s}function computeFitCategoryTraits(t,e,i,a){const n=i.barThickness;let o,s;return isNullOrUndef(n)?(o=e.min*i.categoryPercentage,s=i.barPercentage):(o=n*a,s=1),{chunk:o/a,ratio:s,start:e.pixels[t]-o/2}}function computeFlexCategoryTraits(t,e,i,a){const n=e.pixels,o=n[t];let s=t>0?n[t-1]:null,r=t<n.length-1?n[t+1]:null;const l=i.categoryPercentage;null===s&&(s=o-(null===r?e.end-e.start:r-o)),null===r&&(r=o+o-s);const c=o-(o-Math.min(s,r))/2*l;return{chunk:Math.abs(r-s)/2*l/a,ratio:i.barPercentage,start:c}}function parseFloatBar(t,e,i,a){const n=i.parse(t[0],a),o=i.parse(t[1],a),s=Math.min(n,o),r=Math.max(n,o);let l=s,c=r;Math.abs(s)>Math.abs(r)&&(l=r,c=s),e[i.axis]=c,e._custom={barStart:l,barEnd:c,start:n,end:o,min:s,max:r}}function parseValue(t,e,i,a){return isArray(t)?parseFloatBar(t,e,i,a):e[i.axis]=i.parse(t,a),e}function parseArrayOrPrimitive(t,e,i,a){const n=t.iScale,o=t.vScale,s=n.getLabels(),r=n===o,l=[];let c,d,h,u;for(c=i,d=i+a;c<d;++c)u=e[c],h={},h[n.axis]=r||n.parse(s[c],c),l.push(parseValue(u,h,o,c));return l}function isFloatBar(t){return t&&void 0!==t.barStart&&void 0!==t.barEnd}DatasetController.defaults={},DatasetController.prototype.datasetElementType=null,DatasetController.prototype.dataElementType=null;class BarController extends DatasetController{parsePrimitiveData(t,e,i,a){return parseArrayOrPrimitive(t,e,i,a)}parseArrayData(t,e,i,a){return parseArrayOrPrimitive(t,e,i,a)}parseObjectData(t,e,i,a){const{iScale:n,vScale:o}=t,{xAxisKey:s="x",yAxisKey:r="y"}=this._parsing,l="x"===n.axis?s:r,c="x"===o.axis?s:r,d=[];let h,u,g,p;for(h=i,u=i+a;h<u;++h)p=e[h],g={},g[n.axis]=n.parse(resolveObjectKey(p,l),h),d.push(parseValue(resolveObjectKey(p,c),g,o,h));return d}updateRangeFromParsed(t,e,i,a){super.updateRangeFromParsed(t,e,i,a);const n=i._custom;n&&e===this._cachedMeta.vScale&&(t.min=Math.min(t.min,n.min),t.max=Math.max(t.max,n.max))}getLabelAndValue(t){const e=this._cachedMeta,{iScale:i,vScale:a}=e,n=this.getParsed(t),o=n._custom,s=isFloatBar(o)?"["+o.start+", "+o.end+"]":""+a.getLabelForValue(n[a.axis]);return{label:""+i.getLabelForValue(n[i.axis]),value:s}}initialize(){const t=this;t.enableOptionSharing=!0,super.initialize();t._cachedMeta.stack=t.getDataset().stack}update(t){const e=this._cachedMeta;this.updateElements(e.data,0,e.data.length,t)}updateElements(t,e,i,a){const n=this,o="reset"===a,s=n._cachedMeta.vScale,r=s.getBasePixel(),l=s.isHorizontal(),c=n._getRuler(),d=n.resolveDataElementOptions(e,a),h=n.getSharedOptions(d),u=n.includeOptions(a,h);n.updateSharedOptions(h,a,d);for(let d=e;d<e+i;d++){const e=n.getParsed(d),i=o||isNullOrUndef(e[s.axis])?{base:r,head:r}:n._calculateBarValuePixels(d),g=n._calculateBarIndexPixels(d,c),p=(e._stacks||{})[s.axis],f={horizontal:l,base:i.base,enableBorderRadius:!p||isFloatBar(e._custom)||n.index===p._top||n.index===p._bottom,x:l?i.head:g.center,y:l?g.center:i.head,height:l?g.size:void 0,width:l?void 0:g.size};u&&(f.options=h||n.resolveDataElementOptions(d,a)),n.updateElement(t[d],d,f,a)}}_getStacks(t,e){const i=this._cachedMeta.iScale,a=i.getMatchingVisibleMetas(this._type),n=i.options.stacked,o=a.length,s=[];let r,l;for(r=0;r<o;++r){if(l=a[r],void 0!==e){const t=l.controller.getParsed(e)[l.controller._cachedMeta.vScale.axis];if(isNullOrUndef(t)||isNaN(t))continue}if((!1===n||-1===s.indexOf(l.stack)||void 0===n&&void 0===l.stack)&&s.push(l.stack),l.index===t)break}return s.length||s.push(void 0),s}_getStackCount(t){return this._getStacks(void 0,t).length}_getStackIndex(t,e,i){const a=this._getStacks(t,i),n=void 0!==e?a.indexOf(e):-1;return-1===n?a.length-1:n}_getRuler(){const t=this,e=t.options,i=t._cachedMeta,a=i.iScale,n=[];let o,s;for(o=0,s=i.data.length;o<s;++o)n.push(a.getPixelForValue(t.getParsed(o)[a.axis],o));const r=e.barThickness;return{min:r||computeMinSampleSize(a),pixels:n,start:a._startPixel,end:a._endPixel,stackCount:t._getStackCount(),scale:a,grouped:e.grouped,ratio:r?1:e.categoryPercentage*e.barPercentage}}_calculateBarValuePixels(t){const e=this,{vScale:i,_stacked:a}=e._cachedMeta,{base:n,minBarLength:o}=e.options,s=e.getParsed(t),r=s._custom,l=isFloatBar(r);let c,d,h=s[i.axis],u=0,g=a?e.applyStack(i,s,a):h;g!==h&&(u=g-h,g=h),l&&(h=r.barStart,g=r.barEnd-r.barStart,0!==h&&sign(h)!==sign(r.barEnd)&&(u=0),u+=h);const p=isNullOrUndef(n)||l?u:n;let f=i.getPixelForValue(p);c=this.chart.getDataVisibility(t)?i.getPixelForValue(u+g):f,d=c-f,void 0!==o&&Math.abs(d)<o&&(d=d<0?-o:o,0===h&&(f-=d/2),c=f+d);const m=n||0;if(f===i.getPixelForValue(m)){const t=i.getLineWidthForValue(m)/2;d>0?(f+=t,d-=t):d<0&&(f-=t,d+=t)}return{size:d,base:f,head:c,center:c+d/2}}_calculateBarIndexPixels(t,e){const i=this,a=e.scale,n=i.options,o=n.skipNull,s=valueOrDefault(n.maxBarThickness,1/0);let r,l;if(e.grouped){const a=o?i._getStackCount(t):e.stackCount,c="flex"===n.barThickness?computeFlexCategoryTraits(t,e,n,a):computeFitCategoryTraits(t,e,n,a),d=i._getStackIndex(i.index,i._cachedMeta.stack,o?t:void 0);r=c.start+c.chunk*d+c.chunk/2,l=Math.min(s,c.chunk*c.ratio)}else r=a.getPixelForValue(i.getParsed(t)[a.axis],t),l=Math.min(s,e.min*e.ratio);return{base:r-l/2,head:r+l/2,center:r,size:l}}draw(){const t=this,e=t.chart,i=t._cachedMeta,a=i.vScale,n=i.data,o=n.length;let s=0;for(clipArea(e.ctx,e.chartArea);s<o;++s)null!==t.getParsed(s)[a.axis]&&n[s].draw(t._ctx);unclipArea(e.ctx)}}BarController.id="bar",BarController.defaults={datasetElementType:!1,dataElementType:"bar",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:"number",properties:["x","y","base","width","height"]}}},BarController.overrides={interaction:{mode:"index"},scales:{_index_:{type:"category",offset:!0,grid:{offset:!0}},_value_:{type:"linear",beginAtZero:!0}}};class BubbleController extends DatasetController{initialize(){this.enableOptionSharing=!0,super.initialize()}parseObjectData(t,e,i,a){const{xScale:n,yScale:o}=t,{xAxisKey:s="x",yAxisKey:r="y"}=this._parsing,l=[];let c,d,h;for(c=i,d=i+a;c<d;++c)h=e[c],l.push({x:n.parse(resolveObjectKey(h,s),c),y:o.parse(resolveObjectKey(h,r),c),_custom:h&&h.r&&+h.r});return l}getMaxOverflow(){const{data:t,_parsed:e}=this._cachedMeta;let i=0;for(let a=t.length-1;a>=0;--a)i=Math.max(i,t[a].size()/2,e[a]._custom);return i>0&&i}getLabelAndValue(t){const e=this._cachedMeta,{xScale:i,yScale:a}=e,n=this.getParsed(t),o=i.getLabelForValue(n.x),s=a.getLabelForValue(n.y),r=n._custom;return{label:e.label,value:"("+o+", "+s+(r?", "+r:"")+")"}}update(t){const e=this._cachedMeta.data;this.updateElements(e,0,e.length,t)}updateElements(t,e,i,a){const n=this,o="reset"===a,{iScale:s,vScale:r}=n._cachedMeta,l=n.resolveDataElementOptions(e,a),c=n.getSharedOptions(l),d=n.includeOptions(a,c),h=s.axis,u=r.axis;for(let l=e;l<e+i;l++){const e=t[l],i=!o&&n.getParsed(l),c={},g=c[h]=o?s.getPixelForDecimal(.5):s.getPixelForValue(i[h]),p=c[u]=o?r.getBasePixel():r.getPixelForValue(i[u]);c.skip=isNaN(g)||isNaN(p),d&&(c.options=n.resolveDataElementOptions(l,a),o&&(c.options.radius=0)),n.updateElement(e,l,c,a)}n.updateSharedOptions(c,a,l)}resolveDataElementOptions(t,e){const i=this.getParsed(t);let a=super.resolveDataElementOptions(t,e);a.$shared&&(a=Object.assign({},a,{$shared:!1}));const n=a.radius;return"active"!==e&&(a.radius=0),a.radius+=valueOrDefault(i&&i._custom,n),a}}function getRatioAndOffset(t,e,i){let a=1,n=1,o=0,s=0;if(e<TAU){const r=t,l=r+e,c=Math.cos(r),d=Math.sin(r),h=Math.cos(l),u=Math.sin(l),g=(t,e,a)=>_angleBetween(t,r,l,!0)?1:Math.max(e,e*i,a,a*i),p=(t,e,a)=>_angleBetween(t,r,l,!0)?-1:Math.min(e,e*i,a,a*i),f=g(0,c,h),m=g(HALF_PI,d,u),x=p(PI,c,h),b=p(PI+HALF_PI,d,u);a=(f-x)/2,n=(m-b)/2,o=-(f+x)/2,s=-(m+b)/2}return{ratioX:a,ratioY:n,offsetX:o,offsetY:s}}BubbleController.id="bubble",BubbleController.defaults={datasetElementType:!1,dataElementType:"point",animations:{numbers:{type:"number",properties:["x","y","borderWidth","radius"]}}},BubbleController.overrides={scales:{x:{type:"linear"},y:{type:"linear"}},plugins:{tooltip:{callbacks:{title:()=>""}}}};class DoughnutController extends DatasetController{constructor(t,e){super(t,e),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0}linkScales(){}parse(t,e){const i=this.getDataset().data,a=this._cachedMeta;let n,o;for(n=t,o=t+e;n<o;++n)a._parsed[n]=+i[n]}_getRotation(){return toRadians(this.options.rotation-90)}_getCircumference(){return toRadians(this.options.circumference)}_getRotationExtents(){let t=TAU,e=-TAU;const i=this;for(let a=0;a<i.chart.data.datasets.length;++a)if(i.chart.isDatasetVisible(a)){const n=i.chart.getDatasetMeta(a).controller,o=n._getRotation(),s=n._getCircumference();t=Math.min(t,o),e=Math.max(e,o+s)}return{rotation:t,circumference:e-t}}update(t){const e=this,i=e.chart,{chartArea:a}=i,n=e._cachedMeta,o=n.data,s=e.getMaxBorderWidth()+e.getMaxOffset(o),r=Math.max((Math.min(a.width,a.height)-s)/2,0),l=Math.min(toPercentage(e.options.cutout,r),1),c=e._getRingWeight(e.index),{circumference:d,rotation:h}=e._getRotationExtents(),{ratioX:u,ratioY:g,offsetX:p,offsetY:f}=getRatioAndOffset(h,d,l),m=(a.width-s)/u,x=(a.height-s)/g,b=Math.max(Math.min(m,x)/2,0),_=toDimension(e.options.radius,b),y=(_-Math.max(_*l,0))/e._getVisibleDatasetWeightTotal();e.offsetX=p*_,e.offsetY=f*_,n.total=e.calculateTotal(),e.outerRadius=_-y*e._getRingWeightOffset(e.index),e.innerRadius=Math.max(e.outerRadius-y*c,0),e.updateElements(o,0,o.length,t)}_circumference(t,e){const i=this,a=i.options,n=i._cachedMeta,o=i._getCircumference();return e&&a.animation.animateRotate||!this.chart.getDataVisibility(t)||null===n._parsed[t]?0:i.calculateCircumference(n._parsed[t]*o/TAU)}updateElements(t,e,i,a){const n=this,o="reset"===a,s=n.chart,r=s.chartArea,l=s.options.animation,c=(r.left+r.right)/2,d=(r.top+r.bottom)/2,h=o&&l.animateScale,u=h?0:n.innerRadius,g=h?0:n.outerRadius,p=n.resolveDataElementOptions(e,a),f=n.getSharedOptions(p),m=n.includeOptions(a,f);let x,b=n._getRotation();for(x=0;x<e;++x)b+=n._circumference(x,o);for(x=e;x<e+i;++x){const e=n._circumference(x,o),i=t[x],s={x:c+n.offsetX,y:d+n.offsetY,startAngle:b,endAngle:b+e,circumference:e,outerRadius:g,innerRadius:u};m&&(s.options=f||n.resolveDataElementOptions(x,a)),b+=e,n.updateElement(i,x,s,a)}n.updateSharedOptions(f,a,p)}calculateTotal(){const t=this._cachedMeta,e=t.data;let i,a=0;for(i=0;i<e.length;i++){const e=t._parsed[i];null!==e&&!isNaN(e)&&this.chart.getDataVisibility(i)&&(a+=Math.abs(e))}return a}calculateCircumference(t){const e=this._cachedMeta.total;return e>0&&!isNaN(t)?TAU*(Math.abs(t)/e):0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,a=i.data.labels||[],n=formatNumber(e._parsed[t],i.options.locale);return{label:a[t]||"",value:n}}getMaxBorderWidth(t){const e=this;let i=0;const a=e.chart;let n,o,s,r,l;if(!t)for(n=0,o=a.data.datasets.length;n<o;++n)if(a.isDatasetVisible(n)){s=a.getDatasetMeta(n),t=s.data,r=s.controller,r!==e&&r.configure();break}if(!t)return 0;for(n=0,o=t.length;n<o;++n)l=r.resolveDataElementOptions(n),"inner"!==l.borderAlign&&(i=Math.max(i,l.borderWidth||0,l.hoverBorderWidth||0));return i}getMaxOffset(t){let e=0;for(let i=0,a=t.length;i<a;++i){const t=this.resolveDataElementOptions(i);e=Math.max(e,t.offset||0,t.hoverOffset||0)}return e}_getRingWeightOffset(t){let e=0;for(let i=0;i<t;++i)this.chart.isDatasetVisible(i)&&(e+=this._getRingWeight(i));return e}_getRingWeight(t){return Math.max(valueOrDefault(this.chart.data.datasets[t].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}DoughnutController.id="doughnut",DoughnutController.defaults={datasetElementType:!1,dataElementType:"arc",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:"number",properties:["circumference","endAngle","innerRadius","outerRadius","startAngle","x","y","offset","borderWidth"]}},cutout:"50%",rotation:0,circumference:360,radius:"100%",indexAxis:"r"},DoughnutController.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(((e,i)=>{const a=t.getDatasetMeta(0).controller.getStyle(i);return{text:e,fillStyle:a.backgroundColor,strokeStyle:a.borderColor,lineWidth:a.borderWidth,hidden:!t.getDataVisibility(i),index:i}})):[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}},tooltip:{callbacks:{title:()=>"",label(t){let e=t.label;const i=": "+t.formattedValue;return isArray(e)?(e=e.slice(),e[0]+=i):e+=i,e}}}}};class LineController extends DatasetController{initialize(){this.enableOptionSharing=!0,super.initialize()}update(t){const e=this,i=e._cachedMeta,{dataset:a,data:n=[],_dataset:o}=i,s=e.chart._animationsDisabled;let{start:r,count:l}=getStartAndCountOfVisiblePoints(i,n,s);e._drawStart=r,e._drawCount=l,scaleRangesChanged(i)&&(r=0,l=n.length),a._decimated=!!o._decimated,a.points=n;const c=e.resolveDatasetElementOptions(t);e.options.showLine||(c.borderWidth=0),c.segment=e.options.segment,e.updateElement(a,void 0,{animated:!s,options:c},t),e.updateElements(n,r,l,t)}updateElements(t,e,i,a){const n=this,o="reset"===a,{iScale:s,vScale:r,_stacked:l}=n._cachedMeta,c=n.resolveDataElementOptions(e,a),d=n.getSharedOptions(c),h=n.includeOptions(a,d),u=s.axis,g=r.axis,p=n.options.spanGaps,f=isNumber(p)?p:Number.POSITIVE_INFINITY,m=n.chart._animationsDisabled||o||"none"===a;let x=e>0&&n.getParsed(e-1);for(let c=e;c<e+i;++c){const e=t[c],i=n.getParsed(c),p=m?e:{},b=isNullOrUndef(i[g]),_=p[u]=s.getPixelForValue(i[u],c),y=p[g]=o||b?r.getBasePixel():r.getPixelForValue(l?n.applyStack(r,i,l):i[g],c);p.skip=isNaN(_)||isNaN(y)||b,p.stop=c>0&&i[u]-x[u]>f,p.parsed=i,h&&(p.options=d||n.resolveDataElementOptions(c,a)),m||n.updateElement(e,c,p,a),x=i}n.updateSharedOptions(d,a,c)}getMaxOverflow(){const t=this,e=t._cachedMeta,i=e.dataset,a=i.options&&i.options.borderWidth||0,n=e.data||[];if(!n.length)return a;const o=n[0].size(t.resolveDataElementOptions(0)),s=n[n.length-1].size(t.resolveDataElementOptions(n.length-1));return Math.max(a,o,s)/2}draw(){const t=this._cachedMeta;t.dataset.updateControlPoints(this.chart.chartArea,t.iScale.axis),super.draw()}}function getStartAndCountOfVisiblePoints(t,e,i){const a=e.length;let n=0,o=a;if(t._sorted){const{iScale:s,_parsed:r}=t,l=s.axis,{min:c,max:d,minDefined:h,maxDefined:u}=s.getUserBounds();h&&(n=_limitValue(Math.min(_lookupByKey(r,s.axis,c).lo,i?a:_lookupByKey(e,l,s.getPixelForValue(c)).lo),0,a-1)),o=u?_limitValue(Math.max(_lookupByKey(r,s.axis,d).hi+1,i?0:_lookupByKey(e,l,s.getPixelForValue(d)).hi+1),n,a)-n:a-n}return{start:n,count:o}}function scaleRangesChanged(t){const{xScale:e,yScale:i,_scaleRanges:a}=t,n={xmin:e.min,xmax:e.max,ymin:i.min,ymax:i.max};if(!a)return t._scaleRanges=n,!0;const o=a.xmin!==e.min||a.xmax!==e.max||a.ymin!==i.min||a.ymax!==i.max;return Object.assign(a,n),o}LineController.id="line",LineController.defaults={datasetElementType:"line",dataElementType:"point",showLine:!0,spanGaps:!1},LineController.overrides={scales:{_index_:{type:"category"},_value_:{type:"linear"}}};class PolarAreaController extends DatasetController{constructor(t,e){super(t,e),this.innerRadius=void 0,this.outerRadius=void 0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,a=i.data.labels||[],n=formatNumber(e._parsed[t].r,i.options.locale);return{label:a[t]||"",value:n}}update(t){const e=this._cachedMeta.data;this._updateRadius(),this.updateElements(e,0,e.length,t)}_updateRadius(){const t=this,e=t.chart,i=e.chartArea,a=e.options,n=Math.min(i.right-i.left,i.bottom-i.top),o=Math.max(n/2,0),s=(o-Math.max(a.cutoutPercentage?o/100*a.cutoutPercentage:1,0))/e.getVisibleDatasetCount();t.outerRadius=o-s*t.index,t.innerRadius=t.outerRadius-s}updateElements(t,e,i,a){const n=this,o="reset"===a,s=n.chart,r=n.getDataset(),l=s.options.animation,c=n._cachedMeta.rScale,d=c.xCenter,h=c.yCenter,u=c.getIndexAngle(0)-.5*PI;let g,p=u;const f=360/n.countVisibleElements();for(g=0;g<e;++g)p+=n._computeAngle(g,a,f);for(g=e;g<e+i;g++){const e=t[g];let i=p,m=p+n._computeAngle(g,a,f),x=s.getDataVisibility(g)?c.getDistanceFromCenterForValue(r.data[g]):0;p=m,o&&(l.animateScale&&(x=0),l.animateRotate&&(i=m=u));const b={x:d,y:h,innerRadius:0,outerRadius:x,startAngle:i,endAngle:m,options:n.resolveDataElementOptions(g,a)};n.updateElement(e,g,b,a)}}countVisibleElements(){const t=this.getDataset(),e=this._cachedMeta;let i=0;return e.data.forEach(((e,a)=>{!isNaN(t.data[a])&&this.chart.getDataVisibility(a)&&i++})),i}_computeAngle(t,e,i){return this.chart.getDataVisibility(t)?toRadians(this.resolveDataElementOptions(t,e).angle||i):0}}PolarAreaController.id="polarArea",PolarAreaController.defaults={dataElementType:"arc",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:"number",properties:["x","y","startAngle","endAngle","innerRadius","outerRadius"]}},indexAxis:"r",startAngle:0},PolarAreaController.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;return e.labels.length&&e.datasets.length?e.labels.map(((e,i)=>{const a=t.getDatasetMeta(0).controller.getStyle(i);return{text:e,fillStyle:a.backgroundColor,strokeStyle:a.borderColor,lineWidth:a.borderWidth,hidden:!t.getDataVisibility(i),index:i}})):[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}},tooltip:{callbacks:{title:()=>"",label:t=>t.chart.data.labels[t.dataIndex]+": "+t.formattedValue}}},scales:{r:{type:"radialLinear",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}};class PieController extends DoughnutController{}PieController.id="pie",PieController.defaults={cutout:0,rotation:0,circumference:360,radius:"100%"};class RadarController extends DatasetController{getLabelAndValue(t){const e=this._cachedMeta.vScale,i=this.getParsed(t);return{label:e.getLabels()[t],value:""+e.getLabelForValue(i[e.axis])}}update(t){const e=this,i=e._cachedMeta,a=i.dataset,n=i.data||[],o=i.iScale.getLabels();if(a.points=n,"resize"!==t){const i=e.resolveDatasetElementOptions(t);e.options.showLine||(i.borderWidth=0);const s={_loop:!0,_fullLoop:o.length===n.length,options:i};e.updateElement(a,void 0,s,t)}e.updateElements(n,0,n.length,t)}updateElements(t,e,i,a){const n=this,o=n.getDataset(),s=n._cachedMeta.rScale,r="reset"===a;for(let l=e;l<e+i;l++){const e=t[l],i=n.resolveDataElementOptions(l,a),c=s.getPointPositionForValue(l,o.data[l]),d=r?s.xCenter:c.x,h=r?s.yCenter:c.y,u={x:d,y:h,angle:c.angle,skip:isNaN(d)||isNaN(h),options:i};n.updateElement(e,l,u,a)}}}RadarController.id="radar",RadarController.defaults={datasetElementType:"line",dataElementType:"point",indexAxis:"r",showLine:!0,elements:{line:{fill:"start"}}},RadarController.overrides={aspectRatio:1,scales:{r:{type:"radialLinear"}}};class ScatterController extends LineController{}ScatterController.id="scatter",ScatterController.defaults={showLine:!1,fill:!1},ScatterController.overrides={interaction:{mode:"point"},plugins:{tooltip:{callbacks:{title:()=>"",label:t=>"("+t.label+", "+t.formattedValue+")"}}},scales:{x:{type:"linear"},y:{type:"linear"}}};var controllers=Object.freeze({__proto__:null,BarController:BarController,BubbleController:BubbleController,DoughnutController:DoughnutController,LineController:LineController,PolarAreaController:PolarAreaController,PieController:PieController,RadarController:RadarController,ScatterController:ScatterController});function abstract(){throw new Error("This method is not implemented: Check that a complete date adapter is provided.")}class DateAdapter{constructor(t){this.options=t||{}}formats(){return abstract()}parse(t,e){return abstract()}format(t,e){return abstract()}add(t,e,i){return abstract()}diff(t,e,i){return abstract()}startOf(t,e,i){return abstract()}endOf(t,e){return abstract()}}DateAdapter.override=function(t){Object.assign(DateAdapter.prototype,t)};var adapters={_date:DateAdapter};function getRelativePosition(t,e){return"native"in t?{x:t.x,y:t.y}:getRelativePosition$1(t,e)}function evaluateAllVisibleItems(t,e){const i=t.getSortedVisibleDatasetMetas();let a,n,o;for(let t=0,s=i.length;t<s;++t){({index:a,data:n}=i[t]);for(let t=0,i=n.length;t<i;++t)o=n[t],o.skip||e(o,a,t)}}function binarySearch(t,e,i,a){const{controller:n,data:o,_sorted:s}=t,r=n._cachedMeta.iScale;if(r&&e===r.axis&&s&&o.length){const t=r._reversePixels?_rlookupByKey:_lookupByKey;if(!a)return t(o,e,i);if(n._sharedOptions){const a=o[0],n="function"==typeof a.getRange&&a.getRange(e);if(n){const a=t(o,e,i-n),s=t(o,e,i+n);return{lo:a.lo,hi:s.hi}}}}return{lo:0,hi:o.length-1}}function optimizedEvaluateItems(t,e,i,a,n){const o=t.getSortedVisibleDatasetMetas(),s=i[e];for(let t=0,i=o.length;t<i;++t){const{index:i,data:r}=o[t],{lo:l,hi:c}=binarySearch(o[t],e,s,n);for(let t=l;t<=c;++t){const e=r[t];e.skip||a(e,i,t)}}}function getDistanceMetricForAxis(t){const e=-1!==t.indexOf("x"),i=-1!==t.indexOf("y");return function(t,a){const n=e?Math.abs(t.x-a.x):0,o=i?Math.abs(t.y-a.y):0;return Math.sqrt(Math.pow(n,2)+Math.pow(o,2))}}function getIntersectItems(t,e,i,a){const n=[];if(!_isPointInArea(e,t.chartArea,t._minPadding))return n;return optimizedEvaluateItems(t,i,e,(function(t,i,o){t.inRange(e.x,e.y,a)&&n.push({element:t,datasetIndex:i,index:o})}),!0),n}function getNearestItems(t,e,i,a,n){const o=getDistanceMetricForAxis(i);let s=Number.POSITIVE_INFINITY,r=[];if(!_isPointInArea(e,t.chartArea,t._minPadding))return r;return optimizedEvaluateItems(t,i,e,(function(i,l,c){if(a&&!i.inRange(e.x,e.y,n))return;const d=i.getCenterPoint(n);if(!_isPointInArea(d,t.chartArea,t._minPadding))return;const h=o(e,d);h<s?(r=[{element:i,datasetIndex:l,index:c}],s=h):h===s&&r.push({element:i,datasetIndex:l,index:c})})),r}function getAxisItems(t,e,i,a){const n=getRelativePosition(e,t),o=[],s=i.axis,r="x"===s?"inXRange":"inYRange";let l=!1;return evaluateAllVisibleItems(t,((t,e,i)=>{t[r](n[s],a)&&o.push({element:t,datasetIndex:e,index:i}),t.inRange(n.x,n.y,a)&&(l=!0)})),i.intersect&&!l?[]:o}var Interaction={modes:{index(t,e,i,a){const n=getRelativePosition(e,t),o=i.axis||"x",s=i.intersect?getIntersectItems(t,n,o,a):getNearestItems(t,n,o,!1,a),r=[];return s.length?(t.getSortedVisibleDatasetMetas().forEach((t=>{const e=s[0].index,i=t.data[e];i&&!i.skip&&r.push({element:i,datasetIndex:t.index,index:e})})),r):[]},dataset(t,e,i,a){const n=getRelativePosition(e,t),o=i.axis||"xy";let s=i.intersect?getIntersectItems(t,n,o,a):getNearestItems(t,n,o,!1,a);if(s.length>0){const e=s[0].datasetIndex,i=t.getDatasetMeta(e).data;s=[];for(let t=0;t<i.length;++t)s.push({element:i[t],datasetIndex:e,index:t})}return s},point:(t,e,i,a)=>getIntersectItems(t,getRelativePosition(e,t),i.axis||"xy",a),nearest:(t,e,i,a)=>getNearestItems(t,getRelativePosition(e,t),i.axis||"xy",i.intersect,a),x:(t,e,i,a)=>(i.axis="x",getAxisItems(t,e,i,a)),y:(t,e,i,a)=>(i.axis="y",getAxisItems(t,e,i,a))}};const STATIC_POSITIONS=["left","top","right","bottom"];function filterByPosition(t,e){return t.filter((t=>t.pos===e))}function filterDynamicPositionByAxis(t,e){return t.filter((t=>-1===STATIC_POSITIONS.indexOf(t.pos)&&t.box.axis===e))}function sortByWeight(t,e){return t.sort(((t,i)=>{const a=e?i:t,n=e?t:i;return a.weight===n.weight?a.index-n.index:a.weight-n.weight}))}function wrapBoxes(t){const e=[];let i,a,n;for(i=0,a=(t||[]).length;i<a;++i)n=t[i],e.push({index:i,box:n,pos:n.position,horizontal:n.isHorizontal(),weight:n.weight});return e}function setLayoutDims(t,e){let i,a,n;for(i=0,a=t.length;i<a;++i)n=t[i],n.horizontal?(n.width=n.box.fullSize&&e.availableWidth,n.height=e.hBoxMaxHeight):(n.width=e.vBoxMaxWidth,n.height=n.box.fullSize&&e.availableHeight)}function buildLayoutBoxes(t){const e=wrapBoxes(t),i=sortByWeight(e.filter((t=>t.box.fullSize)),!0),a=sortByWeight(filterByPosition(e,"left"),!0),n=sortByWeight(filterByPosition(e,"right")),o=sortByWeight(filterByPosition(e,"top"),!0),s=sortByWeight(filterByPosition(e,"bottom")),r=filterDynamicPositionByAxis(e,"x"),l=filterDynamicPositionByAxis(e,"y");return{fullSize:i,leftAndTop:a.concat(o),rightAndBottom:n.concat(l).concat(s).concat(r),chartArea:filterByPosition(e,"chartArea"),vertical:a.concat(n).concat(l),horizontal:o.concat(s).concat(r)}}function getCombinedMax(t,e,i,a){return Math.max(t[i],e[i])+Math.max(t[a],e[a])}function updateMaxPadding(t,e){t.top=Math.max(t.top,e.top),t.left=Math.max(t.left,e.left),t.bottom=Math.max(t.bottom,e.bottom),t.right=Math.max(t.right,e.right)}function updateDims(t,e,i){const a=i.box,n=t.maxPadding;isObject(i.pos)||(i.size&&(t[i.pos]-=i.size),i.size=i.horizontal?a.height:a.width,t[i.pos]+=i.size),a.getPadding&&updateMaxPadding(n,a.getPadding());const o=Math.max(0,e.outerWidth-getCombinedMax(n,t,"left","right")),s=Math.max(0,e.outerHeight-getCombinedMax(n,t,"top","bottom")),r=o!==t.w,l=s!==t.h;return t.w=o,t.h=s,i.horizontal?{same:r,other:l}:{same:l,other:r}}function handleMaxPadding(t){const e=t.maxPadding;function i(i){const a=Math.max(e[i]-t[i],0);return t[i]+=a,a}t.y+=i("top"),t.x+=i("left"),i("right"),i("bottom")}function getMargins(t,e){const i=e.maxPadding;function a(t){const a={left:0,top:0,right:0,bottom:0};return t.forEach((t=>{a[t]=Math.max(e[t],i[t])})),a}return a(t?["left","right"]:["top","bottom"])}function fitBoxes(t,e,i){const a=[];let n,o,s,r,l,c;for(n=0,o=t.length,l=0;n<o;++n){s=t[n],r=s.box,r.update(s.width||e.w,s.height||e.h,getMargins(s.horizontal,e));const{same:o,other:d}=updateDims(e,i,s);l|=o&&a.length,c=c||d,r.fullSize||a.push(s)}return l&&fitBoxes(a,e,i)||c}function placeBoxes(t,e,i){const a=i.padding;let n,o,s,r,l=e.x,c=e.y;for(n=0,o=t.length;n<o;++n)s=t[n],r=s.box,s.horizontal?(r.left=r.fullSize?a.left:e.left,r.right=r.fullSize?i.outerWidth-a.right:e.left+e.w,r.top=c,r.bottom=c+r.height,r.width=r.right-r.left,c=r.bottom):(r.left=l,r.right=l+r.width,r.top=r.fullSize?a.top:e.top,r.bottom=r.fullSize?i.outerHeight-a.right:e.top+e.h,r.height=r.bottom-r.top,l=r.right);e.x=l,e.y=c}defaults.set("layout",{padding:{top:0,right:0,bottom:0,left:0}});var layouts={addBox(t,e){t.boxes||(t.boxes=[]),e.fullSize=e.fullSize||!1,e.position=e.position||"top",e.weight=e.weight||0,e._layers=e._layers||function(){return[{z:0,draw(t){e.draw(t)}}]},t.boxes.push(e)},removeBox(t,e){const i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1)},configure(t,e,i){e.fullSize=i.fullSize,e.position=i.position,e.weight=i.weight},update(t,e,i,a){if(!t)return;const n=toPadding(t.options.layout.padding),o=Math.max(e-n.width,0),s=Math.max(i-n.height,0),r=buildLayoutBoxes(t.boxes),l=r.vertical,c=r.horizontal;each(t.boxes,(t=>{"function"==typeof t.beforeLayout&&t.beforeLayout()}));const d=l.reduce(((t,e)=>e.box.options&&!1===e.box.options.display?t:t+1),0)||1,h=Object.freeze({outerWidth:e,outerHeight:i,padding:n,availableWidth:o,availableHeight:s,vBoxMaxWidth:o/2/d,hBoxMaxHeight:s/2}),u=Object.assign({},n);updateMaxPadding(u,toPadding(a));const g=Object.assign({maxPadding:u,w:o,h:s,x:n.left,y:n.top},n);setLayoutDims(l.concat(c),h),fitBoxes(r.fullSize,g,h),fitBoxes(l,g,h),fitBoxes(c,g,h)&&fitBoxes(l,g,h),handleMaxPadding(g),placeBoxes(r.leftAndTop,g,h),g.x+=g.w,g.y+=g.h,placeBoxes(r.rightAndBottom,g,h),t.chartArea={left:g.left,top:g.top,right:g.left+g.w,bottom:g.top+g.h,height:g.h,width:g.w},each(r.chartArea,(e=>{const i=e.box;Object.assign(i,t.chartArea),i.update(g.w,g.h)}))}};class BasePlatform{acquireContext(t,e){}releaseContext(t){return!1}addEventListener(t,e,i){}removeEventListener(t,e,i){}getDevicePixelRatio(){return 1}getMaximumSize(t,e,i,a){return e=Math.max(0,e||t.width),i=i||t.height,{width:e,height:Math.max(0,a?Math.floor(e/a):i)}}isAttached(t){return!0}}class BasicPlatform extends BasePlatform{acquireContext(t){return t&&t.getContext&&t.getContext("2d")||null}}const EXPANDO_KEY="$chartjs",EVENT_TYPES={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"},isNullOrEmpty=t=>null===t||""===t;function initCanvas(t,e){const i=t.style,a=t.getAttribute("height"),n=t.getAttribute("width");if(t.$chartjs={initial:{height:a,width:n,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||"block",i.boxSizing=i.boxSizing||"border-box",isNullOrEmpty(n)){const e=readUsedSize(t,"width");void 0!==e&&(t.width=e)}if(isNullOrEmpty(a))if(""===t.style.height)t.height=t.width/(e||2);else{const e=readUsedSize(t,"height");void 0!==e&&(t.height=e)}return t}const eventListenerOptions=!!supportsEventListenerOptions&&{passive:!0};function addListener(t,e,i){t.addEventListener(e,i,eventListenerOptions)}function removeListener(t,e,i){t.canvas.removeEventListener(e,i,eventListenerOptions)}function fromNativeEvent(t,e){const i=EVENT_TYPES[t.type]||t.type,{x:a,y:n}=getRelativePosition$1(t,e);return{type:i,chart:e,native:t,x:void 0!==a?a:null,y:void 0!==n?n:null}}function createAttachObserver(t,e,i){const a=t.canvas,n=a&&_getParentNode(a)||a,o=new MutationObserver((t=>{const e=_getParentNode(n);t.forEach((t=>{for(let a=0;a<t.addedNodes.length;a++){const o=t.addedNodes[a];o!==n&&o!==e||i(t.target)}}))}));return o.observe(document,{childList:!0,subtree:!0}),o}function createDetachObserver(t,e,i){const a=t.canvas,n=a&&_getParentNode(a);if(!n)return;const o=new MutationObserver((t=>{t.forEach((t=>{for(let e=0;e<t.removedNodes.length;e++)if(t.removedNodes[e]===a){i();break}}))}));return o.observe(n,{childList:!0}),o}const drpListeningCharts=new Map;let oldDevicePixelRatio=0;function onWindowResize(){const t=window.devicePixelRatio;t!==oldDevicePixelRatio&&(oldDevicePixelRatio=t,drpListeningCharts.forEach(((e,i)=>{i.currentDevicePixelRatio!==t&&e()})))}function listenDevicePixelRatioChanges(t,e){drpListeningCharts.size||window.addEventListener("resize",onWindowResize),drpListeningCharts.set(t,e)}function unlistenDevicePixelRatioChanges(t){drpListeningCharts.delete(t),drpListeningCharts.size||window.removeEventListener("resize",onWindowResize)}function createResizeObserver(t,e,i){const a=t.canvas,n=a&&_getParentNode(a);if(!n)return;const o=throttled(((t,e)=>{const a=n.clientWidth;i(t,e),a<n.clientWidth&&i()}),window),s=new ResizeObserver((t=>{const e=t[0],i=e.contentRect.width,a=e.contentRect.height;0===i&&0===a||o(i,a)}));return s.observe(n),listenDevicePixelRatioChanges(t,o),s}function releaseObserver(t,e,i){i&&i.disconnect(),"resize"===e&&unlistenDevicePixelRatioChanges(t)}function createProxyAndListen(t,e,i){const a=t.canvas,n=throttled((e=>{null!==t.ctx&&i(fromNativeEvent(e,t))}),t,(t=>{const e=t[0];return[e,e.offsetX,e.offsetY]}));return addListener(a,e,n),n}class DomPlatform extends BasePlatform{acquireContext(t,e){const i=t&&t.getContext&&t.getContext("2d");return i&&i.canvas===t?(initCanvas(t,e),i):null}releaseContext(t){const e=t.canvas;if(!e.$chartjs)return!1;const i=e.$chartjs.initial;["height","width"].forEach((t=>{const a=i[t];isNullOrUndef(a)?e.removeAttribute(t):e.setAttribute(t,a)}));const a=i.style||{};return Object.keys(a).forEach((t=>{e.style[t]=a[t]})),e.width=e.width,delete e.$chartjs,!0}addEventListener(t,e,i){this.removeEventListener(t,e);const a=t.$proxies||(t.$proxies={}),n={attach:createAttachObserver,detach:createDetachObserver,resize:createResizeObserver}[e]||createProxyAndListen;a[e]=n(t,e,i)}removeEventListener(t,e){const i=t.$proxies||(t.$proxies={}),a=i[e];if(!a)return;({attach:releaseObserver,detach:releaseObserver,resize:releaseObserver}[e]||removeListener)(t,e,a),i[e]=void 0}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(t,e,i,a){return getMaximumSize(t,e,i,a)}isAttached(t){const e=_getParentNode(t);return!(!e||!_getParentNode(e))}}class Element{constructor(){this.x=void 0,this.y=void 0,this.active=!1,this.options=void 0,this.$animations=void 0}tooltipPosition(t){const{x:e,y:i}=this.getProps(["x","y"],t);return{x:e,y:i}}hasValue(){return isNumber(this.x)&&isNumber(this.y)}getProps(t,e){const i=this,a=this.$animations;if(!e||!a)return i;const n={};return t.forEach((t=>{n[t]=a[t]&&a[t].active()?a[t]._to:i[t]})),n}}Element.defaults={},Element.defaultRoutes=void 0;const formatters={values:t=>isArray(t)?t:""+t,numeric(t,e,i){if(0===t)return"0";const a=this.chart.options.locale;let n,o=t;if(i.length>1){const e=Math.max(Math.abs(i[0].value),Math.abs(i[i.length-1].value));(e<1e-4||e>1e15)&&(n="scientific"),o=calculateDelta(t,i)}const s=log10(Math.abs(o)),r=Math.max(Math.min(-1*Math.floor(s),20),0),l={notation:n,minimumFractionDigits:r,maximumFractionDigits:r};return Object.assign(l,this.options.ticks.format),formatNumber(t,a,l)},logarithmic(t,e,i){if(0===t)return"0";const a=t/Math.pow(10,Math.floor(log10(t)));return 1===a||2===a||5===a?formatters.numeric.call(this,t,e,i):""}};function calculateDelta(t,e){let i=e.length>3?e[2].value-e[1].value:e[1].value-e[0].value;return Math.abs(i)>=1&&t!==Math.floor(t)&&(i=t-Math.floor(t)),i}var Ticks={formatters:formatters};function autoSkip(t,e){const i=t.options.ticks,a=i.maxTicksLimit||determineMaxTicks(t),n=i.major.enabled?getMajorIndices(e):[],o=n.length,s=n[0],r=n[o-1],l=[];if(o>a)return skipMajors(e,l,n,o/a),l;const c=calculateSpacing(n,e,a);if(o>0){let t,i;const a=o>1?Math.round((r-s)/(o-1)):null;for(skip(e,l,c,isNullOrUndef(a)?0:s-a,s),t=0,i=o-1;t<i;t++)skip(e,l,c,n[t],n[t+1]);return skip(e,l,c,r,isNullOrUndef(a)?e.length:r+a),l}return skip(e,l,c),l}function determineMaxTicks(t){const e=t.options.offset,i=t._tickSize(),a=t._length/i+(e?0:1),n=t._maxLength/i;return Math.floor(Math.min(a,n))}function calculateSpacing(t,e,i){const a=getEvenSpacing(t),n=e.length/i;if(!a)return Math.max(n,1);const o=_factorize(a);for(let t=0,e=o.length-1;t<e;t++){const e=o[t];if(e>n)return e}return Math.max(n,1)}function getMajorIndices(t){const e=[];let i,a;for(i=0,a=t.length;i<a;i++)t[i].major&&e.push(i);return e}function skipMajors(t,e,i,a){let n,o=0,s=i[0];for(a=Math.ceil(a),n=0;n<t.length;n++)n===s&&(e.push(t[n]),o++,s=i[o*a])}function skip(t,e,i,a,n){const o=valueOrDefault(a,0),s=Math.min(valueOrDefault(n,t.length),t.length);let r,l,c,d=0;for(i=Math.ceil(i),n&&(r=n-a,i=r/Math.floor(r/i)),c=o;c<0;)d++,c=Math.round(o+d*i);for(l=Math.max(o,0);l<s;l++)l===c&&(e.push(t[l]),d++,c=Math.round(o+d*i))}function getEvenSpacing(t){const e=t.length;let i,a;if(e<2)return!1;for(a=t[0],i=1;i<e;++i)if(t[i]-t[i-1]!==a)return!1;return a}defaults.set("scale",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:"ticks",grace:0,grid:{display:!0,lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(t,e)=>e.lineWidth,tickColor:(t,e)=>e.color,offset:!1,borderDash:[],borderDashOffset:0,borderWidth:1},title:{display:!1,text:"",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:"",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:Ticks.formatters.values,minor:{},major:{},align:"center",crossAlign:"near",showLabelBackdrop:!1,backdropColor:"rgba(255, 255, 255, 0.75)",backdropPadding:2}}),defaults.route("scale.ticks","color","","color"),defaults.route("scale.grid","color","","borderColor"),defaults.route("scale.grid","borderColor","","borderColor"),defaults.route("scale.title","color","","color"),defaults.describe("scale",{_fallback:!1,_scriptable:t=>!t.startsWith("before")&&!t.startsWith("after")&&"callback"!==t&&"parser"!==t,_indexable:t=>"borderDash"!==t&&"tickBorderDash"!==t}),defaults.describe("scales",{_fallback:"scale"});const reverseAlign=t=>"left"===t?"right":"right"===t?"left":t,offsetFromEdge=(t,e,i)=>"top"===e||"left"===e?t[e]+i:t[e]-i;function sample(t,e){const i=[],a=t.length/e,n=t.length;let o=0;for(;o<n;o+=a)i.push(t[Math.floor(o)]);return i}function getPixelForGridLine(t,e,i){const a=t.ticks.length,n=Math.min(e,a-1),o=t._startPixel,s=t._endPixel,r=1e-6;let l,c=t.getPixelForTick(n);if(!(i&&(l=1===a?Math.max(c-o,s-c):0===e?(t.getPixelForTick(1)-c)/2:(c-t.getPixelForTick(n-1))/2,c+=n<e?l:-l,c<o-r||c>s+r)))return c}function garbageCollect(t,e){each(t,(t=>{const i=t.gc,a=i.length/2;let n;if(a>e){for(n=0;n<a;++n)delete t.data[i[n]];i.splice(0,a)}}))}function getTickMarkLength(t){return t.drawTicks?t.tickLength:0}function getTitleHeight(t,e){if(!t.display)return 0;const i=toFont(t.font,e),a=toPadding(t.padding);return(isArray(t.text)?t.text.length:1)*i.lineHeight+a.height}function createScaleContext(t,e){return Object.assign(Object.create(t),{scale:e,type:"scale"})}function createTickContext(t,e,i){return Object.assign(Object.create(t),{tick:i,index:e,type:"tick"})}function titleAlign(t,e,i){let a=_toLeftRightCenter(t);return(i&&"right"!==e||!i&&"right"===e)&&(a=reverseAlign(a)),a}function titleArgs(t,e,i,a){const{top:n,left:o,bottom:s,right:r}=t;let l,c,d,h=0;return t.isHorizontal()?(c=_alignStartEnd(a,o,r),d=offsetFromEdge(t,i,e),l=r-o):(c=offsetFromEdge(t,i,e),d=_alignStartEnd(a,s,n),h="left"===i?-HALF_PI:HALF_PI),{titleX:c,titleY:d,maxWidth:l,rotation:h}}class Scale extends Element{constructor(t){super(),this.id=t.id,this.type=t.type,this.options=void 0,this.ctx=t.ctx,this.chart=t.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0}init(t){const e=this;e.options=t.setContext(e.getContext()),e.axis=t.axis,e._userMin=e.parse(t.min),e._userMax=e.parse(t.max),e._suggestedMin=e.parse(t.suggestedMin),e._suggestedMax=e.parse(t.suggestedMax)}parse(t,e){return t}getUserBounds(){let{_userMin:t,_userMax:e,_suggestedMin:i,_suggestedMax:a}=this;return t=finiteOrDefault(t,Number.POSITIVE_INFINITY),e=finiteOrDefault(e,Number.NEGATIVE_INFINITY),i=finiteOrDefault(i,Number.POSITIVE_INFINITY),a=finiteOrDefault(a,Number.NEGATIVE_INFINITY),{min:finiteOrDefault(t,i),max:finiteOrDefault(e,a),minDefined:isNumberFinite(t),maxDefined:isNumberFinite(e)}}getMinMax(t){const e=this;let i,{min:a,max:n,minDefined:o,maxDefined:s}=e.getUserBounds();if(o&&s)return{min:a,max:n};const r=e.getMatchingVisibleMetas();for(let l=0,c=r.length;l<c;++l)i=r[l].controller.getMinMax(e,t),o||(a=Math.min(a,i.min)),s||(n=Math.max(n,i.max));return{min:finiteOrDefault(a,finiteOrDefault(n,a)),max:finiteOrDefault(n,finiteOrDefault(a,n))}}getPadding(){const t=this;return{left:t.paddingLeft||0,top:t.paddingTop||0,right:t.paddingRight||0,bottom:t.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]}beforeLayout(){this._cache={},this._dataLimitsCached=!1}beforeUpdate(){callback(this.options.beforeUpdate,[this])}update(t,e,i){const a=this,n=a.options.ticks,o=n.sampleSize;a.beforeUpdate(),a.maxWidth=t,a.maxHeight=e,a._margins=i=Object.assign({left:0,right:0,top:0,bottom:0},i),a.ticks=null,a._labelSizes=null,a._gridLineItems=null,a._labelItems=null,a.beforeSetDimensions(),a.setDimensions(),a.afterSetDimensions(),a._maxLength=a.isHorizontal()?a.width+i.left+i.right:a.height+i.top+i.bottom,a._dataLimitsCached||(a.beforeDataLimits(),a.determineDataLimits(),a.afterDataLimits(),a._range=_addGrace(a,a.options.grace),a._dataLimitsCached=!0),a.beforeBuildTicks(),a.ticks=a.buildTicks()||[],a.afterBuildTicks();const s=o<a.ticks.length;a._convertTicksToLabels(s?sample(a.ticks,o):a.ticks),a.configure(),a.beforeCalculateLabelRotation(),a.calculateLabelRotation(),a.afterCalculateLabelRotation(),n.display&&(n.autoSkip||"auto"===n.source)&&(a.ticks=autoSkip(a,a.ticks),a._labelSizes=null),s&&a._convertTicksToLabels(a.ticks),a.beforeFit(),a.fit(),a.afterFit(),a.afterUpdate()}configure(){const t=this;let e,i,a=t.options.reverse;t.isHorizontal()?(e=t.left,i=t.right):(e=t.top,i=t.bottom,a=!a),t._startPixel=e,t._endPixel=i,t._reversePixels=a,t._length=i-e,t._alignToPixels=t.options.alignToPixels}afterUpdate(){callback(this.options.afterUpdate,[this])}beforeSetDimensions(){callback(this.options.beforeSetDimensions,[this])}setDimensions(){const t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0}afterSetDimensions(){callback(this.options.afterSetDimensions,[this])}_callHooks(t){const e=this;e.chart.notifyPlugins(t,e.getContext()),callback(e.options[t],[e])}beforeDataLimits(){this._callHooks("beforeDataLimits")}determineDataLimits(){}afterDataLimits(){this._callHooks("afterDataLimits")}beforeBuildTicks(){this._callHooks("beforeBuildTicks")}buildTicks(){return[]}afterBuildTicks(){this._callHooks("afterBuildTicks")}beforeTickToLabelConversion(){callback(this.options.beforeTickToLabelConversion,[this])}generateTickLabels(t){const e=this,i=e.options.ticks;let a,n,o;for(a=0,n=t.length;a<n;a++)o=t[a],o.label=callback(i.callback,[o.value,a,t],e);for(a=0;a<n;a++)isNullOrUndef(t[a].label)&&(t.splice(a,1),n--,a--)}afterTickToLabelConversion(){callback(this.options.afterTickToLabelConversion,[this])}beforeCalculateLabelRotation(){callback(this.options.beforeCalculateLabelRotation,[this])}calculateLabelRotation(){const t=this,e=t.options,i=e.ticks,a=t.ticks.length,n=i.minRotation||0,o=i.maxRotation;let s,r,l,c=n;if(!t._isVisible()||!i.display||n>=o||a<=1||!t.isHorizontal())return void(t.labelRotation=n);const d=t._getLabelSizes(),h=d.widest.width,u=d.highest.height,g=_limitValue(t.chart.width-h,0,t.maxWidth);s=e.offset?t.maxWidth/a:g/(a-1),h+6>s&&(s=g/(a-(e.offset?.5:1)),r=t.maxHeight-getTickMarkLength(e.grid)-i.padding-getTitleHeight(e.title,t.chart.options.font),l=Math.sqrt(h*h+u*u),c=toDegrees(Math.min(Math.asin(Math.min((d.highest.height+6)/s,1)),Math.asin(Math.min(r/l,1))-Math.asin(u/l))),c=Math.max(n,Math.min(o,c))),t.labelRotation=c}afterCalculateLabelRotation(){callback(this.options.afterCalculateLabelRotation,[this])}beforeFit(){callback(this.options.beforeFit,[this])}fit(){const t=this,e={width:0,height:0},{chart:i,options:{ticks:a,title:n,grid:o}}=t,s=t._isVisible(),r=t.isHorizontal();if(s){const s=getTitleHeight(n,i.options.font);if(r?(e.width=t.maxWidth,e.height=getTickMarkLength(o)+s):(e.height=t.maxHeight,e.width=getTickMarkLength(o)+s),a.display&&t.ticks.length){const{first:i,last:n,widest:o,highest:s}=t._getLabelSizes(),l=2*a.padding,c=toRadians(t.labelRotation),d=Math.cos(c),h=Math.sin(c);if(r){const i=a.mirror?0:h*o.width+d*s.height;e.height=Math.min(t.maxHeight,e.height+i+l)}else{const i=a.mirror?0:d*o.width+h*s.height;e.width=Math.min(t.maxWidth,e.width+i+l)}t._calculatePadding(i,n,h,d)}}t._handleMargins(),r?(t.width=t._length=i.width-t._margins.left-t._margins.right,t.height=e.height):(t.width=e.width,t.height=t._length=i.height-t._margins.top-t._margins.bottom)}_calculatePadding(t,e,i,a){const n=this,{ticks:{align:o,padding:s},position:r}=n.options,l=0!==n.labelRotation,c="top"!==r&&"x"===n.axis;if(n.isHorizontal()){const r=n.getPixelForTick(0)-n.left,d=n.right-n.getPixelForTick(n.ticks.length-1);let h=0,u=0;l?c?(h=a*t.width,u=i*e.height):(h=i*t.height,u=a*e.width):"start"===o?u=e.width:"end"===o?h=t.width:(h=t.width/2,u=e.width/2),n.paddingLeft=Math.max((h-r+s)*n.width/(n.width-r),0),n.paddingRight=Math.max((u-d+s)*n.width/(n.width-d),0)}else{let i=e.height/2,a=t.height/2;"start"===o?(i=0,a=t.height):"end"===o&&(i=e.height,a=0),n.paddingTop=i+s,n.paddingBottom=a+s}}_handleMargins(){const t=this;t._margins&&(t._margins.left=Math.max(t.paddingLeft,t._margins.left),t._margins.top=Math.max(t.paddingTop,t._margins.top),t._margins.right=Math.max(t.paddingRight,t._margins.right),t._margins.bottom=Math.max(t.paddingBottom,t._margins.bottom))}afterFit(){callback(this.options.afterFit,[this])}isHorizontal(){const{axis:t,position:e}=this.options;return"top"===e||"bottom"===e||"x"===t}isFullSize(){return this.options.fullSize}_convertTicksToLabels(t){const e=this;e.beforeTickToLabelConversion(),e.generateTickLabels(t),e.afterTickToLabelConversion()}_getLabelSizes(){const t=this;let e=t._labelSizes;if(!e){const i=t.options.ticks.sampleSize;let a=t.ticks;i<a.length&&(a=sample(a,i)),t._labelSizes=e=t._computeLabelSizes(a,a.length)}return e}_computeLabelSizes(t,e){const{ctx:i,_longestTextCache:a}=this,n=[],o=[];let s,r,l,c,d,h,u,g,p,f,m,x=0,b=0;for(s=0;s<e;++s){if(c=t[s].label,d=this._resolveTickFontOptions(s),i.font=h=d.string,u=a[h]=a[h]||{data:{},gc:[]},g=d.lineHeight,p=f=0,isNullOrUndef(c)||isArray(c)){if(isArray(c))for(r=0,l=c.length;r<l;++r)m=c[r],isNullOrUndef(m)||isArray(m)||(p=_measureText(i,u.data,u.gc,p,m),f+=g)}else p=_measureText(i,u.data,u.gc,p,c),f=g;n.push(p),o.push(f),x=Math.max(p,x),b=Math.max(f,b)}garbageCollect(a,e);const _=n.indexOf(x),y=o.indexOf(b),v=t=>({width:n[t]||0,height:o[t]||0});return{first:v(0),last:v(e-1),widest:v(_),highest:v(y),widths:n,heights:o}}getLabelForValue(t){return t}getPixelForValue(t,e){return NaN}getValueForPixel(t){}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getPixelForDecimal(t){const e=this;e._reversePixels&&(t=1-t);const i=e._startPixel+t*e._length;return _int16Range(e._alignToPixels?_alignPixel(e.chart,i,0):i)}getDecimalForPixel(t){const e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:t,max:e}=this;return t<0&&e<0?e:t>0&&e>0?t:0}getContext(t){const e=this,i=e.ticks||[];if(t>=0&&t<i.length){const a=i[t];return a.$context||(a.$context=createTickContext(e.getContext(),t,a))}return e.$context||(e.$context=createScaleContext(e.chart.getContext(),e))}_tickSize(){const t=this,e=t.options.ticks,i=toRadians(t.labelRotation),a=Math.abs(Math.cos(i)),n=Math.abs(Math.sin(i)),o=t._getLabelSizes(),s=e.autoSkipPadding||0,r=o?o.widest.width+s:0,l=o?o.highest.height+s:0;return t.isHorizontal()?l*a>r*n?r/a:l/n:l*n<r*a?l/a:r/n}_isVisible(){const t=this.options.display;return"auto"!==t?!!t:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(t){const e=this,i=e.axis,a=e.chart,n=e.options,{grid:o,position:s}=n,r=o.offset,l=e.isHorizontal(),c=e.ticks.length+(r?1:0),d=getTickMarkLength(o),h=[],u=o.setContext(e.getContext()),g=u.drawBorder?u.borderWidth:0,p=g/2,f=function(t){return _alignPixel(a,t,g)};let m,x,b,_,y,v,S,k,M,D,w,P;if("top"===s)m=f(e.bottom),v=e.bottom-d,k=m-p,D=f(t.top)+p,P=t.bottom;else if("bottom"===s)m=f(e.top),D=t.top,P=f(t.bottom)-p,v=m+p,k=e.top+d;else if("left"===s)m=f(e.right),y=e.right-d,S=m-p,M=f(t.left)+p,w=t.right;else if("right"===s)m=f(e.left),M=t.left,w=f(t.right)-p,y=m+p,S=e.left+d;else if("x"===i){if("center"===s)m=f((t.top+t.bottom)/2+.5);else if(isObject(s)){const t=Object.keys(s)[0],i=s[t];m=f(e.chart.scales[t].getPixelForValue(i))}D=t.top,P=t.bottom,v=m+p,k=v+d}else if("y"===i){if("center"===s)m=f((t.left+t.right)/2);else if(isObject(s)){const t=Object.keys(s)[0],i=s[t];m=f(e.chart.scales[t].getPixelForValue(i))}y=m-p,S=y-d,M=t.left,w=t.right}for(x=0;x<c;++x){const t=o.setContext(e.getContext(x)),i=t.lineWidth,n=t.color,s=o.borderDash||[],c=t.borderDashOffset,d=t.tickWidth,u=t.tickColor,g=t.tickBorderDash||[],p=t.tickBorderDashOffset;b=getPixelForGridLine(e,x,r),void 0!==b&&(_=_alignPixel(a,b,i),l?y=S=M=w=_:v=k=D=P=_,h.push({tx1:y,ty1:v,tx2:S,ty2:k,x1:M,y1:D,x2:w,y2:P,width:i,color:n,borderDash:s,borderDashOffset:c,tickWidth:d,tickColor:u,tickBorderDash:g,tickBorderDashOffset:p}))}return e._ticksLength=c,e._borderValue=m,h}_computeLabelItems(t){const e=this,i=e.axis,a=e.options,{position:n,ticks:o}=a,s=e.isHorizontal(),r=e.ticks,{align:l,crossAlign:c,padding:d,mirror:h}=o,u=getTickMarkLength(a.grid),g=u+d,p=h?-d:g,f=-toRadians(e.labelRotation),m=[];let x,b,_,y,v,S,k,M,D,w,P,A,C="middle";if("top"===n)S=e.bottom-p,k=e._getXAxisLabelAlignment();else if("bottom"===n)S=e.top+p,k=e._getXAxisLabelAlignment();else if("left"===n){const t=e._getYAxisLabelAlignment(u);k=t.textAlign,v=t.x}else if("right"===n){const t=e._getYAxisLabelAlignment(u);k=t.textAlign,v=t.x}else if("x"===i){if("center"===n)S=(t.top+t.bottom)/2+g;else if(isObject(n)){const t=Object.keys(n)[0],i=n[t];S=e.chart.scales[t].getPixelForValue(i)+g}k=e._getXAxisLabelAlignment()}else if("y"===i){if("center"===n)v=(t.left+t.right)/2-g;else if(isObject(n)){const t=Object.keys(n)[0],i=n[t];v=e.chart.scales[t].getPixelForValue(i)}k=e._getYAxisLabelAlignment(u).textAlign}"y"===i&&("start"===l?C="top":"end"===l&&(C="bottom"));const O=e._getLabelSizes();for(x=0,b=r.length;x<b;++x){_=r[x],y=_.label;const t=o.setContext(e.getContext(x));M=e.getPixelForTick(x)+o.labelOffset,D=e._resolveTickFontOptions(x),w=D.lineHeight,P=isArray(y)?y.length:1;const i=P/2,a=t.color,l=t.textStrokeColor,d=t.textStrokeWidth;let u;if(s?(v=M,A="top"===n?"near"===c||0!==f?-P*w+w/2:"center"===c?-O.highest.height/2-i*w+w:-O.highest.height+w/2:"near"===c||0!==f?w/2:"center"===c?O.highest.height/2-i*w:O.highest.height-P*w,h&&(A*=-1)):(S=M,A=(1-P)*w/2),t.showLabelBackdrop){const e=toPadding(t.backdropPadding),i=O.heights[x],a=O.widths[x];let n=S+A-e.top,o=v-e.left;switch(C){case"middle":n-=i/2;break;case"bottom":n-=i}switch(k){case"center":o-=a/2;break;case"right":o-=a}u={left:o,top:n,width:a+e.width,height:i+e.height,color:t.backdropColor}}m.push({rotation:f,label:y,font:D,color:a,strokeColor:l,strokeWidth:d,textOffset:A,textAlign:k,textBaseline:C,translation:[v,S],backdrop:u})}return m}_getXAxisLabelAlignment(){const{position:t,ticks:e}=this.options;if(-toRadians(this.labelRotation))return"top"===t?"left":"right";let i="center";return"start"===e.align?i="left":"end"===e.align&&(i="right"),i}_getYAxisLabelAlignment(t){const e=this,{position:i,ticks:{crossAlign:a,mirror:n,padding:o}}=e.options,s=t+o,r=e._getLabelSizes().widest.width;let l,c;return"left"===i?n?(l="left",c=e.right+o):(c=e.right-s,"near"===a?l="right":"center"===a?(l="center",c-=r/2):(l="left",c=e.left)):"right"===i?n?(l="right",c=e.left+o):(c=e.left+s,"near"===a?l="left":"center"===a?(l="center",c+=r/2):(l="right",c=e.right)):l="right",{textAlign:l,x:c}}_computeLabelArea(){const t=this;if(t.options.ticks.mirror)return;const e=t.chart,i=t.options.position;return"left"===i||"right"===i?{top:0,left:t.left,bottom:e.height,right:t.right}:"top"===i||"bottom"===i?{top:t.top,left:0,bottom:t.bottom,right:e.width}:void 0}drawBackground(){const{ctx:t,options:{backgroundColor:e},left:i,top:a,width:n,height:o}=this;e&&(t.save(),t.fillStyle=e,t.fillRect(i,a,n,o),t.restore())}getLineWidthForValue(t){const e=this,i=e.options.grid;if(!e._isVisible()||!i.display)return 0;const a=e.ticks.findIndex((e=>e.value===t));if(a>=0){return i.setContext(e.getContext(a)).lineWidth}return 0}drawGrid(t){const e=this,i=e.options.grid,a=e.ctx,n=e._gridLineItems||(e._gridLineItems=e._computeGridLineItems(t));let o,s;const r=(t,e,i)=>{i.width&&i.color&&(a.save(),a.lineWidth=i.width,a.strokeStyle=i.color,a.setLineDash(i.borderDash||[]),a.lineDashOffset=i.borderDashOffset,a.beginPath(),a.moveTo(t.x,t.y),a.lineTo(e.x,e.y),a.stroke(),a.restore())};if(i.display)for(o=0,s=n.length;o<s;++o){const t=n[o];i.drawOnChartArea&&r({x:t.x1,y:t.y1},{x:t.x2,y:t.y2},t),i.drawTicks&&r({x:t.tx1,y:t.ty1},{x:t.tx2,y:t.ty2},{color:t.tickColor,width:t.tickWidth,borderDash:t.tickBorderDash,borderDashOffset:t.tickBorderDashOffset})}}drawBorder(){const t=this,{chart:e,ctx:i,options:{grid:a}}=t,n=a.setContext(t.getContext()),o=a.drawBorder?n.borderWidth:0;if(!o)return;const s=a.setContext(t.getContext(0)).lineWidth,r=t._borderValue;let l,c,d,h;t.isHorizontal()?(l=_alignPixel(e,t.left,o)-o/2,c=_alignPixel(e,t.right,s)+s/2,d=h=r):(d=_alignPixel(e,t.top,o)-o/2,h=_alignPixel(e,t.bottom,s)+s/2,l=c=r),i.save(),i.lineWidth=n.borderWidth,i.strokeStyle=n.borderColor,i.beginPath(),i.moveTo(l,d),i.lineTo(c,h),i.stroke(),i.restore()}drawLabels(t){const e=this;if(!e.options.ticks.display)return;const i=e.ctx,a=e._computeLabelArea();a&&clipArea(i,a);const n=e._labelItems||(e._labelItems=e._computeLabelItems(t));let o,s;for(o=0,s=n.length;o<s;++o){const t=n[o],e=t.font,a=t.label;t.backdrop&&(i.fillStyle=t.backdrop.color,i.fillRect(t.backdrop.left,t.backdrop.top,t.backdrop.width,t.backdrop.height));let s=t.textOffset;renderText(i,a,0,s,e,t)}a&&unclipArea(i)}drawTitle(){const{ctx:t,options:{position:e,title:i,reverse:a}}=this;if(!i.display)return;const n=toFont(i.font),o=toPadding(i.padding),s=i.align;let r=n.lineHeight/2;"bottom"===e?(r+=o.bottom,isArray(i.text)&&(r+=n.lineHeight*(i.text.length-1))):r+=o.top;const{titleX:l,titleY:c,maxWidth:d,rotation:h}=titleArgs(this,r,e,s);renderText(t,i.text,0,0,n,{color:i.color,maxWidth:d,rotation:h,textAlign:titleAlign(s,e,a),textBaseline:"middle",translation:[l,c]})}draw(t){const e=this;e._isVisible()&&(e.drawBackground(),e.drawGrid(t),e.drawBorder(),e.drawTitle(),e.drawLabels(t))}_layers(){const t=this,e=t.options,i=e.ticks&&e.ticks.z||0,a=e.grid&&e.grid.z||0;return t._isVisible()&&t.draw===Scale.prototype.draw?[{z:a,draw(e){t.drawBackground(),t.drawGrid(e),t.drawTitle()}},{z:a+1,draw(){t.drawBorder()}},{z:i,draw(e){t.drawLabels(e)}}]:[{z:i,draw(e){t.draw(e)}}]}getMatchingVisibleMetas(t){const e=this,i=e.chart.getSortedVisibleDatasetMetas(),a=e.axis+"AxisID",n=[];let o,s;for(o=0,s=i.length;o<s;++o){const s=i[o];s[a]!==e.id||t&&s.type!==t||n.push(s)}return n}_resolveTickFontOptions(t){const e=this.options.ticks.setContext(this.getContext(t));return toFont(e.font)}_maxDigits(){const t=this,e=t._resolveTickFontOptions(0).lineHeight;return(t.isHorizontal()?t.width:t.height)/e}}class TypedRegistry{constructor(t,e,i){this.type=t,this.scope=e,this.override=i,this.items=Object.create(null)}isForType(t){return Object.prototype.isPrototypeOf.call(this.type.prototype,t.prototype)}register(t){const e=this,i=Object.getPrototypeOf(t);let a;isIChartComponent(i)&&(a=e.register(i));const n=e.items,o=t.id,s=e.scope+"."+o;if(!o)throw new Error("class does not have id: "+t);return o in n||(n[o]=t,registerDefaults(t,s,a),e.override&&defaults.override(t.id,t.overrides)),s}get(t){return this.items[t]}unregister(t){const e=this.items,i=t.id,a=this.scope;i in e&&delete e[i],a&&i in defaults[a]&&(delete defaults[a][i],this.override&&delete overrides[i])}}function registerDefaults(t,e,i){const a=merge(Object.create(null),[i?defaults.get(i):{},defaults.get(e),t.defaults]);defaults.set(e,a),t.defaultRoutes&&routeDefaults(e,t.defaultRoutes),t.descriptors&&defaults.describe(e,t.descriptors)}function routeDefaults(t,e){Object.keys(e).forEach((i=>{const a=i.split("."),n=a.pop(),o=[t].concat(a).join("."),s=e[i].split("."),r=s.pop(),l=s.join(".");defaults.route(o,n,l,r)}))}function isIChartComponent(t){return"id"in t&&"defaults"in t}class Registry{constructor(){this.controllers=new TypedRegistry(DatasetController,"datasets",!0),this.elements=new TypedRegistry(Element,"elements"),this.plugins=new TypedRegistry(Object,"plugins"),this.scales=new TypedRegistry(Scale,"scales"),this._typedRegistries=[this.controllers,this.scales,this.elements]}add(...t){this._each("register",t)}remove(...t){this._each("unregister",t)}addControllers(...t){this._each("register",t,this.controllers)}addElements(...t){this._each("register",t,this.elements)}addPlugins(...t){this._each("register",t,this.plugins)}addScales(...t){this._each("register",t,this.scales)}getController(t){return this._get(t,this.controllers,"controller")}getElement(t){return this._get(t,this.elements,"element")}getPlugin(t){return this._get(t,this.plugins,"plugin")}getScale(t){return this._get(t,this.scales,"scale")}removeControllers(...t){this._each("unregister",t,this.controllers)}removeElements(...t){this._each("unregister",t,this.elements)}removePlugins(...t){this._each("unregister",t,this.plugins)}removeScales(...t){this._each("unregister",t,this.scales)}_each(t,e,i){const a=this;[...e].forEach((e=>{const n=i||a._getRegistryForType(e);i||n.isForType(e)||n===a.plugins&&e.id?a._exec(t,n,e):each(e,(e=>{const n=i||a._getRegistryForType(e);a._exec(t,n,e)}))}))}_exec(t,e,i){const a=_capitalize(t);callback(i["before"+a],[],i),e[t](i),callback(i["after"+a],[],i)}_getRegistryForType(t){for(let e=0;e<this._typedRegistries.length;e++){const i=this._typedRegistries[e];if(i.isForType(t))return i}return this.plugins}_get(t,e,i){const a=e.get(t);if(void 0===a)throw new Error('"'+t+'" is not a registered '+i+".");return a}}var registry=new Registry;class PluginService{constructor(){this._init=[]}notify(t,e,i,a){const n=this;"beforeInit"===e&&(n._init=n._createDescriptors(t,!0),n._notify(n._init,t,"install"));const o=a?n._descriptors(t).filter(a):n._descriptors(t),s=n._notify(o,t,e,i);return"destroy"===e&&(n._notify(o,t,"stop"),n._notify(n._init,t,"uninstall")),s}_notify(t,e,i,a){a=a||{};for(const n of t){const t=n.plugin,o=t[i],s=[e,a,n.options];if(!1===callback(o,s,t)&&a.cancelable)return!1}return!0}invalidate(){isNullOrUndef(this._cache)||(this._oldCache=this._cache,this._cache=void 0)}_descriptors(t){if(this._cache)return this._cache;const e=this._cache=this._createDescriptors(t);return this._notifyStateChanges(t),e}_createDescriptors(t,e){const i=t&&t.config,a=valueOrDefault(i.options&&i.options.plugins,{}),n=allPlugins(i);return!1!==a||e?createDescriptors(t,n,a,e):[]}_notifyStateChanges(t){const e=this._oldCache||[],i=this._cache,a=(t,e)=>t.filter((t=>!e.some((e=>t.plugin.id===e.plugin.id))));this._notify(a(e,i),t,"stop"),this._notify(a(i,e),t,"start")}}function allPlugins(t){const e=[],i=Object.keys(registry.plugins.items);for(let t=0;t<i.length;t++)e.push(registry.getPlugin(i[t]));const a=t.plugins||[];for(let t=0;t<a.length;t++){const i=a[t];-1===e.indexOf(i)&&e.push(i)}return e}function getOpts(t,e){return e||!1!==t?!0===t?{}:t:null}function createDescriptors(t,e,i,a){const n=[],o=t.getContext();for(let s=0;s<e.length;s++){const r=e[s],l=getOpts(i[r.id],a);null!==l&&n.push({plugin:r,options:pluginOpts(t.config,r,l,o)})}return n}function pluginOpts(t,e,i,a){const n=t.pluginScopeKeys(e),o=t.getOptionScopes(i,n);return t.createResolver(o,a,[""],{scriptable:!1,indexable:!1,allKeys:!0})}function getIndexAxis(t,e){const i=defaults.datasets[t]||{};return((e.datasets||{})[t]||{}).indexAxis||e.indexAxis||i.indexAxis||"x"}function getAxisFromDefaultScaleID(t,e){let i=t;return"_index_"===t?i=e:"_value_"===t&&(i="x"===e?"y":"x"),i}function getDefaultScaleIDFromAxis(t,e){return t===e?"_index_":"_value_"}function axisFromPosition(t){return"top"===t||"bottom"===t?"x":"left"===t||"right"===t?"y":void 0}function determineAxis(t,e){return"x"===t||"y"===t?t:e.axis||axisFromPosition(e.position)||t.charAt(0).toLowerCase()}function mergeScaleConfig(t,e){const i=overrides[t.type]||{scales:{}},a=e.scales||{},n=getIndexAxis(t.type,e),o=Object.create(null),s=Object.create(null);return Object.keys(a).forEach((t=>{const e=a[t],r=determineAxis(t,e),l=getDefaultScaleIDFromAxis(r,n),c=i.scales||{};o[r]=o[r]||t,s[t]=mergeIf(Object.create(null),[{axis:r},e,c[r],c[l]])})),t.data.datasets.forEach((i=>{const n=i.type||t.type,r=i.indexAxis||getIndexAxis(n,e),l=(overrides[n]||{}).scales||{};Object.keys(l).forEach((t=>{const e=getAxisFromDefaultScaleID(t,r),n=i[e+"AxisID"]||o[e]||e;s[n]=s[n]||Object.create(null),mergeIf(s[n],[{axis:e},a[n],l[t]])}))})),Object.keys(s).forEach((t=>{const e=s[t];mergeIf(e,[defaults.scales[e.type],defaults.scale])})),s}function initOptions(t){const e=t.options||(t.options={});e.plugins=valueOrDefault(e.plugins,{}),e.scales=mergeScaleConfig(t,e)}function initData(t){return(t=t||{}).datasets=t.datasets||[],t.labels=t.labels||[],t}function initConfig(t){return(t=t||{}).data=initData(t.data),initOptions(t),t}const keyCache=new Map,keysCached=new Set;function cachedKeys(t,e){let i=keyCache.get(t);return i||(i=e(),keyCache.set(t,i),keysCached.add(i)),i}const addIfFound=(t,e,i)=>{const a=resolveObjectKey(e,i);void 0!==a&&t.add(a)};class Config{constructor(t){this._config=initConfig(t),this._scopeCache=new Map,this._resolverCache=new Map}get type(){return this._config.type}set type(t){this._config.type=t}get data(){return this._config.data}set data(t){this._config.data=initData(t)}get options(){return this._config.options}set options(t){this._config.options=t}get plugins(){return this._config.plugins}update(){const t=this._config;this.clearCache(),initOptions(t)}clearCache(){this._scopeCache.clear(),this._resolverCache.clear()}datasetScopeKeys(t){return cachedKeys(t,(()=>[["datasets."+t,""]]))}datasetAnimationScopeKeys(t,e){return cachedKeys(`${t}.transition.${e}`,(()=>[[`datasets.${t}.transitions.${e}`,"transitions."+e],["datasets."+t,""]]))}datasetElementScopeKeys(t,e){return cachedKeys(`${t}-${e}`,(()=>[[`datasets.${t}.elements.${e}`,"datasets."+t,"elements."+e,""]]))}pluginScopeKeys(t){const e=t.id;return cachedKeys(`${this.type}-plugin-${e}`,(()=>[["plugins."+e,...t.additionalOptionScopes||[]]]))}_cachedScopes(t,e){const i=this._scopeCache;let a=i.get(t);return a&&!e||(a=new Map,i.set(t,a)),a}getOptionScopes(t,e,i){const{options:a,type:n}=this,o=this._cachedScopes(t,i),s=o.get(e);if(s)return s;const r=new Set;e.forEach((e=>{t&&(r.add(t),e.forEach((e=>addIfFound(r,t,e)))),e.forEach((t=>addIfFound(r,a,t))),e.forEach((t=>addIfFound(r,overrides[n]||{},t))),e.forEach((t=>addIfFound(r,defaults,t))),e.forEach((t=>addIfFound(r,descriptors,t)))}));const l=[...r];return keysCached.has(e)&&o.set(e,l),l}chartOptionScopes(){const{options:t,type:e}=this;return[t,overrides[e]||{},defaults.datasets[e]||{},{type:e},defaults,descriptors]}resolveNamedOptions(t,e,i,a=[""]){const n={$shared:!0},{resolver:o,subPrefixes:s}=getResolver(this._resolverCache,t,a);let r=o;if(needContext(o,e)){n.$shared=!1,i=isFunction(i)?i():i;const e=this.createResolver(t,i,s);r=_attachContext(o,i,e)}for(const t of e)n[t]=r[t];return n}createResolver(t,e,i=[""],a){const{resolver:n}=getResolver(this._resolverCache,t,i);return isObject(e)?_attachContext(n,e,void 0,a):n}}function getResolver(t,e,i){let a=t.get(e);a||(a=new Map,t.set(e,a));const n=i.join();let o=a.get(n);if(!o){o={resolver:_createResolver(e,i),subPrefixes:i.filter((t=>!t.toLowerCase().includes("hover")))},a.set(n,o)}return o}function needContext(t,e){const{isScriptable:i,isIndexable:a}=_descriptors(t);for(const n of e)if(i(n)&&isFunction(t[n])||a(n)&&isArray(t[n]))return!0;return!1}var version="3.3.2";const KNOWN_POSITIONS=["top","bottom","left","right","chartArea"];function positionIsHorizontal(t,e){return"top"===t||"bottom"===t||-1===KNOWN_POSITIONS.indexOf(t)&&"x"===e}function compare2Level(t,e){return function(i,a){return i[t]===a[t]?i[e]-a[e]:i[t]-a[t]}}function onAnimationsComplete(t){const e=t.chart,i=e.options.animation;e.notifyPlugins("afterRender"),callback(i&&i.onComplete,[t],e)}function onAnimationProgress(t){const e=t.chart,i=e.options.animation;callback(i&&i.onProgress,[t],e)}function isDomSupported(){return"undefined"!=typeof window&&"undefined"!=typeof document}function getCanvas(t){return isDomSupported()&&"string"==typeof t?t=document.getElementById(t):t&&t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas),t}const instances={},getChart=t=>{const e=getCanvas(t);return Object.values(instances).filter((t=>t.canvas===e)).pop()};class Chart{constructor(t,e){const i=this;this.config=e=new Config(e);const a=getCanvas(t),n=getChart(a);if(n)throw new Error("Canvas is already in use. Chart with ID '"+n.id+"' must be destroyed before the canvas can be reused.");const o=e.createResolver(e.chartOptionScopes(),i.getContext());this.platform=i._initializePlatform(a,e);const s=i.platform.acquireContext(a,o.aspectRatio),r=s&&s.canvas,l=r&&r.height,c=r&&r.width;this.id=uid(),this.ctx=s,this.canvas=r,this.width=c,this.height=l,this._options=o,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this.scale=void 0,this._plugins=new PluginService,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=debounce((()=>this.update("resize")),o.resizeDelay||0),instances[i.id]=i,s&&r?(animator.listen(i,"complete",onAnimationsComplete),animator.listen(i,"progress",onAnimationProgress),i._initialize(),i.attached&&i.update()):console.error("Failed to create chart: can't acquire context from the given item")}get aspectRatio(){const{options:{aspectRatio:t,maintainAspectRatio:e},width:i,height:a,_aspectRatio:n}=this;return isNullOrUndef(t)?e&&n?n:a?i/a:null:t}get data(){return this.config.data}set data(t){this.config.data=t}get options(){return this._options}set options(t){this.config.options=t}_initialize(){const t=this;return t.notifyPlugins("beforeInit"),t.options.responsive?t.resize():retinaScale(t,t.options.devicePixelRatio),t.bindEvents(),t.notifyPlugins("afterInit"),t}_initializePlatform(t,e){return e.platform?new e.platform:!isDomSupported()||"undefined"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas?new BasicPlatform:new DomPlatform}clear(){return clearCanvas(this.canvas,this.ctx),this}stop(){return animator.stop(this),this}resize(t,e){animator.running(this)?this._resizeBeforeDraw={width:t,height:e}:this._resize(t,e)}_resize(t,e){const i=this,a=i.options,n=i.canvas,o=a.maintainAspectRatio&&i.aspectRatio,s=i.platform.getMaximumSize(n,t,e,o),r=a.devicePixelRatio||i.platform.getDevicePixelRatio();i.width=s.width,i.height=s.height,i._aspectRatio=i.aspectRatio,retinaScale(i,r,!0)&&(i.notifyPlugins("resize",{size:s}),callback(a.onResize,[i,s],i),i.attached&&i._doResize()&&i.render())}ensureScalesHaveIDs(){const t=this.options.scales||{};each(t,((t,e)=>{t.id=e}))}buildOrUpdateScales(){const t=this,e=t.options,i=e.scales,a=t.scales,n=Object.keys(a).reduce(((t,e)=>(t[e]=!1,t)),{});let o=[];i&&(o=o.concat(Object.keys(i).map((t=>{const e=i[t],a=determineAxis(t,e),n="r"===a,o="x"===a;return{options:e,dposition:n?"chartArea":o?"bottom":"left",dtype:n?"radialLinear":o?"category":"linear"}})))),each(o,(i=>{const o=i.options,s=o.id,r=determineAxis(s,o),l=valueOrDefault(o.type,i.dtype);void 0!==o.position&&positionIsHorizontal(o.position,r)===positionIsHorizontal(i.dposition)||(o.position=i.dposition),n[s]=!0;let c=null;if(s in a&&a[s].type===l)c=a[s];else{c=new(registry.getScale(l))({id:s,type:l,ctx:t.ctx,chart:t}),a[c.id]=c}c.init(o,e)})),each(n,((t,e)=>{t||delete a[e]})),each(a,(e=>{layouts.configure(t,e,e.options),layouts.addBox(t,e)}))}_updateMetasets(){const t=this,e=t._metasets,i=t.data.datasets.length,a=e.length;if(e.sort(((t,e)=>t.index-e.index)),a>i){for(let e=i;e<a;++e)t._destroyDatasetMeta(e);e.splice(i,a-i)}t._sortedMetasets=e.slice(0).sort(compare2Level("order","index"))}_removeUnreferencedMetasets(){const t=this,{_metasets:e,data:{datasets:i}}=t;e.length>i.length&&delete t._stacks,e.forEach(((e,a)=>{0===i.filter((t=>t===e._dataset)).length&&t._destroyDatasetMeta(a)}))}buildOrUpdateControllers(){const t=this,e=[],i=t.data.datasets;let a,n;for(t._removeUnreferencedMetasets(),a=0,n=i.length;a<n;a++){const n=i[a];let o=t.getDatasetMeta(a);const s=n.type||t.config.type;if(o.type&&o.type!==s&&(t._destroyDatasetMeta(a),o=t.getDatasetMeta(a)),o.type=s,o.indexAxis=n.indexAxis||getIndexAxis(s,t.options),o.order=n.order||0,o.index=a,o.label=""+n.label,o.visible=t.isDatasetVisible(a),o.controller)o.controller.updateIndex(a),o.controller.linkScales();else{const i=registry.getController(s),{datasetElementType:n,dataElementType:r}=defaults.datasets[s];Object.assign(i.prototype,{dataElementType:registry.getElement(r),datasetElementType:n&&registry.getElement(n)}),o.controller=new i(t,a),e.push(o.controller)}}return t._updateMetasets(),e}_resetElements(){const t=this;each(t.data.datasets,((e,i)=>{t.getDatasetMeta(i).controller.reset()}),t)}reset(){this._resetElements(),this.notifyPlugins("reset")}update(t){const e=this,i=e.config;i.update(),e._options=i.createResolver(i.chartOptionScopes(),e.getContext()),each(e.scales,(t=>{layouts.removeBox(e,t)}));const a=e._animationsDisabled=!e.options.animation;e.ensureScalesHaveIDs(),e.buildOrUpdateScales();const n=new Set(Object.keys(e._listeners)),o=new Set(e.options.events);if(setsEqual(n,o)&&!!this._responsiveListeners===e.options.responsive||(e.unbindEvents(),e.bindEvents()),e._plugins.invalidate(),!1===e.notifyPlugins("beforeUpdate",{mode:t,cancelable:!0}))return;const s=e.buildOrUpdateControllers();e.notifyPlugins("beforeElementsUpdate");let r=0;for(let t=0,i=e.data.datasets.length;t<i;t++){const{controller:i}=e.getDatasetMeta(t),n=!a&&-1===s.indexOf(i);i.buildOrUpdateElements(n),r=Math.max(+i.getMaxOverflow(),r)}e._minPadding=r,e._updateLayout(r),a||each(s,(t=>{t.reset()})),e._updateDatasets(t),e.notifyPlugins("afterUpdate",{mode:t}),e._layers.sort(compare2Level("z","_idx")),e._lastEvent&&e._eventHandler(e._lastEvent,!0),e.render()}_updateLayout(t){const e=this;if(!1===e.notifyPlugins("beforeLayout",{cancelable:!0}))return;layouts.update(e,e.width,e.height,t);const i=e.chartArea,a=i.width<=0||i.height<=0;e._layers=[],each(e.boxes,(t=>{a&&"chartArea"===t.position||(t.configure&&t.configure(),e._layers.push(...t._layers()))}),e),e._layers.forEach(((t,e)=>{t._idx=e})),e.notifyPlugins("afterLayout")}_updateDatasets(t){const e=this,i="function"==typeof t;if(!1!==e.notifyPlugins("beforeDatasetsUpdate",{mode:t,cancelable:!0})){for(let a=0,n=e.data.datasets.length;a<n;++a)e._updateDataset(a,i?t({datasetIndex:a}):t);e.notifyPlugins("afterDatasetsUpdate",{mode:t})}}_updateDataset(t,e){const i=this,a=i.getDatasetMeta(t),n={meta:a,index:t,mode:e,cancelable:!0};!1!==i.notifyPlugins("beforeDatasetUpdate",n)&&(a.controller._update(e),n.cancelable=!1,i.notifyPlugins("afterDatasetUpdate",n))}render(){const t=this;!1!==t.notifyPlugins("beforeRender",{cancelable:!0})&&(animator.has(t)?t.attached&&!animator.running(t)&&animator.start(t):(t.draw(),onAnimationsComplete({chart:t})))}draw(){const t=this;let e;if(t._resizeBeforeDraw){const{width:e,height:i}=t._resizeBeforeDraw;t._resize(e,i),t._resizeBeforeDraw=null}if(t.clear(),t.width<=0||t.height<=0)return;if(!1===t.notifyPlugins("beforeDraw",{cancelable:!0}))return;const i=t._layers;for(e=0;e<i.length&&i[e].z<=0;++e)i[e].draw(t.chartArea);for(t._drawDatasets();e<i.length;++e)i[e].draw(t.chartArea);t.notifyPlugins("afterDraw")}_getSortedDatasetMetas(t){const e=this._sortedMetasets,i=[];let a,n;for(a=0,n=e.length;a<n;++a){const n=e[a];t&&!n.visible||i.push(n)}return i}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){const t=this;if(!1===t.notifyPlugins("beforeDatasetsDraw",{cancelable:!0}))return;const e=t.getSortedVisibleDatasetMetas();for(let i=e.length-1;i>=0;--i)t._drawDataset(e[i]);t.notifyPlugins("afterDatasetsDraw")}_drawDataset(t){const e=this,i=e.ctx,a=t._clip,n=e.chartArea,o={meta:t,index:t.index,cancelable:!0};!1!==e.notifyPlugins("beforeDatasetDraw",o)&&(clipArea(i,{left:!1===a.left?0:n.left-a.left,right:!1===a.right?e.width:n.right+a.right,top:!1===a.top?0:n.top-a.top,bottom:!1===a.bottom?e.height:n.bottom+a.bottom}),t.controller.draw(),unclipArea(i),o.cancelable=!1,e.notifyPlugins("afterDatasetDraw",o))}getElementsAtEventForMode(t,e,i,a){const n=Interaction.modes[e];return"function"==typeof n?n(this,t,i,a):[]}getDatasetMeta(t){const e=this.data.datasets[t],i=this._metasets;let a=i.filter((t=>t&&t._dataset===e)).pop();return a||(a={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e&&e.order||0,index:t,_dataset:e,_parsed:[],_sorted:!1},i.push(a)),a}getContext(){return this.$context||(this.$context={chart:this,type:"chart"})}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(t){const e=this.data.datasets[t];if(!e)return!1;const i=this.getDatasetMeta(t);return"boolean"==typeof i.hidden?!i.hidden:!e.hidden}setDatasetVisibility(t,e){this.getDatasetMeta(t).hidden=!e}toggleDataVisibility(t){this._hiddenIndices[t]=!this._hiddenIndices[t]}getDataVisibility(t){return!this._hiddenIndices[t]}_updateDatasetVisibility(t,e){const i=this,a=e?"show":"hide",n=i.getDatasetMeta(t),o=n.controller._resolveAnimations(void 0,a);i.setDatasetVisibility(t,e),o.update(n,{visible:e}),i.update((e=>e.datasetIndex===t?a:void 0))}hide(t){this._updateDatasetVisibility(t,!1)}show(t){this._updateDatasetVisibility(t,!0)}_destroyDatasetMeta(t){const e=this,i=e._metasets&&e._metasets[t];i&&i.controller&&(i.controller._destroy(),delete e._metasets[t])}destroy(){const t=this,{canvas:e,ctx:i}=t;let a,n;for(t.stop(),animator.remove(t),a=0,n=t.data.datasets.length;a<n;++a)t._destroyDatasetMeta(a);t.config.clearCache(),e&&(t.unbindEvents(),clearCanvas(e,i),t.platform.releaseContext(i),t.canvas=null,t.ctx=null),t.notifyPlugins("destroy"),delete instances[t.id]}toBase64Image(...t){return this.canvas.toDataURL(...t)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0}bindUserEvents(){const t=this,e=t._listeners,i=t.platform,a=function(e,i,a){e.offsetX=i,e.offsetY=a,t._eventHandler(e)};each(t.options.events,(n=>((a,n)=>{i.addEventListener(t,a,n),e[a]=n})(n,a)))}bindResponsiveEvents(){const t=this;t._responsiveListeners||(t._responsiveListeners={});const e=t._responsiveListeners,i=t.platform,a=(a,n)=>{i.addEventListener(t,a,n),e[a]=n},n=(a,n)=>{e[a]&&(i.removeEventListener(t,a,n),delete e[a])},o=(e,i)=>{t.canvas&&t.resize(e,i)};let s;const r=()=>{n("attach",r),t.attached=!0,t.resize(),a("resize",o),a("detach",s)};s=()=>{t.attached=!1,n("resize",o),a("attach",r)},i.isAttached(t.canvas)?r():s()}unbindEvents(){const t=this;each(t._listeners,((e,i)=>{t.platform.removeEventListener(t,i,e)})),t._listeners={},each(t._responsiveListeners,((e,i)=>{t.platform.removeEventListener(t,i,e)})),t._responsiveListeners=void 0}updateHoverStyle(t,e,i){const a=i?"set":"remove";let n,o,s,r;for("dataset"===e&&(n=this.getDatasetMeta(t[0].datasetIndex),n.controller["_"+a+"DatasetHoverStyle"]()),s=0,r=t.length;s<r;++s){o=t[s];const e=o&&this.getDatasetMeta(o.datasetIndex).controller;e&&e[a+"HoverStyle"](o.element,o.datasetIndex,o.index)}}getActiveElements(){return this._active||[]}setActiveElements(t){const e=this,i=e._active||[],a=t.map((({datasetIndex:t,index:i})=>{const a=e.getDatasetMeta(t);if(!a)throw new Error("No dataset found at index "+t);return{datasetIndex:t,element:a.data[i],index:i}}));!_elementsEqual(a,i)&&(e._active=a,e._updateHoverStyles(a,i))}notifyPlugins(t,e,i){return this._plugins.notify(this,t,e,i)}_updateHoverStyles(t,e,i){const a=this,n=a.options.hover,o=(t,e)=>t.filter((t=>!e.some((e=>t.datasetIndex===e.datasetIndex&&t.index===e.index)))),s=o(e,t),r=i?t:o(t,e);s.length&&a.updateHoverStyle(s,n.mode,!1),r.length&&n.mode&&a.updateHoverStyle(r,n.mode,!0)}_eventHandler(t,e){const i=this,a={event:t,replay:e,cancelable:!0},n=e=>(e.options.events||this.options.events).includes(t.type);if(!1===i.notifyPlugins("beforeEvent",a,n))return;const o=i._handleEvent(t,e);return a.cancelable=!1,i.notifyPlugins("afterEvent",a,n),(o||a.changed)&&i.render(),i}_handleEvent(t,e){const i=this,{_active:a=[],options:n}=i,o=n.hover,s=e;let r=[],l=!1,c=null;return"mouseout"!==t.type&&(r=i.getElementsAtEventForMode(t,o.mode,o,s),c="click"===t.type?i._lastEvent:t),i._lastEvent=null,_isPointInArea(t,i.chartArea,i._minPadding)&&(callback(n.onHover,[t,r,i],i),"mouseup"!==t.type&&"click"!==t.type&&"contextmenu"!==t.type||callback(n.onClick,[t,r,i],i)),l=!_elementsEqual(r,a),(l||e)&&(i._active=r,i._updateHoverStyles(r,a,e)),i._lastEvent=c,l}}const invalidatePlugins=()=>each(Chart.instances,(t=>t._plugins.invalidate())),enumerable=!0;function clipArc(t,e,i){const{startAngle:a,pixelMargin:n,x:o,y:s,outerRadius:r,innerRadius:l}=e;let c=n/r;t.beginPath(),t.arc(o,s,r,a-c,i+c),l>n?(c=n/l,t.arc(o,s,l,i+c,a-c,!0)):t.arc(o,s,n,i+HALF_PI,a-HALF_PI),t.closePath(),t.clip()}function toRadiusCorners(t){return _readValueToProps(t,["outerStart","outerEnd","innerStart","innerEnd"])}function parseBorderRadius$1(t,e,i,a){const n=toRadiusCorners(t.options.borderRadius),o=(i-e)/2,s=Math.min(o,a*e/2),r=t=>{const e=(i-Math.min(o,t))*a/2;return _limitValue(t,0,Math.min(o,e))};return{outerStart:r(n.outerStart),outerEnd:r(n.outerEnd),innerStart:_limitValue(n.innerStart,0,s),innerEnd:_limitValue(n.innerEnd,0,s)}}function rThetaToXY(t,e,i,a){return{x:i+t*Math.cos(e),y:a+t*Math.sin(e)}}function pathArc(t,e,i,a){const{x:n,y:o,startAngle:s,pixelMargin:r,innerRadius:l}=e,c=Math.max(e.outerRadius+i-r,0),d=l>0?l+i+r:0,h=a-s,u=(h-Math.max(.001,h*c-i/PI)/c)/2,g=s+u,p=a-u,{outerStart:f,outerEnd:m,innerStart:x,innerEnd:b}=parseBorderRadius$1(e,d,c,p-g),_=c-f,y=c-m,v=g+f/_,S=p-m/y,k=d+x,M=d+b,D=g+x/k,w=p-b/M;if(t.beginPath(),t.arc(n,o,c,v,S),m>0){const e=rThetaToXY(y,S,n,o);t.arc(e.x,e.y,m,S,p+HALF_PI)}const P=rThetaToXY(M,p,n,o);if(t.lineTo(P.x,P.y),b>0){const e=rThetaToXY(M,w,n,o);t.arc(e.x,e.y,b,p+HALF_PI,w+Math.PI)}if(t.arc(n,o,d,p-b/d,g+x/d,!0),x>0){const e=rThetaToXY(k,D,n,o);t.arc(e.x,e.y,x,D+Math.PI,g-HALF_PI)}const A=rThetaToXY(_,g,n,o);if(t.lineTo(A.x,A.y),f>0){const e=rThetaToXY(_,v,n,o);t.arc(e.x,e.y,f,g-HALF_PI,v)}t.closePath()}function drawArc(t,e,i){const{fullCircles:a,startAngle:n,circumference:o}=e;let s=e.endAngle;if(a){pathArc(t,e,i,n+TAU);for(let e=0;e<a;++e)t.fill();isNaN(o)||(s=n+o%TAU,o%TAU==0&&(s+=TAU))}return pathArc(t,e,i,s),t.fill(),s}function drawFullCircleBorders(t,e,i){const{x:a,y:n,startAngle:o,pixelMargin:s,fullCircles:r}=e,l=Math.max(e.outerRadius-s,0),c=e.innerRadius+s;let d;for(i&&clipArc(t,e,o+TAU),t.beginPath(),t.arc(a,n,c,o+TAU,o,!0),d=0;d<r;++d)t.stroke();for(t.beginPath(),t.arc(a,n,l,o,o+TAU),d=0;d<r;++d)t.stroke()}function drawBorder(t,e,i,a){const{options:n}=e,o="inner"===n.borderAlign;n.borderWidth&&(o?(t.lineWidth=2*n.borderWidth,t.lineJoin="round"):(t.lineWidth=n.borderWidth,t.lineJoin="bevel"),e.fullCircles&&drawFullCircleBorders(t,e,o),o&&clipArc(t,e,a),pathArc(t,e,i,a),t.stroke())}Object.defineProperties(Chart,{defaults:{enumerable:true,value:defaults},instances:{enumerable:true,value:instances},overrides:{enumerable:true,value:overrides},registry:{enumerable:true,value:registry},version:{enumerable:true,value:version},getChart:{enumerable:true,value:getChart},register:{enumerable:true,value:(...t)=>{registry.add(...t),invalidatePlugins()}},unregister:{enumerable:true,value:(...t)=>{registry.remove(...t),invalidatePlugins()}}});class ArcElement extends Element{constructor(t){super(),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,t&&Object.assign(this,t)}inRange(t,e,i){const a=this.getProps(["x","y"],i),{angle:n,distance:o}=getAngleFromPoint(a,{x:t,y:e}),{startAngle:s,endAngle:r,innerRadius:l,outerRadius:c,circumference:d}=this.getProps(["startAngle","endAngle","innerRadius","outerRadius","circumference"],i);return(d>=TAU||_angleBetween(n,s,r))&&(o>=l&&o<=c)}getCenterPoint(t){const{x:e,y:i,startAngle:a,endAngle:n,innerRadius:o,outerRadius:s}=this.getProps(["x","y","startAngle","endAngle","innerRadius","outerRadius","circumference"],t),r=(a+n)/2,l=(o+s)/2;return{x:e+Math.cos(r)*l,y:i+Math.sin(r)*l}}tooltipPosition(t){return this.getCenterPoint(t)}draw(t){const e=this,{options:i,circumference:a}=e,n=(i.offset||0)/2;if(e.pixelMargin="inner"===i.borderAlign?.33:0,e.fullCircles=a>TAU?Math.floor(a/TAU):0,0===a||e.innerRadius<0||e.outerRadius<0)return;t.save();let o=0;if(n){o=n/2;const i=(e.startAngle+e.endAngle)/2;t.translate(Math.cos(i)*o,Math.sin(i)*o),e.circumference>=PI&&(o=n)}t.fillStyle=i.backgroundColor,t.strokeStyle=i.borderColor;drawBorder(t,e,o,drawArc(t,e,o)),t.restore()}}function setStyle(t,e,i=e){t.lineCap=valueOrDefault(i.borderCapStyle,e.borderCapStyle),t.setLineDash(valueOrDefault(i.borderDash,e.borderDash)),t.lineDashOffset=valueOrDefault(i.borderDashOffset,e.borderDashOffset),t.lineJoin=valueOrDefault(i.borderJoinStyle,e.borderJoinStyle),t.lineWidth=valueOrDefault(i.borderWidth,e.borderWidth),t.strokeStyle=valueOrDefault(i.borderColor,e.borderColor)}function lineTo(t,e,i){t.lineTo(i.x,i.y)}function getLineMethod(t){return t.stepped?_steppedLineTo:t.tension||"monotone"===t.cubicInterpolationMode?_bezierCurveTo:lineTo}function pathVars(t,e,i={}){const a=t.length,{start:n=0,end:o=a-1}=i,{start:s,end:r}=e,l=Math.max(n,s),c=Math.min(o,r),d=n<s&&o<s||n>r&&o>r;return{count:a,start:l,loop:e.loop,ilen:c<l&&!d?a+c-l:c-l}}function pathSegment(t,e,i,a){const{points:n,options:o}=e,{count:s,start:r,loop:l,ilen:c}=pathVars(n,i,a),d=getLineMethod(o);let h,u,g,{move:p=!0,reverse:f}=a||{};for(h=0;h<=c;++h)u=n[(r+(f?c-h:h))%s],u.skip||(p?(t.moveTo(u.x,u.y),p=!1):d(t,g,u,f,o.stepped),g=u);return l&&(u=n[(r+(f?c:0))%s],d(t,g,u,f,o.stepped)),!!l}function fastPathSegment(t,e,i,a){const n=e.points,{count:o,start:s,ilen:r}=pathVars(n,i,a),{move:l=!0,reverse:c}=a||{};let d,h,u,g,p,f,m=0,x=0;const b=t=>(s+(c?r-t:t))%o,_=()=>{g!==p&&(t.lineTo(m,p),t.lineTo(m,g),t.lineTo(m,f))};for(l&&(h=n[b(0)],t.moveTo(h.x,h.y)),d=0;d<=r;++d){if(h=n[b(d)],h.skip)continue;const e=h.x,i=h.y,a=0|e;a===u?(i<g?g=i:i>p&&(p=i),m=(x*m+e)/++x):(_(),t.lineTo(e,i),u=a,x=0,g=p=i),f=i}_()}function _getSegmentMethod(t){const e=t.options,i=e.borderDash&&e.borderDash.length;return!(t._decimated||t._loop||e.tension||"monotone"===e.cubicInterpolationMode||e.stepped||i)?fastPathSegment:pathSegment}function _getInterpolationMethod(t){return t.stepped?_steppedInterpolation:t.tension||"monotone"===t.cubicInterpolationMode?_bezierInterpolation:_pointInLine}function strokePathWithCache(t,e,i,a){let n=e._path;n||(n=e._path=new Path2D,e.path(n,i,a)&&n.closePath()),setStyle(t,e.options),t.stroke(n)}function strokePathDirect(t,e,i,a){const{segments:n,options:o}=e,s=_getSegmentMethod(e);for(const r of n)setStyle(t,o,r.style),t.beginPath(),s(t,e,r,{start:i,end:i+a-1})&&t.closePath(),t.stroke()}ArcElement.id="arc",ArcElement.defaults={borderAlign:"center",borderColor:"#fff",borderRadius:0,borderWidth:2,offset:0,angle:void 0},ArcElement.defaultRoutes={backgroundColor:"backgroundColor"};const usePath2D="function"==typeof Path2D;function draw(t,e,i,a){usePath2D&&1===e.segments.length?strokePathWithCache(t,e,i,a):strokePathDirect(t,e,i,a)}class LineElement extends Element{constructor(t){super(),this.animated=!0,this.options=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,t&&Object.assign(this,t)}updateControlPoints(t,e){const i=this,a=i.options;if((a.tension||"monotone"===a.cubicInterpolationMode)&&!a.stepped&&!i._pointsUpdated){const n=a.spanGaps?i._loop:i._fullLoop;_updateBezierControlPoints(i._points,a,t,n,e),i._pointsUpdated=!0}}set points(t){const e=this;e._points=t,delete e._segments,delete e._path,e._pointsUpdated=!1}get points(){return this._points}get segments(){return this._segments||(this._segments=_computeSegments(this,this.options.segment))}first(){const t=this.segments,e=this.points;return t.length&&e[t[0].start]}last(){const t=this.segments,e=this.points,i=t.length;return i&&e[t[i-1].end]}interpolate(t,e){const i=this,a=i.options,n=t[e],o=i.points,s=_boundSegments(i,{property:e,start:n,end:n});if(!s.length)return;const r=[],l=_getInterpolationMethod(a);let c,d;for(c=0,d=s.length;c<d;++c){const{start:i,end:d}=s[c],h=o[i],u=o[d];if(h===u){r.push(h);continue}const g=l(h,u,Math.abs((n-h[e])/(u[e]-h[e])),a.stepped);g[e]=t[e],r.push(g)}return 1===r.length?r[0]:r}pathSegment(t,e,i){return _getSegmentMethod(this)(t,this,e,i)}path(t,e,i){const a=this,n=a.segments,o=_getSegmentMethod(a);let s=a._loop;e=e||0,i=i||a.points.length-e;for(const r of n)s&=o(t,a,r,{start:e,end:e+i-1});return!!s}draw(t,e,i,a){const n=this,o=n.options||{};(n.points||[]).length&&o.borderWidth&&(t.save(),draw(t,n,i,a),t.restore(),n.animated&&(n._pointsUpdated=!1,n._path=void 0))}}function inRange$1(t,e,i,a){const n=t.options,{[i]:o}=t.getProps([i],a);return Math.abs(e-o)<n.radius+n.hitRadius}LineElement.id="line",LineElement.defaults={borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:"default",fill:!1,spanGaps:!1,stepped:!1,tension:0},LineElement.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"},LineElement.descriptors={_scriptable:!0,_indexable:t=>"borderDash"!==t&&"fill"!==t};class PointElement extends Element{constructor(t){super(),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,t&&Object.assign(this,t)}inRange(t,e,i){const a=this.options,{x:n,y:o}=this.getProps(["x","y"],i);return Math.pow(t-n,2)+Math.pow(e-o,2)<Math.pow(a.hitRadius+a.radius,2)}inXRange(t,e){return inRange$1(this,t,"x",e)}inYRange(t,e){return inRange$1(this,t,"y",e)}getCenterPoint(t){const{x:e,y:i}=this.getProps(["x","y"],t);return{x:e,y:i}}size(t){let e=(t=t||this.options||{}).radius||0;e=Math.max(e,e&&t.hoverRadius||0);return 2*(e+(e&&t.borderWidth||0))}draw(t){const e=this,i=e.options;e.skip||i.radius<.1||(t.strokeStyle=i.borderColor,t.lineWidth=i.borderWidth,t.fillStyle=i.backgroundColor,drawPoint(t,i,e.x,e.y))}getRange(){const t=this.options||{};return t.radius+t.hitRadius}}function getBarBounds(t,e){const{x:i,y:a,base:n,width:o,height:s}=t.getProps(["x","y","base","width","height"],e);let r,l,c,d,h;return t.horizontal?(h=s/2,r=Math.min(i,n),l=Math.max(i,n),c=a-h,d=a+h):(h=o/2,r=i-h,l=i+h,c=Math.min(a,n),d=Math.max(a,n)),{left:r,top:c,right:l,bottom:d}}function parseBorderSkipped(t){let e=t.options.borderSkipped;const i={};return e?(e=t.horizontal?parseEdge(e,"left","right",t.base>t.x):parseEdge(e,"bottom","top",t.base<t.y),i[e]=!0,i):i}function parseEdge(t,e,i,a){return t=a?startEnd(t=swap(t,e,i),i,e):startEnd(t,e,i)}function swap(t,e,i){return t===e?i:t===i?e:t}function startEnd(t,e,i){return"start"===t?e:"end"===t?i:t}function skipOrLimit(t,e,i,a){return t?0:Math.max(Math.min(e,a),i)}function parseBorderWidth(t,e,i){const a=t.options.borderWidth,n=parseBorderSkipped(t),o=toTRBL(a);return{t:skipOrLimit(n.top,o.top,0,i),r:skipOrLimit(n.right,o.right,0,e),b:skipOrLimit(n.bottom,o.bottom,0,i),l:skipOrLimit(n.left,o.left,0,e)}}function parseBorderRadius(t,e,i){const{enableBorderRadius:a}=t.getProps(["enableBorderRadius"]),n=t.options.borderRadius,o=toTRBLCorners(n),s=Math.min(e,i),r=parseBorderSkipped(t),l=a||isObject(n);return{topLeft:skipOrLimit(!l||r.top||r.left,o.topLeft,0,s),topRight:skipOrLimit(!l||r.top||r.right,o.topRight,0,s),bottomLeft:skipOrLimit(!l||r.bottom||r.left,o.bottomLeft,0,s),bottomRight:skipOrLimit(!l||r.bottom||r.right,o.bottomRight,0,s)}}function boundingRects(t){const e=getBarBounds(t),i=e.right-e.left,a=e.bottom-e.top,n=parseBorderWidth(t,i/2,a/2),o=parseBorderRadius(t,i/2,a/2);return{outer:{x:e.left,y:e.top,w:i,h:a,radius:o},inner:{x:e.left+n.l,y:e.top+n.t,w:i-n.l-n.r,h:a-n.t-n.b,radius:{topLeft:Math.max(0,o.topLeft-Math.max(n.t,n.l)),topRight:Math.max(0,o.topRight-Math.max(n.t,n.r)),bottomLeft:Math.max(0,o.bottomLeft-Math.max(n.b,n.l)),bottomRight:Math.max(0,o.bottomRight-Math.max(n.b,n.r))}}}}function inRange(t,e,i,a){const n=null===e,o=null===i,s=t&&!(n&&o)&&getBarBounds(t,a);return s&&(n||e>=s.left&&e<=s.right)&&(o||i>=s.top&&i<=s.bottom)}function hasRadius(t){return t.topLeft||t.topRight||t.bottomLeft||t.bottomRight}function addNormalRectPath(t,e){t.rect(e.x,e.y,e.w,e.h)}PointElement.id="point",PointElement.defaults={borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:"circle",radius:3,rotation:0},PointElement.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};class BarElement extends Element{constructor(t){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,t&&Object.assign(this,t)}draw(t){const e=this.options,{inner:i,outer:a}=boundingRects(this),n=hasRadius(a.radius)?addRoundedRectPath:addNormalRectPath;t.save(),a.w===i.w&&a.h===i.h||(t.beginPath(),n(t,a),t.clip(),n(t,i),t.fillStyle=e.borderColor,t.fill("evenodd")),t.beginPath(),n(t,i),t.fillStyle=e.backgroundColor,t.fill(),t.restore()}inRange(t,e,i){return inRange(this,t,e,i)}inXRange(t,e){return inRange(this,t,null,e)}inYRange(t,e){return inRange(this,null,t,e)}getCenterPoint(t){const{x:e,y:i,base:a,horizontal:n}=this.getProps(["x","y","base","horizontal"],t);return{x:n?(e+a)/2:e,y:n?i:(i+a)/2}}getRange(t){return"x"===t?this.width/2:this.height/2}}BarElement.id="bar",BarElement.defaults={borderSkipped:"start",borderWidth:0,borderRadius:0,enableBorderRadius:!0,pointStyle:void 0},BarElement.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};var elements=Object.freeze({__proto__:null,ArcElement:ArcElement,LineElement:LineElement,PointElement:PointElement,BarElement:BarElement});function lttbDecimation(t,e,i,a,n){const o=n.samples||a;if(o>=i)return t.slice(e,e+i);const s=[],r=(i-2)/(o-2);let l=0;const c=e+i-1;let d,h,u,g,p,f=e;for(s[l++]=t[f],d=0;d<o-2;d++){let a,n=0,o=0;const c=Math.floor((d+1)*r)+1+e,m=Math.min(Math.floor((d+2)*r)+1,i)+e,x=m-c;for(a=c;a<m;a++)n+=t[a].x,o+=t[a].y;n/=x,o/=x;const b=Math.floor(d*r)+1+e,_=Math.floor((d+1)*r)+1+e,{x:y,y:v}=t[f];for(u=g=-1,a=b;a<_;a++)g=.5*Math.abs((y-n)*(t[a].y-v)-(y-t[a].x)*(o-v)),g>u&&(u=g,h=t[a],p=a);s[l++]=h,f=p}return s[l++]=t[c],s}function minMaxDecimation(t,e,i,a){let n,o,s,r,l,c,d,h,u,g,p=0,f=0;const m=[],x=e+i-1,b=t[e].x,_=t[x].x-b;for(n=e;n<e+i;++n){o=t[n],s=(o.x-b)/_*a,r=o.y;const e=0|s;if(e===l)r<u?(u=r,c=n):r>g&&(g=r,d=n),p=(f*p+o.x)/++f;else{const i=n-1;if(!isNullOrUndef(c)&&!isNullOrUndef(d)){const e=Math.min(c,d),a=Math.max(c,d);e!==h&&e!==i&&m.push({...t[e],x:p}),a!==h&&a!==i&&m.push({...t[a],x:p})}n>0&&i!==h&&m.push(t[i]),m.push(o),l=e,f=0,u=g=r,c=d=h=n}}return m}function cleanDecimatedDataset(t){if(t._decimated){const e=t._data;delete t._decimated,delete t._data,Object.defineProperty(t,"data",{value:e})}}function cleanDecimatedData(t){t.data.datasets.forEach((t=>{cleanDecimatedDataset(t)}))}function getStartAndCountOfVisiblePointsSimplified(t,e){const i=e.length;let a,n=0;const{iScale:o}=t,{min:s,max:r,minDefined:l,maxDefined:c}=o.getUserBounds();return l&&(n=_limitValue(_lookupByKey(e,o.axis,s).lo,0,i-1)),a=c?_limitValue(_lookupByKey(e,o.axis,r).hi+1,n,i)-n:i-n,{start:n,count:a}}var plugin_decimation={id:"decimation",defaults:{algorithm:"min-max",enabled:!1},beforeElementsUpdate:(t,e,i)=>{if(!i.enabled)return void cleanDecimatedData(t);const a=t.width;t.data.datasets.forEach(((e,n)=>{const{_data:o,indexAxis:s}=e,r=t.getDatasetMeta(n),l=o||e.data;if("y"===resolve([s,t.options.indexAxis]))return;if("line"!==r.type)return;const c=t.scales[r.xAxisID];if("linear"!==c.type&&"time"!==c.type)return;if(t.options.parsing)return;let d,{start:h,count:u}=getStartAndCountOfVisiblePointsSimplified(r,l);if(u<=4*a)cleanDecimatedDataset(e);else{switch(isNullOrUndef(o)&&(e._data=l,delete e.data,Object.defineProperty(e,"data",{configurable:!0,enumerable:!0,get:function(){return this._decimated},set:function(t){this._data=t}})),i.algorithm){case"lttb":d=lttbDecimation(l,h,u,a,i);break;case"min-max":d=minMaxDecimation(l,h,u,a);break;default:throw new Error(`Unsupported decimation algorithm '${i.algorithm}'`)}e._decimated=d}}))},destroy(t){cleanDecimatedData(t)}};function getLineByIndex(t,e){const i=t.getDatasetMeta(e);return i&&t.isDatasetVisible(e)?i.dataset:null}function parseFillOption(t){const e=t.options,i=e.fill;let a=valueOrDefault(i&&i.target,i);return void 0===a&&(a=!!e.backgroundColor),!1!==a&&null!==a&&(!0===a?"origin":a)}function decodeFill(t,e,i){const a=parseFillOption(t);if(isObject(a))return!isNaN(a.value)&&a;let n=parseFloat(a);return isNumberFinite(n)&&Math.floor(n)===n?("-"!==a[0]&&"+"!==a[0]||(n=e+n),!(n===e||n<0||n>=i)&&n):["origin","start","end","stack"].indexOf(a)>=0&&a}function computeLinearBoundary(t){const{scale:e={},fill:i}=t;let a,n=null;return"start"===i?n=e.bottom:"end"===i?n=e.top:isObject(i)?n=e.getPixelForValue(i.value):e.getBasePixel&&(n=e.getBasePixel()),isNumberFinite(n)?(a=e.isHorizontal(),{x:a?n:null,y:a?null:n}):null}class simpleArc{constructor(t){this.x=t.x,this.y=t.y,this.radius=t.radius}pathSegment(t,e,i){const{x:a,y:n,radius:o}=this;return e=e||{start:0,end:TAU},t.arc(a,n,o,e.end,e.start,!0),!i.bounds}interpolate(t){const{x:e,y:i,radius:a}=this,n=t.angle;return{x:e+Math.cos(n)*a,y:i+Math.sin(n)*a,angle:n}}}function computeCircularBoundary(t){const{scale:e,fill:i}=t,a=e.options,n=e.getLabels().length,o=[],s=a.reverse?e.max:e.min,r=a.reverse?e.min:e.max;let l,c,d;if(d="start"===i?s:"end"===i?r:isObject(i)?i.value:e.getBaseValue(),a.grid.circular)return c=e.getPointPositionForValue(0,s),new simpleArc({x:c.x,y:c.y,radius:e.getDistanceFromCenterForValue(d)});for(l=0;l<n;++l)o.push(e.getPointPositionForValue(l,d));return o}function computeBoundary(t){return(t.scale||{}).getPointPositionForValue?computeCircularBoundary(t):computeLinearBoundary(t)}function pointsFromSegments(t,e){const{x:i=null,y:a=null}=t||{},n=e.points,o=[];return e.segments.forEach((t=>{const e=n[t.start],s=n[t.end];null!==a?(o.push({x:e.x,y:a}),o.push({x:s.x,y:a})):null!==i&&(o.push({x:i,y:e.y}),o.push({x:i,y:s.y}))})),o}function buildStackLine(t){const{chart:e,scale:i,index:a,line:n}=t,o=[],s=n.segments,r=n.points,l=getLinesBelow(e,a);l.push(createBoundaryLine({x:null,y:i.bottom},n));for(let t=0;t<s.length;t++){const e=s[t];for(let t=e.start;t<=e.end;t++)addPointsBelow(o,r[t],l)}return new LineElement({points:o,options:{}})}const isLineAndNotInHideAnimation=t=>"line"===t.type&&!t.hidden;function getLinesBelow(t,e){const i=[],a=t.getSortedVisibleDatasetMetas();for(let t=0;t<a.length;t++){const n=a[t];if(n.index===e)break;isLineAndNotInHideAnimation(n)&&i.unshift(n.dataset)}return i}function addPointsBelow(t,e,i){const a=[];for(let n=0;n<i.length;n++){const o=i[n],{first:s,last:r,point:l}=findPoint(o,e,"x");if(!(!l||s&&r))if(s)a.unshift(l);else if(t.push(l),!r)break}t.push(...a)}function findPoint(t,e,i){const a=t.interpolate(e,i);if(!a)return{};const n=a[i],o=t.segments,s=t.points;let r=!1,l=!1;for(let t=0;t<o.length;t++){const e=o[t],a=s[e.start][i],c=s[e.end][i];if(n>=a&&n<=c){r=n===a,l=n===c;break}}return{first:r,last:l,point:a}}function getTarget(t){const{chart:e,fill:i,line:a}=t;if(isNumberFinite(i))return getLineByIndex(e,i);if("stack"===i)return buildStackLine(t);const n=computeBoundary(t);return n instanceof simpleArc?n:createBoundaryLine(n,a)}function createBoundaryLine(t,e){let i=[],a=!1;return isArray(t)?(a=!0,i=t):i=pointsFromSegments(t,e),i.length?new LineElement({points:i,options:{tension:0},_loop:a,_fullLoop:a}):null}function resolveTarget(t,e,i){let a=t[e].fill;const n=[e];let o;if(!i)return a;for(;!1!==a&&-1===n.indexOf(a);){if(!isNumberFinite(a))return a;if(o=t[a],!o)return!1;if(o.visible)return a;n.push(a),a=o.fill}return!1}function _clip(t,e,i){t.beginPath(),e.path(t),t.lineTo(e.last().x,i),t.lineTo(e.first().x,i),t.closePath(),t.clip()}function getBounds(t,e,i,a){if(a)return;let n=e[t],o=i[t];return"angle"===t&&(n=_normalizeAngle(n),o=_normalizeAngle(o)),{property:t,start:n,end:o}}function _getEdge(t,e,i,a){return t&&e?a(t[i],e[i]):t?t[i]:e?e[i]:0}function _segments(t,e,i){const a=t.segments,n=t.points,o=e.points,s=[];for(const t of a){const a=getBounds(i,n[t.start],n[t.end],t.loop);if(!e.segments){s.push({source:t,target:a,start:n[t.start],end:n[t.end]});continue}const r=_boundSegments(e,a);for(const e of r){const r=getBounds(i,o[e.start],o[e.end],e.loop),l=_boundSegment(t,n,r);for(const t of l)s.push({source:t,target:e,start:{[i]:_getEdge(a,r,"start",Math.max)},end:{[i]:_getEdge(a,r,"end",Math.min)}})}}return s}function clipBounds(t,e,i){const{top:a,bottom:n}=e.chart.chartArea,{property:o,start:s,end:r}=i||{};"x"===o&&(t.beginPath(),t.rect(s,a,r-s,n-a),t.clip())}function interpolatedLineTo(t,e,i,a){const n=e.interpolate(i,a);n&&t.lineTo(n.x,n.y)}function _fill(t,e){const{line:i,target:a,property:n,color:o,scale:s}=e,r=_segments(i,a,n);for(const{source:e,target:l,start:c,end:d}of r){const{style:{backgroundColor:r=o}={}}=e;t.save(),t.fillStyle=r,clipBounds(t,s,getBounds(n,c,d)),t.beginPath();const h=!!i.pathSegment(t,e);h?t.closePath():interpolatedLineTo(t,a,d,n);const u=!!a.pathSegment(t,l,{move:h,reverse:!0}),g=h&&u;g||interpolatedLineTo(t,a,c,n),t.closePath(),t.fill(g?"evenodd":"nonzero"),t.restore()}}function doFill(t,e){const{line:i,target:a,above:n,below:o,area:s,scale:r}=e,l=i._loop?"angle":e.axis;t.save(),"x"===l&&o!==n&&(_clip(t,a,s.top),_fill(t,{line:i,target:a,color:n,scale:r,property:l}),t.restore(),t.save(),_clip(t,a,s.bottom)),_fill(t,{line:i,target:a,color:o,scale:r,property:l}),t.restore()}function drawfill(t,e,i){const a=getTarget(e),{line:n,scale:o,axis:s}=e,r=n.options,l=r.fill,c=r.backgroundColor,{above:d=c,below:h=c}=l||{};a&&n.points.length&&(clipArea(t,i),doFill(t,{line:n,target:a,above:d,below:h,area:i,scale:o,axis:s}),unclipArea(t))}var plugin_filler={id:"filler",afterDatasetsUpdate(t,e,i){const a=(t.data.datasets||[]).length,n=[];let o,s,r,l;for(s=0;s<a;++s)o=t.getDatasetMeta(s),r=o.dataset,l=null,r&&r.options&&r instanceof LineElement&&(l={visible:t.isDatasetVisible(s),index:s,fill:decodeFill(r,s,a),chart:t,axis:o.controller.options.indexAxis,scale:o.vScale,line:r}),o.$filler=l,n.push(l);for(s=0;s<a;++s)l=n[s],l&&!1!==l.fill&&(l.fill=resolveTarget(n,s,i.propagate))},beforeDraw(t,e,i){const a="beforeDraw"===i.drawTime,n=t.getSortedVisibleDatasetMetas(),o=t.chartArea;for(let e=n.length-1;e>=0;--e){const i=n[e].$filler;i&&(i.line.updateControlPoints(o,i.axis),a&&drawfill(t.ctx,i,o))}},beforeDatasetsDraw(t,e,i){if("beforeDatasetsDraw"!==i.drawTime)return;const a=t.getSortedVisibleDatasetMetas();for(let e=a.length-1;e>=0;--e){const i=a[e].$filler;i&&drawfill(t.ctx,i,t.chartArea)}},beforeDatasetDraw(t,e,i){const a=e.meta.$filler;a&&!1!==a.fill&&"beforeDatasetDraw"===i.drawTime&&drawfill(t.ctx,a,t.chartArea)},defaults:{propagate:!0,drawTime:"beforeDatasetDraw"}};const getBoxSize=(t,e)=>{let{boxHeight:i=e,boxWidth:a=e}=t;return t.usePointStyle&&(i=Math.min(i,e),a=Math.min(a,e)),{boxWidth:a,boxHeight:i,itemHeight:Math.max(e,i)}},itemsEqual=(t,e)=>null!==t&&null!==e&&t.datasetIndex===e.datasetIndex&&t.index===e.index;class Legend extends Element{constructor(t){super(),this._added=!1,this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1,this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this.legendItems=void 0,this.columnSizes=void 0,this.lineWidths=void 0,this.maxHeight=void 0,this.maxWidth=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.height=void 0,this.width=void 0,this._margins=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e,i){const a=this;a.maxWidth=t,a.maxHeight=e,a._margins=i,a.setDimensions(),a.buildLabels(),a.fit()}setDimensions(){const t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height)}buildLabels(){const t=this,e=t.options.labels||{};let i=callback(e.generateLabels,[t.chart],t)||[];e.filter&&(i=i.filter((i=>e.filter(i,t.chart.data)))),e.sort&&(i=i.sort(((i,a)=>e.sort(i,a,t.chart.data)))),t.options.reverse&&i.reverse(),t.legendItems=i}fit(){const t=this,{options:e,ctx:i}=t;if(!e.display)return void(t.width=t.height=0);const a=e.labels,n=toFont(a.font),o=n.size,s=t._computeTitleHeight(),{boxWidth:r,itemHeight:l}=getBoxSize(a,o);let c,d;i.font=n.string,t.isHorizontal()?(c=t.maxWidth,d=t._fitRows(s,o,r,l)+10):(d=t.maxHeight,c=t._fitCols(s,o,r,l)+10),t.width=Math.min(c,e.maxWidth||t.maxWidth),t.height=Math.min(d,e.maxHeight||t.maxHeight)}_fitRows(t,e,i,a){const n=this,{ctx:o,maxWidth:s,options:{labels:{padding:r}}}=n,l=n.legendHitBoxes=[],c=n.lineWidths=[0],d=a+r;let h=t;o.textAlign="left",o.textBaseline="middle";let u=-1,g=-d;return n.legendItems.forEach(((t,n)=>{const p=i+e/2+o.measureText(t.text).width;(0===n||c[c.length-1]+p+2*r>s)&&(h+=d,c[c.length-(n>0?0:1)]=0,g+=d,u++),l[n]={left:0,top:g,row:u,width:p,height:a},c[c.length-1]+=p+r})),h}_fitCols(t,e,i,a){const n=this,{ctx:o,maxHeight:s,options:{labels:{padding:r}}}=n,l=n.legendHitBoxes=[],c=n.columnSizes=[],d=s-t;let h=r,u=0,g=0,p=0,f=0,m=0;return n.legendItems.forEach(((t,n)=>{const s=i+e/2+o.measureText(t.text).width;n>0&&g+e+2*r>d&&(h+=u+r,c.push({width:u,height:g}),p+=u+r,m++,f=0,u=g=0),u=Math.max(u,s),g+=e+r,l[n]={left:p,top:f,col:m,width:s,height:a},f+=a+r})),h+=u,c.push({width:u,height:g}),h}adjustHitBoxes(){const t=this;if(!t.options.display)return;const e=t._computeTitleHeight(),{legendHitBoxes:i,options:{align:a,labels:{padding:n}}}=t;if(this.isHorizontal()){let o=0,s=_alignStartEnd(a,t.left+n,t.right-t.lineWidths[o]);for(const r of i)o!==r.row&&(o=r.row,s=_alignStartEnd(a,t.left+n,t.right-t.lineWidths[o])),r.top+=t.top+e+n,r.left=s,s+=r.width+n}else{let o=0,s=_alignStartEnd(a,t.top+e+n,t.bottom-t.columnSizes[o].height);for(const r of i)r.col!==o&&(o=r.col,s=_alignStartEnd(a,t.top+e+n,t.bottom-t.columnSizes[o].height)),r.top=s,r.left+=t.left+n,s+=r.height+n}}isHorizontal(){return"top"===this.options.position||"bottom"===this.options.position}draw(){const t=this;if(t.options.display){const e=t.ctx;clipArea(e,t),t._draw(),unclipArea(e)}}_draw(){const t=this,{options:e,columnSizes:i,lineWidths:a,ctx:n}=t,{align:o,labels:s}=e,r=defaults.color,l=getRtlAdapter(e.rtl,t.left,t.width),c=toFont(s.font),{color:d,padding:h}=s,u=c.size,g=u/2;let p;t.drawTitle(),n.textAlign=l.textAlign("left"),n.textBaseline="middle",n.lineWidth=.5,n.font=c.string;const{boxWidth:f,boxHeight:m,itemHeight:x}=getBoxSize(s,u),b=t.isHorizontal(),_=this._computeTitleHeight();p=b?{x:_alignStartEnd(o,t.left+h,t.right-a[0]),y:t.top+h+_,line:0}:{x:t.left+h,y:_alignStartEnd(o,t.top+_+h,t.bottom-i[0].height),line:0},overrideTextDirection(t.ctx,e.textDirection);const y=x+h;t.legendItems.forEach(((e,v)=>{n.strokeStyle=e.fontColor||d,n.fillStyle=e.fontColor||d;const S=n.measureText(e.text).width,k=l.textAlign(e.textAlign||(e.textAlign=s.textAlign)),M=f+u/2+S;let D=p.x,w=p.y;l.setWidth(t.width),b?v>0&&D+M+h>t.right&&(w=p.y+=y,p.line++,D=p.x=_alignStartEnd(o,t.left+h,t.right-a[p.line])):v>0&&w+y>t.bottom&&(D=p.x=D+i[p.line].width+h,p.line++,w=p.y=_alignStartEnd(o,t.top+_+h,t.bottom-i[p.line].height));!function(t,e,i){if(isNaN(f)||f<=0||isNaN(m)||m<0)return;n.save();const a=valueOrDefault(i.lineWidth,1);if(n.fillStyle=valueOrDefault(i.fillStyle,r),n.lineCap=valueOrDefault(i.lineCap,"butt"),n.lineDashOffset=valueOrDefault(i.lineDashOffset,0),n.lineJoin=valueOrDefault(i.lineJoin,"miter"),n.lineWidth=a,n.strokeStyle=valueOrDefault(i.strokeStyle,r),n.setLineDash(valueOrDefault(i.lineDash,[])),s.usePointStyle){const o={radius:f*Math.SQRT2/2,pointStyle:i.pointStyle,rotation:i.rotation,borderWidth:a},s=l.xPlus(t,f/2);drawPoint(n,o,s,e+g)}else{const o=e+Math.max((u-m)/2,0),s=l.leftForLtr(t,f),r=toTRBLCorners(i.borderRadius);n.beginPath(),Object.values(r).some((t=>0!==t))?addRoundedRectPath(n,{x:s,y:o,w:f,h:m,radius:r}):n.rect(s,o,f,m),n.fill(),0!==a&&n.stroke()}n.restore()}(l.x(D),w,e),D=_textX(k,D+f+g,t.right),function(t,e,i){renderText(n,i.text,t,e+x/2,c,{strikethrough:i.hidden,textAlign:i.textAlign})}(l.x(D),w,e),b?p.x+=M+h:p.y+=y})),restoreTextDirection(t.ctx,e.textDirection)}drawTitle(){const t=this,e=t.options,i=e.title,a=toFont(i.font),n=toPadding(i.padding);if(!i.display)return;const o=getRtlAdapter(e.rtl,t.left,t.width),s=t.ctx,r=i.position,l=a.size/2,c=n.top+l;let d,h=t.left,u=t.width;if(this.isHorizontal())u=Math.max(...t.lineWidths),d=t.top+c,h=_alignStartEnd(e.align,h,t.right-u);else{const i=t.columnSizes.reduce(((t,e)=>Math.max(t,e.height)),0);d=c+_alignStartEnd(e.align,t.top,t.bottom-i-e.labels.padding-t._computeTitleHeight())}const g=_alignStartEnd(r,h,h+u);s.textAlign=o.textAlign(_toLeftRightCenter(r)),s.textBaseline="middle",s.strokeStyle=i.color,s.fillStyle=i.color,s.font=a.string,renderText(s,i.text,g,d,a)}_computeTitleHeight(){const t=this.options.title,e=toFont(t.font),i=toPadding(t.padding);return t.display?e.lineHeight+i.height:0}_getLegendItemAt(t,e){const i=this;let a,n,o;if(t>=i.left&&t<=i.right&&e>=i.top&&e<=i.bottom)for(o=i.legendHitBoxes,a=0;a<o.length;++a)if(n=o[a],t>=n.left&&t<=n.left+n.width&&e>=n.top&&e<=n.top+n.height)return i.legendItems[a];return null}handleEvent(t){const e=this,i=e.options;if(!isListened(t.type,i))return;const a=e._getLegendItemAt(t.x,t.y);if("mousemove"===t.type){const s=e._hoveredItem,r=(o=a,null!==(n=s)&&null!==o&&n.datasetIndex===o.datasetIndex&&n.index===o.index);s&&!r&&callback(i.onLeave,[t,s,e],e),e._hoveredItem=a,a&&!r&&callback(i.onHover,[t,a,e],e)}else a&&callback(i.onClick,[t,a,e],e);var n,o}}function isListened(t,e){return!("mousemove"!==t||!e.onHover&&!e.onLeave)||!(!e.onClick||"click"!==t&&"mouseup"!==t)}var plugin_legend={id:"legend",_element:Legend,start(t,e,i){const a=t.legend=new Legend({ctx:t.ctx,options:i,chart:t});layouts.configure(t,a,i),layouts.addBox(t,a)},stop(t){layouts.removeBox(t,t.legend),delete t.legend},beforeUpdate(t,e,i){const a=t.legend;layouts.configure(t,a,i),a.options=i},afterUpdate(t){const e=t.legend;e.buildLabels(),e.adjustHitBoxes()},afterEvent(t,e){e.replay||t.legend.handleEvent(e.event)},defaults:{display:!0,position:"top",align:"center",fullSize:!0,reverse:!1,weight:1e3,onClick(t,e,i){const a=e.datasetIndex,n=i.chart;n.isDatasetVisible(a)?(n.hide(a),e.hidden=!0):(n.show(a),e.hidden=!1)},onHover:null,onLeave:null,labels:{color:t=>t.chart.options.color,boxWidth:40,padding:10,generateLabels(t){const e=t.data.datasets,{labels:{usePointStyle:i,pointStyle:a,textAlign:n,color:o}}=t.legend.options;return t._getSortedDatasetMetas().map((t=>{const s=t.controller.getStyle(i?0:void 0),r=toPadding(s.borderWidth);return{text:e[t.index].label,fillStyle:s.backgroundColor,fontColor:o,hidden:!t.visible,lineCap:s.borderCapStyle,lineDash:s.borderDash,lineDashOffset:s.borderDashOffset,lineJoin:s.borderJoinStyle,lineWidth:(r.width+r.height)/4,strokeStyle:s.borderColor,pointStyle:a||s.pointStyle,rotation:s.rotation,textAlign:n||s.textAlign,borderRadius:0,datasetIndex:t.index}}),this)}},title:{color:t=>t.chart.options.color,display:!1,position:"center",text:""}},descriptors:{_scriptable:t=>!t.startsWith("on"),labels:{_scriptable:t=>!["generateLabels","filter","sort"].includes(t)}}};class Title extends Element{constructor(t){super(),this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this._padding=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e){const i=this,a=i.options;if(i.left=0,i.top=0,!a.display)return void(i.width=i.height=i.right=i.bottom=0);i.width=i.right=t,i.height=i.bottom=e;const n=isArray(a.text)?a.text.length:1;i._padding=toPadding(a.padding);const o=n*toFont(a.font).lineHeight+i._padding.height;i.isHorizontal()?i.height=o:i.width=o}isHorizontal(){const t=this.options.position;return"top"===t||"bottom"===t}_drawArgs(t){const{top:e,left:i,bottom:a,right:n,options:o}=this,s=o.align;let r,l,c,d=0;return this.isHorizontal()?(l=_alignStartEnd(s,i,n),c=e+t,r=n-i):("left"===o.position?(l=i+t,c=_alignStartEnd(s,a,e),d=-.5*PI):(l=n-t,c=_alignStartEnd(s,e,a),d=.5*PI),r=a-e),{titleX:l,titleY:c,maxWidth:r,rotation:d}}draw(){const t=this,e=t.ctx,i=t.options;if(!i.display)return;const a=toFont(i.font),n=a.lineHeight/2+t._padding.top,{titleX:o,titleY:s,maxWidth:r,rotation:l}=t._drawArgs(n);renderText(e,i.text,0,0,a,{color:i.color,maxWidth:r,rotation:l,textAlign:_toLeftRightCenter(i.align),textBaseline:"middle",translation:[o,s]})}}function createTitle(t,e){const i=new Title({ctx:t.ctx,options:e,chart:t});layouts.configure(t,i,e),layouts.addBox(t,i),t.titleBlock=i}var plugin_title={id:"title",_element:Title,start(t,e,i){createTitle(t,i)},stop(t){const e=t.titleBlock;layouts.removeBox(t,e),delete t.titleBlock},beforeUpdate(t,e,i){const a=t.titleBlock;layouts.configure(t,a,i),a.options=i},defaults:{align:"center",display:!1,font:{weight:"bold"},fullSize:!0,padding:10,position:"top",text:"",weight:2e3},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const positioners={average(t){if(!t.length)return!1;let e,i,a=0,n=0,o=0;for(e=0,i=t.length;e<i;++e){const i=t[e].element;if(i&&i.hasValue()){const t=i.tooltipPosition();a+=t.x,n+=t.y,++o}}return{x:a/o,y:n/o}},nearest(t,e){if(!t.length)return!1;let i,a,n,o=e.x,s=e.y,r=Number.POSITIVE_INFINITY;for(i=0,a=t.length;i<a;++i){const a=t[i].element;if(a&&a.hasValue()){const t=a.getCenterPoint(),i=distanceBetweenPoints(e,t);i<r&&(r=i,n=a)}}if(n){const t=n.tooltipPosition();o=t.x,s=t.y}return{x:o,y:s}}};function pushOrConcat(t,e){return e&&(isArray(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function splitNewlines(t){return("string"==typeof t||t instanceof String)&&t.indexOf("\n")>-1?t.split("\n"):t}function createTooltipItem(t,e){const{element:i,datasetIndex:a,index:n}=e,o=t.getDatasetMeta(a).controller,{label:s,value:r}=o.getLabelAndValue(n);return{chart:t,label:s,parsed:o.getParsed(n),raw:t.data.datasets[a].data[n],formattedValue:r,dataset:o.getDataset(),dataIndex:n,datasetIndex:a,element:i}}function getTooltipSize(t,e){const i=t._chart.ctx,{body:a,footer:n,title:o}=t,{boxWidth:s,boxHeight:r}=e,l=toFont(e.bodyFont),c=toFont(e.titleFont),d=toFont(e.footerFont),h=o.length,u=n.length,g=a.length,p=toPadding(e.padding);let f=p.height,m=0,x=a.reduce(((t,e)=>t+e.before.length+e.lines.length+e.after.length),0);if(x+=t.beforeBody.length+t.afterBody.length,h&&(f+=h*c.lineHeight+(h-1)*e.titleSpacing+e.titleMarginBottom),x){f+=g*(e.displayColors?Math.max(r,l.lineHeight):l.lineHeight)+(x-g)*l.lineHeight+(x-1)*e.bodySpacing}u&&(f+=e.footerMarginTop+u*d.lineHeight+(u-1)*e.footerSpacing);let b=0;const _=function(t){m=Math.max(m,i.measureText(t).width+b)};return i.save(),i.font=c.string,each(t.title,_),i.font=l.string,each(t.beforeBody.concat(t.afterBody),_),b=e.displayColors?s+2:0,each(a,(t=>{each(t.before,_),each(t.lines,_),each(t.after,_)})),b=0,i.font=d.string,each(t.footer,_),i.restore(),m+=p.width,{width:m,height:f}}function determineYAlign(t,e){const{y:i,height:a}=e;return i<a/2?"top":i>t.height-a/2?"bottom":"center"}function doesNotFitWithAlign(t,e,i,a){const{x:n,width:o}=a,s=i.caretSize+i.caretPadding;return"left"===t&&n+o+s>e.width||("right"===t&&n-o-s<0||void 0)}function determineXAlign(t,e,i,a){const{x:n,width:o}=i,{width:s,chartArea:{left:r,right:l}}=t;let c="center";return"center"===a?c=n<=(r+l)/2?"left":"right":n<=o/2?c="left":n>=s-o/2&&(c="right"),doesNotFitWithAlign(c,t,e,i)&&(c="center"),c}function determineAlignment(t,e,i){const a=e.yAlign||determineYAlign(t,i);return{xAlign:e.xAlign||determineXAlign(t,e,i,a),yAlign:a}}function alignX(t,e){let{x:i,width:a}=t;return"right"===e?i-=a:"center"===e&&(i-=a/2),i}function alignY(t,e,i){let{y:a,height:n}=t;return"top"===e?a+=i:a-="bottom"===e?n+i:n/2,a}function getBackgroundPoint(t,e,i,a){const{caretSize:n,caretPadding:o,cornerRadius:s}=t,{xAlign:r,yAlign:l}=i,c=n+o,d=s+o;let h=alignX(e,r);const u=alignY(e,l,c);return"center"===l?"left"===r?h+=c:"right"===r&&(h-=c):"left"===r?h-=d:"right"===r&&(h+=d),{x:_limitValue(h,0,a.width-e.width),y:_limitValue(u,0,a.height-e.height)}}function getAlignedX(t,e,i){const a=toPadding(i.padding);return"center"===e?t.x+t.width/2:"right"===e?t.x+t.width-a.right:t.x+a.left}function getBeforeAfterBodyLines(t){return pushOrConcat([],splitNewlines(t))}function createTooltipContext(t,e,i){return Object.assign(Object.create(t),{tooltip:e,tooltipItems:i,type:"tooltip"})}function overrideCallbacks(t,e){const i=e&&e.dataset&&e.dataset.tooltip&&e.dataset.tooltip.callbacks;return i?t.override(i):t}class Tooltip extends Element{constructor(t){super(),this.opacity=0,this._active=[],this._chart=t._chart,this._eventPosition=void 0,this._size=void 0,this._cachedAnimations=void 0,this._tooltipItems=[],this.$animations=void 0,this.$context=void 0,this.options=t.options,this.dataPoints=void 0,this.title=void 0,this.beforeBody=void 0,this.body=void 0,this.afterBody=void 0,this.footer=void 0,this.xAlign=void 0,this.yAlign=void 0,this.x=void 0,this.y=void 0,this.height=void 0,this.width=void 0,this.caretX=void 0,this.caretY=void 0,this.labelColors=void 0,this.labelPointStyles=void 0,this.labelTextColors=void 0}initialize(t){this.options=t,this._cachedAnimations=void 0,this.$context=void 0}_resolveAnimations(){const t=this,e=t._cachedAnimations;if(e)return e;const i=t._chart,a=t.options.setContext(t.getContext()),n=a.enabled&&i.options.animation&&a.animations,o=new Animations(t._chart,n);return n._cacheable&&(t._cachedAnimations=Object.freeze(o)),o}getContext(){const t=this;return t.$context||(t.$context=createTooltipContext(t._chart.getContext(),t,t._tooltipItems))}getTitle(t,e){const i=this,{callbacks:a}=e,n=a.beforeTitle.apply(i,[t]),o=a.title.apply(i,[t]),s=a.afterTitle.apply(i,[t]);let r=[];return r=pushOrConcat(r,splitNewlines(n)),r=pushOrConcat(r,splitNewlines(o)),r=pushOrConcat(r,splitNewlines(s)),r}getBeforeBody(t,e){return getBeforeAfterBodyLines(e.callbacks.beforeBody.apply(this,[t]))}getBody(t,e){const i=this,{callbacks:a}=e,n=[];return each(t,(t=>{const e={before:[],lines:[],after:[]},o=overrideCallbacks(a,t);pushOrConcat(e.before,splitNewlines(o.beforeLabel.call(i,t))),pushOrConcat(e.lines,o.label.call(i,t)),pushOrConcat(e.after,splitNewlines(o.afterLabel.call(i,t))),n.push(e)})),n}getAfterBody(t,e){return getBeforeAfterBodyLines(e.callbacks.afterBody.apply(this,[t]))}getFooter(t,e){const i=this,{callbacks:a}=e,n=a.beforeFooter.apply(i,[t]),o=a.footer.apply(i,[t]),s=a.afterFooter.apply(i,[t]);let r=[];return r=pushOrConcat(r,splitNewlines(n)),r=pushOrConcat(r,splitNewlines(o)),r=pushOrConcat(r,splitNewlines(s)),r}_createItems(t){const e=this,i=e._active,a=e._chart.data,n=[],o=[],s=[];let r,l,c=[];for(r=0,l=i.length;r<l;++r)c.push(createTooltipItem(e._chart,i[r]));return t.filter&&(c=c.filter(((e,i,n)=>t.filter(e,i,n,a)))),t.itemSort&&(c=c.sort(((e,i)=>t.itemSort(e,i,a)))),each(c,(i=>{const a=overrideCallbacks(t.callbacks,i);n.push(a.labelColor.call(e,i)),o.push(a.labelPointStyle.call(e,i)),s.push(a.labelTextColor.call(e,i))})),e.labelColors=n,e.labelPointStyles=o,e.labelTextColors=s,e.dataPoints=c,c}update(t,e){const i=this,a=i.options.setContext(i.getContext()),n=i._active;let o,s=[];if(n.length){const t=positioners[a.position].call(i,n,i._eventPosition);s=i._createItems(a),i.title=i.getTitle(s,a),i.beforeBody=i.getBeforeBody(s,a),i.body=i.getBody(s,a),i.afterBody=i.getAfterBody(s,a),i.footer=i.getFooter(s,a);const e=i._size=getTooltipSize(i,a),r=Object.assign({},t,e),l=determineAlignment(i._chart,a,r),c=getBackgroundPoint(a,r,l,i._chart);i.xAlign=l.xAlign,i.yAlign=l.yAlign,o={opacity:1,x:c.x,y:c.y,width:e.width,height:e.height,caretX:t.x,caretY:t.y}}else 0!==i.opacity&&(o={opacity:0});i._tooltipItems=s,i.$context=void 0,o&&i._resolveAnimations().update(i,o),t&&a.external&&a.external.call(i,{chart:i._chart,tooltip:i,replay:e})}drawCaret(t,e,i,a){const n=this.getCaretPosition(t,i,a);e.lineTo(n.x1,n.y1),e.lineTo(n.x2,n.y2),e.lineTo(n.x3,n.y3)}getCaretPosition(t,e,i){const{xAlign:a,yAlign:n}=this,{cornerRadius:o,caretSize:s}=i,{x:r,y:l}=t,{width:c,height:d}=e;let h,u,g,p,f,m;return"center"===n?(f=l+d/2,"left"===a?(h=r,u=h-s,p=f+s,m=f-s):(h=r+c,u=h+s,p=f-s,m=f+s),g=h):(u="left"===a?r+o+s:"right"===a?r+c-o-s:this.caretX,"top"===n?(p=l,f=p-s,h=u-s,g=u+s):(p=l+d,f=p+s,h=u+s,g=u-s),m=p),{x1:h,x2:u,x3:g,y1:p,y2:f,y3:m}}drawTitle(t,e,i){const a=this,n=a.title,o=n.length;let s,r,l;if(o){const c=getRtlAdapter(i.rtl,a.x,a.width);for(t.x=getAlignedX(a,i.titleAlign,i),e.textAlign=c.textAlign(i.titleAlign),e.textBaseline="middle",s=toFont(i.titleFont),r=i.titleSpacing,e.fillStyle=i.titleColor,e.font=s.string,l=0;l<o;++l)e.fillText(n[l],c.x(t.x),t.y+s.lineHeight/2),t.y+=s.lineHeight+r,l+1===o&&(t.y+=i.titleMarginBottom-r)}}_drawColorBox(t,e,i,a,n){const o=this,s=o.labelColors[i],r=o.labelPointStyles[i],{boxHeight:l,boxWidth:c}=n,d=toFont(n.bodyFont),h=getAlignedX(o,"left",n),u=a.x(h),g=l<d.lineHeight?(d.lineHeight-l)/2:0,p=e.y+g;if(n.usePointStyle){const e={radius:Math.min(c,l)/2,pointStyle:r.pointStyle,rotation:r.rotation,borderWidth:1},i=a.leftForLtr(u,c)+c/2,o=p+l/2;t.strokeStyle=n.multiKeyBackground,t.fillStyle=n.multiKeyBackground,drawPoint(t,e,i,o),t.strokeStyle=s.borderColor,t.fillStyle=s.backgroundColor,drawPoint(t,e,i,o)}else{t.lineWidth=s.borderWidth||1,t.strokeStyle=s.borderColor,t.setLineDash(s.borderDash||[]),t.lineDashOffset=s.borderDashOffset||0;const e=a.leftForLtr(u,c),i=a.leftForLtr(a.xPlus(u,1),c-2),o=toTRBLCorners(s.borderRadius);Object.values(o).some((t=>0!==t))?(t.beginPath(),t.fillStyle=n.multiKeyBackground,addRoundedRectPath(t,{x:e,y:p,w:c,h:l,radius:o}),t.fill(),t.stroke(),t.fillStyle=s.backgroundColor,t.beginPath(),addRoundedRectPath(t,{x:i,y:p+1,w:c-2,h:l-2,radius:o}),t.fill()):(t.fillStyle=n.multiKeyBackground,t.fillRect(e,p,c,l),t.strokeRect(e,p,c,l),t.fillStyle=s.backgroundColor,t.fillRect(i,p+1,c-2,l-2))}t.fillStyle=o.labelTextColors[i]}drawBody(t,e,i){const a=this,{body:n}=a,{bodySpacing:o,bodyAlign:s,displayColors:r,boxHeight:l,boxWidth:c}=i,d=toFont(i.bodyFont);let h=d.lineHeight,u=0;const g=getRtlAdapter(i.rtl,a.x,a.width),p=function(i){e.fillText(i,g.x(t.x+u),t.y+h/2),t.y+=h+o},f=g.textAlign(s);let m,x,b,_,y,v,S;for(e.textAlign=s,e.textBaseline="middle",e.font=d.string,t.x=getAlignedX(a,f,i),e.fillStyle=i.bodyColor,each(a.beforeBody,p),u=r&&"right"!==f?"center"===s?c/2+1:c+2:0,_=0,v=n.length;_<v;++_){for(m=n[_],x=a.labelTextColors[_],e.fillStyle=x,each(m.before,p),b=m.lines,r&&b.length&&(a._drawColorBox(e,t,_,g,i),h=Math.max(d.lineHeight,l)),y=0,S=b.length;y<S;++y)p(b[y]),h=d.lineHeight;each(m.after,p)}u=0,h=d.lineHeight,each(a.afterBody,p),t.y-=o}drawFooter(t,e,i){const a=this,n=a.footer,o=n.length;let s,r;if(o){const l=getRtlAdapter(i.rtl,a.x,a.width);for(t.x=getAlignedX(a,i.footerAlign,i),t.y+=i.footerMarginTop,e.textAlign=l.textAlign(i.footerAlign),e.textBaseline="middle",s=toFont(i.footerFont),e.fillStyle=i.footerColor,e.font=s.string,r=0;r<o;++r)e.fillText(n[r],l.x(t.x),t.y+s.lineHeight/2),t.y+=s.lineHeight+i.footerSpacing}}drawBackground(t,e,i,a){const{xAlign:n,yAlign:o}=this,{x:s,y:r}=t,{width:l,height:c}=i,d=a.cornerRadius;e.fillStyle=a.backgroundColor,e.strokeStyle=a.borderColor,e.lineWidth=a.borderWidth,e.beginPath(),e.moveTo(s+d,r),"top"===o&&this.drawCaret(t,e,i,a),e.lineTo(s+l-d,r),e.quadraticCurveTo(s+l,r,s+l,r+d),"center"===o&&"right"===n&&this.drawCaret(t,e,i,a),e.lineTo(s+l,r+c-d),e.quadraticCurveTo(s+l,r+c,s+l-d,r+c),"bottom"===o&&this.drawCaret(t,e,i,a),e.lineTo(s+d,r+c),e.quadraticCurveTo(s,r+c,s,r+c-d),"center"===o&&"left"===n&&this.drawCaret(t,e,i,a),e.lineTo(s,r+d),e.quadraticCurveTo(s,r,s+d,r),e.closePath(),e.fill(),a.borderWidth>0&&e.stroke()}_updateAnimationTarget(t){const e=this,i=e._chart,a=e.$animations,n=a&&a.x,o=a&&a.y;if(n||o){const a=positioners[t.position].call(e,e._active,e._eventPosition);if(!a)return;const s=e._size=getTooltipSize(e,t),r=Object.assign({},a,e._size),l=determineAlignment(i,t,r),c=getBackgroundPoint(t,r,l,i);n._to===c.x&&o._to===c.y||(e.xAlign=l.xAlign,e.yAlign=l.yAlign,e.width=s.width,e.height=s.height,e.caretX=a.x,e.caretY=a.y,e._resolveAnimations().update(e,c))}}draw(t){const e=this,i=e.options.setContext(e.getContext());let a=e.opacity;if(!a)return;e._updateAnimationTarget(i);const n={width:e.width,height:e.height},o={x:e.x,y:e.y};a=Math.abs(a)<.001?0:a;const s=toPadding(i.padding),r=e.title.length||e.beforeBody.length||e.body.length||e.afterBody.length||e.footer.length;i.enabled&&r&&(t.save(),t.globalAlpha=a,e.drawBackground(o,t,n,i),overrideTextDirection(t,i.textDirection),o.y+=s.top,e.drawTitle(o,t,i),e.drawBody(o,t,i),e.drawFooter(o,t,i),restoreTextDirection(t,i.textDirection),t.restore())}getActiveElements(){return this._active||[]}setActiveElements(t,e){const i=this,a=i._active,n=t.map((({datasetIndex:t,index:e})=>{const a=i._chart.getDatasetMeta(t);if(!a)throw new Error("Cannot find a dataset at index "+t);return{datasetIndex:t,element:a.data[e],index:e}})),o=!_elementsEqual(a,n),s=i._positionChanged(n,e);(o||s)&&(i._active=n,i._eventPosition=e,i.update(!0))}handleEvent(t,e){const i=this,a=i.options,n=i._active||[];let o=!1,s=[];"mouseout"!==t.type&&(s=i._chart.getElementsAtEventForMode(t,a.mode,a,e),a.reverse&&s.reverse());const r=i._positionChanged(s,t);return o=e||!_elementsEqual(s,n)||r,o&&(i._active=s,(a.enabled||a.external)&&(i._eventPosition={x:t.x,y:t.y},i.update(!0,e))),o}_positionChanged(t,e){const{caretX:i,caretY:a,options:n}=this,o=positioners[n.position].call(this,t,e);return!1!==o&&(i!==o.x||a!==o.y)}}Tooltip.positioners=positioners;var plugin_tooltip={id:"tooltip",_element:Tooltip,positioners:positioners,afterInit(t,e,i){i&&(t.tooltip=new Tooltip({_chart:t,options:i}))},beforeUpdate(t,e,i){t.tooltip&&t.tooltip.initialize(i)},reset(t,e,i){t.tooltip&&t.tooltip.initialize(i)},afterDraw(t){const e=t.tooltip,i={tooltip:e};!1!==t.notifyPlugins("beforeTooltipDraw",i)&&(e&&e.draw(t.ctx),t.notifyPlugins("afterTooltipDraw",i))},afterEvent(t,e){if(t.tooltip){const i=e.replay;t.tooltip.handleEvent(e.event,i)&&(e.changed=!0)}},defaults:{enabled:!0,external:null,position:"average",backgroundColor:"rgba(0,0,0,0.8)",titleColor:"#fff",titleFont:{weight:"bold"},titleSpacing:2,titleMarginBottom:6,titleAlign:"left",bodyColor:"#fff",bodySpacing:2,bodyFont:{},bodyAlign:"left",footerColor:"#fff",footerSpacing:2,footerMarginTop:6,footerFont:{weight:"bold"},footerAlign:"left",padding:6,caretPadding:2,caretSize:5,cornerRadius:6,boxHeight:(t,e)=>e.bodyFont.size,boxWidth:(t,e)=>e.bodyFont.size,multiKeyBackground:"#fff",displayColors:!0,borderColor:"rgba(0,0,0,0)",borderWidth:0,animation:{duration:400,easing:"easeOutQuart"},animations:{numbers:{type:"number",properties:["x","y","width","height","caretX","caretY"]},opacity:{easing:"linear",duration:200}},callbacks:{beforeTitle:noop,title(t){if(t.length>0){const e=t[0],i=e.chart.data.labels,a=i?i.length:0;if(this&&this.options&&"dataset"===this.options.mode)return e.dataset.label||"";if(e.label)return e.label;if(a>0&&e.dataIndex<a)return i[e.dataIndex]}return""},afterTitle:noop,beforeBody:noop,beforeLabel:noop,label(t){if(this&&this.options&&"dataset"===this.options.mode)return t.label+": "+t.formattedValue||t.formattedValue;let e=t.dataset.label||"";e&&(e+=": ");const i=t.formattedValue;return isNullOrUndef(i)||(e+=i),e},labelColor(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{borderColor:e.borderColor,backgroundColor:e.backgroundColor,borderWidth:e.borderWidth,borderDash:e.borderDash,borderDashOffset:e.borderDashOffset,borderRadius:0}},labelTextColor(){return this.options.bodyColor},labelPointStyle(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{pointStyle:e.pointStyle,rotation:e.rotation}},afterLabel:noop,afterBody:noop,beforeFooter:noop,footer:noop,afterFooter:noop}},defaultRoutes:{bodyFont:"font",footerFont:"font",titleFont:"font"},descriptors:{_scriptable:t=>"filter"!==t&&"itemSort"!==t&&"external"!==t,_indexable:!1,callbacks:{_scriptable:!1,_indexable:!1},animation:{_fallback:!1},animations:{_fallback:"animation"}},additionalOptionScopes:["interaction"]},plugins=Object.freeze({__proto__:null,Decimation:plugin_decimation,Filler:plugin_filler,Legend:plugin_legend,Title:plugin_title,Tooltip:plugin_tooltip});const addIfString=(t,e,i)=>"string"==typeof e?t.push(e)-1:isNaN(e)?null:i;function findOrAddLabel(t,e,i){const a=t.indexOf(e);if(-1===a)return addIfString(t,e,i);return a!==t.lastIndexOf(e)?i:a}const validIndex=(t,e)=>null===t?null:_limitValue(Math.round(t),0,e);class CategoryScale extends Scale{constructor(t){super(t),this._startValue=void 0,this._valueRange=0}parse(t,e){if(isNullOrUndef(t))return null;const i=this.getLabels();return e=isFinite(e)&&i[e]===t?e:findOrAddLabel(i,t,valueOrDefault(e,t)),validIndex(e,i.length-1)}determineDataLimits(){const t=this,{minDefined:e,maxDefined:i}=t.getUserBounds();let{min:a,max:n}=t.getMinMax(!0);"ticks"===t.options.bounds&&(e||(a=0),i||(n=t.getLabels().length-1)),t.min=a,t.max=n}buildTicks(){const t=this,e=t.min,i=t.max,a=t.options.offset,n=[];let o=t.getLabels();o=0===e&&i===o.length-1?o:o.slice(e,i+1),t._valueRange=Math.max(o.length-(a?0:1),1),t._startValue=t.min-(a?.5:0);for(let t=e;t<=i;t++)n.push({value:t});return n}getLabelForValue(t){const e=this.getLabels();return t>=0&&t<e.length?e[t]:t}configure(){const t=this;super.configure(),t.isHorizontal()||(t._reversePixels=!t._reversePixels)}getPixelForValue(t){const e=this;return"number"!=typeof t&&(t=e.parse(t)),null===t?NaN:e.getPixelForDecimal((t-e._startValue)/e._valueRange)}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getValueForPixel(t){const e=this;return Math.round(e._startValue+e.getDecimalForPixel(t)*e._valueRange)}getBasePixel(){return this.bottom}}function generateTicks$1(t,e){const i=[],{bounds:a,step:n,min:o,max:s,precision:r,count:l,maxTicks:c,maxDigits:d,includeBounds:h}=t,u=n||1,g=c-1,{min:p,max:f}=e,m=!isNullOrUndef(o),x=!isNullOrUndef(s),b=!isNullOrUndef(l),_=(f-p)/(d+1);let y,v,S,k,M=niceNum((f-p)/g/u)*u;if(M<1e-14&&!m&&!x)return[{value:p},{value:f}];k=Math.ceil(f/M)-Math.floor(p/M),k>g&&(M=niceNum(k*M/g/u)*u),isNullOrUndef(r)||(y=Math.pow(10,r),M=Math.ceil(M*y)/y),"ticks"===a?(v=Math.floor(p/M)*M,S=Math.ceil(f/M)*M):(v=p,S=f),m&&x&&n&&almostWhole((s-o)/n,M/1e3)?(k=Math.min((s-o)/M,c),M=(s-o)/k,v=o,S=s):b?(v=m?o:v,S=x?s:S,k=l-1,M=(S-v)/k):(k=(S-v)/M,k=almostEquals(k,Math.round(k),M/1e3)?Math.round(k):Math.ceil(k));const D=Math.max(_decimalPlaces(M),_decimalPlaces(v));y=Math.pow(10,isNullOrUndef(r)?D:r),v=Math.round(v*y)/y,S=Math.round(S*y)/y;let w=0;for(m&&(h&&v!==o?(i.push({value:o}),v<o&&w++,almostEquals(Math.round((v+w*M)*y)/y,o,relativeLabelSize(o,_,t))&&w++):v<o&&w++);w<k;++w)i.push({value:Math.round((v+w*M)*y)/y});return x&&h&&S!==s?almostEquals(i[i.length-1].value,s,relativeLabelSize(s,_,t))?i[i.length-1].value=s:i.push({value:s}):x&&S!==s||i.push({value:S}),i}function relativeLabelSize(t,e,{horizontal:i,minRotation:a}){const n=toRadians(a),o=(i?Math.sin(n):Math.cos(n))||.001,s=.75*e*(""+t).length;return Math.min(e/o,s)}CategoryScale.id="category",CategoryScale.defaults={ticks:{callback:CategoryScale.prototype.getLabelForValue}};class LinearScaleBase extends Scale{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0}parse(t,e){return isNullOrUndef(t)||("number"==typeof t||t instanceof Number)&&!isFinite(+t)?null:+t}handleTickRangeOptions(){const t=this,{beginAtZero:e}=t.options,{minDefined:i,maxDefined:a}=t.getUserBounds();let{min:n,max:o}=t;const s=t=>n=i?n:t,r=t=>o=a?o:t;if(e){const t=sign(n),e=sign(o);t<0&&e<0?r(0):t>0&&e>0&&s(0)}n===o&&(r(o+1),e||s(n-1)),t.min=n,t.max=o}getTickLimit(){const t=this,e=t.options.ticks;let i,{maxTicksLimit:a,stepSize:n}=e;return n?i=Math.ceil(t.max/n)-Math.floor(t.min/n)+1:(i=t.computeTickLimit(),a=a||11),a&&(i=Math.min(a,i)),i}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const t=this,e=t.options,i=e.ticks;let a=t.getTickLimit();a=Math.max(2,a);const n=generateTicks$1({maxTicks:a,bounds:e.bounds,min:e.min,max:e.max,precision:i.precision,step:i.stepSize,count:i.count,maxDigits:t._maxDigits(),horizontal:t.isHorizontal(),minRotation:i.minRotation||0,includeBounds:!1!==i.includeBounds},t._range||t);return"ticks"===e.bounds&&_setMinAndMaxByKey(n,t,"value"),e.reverse?(n.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),n}configure(){const t=this,e=t.ticks;let i=t.min,a=t.max;if(super.configure(),t.options.offset&&e.length){const t=(a-i)/Math.max(e.length-1,1)/2;i-=t,a+=t}t._startValue=i,t._endValue=a,t._valueRange=a-i}getLabelForValue(t){return formatNumber(t,this.chart.options.locale)}}class LinearScale extends LinearScaleBase{determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!0);t.min=isNumberFinite(e)?e:0,t.max=isNumberFinite(i)?i:1,t.handleTickRangeOptions()}computeTickLimit(){const t=this,e=t.isHorizontal(),i=e?t.width:t.height,a=toRadians(t.options.ticks.minRotation),n=(e?Math.sin(a):Math.cos(a))||.001,o=t._resolveTickFontOptions(0);return Math.ceil(i/Math.min(40,o.lineHeight/n))}getPixelForValue(t){return null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getValueForPixel(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange}}function isMajor(t){return 1===t/Math.pow(10,Math.floor(log10(t)))}function generateTicks(t,e){const i=Math.floor(log10(e.max)),a=Math.ceil(e.max/Math.pow(10,i)),n=[];let o=finiteOrDefault(t.min,Math.pow(10,Math.floor(log10(e.min)))),s=Math.floor(log10(o)),r=Math.floor(o/Math.pow(10,s)),l=s<0?Math.pow(10,Math.abs(s)):1;do{n.push({value:o,major:isMajor(o)}),++r,10===r&&(r=1,++s,l=s>=0?1:l),o=Math.round(r*Math.pow(10,s)*l)/l}while(s<i||s===i&&r<a);const c=finiteOrDefault(t.max,o);return n.push({value:c,major:isMajor(o)}),n}LinearScale.id="linear",LinearScale.defaults={ticks:{callback:Ticks.formatters.numeric}};class LogarithmicScale extends Scale{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0}parse(t,e){const i=LinearScaleBase.prototype.parse.apply(this,[t,e]);if(0!==i)return isNumberFinite(i)&&i>0?i:null;this._zero=!0}determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!0);t.min=isNumberFinite(e)?Math.max(0,e):null,t.max=isNumberFinite(i)?Math.max(0,i):null,t.options.beginAtZero&&(t._zero=!0),t.handleTickRangeOptions()}handleTickRangeOptions(){const t=this,{minDefined:e,maxDefined:i}=t.getUserBounds();let a=t.min,n=t.max;const o=t=>a=e?a:t,s=t=>n=i?n:t,r=(t,e)=>Math.pow(10,Math.floor(log10(t))+e);a===n&&(a<=0?(o(1),s(10)):(o(r(a,-1)),s(r(n,1)))),a<=0&&o(r(n,-1)),n<=0&&s(r(a,1)),t._zero&&t.min!==t._suggestedMin&&a===r(t.min,0)&&o(r(a,-1)),t.min=a,t.max=n}buildTicks(){const t=this,e=t.options,i=generateTicks({min:t._userMin,max:t._userMax},t);return"ticks"===e.bounds&&_setMinAndMaxByKey(i,t,"value"),e.reverse?(i.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max),i}getLabelForValue(t){return void 0===t?"0":formatNumber(t,this.chart.options.locale)}configure(){const t=this,e=t.min;super.configure(),t._startValue=log10(e),t._valueRange=log10(t.max)-log10(e)}getPixelForValue(t){const e=this;return void 0!==t&&0!==t||(t=e.min),null===t||isNaN(t)?NaN:e.getPixelForDecimal(t===e.min?0:(log10(t)-e._startValue)/e._valueRange)}getValueForPixel(t){const e=this,i=e.getDecimalForPixel(t);return Math.pow(10,e._startValue+i*e._valueRange)}}function getTickBackdropHeight(t){const e=t.ticks;if(e.display&&t.display){const t=toPadding(e.backdropPadding);return valueOrDefault(e.font&&e.font.size,defaults.font.size)+t.height}return 0}function measureLabelSize(t,e,i){return isArray(i)?{w:_longestText(t,t.font,i),h:i.length*e}:{w:t.measureText(i).width,h:e}}function determineLimits(t,e,i,a,n){return t===a||t===n?{start:e-i/2,end:e+i/2}:t<a||t>n?{start:e-i,end:e}:{start:e,end:e+i}}function fitWithPointLabels(t){const e={l:0,r:t.width,t:0,b:t.height-t.paddingTop},i={};let a,n,o;const s=[],r=[],l=t.getLabels().length;for(a=0;a<l;a++){const l=t.options.pointLabels.setContext(t.getContext(a));r[a]=l.padding,o=t.getPointPosition(a,t.drawingArea+r[a]);const c=toFont(l.font);t.ctx.font=c.string,n=measureLabelSize(t.ctx,c.lineHeight,t._pointLabels[a]),s[a]=n;const d=t.getIndexAngle(a),h=toDegrees(d),u=determineLimits(h,o.x,n.w,0,180),g=determineLimits(h,o.y,n.h,90,270);u.start<e.l&&(e.l=u.start,i.l=d),u.end>e.r&&(e.r=u.end,i.r=d),g.start<e.t&&(e.t=g.start,i.t=d),g.end>e.b&&(e.b=g.end,i.b=d)}t._setReductions(t.drawingArea,e,i),t._pointLabelItems=[];const c=t.options,d=getTickBackdropHeight(c),h=t.getDistanceFromCenterForValue(c.ticks.reverse?t.min:t.max);for(a=0;a<l;a++){const e=0===a?d/2:0,i=t.getPointPosition(a,h+e+r[a]),n=toDegrees(t.getIndexAngle(a)),o=s[a];adjustPointPositionForLabelHeight(n,o,i);const l=getTextAlignForAngle(n);let c;c="left"===l?i.x:"center"===l?i.x-o.w/2:i.x-o.w;const u=c+o.w;t._pointLabelItems[a]={x:i.x,y:i.y,textAlign:l,left:c,top:i.y,right:u,bottom:i.y+o.h}}}function getTextAlignForAngle(t){return 0===t||180===t?"center":t<180?"left":"right"}function adjustPointPositionForLabelHeight(t,e,i){90===t||270===t?i.y-=e.h/2:(t>270||t<90)&&(i.y-=e.h)}function drawPointLabels(t,e){const{ctx:i,options:{pointLabels:a}}=t;for(let n=e-1;n>=0;n--){const e=a.setContext(t.getContext(n)),o=toFont(e.font),{x:s,y:r,textAlign:l,left:c,top:d,right:h,bottom:u}=t._pointLabelItems[n],{backdropColor:g}=e;if(!isNullOrUndef(g)){const t=toPadding(e.backdropPadding);i.fillStyle=g,i.fillRect(c-t.left,d-t.top,h-c+t.width,u-d+t.height)}renderText(i,t._pointLabels[n],s,r+o.lineHeight/2,o,{color:e.color,textAlign:l,textBaseline:"middle"})}}function pathRadiusLine(t,e,i,a){const{ctx:n}=t;if(i)n.arc(t.xCenter,t.yCenter,e,0,TAU);else{let i=t.getPointPosition(0,e);n.moveTo(i.x,i.y);for(let o=1;o<a;o++)i=t.getPointPosition(o,e),n.lineTo(i.x,i.y)}}function drawRadiusLine(t,e,i,a){const n=t.ctx,o=e.circular,{color:s,lineWidth:r}=e;!o&&!a||!s||!r||i<0||(n.save(),n.strokeStyle=s,n.lineWidth=r,n.setLineDash(e.borderDash),n.lineDashOffset=e.borderDashOffset,n.beginPath(),pathRadiusLine(t,i,o,a),n.closePath(),n.stroke(),n.restore())}function numberOrZero(t){return isNumber(t)?t:0}LogarithmicScale.id="logarithmic",LogarithmicScale.defaults={ticks:{callback:Ticks.formatters.logarithmic,major:{enabled:!0}}};class RadialLinearScale extends LinearScaleBase{constructor(t){super(t),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[]}setDimensions(){const t=this;t.width=t.maxWidth,t.height=t.maxHeight,t.paddingTop=getTickBackdropHeight(t.options)/2,t.xCenter=Math.floor(t.width/2),t.yCenter=Math.floor((t.height-t.paddingTop)/2),t.drawingArea=Math.min(t.height-t.paddingTop,t.width)/2}determineDataLimits(){const t=this,{min:e,max:i}=t.getMinMax(!1);t.min=isNumberFinite(e)&&!isNaN(e)?e:0,t.max=isNumberFinite(i)&&!isNaN(i)?i:0,t.handleTickRangeOptions()}computeTickLimit(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options))}generateTickLabels(t){const e=this;LinearScaleBase.prototype.generateTickLabels.call(e,t),e._pointLabels=e.getLabels().map(((t,i)=>{const a=callback(e.options.pointLabels.callback,[t,i],e);return a||0===a?a:""}))}fit(){const t=this,e=t.options;e.display&&e.pointLabels.display?fitWithPointLabels(t):t.setCenterPoint(0,0,0,0)}_setReductions(t,e,i){const a=this;let n=e.l/Math.sin(i.l),o=Math.max(e.r-a.width,0)/Math.sin(i.r),s=-e.t/Math.cos(i.t),r=-Math.max(e.b-(a.height-a.paddingTop),0)/Math.cos(i.b);n=numberOrZero(n),o=numberOrZero(o),s=numberOrZero(s),r=numberOrZero(r),a.drawingArea=Math.max(t/2,Math.min(Math.floor(t-(n+o)/2),Math.floor(t-(s+r)/2))),a.setCenterPoint(n,o,s,r)}setCenterPoint(t,e,i,a){const n=this,o=n.width-e-n.drawingArea,s=t+n.drawingArea,r=i+n.drawingArea,l=n.height-n.paddingTop-a-n.drawingArea;n.xCenter=Math.floor((s+o)/2+n.left),n.yCenter=Math.floor((r+l)/2+n.top+n.paddingTop)}getIndexAngle(t){const e=TAU/this.getLabels().length,i=this.options.startAngle||0;return _normalizeAngle(t*e+toRadians(i))}getDistanceFromCenterForValue(t){const e=this;if(isNullOrUndef(t))return NaN;const i=e.drawingArea/(e.max-e.min);return e.options.reverse?(e.max-t)*i:(t-e.min)*i}getValueForDistanceFromCenter(t){if(isNullOrUndef(t))return NaN;const e=this,i=t/(e.drawingArea/(e.max-e.min));return e.options.reverse?e.max-i:e.min+i}getPointPosition(t,e){const i=this,a=i.getIndexAngle(t)-HALF_PI;return{x:Math.cos(a)*e+i.xCenter,y:Math.sin(a)*e+i.yCenter,angle:a}}getPointPositionForValue(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))}getBasePosition(t){return this.getPointPositionForValue(t||0,this.getBaseValue())}getPointLabelPosition(t){const{left:e,top:i,right:a,bottom:n}=this._pointLabelItems[t];return{left:e,top:i,right:a,bottom:n}}drawBackground(){const t=this,{backgroundColor:e,grid:{circular:i}}=t.options;if(e){const a=t.ctx;a.save(),a.beginPath(),pathRadiusLine(t,t.getDistanceFromCenterForValue(t._endValue),i,t.getLabels().length),a.closePath(),a.fillStyle=e,a.fill(),a.restore()}}drawGrid(){const t=this,e=t.ctx,i=t.options,{angleLines:a,grid:n}=i,o=t.getLabels().length;let s,r,l;if(i.pointLabels.display&&drawPointLabels(t,o),n.display&&t.ticks.forEach(((e,i)=>{if(0!==i){r=t.getDistanceFromCenterForValue(e.value);const a=n.setContext(t.getContext(i-1));drawRadiusLine(t,a,r,o)}})),a.display){for(e.save(),s=t.getLabels().length-1;s>=0;s--){const n=a.setContext(t.getContext(s)),{color:o,lineWidth:c}=n;c&&o&&(e.lineWidth=c,e.strokeStyle=o,e.setLineDash(n.borderDash),e.lineDashOffset=n.borderDashOffset,r=t.getDistanceFromCenterForValue(i.ticks.reverse?t.min:t.max),l=t.getPointPosition(s,r),e.beginPath(),e.moveTo(t.xCenter,t.yCenter),e.lineTo(l.x,l.y),e.stroke())}e.restore()}}drawBorder(){}drawLabels(){const t=this,e=t.ctx,i=t.options,a=i.ticks;if(!a.display)return;const n=t.getIndexAngle(0);let o,s;e.save(),e.translate(t.xCenter,t.yCenter),e.rotate(n),e.textAlign="center",e.textBaseline="middle",t.ticks.forEach(((n,r)=>{if(0===r&&!i.reverse)return;const l=a.setContext(t.getContext(r)),c=toFont(l.font);if(o=t.getDistanceFromCenterForValue(t.ticks[r].value),l.showLabelBackdrop){s=e.measureText(n.label).width,e.fillStyle=l.backdropColor;const t=toPadding(l.backdropPadding);e.fillRect(-s/2-t.left,-o-c.size/2-t.top,s+t.width,c.size+t.height)}renderText(e,n.label,0,-o,c,{color:l.color})})),e.restore()}drawTitle(){}}RadialLinearScale.id="radialLinear",RadialLinearScale.defaults={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:Ticks.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:t=>t,padding:5}},RadialLinearScale.defaultRoutes={"angleLines.color":"borderColor","pointLabels.color":"color","ticks.color":"color"},RadialLinearScale.descriptors={angleLines:{_fallback:"grid"}};const INTERVALS={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},UNITS=Object.keys(INTERVALS);function sorter(t,e){return t-e}function parse(t,e){if(isNullOrUndef(e))return null;const i=t._adapter,{parser:a,round:n,isoWeekday:o}=t._parseOpts;let s=e;return"function"==typeof a&&(s=a(s)),isNumberFinite(s)||(s="string"==typeof a?i.parse(s,a):i.parse(s)),null===s?null:(n&&(s="week"!==n||!isNumber(o)&&!0!==o?i.startOf(s,n):i.startOf(s,"isoWeek",o)),+s)}function determineUnitForAutoTicks(t,e,i,a){const n=UNITS.length;for(let o=UNITS.indexOf(t);o<n-1;++o){const t=INTERVALS[UNITS[o]],n=t.steps?t.steps:Number.MAX_SAFE_INTEGER;if(t.common&&Math.ceil((i-e)/(n*t.size))<=a)return UNITS[o]}return UNITS[n-1]}function determineUnitForFormatting(t,e,i,a,n){for(let o=UNITS.length-1;o>=UNITS.indexOf(i);o--){const i=UNITS[o];if(INTERVALS[i].common&&t._adapter.diff(n,a,i)>=e-1)return i}return UNITS[i?UNITS.indexOf(i):0]}function determineMajorUnit(t){for(let e=UNITS.indexOf(t)+1,i=UNITS.length;e<i;++e)if(INTERVALS[UNITS[e]].common)return UNITS[e]}function addTick(t,e,i){if(i){if(i.length){const{lo:a,hi:n}=_lookup(i,e);t[i[a]>=e?i[a]:i[n]]=!0}}else t[e]=!0}function setMajorTicks(t,e,i,a){const n=t._adapter,o=+n.startOf(e[0].value,a),s=e[e.length-1].value;let r,l;for(r=o;r<=s;r=+n.add(r,1,a))l=i[r],l>=0&&(e[l].major=!0);return e}function ticksFromTimestamps(t,e,i){const a=[],n={},o=e.length;let s,r;for(s=0;s<o;++s)r=e[s],n[r]=s,a.push({value:r,major:!1});return 0!==o&&i?setMajorTicks(t,a,n,i):a}class TimeScale extends Scale{constructor(t){super(t),this._cache={data:[],labels:[],all:[]},this._unit="day",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0}init(t,e){const i=t.time||(t.time={}),a=this._adapter=new adapters._date(t.adapters.date);mergeIf(i.displayFormats,a.formats()),this._parseOpts={parser:i.parser,round:i.round,isoWeekday:i.isoWeekday},super.init(t),this._normalized=e.normalized}parse(t,e){return void 0===t?null:parse(this,t)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]}}determineDataLimits(){const t=this,e=t.options,i=t._adapter,a=e.time.unit||"day";let{min:n,max:o,minDefined:s,maxDefined:r}=t.getUserBounds();function l(t){s||isNaN(t.min)||(n=Math.min(n,t.min)),r||isNaN(t.max)||(o=Math.max(o,t.max))}s&&r||(l(t._getLabelBounds()),"ticks"===e.bounds&&"labels"===e.ticks.source||l(t.getMinMax(!1))),n=isNumberFinite(n)&&!isNaN(n)?n:+i.startOf(Date.now(),a),o=isNumberFinite(o)&&!isNaN(o)?o:+i.endOf(Date.now(),a)+1,t.min=Math.min(n,o-1),t.max=Math.max(n+1,o)}_getLabelBounds(){const t=this.getLabelTimestamps();let e=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY;return t.length&&(e=t[0],i=t[t.length-1]),{min:e,max:i}}buildTicks(){const t=this,e=t.options,i=e.time,a=e.ticks,n="labels"===a.source?t.getLabelTimestamps():t._generate();"ticks"===e.bounds&&n.length&&(t.min=t._userMin||n[0],t.max=t._userMax||n[n.length-1]);const o=t.min,s=t.max,r=_filterBetween(n,o,s);return t._unit=i.unit||(a.autoSkip?determineUnitForAutoTicks(i.minUnit,t.min,t.max,t._getLabelCapacity(o)):determineUnitForFormatting(t,r.length,i.minUnit,t.min,t.max)),t._majorUnit=a.major.enabled&&"year"!==t._unit?determineMajorUnit(t._unit):void 0,t.initOffsets(n),e.reverse&&r.reverse(),ticksFromTimestamps(t,r,t._majorUnit)}initOffsets(t){const e=this;let i,a,n=0,o=0;e.options.offset&&t.length&&(i=e.getDecimalForValue(t[0]),n=1===t.length?1-i:(e.getDecimalForValue(t[1])-i)/2,a=e.getDecimalForValue(t[t.length-1]),o=1===t.length?a:(a-e.getDecimalForValue(t[t.length-2]))/2);const s=t.length<3?.5:.25;n=_limitValue(n,0,s),o=_limitValue(o,0,s),e._offsets={start:n,end:o,factor:1/(n+1+o)}}_generate(){const t=this,e=t._adapter,i=t.min,a=t.max,n=t.options,o=n.time,s=o.unit||determineUnitForAutoTicks(o.minUnit,i,a,t._getLabelCapacity(i)),r=valueOrDefault(o.stepSize,1),l="week"===s&&o.isoWeekday,c=isNumber(l)||!0===l,d={};let h,u,g=i;if(c&&(g=+e.startOf(g,"isoWeek",l)),g=+e.startOf(g,c?"day":s),e.diff(a,i,s)>1e5*r)throw new Error(i+" and "+a+" are too far apart with stepSize of "+r+" "+s);const p="data"===n.ticks.source&&t.getDataTimestamps();for(h=g,u=0;h<a;h=+e.add(h,r,s),u++)addTick(d,h,p);return h!==a&&"ticks"!==n.bounds&&1!==u||addTick(d,h,p),Object.keys(d).sort(((t,e)=>t-e)).map((t=>+t))}getLabelForValue(t){const e=this._adapter,i=this.options.time;return i.tooltipFormat?e.format(t,i.tooltipFormat):e.format(t,i.displayFormats.datetime)}_tickFormatFunction(t,e,i,a){const n=this,o=n.options,s=o.time.displayFormats,r=n._unit,l=n._majorUnit,c=r&&s[r],d=l&&s[l],h=i[e],u=l&&d&&h&&h.major,g=n._adapter.format(t,a||(u?d:c)),p=o.ticks.callback;return p?callback(p,[g,e,i],n):g}generateTickLabels(t){let e,i,a;for(e=0,i=t.length;e<i;++e)a=t[e],a.label=this._tickFormatFunction(a.value,e,t)}getDecimalForValue(t){const e=this;return null===t?NaN:(t-e.min)/(e.max-e.min)}getPixelForValue(t){const e=this,i=e._offsets,a=e.getDecimalForValue(t);return e.getPixelForDecimal((i.start+a)*i.factor)}getValueForPixel(t){const e=this,i=e._offsets,a=e.getDecimalForPixel(t)/i.factor-i.end;return e.min+a*(e.max-e.min)}_getLabelSize(t){const e=this,i=e.options.ticks,a=e.ctx.measureText(t).width,n=toRadians(e.isHorizontal()?i.maxRotation:i.minRotation),o=Math.cos(n),s=Math.sin(n),r=e._resolveTickFontOptions(0).size;return{w:a*o+r*s,h:a*s+r*o}}_getLabelCapacity(t){const e=this,i=e.options.time,a=i.displayFormats,n=a[i.unit]||a.millisecond,o=e._tickFormatFunction(t,0,ticksFromTimestamps(e,[t],e._majorUnit),n),s=e._getLabelSize(o),r=Math.floor(e.isHorizontal()?e.width/s.w:e.height/s.h)-1;return r>0?r:1}getDataTimestamps(){const t=this;let e,i,a=t._cache.data||[];if(a.length)return a;const n=t.getMatchingVisibleMetas();if(t._normalized&&n.length)return t._cache.data=n[0].controller.getAllParsedValues(t);for(e=0,i=n.length;e<i;++e)a=a.concat(n[e].controller.getAllParsedValues(t));return t._cache.data=t.normalize(a)}getLabelTimestamps(){const t=this,e=t._cache.labels||[];let i,a;if(e.length)return e;const n=t.getLabels();for(i=0,a=n.length;i<a;++i)e.push(parse(t,n[i]));return t._cache.labels=t._normalized?e:t.normalize(e)}normalize(t){return _arrayUnique(t.sort(sorter))}}function interpolate(t,e,i){let a,n,o,s;if(i)a=Math.floor(e),n=Math.ceil(e),o=t[a],s=t[n];else{const i=_lookup(t,e);o=i.lo,s=i.hi,a=t[o],n=t[s]}const r=n-a;return r?o+(s-o)*(e-a)/r:o}TimeScale.id="time",TimeScale.defaults={bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{source:"auto",major:{enabled:!1}}};class TimeSeriesScale extends TimeScale{constructor(t){super(t),this._table=[],this._maxIndex=void 0}initOffsets(){const t=this,e=t._getTimestampsForTable();t._table=t.buildLookupTable(e),t._maxIndex=t._table.length-1,super.initOffsets(e)}buildLookupTable(t){const{min:e,max:i}=this;if(!t.length)return[{time:e,pos:0},{time:i,pos:1}];const a=[e];let n,o,s;for(n=0,o=t.length;n<o;++n)s=t[n],s>e&&s<i&&a.push(s);return a.push(i),a}_getTimestampsForTable(){const t=this;let e=t._cache.all||[];if(e.length)return e;const i=t.getDataTimestamps(),a=t.getLabelTimestamps();return e=i.length&&a.length?t.normalize(i.concat(a)):i.length?i:a,e=t._cache.all=e,e}getPixelForValue(t,e){const i=this,a=i._offsets,n=i._normalized&&i._maxIndex>0&&!isNullOrUndef(e)?e/i._maxIndex:i.getDecimalForValue(t);return i.getPixelForDecimal((a.start+n)*a.factor)}getDecimalForValue(t){return interpolate(this._table,t)/this._maxIndex}getValueForPixel(t){const e=this,i=e._offsets,a=e.getDecimalForPixel(t)/i.factor-i.end;return interpolate(e._table,a*this._maxIndex,!0)}}TimeSeriesScale.id="timeseries",TimeSeriesScale.defaults=TimeScale.defaults;var scales=Object.freeze({__proto__:null,CategoryScale:CategoryScale,LinearScale:LinearScale,LogarithmicScale:LogarithmicScale,RadialLinearScale:RadialLinearScale,TimeScale:TimeScale,TimeSeriesScale:TimeSeriesScale});const registerables=[controllers,elements,plugins,scales];export{Animation,Animations,ArcElement,BarController,BarElement,BasePlatform,BasicPlatform,BubbleController,CategoryScale,Chart,DatasetController,plugin_decimation as Decimation,DomPlatform,DoughnutController,Element,plugin_filler as Filler,Interaction,plugin_legend as Legend,LineController,LineElement,LinearScale,LogarithmicScale,PieController,PointElement,PolarAreaController,RadarController,RadialLinearScale,Scale,ScatterController,Ticks,TimeScale,TimeSeriesScale,plugin_title as Title,plugin_tooltip as Tooltip,adapters as _adapters,animator,controllers,elements,layouts,plugins,registerables,registry,scales};
//# sourceMappingURL=/sm/07f6695829b8ee6ba95d87b85447208da661371db6686b8698d462f261c1e3c6.map