/**
 * Minified by jsDelivr using Terser v5.3.5.
 * Original file: /npm/chart.js@3.3.2/dist/chunks/helpers.segment.js
 *
 * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files
 */
/*!
 * Chart.js v3.3.2
 * https://www.chartjs.org
 * (c) 2021 Chart.js Contributors
 * Released under the MIT License
 */
function fontString(e,t,n){return t+" "+e+"px "+n}const requestAnimFrame="undefined"==typeof window?function(e){return e()}:window.requestAnimationFrame;function throttled(e,t,n){const r=n||(e=>Array.prototype.slice.call(e));let o=!1,i=[];return function(...n){i=r(n),o||(o=!0,requestAnimFrame.call(window,(()=>{o=!1,e.apply(t,i)})))}}function debounce(e,t){let n;return function(){return t?(clearTimeout(n),n=setTimeout(e,t)):e(),t}}const _toLeftRightCenter=e=>"start"===e?"left":"end"===e?"right":"center",_alignStartEnd=(e,t,n)=>"start"===e?t:"end"===e?n:(t+n)/2,_textX=(e,t,n)=>"right"===e?n:"center"===e?(t+n)/2:t;function noop(){}const uid=function(){let e=0;return function(){return e++}}();function isNullOrUndef(e){return null==e}function isArray(e){if(Array.isArray&&Array.isArray(e))return!0;const t=Object.prototype.toString.call(e);return"[object"===t.substr(0,7)&&"Array]"===t.substr(-6)}function isObject(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}const isNumberFinite=e=>("number"==typeof e||e instanceof Number)&&isFinite(+e);function finiteOrDefault(e,t){return isNumberFinite(e)?e:t}function valueOrDefault(e,t){return void 0===e?t:e}const toPercentage=(e,t)=>"string"==typeof e&&e.endsWith("%")?parseFloat(e)/100:e/t,toDimension=(e,t)=>"string"==typeof e&&e.endsWith("%")?parseFloat(e)/100*t:+e;function callback(e,t,n){if(e&&"function"==typeof e.call)return e.apply(n,t)}function each(e,t,n,r){let o,i,a;if(isArray(e))if(i=e.length,r)for(o=i-1;o>=0;o--)t.call(n,e[o],o);else for(o=0;o<i;o++)t.call(n,e[o],o);else if(isObject(e))for(a=Object.keys(e),i=a.length,o=0;o<i;o++)t.call(n,e[a[o]],a[o])}function _elementsEqual(e,t){let n,r,o,i;if(!e||!t||e.length!==t.length)return!1;for(n=0,r=e.length;n<r;++n)if(o=e[n],i=t[n],o.datasetIndex!==i.datasetIndex||o.index!==i.index)return!1;return!0}function clone$1(e){if(isArray(e))return e.map(clone$1);if(isObject(e)){const t=Object.create(null),n=Object.keys(e),r=n.length;let o=0;for(;o<r;++o)t[n[o]]=clone$1(e[n[o]]);return t}return e}function isValidKey(e){return-1===["__proto__","prototype","constructor"].indexOf(e)}function _merger(e,t,n,r){if(!isValidKey(e))return;const o=t[e],i=n[e];isObject(o)&&isObject(i)?merge(o,i,r):t[e]=clone$1(i)}function merge(e,t,n){const r=isArray(t)?t:[t],o=r.length;if(!isObject(e))return e;const i=(n=n||{}).merger||_merger;for(let a=0;a<o;++a){if(!isObject(t=r[a]))continue;const o=Object.keys(t);for(let r=0,a=o.length;r<a;++r)i(o[r],e,t,n)}return e}function mergeIf(e,t){return merge(e,t,{merger:_mergerIf})}function _mergerIf(e,t,n){if(!isValidKey(e))return;const r=t[e],o=n[e];isObject(r)&&isObject(o)?mergeIf(r,o):Object.prototype.hasOwnProperty.call(t,e)||(t[e]=clone$1(o))}function _deprecated(e,t,n,r){void 0!==t&&console.warn(e+': "'+n+'" is deprecated. Please use "'+r+'" instead')}const emptyString="",dot=".";function indexOfDotOrLength(e,t){const n=e.indexOf(".",t);return-1===n?e.length:n}function resolveObjectKey(e,t){if(""===t)return e;let n=0,r=indexOfDotOrLength(t,n);for(;e&&r>n;)e=e[t.substr(n,r-n)],n=r+1,r=indexOfDotOrLength(t,n);return e}function _capitalize(e){return e.charAt(0).toUpperCase()+e.slice(1)}const defined=e=>void 0!==e,isFunction=e=>"function"==typeof e,setsEqual=(e,t)=>{if(e.size!==t.size)return!1;for(const n of e)if(!t.has(n))return!1;return!0},PI=Math.PI,TAU=2*PI,PITAU=TAU+PI,INFINITY=Number.POSITIVE_INFINITY,RAD_PER_DEG=PI/180,HALF_PI=PI/2,QUARTER_PI=PI/4,TWO_THIRDS_PI=2*PI/3,log10=Math.log10,sign=Math.sign;function niceNum(e){const t=Math.pow(10,Math.floor(log10(e))),n=e/t;return(n<=1?1:n<=2?2:n<=5?5:10)*t}function _factorize(e){const t=[],n=Math.sqrt(e);let r;for(r=1;r<n;r++)e%r==0&&(t.push(r),t.push(e/r));return n===(0|n)&&t.push(n),t.sort(((e,t)=>e-t)).pop(),t}function isNumber(e){return!isNaN(parseFloat(e))&&isFinite(e)}function almostEquals(e,t,n){return Math.abs(e-t)<n}function almostWhole(e,t){const n=Math.round(e);return n-t<=e&&n+t>=e}function _setMinAndMaxByKey(e,t,n){let r,o,i;for(r=0,o=e.length;r<o;r++)i=e[r][n],isNaN(i)||(t.min=Math.min(t.min,i),t.max=Math.max(t.max,i))}function toRadians(e){return e*(PI/180)}function toDegrees(e){return e*(180/PI)}function _decimalPlaces(e){if(!isNumberFinite(e))return;let t=1,n=0;for(;Math.round(e*t)/t!==e;)t*=10,n++;return n}function getAngleFromPoint(e,t){const n=t.x-e.x,r=t.y-e.y,o=Math.sqrt(n*n+r*r);let i=Math.atan2(r,n);return i<-.5*PI&&(i+=TAU),{angle:i,distance:o}}function distanceBetweenPoints(e,t){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}function _angleDiff(e,t){return(e-t+PITAU)%TAU-PI}function _normalizeAngle(e){return(e%TAU+TAU)%TAU}function _angleBetween(e,t,n,r){const o=_normalizeAngle(e),i=_normalizeAngle(t),a=_normalizeAngle(n),s=_normalizeAngle(i-o),l=_normalizeAngle(a-o),c=_normalizeAngle(o-i),u=_normalizeAngle(o-a);return o===i||o===a||r&&i===a||s>l&&c<u}function _limitValue(e,t,n){return Math.max(t,Math.min(n,e))}function _int16Range(e){return _limitValue(e,-32768,32767)}const atEdge=e=>0===e||1===e,elasticIn=(e,t,n)=>-Math.pow(2,10*(e-=1))*Math.sin((e-t)*TAU/n),elasticOut=(e,t,n)=>Math.pow(2,-10*e)*Math.sin((e-t)*TAU/n)+1,effects={linear:e=>e,easeInQuad:e=>e*e,easeOutQuad:e=>-e*(e-2),easeInOutQuad:e=>(e/=.5)<1?.5*e*e:-.5*(--e*(e-2)-1),easeInCubic:e=>e*e*e,easeOutCubic:e=>(e-=1)*e*e+1,easeInOutCubic:e=>(e/=.5)<1?.5*e*e*e:.5*((e-=2)*e*e+2),easeInQuart:e=>e*e*e*e,easeOutQuart:e=>-((e-=1)*e*e*e-1),easeInOutQuart:e=>(e/=.5)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2),easeInQuint:e=>e*e*e*e*e,easeOutQuint:e=>(e-=1)*e*e*e*e+1,easeInOutQuint:e=>(e/=.5)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2),easeInSine:e=>1-Math.cos(e*HALF_PI),easeOutSine:e=>Math.sin(e*HALF_PI),easeInOutSine:e=>-.5*(Math.cos(PI*e)-1),easeInExpo:e=>0===e?0:Math.pow(2,10*(e-1)),easeOutExpo:e=>1===e?1:1-Math.pow(2,-10*e),easeInOutExpo:e=>atEdge(e)?e:e<.5?.5*Math.pow(2,10*(2*e-1)):.5*(2-Math.pow(2,-10*(2*e-1))),easeInCirc:e=>e>=1?e:-(Math.sqrt(1-e*e)-1),easeOutCirc:e=>Math.sqrt(1-(e-=1)*e),easeInOutCirc:e=>(e/=.5)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1),easeInElastic:e=>atEdge(e)?e:elasticIn(e,.075,.3),easeOutElastic:e=>atEdge(e)?e:elasticOut(e,.075,.3),easeInOutElastic(e){const t=.1125;return atEdge(e)?e:e<.5?.5*elasticIn(2*e,t,.45):.5+.5*elasticOut(2*e-1,t,.45)},easeInBack(e){const t=1.70158;return e*e*((t+1)*e-t)},easeOutBack(e){const t=1.70158;return(e-=1)*e*((t+1)*e+t)+1},easeInOutBack(e){let t=1.70158;return(e/=.5)<1?e*e*((1+(t*=1.525))*e-t)*.5:.5*((e-=2)*e*((1+(t*=1.525))*e+t)+2)},easeInBounce:e=>1-effects.easeOutBounce(1-e),easeOutBounce(e){const t=7.5625,n=2.75;return e<1/n?t*e*e:e<2/n?t*(e-=1.5/n)*e+.75:e<2.5/n?t*(e-=2.25/n)*e+.9375:t*(e-=2.625/n)*e+.984375},easeInOutBounce:e=>e<.5?.5*effects.easeInBounce(2*e):.5*effects.easeOutBounce(2*e-1)+.5},map={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},hex="0123456789ABCDEF",h1=e=>hex[15&e],h2=e=>hex[(240&e)>>4]+hex[15&e],eq=e=>(240&e)>>4==(15&e);function isShort(e){return eq(e.r)&&eq(e.g)&&eq(e.b)&&eq(e.a)}function hexParse(e){var t,n=e.length;return"#"===e[0]&&(4===n||5===n?t={r:255&17*map[e[1]],g:255&17*map[e[2]],b:255&17*map[e[3]],a:5===n?17*map[e[4]]:255}:7!==n&&9!==n||(t={r:map[e[1]]<<4|map[e[2]],g:map[e[3]]<<4|map[e[4]],b:map[e[5]]<<4|map[e[6]],a:9===n?map[e[7]]<<4|map[e[8]]:255})),t}function hexString(e){var t=isShort(e)?h1:h2;return e?"#"+t(e.r)+t(e.g)+t(e.b)+(e.a<255?t(e.a):""):e}function round(e){return e+.5|0}const lim=(e,t,n)=>Math.max(Math.min(e,n),t);function p2b(e){return lim(round(2.55*e),0,255)}function n2b(e){return lim(round(255*e),0,255)}function b2n(e){return lim(round(e/2.55)/100,0,1)}function n2p(e){return lim(round(100*e),0,100)}const RGB_RE=/^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;function rgbParse(e){const t=RGB_RE.exec(e);let n,r,o,i=255;if(t){if(t[7]!==n){const e=+t[7];i=255&(t[8]?p2b(e):255*e)}return n=+t[1],r=+t[3],o=+t[5],n=255&(t[2]?p2b(n):n),r=255&(t[4]?p2b(r):r),o=255&(t[6]?p2b(o):o),{r:n,g:r,b:o,a:i}}}function rgbString(e){return e&&(e.a<255?`rgba(${e.r}, ${e.g}, ${e.b}, ${b2n(e.a)})`:`rgb(${e.r}, ${e.g}, ${e.b})`)}const HUE_RE=/^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;function hsl2rgbn(e,t,n){const r=t*Math.min(n,1-n),o=(t,o=(t+e/30)%12)=>n-r*Math.max(Math.min(o-3,9-o,1),-1);return[o(0),o(8),o(4)]}function hsv2rgbn(e,t,n){const r=(r,o=(r+e/60)%6)=>n-n*t*Math.max(Math.min(o,4-o,1),0);return[r(5),r(3),r(1)]}function hwb2rgbn(e,t,n){const r=hsl2rgbn(e,1,.5);let o;for(t+n>1&&(o=1/(t+n),t*=o,n*=o),o=0;o<3;o++)r[o]*=1-t-n,r[o]+=t;return r}function rgb2hsl(e){const t=e.r/255,n=e.g/255,r=e.b/255,o=Math.max(t,n,r),i=Math.min(t,n,r),a=(o+i)/2;let s,l,c;return o!==i&&(c=o-i,l=a>.5?c/(2-o-i):c/(o+i),s=o===t?(n-r)/c+(n<r?6:0):o===n?(r-t)/c+2:(t-n)/c+4,s=60*s+.5),[0|s,l||0,a]}function calln(e,t,n,r){return(Array.isArray(t)?e(t[0],t[1],t[2]):e(t,n,r)).map(n2b)}function hsl2rgb(e,t,n){return calln(hsl2rgbn,e,t,n)}function hwb2rgb(e,t,n){return calln(hwb2rgbn,e,t,n)}function hsv2rgb(e,t,n){return calln(hsv2rgbn,e,t,n)}function hue(e){return(e%360+360)%360}function hueParse(e){const t=HUE_RE.exec(e);let n,r=255;if(!t)return;t[5]!==n&&(r=t[6]?p2b(+t[5]):n2b(+t[5]));const o=hue(+t[2]),i=+t[3]/100,a=+t[4]/100;return n="hwb"===t[1]?hwb2rgb(o,i,a):"hsv"===t[1]?hsv2rgb(o,i,a):hsl2rgb(o,i,a),{r:n[0],g:n[1],b:n[2],a:r}}function rotate(e,t){var n=rgb2hsl(e);n[0]=hue(n[0]+t),n=hsl2rgb(n),e.r=n[0],e.g=n[1],e.b=n[2]}function hslString(e){if(!e)return;const t=rgb2hsl(e),n=t[0],r=n2p(t[1]),o=n2p(t[2]);return e.a<255?`hsla(${n}, ${r}%, ${o}%, ${b2n(e.a)})`:`hsl(${n}, ${r}%, ${o}%)`}const map$1={x:"dark",Z:"light",Y:"re",X:"blu",W:"gr",V:"medium",U:"slate",A:"ee",T:"ol",S:"or",B:"ra",C:"lateg",D:"ights",R:"in",Q:"turquois",E:"hi",P:"ro",O:"al",N:"le",M:"de",L:"yello",F:"en",K:"ch",G:"arks",H:"ea",I:"ightg",J:"wh"},names={OiceXe:"f0f8ff",antiquewEte:"faebd7",aqua:"ffff",aquamarRe:"7fffd4",azuY:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"0",blanKedOmond:"ffebcd",Xe:"ff",XeviTet:"8a2be2",bPwn:"a52a2a",burlywood:"deb887",caMtXe:"5f9ea0",KartYuse:"7fff00",KocTate:"d2691e",cSO:"ff7f50",cSnflowerXe:"6495ed",cSnsilk:"fff8dc",crimson:"dc143c",cyan:"ffff",xXe:"8b",xcyan:"8b8b",xgTMnPd:"b8860b",xWay:"a9a9a9",xgYF:"6400",xgYy:"a9a9a9",xkhaki:"bdb76b",xmagFta:"8b008b",xTivegYF:"556b2f",xSange:"ff8c00",xScEd:"9932cc",xYd:"8b0000",xsOmon:"e9967a",xsHgYF:"8fbc8f",xUXe:"483d8b",xUWay:"2f4f4f",xUgYy:"2f4f4f",xQe:"ced1",xviTet:"9400d3",dAppRk:"ff1493",dApskyXe:"bfff",dimWay:"696969",dimgYy:"696969",dodgerXe:"1e90ff",fiYbrick:"b22222",flSOwEte:"fffaf0",foYstWAn:"228b22",fuKsia:"ff00ff",gaRsbSo:"dcdcdc",ghostwEte:"f8f8ff",gTd:"ffd700",gTMnPd:"daa520",Way:"808080",gYF:"8000",gYFLw:"adff2f",gYy:"808080",honeyMw:"f0fff0",hotpRk:"ff69b4",RdianYd:"cd5c5c",Rdigo:"4b0082",ivSy:"fffff0",khaki:"f0e68c",lavFMr:"e6e6fa",lavFMrXsh:"fff0f5",lawngYF:"7cfc00",NmoncEffon:"fffacd",ZXe:"add8e6",ZcSO:"f08080",Zcyan:"e0ffff",ZgTMnPdLw:"fafad2",ZWay:"d3d3d3",ZgYF:"90ee90",ZgYy:"d3d3d3",ZpRk:"ffb6c1",ZsOmon:"ffa07a",ZsHgYF:"20b2aa",ZskyXe:"87cefa",ZUWay:"778899",ZUgYy:"778899",ZstAlXe:"b0c4de",ZLw:"ffffe0",lime:"ff00",limegYF:"32cd32",lRF:"faf0e6",magFta:"ff00ff",maPon:"800000",VaquamarRe:"66cdaa",VXe:"cd",VScEd:"ba55d3",VpurpN:"9370db",VsHgYF:"3cb371",VUXe:"7b68ee",VsprRggYF:"fa9a",VQe:"48d1cc",VviTetYd:"c71585",midnightXe:"191970",mRtcYam:"f5fffa",mistyPse:"ffe4e1",moccasR:"ffe4b5",navajowEte:"ffdead",navy:"80",Tdlace:"fdf5e6",Tive:"808000",TivedBb:"6b8e23",Sange:"ffa500",SangeYd:"ff4500",ScEd:"da70d6",pOegTMnPd:"eee8aa",pOegYF:"98fb98",pOeQe:"afeeee",pOeviTetYd:"db7093",papayawEp:"ffefd5",pHKpuff:"ffdab9",peru:"cd853f",pRk:"ffc0cb",plum:"dda0dd",powMrXe:"b0e0e6",purpN:"800080",YbeccapurpN:"663399",Yd:"ff0000",Psybrown:"bc8f8f",PyOXe:"4169e1",saddNbPwn:"8b4513",sOmon:"fa8072",sandybPwn:"f4a460",sHgYF:"2e8b57",sHshell:"fff5ee",siFna:"a0522d",silver:"c0c0c0",skyXe:"87ceeb",UXe:"6a5acd",UWay:"708090",UgYy:"708090",snow:"fffafa",sprRggYF:"ff7f",stAlXe:"4682b4",tan:"d2b48c",teO:"8080",tEstN:"d8bfd8",tomato:"ff6347",Qe:"40e0d0",viTet:"ee82ee",JHt:"f5deb3",wEte:"ffffff",wEtesmoke:"f5f5f5",Lw:"ffff00",LwgYF:"9acd32"};function unpack(){const e={},t=Object.keys(names),n=Object.keys(map$1);let r,o,i,a,s;for(r=0;r<t.length;r++){for(a=s=t[r],o=0;o<n.length;o++)i=n[o],s=s.replace(i,map$1[i]);i=parseInt(names[a],16),e[s]=[i>>16&255,i>>8&255,255&i]}return e}let names$1;function nameParse(e){names$1||(names$1=unpack(),names$1.transparent=[0,0,0,0]);const t=names$1[e.toLowerCase()];return t&&{r:t[0],g:t[1],b:t[2],a:4===t.length?t[3]:255}}function modHSL(e,t,n){if(e){let r=rgb2hsl(e);r[t]=Math.max(0,Math.min(r[t]+r[t]*n,0===t?360:1)),r=hsl2rgb(r),e.r=r[0],e.g=r[1],e.b=r[2]}}function clone(e,t){return e?Object.assign(t||{},e):e}function fromObject(e){var t={r:0,g:0,b:0,a:255};return Array.isArray(e)?e.length>=3&&(t={r:e[0],g:e[1],b:e[2],a:255},e.length>3&&(t.a=n2b(e[3]))):(t=clone(e,{r:0,g:0,b:0,a:1})).a=n2b(t.a),t}function functionParse(e){return"r"===e.charAt(0)?rgbParse(e):hueParse(e)}class Color{constructor(e){if(e instanceof Color)return e;const t=typeof e;let n;"object"===t?n=fromObject(e):"string"===t&&(n=hexParse(e)||nameParse(e)||functionParse(e)),this._rgb=n,this._valid=!!n}get valid(){return this._valid}get rgb(){var e=clone(this._rgb);return e&&(e.a=b2n(e.a)),e}set rgb(e){this._rgb=fromObject(e)}rgbString(){return this._valid?rgbString(this._rgb):this._rgb}hexString(){return this._valid?hexString(this._rgb):this._rgb}hslString(){return this._valid?hslString(this._rgb):this._rgb}mix(e,t){const n=this;if(e){const r=n.rgb,o=e.rgb;let i;const a=t===i?.5:t,s=2*a-1,l=r.a-o.a,c=((s*l==-1?s:(s+l)/(1+s*l))+1)/2;i=1-c,r.r=255&c*r.r+i*o.r+.5,r.g=255&c*r.g+i*o.g+.5,r.b=255&c*r.b+i*o.b+.5,r.a=a*r.a+(1-a)*o.a,n.rgb=r}return n}clone(){return new Color(this.rgb)}alpha(e){return this._rgb.a=n2b(e),this}clearer(e){return this._rgb.a*=1-e,this}greyscale(){const e=this._rgb,t=round(.3*e.r+.59*e.g+.11*e.b);return e.r=e.g=e.b=t,this}opaquer(e){return this._rgb.a*=1+e,this}negate(){const e=this._rgb;return e.r=255-e.r,e.g=255-e.g,e.b=255-e.b,this}lighten(e){return modHSL(this._rgb,2,e),this}darken(e){return modHSL(this._rgb,2,-e),this}saturate(e){return modHSL(this._rgb,1,e),this}desaturate(e){return modHSL(this._rgb,1,-e),this}rotate(e){return rotate(this._rgb,e),this}}function index_esm(e){return new Color(e)}const isPatternOrGradient=e=>e instanceof CanvasGradient||e instanceof CanvasPattern;function color(e){return isPatternOrGradient(e)?e:index_esm(e)}function getHoverColor(e){return isPatternOrGradient(e)?e:index_esm(e).saturate(.5).darken(.1).hexString()}const overrides=Object.create(null),descriptors=Object.create(null);function getScope$1(e,t){if(!t)return e;const n=t.split(".");for(let t=0,r=n.length;t<r;++t){const r=n[t];e=e[r]||(e[r]=Object.create(null))}return e}function set(e,t,n){return"string"==typeof t?merge(getScope$1(e,t),n):merge(getScope$1(e,""),t)}class Defaults{constructor(e){this.animation=void 0,this.backgroundColor="rgba(0,0,0,0.1)",this.borderColor="rgba(0,0,0,0.1)",this.color="#666",this.datasets={},this.devicePixelRatio=e=>e.chart.platform.getDevicePixelRatio(),this.elements={},this.events=["mousemove","mouseout","click","touchstart","touchmove"],this.font={family:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",size:12,style:"normal",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(e,t)=>getHoverColor(t.backgroundColor),this.hoverBorderColor=(e,t)=>getHoverColor(t.borderColor),this.hoverColor=(e,t)=>getHoverColor(t.color),this.indexAxis="x",this.interaction={mode:"nearest",intersect:!0},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.describe(e)}set(e,t){return set(this,e,t)}get(e){return getScope$1(this,e)}describe(e,t){return set(descriptors,e,t)}override(e,t){return set(overrides,e,t)}route(e,t,n,r){const o=getScope$1(this,e),i=getScope$1(this,n),a="_"+t;Object.defineProperties(o,{[a]:{value:o[t],writable:!0},[t]:{enumerable:!0,get(){const e=this[a],t=i[r];return isObject(e)?Object.assign({},t,e):valueOrDefault(e,t)},set(e){this[a]=e}}})}}var defaults=new Defaults({_scriptable:e=>!e.startsWith("on"),_indexable:e=>"events"!==e,hover:{_fallback:"interaction"},interaction:{_scriptable:!1,_indexable:!1}});function toFontString(e){return!e||isNullOrUndef(e.size)||isNullOrUndef(e.family)?null:(e.style?e.style+" ":"")+(e.weight?e.weight+" ":"")+e.size+"px "+e.family}function _measureText(e,t,n,r,o){let i=t[o];return i||(i=t[o]=e.measureText(o).width,n.push(o)),i>r&&(r=i),r}function _longestText(e,t,n,r){let o=(r=r||{}).data=r.data||{},i=r.garbageCollect=r.garbageCollect||[];r.font!==t&&(o=r.data={},i=r.garbageCollect=[],r.font=t),e.save(),e.font=t;let a=0;const s=n.length;let l,c,u,f,d;for(l=0;l<s;l++)if(f=n[l],null!=f&&!0!==isArray(f))a=_measureText(e,o,i,a,f);else if(isArray(f))for(c=0,u=f.length;c<u;c++)d=f[c],null==d||isArray(d)||(a=_measureText(e,o,i,a,d));e.restore();const h=i.length/2;if(h>n.length){for(l=0;l<h;l++)delete o[i[l]];i.splice(0,h)}return a}function _alignPixel(e,t,n){const r=e.currentDevicePixelRatio,o=0!==n?Math.max(n/2,.5):0;return Math.round((t-o)*r)/r+o}function clearCanvas(e,t){(t=t||e.getContext("2d")).save(),t.resetTransform(),t.clearRect(0,0,e.width,e.height),t.restore()}function drawPoint(e,t,n,r){let o,i,a,s,l;const c=t.pointStyle,u=t.rotation,f=t.radius;let d=(u||0)*RAD_PER_DEG;if(c&&"object"==typeof c&&(o=c.toString(),"[object HTMLImageElement]"===o||"[object HTMLCanvasElement]"===o))return e.save(),e.translate(n,r),e.rotate(d),e.drawImage(c,-c.width/2,-c.height/2,c.width,c.height),void e.restore();if(!(isNaN(f)||f<=0)){switch(e.beginPath(),c){default:e.arc(n,r,f,0,TAU),e.closePath();break;case"triangle":e.moveTo(n+Math.sin(d)*f,r-Math.cos(d)*f),d+=TWO_THIRDS_PI,e.lineTo(n+Math.sin(d)*f,r-Math.cos(d)*f),d+=TWO_THIRDS_PI,e.lineTo(n+Math.sin(d)*f,r-Math.cos(d)*f),e.closePath();break;case"rectRounded":l=.516*f,s=f-l,i=Math.cos(d+QUARTER_PI)*s,a=Math.sin(d+QUARTER_PI)*s,e.arc(n-i,r-a,l,d-PI,d-HALF_PI),e.arc(n+a,r-i,l,d-HALF_PI,d),e.arc(n+i,r+a,l,d,d+HALF_PI),e.arc(n-a,r+i,l,d+HALF_PI,d+PI),e.closePath();break;case"rect":if(!u){s=Math.SQRT1_2*f,e.rect(n-s,r-s,2*s,2*s);break}d+=QUARTER_PI;case"rectRot":i=Math.cos(d)*f,a=Math.sin(d)*f,e.moveTo(n-i,r-a),e.lineTo(n+a,r-i),e.lineTo(n+i,r+a),e.lineTo(n-a,r+i),e.closePath();break;case"crossRot":d+=QUARTER_PI;case"cross":i=Math.cos(d)*f,a=Math.sin(d)*f,e.moveTo(n-i,r-a),e.lineTo(n+i,r+a),e.moveTo(n+a,r-i),e.lineTo(n-a,r+i);break;case"star":i=Math.cos(d)*f,a=Math.sin(d)*f,e.moveTo(n-i,r-a),e.lineTo(n+i,r+a),e.moveTo(n+a,r-i),e.lineTo(n-a,r+i),d+=QUARTER_PI,i=Math.cos(d)*f,a=Math.sin(d)*f,e.moveTo(n-i,r-a),e.lineTo(n+i,r+a),e.moveTo(n+a,r-i),e.lineTo(n-a,r+i);break;case"line":i=Math.cos(d)*f,a=Math.sin(d)*f,e.moveTo(n-i,r-a),e.lineTo(n+i,r+a);break;case"dash":e.moveTo(n,r),e.lineTo(n+Math.cos(d)*f,r+Math.sin(d)*f)}e.fill(),t.borderWidth>0&&e.stroke()}}function _isPointInArea(e,t,n){return n=n||.5,e&&e.x>t.left-n&&e.x<t.right+n&&e.y>t.top-n&&e.y<t.bottom+n}function clipArea(e,t){e.save(),e.beginPath(),e.rect(t.left,t.top,t.right-t.left,t.bottom-t.top),e.clip()}function unclipArea(e){e.restore()}function _steppedLineTo(e,t,n,r,o){if(!t)return e.lineTo(n.x,n.y);if("middle"===o){const r=(t.x+n.x)/2;e.lineTo(r,t.y),e.lineTo(r,n.y)}else"after"===o!=!!r?e.lineTo(t.x,n.y):e.lineTo(n.x,t.y);e.lineTo(n.x,n.y)}function _bezierCurveTo(e,t,n,r){if(!t)return e.lineTo(n.x,n.y);e.bezierCurveTo(r?t.cp1x:t.cp2x,r?t.cp1y:t.cp2y,r?n.cp2x:n.cp1x,r?n.cp2y:n.cp1y,n.x,n.y)}function renderText(e,t,n,r,o,i={}){const a=isArray(t)?t:[t],s=i.strokeWidth>0&&""!==i.strokeColor;let l,c;for(e.save(),i.translation&&e.translate(i.translation[0],i.translation[1]),isNullOrUndef(i.rotation)||e.rotate(i.rotation),e.font=o.string,i.color&&(e.fillStyle=i.color),i.textAlign&&(e.textAlign=i.textAlign),i.textBaseline&&(e.textBaseline=i.textBaseline),l=0;l<a.length;++l){if(c=a[l],s&&(i.strokeColor&&(e.strokeStyle=i.strokeColor),isNullOrUndef(i.strokeWidth)||(e.lineWidth=i.strokeWidth),e.strokeText(c,n,r,i.maxWidth)),e.fillText(c,n,r,i.maxWidth),i.strikethrough||i.underline){const t=e.measureText(c),o=n-t.actualBoundingBoxLeft,a=n+t.actualBoundingBoxRight,s=r-t.actualBoundingBoxAscent,l=r+t.actualBoundingBoxDescent,u=i.strikethrough?(s+l)/2:l;e.strokeStyle=e.fillStyle,e.beginPath(),e.lineWidth=i.decorationWidth||2,e.moveTo(o,u),e.lineTo(a,u),e.stroke()}r+=o.lineHeight}e.restore()}function addRoundedRectPath(e,t){const{x:n,y:r,w:o,h:i,radius:a}=t;e.arc(n+a.topLeft,r+a.topLeft,a.topLeft,-HALF_PI,PI,!0),e.lineTo(n,r+i-a.bottomLeft),e.arc(n+a.bottomLeft,r+i-a.bottomLeft,a.bottomLeft,PI,HALF_PI,!0),e.lineTo(n+o-a.bottomRight,r+i),e.arc(n+o-a.bottomRight,r+i-a.bottomRight,a.bottomRight,HALF_PI,0,!0),e.lineTo(n+o,r+a.topRight),e.arc(n+o-a.topRight,r+a.topRight,a.topRight,0,-HALF_PI,!0),e.lineTo(n+a.topLeft,r)}const LINE_HEIGHT=new RegExp(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/),FONT_STYLE=new RegExp(/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/);function toLineHeight(e,t){const n=(""+e).match(LINE_HEIGHT);if(!n||"normal"===n[1])return 1.2*t;switch(e=+n[2],n[3]){case"px":return e;case"%":e/=100}return t*e}const numberOrZero=e=>+e||0;function _readValueToProps(e,t){const n={},r=isObject(t),o=r?Object.keys(t):t,i=isObject(e)?r?n=>valueOrDefault(e[n],e[t[n]]):t=>e[t]:()=>e;for(const e of o)n[e]=+i(e)||0;return n}function toTRBL(e){return _readValueToProps(e,{top:"y",right:"x",bottom:"y",left:"x"})}function toTRBLCorners(e){return _readValueToProps(e,["topLeft","topRight","bottomLeft","bottomRight"])}function toPadding(e){const t=toTRBL(e);return t.width=t.left+t.right,t.height=t.top+t.bottom,t}function toFont(e,t){e=e||{},t=t||defaults.font;let n=valueOrDefault(e.size,t.size);"string"==typeof n&&(n=parseInt(n,10));let r=valueOrDefault(e.style,t.style);r&&!(""+r).match(FONT_STYLE)&&(console.warn('Invalid font style specified: "'+r+'"'),r="");const o={family:valueOrDefault(e.family,t.family),lineHeight:toLineHeight(valueOrDefault(e.lineHeight,t.lineHeight),n),size:n,style:r,weight:valueOrDefault(e.weight,t.weight),string:""};return o.string=toFontString(o),o}function resolve(e,t,n,r){let o,i,a,s=!0;for(o=0,i=e.length;o<i;++o)if(a=e[o],void 0!==a&&(void 0!==t&&"function"==typeof a&&(a=a(t),s=!1),void 0!==n&&isArray(a)&&(a=a[n%a.length],s=!1),void 0!==a))return r&&!s&&(r.cacheable=!1),a}function _addGrace(e,t){const{min:n,max:r}=e;return{min:n-Math.abs(toDimension(t,n)),max:r+toDimension(t,r)}}function _lookup(e,t,n){n=n||(n=>e[n]<t);let r,o=e.length-1,i=0;for(;o-i>1;)r=i+o>>1,n(r)?i=r:o=r;return{lo:i,hi:o}}const _lookupByKey=(e,t,n)=>_lookup(e,n,(r=>e[r][t]<n)),_rlookupByKey=(e,t,n)=>_lookup(e,n,(r=>e[r][t]>=n));function _filterBetween(e,t,n){let r=0,o=e.length;for(;r<o&&e[r]<t;)r++;for(;o>r&&e[o-1]>n;)o--;return r>0||o<e.length?e.slice(r,o):e}const arrayEvents=["push","pop","shift","splice","unshift"];function listenArrayEvents(e,t){e._chartjs?e._chartjs.listeners.push(t):(Object.defineProperty(e,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[t]}}),arrayEvents.forEach((t=>{const n="_onData"+_capitalize(t),r=e[t];Object.defineProperty(e,t,{configurable:!0,enumerable:!1,value(...t){const o=r.apply(this,t);return e._chartjs.listeners.forEach((e=>{"function"==typeof e[n]&&e[n](...t)})),o}})})))}function unlistenArrayEvents(e,t){const n=e._chartjs;if(!n)return;const r=n.listeners,o=r.indexOf(t);-1!==o&&r.splice(o,1),r.length>0||(arrayEvents.forEach((t=>{delete e[t]})),delete e._chartjs)}function _arrayUnique(e){const t=new Set;let n,r;for(n=0,r=e.length;n<r;++n)t.add(e[n]);if(t.size===r)return e;const o=[];return t.forEach((e=>{o.push(e)})),o}function _createResolver(e,t=[""],n=e,r,o=(()=>e[0])){defined(r)||(r=_resolve("_fallback",e));const i={[Symbol.toStringTag]:"Object",_cacheable:!0,_scopes:e,_rootScopes:n,_fallback:r,_getTarget:o,override:o=>_createResolver([o,...e],t,n,r)};return new Proxy(i,{deleteProperty:(t,n)=>(delete t[n],delete t._keys,delete e[0][n],!0),get:(n,r)=>_cached(n,r,(()=>_resolveWithPrefixes(r,t,e,n))),getOwnPropertyDescriptor:(e,t)=>Reflect.getOwnPropertyDescriptor(e._scopes[0],t),getPrototypeOf:()=>Reflect.getPrototypeOf(e[0]),has:(e,t)=>getKeysFromAllScopes(e).includes(t),ownKeys:e=>getKeysFromAllScopes(e),set:(e,t,n)=>((e._storage||(e._storage=o()))[t]=n,delete e[t],delete e._keys,!0)})}function _attachContext(e,t,n,r){const o={_cacheable:!1,_proxy:e,_context:t,_subProxy:n,_stack:new Set,_descriptors:_descriptors(e,r),setContext:t=>_attachContext(e,t,n,r),override:o=>_attachContext(e.override(o),t,n,r)};return new Proxy(o,{deleteProperty:(t,n)=>(delete t[n],delete e[n],!0),get:(e,t,n)=>_cached(e,t,(()=>_resolveWithContext(e,t,n))),getOwnPropertyDescriptor:(t,n)=>t._descriptors.allKeys?Reflect.has(e,n)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(e,n),getPrototypeOf:()=>Reflect.getPrototypeOf(e),has:(t,n)=>Reflect.has(e,n),ownKeys:()=>Reflect.ownKeys(e),set:(t,n,r)=>(e[n]=r,delete t[n],!0)})}function _descriptors(e,t={scriptable:!0,indexable:!0}){const{_scriptable:n=t.scriptable,_indexable:r=t.indexable,_allKeys:o=t.allKeys}=e;return{allKeys:o,scriptable:n,indexable:r,isScriptable:isFunction(n)?n:()=>n,isIndexable:isFunction(r)?r:()=>r}}const readKey=(e,t)=>e?e+_capitalize(t):t,needsSubResolver=(e,t)=>isObject(t)&&"adapters"!==e;function _cached(e,t,n){let r=e[t];return defined(r)||(r=n(),defined(r)&&(e[t]=r)),r}function _resolveWithContext(e,t,n){const{_proxy:r,_context:o,_subProxy:i,_descriptors:a}=e;let s=r[t];return isFunction(s)&&a.isScriptable(t)&&(s=_resolveScriptable(t,s,e,n)),isArray(s)&&s.length&&(s=_resolveArray(t,s,e,a.isIndexable)),needsSubResolver(t,s)&&(s=_attachContext(s,o,i&&i[t],a)),s}function _resolveScriptable(e,t,n,r){const{_proxy:o,_context:i,_subProxy:a,_stack:s}=n;if(s.has(e))throw new Error("Recursion detected: "+[...s].join("->")+"->"+e);return s.add(e),t=t(i,a||r),s.delete(e),isObject(t)&&(t=createSubResolver(o._scopes,o,e,t)),t}function _resolveArray(e,t,n,r){const{_proxy:o,_context:i,_subProxy:a,_descriptors:s}=n;if(defined(i.index)&&r(e))t=t[i.index%t.length];else if(isObject(t[0])){const n=t,r=o._scopes.filter((e=>e!==n));t=[];for(const l of n){const n=createSubResolver(r,o,e,l);t.push(_attachContext(n,i,a&&a[e],s))}}return t}function resolveFallback(e,t,n){return isFunction(e)?e(t,n):e}const getScope=(e,t)=>!0===e?t:"string"==typeof e?resolveObjectKey(t,e):void 0;function addScopes(e,t,n,r){for(const o of t){const t=getScope(n,o);if(t){e.add(t);const o=resolveFallback(t._fallback,n,t);if(defined(o)&&o!==n&&o!==r)return o}else if(!1===t&&defined(r)&&n!==r)return null}return!1}function createSubResolver(e,t,n,r){const o=t._rootScopes,i=resolveFallback(t._fallback,n,r),a=[...e,...o],s=new Set;s.add(r);let l=addScopesFromKey(s,a,n,i||n);return null!==l&&((!defined(i)||i===n||(l=addScopesFromKey(s,a,i,l),null!==l))&&_createResolver([...s],[""],o,i,(()=>subGetTarget(t,n,r))))}function addScopesFromKey(e,t,n,r){for(;n;)n=addScopes(e,t,n,r);return n}function subGetTarget(e,t,n){const r=e._getTarget();t in r||(r[t]={});const o=r[t];return isArray(o)&&isObject(n)?n:o}function _resolveWithPrefixes(e,t,n,r){let o;for(const i of t)if(o=_resolve(readKey(i,e),n),defined(o))return needsSubResolver(e,o)?createSubResolver(n,r,e,o):o}function _resolve(e,t){for(const n of t){if(!n)continue;const t=n[e];if(defined(t))return t}}function getKeysFromAllScopes(e){let t=e._keys;return t||(t=e._keys=resolveKeysFromAllScopes(e._scopes)),t}function resolveKeysFromAllScopes(e){const t=new Set;for(const n of e)for(const e of Object.keys(n).filter((e=>!e.startsWith("_"))))t.add(e);return[...t]}const EPSILON=Number.EPSILON||1e-14,getPoint=(e,t)=>t<e.length&&!e[t].skip&&e[t],getValueAxis=e=>"x"===e?"y":"x";function splineCurve(e,t,n,r){const o=e.skip?t:e,i=t,a=n.skip?t:n,s=distanceBetweenPoints(i,o),l=distanceBetweenPoints(a,i);let c=s/(s+l),u=l/(s+l);c=isNaN(c)?0:c,u=isNaN(u)?0:u;const f=r*c,d=r*u;return{previous:{x:i.x-f*(a.x-o.x),y:i.y-f*(a.y-o.y)},next:{x:i.x+d*(a.x-o.x),y:i.y+d*(a.y-o.y)}}}function monotoneAdjust(e,t,n){const r=e.length;let o,i,a,s,l,c=getPoint(e,0);for(let u=0;u<r-1;++u)l=c,c=getPoint(e,u+1),l&&c&&(almostEquals(t[u],0,EPSILON)?n[u]=n[u+1]=0:(o=n[u]/t[u],i=n[u+1]/t[u],s=Math.pow(o,2)+Math.pow(i,2),s<=9||(a=3/Math.sqrt(s),n[u]=o*a*t[u],n[u+1]=i*a*t[u])))}function monotoneCompute(e,t,n="x"){const r=getValueAxis(n),o=e.length;let i,a,s,l=getPoint(e,0);for(let c=0;c<o;++c){if(a=s,s=l,l=getPoint(e,c+1),!s)continue;const o=s[n],u=s[r];a&&(i=(o-a[n])/3,s["cp1"+n]=o-i,s["cp1"+r]=u-i*t[c]),l&&(i=(l[n]-o)/3,s["cp2"+n]=o+i,s["cp2"+r]=u+i*t[c])}}function splineCurveMonotone(e,t="x"){const n=getValueAxis(t),r=e.length,o=Array(r).fill(0),i=Array(r);let a,s,l,c=getPoint(e,0);for(a=0;a<r;++a)if(s=l,l=c,c=getPoint(e,a+1),l){if(c){const e=c[t]-l[t];o[a]=0!==e?(c[n]-l[n])/e:0}i[a]=s?c?sign(o[a-1])!==sign(o[a])?0:(o[a-1]+o[a])/2:o[a-1]:o[a]}monotoneAdjust(e,o,i),monotoneCompute(e,i,t)}function capControlPoint(e,t,n){return Math.max(Math.min(e,n),t)}function capBezierPoints(e,t){let n,r,o,i,a,s=_isPointInArea(e[0],t);for(n=0,r=e.length;n<r;++n)a=i,i=s,s=n<r-1&&_isPointInArea(e[n+1],t),i&&(o=e[n],a&&(o.cp1x=capControlPoint(o.cp1x,t.left,t.right),o.cp1y=capControlPoint(o.cp1y,t.top,t.bottom)),s&&(o.cp2x=capControlPoint(o.cp2x,t.left,t.right),o.cp2y=capControlPoint(o.cp2y,t.top,t.bottom)))}function _updateBezierControlPoints(e,t,n,r,o){let i,a,s,l;if(t.spanGaps&&(e=e.filter((e=>!e.skip))),"monotone"===t.cubicInterpolationMode)splineCurveMonotone(e,o);else{let n=r?e[e.length-1]:e[0];for(i=0,a=e.length;i<a;++i)s=e[i],l=splineCurve(n,s,e[Math.min(i+1,a-(r?0:1))%a],t.tension),s.cp1x=l.previous.x,s.cp1y=l.previous.y,s.cp2x=l.next.x,s.cp2y=l.next.y,n=s}t.capBezierPoints&&capBezierPoints(e,n)}function _getParentNode(e){let t=e.parentNode;return t&&"[object ShadowRoot]"===t.toString()&&(t=t.host),t}function parseMaxStyle(e,t,n){let r;return"string"==typeof e?(r=parseInt(e,10),-1!==e.indexOf("%")&&(r=r/100*t.parentNode[n])):r=e,r}const getComputedStyle=e=>window.getComputedStyle(e,null);function getStyle(e,t){return getComputedStyle(e).getPropertyValue(t)}const positions=["top","right","bottom","left"];function getPositionedStyle(e,t,n){const r={};n=n?"-"+n:"";for(let o=0;o<4;o++){const i=positions[o];r[i]=parseFloat(e[t+"-"+i+n])||0}return r.width=r.left+r.right,r.height=r.top+r.bottom,r}const useOffsetPos=(e,t,n)=>(e>0||t>0)&&(!n||!n.shadowRoot);function getCanvasPosition(e,t){const n=e.native||e,r=n.touches,o=r&&r.length?r[0]:n,{offsetX:i,offsetY:a}=o;let s,l,c=!1;if(useOffsetPos(i,a,n.target))s=i,l=a;else{const e=t.getBoundingClientRect();s=o.clientX-e.left,l=o.clientY-e.top,c=!0}return{x:s,y:l,box:c}}function getRelativePosition(e,t){const{canvas:n,currentDevicePixelRatio:r}=t,o=getComputedStyle(n),i="border-box"===o.boxSizing,a=getPositionedStyle(o,"padding"),s=getPositionedStyle(o,"border","width"),{x:l,y:c,box:u}=getCanvasPosition(e,n),f=a.left+(u&&s.left),d=a.top+(u&&s.top);let{width:h,height:g}=t;return i&&(h-=a.width+s.width,g-=a.height+s.height),{x:Math.round((l-f)/h*n.width/r),y:Math.round((c-d)/g*n.height/r)}}function getContainerSize(e,t,n){let r,o;if(void 0===t||void 0===n){const i=_getParentNode(e);if(i){const e=i.getBoundingClientRect(),a=getComputedStyle(i),s=getPositionedStyle(a,"border","width"),l=getPositionedStyle(a,"padding");t=e.width-l.width-s.width,n=e.height-l.height-s.height,r=parseMaxStyle(a.maxWidth,i,"clientWidth"),o=parseMaxStyle(a.maxHeight,i,"clientHeight")}else t=e.clientWidth,n=e.clientHeight}return{width:t,height:n,maxWidth:r||INFINITY,maxHeight:o||INFINITY}}const round1=e=>Math.round(10*e)/10;function getMaximumSize(e,t,n,r){const o=getComputedStyle(e),i=getPositionedStyle(o,"margin"),a=parseMaxStyle(o.maxWidth,e,"clientWidth")||INFINITY,s=parseMaxStyle(o.maxHeight,e,"clientHeight")||INFINITY,l=getContainerSize(e,t,n);let{width:c,height:u}=l;if("content-box"===o.boxSizing){const e=getPositionedStyle(o,"border","width"),t=getPositionedStyle(o,"padding");c-=t.width+e.width,u-=t.height+e.height}return c=Math.max(0,c-i.width),u=Math.max(0,r?Math.floor(c/r):u-i.height),c=round1(Math.min(c,a,l.maxWidth)),u=round1(Math.min(u,s,l.maxHeight)),c&&!u&&(u=round1(c/2)),{width:c,height:u}}function retinaScale(e,t,n){const r=t||1,o=Math.floor(e.height*r),i=Math.floor(e.width*r);e.height=o/r,e.width=i/r;const a=e.canvas;return a.style&&(n||!a.style.height&&!a.style.width)&&(a.style.height=e.height+"px",a.style.width=e.width+"px"),(e.currentDevicePixelRatio!==r||a.height!==o||a.width!==i)&&(e.currentDevicePixelRatio=r,a.height=o,a.width=i,e.ctx.setTransform(r,0,0,r,0,0),!0)}const supportsEventListenerOptions=function(){let e=!1;try{const t={get passive(){return e=!0,!1}};window.addEventListener("test",null,t),window.removeEventListener("test",null,t)}catch(e){}return e}();function readUsedSize(e,t){const n=getStyle(e,t),r=n&&n.match(/^(\d+)(\.\d+)?px$/);return r?+r[1]:void 0}function _pointInLine(e,t,n,r){return{x:e.x+n*(t.x-e.x),y:e.y+n*(t.y-e.y)}}function _steppedInterpolation(e,t,n,r){return{x:e.x+n*(t.x-e.x),y:"middle"===r?n<.5?e.y:t.y:"after"===r?n<1?e.y:t.y:n>0?t.y:e.y}}function _bezierInterpolation(e,t,n,r){const o={x:e.cp2x,y:e.cp2y},i={x:t.cp1x,y:t.cp1y},a=_pointInLine(e,o,n),s=_pointInLine(o,i,n),l=_pointInLine(i,t,n),c=_pointInLine(a,s,n),u=_pointInLine(s,l,n);return _pointInLine(c,u,n)}const intlCache=new Map;function getNumberFormat(e,t){t=t||{};const n=e+JSON.stringify(t);let r=intlCache.get(n);return r||(r=new Intl.NumberFormat(e,t),intlCache.set(n,r)),r}function formatNumber(e,t,n){return getNumberFormat(t,n).format(e)}const getRightToLeftAdapter=function(e,t){return{x:n=>e+e+t-n,setWidth(e){t=e},textAlign:e=>"center"===e?e:"right"===e?"left":"right",xPlus:(e,t)=>e-t,leftForLtr:(e,t)=>e-t}},getLeftToRightAdapter=function(){return{x:e=>e,setWidth(e){},textAlign:e=>e,xPlus:(e,t)=>e+t,leftForLtr:(e,t)=>e}};function getRtlAdapter(e,t,n){return e?getRightToLeftAdapter(t,n):{x:e=>e,setWidth(e){},textAlign:e=>e,xPlus:(e,t)=>e+t,leftForLtr:(e,t)=>e}}function overrideTextDirection(e,t){let n,r;"ltr"!==t&&"rtl"!==t||(n=e.canvas.style,r=[n.getPropertyValue("direction"),n.getPropertyPriority("direction")],n.setProperty("direction",t,"important"),e.prevTextDirection=r)}function restoreTextDirection(e,t){void 0!==t&&(delete e.prevTextDirection,e.canvas.style.setProperty("direction",t[0],t[1]))}function propertyFn(e){return"angle"===e?{between:_angleBetween,compare:_angleDiff,normalize:_normalizeAngle}:{between:(e,t,n)=>e>=Math.min(t,n)&&e<=Math.max(n,t),compare:(e,t)=>e-t,normalize:e=>e}}function normalizeSegment({start:e,end:t,count:n,loop:r,style:o}){return{start:e%n,end:t%n,loop:r&&(t-e+1)%n==0,style:o}}function getSegment(e,t,n){const{property:r,start:o,end:i}=n,{between:a,normalize:s}=propertyFn(r),l=t.length;let c,u,{start:f,end:d,loop:h}=e;if(h){for(f+=l,d+=l,c=0,u=l;c<u&&a(s(t[f%l][r]),o,i);++c)f--,d--;f%=l,d%=l}return d<f&&(d+=l),{start:f,end:d,loop:h,style:e.style}}function _boundSegment(e,t,n){if(!n)return[e];const{property:r,start:o,end:i}=n,a=t.length,{compare:s,between:l,normalize:c}=propertyFn(r),{start:u,end:f,loop:d,style:h}=getSegment(e,t,n),g=[];let p,b,m,y=!1,_=null;const x=()=>y||l(o,m,p)&&0!==s(o,m),v=()=>!y||0===s(i,p)||l(i,m,p);for(let e=u,n=u;e<=f;++e)b=t[e%a],b.skip||(p=c(b[r]),p!==m&&(y=l(p,o,i),null===_&&x()&&(_=0===s(p,o)?e:n),null!==_&&v()&&(g.push(normalizeSegment({start:_,end:e,loop:d,count:a,style:h})),_=null),n=e,m=p));return null!==_&&g.push(normalizeSegment({start:_,end:f,loop:d,count:a,style:h})),g}function _boundSegments(e,t){const n=[],r=e.segments;for(let o=0;o<r.length;o++){const i=_boundSegment(r[o],e.points,t);i.length&&n.push(...i)}return n}function findStartAndEnd(e,t,n,r){let o=0,i=t-1;if(n&&!r)for(;o<t&&!e[o].skip;)o++;for(;o<t&&e[o].skip;)o++;for(o%=t,n&&(i+=o);i>o&&e[i%t].skip;)i--;return i%=t,{start:o,end:i}}function solidSegments(e,t,n,r){const o=e.length,i=[];let a,s=t,l=e[t];for(a=t+1;a<=n;++a){const n=e[a%o];n.skip||n.stop?l.skip||(r=!1,i.push({start:t%o,end:(a-1)%o,loop:r}),t=s=n.stop?a:null):(s=a,l.skip&&(t=a)),l=n}return null!==s&&i.push({start:t%o,end:s%o,loop:r}),i}function _computeSegments(e,t){const n=e.points,r=e.options.spanGaps,o=n.length;if(!o)return[];const i=!!e._loop,{start:a,end:s}=findStartAndEnd(n,o,i,r);if(!0===r)return splitByStyles([{start:a,end:s,loop:i}],n,t);return splitByStyles(solidSegments(n,a,s<a?s+o:s,!!e._fullLoop&&0===a&&s===o-1),n,t)}function splitByStyles(e,t,n){return n&&n.setContext&&t?doSplitByStyles(e,t,n):e}function doSplitByStyles(e,t,n){const r=t.length,o=[];let i=e[0].start,a=i;for(const s of e){let e,l,c=t[i%r];for(a=i+1;a<=s.end;a++){const u=t[a%r];l=readStyle(n.setContext({type:"segment",p0:c,p1:u})),styleChanged(l,e)&&(o.push({start:i,end:a-1,loop:s.loop,style:e}),e=l,i=a-1),c=u,e=l}i<a-1&&(o.push({start:i,end:a-1,loop:s.loop,style:l}),i=a-1)}return o}function readStyle(e){return{backgroundColor:e.backgroundColor,borderCapStyle:e.borderCapStyle,borderDash:e.borderDash,borderDashOffset:e.borderDashOffset,borderJoinStyle:e.borderJoinStyle,borderWidth:e.borderWidth,borderColor:e.borderColor}}function styleChanged(e,t){return t&&JSON.stringify(e)!==JSON.stringify(t)}export{merge as $,_isPointInArea as A,_rlookupByKey as B,toPadding as C,each as D,getMaximumSize as E,_getParentNode as F,readUsedSize as G,HALF_PI as H,throttled as I,supportsEventListenerOptions as J,log10 as K,_factorize as L,finiteOrDefault as M,callback as N,_addGrace as O,PI as P,toDegrees as Q,_measureText as R,_int16Range as S,TAU as T,_alignPixel as U,renderText as V,toFont as W,_toLeftRightCenter as X,_alignStartEnd as Y,overrides as Z,_arrayUnique as _,resolve as a,_capitalize as a0,descriptors as a1,isFunction as a2,_attachContext as a3,_createResolver as a4,_descriptors as a5,mergeIf as a6,uid as a7,debounce as a8,retinaScale as a9,niceNum as aA,almostWhole as aB,almostEquals as aC,_decimalPlaces as aD,_longestText as aE,_filterBetween as aF,_lookup as aG,getHoverColor as aH,clone$1 as aI,_merger as aJ,_mergerIf as aK,_deprecated as aL,toFontString as aM,splineCurve as aN,splineCurveMonotone as aO,getStyle as aP,fontString as aQ,toLineHeight as aR,PITAU as aS,INFINITY as aT,RAD_PER_DEG as aU,QUARTER_PI as aV,TWO_THIRDS_PI as aW,_angleDiff as aX,clearCanvas as aa,setsEqual as ab,_elementsEqual as ac,getAngleFromPoint as ad,_readValueToProps as ae,_updateBezierControlPoints as af,_computeSegments as ag,_boundSegments as ah,_steppedInterpolation as ai,_bezierInterpolation as aj,_pointInLine as ak,_steppedLineTo as al,_bezierCurveTo as am,drawPoint as an,addRoundedRectPath as ao,toTRBL as ap,toTRBLCorners as aq,_boundSegment as ar,_normalizeAngle as as,getRtlAdapter as at,overrideTextDirection as au,_textX as av,restoreTextDirection as aw,noop as ax,distanceBetweenPoints as ay,_setMinAndMaxByKey as az,isArray as b,color as c,defaults as d,effects as e,resolveObjectKey as f,isNumberFinite as g,defined as h,isObject as i,isNullOrUndef as j,clipArea as k,listenArrayEvents as l,unclipArea as m,toPercentage as n,toDimension as o,formatNumber as p,_angleBetween as q,requestAnimFrame as r,sign as s,toRadians as t,unlistenArrayEvents as u,valueOrDefault as v,isNumber as w,_limitValue as x,_lookupByKey as y,getRelativePosition as z};
//# sourceMappingURL=/sm/f0a36da2f736b286900b2b035cfed43ab48124d86002c30dffab18161a7047bb.map