﻿function PaymentCertificateHandler(params) {
    this.selPlan = params.planes;
    this.jsonPlans = params.plansStr;
    this.jsonCodes = params.codesStr;
    this.cantidad = params.cantidad;
    this.plans = JSON.parse($(this.jsonPlans).val());
    this.descuento = params.descuento;
    this.paypalBtn = params.paypalBtn;
    this.descuentoWrapper = params.descuentoWrapper;
    this.descuentoField = params.descuentoField;
    this.descLabel = params.descLabel;
    this.userId = params.userId;
    this.UserId = $(this.userId).val();
    this.Errors = params.errors;
    this.BtnAplicarDescuento = params.BtnAplicarDescuento;
    this.CodeId = -1;
    const { apiUrl } = params;
    this.Urls = {
        CreateOrder: () => `${apiUrl}/Paypal/CreateOrder`,
        CodeValidator: (id) => `${apiUrl}/Codes/Validate/${id}`,
        Root: () => `${apiUrl}/Plans`
    };
}
PaymentCertificateHandler.prototype.Initialize = function () {
    this.RegisterEvents();
}

PaymentCertificateHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.selPlan).change(function (evt) {
        var value = evt.target.value;
        if (value != -1) {
            $(self.descuento).prop("disabled", false);
            $(self.BtnAplicarDescuento).prop("disabled", false);
            var plan = self.plans.find(p => p.Id == value);
            var mxn = Intl.NumberFormat('es-MX');
            $(self.cantidad).text(`$${mxn.format(plan.Price)}`);
        } else {
            $(self.descuento).prop("disabled", true);
            $(self.BtnAplicarDescuento).prop("disabled", true);
            $(self.cantidad).text(`$0`);
        }

    });
    $(this.BtnAplicarDescuento).click(function(e) {
        self.ValidateCode(self, $(self.descuento).val().toLowerCase());
    });
    $(this.paypalBtn).click(function (e) {
        const plan = $(self.selPlan).val();
        if (plan) {
            
            
            const args = {
                url: self.Urls.CreateOrder(),
                data: {
                    PlanId: +plan,
                    CodeId: self.CodeId,
                    UserId: self.UserId
                },
                done: (data) => {
                    console.log(data);
                    var order = JSON.parse(data);
                    var link = order.Links.find(l => l.Rel === 'approve');
                    window.location.href = link.Href;
                },
                fail: ({ responseJSON }) => {
                    const { errors } = responseJSON;
                    self.DisplayErrors(errors);
                    //console.log(errors);
                    //params.DisplayErrors2(errors);
                }
            };
            Window.dataService.Post(args);
        }
        else {
            const notificationParams = {
                position: 'topRight',
                color: 'red',
                title: `selecciona un Plan`

            };
            iziToast.show(notificationParams);
        }
    });
    $(this.descuento).keyup(function (e) {
        if ((e.key === "Enter" || e.keyCode === 13) && e.target.value) {
            self.ValidateCode(self, e.target.value.toLowerCase());
        } 
    });
}

PaymentCertificateHandler.prototype.ValidateCode = function (self, code) {
    if (code) {
        const notificationParams = {
            position: 'topRight',
            color: 'red',
            title: `El Codigo introducido no es valido`

        };
        const args = {
            url: this.Urls.CodeValidator(code),
            done: (data) => {
                if (data) {
                    self.CodeId = data.id;
                    $(self.descuentoField).text(`-${data.discount}%`);
                    $(self.descuentoWrapper).show(300);
                    var value = $(self.selPlan).val();
                    var plan = self.plans.find(p => p.Id == value);
                    var newValue = plan.Price - (plan.Price * (data.discount / 100));
                    var mxn = Intl.NumberFormat('es-MX');
                    $(self.cantidad).text(`$${mxn.format(newValue)}`);
                } else {
                    self.CodeId = -1;
                    iziToast.show(notificationParams);
                    var value = $(self.selPlan).val();
                    var plan = self.plans.find(p => p.Id == value);
                    var mxn = Intl.NumberFormat('es-MX');
                    $(self.cantidad).text(`$${mxn.format(plan.Price)}`);
                    $(self.descuentoField).text(`0%`);
                    $(self.descuentoWrapper).hide(300);
                }

            },
            fail: error => {
                console.log(error);
                iziToast.show(notificationParams);
            }
        };
        Window.dataService.Get(args);
    } else {
        const notificationParams = {
            position: 'topRight',
            color: 'red',
            title: `introduce un Codigo`

        };
        iziToast.show(notificationParams);
    }
    
}

PaymentCertificateHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        //this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.Errors).append(errorHTML);
        $(this.Errors).show(300);
    }
}
