﻿function ProfileHandler(params) {
    const { apiUrl } = params;
    this.Nombre = params.Nombre;
    this.Apellido = params.Apellido;
    this.PhoneNumber = params.PhoneNumber;
    this.Company = params.Company;
    this.Correo = params.Correo;
    this.ZipCode = params.ZipCode;
    this.btnUpdate = params.btnUpdate;
    this.password = params.password;
    this.confirmPassword = params.confirmPassword;
    this.btnPasswordUpdate = params.btnPasswordUpdate;
    this.user = params.user;
    this.role = params.role;
    this.Urls = {
        ById: (id) => `${apiUrl}/Users/${id}`,
        Root: () => `${apiUrl}/Users`,
        Password: (id) => `${apiUrl}/Users/${id}/Password`
    };
}
ProfileHandler.prototype.Initialize = function () {
    this.SetupUsersTable();
    this.RegisterEvents();
}

ProfileHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.btnUpdate).click(function () {
        var valid = self.ValidateInfo();
        if (valid) {
            self.Update();
        }
    });
    $(this.btnPasswordUpdate).click(function () {
        var valid = self.ValidatePassword();
        if (valid) {
            self.UpdatePassword();
        }
    });
    $(self.PhoneNumber).keyup(function (e) {
        if (!(/\d/g.test(+this.value))) {
            this.value = this.value.replace(/\D/g, '');
        }
    });
    $(self.Nombre).keyup(function (event) {
        if (!/^[a-zA-Z ]*$/gm.test(this.value) || event.key === '_') {
            this.value = this.value.replace(event.key, '');
        }
    });
    $(self.Nombre).blur(function (event) {
        this.value = this.value.trim();
        this.value = Array.from(new Set(this.value.split(" "))).join(' ')
    });
    $(self.Apellido).keyup(function (event) {
        if (!/^[a-zA-Z ]*$/gm.test(this.value) || event.key === '_') {
            this.value = this.value.replace(event.key, '');
        }
    });
    $(self.Apellido).blur(function (event) {
        this.value = this.value.trim();
        this.value = Array.from(new Set(this.value.split(" "))).join(' ')
    });
    $(self.Company).keyup(function (event) {
        if (!/^[a-zA-Z ]*$/gm.test(this.value) || event.key === '_') {
            this.value = this.value.replace(event.key, '');
        }
    });
    $(self.Company).blur(function (event) {
        this.value = this.value.trim();
        this.value = Array.from(new Set(this.value.split(" "))).join(' ')
    });
    $(self.ZipCode).keyup(function (event) {
        if (!/^[a-zA-Z ]*$/gm.test(this.value) || event.key === '_') {
            this.value = this.value.replace(event.key, '');
        }
    });
    $(self.ZipCode).blur(function (event) {
        this.value = this.value.trim();
        this.value = Array.from(new Set(this.value.split(" "))).join(' ')
    });
}
ProfileHandler.prototype.ValidatePassword = function () {
    var validationService = new ValidationService();
    var isNotValid = []
    var fields = [
        $(this.password),
        $(this.confirmPassword)
    ]
    fields.forEach(e => {
        var valid = false;
        var isInput = e.is('input');
        if (isInput) {
            var type = e.attr('type');
            if (type.toLocaleLowerCase() === 'text' || type.toLocaleLowerCase() === 'password') {
                if (e.attr('required')) {
                    valid = validationService.ValidRequiredString(e.val());
                    if (!valid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }

            }
        } 
    });
    var pwd = $(this.password).val();
    var cpwd = $(this.confirmPassword).val();
    if (pwd && cpwd) {
        var valid = pwd === cpwd;
        if (!valid) {
            isNotValid.push(valid);
            this.DisplayErrors($(this.confirmPassword), 'Las contraseñas no coinciden');
        }
    }
    return isNotValid.length === 0;
}

ProfileHandler.prototype.ValidateInfo = function () {
    var validationService = new ValidationService();
    var isNotValid = [];
    const fields = [
        $(this.Correo),
        $(this.Nombre),
        $(this.Apellido),
        $(this.PhoneNumber),
        $(this.Company),
        $(this.ZipCode)
    ];
    fields.forEach(e => {
        var valid = false;
        var isInput = e.is('input');
        if (isInput) {
            var type = e.attr('type');
            if (type.toLocaleLowerCase() === 'text' || type.toLocaleLowerCase() === 'password') {
                if (e.attr('required')) {
                    valid = validationService.ValidRequiredString(e.val());
                    if (!valid) {
                        isNotValid.push(valid);
                        this.DisplayErrors(e, 'Campo Requerido');
                    }
                }

            }
        } 
    });
    return isNotValid.length === 0;
}

ProfileHandler.prototype.Update = function() {
    const user = {
        Password: null,
        Correo: $(this.Correo).val(),
        Nombre: $(this.Nombre).val(),
        Apellido: $(this.Apellido).val(),
        Role: $(this.role).val(),
        PhoneNumber: $(this.PhoneNumber).val(),
        Company: $(this.Company).val(),
        ZipCode: $(this.ZipCode).val(),
        Id: $(this.user).val()
    };
    const id = $(this.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Datos actualizados correctamente`,

    };
    const args = {
        url: this.Urls.ById(id),
        data: user,
        done: (data) => {
            iziToast.show(notificationParams);
            $(this.Correo).val(data.correo);
            $(this.Nombre).val(data.nombre);
            $(this.Apellido).val(data.apellido);
            $(this.PhoneNumber).val(data.phoneNumber);
            $(this.Company).val(data.company);
            $(this.ZipCode).val(data.ZipCode);
        }
    };
    Window.dataService.Put(args);
}

ProfileHandler.prototype.SetupUsersTable = () => {

}
ProfileHandler.prototype.DeleteUser = function (id) {

}
ProfileHandler.prototype.UpdatePassword = function() {
    var Password = $(this.password).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Su Contraseña ha sido Actualizada`,

    };
    var request = {
        Password
    };
    var userId = $(this.user).val();
    const args = {
        url: this.Urls.Password(userId),
        data: request,
        done: (data) => {
            this.ClearPasswordFields();
            iziToast.show(notificationParams);
            /*params.Get();*/
        }
    };
    Window.dataService.Post(args);
}

ProfileHandler.prototype.ClearPasswordFields = function () {
    $(this.password).val('');
    $(this.confirmPassword).val('');
}

ProfileHandler.prototype.DisplayErrors = function (element, errorMsg) {
    if (!$(element).hasClass('invalid')) {
        $(element).parent().append(`<span class="feedback">${errorMsg}</span>`);
        $(element).addClass('invalid');
    }
}
ProfileHandler.prototype.ClearError = function () {
    $(this.userErrors).empty();
}
ProfileHandler.prototype.DisplayErrors2 = function (errors) {

}