﻿function TipoPlanHandler(params) {
    this.btnNuevoCodigo = params.btnNuevoCodigo;
    this.formTipoPlanModal = params.formTipoPlanModal;
    this.tblTipoPlan = params.tblTipoPlan;
    this.TipoPlanForm = params.TipoPlanForm;
    this.btnSave = params.btnSave;
    this.txtTipoPlan = params.txtTipoPlan;
    this.ShowEditSelect = params.ShowEditSelect;
    
    this.txtId = params.txtId;
    this.btnUpdate = params.btnUpdate;
    this.btnDelete = params.btnDelete;
    this.TipoPlanrErrors = params.TipoPlanErrors;
    const { apiUrl } = params;
    this.Urls = {
        ById: (id) => `${apiUrl}/Plans/TipoPlan/${id}`,
        Root: () => `${apiUrl}/Plans/TipoPlan`
    };
}
TipoPlanHandler.prototype.Initialize = function () {
    this.SetupTable(this);
    this.RegisterEvents();
}

TipoPlanHandler.prototype.RegisterEvents = function () {
    self = this;
    $(this.formTipoPlanModal).on("hide.bs.modal", function () {
        self.ClearFields();
        self.ClearError();
    });
    $(this.btnNuevoCodigo).click(() => {
        $('#TipoPlan-modal-title').text('Agregar Tipo de Plan');
        
        $(this.formTipoPlanModal).modal('show');
    });
    $(this.btnSave).unbind();
        $(this.TipoPlanForm).submit(event => {
            event.preventDefault();
            this.ClearError();
            this.Add(this);
        });
    
}

TipoPlanHandler.prototype.TableEvents = function () {
        $(this.btnUpdate).each((index, element) => {
        $(element).click(e => {
            $('#TipoPlan-modal-title').text('Actualizar Tipo de Plan');
            const id = $(element).data('key');
            const args = {
                url: this.Urls.ById(id),
                done: (data) => {
                    $(this.txtId).val(data.id);
                   
                    $(this.txtTipoPlan).val(data.descripcion);
                    $(this.ShowEditSelect).val(data.showEdit.toString());
                    this.ClearError();
                    $(this.formTipoPlanModal).modal('show');
                },
                fail: error => {
                    console.log(error);
                }
            };
            Window.dataService.Get(args);
        });

    });

    $(this.btnDelete).each((index, element) => {
        $(element).click(e => {
            const id = $(element).data('key');
            const TipoPlan = $(element).parent().parent().find('td').get(1).innerText;
            bootbox.confirm({
                message: `Estas seguro que deseas eliminar el tipo de consulta <strong>${TipoPlan}</strong>?`,
                size: 'small',
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    console.log(result);
                    if (result) {
                        self.Delete(id);
                    }
                }
            });
        });
    });
}

TipoPlanHandler.prototype.Get = function () {
    const args = {
        url: this.Urls.Root(),
        done: (data) => {
            var rows = data.map(u => {
                u.action = `<button class="btn btn-primary btn-update" data-key="${u.id}">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                                <button class="btn btn-danger btn-delete" data-key="${u.id}">
                                    <i class="bi bi-trash-fill"></i>
                                </button>`;
                u.deleted = u.deleted ? 'Inactivo' : 'Activo';
                u.showEdit = u.showEdit ? "Si" : "No";
                return u;
            })
            const datatable = $(this.tblTipoPlan).DataTable();
            datatable.clear();
            datatable.rows.add(rows);
            datatable.draw();
            this.TableEvents();
        },
        fail: error => {
            console.log(error);
        }
    };
    Window.dataService.Get(args);
}


TipoPlanHandler.prototype.SetupTable = (objThis) => {
    // Configure datatables
    $(self.tblTipoPlan).DataTable({
        pageLength: 25,
        order: [[1, "asc"]],
        language: dtSpanish,
        columns: [
            { data: "id" },
            { data: "descripcion" },
            { data: "showEdit" },
            { data: "deleted" },
            { data: "action" }
        ],
        drawCallback: function (settings) {
            objThis.TableEvents();
        }
    });
}
TipoPlanHandler.prototype.Delete = function (id) {
    const args = {
        url: self.Urls.ById(id),
        done: (data) => {
            this.Get();
            iziToast.show({ position: 'topRight', title: "Tipo de plan eliminado correctamente", color: 'green' });
        }
    };

    Window.dataService.Delete(args);
}
TipoPlanHandler.prototype.Add = (params) => {

    const 
        Description = $(params.txtTipoPlan).val(),
        showEdit = $(params.ShowEditSelect).val() === 'true';
    const TipoPlan = {
        Description: Description.trim(),
        showEdit
    };
    const id = $(params.txtId).val();
    const notificationParams = {
        position: 'topRight',
        color: 'green',
        title: `Tipo de PLan ${id ? 'actualizado' : 'creado'} correctamente`,

    };
    const args = {
        url: params.Urls.Root(),
        data: TipoPlan,
        done: (data) => {
            $(this.formTipoPlanModal).modal('hide');
            params.ClearFields();
            iziToast.show(notificationParams);
            params.Get();
        },
        fail: ({ responseJSON }) => {
            const { errors } = responseJSON;
            params.DisplayErrors(errors);
            console.log(errors);
            params.DisplayErrors2(errors);
        }
    };
    if (id != 0)  {
        args.data.id = id;
        args.url = params.Urls.ById(id);
        Window.dataService.Put(args);
    } else {
        Window.dataService.Post(args);
    }
}

TipoPlanHandler.prototype.ClearFields = function () {
    $(this.txtId).val('');
    $(this.txtTipoPlan).val('');
    $(this.ShowEditSelect).val('');
}

TipoPlanHandler.prototype.DisplayErrors = function (errors) {
    if (errors) {
        this.ClearError();
        var errorList = Object.keys(errors).map(key => errors[key]).flat(); 
        const errorHTML = `
            <div class="alert alert-danger" role="alert">
                <ul>
                ${errorList.map(e => `<li>${e}</li>`).join('')}
                </ul>
            </div>
        `;
        $(this.TipoPlanrErrors).append(errorHTML);
    }
}
TipoPlanHandler.prototype.ClearError = function () {
    $(this.TipoPlanrErrors).empty();
}
TipoPlanHandler.prototype.DisplayErrors2 = function (errors) {
    //<div class="invalid-feedback">
    //    Doesn't look good!
    //  </div>
    //'rgb(220, 53, 69)'
    //'form..was-validated'
    if (errors) {
        //const errorHTML = `
        //        ${
        Object.keys(errors).map(key => {
            console.log(key);
            const input = $(`input[name=${key}]`);
            const parent = input.parent();
            console.log(input, parent);
        });
        //    return `<div class="alert alert-danger" role="alert">${key}</div>
        //                 <ul>
        //                    ${errors[key].map(e => { return `<li>${e}</li>` }).join('')}
        //                 </ul>`
        //}).join('')
        //    }
        //`;
        //$(this.coderErrors).append(errorHTML);
    }
}