"use strict";import ChartUtilities from"./Utils/ChartUtilities.js";var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT;import DOMElementProvider from"./Utils/DOMElementProvider.js";import EventProvider from"./Utils/EventProvider.js";import H from"../Core/Globals.js";var doc=H.doc,win=H.win;import HTMLUtilities from"./Utils/HTMLUtilities.js";var removeElement=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;import U from"../Core/Utilities.js";var extend=U.extend,fireEvent=U.fireEvent,merge=U.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(e){this.chart=e,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(e,t){var n=t.type;doc.createEvent&&(e.dispatchEvent||e.fireEvent)?e.dispatchEvent?e.dispatchEvent(t):e.fireEvent(n,t):fireEvent(e,n,t)},fakeClickEvent:function(e){var t;e&&(t=getFakeMouseEvent("click"),this.fireEventOnWrappedOrUnwrappedElement(e,t))},addProxyGroup:function(t){this.createOrUpdateProxyContainer();var n=this.createElement("div");return Object.keys(t||{}).forEach(function(e){null!==t[e]&&n.setAttribute(e,t[e])}),this.chart.a11yProxyContainer.appendChild(n),n},createOrUpdateProxyContainer:function(){var e=this.chart,t=e.renderer.box;e.a11yProxyContainer=e.a11yProxyContainer||this.createProxyContainerElement(),t.nextSibling!==e.a11yProxyContainer&&e.container.insertBefore(e.a11yProxyContainer,t.nextSibling)},createProxyContainerElement:function(){var e=doc.createElement("div");return e.className="highcharts-a11y-proxy-container",e},createProxyButton:function(e,t,n,o,r){var i=e.element,a=this.createElement("button"),s=merge({"aria-label":i.getAttribute("aria-label")},n);return Object.keys(s).forEach(function(e){null!==s[e]&&a.setAttribute(e,s[e])}),a.className="highcharts-a11y-proxy-button",e.hasClass("highcharts-no-tooltip")&&(a.className+=" highcharts-no-tooltip"),r&&this.addEvent(a,"click",r),this.setProxyButtonStyle(a),this.updateProxyButtonPosition(a,o||e),this.proxyMouseEventsForButton(i,a),t.appendChild(a),s["aria-hidden"]||unhideChartElementFromAT(this.chart,a),a},getElementPosition:function(e){var t=e.element,e=this.chart.renderTo;if(e&&t&&t.getBoundingClientRect){t=t.getBoundingClientRect(),e=e.getBoundingClientRect();return{x:t.left-e.left,y:t.top-e.top,width:t.right-t.left,height:t.bottom-t.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(e){merge(!0,e.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),e.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(e,t){t=this.getElementPosition(t);merge(!0,e.style,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},proxyMouseEventsForButton:function(r,e){var i=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(n){var o=0===n.indexOf("touch");i.addEvent(e,n,function(e){var t=o?i.cloneTouchEvent(e):i.cloneMouseEvent(e);r&&i.fireEventOnWrappedOrUnwrappedElement(r,t),e.stopPropagation(),"touchstart"!==n&&"touchmove"!==n&&"touchend"!==n&&e.preventDefault()},{passive:!1})})},cloneMouseEvent:function(e){if("function"==typeof win.MouseEvent)return new win.MouseEvent(e.type,e);if(doc.createEvent){var t=doc.createEvent("MouseEvent");if(t.initMouseEvent)return t.initMouseEvent(e.type,e.bubbles,e.cancelable,e.view||win,e.detail,e.screenX,e.screenY,e.clientX,e.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,e.relatedTarget),t}return getFakeMouseEvent(e.type)},cloneTouchEvent:function(e){function t(e){for(var t=[],n=0;n<e.length;++n){var o=e.item(n);o&&t.push(o)}return t}if("function"==typeof win.TouchEvent){var n=new win.TouchEvent(e.type,{touches:t(e.touches),targetTouches:t(e.targetTouches),changedTouches:t(e.changedTouches),ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,altKey:e.altKey,metaKey:e.metaKey,bubbles:e.bubbles,cancelable:e.cancelable,composed:e.composed,detail:e.detail,view:e.view});return e.defaultPrevented&&n.preventDefault(),n}n=this.cloneMouseEvent(e);return n.touches=e.touches,n.changedTouches=e.changedTouches,n.targetTouches=e.targetTouches,n},destroyBase:function(){removeElement(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}},extend(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);export default AccessibilityComponent;