"use strict";import AST from"../../Core/Renderer/HTML/AST.js";import Chart from"../../Core/Chart/Chart.js";import F from"../../Core/FormatUtilities.js";var format=F.format;import H from"../../Core/Globals.js";var doc=H.doc;import U from"../../Core/Utilities.js";var extend=U.extend,pick=U.pick;import AccessibilityComponent from"../AccessibilityComponent.js";import Announcer from"../Utils/Announcer.js";import AnnotationsA11y from"./AnnotationsA11y.js";var getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML;import ChartUtilities from"../Utils/ChartUtilities.js";var getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle=ChartUtilities.getChartTitle,unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT;import HTMLUtilities from"../Utils/HTMLUtilities.js";var addClass=HTMLUtilities.addClass,escapeStringForHTML=HTMLUtilities.escapeStringForHTML,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(t){return t.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(t,e){return e.mapTitle?t.langFormat("accessibility.chartTypes.mapTypeDescription",e):t.langFormat("accessibility.chartTypes.unknownMap",e)}function getTypeDescForCombinationChart(t,e){return t.langFormat("accessibility.chartTypes.combinationChart",e)}function getTypeDescForEmptyChart(t,e){return t.langFormat("accessibility.chartTypes.emptyChart",e)}function buildTypeDescriptionFromSeries(t,e,i){var n=e[0],r=t.langFormat("accessibility.seriesTypeDescriptions."+n,i),e=t.series&&t.series.length<2?"Single":"Multiple";return(t.langFormat("accessibility.chartTypes."+n+e,i)||t.langFormat("accessibility.chartTypes.default"+e,i))+(r?" "+r:"")}function getTableSummary(t){return t.langFormat("accessibility.table.tableSummary",{chart:t})}Chart.prototype.getTypeDescription=function(t){var e=t[0],i=this.series&&this.series[0]||{},i={numSeries:this.series.length,numPoints:i.points&&i.points.length,chart:this,mapTitle:i.mapTitle};return e?"map"===e?getTypeDescForMapChart(this,i):1<this.types.length?getTypeDescForCombinationChart(this,i):buildTypeDescriptionFromSeries(this,t,i):getTypeDescForEmptyChart(this,i)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent,extend(InfoRegionsComponent.prototype,{init:function(){var t=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(t,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(t,"afterViewData",function(t){e.dataTableDiv=t,setTimeout(function(){e.focusDataTable()},300)}),this.announcer=new Announcer(t,"assertive")},initRegionsDefinitions:function(){var i=this;this.screenReaderSections={before:{element:null,buildContent:function(t){var e=t.options.accessibility.screenReaderSection.beforeChartFormatter;return e?e(t):i.defaultBeforeChartFormatter(t)},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.renderTo.firstChild)},afterInserted:function(){void 0!==i.sonifyButtonId&&i.initSonifyButton(i.sonifyButtonId),void 0!==i.dataTableButtonId&&i.initDataTableButton(i.dataTableButtonId)}},after:{element:null,buildContent:function(t){var e=t.options.accessibility.screenReaderSection.afterChartFormatter;return e?e(t):i.defaultAfterChartFormatter()},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.container.nextSibling)}}}},onChartRender:function(){var e=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(t){e.updateScreenReaderSection(t)})},getLinkedDescriptionElement:function(){var t=this.chart.options.accessibility.linkedDescription;if(t){if("string"!=typeof t)return t;t=format(t,this.chart),t=doc.querySelectorAll(t);return 1===t.length?t[0]:void 0}},setLinkedDescriptionAttrs:function(){var t=this.linkedDescriptionElement;t&&(t.setAttribute("aria-hidden","true"),addClass(t,"highcharts-linked-description"))},updateScreenReaderSection:function(t){var e=this.chart,i=this.screenReaderSections[t],n=i.buildContent(e),r=i.element=i.element||this.createElement("div"),a=r.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(r,t),AST.setElementHTML(a,n),r.appendChild(a),i.insertIntoDOM(r,e),visuallyHideElement(a),unhideChartElementFromAT(e,a),i.afterInserted&&i.afterInserted()},setScreenReaderSectionAttribs:function(t,e){var i=this.chart,n=i.langFormat("accessibility.screenReaderSection."+e+"RegionLabel",{chart:i}),e="highcharts-screen-reader-region-"+e+"-"+i.index;setElAttrs(t,{id:e,"aria-label":n}),t.style.position="relative","all"===i.options.accessibility.landmarkVerbosity&&n&&t.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var t=this.chart,e=t.options.accessibility.screenReaderSection.beforeChartFormat,i=this.getAxesDescription(),n=t.sonify&&t.options.sonification&&t.options.sonification.enabled,r="highcharts-a11y-sonify-data-btn-"+t.index,a="hc-linkto-highcharts-data-table-"+t.index,s=getAnnotationsInfoHTML(t),o=t.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:t}),s={headingTagName:getHeadingTagNameForElement(t.renderTo),chartTitle:getChartTitle(t),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:i.xAxis,yAxisDescription:i.yAxis,playAsSoundButton:n?this.getSonifyButtonText(r):"",viewTableButton:t.getCSV?this.getDataTableButtonText(a):"",annotationsTitle:s?o:"",annotationsList:s},t=H.i18nFormat(e,s,t);return this.dataTableButtonId=a,this.sonifyButtonId=r,stripEmptyHTMLTags(t)},defaultAfterChartFormatter:function(){var t=this.chart,e=t.options.accessibility.screenReaderSection.afterChartFormat,i={endOfChartMarker:this.getEndOfChartMarkerText()};return stripEmptyHTMLTags(H.i18nFormat(e,i,t))},getLinkedDescription:function(){var t=this.linkedDescriptionElement,t=t&&t.innerHTML||"";return stripHTMLTagsFromString(t)},getLongdescText:function(){var t=this.chart.options,e=t.caption,i=e&&e.text,e=this.getLinkedDescription();return t.accessibility.description||e||i||""},getTypeDescriptionText:function(){var t=this.chart;return t.types?t.options.accessibility.typeDescription||t.getTypeDescription(t.types):""},getDataTableButtonText:function(t){var e=this.chart;return'<button id="'+t+'">'+e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:getChartTitle(e)})+"</button>"},getSonifyButtonText:function(t){var e=this.chart;return e.options.sonification&&!1===e.options.sonification.enabled?"":'<button id="'+t+'">'+e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:getChartTitle(e)})+"</button>"},getSubtitleText:function(){var t=this.chart.options.subtitle;return stripHTMLTagsFromString(t&&t.text||"")},getEndOfChartMarkerText:function(){var t=this.chart,e=t.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:t});return'<div id="'+("highcharts-end-of-chart-marker-"+t.index)+'">'+e+"</div>"},onDataTableCreated:function(t){var e,i=this.chart;i.options.accessibility.enabled&&(this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true"),(e=t.tree.attributes||{}).tabindex=-1,e.summary=getTableSummary(i),t.tree.attributes=e)},focusDataTable:function(){var t=this.dataTableDiv,t=t&&t.getElementsByTagName("table")[0];t&&t.focus&&t.focus()},initSonifyButton:function(t){var e=this,i=this.sonifyButton=getElement(t),n=this.chart;i&&n&&(setElAttrs(i,{tabindex:-1}),i.onclick=function(t){(n.options.accessibility&&n.options.accessibility.screenReaderSection.onPlayAsSoundClick||function(t){i&&(i.setAttribute("aria-hidden","true"),i.setAttribute("aria-label","")),t.preventDefault(),t.stopPropagation();t=n.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:n});e.announcer.announce(t),setTimeout(function(){i&&(i.removeAttribute("aria-hidden"),i.removeAttribute("aria-label")),n.sonify&&n.sonify()},1e3)}).call(this,t,n)})},initDataTableButton:function(t){var e=this.viewDataTableButton=getElement(t),i=this.chart,t=t.replace("hc-linkto-","");e&&(setElAttrs(e,{tabindex:-1,"aria-expanded":!!getElement(t)}),e.onclick=i.options.accessibility.screenReaderSection.onViewDataTableClick||function(){i.viewData()})},getAxesDescription:function(){function t(t,e){return 1<(t=i[t]).length||t[0]&&pick(t[0].options.accessibility&&t[0].options.accessibility.enabled,e)}var i=this.chart,e=!!i.types&&i.types.indexOf("map")<0,n=!!i.hasCartesianSeries,r=t("xAxis",!i.angular&&n&&e),n=t("yAxis",n&&e),e={};return r&&(e.xAxis=this.getAxisDescriptionText("xAxis")),n&&(e.yAxis=this.getAxisDescriptionText("yAxis")),e},getAxisDescriptionText:function(t){var e=this.chart,i=e[t];return e.langFormat("accessibility.axis."+t+"Description"+(1<i.length?"Plural":"Singular"),{chart:e,names:i.map(function(t){return getAxisDescription(t)}),ranges:i.map(function(t){return getAxisRangeDescription(t)}),numAxes:i.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});export default InfoRegionsComponent;