"use strict";import Chart from"../../Core/Chart/Chart.js";import H from"../../Core/Globals.js";import Legend from"../../Core/Legend.js";import U from"../../Core/Utilities.js";var addEvent=U.addEvent,extend=U.extend,find=U.find,fireEvent=U.fireEvent,isNumber=U.isNumber;import AccessibilityComponent from"../AccessibilityComponent.js";import KeyboardNavigationHandler from"../KeyboardNavigationHandler.js";import HTMLUtilities from"../Utils/HTMLUtilities.js";var removeElement=HTMLUtilities.removeElement,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString;function scrollLegendToItem(e,t){var i=e.allItems[t].pageIx,t=e.currentPage;void 0!==i&&i+1!==t&&e.scroll(1+i-t)}function shouldDoLegendA11y(e){var t=e.legend&&e.legend.allItems,i=e.options.legend.accessibility||{};return!(!t||!t.length||e.colorAxis&&e.colorAxis.length||!1===i.enabled)}Chart.prototype.highlightLegendItem=function(e){var t=this.legend.allItems,i=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return!!t[e]&&(isNumber(i)&&t[i]&&fireEvent(t[i].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,e),this.setFocusToElement(t[e].legendItem,t[e].a11yProxyElement),fireEvent(t[e].legendGroup.element,"mouseover"),!0)},addEvent(Legend,"afterColorizeItem",function(e){var t=this.chart.options.accessibility,i=e.item;t.enabled&&i&&i.a11yProxyElement&&i.a11yProxyElement.setAttribute("aria-pressed",e.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent,extend(LegendComponent.prototype,{init:function(){var t=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===t.chart&&(t.updateProxiesPositions(),t.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(t.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(e){this.chart===t.chart&&this.chart.renderer&&t.updateProxyPositionForItem(e.item)})},updateLegendItemProxyVisibility:function(){var i=this.chart.legend,e=i.allItems||[],n=i.currentPage||1,o=i.clipHeight||0;e.forEach(function(e){var t=e.pageIx||0,t=(e._legendItemPos?e._legendItemPos[1]:0)+(e.legendItem?Math.round(e.legendItem.getBBox().height):0)-i.pages[t]>o||t!==n-1;e.a11yProxyElement&&(e.a11yProxyElement.style.visibility=t?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)?this.updateProxiesPositions():this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var e=0,t=this.proxyElementsList;e<t.length;e++){var i=t[e],n=i.element,i=i.posElement;this.updateProxyButtonPosition(n,i)}},updateProxyPositionForItem:function(t){var e=find(this.proxyElementsList,function(e){return e.item===t});e&&this.updateProxyButtonPosition(e.element,e.posElement)},recreateProxies:function(){this.removeProxies(),shouldDoLegendA11y(this.chart)&&(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility())},removeProxies:function(){removeElement(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var e=this.chart,t=stripHTMLTags((e.legend&&e.legend.options.title&&e.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),t=e.langFormat("accessibility.legend.legendLabel"+(t?"":"NoTitle"),{chart:e,legendTitle:t});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",t)},addLegendProxyGroup:function(){var e="all"===this.chart.options.accessibility.landmarkVerbosity?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:e})},addLegendListContainer:function(){var e;this.legendProxyGroup&&((e=this.legendListContainer=this.createElement("ul")).style.listStyle="none",this.legendProxyGroup.appendChild(e))},proxyLegendItems:function(){var t=this;(this.chart.legend&&this.chart.legend.allItems||[]).forEach(function(e){e.legendItem&&e.legendItem.element&&t.proxyLegendItem(e)})},proxyLegendItem:function(e){var t,i,n;e.legendItem&&e.legendGroup&&this.legendListContainer&&(n=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags(e.name),item:e}),t={tabindex:-1,"aria-pressed":e.visible,"aria-label":n},i=e.legendGroup.div?e.legendItem:e.legendGroup,n=this.createElement("li"),this.legendListContainer.appendChild(n),e.a11yProxyElement=this.createProxyButton(e.legendItem,n,t,i),this.proxyElementsList.push({item:e,element:e.a11yProxyElement,posElement:i}))},getKeyboardNavigation:function(){var t=this.keyCodes,i=this,e=this.chart;return new KeyboardNavigationHandler(e,{keyCodeMap:[[[t.left,t.right,t.up,t.down],function(e){return i.onKbdArrowKey(this,e)}],[[t.enter,t.space],function(e){return H.isFirefox&&e===t.space?this.response.success:i.onKbdClick(this)}]],validate:function(){return i.shouldHaveLegendNavigation()},init:function(e){return i.onKbdNavigationInit(e)},terminate:function(){e.legend.allItems.forEach(function(e){return e.setState("",!0)})}})},onKbdArrowKey:function(e,t){var i=this.keyCodes,n=e.response,o=this.chart,r=o.options.accessibility,s=o.legend.allItems.length,i=t===i.left||t===i.up?-1:1;return o.highlightLegendItem(this.highlightedLegendItemIx+i)?(this.highlightedLegendItemIx+=i,n.success):1<s&&r.keyboardNavigation.wrapAround?(e.init(i),n.success):n[0<i?"next":"prev"]},onKbdClick:function(e){var t=this.chart.legend.allItems[this.highlightedLegendItemIx];return t&&t.a11yProxyElement&&fireEvent(t.a11yProxyElement,"click"),e.response.success},shouldHaveLegendNavigation:function(){var e=this.chart,t=e.options.legend||{},i=e.legend&&e.legend.allItems,n=e.colorAxis&&e.colorAxis.length,t=t.accessibility||{};return!!(i&&e.legend.display&&!n&&t.enabled&&t.keyboardNavigation&&t.keyboardNavigation.enabled)},onKbdNavigationInit:function(e){var t=this.chart,i=t.legend.allItems.length-1,i=0<e?0:i;t.highlightLegendItem(i),this.highlightedLegendItemIx=i}});export default LegendComponent;