"use strict";import Chart from"../../../Core/Chart/Chart.js";import Point from"../../../Core/Series/Point.js";import Series from"../../../Core/Series/Series.js";import SeriesRegistry from"../../../Core/Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import H from"../../../Core/Globals.js";var doc=H.doc;import U from"../../../Core/Utilities.js";var defined=U.defined,extend=U.extend,fireEvent=U.fireEvent;import KeyboardNavigationHandler from"../../KeyboardNavigationHandler.js";import EventProvider from"../../Utils/EventProvider.js";import ChartUtilities from"../../Utils/ChartUtilities.js";var getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;import"../../../Series/Column/ColumnSeries.js";import"../../../Series/Pie/PieSeries.js";function getPointIndex(i){var t=i.index,e=i.series.points,n=e.length;if(e[t]===i)return t;for(;n--;)if(e[n]===i)return n}function isSkipSeries(i){var t=i.chart.options.accessibility.keyboardNavigation.seriesNavigation,e=i.options.accessibility||{},n=e.keyboardNavigation;return n&&!1===n.enabled||!1===e.enabled||!1===i.options.enableMouseTracking||!i.visible||t.pointNavigationEnabledThreshold&&t.pointNavigationEnabledThreshold<=i.points.length}function isSkipPoint(i){var t=i.series.chart.options.accessibility,e=i.options.accessibility&&!1===i.options.accessibility.enabled;return i.isNull&&t.keyboardNavigation.seriesNavigation.skipNullPoints||!1===i.visible||!1===i.isInside||e||isSkipSeries(i.series)}function getClosestPoint(i,t,e,n){function o(i){return!(defined(i.plotX)&&defined(i.plotY))}var r,s,h=1/0,a=t.points.length;if(!o(i)){for(;a--;)o(s=t.points[a])||(s=(i.plotX-s.plotX)*(i.plotX-s.plotX)*(e||1)+(i.plotY-s.plotY)*(i.plotY-s.plotY)*(n||1))<h&&(h=s,r=a);return defined(r)?t.points[r]:void 0}}function highlightFirstValidPointInChart(i){return delete i.highlightedPoint,i.series.reduce(function(i,t){return i||t.highlightFirstValidPoint()},!1)}function highlightLastValidPointInChart(i){for(var t=i.series.length,e=!1;t--&&(i.highlightedPoint=i.series[t].points[i.series[t].points.length-1],!(e=i.series[t].highlightFirstValidPoint())););return e}function updateChartFocusAfterDrilling(i){highlightFirstValidPointInChart(i),i.focusElement&&i.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(i,t){this.keyCodes=t,this.chart=i}Series.prototype.keyboardMoveVertical=!0,["column","pie"].forEach(function(i){seriesTypes[i]&&(seriesTypes[i].prototype.keyboardMoveVertical=!1)}),Point.prototype.highlight=function(){var i=this.series.chart;return this.isNull?i.tooltip&&i.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&i.setFocusToElement(this.graphic),i.highlightedPoint=this},Chart.prototype.highlightAdjacentPoint=function(i){var t,e,n=this,o=n.series,r=n.highlightedPoint,s=r&&getPointIndex(r)||0,h=r&&r.series.points,a=n.series&&n.series[n.series.length-1],a=a&&a.points&&a.points[a.points.length-1];if(!o[0]||!o[0].points)return!1;if(r){if(t=o[r.series.index+(i?1:-1)],!(e=!(e=h[s+(i?1:-1)])&&t?t.points[i?0:t.points.length-1]:e))return!1}else e=i?o[0].points[0]:a;return isSkipPoint(e)?(isSkipSeries(t=e.series)?n.highlightedPoint=i?t.points[t.points.length-1]:t.points[0]:n.highlightedPoint=e,n.highlightAdjacentPoint(i)):e.highlight()},Series.prototype.highlightFirstValidPoint=function(){var i=this.chart.highlightedPoint,i=(i&&i.series)===this?getPointIndex(i):0,t=this.points,e=t.length;if(t&&e){for(var n=i;n<e;++n)if(!isSkipPoint(t[n]))return t[n].highlight();for(var o=i;0<=o;--o)if(!isSkipPoint(t[o]))return t[o].highlight()}return!1},Chart.prototype.highlightAdjacentSeries=function(i){var t,e,n,o=this,r=o.highlightedPoint,s=o.series&&o.series[o.series.length-1],h=s&&s.points&&s.points[s.points.length-1];return o.highlightedPoint?!!(t=o.series[r.series.index+(i?-1:1)])&&(!!(e=getClosestPoint(r,t,4))&&(isSkipSeries(t)?(e.highlight(),(n=o.highlightAdjacentSeries(i))?n:(r.highlight(),!1)):(e.highlight(),e.series.highlightFirstValidPoint()))):(t=i?o.series&&o.series[0]:s,!!(e=i?t&&t.points&&t.points[0]:h)&&e.highlight())},Chart.prototype.highlightAdjacentPointVertical=function(o){var r,s=this.highlightedPoint,h=1/0;return!(!defined(s.plotX)||!defined(s.plotY))&&(this.series.forEach(function(n){isSkipSeries(n)||n.points.forEach(function(i){var t,e;defined(i.plotY)&&defined(i.plotX)&&i!==s&&(t=i.plotY-s.plotY,e=Math.abs(i.plotX-s.plotX),e=Math.abs(t)*Math.abs(t)+e*e*4,n.yAxis&&n.yAxis.reversed&&(t*=-1),t<=0&&o||0<=t&&!o||e<5||isSkipPoint(i)||e<h&&(h=e,r=i))})}),!!r&&r.highlight())},extend(SeriesKeyboardNavigation.prototype,{init:function(){var e=this,t=this.chart,i=this.eventProvider=new EventProvider;i.addEvent(Series,"destroy",function(){return e.onSeriesDestroy(this)}),i.addEvent(t,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),i.addEvent(t,"drilldown",function(i){var t=i.point,i=t.series;e.lastDrilledDownPoint={x:t.x,y:t.y,seriesName:i?i.name:""}}),i.addEvent(t,"drillupall",function(){setTimeout(function(){e.onDrillupAll()},10)}),i.addEvent(Point,"afterSetState",function(){var i=this.graphic&&this.graphic.element;t.highlightedPoint===this&&doc.activeElement!==i&&i&&i.focus&&i.focus()})},onDrillupAll:function(){var i,t=this.lastDrilledDownPoint,e=this.chart,n=t&&getSeriesFromName(e,t.seriesName);t&&n&&defined(t.x)&&defined(t.y)&&(i=getPointFromXY(n,t.x,t.y)),e.container&&e.container.focus(),i&&i.highlight&&i.highlight(),e.focusElement&&e.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var t=this,i=this.keyCodes,n=this.chart,e=n.inverted;return new KeyboardNavigationHandler(n,{keyCodeMap:[[e?[i.up,i.down]:[i.left,i.right],function(i){return t.onKbdSideways(this,i)}],[e?[i.left,i.right]:[i.up,i.down],function(i){return t.onKbdVertical(this,i)}],[[i.enter,i.space],function(i,t){var e=n.highlightedPoint;return e&&(t.point=e,fireEvent(e.series,"click",t),e.firePointEvent("click")),this.response.success}]],init:function(i){return t.onHandlerInit(this,i)},terminate:function(){return t.onHandlerTerminate()}})},onKbdSideways:function(i,t){var e=this.keyCodes,e=t===e.right||t===e.down;return this.attemptHighlightAdjacentPoint(i,e)},onKbdVertical:function(i,t){var e=this.chart,n=this.keyCodes,t=t===n.down||t===n.right,n=e.options.accessibility.keyboardNavigation.seriesNavigation;return n.mode&&"serialize"===n.mode?this.attemptHighlightAdjacentPoint(i,t):(e[e.highlightedPoint&&e.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](t),i.response.success)},onHandlerInit:function(i,t){var e=this.chart;return(0<t?highlightFirstValidPointInChart:highlightLastValidPointInChart)(e),i.response.success},onHandlerTerminate:function(){var i=this.chart;i.tooltip&&i.tooltip.hide(0);var t=i.highlightedPoint&&i.highlightedPoint.series;t&&t.onMouseOut&&t.onMouseOut(),i.highlightedPoint&&i.highlightedPoint.onMouseOut&&i.highlightedPoint.onMouseOut(),delete i.highlightedPoint},attemptHighlightAdjacentPoint:function(i,t){var e=this.chart,n=e.options.accessibility.keyboardNavigation.wrapAround;return e.highlightAdjacentPoint(t)?i.response.success:n?i.init(t?1:-1):i.response[t?"next":"prev"]},onSeriesDestroy:function(i){var t=this.chart;t.highlightedPoint&&t.highlightedPoint.series===i&&(delete t.highlightedPoint,t.focusElement&&t.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});export default SeriesKeyboardNavigation;