"use strict";import AST from"../Renderer/HTML/AST.js";import A from"../Animation/AnimationUtilities.js";var animObject=A.animObject;import F from"../FormatUtilities.js";var format=F.format;import H from"../Globals.js";import D from"../DefaultOptions.js";var defaultOptions=D.defaultOptions;import U from"../Utilities.js";var addEvent=U.addEvent,defined=U.defined,erase=U.erase,extend=U.extend,fireEvent=U.fireEvent,getNestedProperty=U.getNestedProperty,isArray=U.isArray,isFunction=U.isFunction,isNumber=U.isNumber,isObject=U.isObject,merge=U.merge,objectEach=U.objectEach,pick=U.pick,syncTimeout=U.syncTimeout,removeEvent=U.removeEvent,uniqueKey=U.uniqueKey,Point=function(){function l(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return l.prototype.animateBeforeDestroy=function(){var e,o=this,i={x:o.startXPos,opacity:0},t=o.getGraphicalProps();t.singular.forEach(function(t){e="dataLabel"===t,o[t]=o[t].animate(e?{x:o[t].startXPos,y:o[t].startYPos,opacity:0}:i)}),t.plural.forEach(function(t){o[t].forEach(function(t){t.element&&t.animate(extend({x:o.startXPos},t.startYPos?{x:t.startXPos,y:t.startYPos}:{}))})})},l.prototype.applyOptions=function(t,e){var o=this,i=o.series,r=i.options.pointValKey||i.pointValKey;return t=l.prototype.optionsToObject.call(this,t),extend(o,t),o.options=o.options?extend(o.options,t):t,t.group&&delete o.group,t.dataLabels&&delete o.dataLabels,r&&(o.y=l.prototype.getNestedProperty.call(o,r)),o.isNull=pick(o.isValid&&!o.isValid(),null===o.x||!isNumber(o.y)),o.formatPrefix=o.isNull?"null":"point",o.selected&&(o.state="select"),"name"in o&&void 0===e&&i.xAxis&&i.xAxis.hasNames&&(o.x=i.xAxis.nameToX(o)),void 0===o.x&&i&&(o.x=void 0===e?i.autoIncrement(o):e),o},l.prototype.destroy=function(){var t,e=this,o=e.series,i=o.chart,r=o.options.dataSorting,s=i.hoverPoints,o=e.series.chart.renderer.globalAnimation,o=animObject(o);function n(){for(t in(e.graphic||e.dataLabel||e.dataLabels)&&(removeEvent(e),e.destroyElements()),e)e[t]=null}e.legendItem&&i.legend.destroyItem(e),s&&(e.setState(),erase(s,e),s.length||(i.hoverPoints=null)),e===i.hoverPoint&&e.onMouseOut(),r&&r.enabled?(this.animateBeforeDestroy(),syncTimeout(n,o.duration)):n(),i.pointCount--},l.prototype.destroyElements=function(t){var e=this,t=e.getGraphicalProps(t);t.singular.forEach(function(t){e[t]=e[t].destroy()}),t.plural.forEach(function(t){e[t].forEach(function(t){t.element&&t.destroy()}),delete e[t]})},l.prototype.firePointEvent=function(t,e,o){var i=this,r=this.series.options;(r.point.events[t]||i.options&&i.options.events&&i.options.events[t])&&i.importEvents(),"click"===t&&r.allowPointSelect&&(o=function(t){i.select&&i.select(null,t.ctrlKey||t.metaKey||t.shiftKey)}),fireEvent(i,t,e,o)},l.prototype.getClassName=function(){var t=this;return"highcharts-point"+(t.selected?" highcharts-point-select":"")+(t.negative?" highcharts-negative":"")+(t.isNull?" highcharts-null-point":"")+(void 0!==t.colorIndex?" highcharts-color-"+t.colorIndex:"")+(t.options.className?" "+t.options.className:"")+(t.zone&&t.zone.className?" "+t.zone.className.replace("highcharts-negative",""):"")},l.prototype.getGraphicalProps=function(o){var t,e,i=this,r=[],s={singular:[],plural:[]};for((o=o||{graphic:1,dataLabel:1}).graphic&&r.push("graphic","upperGraphic","shadowGroup"),o.dataLabel&&r.push("dataLabel","dataLabelUpper","connector"),e=r.length;e--;)t=r[e],i[t]&&s.singular.push(t);return["dataLabel","connector"].forEach(function(t){var e=t+"s";o[t]&&i[e]&&s.plural.push(e)}),s},l.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},l.prototype.getNestedProperty=function(t){if(t)return 0===t.indexOf("custom.")?getNestedProperty(t,this.options):this[t]},l.prototype.getZone=function(){for(var t=this.series,e=t.zones,o=t.zoneAxis||"y",i=0,r=e[i];this[o]>=r.value;)r=e[++i];return this.nonZonedColor||(this.nonZonedColor=this.color),r&&r.color&&!this.options.color?this.color=r.color:this.color=this.nonZonedColor,r},l.prototype.hasNewShapeType=function(){return(this.graphic&&(this.graphic.symbolName||this.graphic.element.nodeName))!==this.shapeType},l.prototype.init=function(t,e,o){return this.series=t,this.applyOptions(e,o),this.id=defined(this.id)?this.id:uniqueKey(),this.resolveColor(),t.chart.pointCount++,fireEvent(this,"afterInit"),this},l.prototype.optionsToObject=function(t){var e,o={},i=this.series,r=i.options.keys,s=r||i.pointArrayMap||["y"],n=s.length,a=0,c=0;if(isNumber(t)||null===t)o[s[0]]=t;else if(isArray(t))for(!r&&t.length>n&&("string"==(e=typeof t[0])?o.name=t[0]:"number"==e&&(o.x=t[0]),a++);c<n;)r&&void 0===t[a]||(0<s[c].indexOf(".")?l.prototype.setNestedProperty(o,t[a],s[c]):o[s[c]]=t[a]),a++,c++;else"object"==typeof t&&((o=t).dataLabels&&(i._hasPointLabels=!0),t.marker&&(i._hasPointMarkers=!0));return o},l.prototype.resolveColor=function(){var t,e,o=this.series,i=o.chart.options.chart.colorCount,r=o.chart.styledMode;delete this.nonZonedColor,o.options.colorByPoint?(r||(e=(t=o.options.colors||o.chart.options.colors)[o.colorCounter],i=t.length),t=o.colorCounter,o.colorCounter++,o.colorCounter===i&&(o.colorCounter=0)):(r||(e=o.color),t=o.colorIndex),this.colorIndex=pick(this.options.colorIndex,t),this.color=pick(this.options.color,e)},l.prototype.setNestedProperty=function(t,r,e){return e.split(".").reduce(function(t,e,o,i){o=i.length-1===o;return t[e]=o?r:isObject(t[e],!0)?t[e]:{},t[e]},t),t},l.prototype.tooltipFormatter=function(e){var t=this.series,o=t.tooltipOptions,i=pick(o.valueDecimals,""),r=o.valuePrefix||"",s=o.valueSuffix||"";return t.chart.styledMode&&(e=t.chart.tooltip.styledModeFormat(e)),(t.pointArrayMap||["y"]).forEach(function(t){t="{point."+t,e=(e=r||s?e.replace(RegExp(t+"}","g"),r+t+"}"+s):e).replace(RegExp(t+"}","g"),t+":,."+i+"f}")}),format(e,{point:this,series:this.series},t.chart)},l.prototype.update=function(e,o,i,t){var r,s=this,n=s.series,a=s.graphic,c=n.chart,l=n.options;function p(){s.applyOptions(e);var t=a&&s.hasDummyGraphic,t=null===s.y?!t:t;a&&t&&(s.graphic=a.destroy(),delete s.hasDummyGraphic),isObject(e,!0)&&(a&&a.element&&e&&e.marker&&void 0!==e.marker.symbol&&(s.graphic=a.destroy()),e&&e.dataLabels&&s.dataLabel&&(s.dataLabel=s.dataLabel.destroy()),s.connector&&(s.connector=s.connector.destroy())),r=s.index,n.updateParallelArrays(s,r),l.data[r]=isObject(l.data[r],!0)||isObject(e,!0)?s.options:pick(e,l.data[r]),n.isDirty=n.isDirtyData=!0,!n.fixedBox&&n.hasCartesianSeries&&(c.isDirtyBox=!0),"point"===l.legendType&&(c.isDirtyLegend=!0),o&&c.redraw(i)}o=pick(o,!0),!1===t?p():s.firePointEvent("update",{options:e},p)},l.prototype.remove=function(t,e){this.series.removePoint(this.series.data.indexOf(this),t,e)},l.prototype.select=function(t,e){var o=this,i=o.series,r=i.chart;t=pick(t,!o.selected),this.selectedStaging=t,o.firePointEvent(t?"select":"unselect",{accumulate:e},function(){o.selected=o.options.selected=t,i.options.data[i.data.indexOf(o)]=o.options,o.setState(t&&"select"),e||r.getSelectedPoints().forEach(function(t){var e=t.series;t.selected&&t!==o&&(t.selected=t.options.selected=!1,e.options.data[e.data.indexOf(t)]=t.options,t.setState(r.hoverPoints&&e.options.inactiveOtherPoints?"inactive":""),t.firePointEvent("unselect"))})}),delete this.selectedStaging},l.prototype.onMouseOver=function(t){var e=this.series.chart,o=e.pointer;t=t?o.normalize(t):o.getChartCoordinatesFromPoint(this,e.inverted),o.runPointActions(t,this)},l.prototype.onMouseOut=function(){var t=this.series.chart;this.firePointEvent("mouseOut"),this.series.options.inactiveOtherPoints||(t.hoverPoints||[]).forEach(function(t){t.setState()}),t.hoverPoints=t.hoverPoint=null},l.prototype.importEvents=function(){var o,t;this.hasImportedEvents||(t=merge((o=this).series.options.point,o.options).events,o.events=t,objectEach(t,function(t,e){isFunction(t)&&addEvent(o,e,t)}),this.hasImportedEvents=!0)},l.prototype.setState=function(t,e){var o,i,r,s,n=this,a=n.series,c=n.state,l=a.options.states[t||"normal"]||{},p=defaultOptions.plotOptions[a.type].marker&&a.options.marker,h=p&&!1===p.enabled,d=p&&p.states&&p.states[t||"normal"]||{},u=!1===d.enabled,y=a.stateMarkerGraphic,m=n.marker||{},f=a.chart,v=a.halo,g=p&&a.markerAttribs;(t=t||"")===n.state&&!e||n.selected&&"select"!==t||!1===l.enabled||t&&(u||h&&!1===d.enabled)||t&&m.states&&m.states[t]&&!1===m.states[t].enabled||(n.state=t,g&&(o=a.markerAttribs(n,t)),n.graphic&&!n.hasDummyGraphic?(c&&n.graphic.removeClass("highcharts-point-"+c),t&&n.graphic.addClass("highcharts-point-"+t),f.styledMode||(i=a.pointAttribs(n,t),r=pick(f.options.chart.animation,l.animation),a.options.inactiveOtherPoints&&isNumber(i.opacity)&&((n.dataLabels||[]).forEach(function(t){t&&t.animate({opacity:i.opacity},r)}),n.connector&&n.connector.animate({opacity:i.opacity},r)),n.graphic.animate(i,r)),o&&n.graphic.animate(o,pick(f.options.chart.animation,d.animation,p.animation)),y&&y.hide()):(t&&d&&(s=m.symbol||a.symbol,y&&y.currentSymbol!==s&&(y=y.destroy()),o&&(y?y[e?"animate":"attr"]({x:o.x,y:o.y}):s&&(a.stateMarkerGraphic=y=f.renderer.symbol(s,o.x,o.y,o.width,o.height).add(a.markerGroup),y.currentSymbol=s)),!f.styledMode&&y&&y.attr(a.pointAttribs(n,t))),y&&(y[t&&n.isInside?"show":"hide"](),y.element.point=n)),s=l.halo,y=(l=n.graphic||y)&&l.visibility||"inherit",s&&s.size&&l&&"hidden"!==y&&!n.isCluster?(v||(a.halo=v=f.renderer.path().add(l.parentGroup)),v.show()[e?"animate":"attr"]({d:n.haloPath(s.size)}),v.attr({class:"highcharts-halo highcharts-color-"+pick(n.colorIndex,a.colorIndex)+(n.className?" "+n.className:""),visibility:y,zIndex:-1}),v.point=n,f.styledMode||v.attr(extend({fill:n.color||a.color,"fill-opacity":s.opacity},AST.filterUserAttributes(s.attributes||{})))):v&&v.point&&v.point.haloPath&&v.animate({d:v.point.haloPath(0)},null,v.hide),fireEvent(n,"afterSetState",{state:t}))},l.prototype.haloPath=function(t){return this.series.chart.renderer.symbols.circle(Math.floor(this.plotX)-t,this.plotY-t,2*t,2*t)},l}();export default H.Point=Point;