"use strict";import A from"../Animation/AnimationUtilities.js";var animObject=A.animObject,setAnimation=A.setAnimation;import F from"../Foundation.js";var registerEventOptions=F.registerEventOptions;import H from"../Globals.js";var hasTouch=H.hasTouch,svg=H.svg,win=H.win;import LegendSymbolMixin from"../../Mixins/LegendSymbol.js";import D from"../DefaultOptions.js";var defaultOptions=D.defaultOptions;import palette from"../Color/Palette.js";import Point from"./Point.js";import SeriesRegistry from"./SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import SVGElement from"../Renderer/SVG/SVGElement.js";import U from"../Utilities.js";var addEvent=U.addEvent,arrayMax=U.arrayMax,arrayMin=U.arrayMin,clamp=U.clamp,cleanRecursively=U.cleanRecursively,correctFloat=U.correctFloat,defined=U.defined,erase=U.erase,error=U.error,extend=U.extend,find=U.find,fireEvent=U.fireEvent,getNestedProperty=U.getNestedProperty,isArray=U.isArray,isNumber=U.isNumber,isString=U.isString,merge=U.merge,objectEach=U.objectEach,pick=U.pick,removeEvent=U.removeEvent,splat=U.splat,syncTimeout=U.syncTimeout,Series=function(){function t(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return t.prototype.init=function(t,e){fireEvent(this,"init",{options:e});var i=this,o=t.series;this.eventsToUnbind=[],i.chart=t,i.options=i.setOptions(e);var r=i.options;i.linkedSeries=[],i.bindAxes(),extend(i,{name:r.name,state:"",visible:!1!==r.visible,selected:!0===r.selected}),registerEventOptions(this,r);var s,e=r.events;(e&&e.click||r.point&&r.point.events&&r.point.events.click||r.allowPointSelect)&&(t.runTrackerClick=!0),i.getColor(),i.getSymbol(),i.parallelArrays.forEach(function(t){i[t+"Data"]||(i[t+"Data"]=[])}),i.isCartesian&&(t.hasCartesianSeries=!0),o.length&&(s=o[o.length-1]),i._i=pick(s&&s._i,-1)+1,i.opacity=i.options.opacity,t.orderSeries(this.insert(o)),r.dataSorting&&r.dataSorting.enabled?i.setDataSortingOptions():i.points||i.data||i.setData(r.data,!1),fireEvent(this,"afterInit")},t.prototype.is=function(t){return seriesTypes[t]&&this instanceof seriesTypes[t]},t.prototype.insert=function(t){var e,i=this.options.index;if(isNumber(i)){for(e=t.length;e--;)if(i>=pick(t[e].options.index,t[e]._i)){t.splice(e+1,0,this);break}-1===e&&t.unshift(this),e+=1}else t.push(this);return pick(e,t.length-1)},t.prototype.bindAxes=function(){var o,r=this,s=r.options,t=r.chart;fireEvent(this,"bindAxes",null,function(){(r.axisTypes||[]).forEach(function(e){var i=0;t[e].forEach(function(t){o=t.options,(s[e]===i&&!o.isInternal||void 0!==s[e]&&s[e]===o.id||void 0===s[e]&&0===o.index)&&(r.insert(t.series),(r[e]=t).isDirty=!0),o.isInternal||i++}),r[e]||r.optionalAxis===e||error(18,!0,t)})}),fireEvent(this,"afterBindAxes")},t.prototype.updateParallelArrays=function(i,o){var r=i.series,e=arguments,t=isNumber(o)?function(t){var e="y"===t&&r.toYData?r.toYData(i):i[t];r[t+"Data"][o]=e}:function(t){Array.prototype[o].apply(r[t+"Data"],Array.prototype.slice.call(e,2))};r.parallelArrays.forEach(t)},t.prototype.hasData=function(){return this.visible&&void 0!==this.dataMax&&void 0!==this.dataMin||this.visible&&this.yData&&0<this.yData.length},t.prototype.autoIncrement=function(){var t,e=this.options,i=this.xIncrement,o=e.pointIntervalUnit,r=this.chart.time,i=pick(i,e.pointStart,0);return this.pointInterval=t=pick(this.pointInterval,e.pointInterval,1),o&&(e=new r.Date(i),"day"===o?r.set("Date",e,r.get("Date",e)+t):"month"===o?r.set("Month",e,r.get("Month",e)+t):"year"===o&&r.set("FullYear",e,r.get("FullYear",e)+t),t=e.getTime()-i),this.xIncrement=i+t,i},t.prototype.setDataSortingOptions=function(){var t=this.options;extend(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined(t.pointRange)||(t.pointRange=1)},t.prototype.setOptions=function(t){var e=this.chart,i=e.options,o=i.plotOptions,r=e.userOptions||{},s=merge(t),a=e.styledMode,n={plotOptions:o,userOptions:s};fireEvent(this,"setOptions",n);var t=n.plotOptions[this.type],e=r.plotOptions||{};return this.userOptions=n.userOptions,r=merge(t,o.series,r.plotOptions&&r.plotOptions[this.type],s),this.tooltipOptions=merge(defaultOptions.tooltip,defaultOptions.plotOptions.series&&defaultOptions.plotOptions.series.tooltip,defaultOptions.plotOptions[this.type].tooltip,i.tooltip.userOptions,o.series&&o.series.tooltip,o[this.type].tooltip,s.tooltip),this.stickyTracking=pick(s.stickyTracking,e[this.type]&&e[this.type].stickyTracking,e.series&&e.series.stickyTracking,!(!this.tooltipOptions.shared||this.noSharedTooltip)||r.stickyTracking),null===t.marker&&delete r.marker,this.zoneAxis=r.zoneAxis,e=this.zones=(r.zones||[]).slice(),!r.negativeColor&&!r.negativeFillColor||r.zones||(t={value:r[this.zoneAxis+"Threshold"]||r.threshold||0,className:"highcharts-negative"},a||(t.color=r.negativeColor,t.fillColor=r.negativeFillColor),e.push(t)),e.length&&defined(e[e.length-1].value)&&e.push(a?{}:{color:this.color,fillColor:this.fillColor}),fireEvent(this,"afterSetOptions",{options:r}),r},t.prototype.getName=function(){return pick(this.options.name,"Series "+(this.index+1))},t.prototype.getCyclic=function(t,e,i){var o,r,s=this.chart,a=this.userOptions,n=t+"Index",p=t+"Counter",l=i?i.length:pick(s.options.chart[t+"Count"],s[t+"Count"]);e||(r=pick(a[n],a["_"+n]),defined(r)?o=r:(s.series.length||(s[p]=0),a["_"+n]=o=s[p]%l,s[p]+=1),i&&(e=i[o])),void 0!==o&&(this[n]=o),this[t]=e},t.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions.plotOptions[this.type].color,this.chart.options.colors)},t.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},t.prototype.getSymbol=function(){var t=this.options.marker;this.getCyclic("symbol",t.symbol,this.chart.options.symbols)},t.prototype.findPointIndex=function(e,t){var i,o,r,s,a=e.id,n=e.x,p=this.points,l=this.options.dataSorting;if(a)i=this.chart.get(a);else if((this.linkedParent||this.enabledDataSorting)&&(s=l&&l.matchByName?"name":"index",!(i=find(p,function(t){return!t.touched&&t[s]===e[s]}))))return;return i&&void 0!==(r=i&&i.index)&&(o=!0),-1!==(r=void 0===r&&isNumber(n)?this.xData.indexOf(n,t):r)&&void 0!==r&&this.cropped&&(r=r>=this.cropStart?r-this.cropStart:r),r=!o&&p[r]&&p[r].touched?void 0:r},t.prototype.updateData=function(t,e){var r,i,o,s,a=this.options,n=a.dataSorting,p=this.points,l=[],h=this.requireSorting,d=t.length===p.length,c=!0;if(this.xIncrement=null,t.forEach(function(t,e){var i=defined(t)&&this.pointClass.prototype.optionsToObject.call({series:this},t)||{},o=i.x;i.id||isNumber(o)?(-1===(i=this.findPointIndex(i,s))||void 0===i?l.push(t):p[i]&&t!==a.data[i]?(p[i].update(t,!1,null,!1),p[i].touched=!0,h&&(s=i+1)):p[i]&&(p[i].touched=!0),(!d||e!==i||n&&n.enabled||this.hasDerivedData)&&(r=!0)):l.push(t)},this),r)for(i=p.length;i--;)(o=p[i])&&!o.touched&&o.remove&&o.remove(!1,e);else!d||n&&n.enabled?c=!1:(t.forEach(function(t,e){t!==p[e].y&&p[e].update&&p[e].update(t,!1,null,!1)}),l.length=0);return p.forEach(function(t){t&&(t.touched=!1)}),!!c&&(l.forEach(function(t){this.addPoint(t,!1,null,null,!1)},this),null===this.xIncrement&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax(this.xData),this.autoIncrement()),!0)},t.prototype.setData=function(t,e,i,o){var r,s,a,n,p=this,l=p.points,h=l&&l.length||0,d=p.options,c=p.chart,u=d.dataSorting,y=p.xAxis,f=d.turboThreshold,v=this.xData,g=this.yData,m=p.pointArrayMap,x=m&&m.length,m=d.keys,k=0,b=1,D=(t=t||[]).length;if(e=pick(e,!0),u&&u.enabled&&(t=this.sortData(t)),!(n=!1!==o&&D&&h&&!p.cropped&&!p.hasGroupedData&&p.visible&&!p.isSeriesBoosting?this.updateData(t,i):n)){if(p.xIncrement=null,p.colorCounter=0,this.parallelArrays.forEach(function(t){p[t+"Data"].length=0}),f&&f<D)if(r=p.getFirstValidPoint(t),isNumber(r))for(s=0;s<D;s++)v[s]=this.autoIncrement(),g[s]=t[s];else if(isArray(r))if(x)for(s=0;s<D;s++)a=t[s],v[s]=a[0],g[s]=a.slice(1,x+1);else for(m&&(k=0<=(k=m.indexOf("x"))?k:0,b=0<=(b=m.indexOf("y"))?b:1),s=0;s<D;s++)a=t[s],v[s]=a[k],g[s]=a[b];else error(12,!1,c);else for(s=0;s<D;s++)void 0!==t[s]&&(p.pointClass.prototype.applyOptions.apply(a={series:p},[t[s]]),p.updateParallelArrays(a,s));for(g&&isString(g[0])&&error(14,!0,c),p.data=[],p.options.data=p.userOptions.data=t,s=h;s--;)l[s]&&l[s].destroy&&l[s].destroy();y&&(y.minRange=y.userMinRange),p.isDirty=c.isDirtyBox=!0,p.isDirtyData=!!l,i=!1}"point"===d.legendType&&(this.processData(),this.generatePoints()),e&&c.redraw(i)},t.prototype.sortData=function(r){function s(t,e){return defined(e)&&t.pointClass.prototype.optionsToObject.call({series:t},e)||{}}var i=this,o=i.options.dataSorting.sortKey||"y";return r.forEach(function(t,e){r[e]=s(i,t),r[e].index=e},this),r.concat().sort(function(t,e){t=getNestedProperty(o,t),e=getNestedProperty(o,e);return e<t?-1:t<e?1:0}).forEach(function(t,e){t.x=e},this),i.linkedSeries&&i.linkedSeries.forEach(function(i){var t=i.options,o=t.data;t.dataSorting&&t.dataSorting.enabled||!o||(o.forEach(function(t,e){o[e]=s(i,t),r[e]&&(o[e].x=r[e].x,o[e].index=e)}),i.setData(o,!1))}),r},t.prototype.getProcessedData=function(t){var e,i,o,r,s,a,n=this,p=n.xData,l=n.yData,h=p.length,d=0,c=n.xAxis,u=n.options,y=u.cropThreshold,t=t||n.getExtremesFromAll||u.getExtremesFromAll,u=n.isCartesian,f=c&&c.val2lin,v=!(!c||!c.logarithmic),g=n.requireSorting;for(c&&(s=(a=c.getExtremes()).min,a=a.max),u&&n.sorted&&!t&&(!y||y<h||n.forceCrop)&&(p[h-1]<s||p[0]>a?(p=[],l=[]):n.yData&&(p[0]<s||p[h-1]>a)&&(p=(e=this.cropData(n.xData,n.yData,s,a)).xData,l=e.yData,d=e.start,e=!0)),r=p.length||1;--r;)0<(i=v?f(p[r])-f(p[r-1]):p[r]-p[r-1])&&(void 0===o||i<o)?o=i:i<0&&g&&(error(15,!1,n.chart),g=!1);return{xData:p,yData:l,cropped:e,cropStart:d,closestPointRange:o}},t.prototype.processData=function(t){var e=this,i=e.xAxis;if(e.isCartesian&&!e.isDirty&&!i.isDirty&&!e.yAxis.isDirty&&!t)return!1;t=e.getProcessedData(),e.cropped=t.cropped,e.cropStart=t.cropStart,e.processedXData=t.xData,e.processedYData=t.yData,e.closestPointRange=e.basePointRange=t.closestPointRange},t.prototype.cropData=function(t,e,i,o,r){var s,a,n=t.length,p=0,l=n;for(r=pick(r,this.cropShoulder),s=0;s<n;s++)if(t[s]>=i){p=Math.max(0,s-r);break}for(a=s;a<n;a++)if(t[a]>o){l=a+r;break}return{xData:t.slice(p,l),yData:e.slice(p,l),start:p,end:l}},t.prototype.generatePoints=function(){var t,e,i,o,r=this,s=r.options,a=s.data,n=r.data,p=r.processedXData,l=r.processedYData,h=r.pointClass,d=p.length,c=r.cropStart||0,u=r.hasGroupedData,y=s.keys,f=[],v=s.dataGrouping&&s.dataGrouping.groupAll?c:0;for(n||u||((s=[]).length=a.length,n=r.data=s),y&&u&&(r.options.keys=!1),o=0;o<d;o++)e=c+o,u?((i=(new h).init(r,[p[o]].concat(splat(l[o])))).dataGroup=r.groupMap[v+o],i.dataGroup.options&&(i.options=i.dataGroup.options,extend(i,i.dataGroup.options),delete i.dataLabels)):(i=n[e])||void 0===a[e]||(n[e]=i=(new h).init(r,a[e],p[o])),i&&(i.index=u?v+o:e,f[o]=i);if(r.options.keys=y,n&&(d!==(t=n.length)||u))for(o=0;o<t;o++)o!==c||u||(o+=d),n[o]&&(n[o].destroyElements(),n[o].plotX=void 0);r.data=n,r.points=f,fireEvent(this,"afterGeneratePoints")},t.prototype.getXExtremes=function(t){return{min:arrayMin(t),max:arrayMax(t)}},t.prototype.getExtremes=function(t,e){var i,o,r,s,a,n=this.xAxis,p=this.yAxis,l=this.processedXData||this.xData,h=[],d=0,c=0,u=0,y=this.requireSorting?this.cropShoulder:0,f=!!p&&p.positiveValuesOnly,v=(t=t||this.stackedYData||this.processedYData||[]).length;for(n&&(c=(g=n.getExtremes()).min,u=g.max),s=0;s<v;s++)if(o=l[s],r=t[s],i=(isNumber(r)||isArray(r))&&(r.length||0<r||!f),o=e||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!n||(l[s+y]||o)>=c&&(l[s-y]||o)<=u,i&&o)if(a=r.length)for(;a--;)isNumber(r[a])&&(h[d++]=r[a]);else h[d++]=r;var g={dataMin:arrayMin(h),dataMax:arrayMax(h)};return fireEvent(this,"afterGetExtremes",{dataExtremes:g}),g},t.prototype.applyExtremes=function(){var t=this.getExtremes();return this.dataMin=t.dataMin,this.dataMax=t.dataMax,t},t.prototype.getFirstValidPoint=function(t){for(var e=null,i=t.length,o=0;null===e&&o<i;)e=t[o],o++;return e},t.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var t,e,i,o,r=this,s=r.options,a=s.stacking,n=r.xAxis,p=n.categories,l=r.enabledDataSorting,h=r.yAxis,d=r.points,c=d.length,u=!!r.modifyValue,y=r.pointPlacementToXValue(),f=Boolean(y),v=s.threshold,g=s.startFromThreshold?v:0,m=this.zoneAxis||"y",x=Number.MAX_VALUE;function k(t){return clamp(t,-1e5,1e5)}for(t=0;t<c;t++){var b=d[t],D=b.x,A=b.y,S=b.low,E=a&&h.stacking&&h.stacking.stacks[(r.negStacks&&A<(g?0:v)?"-":"")+r.stackKey],O=void 0,P=void 0;(h.positiveValuesOnly&&!h.validatePositiveValue(A)||n.positiveValuesOnly&&!n.validatePositiveValue(D))&&(b.isNull=!0),b.plotX=e=correctFloat(k(n.translate(D,0,0,0,1,y,"flags"===this.type))),a&&r.visible&&E&&E[D]&&(o=r.getStackIndicator(o,D,r.index),b.isNull||(P=(O=E[D]).points[o.key])),isArray(P)&&(S=P[0],A=P[1],S===g&&o.key===E[D].base&&(S=pick(isNumber(v)&&v,h.min)),h.positiveValuesOnly&&S<=0&&(S=null),b.total=b.stackTotal=O.total,b.percentage=O.total&&b.y/O.total*100,b.stackY=A,r.irregularWidths||O.setOffset(r.pointXOffset||0,r.barW||0)),b.yBottom=defined(S)?k(h.translate(S,0,1,0,1)):null,u&&(A=r.modifyValue(A,b)),b.plotY=void 0,!isNumber(A)||void 0!==(A=h.translate(A,!1,!0,!1,!0))&&(b.plotY=k(A)),b.isInside=this.isPointInside(b),b.clientX=f?correctFloat(n.translate(D,0,0,0,1,y)):e,b.negative=b[m]<(s[m+"Threshold"]||v||0),b.category=p&&void 0!==p[b.x]?p[b.x]:b.x,b.isNull||!1===b.visible||(void 0!==i&&(x=Math.min(x,Math.abs(e-i))),i=e),b.zone=this.zones.length&&b.getZone(),!b.graphic&&r.group&&l&&(b.isNew=!0)}r.closestPointRangePx=x,fireEvent(this,"afterTranslate")},t.prototype.getValidPoints=function(t,e,i){var o=this.chart;return(t||this.points||[]).filter(function(t){return!(e&&!o.isInsidePlot(t.plotX,t.plotY,{inverted:o.inverted}))&&(!1!==t.visible&&(i||!t.isNull))})},t.prototype.getClipBox=function(t,e){var i,o=this,r=o.options,s=o.chart,a=s.inverted,n=o.xAxis,p=n&&o.yAxis,l=s.options.chart.scrollablePlotArea||{};return t&&!1===r.clip&&p?i=a?{y:-s.chartWidth+p.len+p.pos,height:s.chartWidth,width:s.chartHeight,x:-s.chartHeight+n.len+n.pos}:{y:-p.pos,height:s.chartHeight,width:s.chartWidth,x:-n.pos}:(i=o.clipBox||s.clipBox,e&&(i.width=s.plotSizeX,i.x=(s.scrollablePixelsX||0)*(l.scrollPositionX||0))),e?{width:i.width,x:i.x}:i},t.prototype.getSharedClipKey=function(t){if(this.sharedClipKey)return this.sharedClipKey;var e=[t&&t.duration,t&&t.easing,t&&t.defer,this.getClipBox(t).height,this.options.xAxis,this.options.yAxis].join(",");return!1===this.options.clip&&!t||(this.sharedClipKey=e),e},t.prototype.setClip=function(t){var e=this.chart,i=this.options,o=e.renderer,r=e.inverted,s=this.clipBox,a=this.getClipBox(t),n=this.getSharedClipKey(t),p=e.sharedClips[n],l=e.sharedClips[n+"m"];t&&(a.width=0,r&&(a.x=e.plotHeight+(!1!==i.clip?0:e.plotTop))),p?e.hasLoaded||p.attr(a):(t&&(e.sharedClips[n+"m"]=l=o.clipRect(r?(e.plotSizeX||0)+99:-99,r?-e.plotLeft:-e.plotTop,99,r?e.chartWidth:e.chartHeight)),e.sharedClips[n]=p=o.clipRect(a),p.count={length:0}),t&&(p.count[this.index]||(p.count[this.index]=!0,p.count.length+=1)),!1===i.clip&&!t||(this.group.clip(t||s?p:e.clipRect),this.markerGroup.clip(l)),t||(p.count[this.index]&&(delete p.count[this.index],--p.count.length),0===p.count.length&&(s||(e.sharedClips[n]=p.destroy()),l&&(e.sharedClips[n+"m"]=l.destroy())))},t.prototype.animate=function(t){var e,i=this.chart,o=animObject(this.options.animation),r=this.sharedClipKey;t?this.setClip(o):r&&(e=i.sharedClips[r],t=i.sharedClips[r+"m"],r=this.getClipBox(o,!0),e&&e.animate(r,o),t&&t.animate({width:r.width+99,x:r.x-(i.inverted?0:99)},o))},t.prototype.afterAnimate=function(){this.setClip(),fireEvent(this,"afterAnimate"),this.finishedAnimating=!0},t.prototype.drawPoints=function(){var t,e=this,i=e.points,o=e.chart,r=e.options.marker,s=e[e.specialGroup]||e.markerGroup,a=e.xAxis,n=pick(r.enabled,!(a&&!a.isRadial)||null,e.closestPointRangePx>=r.enabledThreshold*r.radius);if(!1!==r.enabled||e._hasPointMarkers)for(t=0;t<i.length;t++){var p,l,h,d,c,u=(l=(p=i[t]).graphic)?"animate":"attr",y=p.marker||{},f=!!p.marker;(n&&void 0===y.enabled||y.enabled)&&!p.isNull&&!1!==p.visible?(h=pick(y.symbol,e.symbol,"rect"),d=e.markerAttribs(p,p.selected&&"select"),e.enabledDataSorting&&(p.startXPos=a.reversed?-(d.width||0):a.width),c=!1!==p.isInside,l?l[c?"show":"hide"](c).animate(d):c&&(0<(d.width||0)||p.hasImage)&&(p.graphic=l=o.renderer.symbol(h,d.x,d.y,d.width,d.height,f?y:r).add(s),e.enabledDataSorting&&o.hasRendered&&(l.attr({x:p.startXPos}),u="animate")),l&&"animate"===u&&l[c?"show":"hide"](c).animate(d),l&&!o.styledMode&&l[u](e.pointAttribs(p,p.selected&&"select")),l&&l.addClass(p.getClassName(),!0)):l&&(p.graphic=l.destroy())}},t.prototype.markerAttribs=function(t,e){var i=this.options,o=i.marker,r=t.marker||{},s=r.symbol||o.symbol,a=pick(r.radius,o.radius);return e&&(o=o.states[e],e=r.states&&r.states[e],a=pick(e&&e.radius,o&&o.radius,a+(o&&o.radiusPlus||0))),t.hasImage=s&&0===s.indexOf("url"),t.hasImage&&(a=0),t={x:i.crisp?Math.floor(t.plotX-a):t.plotX-a,y:t.plotY-a},a&&(t.width=t.height=2*a),t},t.prototype.pointAttribs=function(t,e){var i=this.options.marker,o=t&&t.options,r=o&&o.marker||{},s=this.color,a=o&&o.color,n=t&&t.color,p=pick(r.lineWidth,i.lineWidth),o=t&&t.zone&&t.zone.color,t=1,s=a||o||n||s,n=r.fillColor||i.fillColor||s,s=r.lineColor||i.lineColor||s;return(e=e||"normal")&&(i=i.states[e],e=r.states&&r.states[e]||{},p=pick(e.lineWidth,i.lineWidth,p+pick(e.lineWidthPlus,i.lineWidthPlus,0)),n=e.fillColor||i.fillColor||n,s=e.lineColor||i.lineColor||s,t=pick(e.opacity,i.opacity,t)),{stroke:s,"stroke-width":p,fill:n,opacity:t}},t.prototype.destroy=function(i){var t,e,o,r=this,s=r.chart,a=/AppleWebKit\/533/.test(win.navigator.userAgent),n=r.data||[];for(fireEvent(r,"destroy"),this.removeEvents(i),(r.axisTypes||[]).forEach(function(t){(o=r[t])&&o.series&&(erase(o.series,r),o.isDirty=o.forceRedraw=!0)}),r.legendItem&&r.chart.legend.destroyItem(r),t=n.length;t--;)(e=n[t])&&e.destroy&&e.destroy();r.clips&&r.clips.forEach(function(t){return t.destroy()}),U.clearTimeout(r.animationTimeout),objectEach(r,function(t,e){t instanceof SVGElement&&!t.survive&&t[a&&"group"===e?"hide":"destroy"]()}),s.hoverSeries===r&&(s.hoverSeries=void 0),erase(s.series,r),s.orderSeries(),objectEach(r,function(t,e){i&&"hcEvents"===e||delete r[e]})},t.prototype.applyZones=function(){var i,o,r,s,a,n,p,l,h=this,d=this.chart,c=d.renderer,t=this.zones,u=this.clips||[],y=this.graph,f=this.area,v=Math.max(d.chartWidth,d.chartHeight),g=this[(this.zoneAxis||"y")+"Axis"],m=d.inverted,x=!1;t.length&&(y||f)&&g&&void 0!==g.min?(s=g.reversed,a=g.horiz,y&&!this.showLine&&y.hide(),f&&f.hide(),r=g.getExtremes(),t.forEach(function(t,e){l=s?a?d.plotWidth:0:!a&&g.toPixels(r.min)||0,l=clamp(pick(i,l),0,v),i=clamp(Math.round(g.toPixels(pick(t.value,r.max),!0)||0),0,v),x&&(l=i=g.toPixels(r.max)),n=Math.abs(l-i),p=Math.min(l,i),l=Math.max(l,i),g.isXAxis?(o={x:m?l:p,y:0,width:n,height:v},a||(o.x=d.plotHeight-o.x)):(o={x:0,y:m?l:p,width:v,height:n},a&&(o.y=d.plotWidth-o.y)),m&&c.isVML&&(o=g.isXAxis?{x:0,y:s?p:l,height:o.width,width:d.chartWidth}:{x:o.y-d.plotLeft-d.spacingBox.x,y:0,width:o.height,height:d.chartHeight}),u[e]?u[e].animate(o):u[e]=c.clipRect(o),p=h["zone-area-"+e],l=h["zone-graph-"+e],y&&l&&l.clip(u[e]),f&&p&&p.clip(u[e]),x=t.value>r.max,h.resetZones&&0===i&&(i=void 0)}),this.clips=u):h.visible&&(y&&y.show(!0),f&&f.show(!0))},t.prototype.invertGroups=function(e){var i=this,o=i.chart;function t(){["group","markerGroup"].forEach(function(t){i[t]&&(o.renderer.isVML&&i[t].attr({width:i.yAxis.len,height:i.xAxis.len}),i[t].width=i.yAxis.len,i[t].height=i.xAxis.len,i[t].invert(!i.isRadialSeries&&e))})}i.xAxis&&(i.eventsToUnbind.push(addEvent(o,"resize",t)),t(),i.invertGroups=t)},t.prototype.plotGroup=function(t,e,i,o,r){var s=this[t],a=!s,o={visibility:i,zIndex:o||.1};return void 0===this.opacity||this.chart.styledMode||"inactive"===this.state||(o.opacity=this.opacity),a&&(this[t]=s=this.chart.renderer.g().add(r)),s.addClass("highcharts-"+e+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(s.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),s.attr(o)[a?"attr":"animate"](this.getPlotBox()),s},t.prototype.getPlotBox=function(){var t=this.chart,e=this.xAxis,i=this.yAxis;return t.inverted&&(e=i,i=this.xAxis),{translateX:e?e.left:t.plotLeft,translateY:i?i.top:t.plotTop,scaleX:1,scaleY:1}},t.prototype.removeEvents=function(t){t||removeEvent(this),this.eventsToUnbind.length&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind.length=0)},t.prototype.render=function(){var t,e=this,i=e.chart,o=e.options,r=animObject(o.animation),s=!e.finishedAnimating&&i.renderer.isSVG&&r.duration,a=e.visible?"inherit":"hidden",n=o.zIndex,p=e.hasRendered,l=i.seriesGroup,h=i.inverted;fireEvent(this,"render"),t=e.plotGroup("group","series",a,n,l),e.markerGroup=e.plotGroup("markerGroup","markers",a,n,l),s&&e.animate&&e.animate(!0),t.inverted=!!pick(e.invertible,e.isCartesian)&&h,e.drawGraph&&(e.drawGraph(),e.applyZones()),e.visible&&e.drawPoints(),e.drawDataLabels&&e.drawDataLabels(),e.redrawPoints&&e.redrawPoints(),e.drawTracker&&!1!==e.options.enableMouseTracking&&e.drawTracker(),e.invertGroups(h),!1===o.clip||e.sharedClipKey||p||t.clip(i.clipRect),s&&e.animate&&e.animate(),p||(s&&r.defer&&(s+=r.defer),e.animationTimeout=syncTimeout(function(){e.afterAnimate()},s||0)),e.isDirty=!1,e.hasRendered=!0,fireEvent(e,"afterRender")},t.prototype.redraw=function(){var t=this,e=t.chart,i=t.isDirty||t.isDirtyData,o=t.group,r=t.xAxis,s=t.yAxis;o&&(e.inverted&&o.attr({width:e.plotWidth,height:e.plotHeight}),o.animate({translateX:pick(r&&r.left,e.plotLeft),translateY:pick(s&&s.top,e.plotTop)})),t.translate(),t.render(),i&&delete this.kdTree},t.prototype.searchPoint=function(t,e){var i=this.xAxis,o=this.yAxis,r=this.chart.inverted;return this.searchKDTree({clientX:r?i.len-t.chartY+i.pos:t.chartX-i.pos,plotY:r?o.len-t.chartX+o.pos:t.chartY-o.pos},e,t)},t.prototype.buildKDTree=function(t){this.buildingKdTree=!0;var a=this,e=-1<a.options.findNearestPointBy.indexOf("y")?2:1;delete a.kdTree,syncTimeout(function(){a.kdTree=function t(e,i,o){var r,s=e&&e.length;if(s)return r=a.kdAxisArray[i%o],e.sort(function(t,e){return t[r]-e[r]}),{point:e[s=Math.floor(s/2)],left:t(e.slice(0,s),i+1,o),right:t(e.slice(s+1),i+1,o)}}(a.getValidPoints(null,!a.directTouch),e,e),a.buildingKdTree=!1},a.options.kdNow||t&&"touchstart"===t.type?0:1)},t.prototype.searchKDTree=function(t,e,i){var h=this,d=this.kdAxisArray[0],c=this.kdAxisArray[1],u=e?"distX":"dist",e=-1<h.options.findNearestPointBy.indexOf("y")?2:1;function y(t,e,i,o){var r,s,a,n=e.point,p=h.kdAxisArray[i%o],l=n;return s=n,r=((a=defined((r=t)[d])&&defined(s[d])?Math.pow(r[d]-s[d],2):null)||0)+((defined(r[c])&&defined(s[c])?Math.pow(r[c]-s[c],2):null)||0),s.dist=defined(r)?Math.sqrt(r):Number.MAX_VALUE,s.distX=defined(a)?Math.sqrt(a):Number.MAX_VALUE,a=(s=t[p]-n[p])<0?"right":"left",e[p=s<0?"left":"right"]&&(l=(p=y(t,e[p],i+1,o))[u]<l[u]?p:n),l=e[a]&&Math.sqrt(s*s)<l[u]?(o=y(t,e[a],i+1,o))[u]<l[u]?o:l:l}if(this.kdTree||this.buildingKdTree||this.buildKDTree(i),this.kdTree)return y(t,this.kdTree,e,e)},t.prototype.pointPlacementToXValue=function(){var t=this.options,e=t.pointPlacement,i=t.pointRange,t=this.xAxis,e=e;return"between"===e&&(e=t.reversed?-.5:.5),isNumber(e)?e*(i||t.pointRange):0},t.prototype.isPointInside=function(t){return void 0!==t.plotY&&void 0!==t.plotX&&0<=t.plotY&&t.plotY<=this.yAxis.len&&0<=t.plotX&&t.plotX<=this.xAxis.len},t.prototype.drawTracker=function(){function e(t){s.hoverSeries!==i&&i.onMouseOver()}var i=this,o=i.options,t=o.trackByArea,r=[].concat(t?i.areaPath:i.graphPath),s=i.chart,a=s.pointer,n=s.renderer,p=s.options.tooltip.snap,l=i.tracker,h="rgba(192,192,192,"+(svg?1e-4:.002)+")";l?l.attr({d:r}):i.graph&&(i.tracker=n.path(r).attr({visibility:i.visible?"visible":"hidden",zIndex:2}).addClass(t?"highcharts-tracker-area":"highcharts-tracker-line").add(i.group),s.styledMode||i.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:h,fill:t?h:"none","stroke-width":i.graph.strokeWidth()+(t?0:2*p)}),[i.tracker,i.markerGroup,i.dataLabelsGroup].forEach(function(t){t&&(t.addClass("highcharts-tracker").on("mouseover",e).on("mouseout",function(t){a.onTrackerMouseOut(t)}),o.cursor&&!s.styledMode&&t.css({cursor:o.cursor}),hasTouch&&t.on("touchstart",e))})),fireEvent(this,"afterDrawTracker")},t.prototype.addPoint=function(t,e,i,o,r){var s,a,n,p=this,l=p.options,h=p.data,d=p.chart,c=p.xAxis,u=c&&c.hasNames&&c.names,y=l.data,f=p.xData;if(e=pick(e,!0),p.pointClass.prototype.applyOptions.apply(c={series:p},[t]),n=c.x,a=f.length,p.requireSorting&&n<f[a-1])for(s=!0;a&&f[a-1]>n;)a--;p.updateParallelArrays(c,"splice",a,0,0),p.updateParallelArrays(c,a),u&&c.name&&(u[n]=c.name),y.splice(a,0,t),s&&(p.data.splice(a,0,null),p.processData()),"point"===l.legendType&&p.generatePoints(),i&&(h[0]&&h[0].remove?h[0].remove(!1):(h.shift(),p.updateParallelArrays(c,"shift"),y.shift())),!1!==r&&fireEvent(p,"addPoint",{point:c}),p.isDirty=!0,p.isDirtyData=!0,e&&d.redraw(o)},t.prototype.removePoint=function(t,e,i){function o(){n&&n.length===s.length&&n.splice(t,1),s.splice(t,1),r.options.data.splice(t,1),r.updateParallelArrays(a||{series:r},"splice",t,1),a&&a.destroy(),r.isDirty=!0,r.isDirtyData=!0,e&&p.redraw()}var r=this,s=r.data,a=s[t],n=r.points,p=r.chart;setAnimation(i,p),e=pick(e,!0),a?a.firePointEvent("remove",null,o):o()},t.prototype.remove=function(t,e,i,o){var r=this,s=r.chart;function a(){r.destroy(o),s.isDirtyLegend=s.isDirtyBox=!0,s.linkSeries(),pick(t,!0)&&s.redraw(e)}!1!==i?fireEvent(r,"remove",null,a):a()},t.prototype.update=function(t,e){t=cleanRecursively(t,this.userOptions),fireEvent(this,"update",{options:t});var i,o=this,r=o.chart,s=o.userOptions,a=o.initialType||o.type,n=r.options.plotOptions,p=t.type||s.type||r.options.chart.type,l=!(this.hasDerivedData||p&&p!==this.type||void 0!==t.pointStart||void 0!==t.pointInterval||o.hasOptionChanged("dataGrouping")||o.hasOptionChanged("pointStart")||o.hasOptionChanged("pointInterval")||o.hasOptionChanged("pointIntervalUnit")||o.hasOptionChanged("keys")),h=seriesTypes[a].prototype,d=["eventOptions","navigatorSeries","baseSeries"],c=o.finishedAnimating&&{animation:!1},u={},p=p||a;l&&(d.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),!1!==t.visible&&d.push("area","graph"),o.parallelArrays.forEach(function(t){d.push(t+"Data")}),t.data&&(t.dataSorting&&extend(o.options.dataSorting,t.dataSorting),this.setData(t.data,!1))),t=merge(s,c,{index:(void 0===s.index?o:s).index,pointStart:pick(n&&n.series&&n.series.pointStart,s.pointStart,o.xData[0])},!l&&{data:o.options.data},t),l&&t.data&&(t.data=o.options.data),(d=["group","markerGroup","dataLabelsGroup","transformGroup"].concat(d)).forEach(function(t){d[t]=o[t],delete o[t]});var y,n=!1;if(seriesTypes[p]){if(n=p!==o.type,o.remove(!1,!1,!1,!0),n)if(Object.setPrototypeOf)Object.setPrototypeOf(o,seriesTypes[p].prototype);else{s=Object.hasOwnProperty.call(o,"hcEvents")&&o.hcEvents;for(i in h)o[i]=void 0;extend(o,seriesTypes[p].prototype),s?o.hcEvents=s:delete o.hcEvents}}else error(17,!0,r,{missingModuleFor:p});d.forEach(function(t){o[t]=d[t]}),o.init(r,t),l&&this.points&&(!1===(y=o.options).visible?(u.graphic=1,u.dataLabel=1):o._hasPointLabels||(p=y.marker,t=y.dataLabels,p&&(!1===p.enabled||"symbol"in p)&&(u.graphic=1),t&&!1===t.enabled&&(u.dataLabel=1)),this.points.forEach(function(t){t&&t.series&&(t.resolveColor(),Object.keys(u).length&&t.destroyElements(u),!1===y.showInLegend&&t.legendItem&&r.legend.destroyItem(t))},this)),o.initialType=a,r.linkSeries(),n&&o.linkedSeries.length&&(o.isDirtyData=!0),fireEvent(this,"afterUpdate"),pick(e,!0)&&r.redraw(l&&void 0)},t.prototype.setName=function(t){this.name=this.options.name=this.userOptions.name=t,this.chart.isDirtyLegend=!0},t.prototype.hasOptionChanged=function(t){var e=this.chart,i=this.options[t],o=e.options.plotOptions,e=this.userOptions[t];return e?i!==e:i!==pick(o&&o[this.type]&&o[this.type][t],o&&o.series&&o.series[t],i)},t.prototype.onMouseOver=function(){var t=this,e=t.chart,i=e.hoverSeries;e.pointer.setHoverChartIndex(),i&&i!==t&&i.onMouseOut(),t.options.events.mouseOver&&fireEvent(t,"mouseOver"),t.setState("hover"),e.hoverSeries=t},t.prototype.onMouseOut=function(){var t=this,e=t.options,i=t.chart,o=i.tooltip,r=i.hoverPoint;i.hoverSeries=null,r&&r.onMouseOut(),t&&e.events.mouseOut&&fireEvent(t,"mouseOut"),!o||t.stickyTracking||o.shared&&!t.noSharedTooltip||o.hide(),i.series.forEach(function(t){t.setState("",!0)})},t.prototype.setState=function(e,t){var i,o=this,r=o.options,s=o.graph,a=r.inactiveOtherPoints,n=r.states,p=r.lineWidth,l=r.opacity,h=pick(n[e||"normal"]&&n[e||"normal"].animation,o.chart.options.chart.animation),d=0;if(e=e||"",o.state!==e&&([o.group,o.markerGroup,o.dataLabelsGroup].forEach(function(t){t&&(o.state&&t.removeClass("highcharts-series-"+o.state),e&&t.addClass("highcharts-series-"+e))}),o.state=e,!o.chart.styledMode)){if(n[e]&&!1===n[e].enabled)return;if(e&&(p=n[e].lineWidth||p+(n[e].lineWidthPlus||0),l=pick(n[e].opacity,l)),s&&!s.dashstyle)for(s.animate(i={"stroke-width":p},h);o["zone-graph-"+d];)o["zone-graph-"+d].animate(i,h),d+=1;a||[o.group,o.markerGroup,o.dataLabelsGroup,o.labelBySeries].forEach(function(t){t&&t.animate({opacity:l},h)})}t&&a&&o.points&&o.setAllPointsToState(e||void 0)},t.prototype.setAllPointsToState=function(e){this.points.forEach(function(t){t.setState&&t.setState(e)})},t.prototype.setVisible=function(e,t){var i,o=this,r=o.chart,s=o.legendItem,a=r.options.chart.ignoreHiddenSeries,n=o.visible;o.visible=e=o.options.visible=o.userOptions.visible=void 0===e?!n:e,i=e?"show":"hide",["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(t){o[t]&&o[t][i]()}),r.hoverSeries!==o&&(r.hoverPoint&&r.hoverPoint.series)!==o||o.onMouseOut(),s&&r.legend.colorizeItem(o,e),o.isDirty=!0,o.options.stacking&&r.series.forEach(function(t){t.options.stacking&&t.visible&&(t.isDirty=!0)}),o.linkedSeries.forEach(function(t){t.setVisible(e,!1)}),a&&(r.isDirtyBox=!0),fireEvent(o,i),!1!==t&&r.redraw()},t.prototype.show=function(){this.setVisible(!0)},t.prototype.hide=function(){this.setVisible(!1)},t.prototype.select=function(t){var e=this;e.selected=t=this.options.selected=void 0===t?!e.selected:t,e.checkbox&&(e.checkbox.checked=t),fireEvent(e,t?"select":"unselect")},t.prototype.shouldShowTooltip=function(t,e,i){return(i=void 0===i?{}:i).series=this,i.visiblePlotOnly=!0,this.chart.isInsidePlot(t,e,i)},t.defaultOptions={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var t=this.series.chart.numberFormatter;return"number"!=typeof this.y?"":t(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},t}();extend(Series.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbolMixin.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point,requireSorting:!0,sorted:!0});export default SeriesRegistry.series=Series;