"use strict";import U from"../../Core/Utilities.js";var clamp=U.clamp,error=U.error,pick=U.pick;function GLShader(s){var a,r,n,l,t,f,u,x,b,m,c,d=["#version 100","#define LN10 2.302585092994046","precision highp float;","attribute vec4 aVertexPosition;","attribute vec4 aColor;","varying highp vec2 position;","varying highp vec4 vColor;","uniform mat4 uPMatrix;","uniform float pSize;","uniform float translatedThreshold;","uniform bool hasThreshold;","uniform bool skipTranslation;","uniform float xAxisTrans;","uniform float xAxisMin;","uniform float xAxisMinPad;","uniform float xAxisPointRange;","uniform float xAxisLen;","uniform bool  xAxisPostTranslate;","uniform float xAxisOrdinalSlope;","uniform float xAxisOrdinalOffset;","uniform float xAxisPos;","uniform bool  xAxisCVSCoord;","uniform bool  xAxisIsLog;","uniform bool  xAxisReversed;","uniform float yAxisTrans;","uniform float yAxisMin;","uniform float yAxisMinPad;","uniform float yAxisPointRange;","uniform float yAxisLen;","uniform bool  yAxisPostTranslate;","uniform float yAxisOrdinalSlope;","uniform float yAxisOrdinalOffset;","uniform float yAxisPos;","uniform bool  yAxisCVSCoord;","uniform bool  yAxisIsLog;","uniform bool  yAxisReversed;","uniform bool  isBubble;","uniform bool  bubbleSizeByArea;","uniform float bubbleZMin;","uniform float bubbleZMax;","uniform float bubbleZThreshold;","uniform float bubbleMinSize;","uniform float bubbleMaxSize;","uniform bool  bubbleSizeAbs;","uniform bool  isInverted;","float bubbleRadius(){","float value = aVertexPosition.w;","float zMax = bubbleZMax;","float zMin = bubbleZMin;","float radius = 0.0;","float pos = 0.0;","float zRange = zMax - zMin;","if (bubbleSizeAbs){","value = value - bubbleZThreshold;","zMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);","zMin = 0.0;","}","if (value < zMin){","radius = bubbleZMin / 2.0 - 1.0;","} else {","pos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;","if (bubbleSizeByArea && pos > 0.0){","pos = sqrt(pos);","}","radius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;","}","return radius * 2.0;","}","float translate(float val,","float pointPlacement,","float localA,","float localMin,","float minPixelPadding,","float pointRange,","float len,","bool  cvsCoord,","bool  isLog,","bool  reversed","){","float sign = 1.0;","float cvsOffset = 0.0;","if (cvsCoord) {","sign *= -1.0;","cvsOffset = len;","}","if (isLog) {","val = log(val) / LN10;","}","if (reversed) {","sign *= -1.0;","cvsOffset -= sign * len;","}","return sign * (val - localMin) * localA + cvsOffset + ","(sign * minPixelPadding);","}","float xToPixels(float value) {","if (skipTranslation){","return value;// + xAxisPos;","}","return translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;","}","float yToPixels(float value, float checkTreshold) {","float v;","if (skipTranslation){","v = value;// + yAxisPos;","} else {","v = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;","if (v > yAxisLen) {","v = yAxisLen;","}","}","if (checkTreshold > 0.0 && hasThreshold) {","v = min(v, translatedThreshold);","}","return v;","}","void main(void) {","if (isBubble){","gl_PointSize = bubbleRadius();","} else {","gl_PointSize = pSize;","}","vColor = aColor;","if (skipTranslation && isInverted) {","gl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);","} else if (isInverted) {","gl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);","} else {","gl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);","}","}"].join("\n"),v=["precision highp float;","uniform vec4 fillColor;","varying highp vec2 position;","varying highp vec4 vColor;","uniform sampler2D uSampler;","uniform bool isCircle;","uniform bool hasColor;","void main(void) {","vec4 col = fillColor;","vec4 tcol = texture2D(uSampler, gl_PointCoord.st);","if (hasColor) {","col = vColor;","}","if (isCircle) {","col *= tcol;","if (tcol.r < 0.0) {","discard;","} else {","gl_FragColor = col;","}","} else {","gl_FragColor = col;","}","}"].join("\n"),e={},A=[];function P(){A.length&&error("[highcharts boost] shader error - "+A.join("\n"))}function g(i,o){var e="vertex"===o?s.VERTEX_SHADER:s.FRAGMENT_SHADER,e=s.createShader(e);return s.shaderSource(e,i),s.compileShader(e),s.getShaderParameter(e,s.COMPILE_STATUS)?e:(A.push("when compiling "+o+" shader:\n"+s.getShaderInfoLog(e)),!1)}function i(){var i=g(d,"vertex"),o=g(v,"fragment");return i&&o?(a=s.createProgram(),s.attachShader(a,i),s.attachShader(a,o),s.linkProgram(a),s.getProgramParameter(a,s.LINK_STATUS)?(s.useProgram(a),s.bindAttribLocation(a,0,"aVertexPosition"),r=e("uPMatrix"),n=e("pSize"),l=e("fillColor"),t=e("isBubble"),f=e("bubbleSizeAbs"),u=e("bubbleSizeByArea"),c=e("uSampler"),x=e("skipTranslation"),b=e("isCircle"),m=e("isInverted"),!0):(A.push(s.getProgramInfoLog(a)),P(),a=!1)):(a=!1,P(),!1);function e(i){return s.getUniformLocation(a,i)}}function h(i,o){s&&a&&(i=e[i]=e[i]||s.getUniformLocation(a,i),s.uniform1f(i,o))}return!(s&&!i())&&{psUniform:function(){return n},pUniform:function(){return r},fillColorUniform:function(){return l},setBubbleUniforms:function(i,o,e){var r=i.options,n=Number.MAX_VALUE,l=-Number.MAX_VALUE;s&&a&&"bubble"===i.type&&(n=pick(r.zMin,clamp(o,!1===r.displayNegative?r.zThreshold:-Number.MAX_VALUE,n)),l=pick(r.zMax,Math.max(l,e)),s.uniform1i(t,1),s.uniform1i(b,1),s.uniform1i(u,"width"!==i.options.sizeBy),s.uniform1i(f,i.options.sizeByAbsoluteValue),h("bubbleZMin",n),h("bubbleZMax",l),h("bubbleZThreshold",i.options.zThreshold),h("bubbleMinSize",i.minPxSize),h("bubbleMaxSize",i.maxPxSize))},bind:function(){s&&a&&s.useProgram(a)},program:function(){return a},create:i,setUniform:h,setPMatrix:function(i){s&&a&&s.uniformMatrix4fv(r,!1,i)},setColor:function(i){s&&a&&s.uniform4f(l,i[0]/255,i[1]/255,i[2]/255,i[3])},setPointSize:function(i){s&&a&&s.uniform1f(n,i)},setSkipTranslation:function(i){s&&a&&s.uniform1i(x,!0===i?1:0)},setTexture:function(i){s&&a&&s.uniform1i(c,i)},setDrawAsCircle:function(i){s&&a&&s.uniform1i(b,i?1:0)},reset:function(){s&&a&&(s.uniform1i(t,0),s.uniform1i(b,0))},setInverted:function(i){s&&a&&s.uniform1i(m,i)},destroy:function(){s&&a&&(s.deleteProgram(a),a=!1)}}}export default GLShader;