"use strict";import A from"../Core/Animation/AnimationUtilities.js";var animObject=A.animObject;import Chart from"../Core/Chart/Chart.js";import H from"../Core/Globals.js";import Point from"../Core/Series/Point.js";import Series from"../Core/Series/Series.js";import SeriesRegistry from"../Core/Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import U from"../Core/Utilities.js";var addEvent=U.addEvent,clamp=U.clamp,merge=U.merge,objectEach=U.objectEach,pick=U.pick;function flipResizeSide(e){return{left:"right",right:"left",top:"bottom",bottom:"top"}[e]}var horizHandleFormatter=function(e){var r=e.shapeArgs||e.graphic.getBBox(),o=r.r||0,e=r.height-o,r=r.height/2;return[["M",0,o],["L",0,r-5],["A",1,1,0,0,0,0,5+r],["A",1,1,0,0,0,0,r-5],["M",0,5+r],["L",0,e]]},lineDragDropProps=Series.prototype.dragDropProps={x:{axis:"x",move:!0},y:{axis:"y",move:!0}};seriesTypes.flags&&(seriesTypes.flags.prototype.dragDropProps=lineDragDropProps);var columnrangeDragDropProps,arearangeHandleFormatter,xrangeHandlePositioner_1,xrangeDragDropProps,columnDragDropProps=seriesTypes.column.prototype.dragDropProps={x:{axis:"x",move:!0},y:{axis:"y",move:!1,resize:!0,beforeResize:function(e,r,o){var t=o.series.translatedThreshold,a=e.attr("y");r.y>=o.series.options.threshold?(o=e.attr("height"),e.attr({height:Math.max(0,Math.round(o+(t?t-(a+o):0)))})):e.attr({y:Math.round(a+(t?t-a:0))})},resizeSide:function(e,r){var o=r.series.chart.dragHandles,e=e.y>=(r.series.options.threshold||0)?"top":"bottom",r=flipResizeSide(e);return o[r]&&(o[r].destroy(),delete o[r]),e},handlePositioner:function(e){var r=e.shapeArgs||e.graphic&&e.graphic.getBBox()||{},o=e.series.yAxis.reversed,t=e.series.options.threshold||0,e=e.y||0;return{x:r.x||0,y:!o&&t<=e||o&&e<t?r.y||0:(r.y||0)+(r.height||0)}},handleFormatter:function(e){var r=e.shapeArgs||{},o=r.r||0,e=r.width||0,r=e/2;return[["M",o,0],["L",r-5,0],["A",1,1,0,0,0,5+r,0],["A",1,1,0,0,0,r-5,0],["M",5+r,0],["L",e-o,0]]}}};seriesTypes.bullet&&(seriesTypes.bullet.prototype.dragDropProps={x:columnDragDropProps.x,y:columnDragDropProps.y,target:{optionName:"draggableTarget",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){var r=e.targetGraphic.getBBox();return{x:e.barX,y:r.y+r.height/2}},handleFormatter:columnDragDropProps.y.handleFormatter}}),seriesTypes.columnrange&&(seriesTypes.columnrange.prototype.dragDropProps={x:{axis:"x",move:!0},low:{optionName:"draggableLow",axis:"y",move:!0,resize:!0,resizeSide:"bottom",handlePositioner:function(e){e=e.shapeArgs||e.graphic.getBBox();return{x:e.x||0,y:(e.y||0)+(e.height||0)}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.high}},high:{optionName:"draggableHigh",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){e=e.shapeArgs||e.graphic.getBBox();return{x:e.x||0,y:e.y||0}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e>=r.low}}}),seriesTypes.boxplot&&(seriesTypes.boxplot.prototype.dragDropProps={x:columnDragDropProps.x,low:{optionName:"draggableLow",axis:"y",move:!0,resize:!0,resizeSide:"bottom",handlePositioner:function(e){return{x:e.shapeArgs.x||0,y:e.lowPlot}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.q1}},q1:{optionName:"draggableQ1",axis:"y",move:!0,resize:!0,resizeSide:"bottom",handlePositioner:function(e){return{x:e.shapeArgs.x||0,y:e.q1Plot}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.median&&e>=r.low}},median:{axis:"y",move:!0},q3:{optionName:"draggableQ3",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){return{x:e.shapeArgs.x||0,y:e.q3Plot}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.high&&e>=r.median}},high:{optionName:"draggableHigh",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){return{x:e.shapeArgs.x||0,y:e.highPlot}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e>=r.q3}}}),seriesTypes.ohlc&&(seriesTypes.ohlc.prototype.dragDropProps={x:columnDragDropProps.x,low:{optionName:"draggableLow",axis:"y",move:!0,resize:!0,resizeSide:"bottom",handlePositioner:function(e){return{x:e.shapeArgs.x,y:e.plotLow}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.open&&e<=r.close}},high:{optionName:"draggableHigh",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){return{x:e.shapeArgs.x,y:e.plotHigh}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e>=r.open&&e>=r.close}},open:{optionName:"draggableOpen",axis:"y",move:!0,resize:!0,resizeSide:function(e){return e.open>=e.close?"top":"bottom"},handlePositioner:function(e){return{x:e.shapeArgs.x,y:e.plotOpen}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.high&&e>=r.low}},close:{optionName:"draggableClose",axis:"y",move:!0,resize:!0,resizeSide:function(e){return e.open>=e.close?"bottom":"top"},handlePositioner:function(e){return{x:e.shapeArgs.x,y:e.plotClose}},handleFormatter:columnDragDropProps.y.handleFormatter,propValidate:function(e,r){return e<=r.high&&e>=r.low}}}),seriesTypes.arearange&&(columnrangeDragDropProps=seriesTypes.columnrange.prototype.dragDropProps,seriesTypes.arearange.prototype.dragDropProps={x:columnrangeDragDropProps.x,low:{optionName:"draggableLow",axis:"y",move:!0,resize:!0,resizeSide:"bottom",handlePositioner:function(e){e=e.lowerGraphic&&e.lowerGraphic.getBBox();return e?{x:e.x+e.width/2,y:e.y+e.height/2}:{x:-999,y:-999}},handleFormatter:arearangeHandleFormatter=function(e){e=e.graphic?e.graphic.getBBox().width/2+1:4;return[["M",0-e,0],["a",e,e,0,1,0,2*e,0],["a",e,e,0,1,0,-2*e,0]]},propValidate:columnrangeDragDropProps.low.propValidate},high:{optionName:"draggableHigh",axis:"y",move:!0,resize:!0,resizeSide:"top",handlePositioner:function(e){e=e.upperGraphic&&e.upperGraphic.getBBox();return e?{x:e.x+e.width/2,y:e.y+e.height/2}:{x:-999,y:-999}},handleFormatter:arearangeHandleFormatter,propValidate:columnrangeDragDropProps.high.propValidate}}),seriesTypes.waterfall&&(seriesTypes.waterfall.prototype.dragDropProps={x:columnDragDropProps.x,y:merge(columnDragDropProps.y,{handleFormatter:function(e){return e.isSum||e.isIntermediateSum?null:columnDragDropProps.y.handleFormatter(e)}})}),seriesTypes.xrange&&(xrangeHandlePositioner_1=function(e,r){var o=e.series,t=o.xAxis,a=o.yAxis,i=o.chart.inverted,n=t.toPixels(e[r],!0),r=a.toPixels(e.y,!0),e=o.columnMetrics?o.columnMetrics.offset:-e.shapeArgs.height/2;return i&&(n=t.len-n,r=a.len-r),r+=e,{x:Math.round(n),y:Math.round(r)}},xrangeDragDropProps=seriesTypes.xrange.prototype.dragDropProps={y:{axis:"y",move:!0},x:{optionName:"draggableX1",axis:"x",move:!0,resize:!0,resizeSide:"left",handlePositioner:function(e){return xrangeHandlePositioner_1(e,"x")},handleFormatter:horizHandleFormatter,propValidate:function(e,r){return e<=r.x2}},x2:{optionName:"draggableX2",axis:"x",move:!0,resize:!0,resizeSide:"right",handlePositioner:function(e){return xrangeHandlePositioner_1(e,"x2")},handleFormatter:horizHandleFormatter,propValidate:function(e,r){return e>=r.x}}},seriesTypes.gantt&&(seriesTypes.gantt.prototype.dragDropProps={y:xrangeDragDropProps.y,start:merge(xrangeDragDropProps.x,{optionName:"draggableStart",validateIndividualDrag:function(e){return!e.milestone}}),end:merge(xrangeDragDropProps.x2,{optionName:"draggableEnd",validateIndividualDrag:function(e){return!e.milestone}})})),["gauge","pie","sunburst","wordcloud","sankey","histogram","pareto","vector","windbarb","treemap","bellcurve","sma","map","mapline"].forEach(function(e){seriesTypes[e]&&(seriesTypes[e].prototype.dragDropProps=null)});var defaultDragSensitivity=2,defaultGuideBoxOptions={default:{className:"highcharts-drag-box-default",lineWidth:1,lineColor:"#888",color:"rgba(0, 0, 0, 0.1)",cursor:"move",zIndex:900}},defaultDragHandleOptions={className:"highcharts-drag-handle",color:"#fff",lineColor:"rgba(0, 0, 0, 0.6)",lineWidth:1,zIndex:901};function isSeriesDraggable(e){var r,o=["draggableX","draggableY"];for(objectEach(e.dragDropProps,function(e){e.optionName&&o.push(e.optionName)}),r=o.length;r--;)if(e.options.dragDrop[o[r]])return!0}function isChartDraggable(e){var r=e.series?e.series.length:0;if(e.hasCartesianSeries&&!e.polar)for(;r--;)if(e.series[r].options.dragDrop&&isSeriesDraggable(e.series[r]))return!0}function isPointMovable(e){var r,o,t=e.series,a=t.options.dragDrop||{},i=e.options&&e.options.dragDrop,e=t.dragDropProps;return objectEach(e,function(e){"x"===e.axis&&e.move?r=!0:"y"===e.axis&&e.move&&(o=!0)}),(a.draggableX&&r||a.draggableY&&o)&&!(i&&!1===i.draggableX&&!1===i.draggableY)&&t.yAxis&&t.xAxis}function getNormalizedEvent(e,r){return void 0===e.chartX||void 0===e.chartY?r.pointer.normalize(e):e}function addEvents(r,e,o,t){var a=e.map(function(e){return addEvent(r,e,o,t)});return function(){a.forEach(function(e){e()})}}function hasDraggedPastSensitivity(e,r,o){var t=r.dragDropData.origin,a=t.chartX,r=t.chartY,t=e.chartX,e=e.chartY;return o<Math.sqrt((t-a)*(t-a)+(e-r)*(e-r))}function getPositionSnapshot(a,e,r){var i={chartX:a.chartX,chartY:a.chartY,guideBox:r&&{x:r.attr("x"),y:r.attr("y"),width:r.attr("width"),height:r.attr("height")},points:{}};return e.forEach(function(o){var t={};objectEach(o.series.dragDropProps,function(e,r){e=o.series[e.axis+"Axis"];t[r]=o[r],t[r+"Offset"]=e.toPixels(o[r])-(e.horiz?a.chartX:a.chartY)}),t.point=o,i.points[o.id]=t}),i}function getGroupedPoints(r){var o=r.series,t=[],a=o.options.dragDrop.groupBy;return o.isSeriesBoosting?o.options.data.forEach(function(e,r){t.push((new o.pointClass).init(o,e)),t[t.length-1].index=r}):t=o.points,r.options[a]?t.filter(function(e){return e.options[a]===r.options[a]}):[r]}function resizeRect(e,r,o){var t;switch(r){case"left":t={x:e.attr("x")+o.x,width:Math.max(1,e.attr("width")-o.x)};break;case"right":t={width:Math.max(1,e.attr("width")+o.x)};break;case"top":t={y:e.attr("y")+o.y,height:Math.max(1,e.attr("height")-o.y)};break;case"bottom":t={height:Math.max(1,e.attr("height")+o.y)}}e.attr(t)}function initDragDrop(e,r){var o,t=getGroupedPoints(r),a=r.series,i=a.chart;pick(a.options.dragDrop&&a.options.dragDrop.liveRedraw,!0)||(i.dragGuideBox=o=a.getGuideBox(t),i.setGuideBoxState("default",a.options.dragDrop.guideBox).add(a.group)),i.dragDropData={origin:getPositionSnapshot(e,t,o),point:r,groupedPoints:t,isDragging:!0}}function getNewPoints(r,o){var e=r.point,t=e.series,a=merge(t.options.dragDrop,e.options.dragDrop),i={},n=r.updateProp,s={};return objectEach(e.series.dragDropProps,function(e,r){n&&(n!==r||!e.resize||e.optionName&&!1===a[e.optionName])||(n||e.move&&("x"===e.axis&&a.draggableX||"y"===e.axis&&a.draggableY))&&(i[r]=e)}),(n?[e]:r.groupedPoints).forEach(function(e){s[e.id]={point:e,newValues:e.getDropValues(r.origin,o,i)}}),s}function updatePoints(e,r){var o=e.dragDropData.newPoints,r=animObject(r);e.isDragDropAnimating=!0,objectEach(o,function(e){e.point.update(e.newValues,!1)}),e.redraw(r),setTimeout(function(){delete e.isDragDropAnimating,e.hoverPoint&&!e.dragHandles&&e.hoverPoint.showDragHandles()},r.duration)}function resizeGuideBox(e,r,o){var t=e.series,a=t.chart,i=a.dragDropData,n=t.dragDropProps[i.updateProp],s=i.newPoints[e.id].newValues,d="function"==typeof n.resizeSide?n.resizeSide(s,e):n.resizeSide;n.beforeResize&&n.beforeResize(a.dragGuideBox,s,e),resizeRect(a.dragGuideBox,"x"===n.axis&&t.xAxis.reversed||"y"===n.axis&&t.yAxis.reversed?flipResizeSide(d):d,{x:"x"===n.axis?r-(i.origin.prevdX||0):0,y:"y"===n.axis?o-(i.origin.prevdY||0):0})}function dragMove(e,r){var o=r.series,t=o.chart,a=t.dragDropData,i=merge(o.options.dragDrop,r.options.dragDrop),n=i.draggableX,s=i.draggableY,d=a.origin,p=e.chartX-d.chartX,o=e.chartY-d.chartY,e=p,a=a.updateProp;t.inverted&&(p=-o,o=-e),pick(i.liveRedraw,!0)?(updatePoints(t,!1),r.showDragHandles()):a?resizeGuideBox(r,p,o):t.dragGuideBox.translate(n?p:0,s?o:0),d.prevdX=p,d.prevdY=o}function mouseOut(e){var r=e.series&&e.series.chart,o=r&&r.dragDropData;!r||!r.dragHandles||o&&(o.isDragging&&o.draggedPastSensitivity||o.isHoveringHandle===e.id)||r.hideDragHandles()}function onResizeHandleMouseOut(e){var r=e.series.chart;r.dragDropData&&e.id===r.dragDropData.isHoveringHandle&&delete r.dragDropData.isHoveringHandle,r.hoverPoint||mouseOut(e)}function onResizeHandleMouseDown(e,r,o){var t=r.series.chart;t.zoomOrPanKeyPressed(e)||(t.mouseIsDown=!1,initDragDrop(e,r),t.dragDropData.updateProp=e.updateProp=o,r.firePointEvent("dragStart",e),e.stopPropagation(),e.preventDefault())}function countProps(e){var r,o=0;for(r in e)Object.hasOwnProperty.call(e,r)&&o++;return o}function getFirstProp(e){for(var r in e)if(Object.hasOwnProperty.call(e,r))return e[r]}function mouseOver(e){var r=e.series,o=r&&r.chart,t=o&&o.dragDropData,a=o&&o.is3d&&o.is3d();!o||t&&t.isDragging&&t.draggedPastSensitivity||o.isDragDropAnimating||!r.options.dragDrop||a||(o.dragHandles&&o.hideDragHandles(),e.showDragHandles())}function mouseMove(e,r){var o,t,a,i;r.zoomOrPanKeyPressed(e)||(a=0,(o=r.dragDropData)&&o.isDragging&&o.point.series&&(i=(t=o.point).series.options.dragDrop,e.preventDefault(),o.draggedPastSensitivity||(o.draggedPastSensitivity=hasDraggedPastSensitivity(e,r,pick(t.options.dragDrop&&t.options.dragDrop.dragSensitivity,i&&i.dragSensitivity,defaultDragSensitivity))),o.draggedPastSensitivity&&(o.newPoints=getNewPoints(o,e),i=1===(a=countProps(i=o.newPoints))?getFirstProp(i):null,t.firePointEvent("drag",{origin:o.origin,newPoints:o.newPoints,newPoint:i&&i.newValues,newPointId:i&&i.point.id,numNewPoints:a,chartX:e.chartX,chartY:e.chartY},function(){dragMove(e,t)}))))}function mouseUp(e,r){var o,t,a,i,n=r.dragDropData;n&&n.isDragging&&n.draggedPastSensitivity&&n.point.series&&(o=n.point,i=1===(a=countProps(t=n.newPoints))?getFirstProp(t):null,r.dragHandles&&r.hideDragHandles(),e.preventDefault(),r.cancelClick=!0,o.firePointEvent("drop",{origin:n.origin,chartX:e.chartX,chartY:e.chartY,newPoints:t,numNewPoints:a,newPoint:i&&i.newValues,newPointId:i&&i.point.id},function(){updatePoints(r)})),delete r.dragDropData,r.dragGuideBox&&(r.dragGuideBox.destroy(),delete r.dragGuideBox)}function mouseDown(e,r){var o=r.hoverPoint,t=merge(o&&o.series.options.dragDrop,o&&o.options.dragDrop),a=t.draggableX||!1,t=t.draggableY||!1;r.cancelClick=!1,!a&&!t||r.zoomOrPanKeyPressed(e)||r.hasDraggedAnnotation||(r.dragDropData&&r.dragDropData.isDragging?mouseUp(e,r):o&&isPointMovable(o)&&(r.mouseIsDown=!1,initDragDrop(e,o),o.firePointEvent("dragStart",e)))}function addDragDropEvents(r){var e=r.container,o=H.doc;isChartDraggable(r)&&(addEvents(e,["mousedown","touchstart"],function(e){mouseDown(getNormalizedEvent(e,r),r)}),addEvents(e,["mousemove","touchmove"],function(e){mouseMove(getNormalizedEvent(e,r),r)},{passive:!1}),addEvent(e,"mouseleave",function(e){mouseUp(getNormalizedEvent(e,r),r)}),r.unbindDragDropMouseUp=addEvents(o,["mouseup","touchend"],function(e){mouseUp(getNormalizedEvent(e,r),r)},{passive:!1}),r.hasAddedDragDropEvents=!0,addEvent(r,"destroy",function(){r.unbindDragDropMouseUp&&r.unbindDragDropMouseUp()}))}Chart.prototype.setGuideBoxState=function(e,r){var o=this.dragGuideBox,r=merge(defaultGuideBoxOptions,r),e=merge(r.default,r[e]);return o.attr({className:e.className,stroke:e.lineColor,strokeWidth:e.lineWidth,fill:e.color,cursor:e.cursor,zIndex:e.zIndex}).css({pointerEvents:"none"})},Point.prototype.getDropValues=function(e,s,r){var d,o,p=this,g=p.series,l=merge(g.options.dragDrop,p.options.dragDrop),u={},h=e.points[p.id];for(o in r)if(Object.hasOwnProperty.call(r,o)){if(void 0!==d){d=!1;break}d=!0}return objectEach(r,function(e,r){var o,t,a,i=h[r],n=g[e.axis+"Axis"],t=(o=n.toValue((n.horiz?s.chartX:s.chartY)+h[r+"Offset"]),t=e.axis.toUpperCase(),a=g[t.toLowerCase()+"Axis"].categories?1:0,n=pick(l["dragPrecision"+t],a),a=pick(l["dragMin"+t],-1/0),t=pick(l["dragMax"+t],1/0),o,n&&(o=Math.round(o/n)*n),clamp(o,a,t));d&&e.propValidate&&!e.propValidate(t,p)||void 0===i||(u[r]=t)}),u},Series.prototype.getGuideBox=function(e){var o,r=this.chart,t=1/0,a=-1/0,i=1/0,n=-1/0;return e.forEach(function(e){var r=e.graphic&&e.graphic.getBBox()||e.shapeArgs;r&&(r.width||r.height||r.x||r.y)&&(o=!0,t=Math.min(e.plotX||0,r.x||0,t),a=Math.max((r.x||0)+(r.width||0),a),i=Math.min(e.plotY||0,r.y||0,i),n=Math.max((r.y||0)+(r.height||0),n))}),o?r.renderer.rect(t,i,a-t,n-i):r.renderer.g()},Point.prototype.showDragHandles=function(){var s=this,d=s.series,p=d.chart,g=p.renderer,l=merge(d.options.dragDrop,s.options.dragDrop);objectEach(d.dragDropProps,function(e,r){var o=merge(defaultDragHandleOptions,e.handleOptions,l.dragHandle),t={class:o.className,"stroke-width":o.lineWidth,fill:o.color,stroke:o.lineColor},a=o.pathFormatter||e.handleFormatter,i=e.handlePositioner,n=!e.validateIndividualDrag||e.validateIndividualDrag(s);e.resize&&n&&e.resizeSide&&a&&(l["draggable"+e.axis.toUpperCase()]||l[e.optionName])&&!1!==l[e.optionName]&&(p.dragHandles||(p.dragHandles={group:g.g("drag-drop-handles").add(d.markerGroup||d.group)}),p.dragHandles.point=s.id,i=i(s),t.d=a=a(s),!a||i.x<0||i.y<0||(t.cursor=o.cursor||"x"===e.axis!=!!p.inverted?"ew-resize":"ns-resize",(o=(o=p.dragHandles[e.optionName])||(p.dragHandles[e.optionName]=g.path().add(p.dragHandles.group))).translate(i.x,i.y).attr(t),addEvents(o.element,["touchstart","mousedown"],function(e){onResizeHandleMouseDown(getNormalizedEvent(e,p),s,r)},{passive:!1}),addEvent(p.dragHandles.group.element,"mouseover",function(){p.dragDropData=p.dragDropData||{},p.dragDropData.isHoveringHandle=s.id}),addEvents(p.dragHandles.group.element,["touchend","mouseout"],function(){onResizeHandleMouseOut(s)})))})},Chart.prototype.hideDragHandles=function(){var e=this;e.dragHandles&&(objectEach(e.dragHandles,function(e,r){"group"!==r&&e.destroy&&e.destroy()}),e.dragHandles.group&&e.dragHandles.group.destroy&&e.dragHandles.group.destroy(),delete e.dragHandles)},addEvent(Point,"mouseOver",function(){var e=this;setTimeout(function(){mouseOver(e)},12)}),addEvent(Point,"mouseOut",function(){var e=this;setTimeout(function(){e.series&&mouseOut(e)},10)}),addEvent(Point,"remove",function(){var e=this.series.chart,r=e.dragHandles;r&&r.point===this.id&&e.hideDragHandles()}),Chart.prototype.zoomOrPanKeyPressed=function(e){var r=this.userOptions.chart||{},o=r.panKey&&r.panKey+"Key";return e[r.zoomKey&&r.zoomKey+"Key"]||e[o]},addEvent(Chart,"render",function(){this.hasAddedDragDropEvents||addDragDropEvents(this)});