"use strict";import Chart from"../Core/Chart/Chart.js";import chartNavigationMixin from"../Mixins/Navigation.js";import H from"../Core/Globals.js";var doc=H.doc,isTouchDevice=H.isTouchDevice,win=H.win;import D from"../Core/DefaultOptions.js";var defaultOptions=D.defaultOptions;import palette from"../Core/Color/Palette.js";import SVGRenderer from"../Core/Renderer/SVG/SVGRenderer.js";var symbols=SVGRenderer.prototype.symbols;import U from"../Core/Utilities.js";var addEvent=U.addEvent,css=U.css,createElement=U.createElement,discardElement=U.discardElement,extend=U.extend,find=U.find,fireEvent=U.fireEvent,isObject=U.isObject,merge=U.merge,objectEach=U.objectEach,pick=U.pick,removeEvent=U.removeEvent,uniqueKey=U.uniqueKey;extend(defaultOptions.lang,{viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"}),defaultOptions.navigation||(defaultOptions.navigation={}),merge(!0,defaultOptions.navigation,{buttonOptions:{theme:{},symbolSize:14,symbolX:12.5,symbolY:10.5,align:"right",buttonSpacing:3,height:22,verticalAlign:"top",width:24}}),merge(!0,defaultOptions.navigation,{menuStyle:{border:"1px solid "+palette.neutralColor40,background:palette.backgroundColor,padding:"5px 0"},menuItemStyle:{padding:"0.5em 1em",color:palette.neutralColor80,background:"none",fontSize:isTouchDevice?"14px":"11px",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:palette.highlightColor80,color:palette.backgroundColor},buttonOptions:{symbolFill:palette.neutralColor60,symbolStroke:palette.neutralColor60,symbolStrokeWidth:3,theme:{padding:5}}}),defaultOptions.exporting={type:"image/png",url:"https://export.highcharts.com/",printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadPDF","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:function(){this.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:function(){this.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:function(){this.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:function(){this.exportChart({type:"image/svg+xml"})}}}},H.post=function(e,t,n){var o=createElement("form",merge({method:"post",action:e,enctype:"multipart/form-data"},n),{display:"none"},doc.body);objectEach(t,function(e,t){createElement("input",{type:"hidden",name:t,value:e},null,o)}),o.submit(),discardElement(o)},H.isSafari&&H.win.matchMedia("print").addListener(function(e){H.printingChart&&(e.matches?H.printingChart.beforePrint():H.printingChart.afterPrint())}),extend(Chart.prototype,{sanitizeSVG:function(e,t){var n=e.indexOf("</svg>")+6,o=e.substr(n);return e=e.substr(0,n),t&&t.exporting&&t.exporting.allowHTML&&o&&(o='<foreignObject x="0" y="0" width="'+t.chart.width+'" height="'+t.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+o.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",e=e.replace("</svg>",o+"</svg>")),e=e.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery[0-9]+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (|NS[0-9]+\:)href=/g," xlink:href=").replace(/\n/," ").replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"').replace(/&nbsp;/g," ").replace(/&shy;/g,"­"),e=this.ieSanitizeSVG?this.ieSanitizeSVG(e):e},getChartHTML:function(){return this.styledMode&&this.inlineStyles(),this.container.innerHTML},getSVG:function(n){var i,e,t,o,r,s=this,a=merge(s.options,n);a.plotOptions=merge(s.userOptions.plotOptions,n&&n.plotOptions),a.time=merge(s.userOptions.time,n&&n.time),e=createElement("div",null,{position:"absolute",top:"-9999em",width:s.chartWidth+"px",height:s.chartHeight+"px"},doc.body),o=s.renderTo.style.width,r=s.renderTo.style.height,o=a.exporting.sourceWidth||a.chart.width||/px$/.test(o)&&parseInt(o,10)||(a.isGantt?800:600),r=a.exporting.sourceHeight||a.chart.height||/px$/.test(r)&&parseInt(r,10)||400,extend(a.chart,{animation:!1,renderTo:e,forExport:!0,renderer:"SVGRenderer",width:o,height:r}),a.exporting.enabled=!1,delete a.data,a.series=[],s.series.forEach(function(e){(t=merge(e.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:e.visible})).isInternal||a.series.push(t)});var l={};return s.axes.forEach(function(e){e.userOptions.internalKey||(e.userOptions.internalKey=uniqueKey()),e.options.isInternal||(l[e.coll]||(l[e.coll]=!0,a[e.coll]=[]),a[e.coll].push(merge(e.userOptions,{visible:e.visible})))}),i=new Chart(a,s.callback),n&&["xAxis","yAxis","series"].forEach(function(e){var t={};n[e]&&(t[e]=n[e],i.update(t))}),s.axes.forEach(function(t){var e=find(i.axes,function(e){return e.options.internalKey===t.userOptions.internalKey}),n=t.getExtremes(),o=n.userMin,n=n.userMax;e&&(void 0!==o&&o!==e.min||void 0!==n&&n!==e.max)&&e.setExtremes(o,n,!0,!1)}),r=i.getChartHTML(),fireEvent(this,"getSVG",{chartCopy:i}),r=s.sanitizeSVG(r,a),a=null,i.destroy(),discardElement(e),r},getSVGForExport:function(e,t){var n=this.options.exporting;return this.getSVG(merge({chart:{borderRadius:0}},n.chartOptions,t,{exporting:{sourceWidth:e&&e.sourceWidth||n.sourceWidth,sourceHeight:e&&e.sourceHeight||n.sourceHeight}}))},getFilename:function(){var e=this.userOptions.title&&this.userOptions.title.text,t=this.options.exporting.filename;return t?t.replace(/\//g,"-"):!(t="string"==typeof e?e.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z0-9\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,""):t)||t.length<5?"chart":t},exportChart:function(e,t){t=this.getSVGForExport(e,t);e=merge(this.options.exporting,e),H.post(e.url,{filename:e.filename?e.filename.replace(/\//g,"-"):this.getFilename(),type:e.type,width:e.width||0,scale:e.scale,svg:t},e.formAttributes)},moveContainers:function(t){var e=this;(e.fixedDiv?[e.fixedDiv,e.scrollingContainer]:[e.container]).forEach(function(e){t.appendChild(e)})},beforePrint:function(){var e=this,t=doc.body,n=e.options.exporting.printMaxWidth,o={childNodes:t.childNodes,origDisplay:[],resetParams:void 0};e.isPrinting=!0,e.pointer.reset(null,0),fireEvent(e,"beforePrint"),n&&e.chartWidth>n&&(o.resetParams=[e.options.chart.width,void 0,!1],e.setSize(n,void 0,!1)),[].forEach.call(o.childNodes,function(e,t){1===e.nodeType&&(o.origDisplay[t]=e.style.display,e.style.display="none")}),e.moveContainers(t),e.printReverseInfo=o},afterPrint:function(){var e,n,t,o=this;o.printReverseInfo&&(e=o.printReverseInfo.childNodes,n=o.printReverseInfo.origDisplay,t=o.printReverseInfo.resetParams,o.moveContainers(o.renderTo),[].forEach.call(e,function(e,t){1===e.nodeType&&(e.style.display=n[t]||"")}),o.isPrinting=!1,t&&o.setSize.apply(o,t),delete o.printReverseInfo,delete H.printingChart,fireEvent(o,"afterPrint"))},print:function(){var e=this;e.isPrinting||(H.printingChart=e,H.isSafari||e.beforePrint(),setTimeout(function(){win.focus(),win.print(),H.isSafari||setTimeout(function(){e.afterPrint()},1e3)},1))},contextMenu:function(t,e,n,o,i,r,s){var a,l=this,d=l.options.navigation,c=l.chartWidth,p=l.chartHeight,u="cache-"+t,h=l[u],m=Math.max(i,r);h||(l.exportContextMenu=l[u]=h=createElement("div",{className:t},{position:"absolute",zIndex:1e3,padding:m+"px",pointerEvents:"auto"},l.fixedDiv||l.container),a=createElement("ul",{className:"highcharts-menu"},{listStyle:"none",margin:0,padding:0},h),l.styledMode||css(a,extend({MozBoxShadow:"3px 3px 10px #888",WebkitBoxShadow:"3px 3px 10px #888",boxShadow:"3px 3px 10px #888"},d.menuStyle)),h.hideMenu=function(){css(h,{display:"none"}),s&&s.setState(0),l.openMenu=!1,css(l.renderTo,{overflow:"hidden"}),css(l.container,{overflow:"hidden"}),U.clearTimeout(h.hideTimer),fireEvent(l,"exportMenuHidden")},l.exportEvents.push(addEvent(h,"mouseleave",function(){h.hideTimer=win.setTimeout(h.hideMenu,500)}),addEvent(h,"mouseenter",function(){U.clearTimeout(h.hideTimer)}),addEvent(doc,"mouseup",function(e){l.pointer.inClass(e.target,t)||h.hideMenu()}),addEvent(h,"click",function(){l.openMenu&&h.hideMenu()})),e.forEach(function(t){var e;"string"==typeof t&&(t=l.options.exporting.menuItemDefinitions[t]),isObject(t,!0)&&(e=void 0,t.separator?e=createElement("hr",null,null,a):("viewData"===t.textKey&&l.isDataTableVisible&&(t.textKey="hideData"),(e=createElement("li",{className:"highcharts-menu-item",onclick:function(e){e&&e.stopPropagation(),h.hideMenu(),t.onclick&&t.onclick.apply(l,arguments)}},null,a)).appendChild(doc.createTextNode(t.text||l.options.lang[t.textKey])),l.styledMode||(e.onmouseover=function(){css(this,d.menuItemHoverStyle)},e.onmouseout=function(){css(this,d.menuItemStyle)},css(e,extend({cursor:"pointer"},d.menuItemStyle)))),l.exportDivElements.push(e))}),l.exportDivElements.push(a,h),l.exportMenuWidth=h.offsetWidth,l.exportMenuHeight=h.offsetHeight),e={display:"block"},n+l.exportMenuWidth>c?e.right=c-n-i-m+"px":e.left=n-m+"px",o+r+l.exportMenuHeight>p&&"top"!==s.alignOptions.verticalAlign?e.bottom=p-o-m+"px":e.top=o+r-m+"px",css(h,e),css(l.renderTo,{overflow:""}),css(l.container,{overflow:""}),l.openMenu=!0,fireEvent(l,"exportMenuShown")},addButton:function(e){var t,n,o,i,r,s,a=this,l=a.renderer,d=merge(a.options.navigation.buttonOptions,e),c=d.onclick,p=d.menuItems,u=d.symbolSize||12;a.btnCount||(a.btnCount=0),a.exportDivElements||(a.exportDivElements=[],a.exportSVGElements=[]),!1!==d.enabled&&d.theme&&(i=(r=(o=d.theme).states)&&r.hover,r=r&&r.select,a.styledMode||(o.fill=pick(o.fill,palette.backgroundColor),o.stroke=pick(o.stroke,"none")),delete o.states,c?s=function(e){e&&e.stopPropagation(),c.call(a,e)}:p&&(s=function(e){e&&e.stopPropagation(),a.contextMenu(n.menuClassName,p,n.translateX,n.translateY,n.width,n.height,n),n.setState(2)}),d.text&&d.symbol?o.paddingLeft=pick(o.paddingLeft,30):d.text||extend(o,{width:d.width,height:d.height,padding:0}),a.styledMode||(o["stroke-linecap"]="round",o.fill=pick(o.fill,palette.backgroundColor),o.stroke=pick(o.stroke,"none")),(n=l.button(d.text,0,0,s,o,i,r).addClass(e.className).attr({title:pick(a.options.lang[d._titleKey||d.titleKey],"")})).menuClassName=e.menuClassName||"highcharts-menu-"+a.btnCount++,d.symbol&&(t=l.symbol(d.symbol,d.symbolX-u/2,d.symbolY-u/2,u,u,{width:u,height:u}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(n),a.styledMode||t.attr({stroke:d.symbolStroke,fill:d.symbolFill,"stroke-width":d.symbolStrokeWidth||1})),n.add(a.exportingGroup).align(extend(d,{width:n.width,x:pick(d.x,a.buttonOffset)}),!0,"spacingBox"),a.buttonOffset+=(n.width+d.buttonSpacing)*("right"===d.align?-1:1),a.exportSVGElements.push(n,t))},destroyExport:function(e){var n,o=e?e.target:this,t=o.exportSVGElements,i=o.exportDivElements,e=o.exportEvents;t&&(t.forEach(function(e,t){e&&(e.onclick=e.ontouchstart=null,n="cache-"+e.menuClassName,o[n]&&delete o[n],o.exportSVGElements[t]=e.destroy())}),t.length=0),o.exportingGroup&&(o.exportingGroup.destroy(),delete o.exportingGroup),i&&(i.forEach(function(e,t){U.clearTimeout(e.hideTimer),removeEvent(e,"mouseleave"),o.exportDivElements[t]=e.onmouseout=e.onmouseover=e.ontouchstart=e.onclick=null,discardElement(e)}),i.length=0),e&&(e.forEach(function(e){e()}),e.length=0)}}),SVGRenderer.prototype.inlineToAttributes=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"],SVGRenderer.prototype.inlineBlacklist=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/],SVGRenderer.prototype.unstyledElements=["clipPath","defs","desc"],Chart.prototype.inlineStyles=function(){var p,e,u,t=this.renderer,h=t.inlineToAttributes,m=t.inlineBlacklist,g=t.inlineWhitelist,f=t.unstyledElements,x={};function v(e){return e.replace(/([A-Z])/g,function(e,t){return"-"+t.toLowerCase()})}e=doc.createElement("iframe"),css(e,{width:"1px",height:"1px",visibility:"hidden"}),doc.body.appendChild(e),(u=e.contentWindow.document).open(),u.write('<svg xmlns="http://www.w3.org/2000/svg"></svg>'),u.close(),function e(n){var t,o,i,r,s,a,l="";function d(e,t){if(r=s=!1,g){for(a=g.length;a--&&!s;)s=g[a].test(t);r=!s}for("transform"===t&&"none"===e&&(r=!0),a=m.length;a--&&!r;)r=m[a].test(t)||"function"==typeof e;r||o[t]===e&&"svg"!==n.nodeName||x[n.nodeName][t]===e||(h&&-1===h.indexOf(t)?l+=v(t)+":"+e+";":e&&n.setAttribute(v(t),e))}if(1===n.nodeType&&-1===f.indexOf(n.nodeName)){if(t=win.getComputedStyle(n,null),o="svg"===n.nodeName?{}:win.getComputedStyle(n.parentNode,null),x[n.nodeName]||(p=u.getElementsByTagName("svg")[0],i=u.createElementNS(n.namespaceURI,n.nodeName),p.appendChild(i),x[n.nodeName]=merge(win.getComputedStyle(i,null)),"text"===n.nodeName&&delete x.text.fill,p.removeChild(i)),H.isFirefox||H.isMS)for(var c in t)d(t[c],c);else objectEach(t,d);l&&(i=n.getAttribute("style"),n.setAttribute("style",(i?i+";":"")+l)),"svg"===n.nodeName&&n.setAttribute("stroke-width","1px"),"text"!==n.nodeName&&[].forEach.call(n.children||n.childNodes,e)}}(this.container.querySelector("svg")),p.parentNode.removeChild(p),e.parentNode.removeChild(e)},symbols.menu=function(e,t,n,o){return[["M",e,t+2.5],["L",e+n,t+2.5],["M",e,t+o/2+.5],["L",e+n,t+o/2+.5],["M",e,t+o-1.5],["L",e+n,t+o-1.5]]},symbols.menuball=function(e,t,n,o){o=o/3-2;return[].concat(symbols.circle(n-o,t,o,o),symbols.circle(n-o,t+o+4,o,o),symbols.circle(n-o,t+2*(4+o),o,o))},Chart.prototype.renderExporting=function(){var t=this,e=t.options.exporting,n=e.buttons,o=t.isDirtyExporting||!t.exportSVGElements;t.buttonOffset=0,t.isDirtyExporting&&t.destroyExport(),o&&!1!==e.enabled&&(t.exportEvents=[],t.exportingGroup=t.exportingGroup||t.renderer.g("exporting-group").attr({zIndex:3}).add(),objectEach(n,function(e){t.addButton(e)}),t.isDirtyExporting=!1)},addEvent(Chart,"init",function(){var o=this;function n(e,t,n){o.isDirtyExporting=!0,merge(!0,o.options[e],t),pick(n,!0)&&o.redraw()}o.exporting={update:function(e,t){n("exporting",e,t)}},chartNavigationMixin.addUpdate(function(e,t){n("navigation",e,t)},o)}),Chart.prototype.callbacks.push(function(e){e.renderExporting(),addEvent(e,"redraw",e.renderExporting),addEvent(e,"destroy",e.destroyExport)});