"use strict";import A from"../Core/Animation/AnimationUtilities.js";var animObject=A.animObject;import Chart from"../Core/Chart/Chart.js";import D from"../Core/DefaultOptions.js";var defaultOptions=D.defaultOptions;import palette from"../Core/Color/Palette.js";import Point from"../Core/Series/Point.js";import Series from"../Core/Series/Series.js";import SeriesRegistry from"../Core/Series/SeriesRegistry.js";var seriesTypes=SeriesRegistry.seriesTypes;import SVGRenderer from"../Core/Renderer/SVG/SVGRenderer.js";var symbols=SVGRenderer.prototype.symbols;import U from"../Core/Utilities.js";var addEvent=U.addEvent,defined=U.defined,error=U.error,isArray=U.isArray,isFunction=U.isFunction,isObject=U.isObject,isNumber=U.isNumber,merge=U.merge,objectEach=U.objectEach,relativeLength=U.relativeLength,syncTimeout=U.syncTimeout;import Axis from"../Core/Axis/Axis.js";var Scatter=seriesTypes.scatter,baseGeneratePoints=Series.prototype.generatePoints,stateIdCounter=0,oldPointsStateId=[],clusterDefaultOptions={enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:palette.backgroundColor},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}};function getClusterPosition(t){for(var e=t.length,a=0,i=0,r=0;r<e;r++)a+=t[r].x,i+=t[r].y;return{x:a/e,y:i/e}}function getDataState(t,e){var a=[];return a.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){a[t.dataIndex]=t})}),t.noise.forEach(function(t){a[t.data[0].dataIndex]=t.data[0]}),a}function fadeInElement(t,e,a){t.attr({opacity:e}).animate({opacity:1},a)}function fadeInStatePoint(t,e,a,i,r){t.point&&(i&&t.point.graphic&&(t.point.graphic.show(),fadeInElement(t.point.graphic,e,a)),r&&t.point.dataLabel&&(t.point.dataLabel.show(),fadeInElement(t.point.dataLabel,e,a)))}function hideStatePoint(t,e,a){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),a&&t.point.dataLabel&&t.point.dataLabel.hide())}function destroyOldPoints(t){t&&objectEach(t,function(t){t.point&&t.point.destroy&&t.point.destroy()})}function fadeInNewPointAndDestoryOld(t,e,a,i){fadeInStatePoint(t,i,a,!0,!0),e.forEach(function(t){t.point&&t.point.destroy&&t.point.destroy()})}function getStateId(){return Math.random().toString(36).substring(2,7)+"-"+stateIdCounter++}(defaultOptions.plotOptions||{}).series=merge((defaultOptions.plotOptions||{}).series,{cluster:clusterDefaultOptions,tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}}),symbols.cluster=function(t,e,a,i){var r=a/2,o=i/2,a=symbols.arc(t+r,e+o,r-4,o-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),i=symbols.arc(t+r,e+o,r-3,o-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r-2,open:!1});return symbols.arc(t+r,e+o,r-1,o-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r,open:!1}).concat(i,a)},Scatter.prototype.animateClusterPoint=function(t){var e,a,i,r,o=this,n=o.xAxis,s=o.yAxis,l=o.chart,p=o.options.cluster,d=animObject((p||{}).animation),u=d.duration||500,p=(o.markerClusterInfo||{}).pointsState,o=(p||{}).newState,c=(p||{}).oldState,h=[],f=!1,m=!1;c&&o&&(a=o[t.stateId],i=n.toPixels(a.x)-l.plotLeft,r=s.toPixels(a.y)-l.plotTop,1===a.parentsId.length?(t=(o||{})[t.stateId].parentsId[0],e=c[t],a.point&&a.point.graphic&&e&&e.point&&e.point.plotX&&e.point.plotY&&e.point.plotX!==a.point.plotX&&e.point.plotY!==a.point.plotY&&(t=a.point.graphic.getBBox(),p=a.point.graphic&&a.point.graphic.isImg?0:t.width/2,a.point.graphic.attr({x:e.point.plotX-p,y:e.point.plotY-p}),a.point.graphic.animate({x:i-(a.point.graphic.radius||0),y:r-(a.point.graphic.radius||0)},d,function(){m=!0,e.point&&e.point.destroy&&e.point.destroy()}),a.point.dataLabel&&a.point.dataLabel.alignAttr&&e.point.dataLabel&&e.point.dataLabel.alignAttr&&(a.point.dataLabel.attr({x:e.point.dataLabel.alignAttr.x,y:e.point.dataLabel.alignAttr.y}),a.point.dataLabel.animate({x:a.point.dataLabel.alignAttr.x,y:a.point.dataLabel.alignAttr.y},d)))):0===a.parentsId.length?(hideStatePoint(a,!0,!0),syncTimeout(function(){fadeInStatePoint(a,.1,d,!0,!0)},u/2)):(hideStatePoint(a,!0,!0),a.parentsId.forEach(function(t){c&&c[t]&&(e=c[t],h.push(e),e.point&&e.point.graphic&&(f=!0,e.point.graphic.show(),e.point.graphic.animate({x:i-(e.point.graphic.radius||0),y:r-(e.point.graphic.radius||0),opacity:.4},d,function(){m=!0,fadeInNewPointAndDestoryOld(a,h,d,.7)}),e.point.dataLabel&&-9999!==e.point.dataLabel.y&&a.point&&a.point.dataLabel&&a.point.dataLabel.alignAttr&&(e.point.dataLabel.show(),e.point.dataLabel.animate({x:a.point.dataLabel.alignAttr.x,y:a.point.dataLabel.alignAttr.y,opacity:.4},d))))}),syncTimeout(function(){m||fadeInNewPointAndDestoryOld(a,h,d,.85)},u),f||syncTimeout(function(){fadeInNewPointAndDestoryOld(a,h,d,.1)},u/2)))},Scatter.prototype.getGridOffset=function(){var t=this,e=t.chart,a=t.xAxis,i=t.yAxis;return{plotLeft:t.dataMinX&&t.dataMaxX?a.reversed?a.toPixels(t.dataMaxX):a.toPixels(t.dataMinX):e.plotLeft,plotTop:t.dataMinY&&t.dataMaxY?i.reversed?i.toPixels(t.dataMinY):i.toPixels(t.dataMaxY):e.plotTop}},Scatter.prototype.getScaledGridSize=function(t){var e,a,i=this.xAxis,r=!0,o=1,n=1,t=t.processedGridSize||clusterDefaultOptions.layoutAlgorithm.gridSize;for(this.gridValueSize||(this.gridValueSize=Math.abs(i.toValue(t)-i.toValue(0))),e=+(t/(i.toPixels(this.gridValueSize)-i.toPixels(0))).toFixed(14);r&&1!=e;)a=Math.pow(2,o),.75<e&&e<1.25?r=!1:1/a<=e&&e<1/a*2?(r=!1,n=a):e<=a&&a/2<e&&(r=!1,n=1/a),o++;return t/n/e},Scatter.prototype.getRealExtremes=function(){var t,e=this.chart,a=this.xAxis,i=this.yAxis,r=a?a.toValue(e.plotLeft):0,o=a?a.toValue(e.plotLeft+e.plotWidth):0,a=i?i.toValue(e.plotTop):0,e=i?i.toValue(e.plotTop+e.plotHeight):0;return o<r&&(o=(t=[r,o])[0],r=t[1]),e<a&&(e=(t=[a,e])[0],a=t[1]),{minX:r,maxX:o,minY:a,maxY:e}},Scatter.prototype.onDrillToCluster=function(t){(t.point||t.target).firePointEvent("drillToCluster",t,function(t){var e,a,i,r,o,n=t.point||t.target,s=n.series,l=n.series.xAxis,p=n.series.yAxis,d=n.series.chart;(s.options.cluster||{}).drillToCluster&&n.clusteredData&&(a=n.clusteredData.map(function(t){return t.x}).sort(function(t,e){return t-e}),i=n.clusteredData.map(function(t){return t.y}).sort(function(t,e){return t-e}),r=a[0],o=a[a.length-1],s=i[0],n=i[i.length-1],a=Math.abs(.1*(o-r)),i=Math.abs(.1*(n-s)),d.pointer.zoomX=!0,d.pointer.zoomY=!0,o<r&&(r=(e=[o,r])[0],o=e[1]),n<s&&(s=(e=[n,s])[0],n=e[1]),d.zoom({originalEvent:t,xAxis:[{axis:l,min:r-a,max:o+a}],yAxis:[{axis:p,min:s-i,max:n+i}]}))})},Scatter.prototype.getClusterDistancesFromPoint=function(t,e,a){for(var i,r=this.xAxis,o=this.yAxis,n=[],s=0;s<t.length;s++)i=Math.sqrt(Math.pow(r.toPixels(e)-r.toPixels(t[s].posX),2)+Math.pow(o.toPixels(a)-o.toPixels(t[s].posY),2)),n.push({clusterIndex:s,distance:i});return n.sort(function(t,e){return t.distance-e.distance})},Scatter.prototype.getPointsState=function(t,e,a){var i,r,o,n=e?getDataState(e,a):[],s=getDataState(t,a),l={};for(oldPointsStateId=[],t.clusters.forEach(function(t){l[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(function(t){l[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),o=0;o<s.length;o++)i=s[o],r=n[o],i&&r&&i.parentStateId&&r.parentStateId&&l[i.parentStateId]&&-1===l[i.parentStateId].parentsId.indexOf(r.parentStateId)&&(l[i.parentStateId].parentsId.push(r.parentStateId),-1===oldPointsStateId.indexOf(r.parentStateId)&&oldPointsStateId.push(r.parentStateId));return l},Scatter.prototype.markerClusterAlgorithms={grid:function(t,e,a,i){for(var r,o,n=this.xAxis,s=this.yAxis,l={},p=this.getGridOffset(),d=this.getScaledGridSize(i),u=0;u<t.length;u++)o=n.toPixels(t[u])-p.plotLeft,r=s.toPixels(e[u])-p.plotTop,o=Math.floor(o/d),l[o=Math.floor(r/d)+"-"+o]||(l[o]=[]),l[o].push({dataIndex:a[u],x:t[u],y:e[u]});return l},kmeans:function(t,e,a,i){var r,o,n,s,l,p,d,u=this,c=[],h=[],f={},m=i.processedDistance||clusterDefaultOptions.layoutAlgorithm.distance,g=i.iterations,x=0,y=!0,S=[];for(l in i.processedGridSize=i.processedDistance,s=u.markerClusterAlgorithms?u.markerClusterAlgorithms.grid.call(u,t,e,a,i):{})1<s[l].length&&(n=getClusterPosition(s[l]),c.push({posX:n.x,posY:n.y,oldX:0,oldY:0,startPointsLen:s[l].length,points:[]}));for(;y;){for(c.map(function(t){return t.points.length=0,t}),p=h.length=0;p<t.length;p++)r=t[p],o=e[p],((S=u.getClusterDistancesFromPoint(c,r,o)).length&&S[0].distance<m?c[S[0].clusterIndex].points:h).push({x:r,y:o,dataIndex:a[p]});for(d=0;d<c.length;d++)1===c[d].points.length&&(S=u.getClusterDistancesFromPoint(c,c[d].points[0].x,c[d].points[0].y))[1].distance<m&&(c[S[1].clusterIndex].points.push(c[d].points[0]),c[S[0].clusterIndex].points.length=0);for(y=!1,d=0;d<c.length;d++)n=getClusterPosition(c[d].points),c[d].oldX=c[d].posX,c[d].oldY=c[d].posY,c[d].posX=n.x,c[d].posY=n.y,(c[d].posX>c[d].oldX+1||c[d].posX<c[d].oldX-1||c[d].posY>c[d].oldY+1||c[d].posY<c[d].oldY-1)&&(y=!0);g&&(y=x<g-1),x++}return c.forEach(function(t,e){f["cluster"+e]=t.points}),h.forEach(function(t,e){f["noise"+e]=[t]}),f},optimizedKmeans:function(t,e,a,i){var r,o,n=this,s=n.xAxis,l=n.yAxis,p=i.processedDistance||clusterDefaultOptions.layoutAlgorithm.gridSize,d={},u=n.getRealExtremes(),c=(n.options.cluster||{}).marker;return!n.markerClusterInfo||n.initMaxX&&n.initMaxX<u.maxX||n.initMinX&&n.initMinX>u.minX||n.initMaxY&&n.initMaxY<u.maxY||n.initMinY&&n.initMinY>u.minY?(n.initMaxX=u.maxX,n.initMinX=u.minX,n.initMaxY=u.maxY,n.initMinY=u.minY,d=n.markerClusterAlgorithms?n.markerClusterAlgorithms.kmeans.call(n,t,e,a,i):{},n.baseClusters=null):(n.baseClusters||(n.baseClusters={clusters:n.markerClusterInfo.clusters,noise:n.markerClusterInfo.noise}),n.baseClusters.clusters.forEach(function(a){a.pointsOutside=[],a.pointsInside=[],a.data.forEach(function(t){r=Math.sqrt(Math.pow(s.toPixels(t.x)-s.toPixels(a.x),2)+Math.pow(l.toPixels(t.y)-l.toPixels(a.y),2)),(o=(a.clusterZone&&a.clusterZone.marker&&a.clusterZone.marker.radius?a.clusterZone.marker:c&&c.radius?c:clusterDefaultOptions.marker).radius)+(0<=p-o?p-o:o)<r&&defined(a.pointsOutside)?a.pointsOutside.push(t):defined(a.pointsInside)&&a.pointsInside.push(t)}),a.pointsInside.length&&(d[a.id]=a.pointsInside),a.pointsOutside.forEach(function(t,e){d[a.id+"_noise"+e]=[t]})}),n.baseClusters.noise.forEach(function(t){d[t.id]=t.data})),d}},Scatter.prototype.preventClusterCollisions=function(t){var a,i,r,e,o,n,s,l,p,d,u,c=this,h=c.xAxis,f=c.yAxis,m=t.key.split("-").map(parseFloat),g=m[0],x=m[1],y=t.gridSize,S=t.groupedData,C=t.defaultRadius,I=t.clusterRadius,b=x*y,D=g*y,P=h.toPixels(t.x),A=f.toPixels(t.y),k=[],M=0,v=(c.options.cluster||{}).marker,O=(c.options.cluster||{}).zones,E=c.getGridOffset();for(P-=E.plotLeft,A-=E.plotTop,n=1;n<5;n++)for(e=n%2?-1:1,o=n<3?-1:1,e=Math.floor((P+e*I)/y),u=[(o=Math.floor((A+o*I)/y))+"-"+e,o+"-"+x,g+"-"+e],s=0;s<u.length;s++)-1===k.indexOf(u[s])&&u[s]!==t.key&&k.push(u[s]);return k.forEach(function(t){var e;if(S[t]){if(S[t].posX||(d=getClusterPosition(S[t]),S[t].posX=d.x,S[t].posY=d.y),i=h.toPixels(S[t].posX||0)-E.plotLeft,r=f.toPixels(S[t].posY||0)-E.plotTop,e=t.split("-").map(parseFloat),p=e[0],l=e[1],O)for(a=S[t].length,n=0;n<O.length;n++)a>=O[n].from&&a<=O[n].to&&(M=defined((O[n].marker||{}).radius)?O[n].marker.radius||0:(v&&v.radius?v:clusterDefaultOptions.marker).radius);1<S[t].length&&0===M&&v&&v.radius?M=v.radius:1===S[t].length&&(M=C),d=I+M,M=0,l!==x&&Math.abs(P-i)<d&&(P=l-x<0?b+I:b+y-I),p!==g&&Math.abs(A-r)<d&&(A=p-g<0?D+I:D+y-I)}}),m=h.toValue(P+E.plotLeft),c=f.toValue(A+E.plotTop),{x:S[t.key].posX=m,y:S[t.key].posY=c}},Scatter.prototype.isValidGroupedDataObject=function(t){var e,a=!1;return!!isObject(t)&&(objectEach(t,function(t){if(a=!0,isArray(t)&&t.length){for(e=0;e<t.length;e++)if(!isObject(t[e])||!t[e].x||!t[e].y)return void(a=!1)}else a=!1}),a)},Scatter.prototype.getClusteredData=function(t,e){var a,i,r,o,n,s,l,p,d,u,c,h,f,m=this,g=[],x=[],y=[],S=[],C=[],I=0,b=Math.max(2,e.minimumClusterSize||2);if(isFunction(e.layoutAlgorithm.type)&&!m.isValidGroupedDataObject(t))return error("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,m.chart),!1;for(f in t)if(t[f].length>=b){if(r=t[f],a=getStateId(),n=r.length,e.zones)for(h=0;h<e.zones.length;h++)n>=e.zones[h].from&&n<=e.zones[h].to&&((u=e.zones[h]).zoneIndex=h,d=e.zones[h].marker,c=e.zones[h].className);for(p=getClusterPosition(r),s="grid"!==e.layoutAlgorithm.type||e.allowOverlap?{x:p.x,y:p.y}:(s=m.options.marker||{},m.preventClusterCollisions({x:p.x,y:p.y,key:f,groupedData:t,gridSize:m.getScaledGridSize(e.layoutAlgorithm),defaultRadius:s.radius||3+(s.lineWidth||0),clusterRadius:d&&d.radius?d.radius:(e.marker||{}).radius||clusterDefaultOptions.marker.radius})),h=0;h<n;h++)r[h].parentStateId=a;if(y.push({x:s.x,y:s.y,id:f,stateId:a,index:I,data:r,clusterZone:u,clusterZoneClassName:c}),g.push(s.x),x.push(s.y),C.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:merge(e.marker,{states:e.states},d||{})}}),m.options.data&&m.options.data.length)for(h=0;h<n;h++)isObject(m.options.data[r[h].dataIndex])&&(r[h].options=m.options.data[r[h].dataIndex]);I++,d=null}else for(h=0;h<t[f].length;h++)i=t[f][h],a=getStateId(),l=null,o=((m.options||{}).data||[])[i.dataIndex],g.push(i.x),x.push(i.y),i.parentStateId=a,S.push({x:i.x,y:i.y,id:f,stateId:a,index:I,data:t[f]}),l=o&&"object"==typeof o&&!isArray(o)?merge(o,{x:i.x,y:i.y}):{userOptions:o,x:i.x,y:i.y},C.push({options:l}),I++;return{clusters:y,noise:S,groupedXData:g,groupedYData:x,groupMap:C}},Scatter.prototype.destroyClusteredData=function(){(this.markerClusterSeriesData||[]).forEach(function(t){t&&t.destroy&&t.destroy()}),this.markerClusterSeriesData=null},Scatter.prototype.hideClusteredData=function(){var t=this.markerClusterSeriesData,e=((this.markerClusterInfo||{}).pointsState||{}).oldState||{},a=oldPointsStateId.map(function(t){return(e[t].point||{}).id||""});(t||[]).forEach(function(t){t&&-1!==a.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t&&t.destroy&&t.destroy()})},Scatter.prototype.generatePoints=function(){var t,e,a,i,r,o,n,s,l,p,d=this,u=d.chart,c=d.xAxis,h=d.yAxis,f=d.options.cluster,m=d.getRealExtremes(),g=[],x=[],y=[];if(f&&f.enabled&&d.xData&&d.xData.length&&d.yData&&d.yData.length&&!u.polar){for(n=f.layoutAlgorithm.type,(s=f.layoutAlgorithm).processedGridSize=relativeLength(s.gridSize||clusterDefaultOptions.layoutAlgorithm.gridSize,u.plotWidth),s.processedDistance=relativeLength(s.distance||clusterDefaultOptions.layoutAlgorithm.distance,u.plotWidth),u=s.kmeansThreshold||clusterDefaultOptions.layoutAlgorithm.kmeansThreshold,t=Math.abs(c.toValue(s.processedGridSize/2)-c.toValue(0)),e=Math.abs(h.toValue(s.processedGridSize/2)-h.toValue(0)),p=0;p<d.xData.length;p++)d.dataMaxX||(defined(i)&&defined(a)&&defined(o)&&defined(r)?isNumber(d.yData[p])&&isNumber(o)&&isNumber(r)&&(i=Math.max(d.xData[p],i),a=Math.min(d.xData[p],a),o=Math.max(d.yData[p]||o,o),r=Math.min(d.yData[p]||r,r)):(i=a=d.xData[p],o=r=d.yData[p])),d.xData[p]>=m.minX-t&&d.xData[p]<=m.maxX+t&&(d.yData[p]||m.minY)>=m.minY-e&&(d.yData[p]||m.maxY)<=m.maxY+e&&(g.push(d.xData[p]),x.push(d.yData[p]),y.push(p));defined(i)&&defined(a)&&isNumber(o)&&isNumber(r)&&(d.dataMaxX=i,d.dataMinX=a,d.dataMaxY=o,d.dataMinY=r),n=(h=(isFunction(n)?n:d.markerClusterAlgorithms?n&&d.markerClusterAlgorithms[n]?d.markerClusterAlgorithms[n]:g.length<u?d.markerClusterAlgorithms.kmeans:d.markerClusterAlgorithms.grid:function(){return!1}).call(this,g,x,y,s))&&d.getClusteredData(h,f),u=f.animation&&d.markerClusterInfo&&d.markerClusterInfo.pointsState&&d.markerClusterInfo.pointsState.oldState?(destroyOldPoints(d.markerClusterInfo.pointsState.oldState),d.markerClusterInfo.pointsState.newState):{},s=d.xData.length,h=d.markerClusterInfo,n&&(d.processedXData=n.groupedXData,d.processedYData=n.groupedYData,d.hasGroupedData=!0,d.markerClusterInfo=n,d.groupMap=n.groupMap),baseGeneratePoints.apply(this),n&&d.markerClusterInfo&&((d.markerClusterInfo.clusters||[]).forEach(function(t){(l=d.points[t.index]).isCluster=!0,l.clusteredData=t.data,l.clusterPointsAmount=t.data.length,t.point=l,addEvent(l,"click",d.onDrillToCluster)}),(d.markerClusterInfo.noise||[]).forEach(function(t){t.point=d.points[t.index]}),f.animation&&d.markerClusterInfo&&(d.markerClusterInfo.pointsState={oldState:u,newState:d.getPointsState(n,h,s)}),f.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else baseGeneratePoints.apply(this)},addEvent(Chart,"render",function(){(this.series||[]).forEach(function(e){var t,a;e.markerClusterInfo&&(t=e.options.cluster,a=((e.markerClusterInfo||{}).pointsState||{}).oldState,(t||{}).animation&&e.markerClusterInfo&&0===e.chart.pointer.pinchDown.length&&"pan"!==(e.xAxis.eventArgs||{}).trigger&&a&&Object.keys(a).length&&(e.markerClusterInfo.clusters.forEach(function(t){e.animateClusterPoint(t)}),e.markerClusterInfo.noise.forEach(function(t){e.animateClusterPoint(t)})))})}),addEvent(Point,"update",function(){if(this.dataGroup)return error("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}),addEvent(Series,"destroy",Scatter.prototype.destroyClusteredData),addEvent(Series,"afterRender",function(){var e=(this.options.cluster||{}).drillToCluster;this.markerClusterInfo&&this.markerClusterInfo.clusters&&this.markerClusterInfo.clusters.forEach(function(t){t.point&&t.point.graphic&&(t.point.graphic.addClass("highcharts-cluster-point"),e&&t.point&&(t.point.graphic.css({cursor:"pointer"}),t.point.dataLabel&&t.point.dataLabel.css({cursor:"pointer"})),defined(t.clusterZone)&&t.point.graphic.addClass(t.clusterZoneClassName||"highcharts-cluster-zone-"+t.clusterZone.zoneIndex))})}),addEvent(Point,"drillToCluster",function(t){var e=(((t.point||t.target).series.options.cluster||{}).events||{}).drillToCluster;isFunction(e)&&e.call(this,t)}),addEvent(Axis,"setExtremes",function(){var e,t=this.chart,a=0;t.series.forEach(function(t){t.markerClusterInfo&&(e=animObject((t.options.cluster||{}).animation),a=e.duration||0)}),syncTimeout(function(){t.tooltip&&t.tooltip.destroy()},a)});