"use strict";import Connection from"./Connection.js";import Chart from"../Core/Chart/Chart.js";import H from"../Core/Globals.js";import D from"../Core/DefaultOptions.js";var defaultOptions=D.defaultOptions;import Point from"../Core/Series/Point.js";import U from"../Core/Utilities.js";var addEvent=U.addEvent,defined=U.defined,error=U.error,extend=U.extend,merge=U.merge,objectEach=U.objectEach,pick=U.pick,splat=U.splat;import pathfinderAlgorithms from"./PathfinderAlgorithms.js";import"../Extensions/ArrowSymbols.js";var deg2rad=H.deg2rad,max=Math.max,min=Math.min;function getPointBB(t){var n=t.shapeArgs;return n?{xMin:n.x||0,xMax:(n.x||0)+(n.width||0),yMin:n.y||0,yMax:(n.y||0)+(n.height||0)}:(n=t.graphic&&t.graphic.getBBox())?{xMin:t.plotX-n.width/2,xMax:t.plotX+n.width/2,yMin:t.plotY-n.height/2,yMax:t.plotY+n.height/2}:null}function calculateObstacleMargin(t){for(var n,i,e=t.length,o=0,r=[],s=function(t,n,i){var e=pick(i,10),o=t.yMax+e>n.yMin-e&&t.yMin-e<n.yMax+e,r=t.xMax+e>n.xMin-e&&t.xMin-e<n.xMax+e,a=o?t.xMin>n.xMax?t.xMin-n.xMax:n.xMin-t.xMax:1/0,i=r?t.yMin>n.yMax?t.yMin-n.yMax:n.yMin-t.yMax:1/0;return r&&o?e?s(t,n,Math.floor(e/2)):1/0:min(a,i)};o<e;++o)for(n=o+1;n<e;++n)(i=s(t[o],t[n]))<80&&r.push(i);return r.push(80),max(Math.floor(r.sort(function(t,n){return t-n})[Math.floor(r.length/10)]/2-1),1)}extend(defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var Pathfinder=function(){function t(t){this.chart=void 0,this.chartObstacles=void 0,this.chartObstacleMetrics=void 0,this.connections=void 0,this.group=void 0,this.lineObstacles=void 0,this.init(t)}return t.prototype.init=function(t){this.chart=t,this.connections=[],addEvent(t,"redraw",function(){this.pathfinder.update()})},t.prototype.update=function(t){var e=this.chart,o=this,n=o.connections;o.connections=[],e.series.forEach(function(t){t.visible&&!t.options.isInternal&&t.points.forEach(function(n){var t=n.options;t&&t.dependency&&(t.connect=t.dependency);var i,t=n.options&&n.options.connect&&splat(n.options.connect);n.visible&&!1!==n.isInside&&t&&t.forEach(function(t){(i=e.get("string"==typeof t?t:t.to))instanceof Point&&i.series.visible&&i.visible&&!1!==i.isInside&&o.connections.push(new Connection(n,i,"string"==typeof t?{}:t))})})});for(var i=0,r=void 0,a=void 0,s=n.length,c=o.connections.length;i<s;++i){for(a=!1,r=0;r<c;++r)if(n[i].fromPoint===o.connections[r].fromPoint&&n[i].toPoint===o.connections[r].toPoint){o.connections[r].graphics=n[i].graphics,a=!0;break}a||n[i].destroy()}delete this.chartObstacles,delete this.lineObstacles,o.renderConnections(t)},t.prototype.renderConnections=function(t){t?this.chart.series.forEach(function(n){function t(){var t=n.chart.pathfinder;(t&&t.connections||[]).forEach(function(t){t.fromPoint&&t.fromPoint.series===n&&t.render()}),n.pathfinderRemoveRenderEvent&&(n.pathfinderRemoveRenderEvent(),delete n.pathfinderRemoveRenderEvent)}!1===n.options.animation?t():n.pathfinderRemoveRenderEvent=addEvent(n,"afterAnimate",t)}):this.connections.forEach(function(t){t.render()})},t.prototype.getChartObstacles=function(t){for(var n,i=[],e=this.chart.series,o=pick(t.algorithmMargin,0),r=0,a=e.length;r<a;++r)if(e[r].visible&&!e[r].options.isInternal)for(var s,c,h=0,d=e[r].points.length;h<d;++h)(c=e[r].points[h]).visible&&(s=getPointBB(c))&&i.push({xMin:s.xMin-o,xMax:s.xMax+o,yMin:s.yMin-o,yMax:s.yMax+o});return i=i.sort(function(t,n){return t.xMin-n.xMin}),defined(t.algorithmMargin)||(n=t.algorithmMargin=calculateObstacleMargin(i),i.forEach(function(t){t.xMin-=n,t.xMax+=n,t.yMin-=n,t.yMax+=n})),i},t.prototype.getObstacleMetrics=function(t){for(var n,i=0,e=0,o=t.length;o--;)i<(n=t[o].xMax-t[o].xMin)&&(i=n),e<(n=t[o].yMax-t[o].yMin)&&(e=n);return{maxHeight:e,maxWidth:i}},t.prototype.getAlgorithmStartDirection=function(t){var n="left"!==t.align&&"right"!==t.align,t="top"!==t.verticalAlign&&"bottom"!==t.verticalAlign;return n?t&&void 0:t||void 0},t}();function warnLegacy(t){(t.options.pathfinder||t.series.reduce(function(t,n){return n.options&&merge(!0,n.options.connectors=n.options.connectors||{},n.options.pathfinder),t||n.options&&n.options.pathfinder},!1))&&(merge(!0,t.options.connectors=t.options.connectors||{},t.options.pathfinder),error('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.'))}Pathfinder.prototype.algorithms=pathfinderAlgorithms,H.Pathfinder=Pathfinder,extend(Point.prototype,{getPathfinderAnchorPoint:function(t){var n,i,e=getPointBB(this);switch(t.align){case"right":n="xMax";break;case"left":n="xMin"}switch(t.verticalAlign){case"top":i="yMin";break;case"bottom":i="yMax"}return{x:n?e[n]:(e.xMin+e.xMax)/2,y:i?e[i]:(e.yMin+e.yMax)/2}},getRadiansToVector:function(t,n){var i;return defined(n)||(i=getPointBB(this))&&(n={x:(i.xMin+i.xMax)/2,y:(i.yMin+i.yMax)/2}),Math.atan2(n.y-t.y,t.x-n.x)},getMarkerVector:function(t,n,i){for(var e,o=2*Math.PI,r=t,a=getPointBB(this),s=a.xMax-a.xMin,c=a.yMax-a.yMin,h=Math.atan2(c,s),d=!1,f=s/2,p=c/2,M=a.xMin+f,x=a.yMin+p,t={x:M,y:x},s=1,a=1;r<-Math.PI;)r+=o;for(;r>Math.PI;)r-=o;return e=Math.tan(r),-h<r&&r<=h?(a=-1,d=!0):h<r&&r<=Math.PI-h?a=-1:r>Math.PI-h||r<=-(Math.PI-h)?(s=-1,d=!0):s=-1,d?(t.x+=s*f,t.y+=a*f*e):(t.x+=s*(c/(2*e)),t.y+=a*p),i.x!==M&&(t.x=i.x),i.y!==x&&(t.y=i.y),{x:t.x+n*Math.cos(r),y:t.y-n*Math.sin(r)}}}),Chart.prototype.callbacks.push(function(t){!1!==t.options.connectors.enabled&&(warnLegacy(t),this.pathfinder=new Pathfinder(this),this.pathfinder.update(!0))});export default Pathfinder;