"use strict";var __extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var o in t)t.hasOwnProperty(o)&&(e[o]=t[o])})(e,t)};return function(e,t){function o(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(o.prototype=t.prototype,new o)}}();import A from"../../../Core/Animation/AnimationUtilities.js";var animObject=A.animObject;import H from"../../../Core/Globals.js";var noop=H.noop;import SeriesRegistry from"../../../Core/Series/SeriesRegistry.js";var SMAIndicator=SeriesRegistry.seriesTypes.sma;import U from"../../../Core/Utilities.js";var addEvent=U.addEvent,arrayMax=U.arrayMax,arrayMin=U.arrayMin,correctFloat=U.correctFloat,error=U.error,extend=U.extend,isArray=U.isArray,merge=U.merge;function arrayExtremesOHLC(e){for(var t,o=e.length,r=e[0][3],n=r,a=1;a<o;a++)(t=e[a][3])<r&&(r=t),n<t&&(n=t);return{min:r,max:n}}var abs=Math.abs,columnPrototype=SeriesRegistry.seriesTypes.column.prototype,VBPIndicator=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.data=void 0,e.negWidths=void 0,e.options=void 0,e.points=void 0,e.posWidths=void 0,e.priceZones=void 0,e.rangeStep=void 0,e.volumeDataArray=void 0,e.zoneStarts=void 0,e.zoneLinesSVG=void 0,e}return __extends(e,t),e.prototype.init=function(e){var t,o,r=this;return H.seriesTypes.sma.prototype.init.apply(r,arguments),o=r.options.params,t=r.linkedParent,o=e.get(o.volumeSeriesID),r.addCustomEvents(t,o),r},e.prototype.addCustomEvents=function(e,t){var o=this;function r(){o.chart.redraw(),o.setData([]),o.zoneStarts=[],o.zoneLinesSVG&&(o.zoneLinesSVG=o.zoneLinesSVG.destroy())}return o.dataEventsToUnbind.push(addEvent(e,"remove",function(){r()})),t&&o.dataEventsToUnbind.push(addEvent(t,"remove",function(){r()})),o},e.prototype.animate=function(e){var o=this,t=o.chart.inverted,r=o.group,n={};!e&&r&&(e=t?o.yAxis.top:o.xAxis.left,t?(r["forceAnimate:translateY"]=!0,n.translateY=e):(r["forceAnimate:translateX"]=!0,n.translateX=e),r.animate(n,extend(animObject(o.options.animation),{step:function(e,t){o.group.attr({scaleX:Math.max(.001,t.pos)})}})))},e.prototype.drawPoints=function(){var e=this;e.options.volumeDivision.enabled&&(e.posNegVolume(!0,!0),columnPrototype.drawPoints.apply(e,arguments),e.posNegVolume(!1,!1)),columnPrototype.drawPoints.apply(e,arguments)},e.prototype.posNegVolume=function(e,t){var o,r,n,a,i=this,s=t?["positive","negative"]:["negative","positive"],p=i.options.volumeDivision,l=i.points.length,d=[],u=[],c=0;for(e?(i.posWidths=d,i.negWidths=u):(d=i.posWidths,u=i.negWidths);c<l;c++)(a=i.points[c])[s[0]+"Graphic"]=a.graphic,a.graphic=a[s[1]+"Graphic"],e&&(o=a.shapeArgs.width,(n=(r=i.priceZones[c]).wholeVolumeData)?(d.push(o/n*r.positiveVolumeData),u.push(o/n*r.negativeVolumeData)):(d.push(0),u.push(0))),a.color=t?p.styles.positiveColor:p.styles.negativeColor,a.shapeArgs.width=(t?i.posWidths:i.negWidths)[c],a.shapeArgs.x=t?a.shapeArgs.x:i.posWidths[c]},e.prototype.translate=function(){var e,o,r,n,a,i,t,s,p,l=this,d=l.options,u=l.chart,c=l.yAxis,h=c.min,m=l.options.zoneLines,v=l.priceZones,y=0;columnPrototype.translate.apply(l),(e=l.points).length&&(t=d.pointPadding<.5?d.pointPadding:.1,d=l.volumeDataArray,o=arrayMax(d),r=u.plotWidth/2,s=u.plotTop,n=abs(c.toPixels(h)-c.toPixels(h+l.rangeStep)),a=abs(c.toPixels(h)-c.toPixels(h+l.rangeStep)),t&&(t=abs(n*(1-2*t)),y=abs((n-t)/2),n=abs(t)),e.forEach(function(e,t){e.barX=e.plotX=0,p=e.plotY=c.toPixels(v[t].start)-s-(c.reversed?n-a:n)-y,i=correctFloat(r*v[t].wholeVolumeData/o),e.pointWidth=i,e.shapeArgs=l.crispCol.apply(l,[0,p,i,n]),e.volumeNeg=v[t].negativeVolumeData,e.volumePos=v[t].positiveVolumeData,e.volumeAll=v[t].wholeVolumeData}),m.enabled&&l.drawZones(u,c,l.zoneStarts,m.styles))},e.prototype.getValues=function(e,t){var o,r,n=e.processedXData,a=e.processedYData,i=this.chart,s=t.ranges,p=[],l=[],d=[];if(e.chart)if(r=i.get(t.volumeSeriesID)){if(!(o=isArray(a[0]))||4===a[0].length)return(this.priceZones=this.specifyZones(o,n,a,s,r)).forEach(function(e,t){p.push([e.x,e.end]),l.push(p[t][0]),d.push(p[t][1])}),{values:p,xData:l,yData:d};error("Type of "+e.name+" series is different than line, OHLC or candlestick.",!0,i)}else error("Series "+t.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,i);else error("Base series not found! In case it has been removed, add a new one.",!0,i)},e.prototype.specifyZones=function(e,t,o,r,n){var a,i,s=!!e&&arrayExtremesOHLC(o),p=s?s.min:arrayMin(o),s=s?s.max:arrayMax(o),l=this.zoneStarts=[],d=[],u=0,c=1;if(!p||!s)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];for(a=this.rangeStep=correctFloat(s-p)/r,l.push(p);u<r-1;u++)l.push(correctFloat(l[u]+a));for(l.push(s),i=l.length;c<i;c++)d.push({index:c-1,x:t[0],start:l[c-1],end:l[c]});return this.volumePerZone(e,d,n,t,o)},e.prototype.volumePerZone=function(t,e,o,r,n){var a,i,s,p,l,d=this,u=o.processedXData,c=o.processedYData,h=e.length-1,m=n.length,o=c.length;return abs(m-o)&&(r[0]!==u[0]&&c.unshift(0),r[m-1]!==u[o-1]&&c.push(0)),d.volumeDataArray=[],e.forEach(function(e){for(e.wholeVolumeData=0,e.positiveVolumeData=0,e.negativeVolumeData=0,l=0;l<m;l++)s=i=!1,p=t?n[l][3]:n[l],a=l?t?n[l-1][3]:n[l-1]:p,p<=e.start&&0===e.index&&(i=!0),p>=e.end&&e.index===h&&(s=!0),(p>e.start||i)&&(p<e.end||s)&&(e.wholeVolumeData+=c[l],p<a?e.negativeVolumeData+=c[l]:e.positiveVolumeData+=c[l]);d.volumeDataArray.push(e.wholeVolumeData)}),e},e.prototype.drawZones=function(t,o,e,r){var n,a=t.renderer,i=this.zoneLinesSVG,s=[],p=t.plotWidth,l=t.plotTop;e.forEach(function(e){n=o.toPixels(e)-l,s=s.concat(t.renderer.crispLine([["M",0,n],["L",p,n]],r.lineWidth))}),i?i.animate({d:s}):i=this.zoneLinesSVG=a.path(s).attr({"stroke-width":r.lineWidth,stroke:r.color,dashstyle:r.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)},e.defaultOptions=merge(SMAIndicator.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1e3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}}),e}(SMAIndicator);extend(VBPIndicator.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:noop,drawGraph:noop,getColumnMetrics:columnPrototype.getColumnMetrics,crispCol:columnPrototype.crispCol}),SeriesRegistry.registerSeriesType("vbp",VBPIndicator);export default VBPIndicator;