/*
 Highstock JS v9.1.2 (2021-06-16)

 All technical indicators for Highcharts Stock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
'use strict';(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(v){e(v);e.Highcharts=v;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function v(e,d,h,k){e.hasOwnProperty(d)||(e[d]=k.apply(null,h))}e=e?e._modules:{};v(e,"Mixins/IndicatorRequired.js",[e["Core/Utilities.js"]],function(e){var d=e.error;
return{isParentLoaded:function(h,e,m,p,r){if(h)return p?p(h):!0;d(r||this.generateMessage(m,e));return!1},generateMessage:function(d,e){return'Error: "'+d+'" indicator type requires "'+e+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+d}}});v(e,"Stock/Indicators/SMA/SMAComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=e.series,k=e.seriesTypes.ohlc.prototype;e=d.addEvent;var m=d.extend;e(h,"init",function(d){d=
d.options;d.useOhlcData&&"highcharts-navigator-series"!==d.id&&m(this,{pointValKey:k.pointValKey,pointArrayMap:k.pointArrayMap,toYData:k.toYData})});e(h,"afterSetOptions",function(d){d=d.options;var h=d.dataGrouping;h&&d.useOhlcData&&"highcharts-navigator-series"!==d.id&&(h.approximation="ohlc")})});v(e,"Stock/Indicators/SMA/SMAIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var f=function(a,
b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,a){f.__proto__=a}||function(f,a){for(var b in a)a.hasOwnProperty(b)&&(f[b]=a[b])};return f(a,b)};return function(a,b){function c(){this.constructor=a}f(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=d.seriesTypes.line,p=h.addEvent,r=h.error,l=h.extend,g=h.isArray,c=h.merge,a=h.pick,b=h.splat,f=e.generateMessage;e=function(x){function t(){var f=null!==x&&x.apply(this,arguments)||this;f.data=void 0;
f.dataEventsToUnbind=void 0;f.linkedParent=void 0;f.options=void 0;f.points=void 0;return f}k(t,x);t.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(f){f()});x.prototype.destroy.apply(this,arguments)};t.prototype.getName=function(){var f=this.name,b=[];f||((this.nameComponents||[]).forEach(function(f,c){b.push(this.options.params[f]+a(this.nameSuffixes[c],""))},this),f=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+b.join(", ")+")":""));return f};t.prototype.getValues=
function(f,a){var b=a.period,c=f.xData;f=f.yData;var x=f.length,t=0,u=0,F=[],l=[],d=[],h=-1;if(!(c.length<b)){for(g(f[0])&&(h=a.index?a.index:0);t<b-1;)u+=0>h?f[t]:f[t][h],t++;for(a=t;a<x;a++){u+=0>h?f[a]:f[a][h];var e=[c[a],u/b];F.push(e);l.push(e[0]);d.push(e[1]);u-=0>h?f[a-t]:f[a-t][h]}return{values:F,xData:l,yData:d}}};t.prototype.init=function(a,c){function g(){var f=t.points||[],a=(t.xData||[]).length,c=t.getValues(t.linkedParent,t.options.params)||{values:[],xData:[],yData:[]},x=[],g=!0;if(a&&
!t.hasGroupedData&&t.visible&&t.points)if(t.cropped){if(t.xAxis){var u=t.xAxis.min;var n=t.xAxis.max}a=t.cropData(c.xData,c.yData,u,n);for(u=0;u<a.xData.length;u++)x.push([a.xData[u]].concat(b(a.yData[u])));a=c.xData.indexOf(t.xData[0]);u=c.xData.indexOf(t.xData[t.xData.length-1]);-1===a&&u===c.xData.length-2&&x[0][0]===f[0].x&&x.shift();t.updateData(x)}else c.xData.length!==a-1&&c.xData.length!==a+1&&(g=!1,t.updateData(c.values));g&&(t.xData=c.xData,t.yData=c.yData,t.options.data=c.values);!1===
t.bindTo.series&&(delete t.processedXData,t.isDirty=!0,t.redraw());t.isDirtyData=!1}var t=this,u=t.requireIndicators();if(!u.allLoaded)return r(f(t.type,u.needed));x.prototype.init.call(t,a,c);a.linkSeries();t.dataEventsToUnbind=[];if(!t.linkedParent)return r("Series "+t.options.linkedTo+" not found! Check `linkedTo`.",!1,a);t.dataEventsToUnbind.push(p(t.bindTo.series?t.linkedParent:t.linkedParent.xAxis,t.bindTo.eventName,g));if("init"===t.calculateOn)g();else var w=p(t.chart,t.calculateOn,function(){g();
w()})};t.prototype.processData=function(){var f=this.options.compareToMain,a=this.linkedParent;x.prototype.processData.apply(this,arguments);a&&a.compareValue&&f&&(this.compareValue=a.compareValue)};t.prototype.requireIndicators=function(){var f={allLoaded:!0};this.requiredIndicators.forEach(function(a){d.seriesTypes[a]?d.seriesTypes[a].prototype.requireIndicators():(f.allLoaded=!1,f.needed=a)});return f};t.defaultOptions=c(m.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,
params:{index:0,period:14}});return t}(m);l(e.prototype,{bindTo:{series:!0,eventName:"updatedData"},calculateOn:"init",hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],requiredIndicators:[],useCommonDataGrouping:!0});d.registerSeriesType("sma",e);"";return e});v(e,"Stock/Indicators/AD/ADIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var l=function(g,c){l=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return l(g,c)};return function(g,c){function a(){this.constructor=g}l(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.error,p=d.extend,r=d.merge;d=function(l){function g(){var c=null!==l&&l.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(g,l);g.populateAverage=function(c,a,b,f,x){x=a[f][1];var t=a[f][2];a=a[f][3];
b=b[f];return[c[f],a===x&&a===t||x===t?0:(2*a-t-x)/(x-t)*b]};g.prototype.getValues=function(c,a){var b=a.period,f=c.xData,x=c.yData,t=a.volumeSeriesID,u=c.chart.get(t);a=u&&u.yData;var F=x?x.length:0,l=[],d=[],n=[];if(!(f.length<=b&&F&&4!==x[0].length)){if(u){for(t=b;t<F;t++)c=l.length,u=g.populateAverage(f,x,a,t,b),0<c&&(u[1]+=l[c-1][1]),l.push(u),d.push(u[0]),n.push(u[1]);return{values:l,xData:d,yData:n}}m("Series "+t+" not found! Check `volumeSeriesID`.",!0,c.chart)}};g.defaultOptions=r(k.defaultOptions,
{params:{index:void 0,volumeSeriesID:"volume"}});return g}(k);p(d.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"});e.registerSeriesType("ad",d);"";return d});v(e,"Stock/Indicators/AO/AOIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Core/Color/Palette.js"]],function(e,d,h,k){var m=this&&this.__extends||function(){var a=function(f,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,a){f.__proto__=a}||function(f,
a){for(var b in a)a.hasOwnProperty(b)&&(f[b]=a[b])};return a(f,b)};return function(f,b){function c(){this.constructor=f}a(f,b);f.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}();e=e.noop;var p=d.seriesTypes,r=p.sma;p=p.column;var l=h.extend,g=h.merge,c=h.correctFloat,a=h.isArray;h=function(b){function f(){var f=null!==b&&b.apply(this,arguments)||this;f.data=void 0;f.options=void 0;f.points=void 0;return f}m(f,b);f.prototype.drawGraph=function(){var f=this.options,a=this.points,
b=f.greaterBarColor;f=f.lowerBarColor;var c=a[0];if(!this.userOptions.color&&c)for(c.color=b,c=1;c<a.length;c++)a[c].color=a[c].y>a[c-1].y?b:a[c].y<a[c-1].y?f:a[c-1].color};f.prototype.getValues=function(f){var b=f.xData||[];f=f.yData||[];var x=f.length,g=[],l=[],d=[],n=0,w=0,q;if(!(34>=b.length)&&a(f[0])&&4===f[0].length){for(q=0;33>q;q++){var B=(f[q][1]+f[q][2])/2;29<=q&&(n=c(n+B));w=c(w+B)}for(q=33;q<x;q++){B=(f[q][1]+f[q][2])/2;n=c(n+B);w=c(w+B);B=n/5;var h=w/34;B=c(B-h);g.push([b[q],B]);l.push(b[q]);
d.push(B);B=q+1-5;h=q+1-34;n=c(n-(f[B][1]+f[B][2])/2);w=c(w-(f[h][1]+f[h][2])/2)}return{values:g,xData:l,yData:d}}};f.defaultOptions=g(r.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:k.positiveColor,lowerBarColor:k.negativeColor,threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}});return f}(r);l(h.prototype,{nameBase:"AO",nameComponents:!1,markerAttribs:e,getColumnMetrics:p.prototype.getColumnMetrics,crispCol:p.prototype.crispCol,translate:p.prototype.translate,
drawPoints:p.prototype.drawPoints});d.registerSeriesType("ao",h);"";return h});v(e,"Mixins/MultipleLines.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(e,d){var h=d.defined,k=d.error,m=d.merge,p=e.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(d){var l=[];(this.pointArrayMap||[]).forEach(function(g){g!==d&&l.push("plot"+g.charAt(0).toUpperCase()+g.slice(1))});return l},toYData:function(d){var l=[];(this.pointArrayMap||
[]).forEach(function(g){l.push(d[g])});return l},translate:function(){var d=this,l=d.pointArrayMap,g=[],c;g=d.getTranslatedLinesNames();p.prototype.translate.apply(d,arguments);d.points.forEach(function(a){l.forEach(function(b,f){c=a[b];null!==c&&(a[g[f]]=d.yAxis.toPixels(c,!0))})})},drawGraph:function(){var d=this,l=d.linesApiNames,g=d.points,c=g.length,a=d.options,b=d.graph,f={options:{gapSize:a.gapSize}},x=[],t;d.getTranslatedLinesNames(d.pointValKey).forEach(function(f,a){for(x[a]=[];c--;)t=g[c],
x[a].push({x:t.x,plotX:t.plotX,plotY:t[f],isNull:!h(t[f])});c=g.length});l.forEach(function(b,c){x[c]?(d.points=x[c],a[b]?d.options=m(a[b].styles,f):k('Error: "There is no '+b+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),d.graph=d["graph"+b],p.prototype.drawGraph.call(d),d["graph"+b]=d.graph):k('Error: "'+b+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});d.points=
g;d.options=a;d.graph=b;p.prototype.drawGraph.call(d)}}});v(e,"Stock/Indicators/Aroon/AroonIndicator.js",[e["Mixins/MultipleLines.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){function k(c,a){var b=c[0],f=0,x;for(x=1;x<c.length;x++)if("max"===a&&c[x]>=b||"min"===a&&c[x]<=b)b=c[x],f=x;return f}var m=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,a){f.__proto__=a}||function(f,a){for(var b in a)a.hasOwnProperty(b)&&
(f[b]=a[b])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),p=d.seriesTypes.sma,r=h.extend,l=h.merge,g=h.pick;h=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,c);a.prototype.getValues=function(a,f){f=f.period;var b=a.xData,c=(a=a.yData)?a.length:0,u=[],d=[],l=[],A;for(A=f-1;A<c;A++){var n=a.slice(A-f+1,A+2);var w=
k(n.map(function(a){return g(a[2],a)}),"min");n=k(n.map(function(a){return g(a[1],a)}),"max");n=n/f*100;w=w/f*100;b[A+1]&&(u.push([b[A+1],n,w]),d.push(b[A+1]),l.push([n,w]))}return{values:u,xData:d,yData:l}};a.defaultOptions=l(p.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},
dataGrouping:{approximation:"averages"}});return a}(p);r(h.prototype,{linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,toYData:e.toYData,translate:e.translate});d.registerSeriesType("aroon",h);"";return h});v(e,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[e["Mixins/MultipleLines.js"],e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],
function(e,d,h,k){var m=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),p=h.seriesTypes.aroon,r=k.extend,l=k.merge,g=h.seriesTypes.aroon;k=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||
this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,c);a.prototype.getValues=function(a,f){var b=[],c=[],u=[];a=g.prototype.getValues.call(this,a,f);for(f=0;f<a.yData.length;f++){var d=a.yData[f][0];var l=a.yData[f][1];d-=l;b.push([a.xData[f],d]);c.push(a.xData[f]);u.push(d)}return{values:b,xData:c,yData:u}};a.prototype.init=function(){var a=arguments,f=this;d.isParentLoaded(g,"aroon",f.type,function(b){b.prototype.init.apply(f,a)})};a.defaultOptions=l(p.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});
return a}(p);r(k.prototype,l(e,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[]}));h.registerSeriesType("aroonoscillator",k);"";return k});v(e,"Stock/Indicators/ATR/ATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){function h(d,g){return Math.max(d[1]-d[2],"undefined"===typeof g?0:Math.abs(d[1]-g[3]),"undefined"===typeof g?0:Math.abs(d[2]-g[3]))}var k=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return d(g,c)};return function(g,c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),m=e.seriesTypes.sma,p=d.isArray,r=d.merge;d=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.points=void 0;c.options=void 0;return c}k(g,d);g.prototype.getValues=function(c,a){a=a.period;var b=
c.xData,f=(c=c.yData)?c.length:0,g=1,t=0,d=0,l=[],e=[],A=[],n;var w=[[b[0],c[0]]];if(!(b.length<=a)&&p(c[0])&&4===c[0].length){for(n=1;n<=f;n++)if(w.push([b[n],c[n]]),a<g){var q=a;var B=b[n-1],k=h(c[n-1],c[n-2]);q=[B,(t*(q-1)+k)/q];t=q[1];l.push(q);e.push(q[0]);A.push(q[1])}else a===g?(t=d/(n-1),l.push([b[n-1],t]),e.push(b[n-1]),A.push(t)):d+=h(c[n-1],c[n-2]),g++;return{values:l,xData:e,yData:A}}};g.defaultOptions=r(m.defaultOptions,{params:{index:void 0}});return g}(m);e.registerSeriesType("atr",
d);"";return d});v(e,"Stock/Indicators/BB/BBIndicator.js",[e["Mixins/MultipleLines.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,
new b)}}(),m=d.seriesTypes.sma,p=h.extend,r=h.isArray,l=h.merge;h=function(g){function c(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,g);c.prototype.init=function(){d.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};c.prototype.getValues=function(a,b){var f=b.period,c=b.standardDeviation,g=a.xData,u=(a=a.yData)?a.length:
0,l=[],h=[],A=[],n;if(!(g.length<f)){var w=r(a[0]);for(n=f;n<=u;n++){var q=g.slice(n-f,n);var B=a.slice(n-f,n);var e=d.seriesTypes.sma.prototype.getValues.call(this,{xData:q,yData:B},b);q=e.xData[0];e=e.yData[0];for(var k=0,z=B.length,m=0;m<z;m++){var p=(w?B[m][b.index]:B[m])-e;k+=p*p}p=Math.sqrt(k/(z-1));B=e+c*p;p=e-c*p;l.push([q,B,e,p]);h.push(q);A.push([B,e,p])}return{values:l,xData:h,yData:A}}};c.defaultOptions=l(m.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,
lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return c}(m);p(h.prototype,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,
translate:e.translate,toYData:e.toYData});d.registerSeriesType("bb",h);"";return h});v(e,"Stock/Indicators/CCI/CCIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){function h(d){return d.reduce(function(g,c){return g+c},0)}var k=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return d(g,c)};return function(g,
c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),m=e.seriesTypes.sma,p=d.isArray,r=d.merge;d=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.points=void 0;c.options=void 0;return c}k(g,d);g.prototype.getValues=function(c,a){a=a.period;var b=c.xData,f=(c=c.yData)?c.length:0,g=[],t=1,d=[],l=[],e=[];if(!(b.length<=a)&&p(c[0])&&4===c[0].length){for(;t<a;){var A=c[t-1];g.push((A[1]+A[2]+A[3])/3);t++}for(t=
a;t<=f;t++){A=c[t-1];A=(A[1]+A[2]+A[3])/3;var n=g.push(A);var w=g.slice(n-a);n=h(w)/a;var q,B=w.length,k=0;for(q=0;q<B;q++)k+=Math.abs(n-w[q]);w=k/a;A=(A-n)/(.015*w);d.push([b[t-1],A]);l.push(b[t-1]);e.push(A)}return{values:d,xData:l,yData:e}}};g.defaultOptions=r(m.defaultOptions,{params:{index:void 0}});return g}(m);e.registerSeriesType("cci",d);"";return d});v(e,"Stock/Indicators/CMF/CMFIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||
function(){var d=function(e,l){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(g,c){g.__proto__=c}||function(g,c){for(var a in c)c.hasOwnProperty(a)&&(g[a]=c[a])};return d(e,l)};return function(e,l){function g(){this.constructor=e}d(e,l);e.prototype=null===l?Object.create(l):(g.prototype=l.prototype,new g)}}(),k=e.seriesTypes.sma,m=d.merge;d=function(d){function e(){var l=null!==d&&d.apply(this,arguments)||this;l.data=void 0;l.options=void 0;l.points=void 0;l.volumeSeries=void 0;
l.linkedParent=void 0;l.yData=void 0;l.nameBase="Chaikin Money Flow";return l}h(e,d);e.prototype.isValid=function(){var d=this.chart,g=this.options,c=this.linkedParent;d=this.volumeSeries||(this.volumeSeries=d.get(g.params.volumeSeriesID));var a=c&&c.yData&&4===c.yData[0].length;return!!(c&&d&&c.xData&&c.xData.length>=g.params.period&&d.xData&&d.xData.length>=g.params.period&&a)};e.prototype.getValues=function(d,g){if(this.isValid())return this.getMoneyFlow(d.xData,d.yData,this.volumeSeries.yData,
g.period)};e.prototype.getMoneyFlow=function(d,g,c,a){function b(a,f){var b=a[1],c=a[2];a=a[3];return null!==f&&null!==b&&null!==c&&null!==a&&b!==c?(a-c-(b-a))/(b-c)*f:(w=n,null)}var f=g.length,x=[],t=0,u=0,l=[],e=[],A=[],n,w=-1;if(0<a&&a<=f){for(n=0;n<a;n++)x[n]=b(g[n],c[n]),t+=c[n],u+=x[n];l.push(d[n-1]);e.push(n-w>=a&&0!==t?u/t:null);for(A.push([l[0],e[0]]);n<f;n++){x[n]=b(g[n],c[n]);t-=c[n-a];t+=c[n];u-=x[n-a];u+=x[n];var q=[d[n],n-w>=a?u/t:null];l.push(q[0]);e.push(q[1]);A.push([q[0],q[1]])}}return{values:A,
xData:l,yData:e}};e.defaultOptions=m(k.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return e}(k);e.registerSeriesType("cmf",d);"";return d});v(e,"Stock/Indicators/DMI/DMIIndicator.js",[e["Mixins/MultipleLines.js"],e["Core/Color/Palette.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k){var m=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&
(a[b]=f[b])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,new c)}}(),p=h.seriesTypes.sma,r=k.correctFloat,l=k.extend,g=k.isArray,c=k.merge;k=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}m(b,a);b.prototype.calculateDM=function(a,b,c){var f=a[b][1],g=a[b][2],t=a[b-1][1];a=a[b-1][2];return r(f-t>a-g?c?Math.max(f-t,0):0:c?0:Math.max(a-g,0))};b.prototype.calculateDI=function(a,b){return a/
b*100};b.prototype.calculateDX=function(a,b){return r(Math.abs(a-b)/Math.abs(a+b)*100)};b.prototype.smoothValues=function(a,b,c){return r(a-a/c+b)};b.prototype.getTR=function(a,b){return r(Math.max(a[1]-a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};b.prototype.getValues=function(a,b){b=b.period;var f=a.xData,c=(a=a.yData)?a.length:0,x=[],d=[],e=[];if(!(f.length<=b)&&g(a[0])&&4===a[0].length){var n=0,w=0,q=0,l;for(l=1;l<c;l++)if(l<=b){var h=this.calculateDM(a,l,!0);var k=this.calculateDM(a,
l);var r=this.getTR(a[l],a[l-1]);n+=h;w+=k;q+=r;l===b&&(r=this.calculateDI(n,q),k=this.calculateDI(w,q),h=this.calculateDX(n,w),x.push([f[l],h,r,k]),d.push(f[l]),e.push([h,r,k]))}else h=this.calculateDM(a,l,!0),k=this.calculateDM(a,l),r=this.getTR(a[l],a[l-1]),n=this.smoothValues(n,h,b),w=this.smoothValues(w,k,b),q=this.smoothValues(q,r,b),r=this.calculateDI(n,q),k=this.calculateDI(w,q),h=this.calculateDX(n,w),x.push([f[l],h,r,k]),d.push(f[l]),e.push([h,r,k]);return{values:x,xData:d,yData:e}}};b.defaultOptions=
c(p.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},plusDILine:{styles:{lineWidth:1,lineColor:d.positiveColor}},minusDILine:{styles:{lineWidth:1,
lineColor:d.negativeColor}},dataGrouping:{approximation:"averages"}});return b}(p);l(k.prototype,{nameBase:"DMI",pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y",linesApiNames:["plusDILine","minusDILine"],drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,translate:e.translate,toYData:e.toYData});h.registerSeriesType("dmi",k);"";return k});v(e,"Stock/Indicators/DPO/DPOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],
function(e,d){function h(c,a,b,f,x){a=g(a[b][f],a[b]);return x?l(c-a):l(c+a)}var k=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),m=e.seriesTypes.sma,p=d.extend,r=d.merge,l=d.correctFloat,g=d.pick;
d=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.options=void 0;a.data=void 0;a.points=void 0;return a}k(a,c);a.prototype.getValues=function(a,f){var b=f.period;f=f.index;var c=b+Math.floor(b/2+1),d=a.xData||[];a=a.yData||[];var l=a.length,e=[],A=[],n=[],w=0,q,B;if(!(d.length<=c)){for(q=0;q<b-1;q++)w=h(w,a,q,f);for(B=0;B<=l-c;B++){var k=B+b-1;q=B+c-1;w=h(w,a,k,f);k=g(a[q][f],a[q]);k-=w/b;w=h(w,a,B,f,!0);e.push([d[q],k]);A.push(d[q]);n.push(k)}return{values:e,xData:A,yData:n}}};
a.defaultOptions=r(m.defaultOptions,{params:{index:0,period:21}});return a}(m);p(d.prototype,{nameBase:"DPO"});e.registerSeriesType("dpo",d);"";return d});v(e,"Stock/Indicators/EMA/EMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return d(g,c)};return function(g,
c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.correctFloat,p=d.isArray,r=d.merge;d=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(g,d);g.prototype.accumulatePeriodPoints=function(c,a,b){for(var f=0,g=0,t;g<c;)t=0>a?b[g]:b[g][a],f+=t,g++;return f};g.prototype.calculateEma=function(c,a,b,f,g,t,d){c=c[b-1];a=0>t?a[b-1]:a[b-1][t];
f="undefined"===typeof g?d:m(a*f+g*(1-f));return[c,f]};g.prototype.getValues=function(c,a){var b=a.period,f=c.xData,g=(c=c.yData)?c.length:0,t=2/(b+1),d=[],e=[],l=[],h=-1;if(!(g<b)){p(c[0])&&(h=a.index?a.index:0);a=this.accumulatePeriodPoints(b,h,c);for(a/=b;b<g+1;b++){var n=this.calculateEma(f,c,b,t,n,h,a);d.push(n);e.push(n[0]);l.push(n[1]);n=n[1]}return{values:d,xData:e,yData:l}}};g.defaultOptions=r(k.defaultOptions,{params:{index:3,period:9}});return g}(k);e.registerSeriesType("ema",d);"";return d});
v(e,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,
new c)}}(),m=d.seriesTypes,p=m.ad,r=m.ema,l=h.correctFloat;m=h.extend;var g=h.merge,c=h.error;h=function(a){function b(){var f=null!==a&&a.apply(this,arguments)||this;f.data=void 0;f.options=void 0;f.points=void 0;return f}k(b,a);b.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(r,"ema",b.type,function(f){f.prototype.init.apply(b,a)})};b.prototype.getValues=function(a,b){var f=b.periods,g=b.period,d=[],x=[],e=[],n;if(2!==f.length||f[1]<=f[0])c('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');
else if(b=p.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:g}))if(a=r.prototype.getValues.call(this,b,{period:f[0]}),b=r.prototype.getValues.call(this,b,{period:f[1]}),a&&b){f=f[1]-f[0];for(n=0;n<b.yData.length;n++)g=l(a.yData[n+f]-b.yData[n]),d.push([b.xData[n],g]),x.push(b.xData[n]),e.push(g);return{values:d,xData:x,yData:e}}};b.defaultOptions=g(r.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}});return b}(r);m(h.prototype,{nameBase:"Chaikin Osc",
nameComponents:["periods"]});d.registerSeriesType("chaikin",h);"";return h});v(e,"Stock/Indicators/CMO/CMOIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):
(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.sma,m=d.isNumber,p=d.merge;d=function(d){function e(){var g=null!==d&&d.apply(this,arguments)||this;g.data=void 0;g.options=void 0;g.points=void 0;return g}h(e,d);e.prototype.getValues=function(g,c){var a=c.period,b=g.xData,f=g.yData;g=f?f.length:0;var d=[],t=[],e=[],l,h=c.index;if(!(b.length<a)){m(f[0])?c=f:(h=Math.min(h,f[0].length-1),c=f.map(function(a){return a[h]}));var A=0,n=f=0;for(l=a;0<l;l--)c[l]>c[l-1]?f+=c[l]-c[l-1]:c[l]<c[l-1]&&(n+=c[l-
1]-c[l]);A=0<f+n?100*(f-n)/(f+n):0;t.push(b[a]);e.push(A);d.push([b[a],A]);for(l=a+1;l<g;l++)A=Math.abs(c[l-a-1]-c[l-a]),c[l]>c[l-1]?f+=c[l]-c[l-1]:c[l]<c[l-1]&&(n+=c[l-1]-c[l]),c[l-a]>c[l-a-1]?f-=A:n-=A,A=0<f+n?100*(f-n)/(f+n):0,t.push(b[l]),e.push(A),d.push([b[l],A]);return{values:d,xData:t,yData:e}}};e.defaultOptions=p(k.defaultOptions,{params:{period:20,index:3}});return e}(k);e.registerSeriesType("cmo",d);"";return d});v(e,"Stock/Indicators/DEMA/DEMAIndicator.js",[e["Mixins/IndicatorRequired.js"],
e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=d.seriesTypes.ema,p=h.correctFloat,r=h.isArray,l=h.merge;h=function(g){function c(){var a=
null!==g&&g.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,g);c.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(m,"ema",b.type,function(f){f.prototype.init.apply(b,a)})};c.prototype.getEMA=function(a,b,f,c,g,d){return m.prototype.calculateEma(d||[],a,"undefined"===typeof g?1:g,this.EMApercent,b,"undefined"===typeof c?-1:c,f)};c.prototype.getValues=function(a,b){var f=b.period,c=2*f,g=a.xData,d=(a=a.yData)?a.length:0,e=
-1,l=[],h=[],n=[],w=0,q=[],B;this.EMApercent=2/(f+1);if(!(d<2*f-1)){r(a[0])&&(e=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(f,e,a);var k=b/f;b=0;for(B=f;B<d+2;B++){B<d+1&&(w=this.getEMA(a,y,k,e,B)[1],q.push(w));var y=w;if(B<c)b+=w;else{B===c&&(k=b/f);w=q[B-f-1];var z=this.getEMA([w],z,k)[1];var O=[g[B-2],p(2*w-z)];l.push(O);h.push(O[0]);n.push(O[1])}}return{values:l,xData:h,yData:n}}};c.defaultOptions=l(m.defaultOptions);return c}(m);d.registerSeriesType("dema",h);"";return h});v(e,"Stock/Indicators/TEMA/TEMAIndicator.js",
[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=d.seriesTypes.ema,p=h.correctFloat,
r=h.isArray,l=h.merge;h=function(g){function c(){var a=null!==g&&g.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,g);c.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(m,"ema",b.type,function(f){f.prototype.init.apply(b,a)})};c.prototype.getEMA=function(a,b,f,c,g,d){return m.prototype.calculateEma(d||[],a,"undefined"===typeof g?1:g,this.EMApercent,b,"undefined"===typeof c?-1:c,f)};c.prototype.getTemaPoint=function(a,b,f,
c){return[a[c-3],p(3*f.level1-3*f.level2+f.level3)]};c.prototype.getValues=function(a,b){var f=b.period,c=2*f,g=3*f,d=a.xData,e=(a=a.yData)?a.length:0,l=-1,h=[],n=[],w=[],q=[],B=[],k,p,z={};this.EMApercent=2/(f+1);if(!(e<3*f-2)){r(a[0])&&(l=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(f,l,a);var y=b/f;b=0;for(k=f;k<e+3;k++){k<e+1&&(z.level1=this.getEMA(a,R,y,l,k)[1],q.push(z.level1));var R=z.level1;if(k<c)b+=z.level1;else{k===c&&(y=b/f,b=0);z.level1=q[k-f-1];z.level2=this.getEMA([z.level1],
D,y)[1];B.push(z.level2);var D=z.level2;if(k<g)b+=z.level2;else{k===g&&(y=b/f);k===e+1&&(z.level1=q[k-f-1],z.level2=this.getEMA([z.level1],D,y)[1],B.push(z.level2));z.level1=q[k-f-2];z.level2=B[k-2*f-1];z.level3=this.getEMA([z.level2],z.prevLevel3,y)[1];if(p=this.getTemaPoint(d,g,z,k))h.push(p),n.push(p[0]),w.push(p[1]);z.prevLevel3=z.level3}}}return{values:h,xData:n,yData:w}}};c.defaultOptions=l(m.defaultOptions);return c}(m);d.registerSeriesType("tema",h);"";return h});v(e,"Stock/Indicators/TRIX/TRIXIndicator.js",
[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return d(g,c)};return function(g,c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),m=d.seriesTypes.tema,p=h.correctFloat,
r=h.merge;h=function(l){function g(){var c=null!==l&&l.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}k(g,l);g.prototype.init=function(){var c=arguments,a=this;e.isParentLoaded(d.seriesTypes.tema,"tema",a.type,function(b){b.prototype.init.apply(a,c)})};g.prototype.getTemaPoint=function(c,a,b,f){if(f>a)return[c[f-3],0!==b.prevLevel3?p(b.level3-b.prevLevel3)/b.prevLevel3*100:null]};g.defaultOptions=r(m.defaultOptions);return g}(m);d.registerSeriesType("trix",h);
"";return h});v(e,"Stock/Indicators/APO/APOIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),m=d.seriesTypes.ema,p=h.extend,r=h.merge,l=h.error;h=function(g){function c(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,g);c.prototype.getValues=function(a,b){var f=b.periods,c=b.index;b=[];var g=[],d=[],e;if(2!==f.length||f[1]<=f[0])l('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var h=m.prototype.getValues.call(this,a,{index:c,period:f[0]});a=m.prototype.getValues.call(this,
a,{index:c,period:f[1]});if(h&&a){f=f[1]-f[0];for(e=0;e<a.yData.length;e++)c=h.yData[e+f]-a.yData[e],b.push([a.xData[e],c]),g.push(a.xData[e]),d.push(c);return{values:b,xData:g,yData:d}}}};c.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(m,"ema",b.type,function(f){f.prototype.init.apply(b,a)})};c.defaultOptions=r(m.defaultOptions,{params:{period:void 0,periods:[10,20]}});return c}(m);p(h.prototype,{nameBase:"APO",nameComponents:["periods"]});d.registerSeriesType("apo",h);"";return h});
v(e,"Stock/Indicators/IKH/IKHIndicator.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k){function m(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function p(a){return a.reduce(function(a,b){return Math.min(a,b[2])},Infinity)}function r(a){return{high:m(a),low:p(a)}}function l(a){var b,f,c,g,d;a.series.forEach(function(a){if(a.xData)for(g=a.xData,d=f=a.xIncrement?1:g.length-1;0<d;d--)if(c=g[d]-g[d-
1],"undefined"===typeof b||c<b)b=c});return b}function g(a,b,f,c){if(a&&b&&f&&c){var g=b.plotX-a.plotX;b=b.plotY-a.plotY;var d=c.plotX-f.plotX;c=c.plotY-f.plotY;var t=a.plotX-f.plotX,e=a.plotY-f.plotY;f=(-b*t+g*e)/(-d*b+g*c);d=(d*e-c*t)/(-d*b+g*c);if(0<=f&&1>=f&&0<=d&&1>=d)return{plotX:a.plotX+d*g,plotY:a.plotY+d*b}}return!1}function c(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=F(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;h.seriesTypes.sma.prototype.drawGraph.call(b)}
var a=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,new c)}}(),b=e.parse,f=h.seriesTypes.sma,x=k.defined;e=k.extend;var t=k.isArray,u=k.isNumber,F=k.merge,L=k.objectEach;d.approximations["ichimoku-averages"]=
function(){var a=[],b;[].forEach.call(arguments,function(f,c){a.push(d.approximations.average(f));b=!b&&"undefined"===typeof a[c]});return b?void 0:a};k=function(d){function e(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}a(e,d);e.prototype.init=function(){h.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=F({tenkanLine:{styles:{lineColor:this.color}},
kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:b(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:b(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:b(this.color).setOpacity(.2).get()}}},this.options)};e.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};e.prototype.translate=function(){var a=this;h.seriesTypes.sma.prototype.translate.apply(a);
a.points.forEach(function(b){a.pointArrayMap.forEach(function(f){var c=b[f];u(c)&&(b["plot"+f]=a.yAxis.toPixels(c,!0),b.plotY=b["plot"+f],b.tooltipPos=[b.plotX,b["plot"+f]],b.isNull=!1)})})};e.prototype.drawGraph=function(){var a=this,b=a.points,f=b.length,d=a.options,t=a.graph,e=a.color,l={options:{gapSize:d.gapSize}},n=a.pointArrayMap.length,u=[[],[],[],[],[],[]],k={tenkanLine:u[0],kijunLine:u[1],chikouLine:u[2],senkouSpanA:u[3],senkouSpanB:u[4],senkouSpan:u[5]},A=[],m=a.options.senkouSpan,r=m.color||
m.styles.fill,p=m.negativeColor,y=[[],[]],v=[[],[]],N=0,K,Q,M;for(a.ikhMap=k;f--;){var E=b[f];for(K=0;K<n;K++)m=a.pointArrayMap[K],x(E[m])&&u[K].push({plotX:E.plotX,plotY:E["plot"+m],isNull:!1});p&&f!==b.length-1&&(m=k.senkouSpanB.length-1,E=g(k.senkouSpanA[m-1],k.senkouSpanA[m],k.senkouSpanB[m-1],k.senkouSpanB[m]),K={plotX:E.plotX,plotY:E.plotY,isNull:!1,intersectPoint:!0},E&&(k.senkouSpanA.splice(m,0,K),k.senkouSpanB.splice(m,0,K),A.push(m)))}L(k,function(b,f){d[f]&&"senkouSpan"!==f&&(a.points=
u[N],a.options=F(d[f].styles,l),a.graph=a["graph"+f],a.fillGraph=!1,a.color=e,h.seriesTypes.sma.prototype.drawGraph.call(a),a["graph"+f]=a.graph);N++});a.graphCollection&&a.graphCollection.forEach(function(b){a[b].destroy();delete a[b]});a.graphCollection=[];if(p&&k.senkouSpanA[0]&&k.senkouSpanB[0]){A.unshift(0);A.push(k.senkouSpanA.length-1);for(n=0;n<A.length-1;n++){m=A[n];E=A[n+1];f=k.senkouSpanB.slice(m,E+1);m=k.senkouSpanA.slice(m,E+1);if(1<=Math.floor(f.length/2))if(E=Math.floor(f.length/2),
f[E].plotY===m[E].plotY){for(M=K=E=0;M<f.length;M++)E+=f[M].plotY,K+=m[M].plotY;E=E>K?0:1}else E=f[E].plotY>m[E].plotY?0:1;else E=f[0].plotY>m[0].plotY?0:1;y[E]=y[E].concat(f);v[E]=v[E].concat(m)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(b,f){y[f].length&&v[f].length&&(Q=0===f?r:p,c({indicator:a,points:y[f],nextPoints:v[f],color:Q,options:d,gap:l,graph:a[b]}),a[b]=a.graph,a.graphCollection.push(b))})}else c({indicator:a,points:k.senkouSpanB,nextPoints:k.senkouSpanA,
color:r,options:d,gap:l,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;delete a.fillGraph;a.points=b;a.options=d;a.graph=t;a.color=e};e.prototype.getGraphPath=function(a){var b=[],f;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((f=h.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&f.length){f[0][0]="L";b=h.seriesTypes.sma.prototype.getGraphPath.call(this,a);f=f.slice(0,b.length);for(var c=f.length-1;0<=c;c--)b.push(f[c])}}else b=h.seriesTypes.sma.prototype.getGraphPath.apply(this,
arguments);return b};e.prototype.getValues=function(a,b){var f=b.period,c=b.periodTenkan;b=b.periodSenkouSpanB;var g=a.xData,d=a.yData,e=d&&d.length||0;a=l(a.xAxis);var x=[],n=[],u;if(!(g.length<=f)&&t(d[0])&&4===d[0].length){var h=g[0]-f*a;for(u=0;u<f;u++)n.push(h+u*a);for(u=0;u<e;u++){if(u>=c){var k=d.slice(u-c,u);k=r(k);k=(k.high+k.low)/2}if(u>=f){var q=d.slice(u-f,u);q=r(q);q=(q.high+q.low)/2;var A=(k+q)/2}if(u>=b){var w=d.slice(u-b,u);w=r(w);w=(w.high+w.low)/2}h=d[u][3];var F=g[u];"undefined"===
typeof x[u]&&(x[u]=[]);"undefined"===typeof x[u+f]&&(x[u+f]=[]);x[u+f][0]=k;x[u+f][1]=q;x[u+f][2]=void 0;x[u][2]=h;u<=f&&(x[u+f][3]=void 0,x[u+f][4]=void 0);"undefined"===typeof x[u+2*f]&&(x[u+2*f]=[]);x[u+2*f][3]=A;x[u+2*f][4]=w;n.push(F)}for(u=1;u<=f;u++)n.push(F+u*a);return{values:x,xData:n,yData:x}}};e.defaultOptions=F(f.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return e}(f);e(k.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});h.registerSeriesType("ikh",k);"";return k});v(e,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[e["Mixins/MultipleLines.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=
c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=d.seriesTypes.sma,p=h.correctFloat,r=h.extend,l=h.merge;h=function(g){function c(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,g);c.prototype.init=function(){d.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};c.prototype.getValues=function(a,
b){var f=b.period,c=b.periodATR,g=b.multiplierATR,e=a.yData;e=e?e.length:0;var l=[];b=d.seriesTypes.ema.prototype.getValues(a,{period:f,index:b.index});var h=d.seriesTypes.atr.prototype.getValues(a,{period:c}),k=[],n=[],w;if(!(e<f)){for(w=f;w<=e;w++){var q=b.values[w-f];var m=h.values[w-c];var r=q[0];a=p(q[1]+g*m[1]);m=p(q[1]-g*m[1]);q=q[1];l.push([r,a,q,m]);k.push(r);n.push([a,q,m])}return{values:l,xData:k,yData:n}}};c.defaultOptions=l(m.defaultOptions,{params:{period:20,periodATR:10,multiplierATR:2},
bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1});return c}(m);r(h.prototype,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",
nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,translate:e.translate,toYData:e.toYData});d.registerSeriesType("keltnerchannels",h);"";return h});v(e,"Stock/Indicators/Klinger/KlingerIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Mixins/MultipleLines.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k){var m=this&&this.__extends||
function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,new c)}}(),p=h.seriesTypes,r=p.sma,l=p.ema,g=k.correctFloat,c=k.error;p=k.extend;var a=k.isArray,b=k.merge;k=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=
void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}m(d,f);d.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(l,"ema",b.type,function(f){f.prototype.init.apply(b,a)})};d.prototype.calculateTrend=function(a,b){return a[b][1]+a[b][2]+a[b][3]>a[b-1][1]+a[b-1][2]+a[b-1][3]?1:-1};d.prototype.isValidData=function(b){var f=this.chart,g=this.options,d=this.linkedParent;b=a(b)&&4===b.length;(f=this.volumeSeries||(this.volumeSeries=f.get(g.params.volumeSeriesID)))||c("Series "+
g.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d.chart);return!(![d,f].every(function(a){return a&&a.xData&&a.xData.length>=g.params.slowAvgPeriod})||!b)};d.prototype.getCM=function(a,b,f,c,d){return g(b+(f===c?a:d))};d.prototype.getDM=function(a,b){return g(a-b)};d.prototype.getVolumeForce=function(a){var b=[],f=1;var c=0;var g=a[0][1]-a[0][2];var d=0;for(f;f<a.length;f++){var e=this.calculateTrend(a,f);var t=this.getDM(a[f][1],a[f][2]);c=this.getCM(c,t,e,d,g);d=this.volumeSeries.yData[f]*
e*Math.abs(2*(t/c-1))*100;b.push([d]);d=e;g=t}return b};d.prototype.getEMA=function(a,b,f,c,g,d,e){return l.prototype.calculateEma(e||[],a,"undefined"===typeof d?1:d,c,b,"undefined"===typeof g?-1:g,f)};d.prototype.getSMA=function(a,b,f){return l.prototype.accumulatePeriodPoints(a,b,f)/a};d.prototype.getValues=function(a,b){var f=[],c=a.xData;a=a.yData;var d=[],e=[],t=[],x,l=0,h=0,u=void 0,k=void 0,m=null;if(this.isValidData(a[0])){var r=this.getVolumeForce(a),p=this.getSMA(b.fastAvgPeriod,0,r),y=
this.getSMA(b.slowAvgPeriod,0,r),v=2/(b.fastAvgPeriod+1),H=2/(b.slowAvgPeriod+1);for(l;l<a.length;l++)l>=b.fastAvgPeriod&&(u=h=this.getEMA(r,u,p,v,0,l,c)[1]),l>=b.slowAvgPeriod&&(k=x=this.getEMA(r,k,y,H,0,l,c)[1],x=g(h-x),t.push(x),t.length>=b.signalPeriod&&(m=t.slice(-b.signalPeriod).reduce(function(a,b){return a+b})/b.signalPeriod),f.push([c[l],x,m]),d.push(c[l]),e.push([x,m]));return{values:f,xData:d,yData:e}}};d.defaultOptions=b(r.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,
volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});return d}(r);p(k.prototype,{linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],
pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y",drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,translate:d.translate,toYData:d.toYData});h.registerSeriesType("klinger",k);"";return k});v(e,"Stock/Indicators/MACD/MACDIndicator.js",[e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,new c)}}(),m=e.noop,p=d.seriesTypes.sma,r=h.extend,l=h.correctFloat,g=h.defined,c=h.merge;h=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.currentLineZone=void 0;b.graphmacd=void 0;b.graphsignal=void 0;b.macdZones=
void 0;b.signalZones=void 0;return b}k(b,a);b.prototype.init=function(){d.seriesTypes.sma.prototype.init.apply(this,arguments);this.options&&(this.options=c({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)};b.prototype.toYData=function(a){return[a.y,
a.signal,a.MACD]};b.prototype.translate=function(){var a=this,b=["plotSignal","plotMACD"];e.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(f){[f.signal,f.MACD].forEach(function(c,g){null!==c&&(f[b[g]]=a.yAxis.toPixels(c,!0))})})};b.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();d.seriesTypes.sma.prototype.destroy.apply(this,arguments)};b.prototype.drawGraph=
function(){for(var a=this,b=a.points,e=b.length,l=a.options,h=a.zones,k={options:{gapSize:l.gapSize}},A=[[],[]],n;e--;)n=b[e],g(n.plotMACD)&&A[0].push({plotX:n.plotX,plotY:n.plotMACD,isNull:!g(n.plotMACD)}),g(n.plotSignal)&&A[1].push({plotX:n.plotX,plotY:n.plotSignal,isNull:!g(n.plotMACD)});["macd","signal"].forEach(function(b,f){a.points=A[f];a.options=c(l[b+"Line"].styles,k);a.graph=a["graph"+b];a.currentLineZone=b+"Zones";a.zones=a[a.currentLineZone].zones;d.seriesTypes.sma.prototype.drawGraph.call(a);
a["graph"+b]=a.graph});a.points=b;a.options=l;a.zones=h;a.currentLineZone=null};b.prototype.getZonesGraphs=function(b){var f=a.prototype.getZonesGraphs.call(this,b),c=f;this.currentLineZone&&(c=f.splice(this[this.currentLineZone].startIndex+1),c.length?c.splice(0,0,b[0]):c=[b[0]]);return c};b.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;d.seriesTypes.sma.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();
this.zones=a};b.prototype.getValues=function(a,b){var f=b.longPeriod-b.shortPeriod,c=0,e=[],h=[],x=[];if(!(a.xData.length<b.longPeriod+b.signalPeriod)){var n=d.seriesTypes.ema.prototype.getValues(a,{period:b.shortPeriod,index:b.index});var k=d.seriesTypes.ema.prototype.getValues(a,{period:b.longPeriod,index:b.index});n=n.values;k=k.values;for(a=0;a<=n.length;a++)g(k[a])&&g(k[a][1])&&g(n[a+f])&&g(n[a+f][0])&&e.push([n[a+f][0],0,null,n[a+f][1]-k[a][1]]);for(a=0;a<e.length;a++)h.push(e[a][0]),x.push([0,
null,e[a][3]]);b=d.seriesTypes.ema.prototype.getValues({xData:h,yData:x},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<e.length;a++)e[a][0]>=b[0][0]&&(e[a][2]=b[c][1],x[a]=[0,b[c][1],e[a][3]],null===e[a][3]?(e[a][1]=0,x[a][0]=0):(e[a][1]=l(e[a][3]-b[c][1]),x[a][0]=l(e[a][3]-b[c][1])),c++);return{values:e,xData:h,yData:x}}};b.defaultOptions=c(p.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],
styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0});return b}(p);r(h.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y","signal","MACD"],
parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:m,getColumnMetrics:e.seriesTypes.column.prototype.getColumnMetrics,crispCol:e.seriesTypes.column.prototype.crispCol,drawPoints:e.seriesTypes.column.prototype.drawPoints});d.registerSeriesType("macd",h);"";return h});v(e,"Stock/Indicators/MFI/MFIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){function h(a){return a.reduce(function(a,f){return a+f})}function k(a){return(a[1]+a[2]+a[3])/3}var m=
this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return a(b,f)};return function(b,f){function c(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(c.prototype=f.prototype,new c)}}(),p=e.seriesTypes.sma,r=d.extend,l=d.merge,g=d.error,c=d.isArray;d=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;
b.options=void 0;b.points=void 0;return b}m(b,a);b.prototype.getValues=function(a,b){var f=b.period,d=a.xData,e=a.yData,l=e?e.length:0,x=b.decimals,n=1,w=a.chart.get(b.volumeSeriesID),q=w&&w.yData,m=[],r=[],p=[],z=[],y=[];if(!w)g("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart);else if(!(d.length<=f)&&c(e[0])&&4===e[0].length&&q){for(a=k(e[n]);n<f+1;)b=a,a=k(e[n]),b=a>=b,w=a*q[n],z.push(b?w:0),y.push(b?0:w),n++;for(f=n-1;f<l;f++)f>n-1&&(z.shift(),y.shift(),b=a,a=k(e[f]),
b=a>b,w=a*q[f],z.push(b?w:0),y.push(b?0:w)),b=h(y),w=h(z),b=w/b,b=parseFloat((100-100/(1+b)).toFixed(x)),m.push([d[f],b]),r.push(d[f]),p.push(b);return{values:m,xData:r,yData:p}}};b.defaultOptions=l(p.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}});return b}(p);r(d.prototype,{nameBase:"Money Flow Index"});e.registerSeriesType("mfi",d);"";return d});v(e,"Stock/Indicators/Momentum/MomentumIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,
d){var h=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return d(g,c)};return function(g,c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.extend,p=d.isArray,r=d.merge;d=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;
c.options=void 0;c.points=void 0;return c}h(g,d);g.prototype.getValues=function(c,a){var b=a.period;a=a.index;var f=c.xData,g=(c=c.yData)?c.length:0,d=[],e=[],l=[],h;if(!(f.length<=b)&&p(c[0])){for(h=b+1;h<g;h++){var k=[f[h-1],c[h-1][a]-c[h-b-1][a]];d.push(k);e.push(k[0]);l.push(k[1])}k=[f[h-1],c[h-1][a]-c[h-b-1][a]];d.push(k);e.push(k[0]);l.push(k[1]);return{values:d,xData:e,yData:l}}};g.defaultOptions=r(k.defaultOptions,{params:{index:3}});return g}(k);m(d.prototype,{nameBase:"Momentum"});e.registerSeriesType("momentum",
d);"";return d});v(e,"Stock/Indicators/NATR/NATRIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.atr,
m=d.merge;d=d.extend;var p=function(d){function e(){var g=null!==d&&d.apply(this,arguments)||this;g.data=void 0;g.points=void 0;g.options=void 0;return g}h(e,d);e.prototype.getValues=function(g,c){var a=k.prototype.getValues.apply(this,arguments),b=a.values.length,f=c.period-1,d=g.yData,e=0;if(a){for(;e<b;e++)a.yData[e]=a.values[e][1]/d[f][3]*100,a.values[e][1]=a.yData[e],f++;return a}};e.defaultOptions=m(k.defaultOptions,{tooltip:{valueSuffix:"%"}});return e}(k);d(p.prototype,{requiredIndicators:["atr"]});
e.registerSeriesType("natr",p);"";return p});v(e,"Stock/Indicators/OBV/OBVIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var g=function(c,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return g(c,a)};return function(c,a){function b(){this.constructor=c}g(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,
new b)}}(),k=e.seriesTypes.sma,m=d.isNumber,p=d.error,r=d.extend,l=d.merge;d=function(g){function c(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}h(c,g);c.prototype.getValues=function(a,b){var f=a.chart.get(b.volumeSeriesID),c=a.xData,g=a.yData,d=[],e=[],l=[],h=!m(g[0]),n=1,k=0;if(f){f=f.yData;a=[c[0],k];var q=h?g[0][3]:g[0];d.push(a);e.push(c[0]);l.push(a[1]);for(n;n<g.length;n++)b=h?g[n][3]:g[n],k=b>q?k+f[n]:b===q?k:k-f[n],a=[c[n],k],q=b,
d.push(a),e.push(c[n]),l.push(a[1]);return{values:d,xData:e,yData:l}}p("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart)};c.defaultOptions=l(k.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}});return c}(k);r(d.prototype,{nameComponents:void 0});e.registerSeriesType("obv",d);"";return d});v(e,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(e){function d(d,
h){var k=d.series.pointArrayMap,m=k.length;for(e.seriesTypes.sma.prototype.pointClass.prototype[h].call(d);m--;)h="dataLabel"+k[m],d[h]&&d[h].element&&d[h].destroy(),d[h]=null}var h=this&&this.__extends||function(){var d=function(e,h){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,e){d.__proto__=e}||function(d,e){for(var g in e)e.hasOwnProperty(g)&&(d[g]=e[g])};return d(e,h)};return function(e,h){function k(){this.constructor=e}d(e,h);e.prototype=null===h?Object.create(h):(k.prototype=
h.prototype,new k)}}();return function(e){function k(){var d=null!==e&&e.apply(this,arguments)||this;d.P=void 0;d.pivotLine=void 0;d.series=void 0;return d}h(k,e);k.prototype.destroyElements=function(){d(this,"destroyElements")};k.prototype.destroy=function(){d(this,"destroyElements")};return k}(e.seriesTypes.sma.prototype.pointClass)});v(e,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[e["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],
function(e,d,h){var k=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var f in b)b.hasOwnProperty(f)&&(a[f]=b[f])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),m=d.seriesTypes.sma,p=h.merge,r=h.extend,l=h.defined,g=h.isArray;h=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||
this;a.data=void 0;a.options=void 0;a.points=void 0;a.endPoint=void 0;a.plotEndPoint=void 0;return a}k(a,c);a.prototype.toYData=function(a){return[a.P]};a.prototype.translate=function(){var a=this;d.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(f){l(b[f])&&(b["plot"+f]=a.yAxis.toPixels(b[f],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};a.prototype.getGraphPath=function(a){for(var b=this,c=a.length,g=[[],[],[],[],[],[],[],[],[]],
e=[],h=b.plotEndPoint,k=b.pointArrayMap.length,m,n,w;c--;){n=a[c];for(w=0;w<k;w++)m=b.pointArrayMap[w],l(n[m])&&g[w].push({plotX:n.plotX,plotY:n["plot"+m],isNull:!1},{plotX:h,plotY:n["plot"+m],isNull:!1},{plotX:h,plotY:null,isNull:!0});h=n.plotX}g.forEach(function(a){e=e.concat(d.seriesTypes.sma.prototype.getGraphPath.call(b,a))});return e};a.prototype.drawDataLabels=function(){var a=this,f=a.pointArrayMap,c,g,e;if(a.options.dataLabels.enabled){var h=a.points.length;f.concat([!1]).forEach(function(b,
l){for(e=h;e--;)g=a.points[e],b?(g.y=g[b],g.pivotLine=b,g.plotY=g["plot"+b],c=g["dataLabel"+b],l&&(g["dataLabel"+f[l-1]]=g.dataLabel),g.dataLabels||(g.dataLabels=[]),g.dataLabels[0]=g.dataLabel=c=c&&c.element?c:null):g["dataLabel"+f[l-1]]=g.dataLabel;d.seriesTypes.sma.prototype.drawDataLabels.apply(a,arguments)})}};a.prototype.getValues=function(a,f){var b=f.period,c=a.xData,d=(a=a.yData)?a.length:0;f=this[f.algorithm+"Placement"];var e=[],h=[],l=[],n;if(!(c.length<b)&&g(a[0])&&4===a[0].length){for(n=
b+1;n<=d+b;n+=b){var k=c.slice(n-b-1,n);var q=a.slice(n-b-1,n);var m=k.length;var r=k[m-1];q=this.getPivotAndHLC(q);q=f(q);q=e.push([r].concat(q));h.push(r);l.push(e[q-1].slice(1))}this.endPoint=k[0]+(r-k[0])/m*b;return{values:e,xData:h,yData:l}}};a.prototype.getPivotAndHLC=function(a){var b=-Infinity,c=Infinity,g=a[a.length-1][3];a.forEach(function(a){b=Math.max(b,a[1]);c=Math.min(c,a[2])});return[(b+c+g)/3,b,c,g]};a.prototype.standardPlacement=function(a){var b=a[1]-a[2];return[null,null,a[0]+b,
2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-b,null,null]};a.prototype.camarillaPlacement=function(a){var b=a[1]-a[2];return[a[3]+1.5*b,a[3]+1.25*b,a[3]+1.1666*b,a[3]+1.0833*b,a[0],a[3]-1.0833*b,a[3]-1.1666*b,a[3]-1.25*b,a[3]-1.5*b]};a.prototype.fibonacciPlacement=function(a){var b=a[1]-a[2];return[null,a[0]+b,a[0]+.618*b,a[0]+.382*b,a[0],a[0]-.382*b,a[0]-.618*b,a[0]-b,null]};a.defaultOptions=p(m.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,
dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return a}(m);r(h.prototype,{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",pointClass:e});d.registerSeriesType("pivotpoints",h);"";return h});v(e,"Stock/Indicators/PPO/PPOIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),m=d.seriesTypes.ema,p=h.correctFloat,r=h.extend,l=h.merge,g=h.error;h=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,c);a.prototype.init=function(){var a=
arguments,c=this;e.isParentLoaded(m,"ema",c.type,function(b){b.prototype.init.apply(c,a)})};a.prototype.getValues=function(a,c){var b=c.periods,f=c.index;c=[];var d=[],e=[],h;if(2!==b.length||b[1]<=b[0])g('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');else{var l=m.prototype.getValues.call(this,a,{index:f,period:b[0]});a=m.prototype.getValues.call(this,a,{index:f,period:b[1]});if(l&&a){b=b[1]-b[0];for(h=0;h<a.yData.length;h++)f=p((l.yData[h+b]-a.yData[h])/
a.yData[h]*100),c.push([a.xData[h],f]),d.push(a.xData[h]),e.push(f);return{values:c,xData:d,yData:e}}}};a.defaultOptions=l(m.defaultOptions,{params:{period:void 0,periods:[12,26]}});return a}(m);r(h.prototype,{nameBase:"PPO",nameComponents:["periods"]});d.registerSeriesType("ppo",h);"";return h});v(e,"Mixins/ReduceArray.js",[],function(){return{minInArray:function(e,d){return e.reduce(function(e,k){return Math.min(e,k[d])},Number.MAX_VALUE)},maxInArray:function(e,d){return e.reduce(function(e,k){return Math.max(e,
k[d])},-Number.MAX_VALUE)},getArrayExtremes:function(e,d,h){return e.reduce(function(e,m){return[Math.min(e[0],m[d]),Math.max(e[1],m[h])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});v(e,"Stock/Indicators/PC/PCIndicator.js",[e["Core/Color/Palette.js"],e["Mixins/MultipleLines.js"],e["Mixins/ReduceArray.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k,y){var m=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),r=k.seriesTypes.sma,l=y.merge;y=y.extend;var g=h.getArrayExtremes;h=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,c);a.prototype.getValues=function(a,c){c=c.period;var b=a.xData,
f=(a=a.yData)?a.length:0,d=[],e=[],h=[],l;if(!(f<c)){for(l=c;l<=f;l++){var n=b[l-1];var k=a.slice(l-c,l);var q=g(k,2,1);k=q[1];var m=q[0];q=(k+m)/2;d.push([n,k,q,m]);e.push(n);h.push([k,q,m])}return{values:d,xData:e,yData:h}}};a.defaultOptions=l(r.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:e.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:e.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(r);y(h.prototype,{getTranslatedLinesNames:d.getTranslatedLinesNames,
drawGraph:d.drawGraph,toYData:d.toYData,pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],translate:d.translate});k.registerSeriesType("pc",h);"";return h});v(e,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(g,c)};return function(g,c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.extend,p=d.isArray,r=d.merge;d=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(g,d);g.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,
arguments);this.options=r({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};g.prototype.toYData=function(c){return[c.top,c.middle,c.bottom]};g.prototype.translate=function(){var c=this,a=["plotTop","plotMiddle","plotBottom"];e.seriesTypes.sma.prototype.translate.apply(c);c.points.forEach(function(b){[b.top,b.middle,b.bottom].forEach(function(f,g){null!==f&&(b[a[g]]=c.yAxis.toPixels(f,!0))})})};g.prototype.drawGraph=function(){for(var c=this,a=c.points,
b=a.length,f=c.options,g=c.graph,d={options:{gapSize:f.gapSize}},h=[[],[]],l;b--;)l=a[b],h[0].push({plotX:l.plotX,plotY:l.plotTop,isNull:l.isNull}),h[1].push({plotX:l.plotX,plotY:l.plotBottom,isNull:l.isNull});["topLine","bottomLine"].forEach(function(a,b){c.points=h[b];c.options=r(f[a].styles,d);c.graph=c["graph"+a];e.seriesTypes.sma.prototype.drawGraph.call(c);c["graph"+a]=c.graph});c.points=a;c.options=f;c.graph=g;e.seriesTypes.sma.prototype.drawGraph.call(c)};g.prototype.getValues=function(c,
a){var b=a.period,f=a.topBand,g=a.bottomBand,d=c.xData,h=(c=c.yData)?c.length:0,l=[],k=[],m=[],n;if(!(d.length<b)&&p(c[0])&&4===c[0].length){for(n=b;n<=h;n++){var w=d.slice(n-b,n);var q=c.slice(n-b,n);q=e.seriesTypes.sma.prototype.getValues.call(this,{xData:w,yData:q},a);w=q.xData[0];q=q.yData[0];var r=q*(1+f);var P=q*(1-g);l.push([w,r,q,P]);k.push(w);m.push([r,q,P])}return{values:l,xData:k,yData:m}}};g.defaultOptions=r(k.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return g}(k);m(d.prototype,{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});e.registerSeriesType("priceenvelopes",d);"";return d});v(e,"Stock/Indicators/PSAR/PSARIndicator.js",[e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.sma,m=d.merge;d=d.extend;var p=function(d){function e(){var g=null!==d&&d.apply(this,arguments)||
this;g.data=void 0;g.points=void 0;g.options=void 0;return g}h(e,d);e.prototype.getValues=function(g,c){var a=g.xData;g=g.yData;var b=g[0][1],f=c.maxAccelerationFactor,d=c.increment,e=c.initialAccelerationFactor,h=g[0][2],l=c.decimals,k=c.index,m=[],n=[],w=[],q=1,r;if(!(k>=g.length)){for(r=0;r<k;r++)b=Math.max(g[r][1],b),h=Math.min(g[r][2],parseFloat(h.toFixed(l)));var p=g[r][1]>h?1:-1;c=c.initialAccelerationFactor;var G=c*(b-h);m.push([a[k],h]);n.push(a[k]);w.push(parseFloat(h.toFixed(l)));for(r=
k+1;r<g.length;r++){k=g[r-1][2];var z=g[r-2][2];var v=g[r-1][1];var y=g[r-2][1];var D=g[r][1];var C=g[r][2];null!==z&&null!==y&&null!==k&&null!==v&&null!==D&&null!==C&&(h=p===q?1===p?h+G<Math.min(z,k)?h+G:Math.min(z,k):h+G>Math.max(y,v)?h+G:Math.max(y,v):b,k=1===p?D>b?D:b:C<b?C:b,D=1===q&&C>h||-1===q&&D>h?1:-1,q=D,G=k,C=d,z=f,v=e,c=q===p?1===q&&G>b?c===z?z:parseFloat((c+C).toFixed(2)):-1===q&&G<b?c===z?z:parseFloat((c+C).toFixed(2)):c:v,b=k-h,G=c*b,m.push([a[r],parseFloat(h.toFixed(l))]),n.push(a[r]),
w.push(parseFloat(h.toFixed(l))),q=p,p=D,b=k)}return{values:m,xData:n,yData:w}}};e.defaultOptions=m(k.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}});return e}(k);d(p.prototype,{nameComponents:void 0});e.registerSeriesType("psar",p);"";return p});v(e,"Stock/Indicators/ROC/ROCIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,
d){var h=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(g,c)};return function(g,c){function a(){this.constructor=g}d(g,c);g.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.isArray,p=d.merge;d=d.extend;var r=function(d){function g(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;
c.options=void 0;c.points=void 0;return c}h(g,d);g.prototype.getValues=function(c,a){var b=a.period,f=c.xData,d=(c=c.yData)?c.length:0,g=[],e=[],h=[],l=-1;if(!(f.length<=b)){m(c[0])&&(l=a.index);for(a=b;a<d;a++){var k=0>l?(k=c[a-b])?(c[a]-k)/k*100:null:(k=c[a-b][l])?(c[a][l]-k)/k*100:null;k=[f[a],k];g.push(k);e.push(k[0]);h.push(k[1])}return{values:g,xData:e,yData:h}}};g.defaultOptions=p(k.defaultOptions,{params:{index:3,period:9}});return g}(k);d(r.prototype,{nameBase:"Rate of Change"});e.registerSeriesType("roc",
r);"";return r});v(e,"Stock/Indicators/RSI/RSIIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.sma,
m=d.isNumber,p=d.merge;d=function(d){function e(){var g=null!==d&&d.apply(this,arguments)||this;g.data=void 0;g.points=void 0;g.options=void 0;return g}h(e,d);e.prototype.getValues=function(d,c){var a=c.period,b=d.xData,f=d.yData;d=f?f.length:0;var g=c.decimals,e=1,h=[],k=[],l=[],r=c.index,n=c=0,w;if(!(b.length<a)){if(m(f[0]))var q=f;else r=Math.min(r,f[0].length-1),q=f.map(function(a){return a[r]});for(;e<a;){var p=parseFloat((q[e]-q[e-1]).toFixed(g));0<p?c+=p:n+=Math.abs(p);e++}f=parseFloat((c/
(a-1)).toFixed(g));for(w=parseFloat((n/(a-1)).toFixed(g));e<d;e++)p=parseFloat((q[e]-q[e-1]).toFixed(g)),0<p?(c=p,n=0):(c=0,n=Math.abs(p)),f=parseFloat(((f*(a-1)+c)/a).toFixed(g)),w=parseFloat(((w*(a-1)+n)/a).toFixed(g)),c=0===w?100:0===f?0:parseFloat((100-100/(1+f/w)).toFixed(g)),h.push([b[e],c]),k.push(b[e]),l.push(c);return{values:h,xData:k,yData:l}}};e.defaultOptions=p(k.defaultOptions,{params:{decimals:4,index:3}});return e}(k);e.registerSeriesType("rsi",d);"";return d});v(e,"Stock/Indicators/Stochastic/StochasticIndicator.js",
[e["Mixins/MultipleLines.js"],e["Mixins/ReduceArray.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k){var m=this&&this.__extends||function(){var c=function(a,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return c(a,b)};return function(a,b){function f(){this.constructor=a}c(a,b);a.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),p=h.seriesTypes.sma,
r=k.extend,l=k.isArray,g=k.merge;k=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,c);a.prototype.init=function(){h.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=g({smoothedLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.periods[0];c=c.periods[1];var f=a.xData,e=(a=a.yData)?a.length:0,g=[],k=[],m=[],n=null,w;if(!(e<b)&&l(a[0])&&4===a[0].length){for(w=
b-1;w<e;w++){var q=a.slice(w-b+1,w+1);var r=d.getArrayExtremes(q,2,1);var p=r[0];q=a[w][3]-p;p=r[1]-p;q=q/p*100;k.push(f[w]);m.push([q,null]);w>=b-1+(c-1)&&(n=h.seriesTypes.sma.prototype.getValues.call(this,{xData:k.slice(-c),yData:m.slice(-c)},{period:c}),n=n.yData[0]);g.push([f[w],q,n]);m[m.length-1][1]=n}return{values:g,xData:k,yData:m}}};a.defaultOptions=g(p.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},
smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return a}(p);r(k.prototype,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,translate:e.translate,toYData:e.toYData});h.registerSeriesType("stochastic",k);"";return k});v(e,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",
[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var d=function(c,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(c,a)};return function(c,a){function b(){this.constructor=c}d(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=d.seriesTypes.stochastic,p=d.seriesTypes,
r=h.extend,l=h.merge;h=function(d){function c(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,d);c.prototype.init=function(){var a=arguments,b=this;e.isParentLoaded(p.stochastic,"stochastic",b.type,function(c){c.prototype.init.apply(b,a)})};c.prototype.getValues=function(a,b){var c=b.periods,d=p.stochastic.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(d){a.xData=d.xData.slice(c[1]-1);d=d.yData.slice(c[1]-1);var e=
p.sma.prototype.getValues.call(this,{xData:a.xData,yData:d},{index:1,period:c[2]});if(e){for(var g=a.xData.length;b<g;b++)a.yData[b]=[d[b][1],e.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],d[b][1],e.yData[b-c[2]+1]||null];return a}}};c.defaultOptions=l(m.defaultOptions,{params:{periods:[14,3,3]}});return c}(m);r(h.prototype,{nameBase:"Slow Stochastic"});d.registerSeriesType("slowstochastic",h);"";return h});v(e,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[e["Core/Color/Palette.js"],e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,d,h){function k(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function f(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(f.prototype=c.prototype,new f)}}(),p=d.seriesTypes,r=p.atr,l=p.sma,g=h.correctFloat,
c=h.isArray;p=h.extend;var a=h.merge,b=h.objectEach;h=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}m(d,f);d.prototype.init=function(){l.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)};d.prototype.drawGraph=function(){var c=this,f=c.options,d=c.linkedParent,e=d?d.points:[],g=c.points,h=c.graph,m=g.length,q=e.length-
m;q=0<q?q:0;for(var r={options:{gapSize:f.gapSize}},p={top:[],bottom:[],intersect:[]},x={top:{styles:{lineWidth:f.lineWidth,lineColor:f.fallingTrendColor||f.color,dashStyle:f.dashStyle}},bottom:{styles:{lineWidth:f.lineWidth,lineColor:f.risingTrendColor||f.color,dashStyle:f.dashStyle}},intersect:f.changeTrendLine},z,v,y,D,C,I,H,J;m--;)z=g[m],v=g[m-1],y=e[m-1+q],D=e[m-2+q],C=e[m+q],I=e[m+q+1],H=z.options.color,J={x:z.x,plotX:z.plotX,plotY:z.plotY,isNull:!1},!D&&y&&d.yData[y.index-1]&&(D=k(d,y.index-
1,3)),!I&&C&&d.yData[C.index+1]&&(I=k(d,C.index+1,3)),!y&&D&&d.yData[D.index+1]?y=k(d,D.index+1,3):!y&&C&&d.yData[C.index-1]&&(y=k(d,C.index-1,3)),z&&y&&C&&D&&z.x!==y.x&&(z.x===C.x?(D=y,y=C):z.x===D.x?(y=D,D={close:d.yData[y.index-1][3],x:d.xData[y.index-1]}):I&&z.x===I.x&&(y=I,D=C)),v&&D&&y?(C={x:v.x,plotX:v.plotX,plotY:v.plotY,isNull:!1},z.y>=y.close&&v.y>=D.close?(z.color=H||f.fallingTrendColor||f.color,p.top.push(J)):z.y<y.close&&v.y<D.close?(z.color=H||f.risingTrendColor||f.color,p.bottom.push(J)):
(p.intersect.push(J),p.intersect.push(C),p.intersect.push(a(C,{isNull:!0})),z.y>=y.close&&v.y<D.close?(z.color=H||f.fallingTrendColor||f.color,v.color=H||f.risingTrendColor||f.color,p.top.push(J),p.top.push(a(C,{isNull:!0}))):z.y<y.close&&v.y>=D.close&&(z.color=H||f.risingTrendColor||f.color,v.color=H||f.fallingTrendColor||f.color,p.bottom.push(J),p.bottom.push(a(C,{isNull:!0}))))):y&&(z.y>=y.close?(z.color=H||f.fallingTrendColor||f.color,p.top.push(J)):(z.color=H||f.risingTrendColor||f.color,p.bottom.push(J)));
b(p,function(b,f){c.points=b;c.options=a(x[f].styles,r);c.graph=c["graph"+f+"Line"];l.prototype.drawGraph.call(c);c["graph"+f+"Line"]=c.graph});c.points=g;c.options=f;c.graph=h};d.prototype.getValues=function(a,b){var f=b.period;b=b.multiplier;var d=a.xData,e=a.yData,h=[],k=[],l=[],m=0===f?0:f-1,t=[],p=[],u;if(!(d.length<=f||!c(e[0])||4!==e[0].length||0>f)){a=r.prototype.getValues.call(this,a,{period:f}).yData;for(u=0;u<a.length;u++){var x=e[m+u];var v=e[m+u-1]||[];var y=t[u-1];var C=p[u-1];var I=
l[u-1];0===u&&(y=C=I=0);f=g((x[1]+x[2])/2+b*a[u]);var H=g((x[1]+x[2])/2-b*a[u]);t[u]=f<y||v[3]>y?f:y;p[u]=H>C||v[3]<C?H:C;if(I===y&&x[3]<t[u]||I===C&&x[3]<p[u])var J=t[u];else if(I===y&&x[3]>t[u]||I===C&&x[3]>p[u])J=p[u];h.push([d[m+u],J]);k.push(d[m+u]);l.push(J)}return{values:h,xData:k,yData:l}}};d.defaultOptions=a(l.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:e.positiveColor,fallingTrendColor:e.negativeColor,changeTrendLine:{styles:{lineWidth:1,lineColor:e.neutralColor80,
dashStyle:"LongDash"}}});return d}(l);p(h.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"]});d.registerSeriesType("supertrend",h);"";return h});v(e,"Stock/Indicators/VBP/VBPIndicator.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h,k){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function f(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(f.prototype=c.prototype,new f)}}(),p=e.animObject;e=d.noop;var r=h.seriesTypes.sma,l=k.addEvent,g=k.arrayMax,c=k.arrayMin,a=k.correctFloat,b=k.error,f=k.extend,x=k.isArray,t=k.merge,u=Math.abs,v=h.seriesTypes.column.prototype;k=function(e){function h(){var a=null!==e&&e.apply(this,arguments)||this;a.data=
void 0;a.negWidths=void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}m(h,e);h.prototype.init=function(a){d.seriesTypes.sma.prototype.init.apply(this,arguments);var b=this.options.params;var c=this.linkedParent;b=a.get(b.volumeSeriesID);this.addCustomEvents(c,b);return this};h.prototype.addCustomEvents=function(a,b){function c(){f.chart.redraw();f.setData([]);f.zoneStarts=[];
f.zoneLinesSVG&&(f.zoneLinesSVG=f.zoneLinesSVG.destroy())}var f=this;f.dataEventsToUnbind.push(l(a,"remove",function(){c()}));b&&f.dataEventsToUnbind.push(l(b,"remove",function(){c()}));return f};h.prototype.animate=function(a){var b=this,c=b.chart.inverted,d=b.group,e={};!a&&d&&(a=c?b.yAxis.top:b.xAxis.left,c?(d["forceAnimate:translateY"]=!0,e.translateY=a):(d["forceAnimate:translateX"]=!0,e.translateX=a),d.animate(e,f(p(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,
c.pos)})}})))};h.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),v.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));v.drawPoints.apply(this,arguments)};h.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],f=this.options.volumeDivision,d=this.points.length,e=[],g=[],h=0,k;a?(this.posWidths=e,this.negWidths=g):(e=this.posWidths,g=this.negWidths);for(;h<d;h++){var l=this.points[h];l[c[0]+"Graphic"]=l.graphic;
l.graphic=l[c[1]+"Graphic"];if(a){var n=l.shapeArgs.width;var m=this.priceZones[h];(k=m.wholeVolumeData)?(e.push(n/k*m.positiveVolumeData),g.push(n/k*m.negativeVolumeData)):(e.push(0),g.push(0))}l.color=b?f.styles.positiveColor:f.styles.negativeColor;l.shapeArgs.width=b?this.posWidths[h]:this.negWidths[h];l.shapeArgs.x=b?l.shapeArgs.x:this.posWidths[h]}};h.prototype.translate=function(){var b=this,c=b.options,f=b.chart,d=b.yAxis,e=d.min,h=b.options.zoneLines,l=b.priceZones,k=0,m,t,p;v.translate.apply(b);
var r=b.points;if(r.length){var x=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var A=g(c);var y=f.plotWidth/2;var F=f.plotTop;var L=u(d.toPixels(e)-d.toPixels(e+b.rangeStep));var N=u(d.toPixels(e)-d.toPixels(e+b.rangeStep));x&&(e=u(L*(1-2*x)),k=u((L-e)/2),L=u(e));r.forEach(function(c,f){t=c.barX=c.plotX=0;p=c.plotY=d.toPixels(l[f].start)-F-(d.reversed?L-N:L)-k;m=a(y*l[f].wholeVolumeData/A);c.pointWidth=m;c.shapeArgs=b.crispCol.apply(b,[t,p,m,L]);c.volumeNeg=l[f].negativeVolumeData;c.volumePos=
l[f].positiveVolumeData;c.volumeAll=l[f].wholeVolumeData});h.enabled&&b.drawZones(f,d,b.zoneStarts,h.styles)}};h.prototype.getValues=function(a,c){var f=a.processedXData,d=a.processedYData,e=this.chart,g=c.ranges,h=[],l=[],k=[],n;if(a.chart)if(n=e.get(c.volumeSeriesID))if((c=x(d[0]))&&4!==d[0].length)b("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,e);else return(this.priceZones=this.specifyZones(c,f,d,g,n)).forEach(function(a,b){h.push([a.x,a.end]);l.push(h[b][0]);k.push(h[b][1])}),
{values:h,xData:l,yData:k};else b("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else b("Base series not found! In case it has been removed, add a new one.",!0,e)};h.prototype.specifyZones=function(b,f,d,e,h){if(b){var l=d.length;for(var k=d[0][3],n=k,m=1,q;m<l;m++)q=d[m][3],q<k&&(k=q),q>n&&(n=q);l={min:k,max:n}}else l=!1;l=(k=l)?k.min:c(d);q=k?k.max:g(d);k=this.zoneStarts=[];n=[];var t=0;m=1;if(!l||!q)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&
(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];var p=this.rangeStep=a(q-l)/e;for(k.push(l);t<e-1;t++)k.push(a(k[t]+p));k.push(q);for(e=k.length;m<e;m++)n.push({index:m-1,x:f[0],start:k[m-1],end:k[m]});return this.volumePerZone(b,n,h,f,d)};h.prototype.volumePerZone=function(a,b,c,f,d){var e=this,g=c.processedXData,h=c.processedYData,k=b.length-1,l=d.length;c=h.length;var n,m,q,t,p;u(l-c)&&(f[0]!==g[0]&&h.unshift(0),f[l-1]!==g[c-1]&&h.push(0));e.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=
0;b.positiveVolumeData=0;for(p=b.negativeVolumeData=0;p<l;p++)q=m=!1,t=a?d[p][3]:d[p],n=p?a?d[p-1][3]:d[p-1]:t,t<=b.start&&0===b.index&&(m=!0),t>=b.end&&b.index===k&&(q=!0),(t>b.start||m)&&(t<b.end||q)&&(b.wholeVolumeData+=h[p],n>t?b.negativeVolumeData+=h[p]:b.positiveVolumeData+=h[p]);e.volumeDataArray.push(b.wholeVolumeData)});return b};h.prototype.drawZones=function(a,b,c,f){var d=a.renderer,e=this.zoneLinesSVG,g=[],h=a.plotWidth,k=a.plotTop,l;c.forEach(function(c){l=b.toPixels(c)-k;g=g.concat(a.renderer.crispLine([["M",
0,l],["L",h,l]],f.lineWidth))});e?e.animate({d:g}):e=this.zoneLinesSVG=d.path(g).attr({"stroke-width":f.lineWidth,stroke:f.color,dashstyle:f.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};h.defaultOptions=t(r.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},
animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return h}(r);f(k.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:e,drawGraph:e,getColumnMetrics:v.getColumnMetrics,crispCol:v.crispCol});h.registerSeriesType("vbp",
k);"";return k});v(e,"Stock/Indicators/VWAP/VWAPIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,c)};return function(e,c){function a(){this.constructor=e}d(e,c);e.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,
m=d.error,p=d.isArray,r=d.merge;d=function(d){function e(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.points=void 0;c.options=void 0;return c}h(e,d);e.prototype.getValues=function(c,a){var b=c.chart,f=c.xData;c=c.yData;var d=a.period,e=!0,g;if(g=b.get(a.volumeSeriesID))return p(c[0])||(e=!1),this.calculateVWAPValues(e,f,c,g,d);m("Series "+a.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b)};e.prototype.calculateVWAPValues=function(c,a,b,f,d){var e=f.yData,g=f.xData.length,
h=a.length;f=[];var k=[],l=[],n=[],m=[],q;g=h<=g?h:g;for(q=h=0;h<g;h++){var p=c?(b[h][1]+b[h][2]+b[h][3])/3:b[h];p*=e[h];p=q?f[h-1]+p:p;var r=q?k[h-1]+e[h]:e[h];f.push(p);k.push(r);m.push([a[h],p/r]);l.push(m[h][0]);n.push(m[h][1]);q++;q===d&&(q=0)}return{values:m,xData:l,yData:n}};e.defaultOptions=r(k.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}});return e}(k);e.registerSeriesType("vwap",d);"";return d});v(e,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[e["Mixins/ReduceArray.js"],
e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var d=function(c,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(c,a)};return function(c,a){function b(){this.constructor=c}d(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=e.getArrayExtremes,p=d.seriesTypes.sma;e=h.extend;var r=h.isArray,
l=h.merge;h=function(d){function c(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,d);c.prototype.getValues=function(a,b){b=b.period;var c=a.xData,d=(a=a.yData)?a.length:0,e=[],g=[],h=[],k;if(!(c.length<b)&&r(a[0])&&4===a[0].length){for(k=b-1;k<d;k++){var l=a.slice(k-b+1,k+1);var n=m(l,2,1);l=n[0];n=n[1];var p=a[k][3];l=(n-p)/(n-l)*-100;c[k]&&(e.push([c[k],l]),g.push(c[k]),h.push(l))}return{values:e,xData:g,yData:h}}};c.defaultOptions=l(p.defaultOptions,
{params:{index:void 0,period:14}});return c}(p);e(h.prototype,{nameBase:"Williams %R"});d.registerSeriesType("williamsr",h);"";return h});v(e,"Stock/Indicators/WMA/WMAIndicator.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){function h(d,c){c*=(c+1)/2;return d.reduce(function(a,b,c){return[null,a[1]+b[1]*(c+1)]})[1]/c}function k(d,c,a,b){a=h(d,d.length);c=c[b-1];d.shift();return[c,a]}var m=this&&this.__extends||function(){var d=function(c,a){d=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(c,a)};return function(c,a){function b(){this.constructor=c}d(c,a);c.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),p=e.seriesTypes.sma,r=d.isArray,l=d.merge;d=function(d){function c(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(c,d);c.prototype.getValues=function(a,b){var c=b.period,
d=a.xData,e=(a=a.yData)?a.length:0,g=1,h=d[0],l=a[0],m=[],n=[],p=[],q=-1;if(!(d.length<c)){r(a[0])&&(q=b.index,l=a[0][q]);for(b=[[h,l]];g!==c;)b.push([d[g],0>q?a[g]:a[g][q]]),g++;for(c=g;c<e;c++)g=k(b,d,a,c),m.push(g),n.push(g[0]),p.push(g[1]),b.push([d[c],0>q?a[c]:a[c][q]]);g=k(b,d,a,c);m.push(g);n.push(g[0]);p.push(g[1]);return{values:m,xData:n,yData:p}}};c.defaultOptions=l(p.defaultOptions,{params:{index:3,period:9}});return c}(p);e.registerSeriesType("wma",d);"";return d});v(e,"Stock/Indicators/Zigzag/ZigzagIndicator.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.sma,m=d.merge;d=d.extend;var p=function(d){function e(){var e=
null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}h(e,d);e.prototype.getValues=function(d,c){var a=c.lowIndex,b=c.highIndex,f=c.deviation/100;c=1+f;var e=1-f;f=d.xData;var g=d.yData;d=g?g.length:0;var h=[],k=[],l=[],m,n,p=!1,q=!1;if(!(!f||1>=f.length||d&&("undefined"===typeof g[0][a]||"undefined"===typeof g[0][b]))){var r=g[0][a];var v=g[0][b];for(m=1;m<d;m++){if(g[m][a]<=v*e){h.push([f[0],v]);var y=[f[m],g[m][a]];p=n=!0}else g[m][b]>=r*c&&(h.push([f[0],
r]),y=[f[m],g[m][b]],n=!1,p=!0);if(p){k.push(h[0][0]);l.push(h[0][1]);var z=m++;m=d}}for(m=z;m<d;m++)n?(g[m][a]<=y[1]&&(y=[f[m],g[m][a]]),g[m][b]>=y[1]*c&&(q=b)):(g[m][b]>=y[1]&&(y=[f[m],g[m][b]]),g[m][a]<=y[1]*e&&(q=a)),!1!==q&&(h.push(y),k.push(y[0]),l.push(y[1]),y=[f[m],g[m][q]],n=!n,q=!1);a=h.length;0!==a&&h[a-1][0]<f[d-1]&&(h.push(y),k.push(y[0]),l.push(y[1]));return{values:h,xData:k,yData:l}}};e.defaultOptions=m(k.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}});
return e}(k);d(p.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"});e.registerSeriesType("zigzag",p);"";return p});v(e,"Stock/Indicators/LinearRegression/LinearRegression.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,c)};
return function(e,c){function a(){this.constructor=e}d(e,c);e.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.isArray,p=d.extend,r=d.merge;d=function(d){function e(){var c=null!==d&&d.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(e,d);e.prototype.getRegressionLineParameters=function(c,a){var b=this.options.params.index,f=function(a,b){return m(a)?a[b]:a},d=c.reduce(function(a,b){return b+a},0),e=a.reduce(function(a,
c){return f(c,b)+a},0);d/=c.length;e/=a.length;var g=0,h=0,k;for(k=0;k<c.length;k++){var l=c[k]-d;var n=f(a[k],b)-e;g+=l*n;h+=Math.pow(l,2)}c=h?g/h:0;return{slope:c,intercept:e-c*d}};e.prototype.getEndPointY=function(c,a){return c.slope*a+c.intercept};e.prototype.transformXData=function(c,a){var b=c[0];return c.map(function(c){return(c-b)/a})};e.prototype.findClosestDistance=function(c){var a,b;for(b=1;b<c.length-1;b++){var f=c[b]-c[b-1];0<f&&("undefined"===typeof a||f<a)&&(a=f)}return a};e.prototype.getValues=
function(c,a){var b=c.xData;c=c.yData;a=a.period;var f,d={xData:[],yData:[],values:[]},e=this.options.params.xAxisUnit||this.findClosestDistance(b);for(f=a-1;f<=b.length-1;f++){var g=f-a+1;var h=f+1;var k=b[f];var l=b.slice(g,h);g=c.slice(g,h);h=this.transformXData(l,e);l=this.getRegressionLineParameters(h,g);g=this.getEndPointY(l,h[h.length-1]);d.values.push({regressionLineParameters:l,x:k,y:g});d.xData.push(k);d.yData.push(g)}return d};e.defaultOptions=r(k.defaultOptions,{params:{xAxisUnit:null},
tooltip:{valueDecimals:4}});return e}(k);p(d.prototype,{nameBase:"Linear Regression Indicator"});e.registerSeriesType("linearRegression",d);"";return d});v(e,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopes.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=
a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.linearRegression,m=d.extend,p=d.merge;d=function(d){function e(){var e=null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;return e}h(e,d);e.prototype.getEndPointY=function(d){return d.slope};e.defaultOptions=p(k.defaultOptions);return e}(k);m(d.prototype,{nameBase:"Linear Regression Slope Indicator"});
e.registerSeriesType("linearRegressionSlope",d);"";return d});v(e,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionIntercept.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,g){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return d(e,g)};return function(e,g){function c(){this.constructor=e}d(e,g);e.prototype=
null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.linearRegression,m=d.extend,p=d.merge;d=function(d){function e(){var e=null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;return e}h(e,d);e.prototype.getEndPointY=function(e){return e.intercept};e.defaultOptions=p(k.defaultOptions);return e}(k);m(d.prototype,{nameBase:"Linear Regression Intercept Indicator"});e.registerSeriesType("linearRegressionIntercept",d);"";return d});v(e,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngle.js",
[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var e=function(d,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return e(d,g)};return function(d,g){function c(){this.constructor=d}e(d,g);d.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),k=e.seriesTypes.linearRegression,m=d.extend,p=d.merge;d=function(e){function d(){var d=
null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}h(d,e);d.prototype.slopeToAngle=function(d){return 180/Math.PI*Math.atan(d)};d.prototype.getEndPointY=function(d){return this.slopeToAngle(d.slope)};d.defaultOptions=p(k.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});return d}(k);m(d.prototype,{nameBase:"Linear Regression Angle Indicator"});e.registerSeriesType("linearRegressionAngle",
d);"";return d});v(e,"Stock/Indicators/ABands/ABandsIndicator.js",[e["Mixins/MultipleLines.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var d=function(c,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(c,a)};return function(c,a){function b(){this.constructor=c}d(c,a);c.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),m=d.seriesTypes.sma,p=h.correctFloat,r=h.extend,l=h.merge;h=function(d){function c(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,d);c.prototype.getValues=function(a,b){var c=b.period,e=b.factor;b=b.index;var g=a.xData,h=(a=a.yData)?a.length:0,k=[],l=[],m=[],n=[],r=[],q;if(!(h<c)){for(q=0;q<=h;q++){if(q<h){var v=a[q][2];var y=a[q][1];var G=e;v=p(y-v)/(p(y+v)/2)*1E3*G;k.push(a[q][1]*p(1+2*v));l.push(a[q][2]*p(1-2*v))}if(q>=
c){v=g.slice(q-c,q);var z=a.slice(q-c,q);G=d.prototype.getValues.call(this,{xData:v,yData:k.slice(q-c,q)},{period:c});y=d.prototype.getValues.call(this,{xData:v,yData:l.slice(q-c,q)},{period:c});z=d.prototype.getValues.call(this,{xData:v,yData:z},{period:c,index:b});v=z.xData[0];G=G.yData[0];y=y.yData[0];z=z.yData[0];m.push([v,G,z,y]);n.push(v);r.push([G,z,y])}}return{values:m,xData:n,yData:r}}};c.defaultOptions=l(m.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},
bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return c}(m);r(h.prototype,{drawGraph:e.drawGraph,getTranslatedLinesNames:e.getTranslatedLinesNames,linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle",toYData:e.toYData,translate:e.translate});d.registerSeriesType("abands",h);"";return h});v(e,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[e["Core/Series/SeriesRegistry.js"],
e["Core/Utilities.js"]],function(e,d){var h=this&&this.__extends||function(){var d=function(e,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,c)};return function(e,c){function a(){this.constructor=e}d(e,c);e.prototype=null===c?Object.create(c):(a.prototype=c.prototype,new a)}}(),k=e.seriesTypes.sma,m=d.extend,p=d.merge,r=d.isArray;d=function(d){function e(){var c=null!==d&&d.apply(this,
arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(e,d);e.prototype.getValues=function(c,a){var b=c.xData,d=c.yData;c=[];var e=[],g=[],h=0,k=0,l=0,m=0,n=b.length,p=a.index;for(a=0;a<n;a++){var q=b[a];var v=r(d[a])?d[a][p]:d[a];h+=q;k+=v;l+=q*v;m+=q*q}d=(n*l-h*k)/(n*m-h*h);isNaN(d)&&(d=0);h=(k-d*h)/n;for(a=0;a<n;a++)q=b[a],v=d*q+h,c[a]=[q,v],e[a]=q,g[a]=v;return{xData:e,yData:g,values:c}};e.defaultOptions=p(k.defaultOptions,{params:{period:void 0,index:3}});return e}(k);m(d.prototype,
{nameBase:"Trendline",nameComponents:!1});e.registerSeriesType("trendline",d);"";return d});v(e,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",[e["Mixins/IndicatorRequired.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(e,d,h){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,
c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),m=d.seriesTypes.sma,p=h.correctFloat,r=h.defined,l=h.extend,g=h.isArray,c=h.merge;h=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.averageIndicator=void 0;b.data=void 0;b.options=void 0;b.points=void 0;return b}k(b,a);b.prototype.init=function(){var a=arguments,b=this,c=a[1].params;c=c&&c.average?c.average:void 0;b.averageIndicator=d.seriesTypes[c]||m;e.isParentLoaded(b.averageIndicator,
c,b.type,function(c){c.prototype.init.apply(b,a)})};b.prototype.calculateDisparityIndex=function(a,b){return p(a-b)/b*100};b.prototype.getValues=function(a,b){var c=b.index,d=a.xData,e=a.yData,f=e?e.length:0,h=[],k=[],l=[],m=this.averageIndicator,p=g(e[0]);b=m.prototype.getValues(a,b);a=b.yData;b=d.indexOf(b.xData[0]);if(a&&0!==a.length&&r(c)&&!(e.length<=b)){for(m=b;m<f;m++){var v=this.calculateDisparityIndex(p?e[m][c]:e[m],a[m-b]);h.push([d[m],v]);k.push(d[m]);l.push(v)}return{values:h,xData:k,
yData:l}}};b.defaultOptions=c(m.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return b}(m);l(h.prototype,{nameBase:"Disparity Index",nameComponents:["period","average"]});d.registerSeriesType("disparityindex",h);"";return h});v(e,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map