"use strict";!function(e){"object"==typeof module&&module.exports?module.exports=e.default=e:"function"==typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){t=t?t._modules:{};function e(t,e,i,n){t.hasOwnProperty(e)||(t[e]=n.apply(null,i))}e(t,"Accessibility/Utils/HTMLUtilities.js",[t["Core/Globals.js"],t["Core/Utilities.js"]],function(t,e){var i=t.doc,n=t.win,o=e.merge;return{addClass:function(t,e){t.classList?t.classList.add(e):t.className.indexOf(e)<0&&(t.className+=e)},escapeStringForHTML:function(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},getElement:function(t){return i.getElementById(t)},getFakeMouseEvent:function(t){if("function"==typeof n.MouseEvent)return new n.MouseEvent(t);if(i.createEvent){var e=i.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(t,!0,!0,n,"click"===t?1:0,0,0,0,0,!1,!1,!1,!1,0,null),e}return{type:t}},getHeadingTagNameForElement:function(t){function i(t){return t=parseInt(t.slice(1),10),"h"+Math.min(6,t+1)}function n(t){return/H[1-6]/.test(t)}var o=function(t){var e=function(t){for(var e=t;e=e.previousSibling;){var i=e.tagName||"";if(n(i))return i}return""}(t);if(e)return i(e);e=t.parentElement;if(!e)return"p";t=e.tagName;return n(t)?i(t):o(e)};return o(t)},removeElement:function(t){t&&t.parentNode&&t.parentNode.removeChild(t)},reverseChildNodes:function(t){for(var e=t.childNodes.length;e--;)t.appendChild(t.childNodes[e])},setElAttrs:function(i,n){Object.keys(n).forEach(function(t){var e=n[t];null===e?i.removeAttribute(t):i.setAttribute(t,e)})},stripHTMLTagsFromString:function(t){return"string"==typeof t?t.replace(/<\/?[^>]+(>|$)/g,""):t},visuallyHideElement:function(t){o(!0,t.style,{position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"})}}}),e(t,"Accessibility/Utils/ChartUtilities.js",[t["Accessibility/Utils/HTMLUtilities.js"],t["Core/Utilities.js"]],function(t,e){var i=t.stripHTMLTagsFromString,r=e.defined,s=e.find,o=e.fireEvent;function n(t){if(t.points&&t.points.length){t=s(t.points,function(t){return!!t.graphic});return t&&t.graphic&&t.graphic.element}}function a(t){var e=n(t);return e&&e.parentNode||t.graph&&t.graph.element||t.group&&t.group.element}return{getChartTitle:function(t){return i(t.options.title.text||t.langFormat("accessibility.defaultChartTitle",{chart:t}))},getAxisDescription:function(t){return t&&(t.userOptions&&t.userOptions.accessibility&&t.userOptions.accessibility.description||t.axisTitle&&t.axisTitle.textStr||t.options.id||t.categories&&"categories"||t.dateTime&&"Time"||"values")},getAxisRangeDescription:function(t){var e,i,n,o=t.options||{};return o.accessibility&&void 0!==o.accessibility.rangeDescription?o.accessibility.rangeDescription:t.categories?function(t){var e=t.chart;if(t.dataMax&&t.dataMin)return e.langFormat("accessibility.axis.rangeCategories",{chart:e,axis:t,numCategories:t.dataMax-t.dataMin+1});return""}(t):!t.dateTime||0!==t.min&&0!==t.dataMin?(i=(e=t).chart,n=i.options&&i.options.accessibility&&i.options.accessibility.screenReaderSection.axisRangeDateFormat||"",i.langFormat("accessibility.axis.rangeFromTo",{chart:i,axis:e,rangeFrom:r("min"),rangeTo:r("max")})):function(t){var e=t.chart,i={},n="Seconds";i.Seconds=((t.max||0)-(t.min||0))/1e3,i.Minutes=i.Seconds/60,i.Hours=i.Minutes/60,i.Days=i.Hours/24,["Minutes","Hours","Days"].forEach(function(t){2<i[t]&&(n=t)});var o=i[n].toFixed("Seconds"!==n&&"Minutes"!==n?1:0);return e.langFormat("accessibility.axis.timeRange"+n,{chart:e,axis:t,range:o.replace(".0","")})}(t);function r(t){return e.dateTime?i.time.dateFormat(n,e[t]):e[t]}},getPointFromXY:function(t,e,i){for(var n,o=t.length;o--;)if(n=s(t[o].points||[],function(t){return t.x===e&&t.y===i}))return n},getSeriesFirstPointElement:n,getSeriesFromName:function(t,e){return e?(t.series||[]).filter(function(t){return t.name===e}):t.series},getSeriesA11yElement:a,unhideChartElementFromAT:function t(e,i){i.setAttribute("aria-hidden",!1),i!==e.renderTo&&i.parentNode&&(Array.prototype.forEach.call(i.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),t(e,i.parentNode))},hideSeriesFromAT:function(t){(t=a(t))&&t.setAttribute("aria-hidden",!0)},scrollToPoint:function(t){var e=t.series.xAxis,i=t.series.yAxis,n=e&&e.scrollbar?e:i;(e=n&&n.scrollbar)&&r(e.to)&&r(e.from)&&(i=e.to-e.from,t=function(t,e){if(!r(t.dataMin)||!r(t.dataMax))return 0;var i=t.toPixels(t.dataMin),n=t.toPixels(t.dataMax),o="xAxis"===t.coll?"x":"y";return(t.toPixels(e[o]||0)-i)/(n-i)}(n,t),e.updatePosition(t-i/2,t+i/2),o(e,"changed",{from:e.from,to:e.to,trigger:"scrollbar",DOMEvent:null}))}}}),e(t,"Accessibility/KeyboardNavigationHandler.js",[t["Core/Utilities.js"]],function(t){var o=t.find;function e(t,e){this.chart=t,this.keyCodeMap=e.keyCodeMap||[],this.validate=e.validate,this.init=e.init,this.terminate=e.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}return e.prototype={run:function(t){var e=t.which||t.keyCode,i=this.response.noHandler,n=o(this.keyCodeMap,function(t){return-1<t[0].indexOf(e)});return n?i=n[1].call(this,e,t):9===e&&(i=this.response[t.shiftKey?"prev":"next"]),i}},e}),e(t,"Accessibility/Utils/DOMElementProvider.js",[t["Core/Globals.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Core/Utilities.js"]],function(t,e,i){var n=t.doc,o=e.removeElement,e=function(){this.elements=[]};return(0,i.extend)(e.prototype,{createElement:function(){var t=n.createElement.apply(n,arguments);return this.elements.push(t),t},destroyCreatedElements:function(){this.elements.forEach(function(t){o(t)}),this.elements=[]}}),e}),e(t,"Accessibility/Utils/EventProvider.js",[t["Core/Globals.js"],t["Core/Utilities.js"]],function(e,t){function i(){this.eventRemovers=[]}var n=t.addEvent;return(0,t.extend)(i.prototype,{addEvent:function(){var t=n.apply(e,arguments);return this.eventRemovers.push(t),t},removeAddedEvents:function(){this.eventRemovers.forEach(function(t){t()}),this.eventRemovers=[]}}),i}),e(t,"Accessibility/AccessibilityComponent.js",[t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Utils/DOMElementProvider.js"],t["Accessibility/Utils/EventProvider.js"],t["Core/Globals.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Core/Utilities.js"]],function(t,e,i,n,o,r){var c=t.unhideChartElementFromAT,s=n.doc,a=n.win,l=o.removeElement,u=o.getFakeMouseEvent,o=r.extend,h=r.fireEvent,d=r.merge;function p(){}return o(p.prototype={initBase:function(t){this.chart=t,this.eventProvider=new i,this.domElementProvider=new e,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(t,e){var i=e.type;s.createEvent&&(t.dispatchEvent||t.fireEvent)?t.dispatchEvent?t.dispatchEvent(e):t.fireEvent(i,e):h(t,i,e)},fakeClickEvent:function(t){var e;t&&(e=u("click"),this.fireEventOnWrappedOrUnwrappedElement(t,e))},addProxyGroup:function(e){this.createOrUpdateProxyContainer();var i=this.createElement("div");return Object.keys(e||{}).forEach(function(t){null!==e[t]&&i.setAttribute(t,e[t])}),this.chart.a11yProxyContainer.appendChild(i),i},createOrUpdateProxyContainer:function(){var t=this.chart,e=t.renderer.box;t.a11yProxyContainer=t.a11yProxyContainer||this.createProxyContainerElement(),e.nextSibling!==t.a11yProxyContainer&&t.container.insertBefore(t.a11yProxyContainer,e.nextSibling)},createProxyContainerElement:function(){var t=s.createElement("div");return t.className="highcharts-a11y-proxy-container",t},createProxyButton:function(t,e,i,n,o){var r=t.element,s=this.createElement("button"),a=d({"aria-label":r.getAttribute("aria-label")},i);return Object.keys(a).forEach(function(t){null!==a[t]&&s.setAttribute(t,a[t])}),s.className="highcharts-a11y-proxy-button",t.hasClass("highcharts-no-tooltip")&&(s.className+=" highcharts-no-tooltip"),o&&this.addEvent(s,"click",o),this.setProxyButtonStyle(s),this.updateProxyButtonPosition(s,n||t),this.proxyMouseEventsForButton(r,s),e.appendChild(s),a["aria-hidden"]||c(this.chart,s),s},getElementPosition:function(t){var e=t.element,t=this.chart.renderTo;if(t&&e&&e.getBoundingClientRect){e=e.getBoundingClientRect(),t=t.getBoundingClientRect();return{x:e.left-t.left,y:e.top-t.top,width:e.right-e.left,height:e.bottom-e.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(t){d(!0,t.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),t.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(t,e){e=this.getElementPosition(e);d(!0,t.style,{width:(e.width||1)+"px",height:(e.height||1)+"px",left:(Math.round(e.x)||0)+"px",top:(Math.round(e.y)||0)+"px"})},proxyMouseEventsForButton:function(o,t){var r=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(i){var n=0===i.indexOf("touch");r.addEvent(t,i,function(t){var e=n?r.cloneTouchEvent(t):r.cloneMouseEvent(t);o&&r.fireEventOnWrappedOrUnwrappedElement(o,e),t.stopPropagation(),"touchstart"!==i&&"touchmove"!==i&&"touchend"!==i&&t.preventDefault()},{passive:!1})})},cloneMouseEvent:function(t){if("function"==typeof a.MouseEvent)return new a.MouseEvent(t.type,t);if(s.createEvent){var e=s.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(t.type,t.bubbles,t.cancelable,t.view||a,t.detail,t.screenX,t.screenY,t.clientX,t.clientY,t.ctrlKey,t.altKey,t.shiftKey,t.metaKey,t.button,t.relatedTarget),e}return u(t.type)},cloneTouchEvent:function(t){function e(t){for(var e=[],i=0;i<t.length;++i){var n=t.item(i);n&&e.push(n)}return e}if("function"==typeof a.TouchEvent){var i=new a.TouchEvent(t.type,{touches:e(t.touches),targetTouches:e(t.targetTouches),changedTouches:e(t.changedTouches),ctrlKey:t.ctrlKey,shiftKey:t.shiftKey,altKey:t.altKey,metaKey:t.metaKey,bubbles:t.bubbles,cancelable:t.cancelable,composed:t.composed,detail:t.detail,view:t.view});return t.defaultPrevented&&i.preventDefault(),i}i=this.cloneMouseEvent(t);return i.touches=t.touches,i.changedTouches=t.changedTouches,i.targetTouches=t.targetTouches,i},destroyBase:function(){l(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}},{init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}}),p}),e(t,"Accessibility/KeyboardNavigation.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/Utilities.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Accessibility/Utils/EventProvider.js"]],function(t,e,i,n,o){var r=e.doc,s=e.win,a=i.addEvent,c=i.fireEvent,l=n.getElement;function u(t,e){this.init(t,e)}return a(r,"keydown",function(t){27===(t.which||t.keyCode)&&e.charts&&e.charts.forEach(function(t){t&&t.dismissPopupContent&&t.dismissPopupContent()})}),t.prototype.dismissPopupContent=function(){var t=this;c(this,"dismissPopupContent",{},function(){t.tooltip&&t.tooltip.hide(0),t.hideExportMenu()})},u.prototype={init:function(e,t){var i=this,n=this.eventProvider=new o;this.chart=e,this.components=t,this.modules=[],this.currentModuleIx=0,this.update(),n.addEvent(this.tabindexContainer,"keydown",function(t){return i.onKeydown(t)}),n.addEvent(this.tabindexContainer,"focus",function(t){return i.onFocus(t)}),["mouseup","touchend"].forEach(function(t){return n.addEvent(r,t,function(){return i.onMouseUp()})}),["mousedown","touchstart"].forEach(function(t){return n.addEvent(e.renderTo,t,function(){i.isClickingChart=!0})}),n.addEvent(e.renderTo,"mouseover",function(){i.pointerIsOverChart=!0}),n.addEvent(e.renderTo,"mouseout",function(){i.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(t){var e=this.chart.options.accessibility,e=e&&e.keyboardNavigation,i=this.components;this.updateContainerTabindex(),e&&e.enabled&&t&&t.length?(this.modules=t.reduce(function(t,e){e=i[e].getKeyboardNavigation();return t.concat(e)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(t){var e=this.chart,t=t.relatedTarget&&e.container.contains(t.relatedTarget);this.exiting||this.tabbingInBackwards||this.isClickingChart||t||!this.modules[0]||this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){var t,e;delete this.isClickingChart,this.keyboardReset||this.pointerIsOverChart||(t=this.chart,(e=this.modules&&this.modules[this.currentModuleIx||0])&&e.terminate&&e.terminate(),t.focusElement&&t.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0)},onKeydown:function(t){var e,i=t||s.event,n=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];this.keyboardReset=!1,this.exiting=!1,n&&((t=n.run(i))===n.response.success?e=!0:t===n.response.prev?e=this.prev():t===n.response.next&&(e=this.next()),e&&(i.preventDefault(),i.stopPropagation()))},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(t){var e=this.modules&&this.modules[this.currentModuleIx];e&&e.terminate&&e.terminate(t),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=t;e=this.modules&&this.modules[this.currentModuleIx];if(e){if(e.validate&&!e.validate())return this.move(t);if(e.init)return e.init(t),!0}return this.currentModuleIx=0,this.exiting=!0,(0<t?this.exitAnchor:this.tabindexContainer).focus(),!1},updateExitAnchor:function(){var t="highcharts-end-of-chart-marker-"+this.chart.index,t=l(t);this.removeExitAnchor(),t?(this.makeElementAnExitAnchor(t),this.exitAnchor=t):this.createExitAnchor()},updateContainerTabindex:function(){var t=this.chart.options.accessibility,e=t&&t.keyboardNavigation,i=!(e&&!1===e.enabled),n=this.chart,t=n.container,e=n.renderTo.hasAttribute("tabindex")?(t.removeAttribute("tabindex"),n.renderTo):t,t=(this.tabindexContainer=e).getAttribute("tabindex");i&&!t?e.setAttribute("tabindex","0"):i||n.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(t){var e=this.tabindexContainer.getAttribute("tabindex")||0;t.setAttribute("class","highcharts-exit-anchor"),t.setAttribute("tabindex",e),t.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(t)},createExitAnchor:function(){var t=this.chart,e=this.exitAnchor=r.createElement("div");t.renderTo.appendChild(e),this.makeElementAnExitAnchor(e)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(t){var e=this.chart,i=this;this.eventProvider.addEvent(t,"focus",function(t){t=t||s.event;!(t.relatedTarget&&e.container.contains(t.relatedTarget)||i.exiting)?(i.tabbingInBackwards=!0,i.tabindexContainer.focus(),delete i.tabbingInBackwards,t.preventDefault(),i.modules&&i.modules.length&&(i.currentModuleIx=i.modules.length-1,(t=i.modules[i.currentModuleIx])&&t.validate&&!t.validate()?i.prev():t&&t.init(-1))):i.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}},u}),e(t,"Accessibility/Components/LegendComponent.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/Legend.js"],t["Core/Utilities.js"],t["Accessibility/AccessibilityComponent.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Accessibility/Utils/HTMLUtilities.js"]],function(t,n,i,e,o,r,s){var a=e.addEvent,c=e.extend,l=e.find,u=e.fireEvent,h=e.isNumber,d=s.removeElement,p=s.stripHTMLTagsFromString;function m(t){var e=t.legend&&t.legend.allItems,i=t.options.legend.accessibility||{};return e&&e.length&&(!t.colorAxis||!t.colorAxis.length)&&!1!==i.enabled}t.prototype.highlightLegendItem=function(t){var e,i,n=this.legend.allItems,o=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return!!n[t]&&(h(o)&&n[o]&&u(n[o].legendGroup.element,"mouseout"),e=this.legend,i=t,o=e.allItems[i].pageIx,i=e.currentPage,void 0!==o&&o+1!==i&&e.scroll(1+o-i),this.setFocusToElement(n[t].legendItem,n[t].a11yProxyElement),u(n[t].legendGroup.element,"mouseover"),!0)},a(i,"afterColorizeItem",function(t){var e=this.chart.options.accessibility,i=t.item;e.enabled&&i&&i.a11yProxyElement&&i.a11yProxyElement.setAttribute("aria-pressed",t.visible?"true":"false")});a=function(){};return c(a.prototype=new o,{init:function(){var e=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(i,"afterScroll",function(){this.chart===e.chart&&(e.updateProxiesPositions(),e.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(e.highlightedLegendItemIx))}),this.addEvent(i,"afterPositionItem",function(t){this.chart===e.chart&&this.chart.renderer&&e.updateProxyPositionForItem(t.item)})},updateLegendItemProxyVisibility:function(){var i=this.chart.legend,t=i.allItems||[],n=i.currentPage||1,o=i.clipHeight||0;t.forEach(function(t){var e=t.pageIx||0,e=(t._legendItemPos?t._legendItemPos[1]:0)+(t.legendItem?Math.round(t.legendItem.getBBox().height):0)-i.pages[e]>o||e!==n-1;t.a11yProxyElement&&(t.a11yProxyElement.style.visibility=e?"hidden":"visible")})},onChartRender:function(){m(this.chart)?this.updateProxiesPositions():this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var t=0,e=this.proxyElementsList;t<e.length;t++){var i=e[t],n=i.element,i=i.posElement;this.updateProxyButtonPosition(n,i)}},updateProxyPositionForItem:function(e){var t=l(this.proxyElementsList,function(t){return t.item===e});t&&this.updateProxyButtonPosition(t.element,t.posElement)},recreateProxies:function(){this.removeProxies(),m(this.chart)&&(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility())},removeProxies:function(){d(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var t=this.chart,e=p((t.legend&&t.legend.options.title&&t.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),e=t.langFormat("accessibility.legend.legendLabel"+(e?"":"NoTitle"),{chart:t,legendTitle:e});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",e)},addLegendProxyGroup:function(){var t="all"===this.chart.options.accessibility.landmarkVerbosity?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:t})},addLegendListContainer:function(){var t;this.legendProxyGroup&&((t=this.legendListContainer=this.createElement("ul")).style.listStyle="none",this.legendProxyGroup.appendChild(t))},proxyLegendItems:function(){var e=this;(this.chart.legend&&this.chart.legend.allItems||[]).forEach(function(t){t.legendItem&&t.legendItem.element&&e.proxyLegendItem(t)})},proxyLegendItem:function(t){var e,i,n;t.legendItem&&t.legendGroup&&this.legendListContainer&&(n=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:p(t.name),item:t}),e={tabindex:-1,"aria-pressed":t.visible,"aria-label":n},i=t.legendGroup.div?t.legendItem:t.legendGroup,n=this.createElement("li"),this.legendListContainer.appendChild(n),t.a11yProxyElement=this.createProxyButton(t.legendItem,n,e,i),this.proxyElementsList.push({item:t,element:t.a11yProxyElement,posElement:i}))},getKeyboardNavigation:function(){var e=this.keyCodes,i=this,t=this.chart;return new r(t,{keyCodeMap:[[[e.left,e.right,e.up,e.down],function(t){return i.onKbdArrowKey(this,t)}],[[e.enter,e.space],function(t){return n.isFirefox&&t===e.space?this.response.success:i.onKbdClick(this)}]],validate:function(){return i.shouldHaveLegendNavigation()},init:function(t){return i.onKbdNavigationInit(t)},terminate:function(){t.legend.allItems.forEach(function(t){return t.setState("",!0)})}})},onKbdArrowKey:function(t,e){var i=this.keyCodes,n=t.response,o=this.chart,r=o.options.accessibility,s=o.legend.allItems.length,i=e===i.left||e===i.up?-1:1;return o.highlightLegendItem(this.highlightedLegendItemIx+i)?(this.highlightedLegendItemIx+=i,n.success):1<s&&r.keyboardNavigation.wrapAround?(t.init(i),n.success):n[0<i?"next":"prev"]},onKbdClick:function(t){var e=this.chart.legend.allItems[this.highlightedLegendItemIx];return e&&e.a11yProxyElement&&u(e.a11yProxyElement,"click"),t.response.success},shouldHaveLegendNavigation:function(){var t=this.chart,e=t.options.legend||{},i=t.legend&&t.legend.allItems,n=t.colorAxis&&t.colorAxis.length,e=e.accessibility||{};return!!(i&&t.legend.display&&!n&&e.enabled&&e.keyboardNavigation&&e.keyboardNavigation.enabled)},onKbdNavigationInit:function(t){var e=this.chart,i=e.legend.allItems.length-1,i=0<t?0:i;e.highlightLegendItem(i),this.highlightedLegendItemIx=i}}),a}),e(t,"Accessibility/Components/MenuComponent.js",[t["Core/Chart/Chart.js"],t["Core/Utilities.js"],t["Accessibility/AccessibilityComponent.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Utils/HTMLUtilities.js"]],function(t,e,i,o,n,r){var e=e.extend,s=n.unhideChartElementFromAT,a=r.removeElement,c=r.getFakeMouseEvent;function l(t){return t.exportSVGElements&&t.exportSVGElements[0]}t.prototype.showExportMenu=function(){var t=l(this);!t||(t=t.element).onclick&&t.onclick(c("click"))},t.prototype.hideExportMenu=function(){var t=this,e=t.exportDivElements;e&&t.exportContextMenu&&(e.forEach(function(t){"highcharts-menu-item"===t.className&&t.onmouseout&&t.onmouseout(c("mouseout"))}),t.highlightedExportItemIx=0,t.exportContextMenu.hideMenu(),t.container.focus())},t.prototype.highlightExportItem=function(t){var e,i=this.exportDivElements&&this.exportDivElements[t],n=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];return!(!i||"LI"!==i.tagName||i.children&&i.children.length)&&(e=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,i.focus&&e&&i.focus(),n&&n.onmouseout&&n.onmouseout(c("mouseout")),i.onmouseover&&i.onmouseover(c("mouseover")),this.highlightedExportItemIx=t,!0)},t.prototype.highlightLastExportItem=function(){var t;if(this.exportDivElements)for(t=this.exportDivElements.length;t--;)if(this.highlightExportItem(t))return!0;return!1};t=function(){};return e(t.prototype=new i,{init:function(){var t=this.chart,e=this;this.addEvent(t,"exportMenuShown",function(){e.onMenuShown()}),this.addEvent(t,"exportMenuHidden",function(){e.onMenuHidden()})},onMenuHidden:function(){var t=this.chart.exportContextMenu;t&&t.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var t=this.chart,e=t.exportContextMenu;e&&(this.addAccessibleContextMenuAttribs(),s(t,e)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(t){var e=this.exportButtonProxy;e&&e.setAttribute("aria-expanded",t)},onChartRender:function(){var t,e,i=this.chart,n=i.options.accessibility;a(this.exportProxyGroup),e=(t=i).options.exporting,t=l(t),e&&!1!==e.enabled&&e.accessibility&&e.accessibility.enabled&&t&&t.element&&(this.exportProxyGroup=this.addProxyGroup("all"===n.landmarkVerbosity?{"aria-label":i.langFormat("accessibility.exporting.exportRegionLabel",{chart:i}),role:"region"}:{}),n=l(this.chart),this.exportButtonProxy=this.createProxyButton(n,this.exportProxyGroup,{"aria-label":i.langFormat("accessibility.exporting.menuButtonLabel",{chart:i}),"aria-expanded":!1}))},addAccessibleContextMenuAttribs:function(){var t=this.chart,e=t.exportDivElements;e&&e.length&&(e.forEach(function(t){"LI"!==t.tagName||t.children&&t.children.length?t.setAttribute("aria-hidden","true"):t.setAttribute("tabindex",-1)}),(e=e[0].parentNode).removeAttribute("aria-hidden"),e.setAttribute("aria-label",t.langFormat("accessibility.exporting.chartMenuLabel",{chart:t})))},getKeyboardNavigation:function(){var t=this.keyCodes,i=this.chart,n=this;return new o(i,{keyCodeMap:[[[t.left,t.up],function(){return n.onKbdPrevious(this)}],[[t.right,t.down],function(){return n.onKbdNext(this)}],[[t.enter,t.space],function(){return n.onKbdClick(this)}]],validate:function(){return i.exportChart&&!1!==i.options.exporting.enabled&&!1!==i.options.exporting.accessibility.enabled},init:function(){var t=n.exportButtonProxy,e=i.exportingGroup;e&&t&&i.setFocusToElement(e,t)},terminate:function(){i.hideExportMenu()}})},onKbdPrevious:function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=e.highlightedExportItemIx||0;o--;)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightLastExportItem(),n.success):n.prev},onKbdNext:function(t){for(var e=this.chart,i=e.options.accessibility,n=t.response,o=(e.highlightedExportItemIx||0)+1;o<e.exportDivElements.length;++o)if(e.highlightExportItem(o))return n.success;return i.keyboardNavigation.wrapAround?(e.highlightExportItem(0),n.success):n.next},onKbdClick:function(t){var e=this.chart,i=e.exportDivElements[e.highlightedExportItemIx],n=l(e).element;return this.isExportMenuShown?this.fakeClickEvent(i):(this.fakeClickEvent(n),e.highlightExportItem(0)),t.response.success}}),t}),e(t,"Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js",[t["Core/Chart/Chart.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Globals.js"],t["Core/Utilities.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Accessibility/Utils/EventProvider.js"],t["Accessibility/Utils/ChartUtilities.js"]],function(t,n,o,e,i,r,s,a,c){var l=e.seriesTypes,u=i.doc,h=r.defined,i=r.extend,d=r.fireEvent,p=c.getPointFromXY,m=c.getSeriesFromName,g=c.scrollToPoint;function f(t){var e=t.index,i=t.series.points,n=i.length;if(i[e]===t)return e;for(;n--;)if(i[n]===t)return n}function b(t){var e=t.chart.options.accessibility.keyboardNavigation.seriesNavigation,i=t.options.accessibility||{},n=i.keyboardNavigation;return n&&!1===n.enabled||!1===i.enabled||!1===t.options.enableMouseTracking||!t.visible||e.pointNavigationEnabledThreshold&&e.pointNavigationEnabledThreshold<=t.points.length}function y(t){var e=t.series.chart.options.accessibility,i=t.options.accessibility&&!1===t.options.accessibility.enabled;return t.isNull&&e.keyboardNavigation.seriesNavigation.skipNullPoints||!1===t.visible||!1===t.isInside||i||b(t.series)}function x(t,e,i,n){function o(t){return!(h(t.plotX)&&h(t.plotY))}var r,s,a=1/0,c=e.points.length;if(!o(t)){for(;c--;)o(s=e.points[c])||(s=(t.plotX-s.plotX)*(t.plotX-s.plotX)*(i||1)+(t.plotY-s.plotY)*(t.plotY-s.plotY)*(n||1))<a&&(a=s,r=c);return h(r)?e.points[r]:void 0}}function v(t){return delete t.highlightedPoint,t.series.reduce(function(t,e){return t||e.highlightFirstValidPoint()},!1)}function A(t,e){this.keyCodes=e,this.chart=t}return o.prototype.keyboardMoveVertical=!0,["column","pie"].forEach(function(t){l[t]&&(l[t].prototype.keyboardMoveVertical=!1)}),n.prototype.highlight=function(){var t=this.series.chart;return this.isNull?t.tooltip&&t.tooltip.hide(0):this.onMouseOver(),g(this),this.graphic&&t.setFocusToElement(this.graphic),t.highlightedPoint=this},t.prototype.highlightAdjacentPoint=function(t){var e,i,n=this,o=n.series,r=n.highlightedPoint,s=r&&f(r)||0,a=r&&r.series.points,c=n.series&&n.series[n.series.length-1],c=c&&c.points&&c.points[c.points.length-1];if(!o[0]||!o[0].points)return!1;if(r){if(e=o[r.series.index+(t?1:-1)],!(i=!(i=a[s+(t?1:-1)])&&e?e.points[t?0:e.points.length-1]:i))return!1}else i=t?o[0].points[0]:c;return y(i)?(b(e=i.series)?n.highlightedPoint=t?e.points[e.points.length-1]:e.points[0]:n.highlightedPoint=i,n.highlightAdjacentPoint(t)):i.highlight()},o.prototype.highlightFirstValidPoint=function(){var t=this.chart.highlightedPoint,t=(t&&t.series)===this?f(t):0,e=this.points,i=e.length;if(e&&i){for(var n=t;n<i;++n)if(!y(e[n]))return e[n].highlight();for(var o=t;0<=o;--o)if(!y(e[o]))return e[o].highlight()}return!1},t.prototype.highlightAdjacentSeries=function(t){var e,i,n,o=this,r=o.highlightedPoint,s=o.series&&o.series[o.series.length-1],a=s&&s.points&&s.points[s.points.length-1];return o.highlightedPoint?!!(e=o.series[r.series.index+(t?-1:1)])&&(!!(i=x(r,e,4))&&(b(e)?(i.highlight(),(n=o.highlightAdjacentSeries(t))?n:(r.highlight(),!1)):(i.highlight(),i.series.highlightFirstValidPoint()))):(e=t?o.series&&o.series[0]:s,!!(i=t?e&&e.points&&e.points[0]:a)&&i.highlight())},t.prototype.highlightAdjacentPointVertical=function(o){var r,s=this.highlightedPoint,a=1/0;return!(!h(s.plotX)||!h(s.plotY))&&(this.series.forEach(function(n){b(n)||n.points.forEach(function(t){var e,i;h(t.plotY)&&h(t.plotX)&&t!==s&&(e=t.plotY-s.plotY,i=Math.abs(t.plotX-s.plotX),i=Math.abs(e)*Math.abs(e)+i*i*4,n.yAxis&&n.yAxis.reversed&&(e*=-1),e<=0&&o||0<=e&&!o||i<5||y(t)||i<a&&(a=i,r=t))})}),!!r&&r.highlight())},i(A.prototype,{init:function(){var i=this,e=this.chart,t=this.eventProvider=new a;t.addEvent(o,"destroy",function(){return i.onSeriesDestroy(this)}),t.addEvent(e,"afterDrilldown",function(){var t;v(t=this),t.focusElement&&t.focusElement.removeFocusBorder()}),t.addEvent(e,"drilldown",function(t){var e=t.point,t=e.series;i.lastDrilledDownPoint={x:e.x,y:e.y,seriesName:t?t.name:""}}),t.addEvent(e,"drillupall",function(){setTimeout(function(){i.onDrillupAll()},10)}),t.addEvent(n,"afterSetState",function(){var t=this.graphic&&this.graphic.element;e.highlightedPoint===this&&u.activeElement!==t&&t&&t.focus&&t.focus()})},onDrillupAll:function(){var t,e=this.lastDrilledDownPoint,i=this.chart,n=e&&m(i,e.seriesName);e&&n&&h(e.x)&&h(e.y)&&(t=p(n,e.x,e.y)),i.container&&i.container.focus(),t&&t.highlight&&t.highlight(),i.focusElement&&i.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var e=this,t=this.keyCodes,n=this.chart,i=n.inverted;return new s(n,{keyCodeMap:[[i?[t.up,t.down]:[t.left,t.right],function(t){return e.onKbdSideways(this,t)}],[i?[t.left,t.right]:[t.up,t.down],function(t){return e.onKbdVertical(this,t)}],[[t.enter,t.space],function(t,e){var i=n.highlightedPoint;return i&&(e.point=i,d(i.series,"click",e),i.firePointEvent("click")),this.response.success}]],init:function(t){return e.onHandlerInit(this,t)},terminate:function(){return e.onHandlerTerminate()}})},onKbdSideways:function(t,e){var i=this.keyCodes,i=e===i.right||e===i.down;return this.attemptHighlightAdjacentPoint(t,i)},onKbdVertical:function(t,e){var i=this.chart,n=this.keyCodes,e=e===n.down||e===n.right,n=i.options.accessibility.keyboardNavigation.seriesNavigation;return n.mode&&"serialize"===n.mode?this.attemptHighlightAdjacentPoint(t,e):(i[i.highlightedPoint&&i.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](e),t.response.success)},onHandlerInit:function(t,e){var i=this.chart;return(0<e?v:function(t){for(var e=t.series.length,i=!1;e--&&(t.highlightedPoint=t.series[e].points[t.series[e].points.length-1],!(i=t.series[e].highlightFirstValidPoint())););})(i),t.response.success},onHandlerTerminate:function(){var t=this.chart;t.tooltip&&t.tooltip.hide(0);var e=t.highlightedPoint&&t.highlightedPoint.series;e&&e.onMouseOut&&e.onMouseOut(),t.highlightedPoint&&t.highlightedPoint.onMouseOut&&t.highlightedPoint.onMouseOut(),delete t.highlightedPoint},attemptHighlightAdjacentPoint:function(t,e){var i=this.chart,n=i.options.accessibility.keyboardNavigation.wrapAround;return i.highlightAdjacentPoint(e)?t.response.success:n?t.init(e?1:-1):t.response[e?"next":"prev"]},onSeriesDestroy:function(t){var e=this.chart;e.highlightedPoint&&e.highlightedPoint.series===t&&(delete e.highlightedPoint,e.focusElement&&e.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}}),A}),e(t,"Accessibility/Components/AnnotationsA11y.js",[t["Accessibility/Utils/HTMLUtilities.js"]],function(t){var e=t.escapeStringForHTML,i=t.stripHTMLTagsFromString;function n(t){return(t.annotations||[]).reduce(function(t,e){return t=e.options&&!1!==e.options.visible?t.concat(e.labels):t},[])}function s(t){return t.options&&t.options.accessibility&&t.options.accessibility.description||t.graphic&&t.graphic.text&&t.graphic.text.textStr||""}function o(t){var e=t.options&&t.options.accessibility&&t.options.accessibility.description;if(e)return e;var i=t.chart,n=s(t),o=t.points,r=o.filter(function(t){return!!t.graphic}).map(function(t){var e,e=t.accessibility&&t.accessibility.valueDescription||((e=t).graphic&&e.graphic.element&&e.graphic.element.getAttribute("aria-label")||""),t=t&&t.series.name||"";return(t?t+", ":"")+"data point "+e}).filter(function(t){return!!t}),e=r.length,o="accessibility.screenReaderSection.annotations.description"+(1<e?"MultiplePoints":e?"SinglePoint":"NoPoints"),r={annotationText:n,annotation:t,numPoints:e,annotationPoint:r[0],additionalAnnotationPoints:r.slice(1)};return i.langFormat(o,r)}function r(t){return n(t).map(function(t){t=e(i(o(t)));return t?"<li>"+t+"</li>":""})}return{getAnnotationsInfoHTML:function(t){var e=t.annotations;return e&&e.length?'<ul style="list-style-type: none">'+r(t).join(" ")+"</ul>":""},getAnnotationLabelDescription:o,getAnnotationListItems:r,getPointAnnotationTexts:function(e){var t=n(e.series.chart).filter(function(t){return-1<t.points.indexOf(e)});return t.length?t.map(function(t){return""+s(t)}):[]}}}),e(t,"Accessibility/Components/SeriesComponent/SeriesDescriber.js",[t["Accessibility/Components/AnnotationsA11y.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Core/FormatUtilities.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Core/Tooltip.js"],t["Core/Utilities.js"]],function(t,e,i,n,o,r){var a=t.getPointAnnotationTexts,s=e.getAxisDescription,c=e.getSeriesFirstPointElement,l=e.getSeriesA11yElement,u=e.unhideChartElementFromAT,h=i.format,d=i.numberFormat,p=n.reverseChildNodes,m=n.stripHTMLTagsFromString,g=r.find,f=r.isNumber,b=r.pick,y=r.defined;function x(t){var e,i,n=t.series,o=(i=(e=t).index,e.series&&e.series.data&&y(i)&&g(e.series.data,function(t){return!!(t&&void 0!==t.index&&t.index>i&&t.graphic&&t.graphic.element)})||null),e=o&&o.graphic,n=e?e.parentGroup:n.graph||n.group,o=o?{x:b(t.plotX,o.plotX,0),y:b(t.plotY,o.plotY,0)}:{x:b(t.plotX,0),y:b(t.plotY,0)},o=(o=o,(o=t.series.chart.renderer.rect(o.x,o.y,1,1)).attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),o);if(n&&n.element)return t.graphic=o,t.hasDummyGraphic=!0,o.add(n),n.element.insertBefore(o.element,e?e.element:null),o.element}function v(t){var e=t.chart.options.accessibility.series.pointDescriptionEnabledThreshold;return!!(!1!==e&&t.points&&t.points.length>=e)}function A(t,e){var i=t.series.chart,n=i.options.accessibility.point||{},t=t.series.tooltipOptions||{},i=i.options.lang;return f(e)?d(e,n.valueDecimals||t.valueDecimals||-1,i.decimalPoint,i.accessibility.thousandsSep||i.thousandsSep):e}function w(t,e){var i=t[e];return t.chart.langFormat("accessibility.series."+e+"Description",{name:s(i),series:t})}function C(t){var e=t.series,i=e.chart,n=i.options.accessibility.point||{};if(e.xAxis&&e.xAxis.dateTime){e=o.prototype.getXDateFormat.call({getDateFormat:o.prototype.getDateFormat,chart:i},t,i.options.tooltip,e.xAxis),e=n.dateFormatter&&n.dateFormatter(t)||n.dateFormat||e;return i.time.dateFormat(e,t.x,void 0)}}function T(t){var e=C(t),i=(t.series.xAxis||{}).categories&&y(t.category)&&(""+t.category).replace("<br/>"," "),n=t.id&&t.id.indexOf("highcharts-")<0,o="x, "+t.x;return t.name||e||i||(n?t.id:o)}function S(i,t,e){var n=t||"",o=e||"";return i.series.pointArrayMap.reduce(function(t,e){return t+(t.length?", ":"")+(e=A(i,b(i[t=e],i.options[t])),t+": "+n+e+o)},"")}function E(t){var e=t.series,i=e.chart.options.accessibility.point||{},n=e.tooltipOptions||{},o=i.valuePrefix||n.valuePrefix||"",i=i.valueSuffix||n.valueSuffix||"",n=A(t,t[void 0!==t.value?"value":"y"]);return t.isNull?e.chart.langFormat("accessibility.series.nullPointValue",{point:t}):e.pointArrayMap?S(t,o,i):o+n+i}function P(t){var e=t.series,i=e.chart,n=i.options.accessibility.point.valueDescriptionFormat,o=b(e.xAxis&&e.xAxis.options.accessibility&&e.xAxis.options.accessibility.enabled,!i.angular),e=o?T(t):"",o={point:t,index:y(t.index)?t.index+1:"",xDescription:e,value:E(t),separator:o?", ":""};return h(n,o,i)}function B(t){var e=t.series,i=e.chart,n=P(t),o=t.options&&t.options.accessibility&&t.options.accessibility.description,r=o?" "+o:"",s=1<i.series.length&&e.name?" "+e.name+".":"",e=(i=(o=t).series.chart,(e=a(o)).length?i.langFormat("accessibility.series.pointAnnotationsDescription",{point:o,annotations:e}):""),e=e?" "+e:"";return t.accessibility=t.accessibility||{},(t.accessibility.valueDescription=n)+r+s+e}function M(t){var e,i,r=(i=t.options.accessibility||{},!v(t)&&!i.exposeAsGroupOnly),i=(i=(e=t).chart.options.accessibility.keyboardNavigation.seriesNavigation,!(!e.points||!(e.points.length<i.pointNavigationEnabledThreshold||!1===i.pointNavigationEnabledThreshold)));(r||i)&&t.points.forEach(function(t){var e,i,n=t.graphic&&t.graphic.element||(e=(i=t).series&&i.series.is("sunburst"),i.isNull&&!e&&x(t)),o=t.options&&t.options.accessibility&&!1===t.options.accessibility.enabled;n&&(n.setAttribute("tabindex","-1"),n.style.outline="0",r&&!o?(i=n,t=(o=(e=t).series).chart.options.accessibility.point||{},o=o.options.accessibility||{},e=m(o.pointDescriptionFormatter&&o.pointDescriptionFormatter(e)||t.descriptionFormatter&&t.descriptionFormatter(e)||B(e)),i.setAttribute("role","img"),i.setAttribute("aria-label",e)):n.setAttribute("aria-hidden",!0))})}function k(e){function t(t){return o[t]&&1<o[t].length&&e[t]}var i,n,o=e.chart,r=o.types||[],s=(n=((i=e).options.accessibility||{}).description)&&i.chart.langFormat("accessibility.series.description",{description:n,series:i})||"",a=w(e,"xAxis"),n=w(e,"yAxis"),i={name:e.name||"",ix:e.index+1,numSeries:o.series&&o.series.length,numPoints:e.points&&e.points.length,series:e},r=1<r.length?"Combination":"";return(o.langFormat("accessibility.series.summary."+e.type+r,i)||o.langFormat("accessibility.series.summary.default"+r,i))+(s?" "+s:"")+(t("yAxis")?" "+n:"")+(t("xAxis")?" "+a:"")}return{describeSeries:function(t){var e,i,n=t.chart,o=c(t),r=l(t),s=n.is3d&&n.is3d();r&&(r.lastChild!==o||s||p(r),M(t),u(n,r),i=(e=t).chart,s=(o=i.options.chart).options3d&&o.options3d.enabled,n=1<i.series.length,o=i.options.accessibility.series.describeSingleSeries,i=(e.options.accessibility||{}).exposeAsGroupOnly,s&&n||!(n||o||i||v(e))?r.setAttribute("aria-label",""):(o=r,e=(i=t).options.accessibility||{},r=i.chart.options.accessibility,t=r.landmarkVerbosity,e.exposeAsGroupOnly?o.setAttribute("role","img"):"all"===t&&o.setAttribute("role","region"),o.setAttribute("tabindex","-1"),o.style.outline="0",o.setAttribute("aria-label",m(r.series.descriptionFormatter&&r.series.descriptionFormatter(i)||k(i)))))},defaultPointDescriptionFormatter:B,defaultSeriesDescriptionFormatter:k,getPointA11yTimeDescription:C,getPointXDescription:T,getPointValue:E,getPointValueDescription:P}}),e(t,"Accessibility/Utils/Announcer.js",[t["Core/Globals.js"],t["Core/Renderer/HTML/AST.js"],t["Accessibility/Utils/DOMElementProvider.js"],t["Accessibility/Utils/HTMLUtilities.js"]],function(t,i,n,e){var o=t.doc,r=e.setElAttrs,s=e.visuallyHideElement,e=(a.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},a.prototype.announce=function(t){var e=this;i.setElementHTML(this.announceRegion,t),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){e.announceRegion.innerHTML="",delete e.clearAnnouncementRegionTimer},1e3)},a.prototype.addAnnounceRegion=function(t){var e=this.chart.announcerContainer||this.createAnnouncerContainer(),i=this.domElementProvider.createElement("div");return r(i,{"aria-hidden":!1,"aria-live":t}),s(i),e.appendChild(i),i},a.prototype.createAnnouncerContainer=function(){var t=this.chart,e=o.createElement("div");return r(e,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),t.renderTo.insertBefore(e,t.renderTo.firstChild),t.announcerContainer=e},a);function a(t,e){this.chart=t,this.domElementProvider=new n,this.announceRegion=this.addAnnounceRegion(e)}return t.Announcer=e}),e(t,"Accessibility/Components/SeriesComponent/NewDataAnnouncer.js",[t["Core/Globals.js"],t["Core/Series/Series.js"],t["Core/Utilities.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],t["Accessibility/Utils/Announcer.js"],t["Accessibility/Utils/EventProvider.js"]],function(s,n,t,e,i,o,r){var a=t.extend,c=t.defined,l=e.getChartTitle,u=i.defaultPointDescriptionFormatter,h=i.defaultSeriesDescriptionFormatter;function d(t){return t.options.accessibility.announceNewData.enabled}i=function(t){this.chart=t};return a(i.prototype,{init:function(){var t=this.chart,e=t.options.accessibility.announceNewData.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new r,this.announcer=new o(t,e),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var e=this,t=this.chart,i=this.eventProvider;i.addEvent(t,"afterDrilldown",function(){e.lastAnnouncementTime=0}),i.addEvent(n,"updatedData",function(){e.onSeriesUpdatedData(this)}),i.addEvent(t,"afterAddSeries",function(t){e.onSeriesAdded(t.series)}),i.addEvent(n,"addPoint",function(t){e.onPointAdded(t.point)}),i.addEvent(t,"redraw",function(){e.announceDirtyData()})},onSeriesUpdatedData:function(t){var e=this.chart;t.chart===e&&d(e)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[t.name+t.index]=t)},onSeriesAdded:function(t){d(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[t.name+t.index]=t,this.dirty.newSeries=c(this.dirty.newSeries)?void 0:t)},onPointAdded:function(t){var e=t.series.chart;this.chart===e&&d(e)&&(this.dirty.newPoint=c(this.dirty.newPoint)?void 0:t)},announceDirtyData:function(){var t,e,i=this.chart,n=this;i.options.accessibility.announceNewData&&this.dirty.hasDirty&&(t=(t=this.dirty.newPoint)&&(1===(i=(e=t).series.data.filter(function(t){return e.x===t.x&&e.y===t.y})).length?i[0]:e),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(t){return n.dirty.allSeries[t]}),this.dirty.newSeries,t),this.dirty={allSeries:{}})},queueAnnouncement:function(t,e,i){var n,o,r,s=this,a=this.chart.options.accessibility.announceNewData;a.enabled&&(o=(n=+new Date)-this.lastAnnouncementTime,a=Math.max(0,a.minAnnounceInterval-o),o=this.queuedAnnouncement&&this.queuedAnnouncement.series,r=(o||[]).concat(t||[]).reduce(function(t,e){return t[e.name+e.index]=e,t},{}),t=Object.keys(r).map(function(t){return r[t]}),(i=this.buildAnnouncementMessage(t,e,i))&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:n,message:i,series:t},this.queuedAnnouncementTimer=setTimeout(function(){s&&s.announcer&&(s.lastAnnouncementTime=+new Date,s.announcer.announce(s.queuedAnnouncement.message),delete s.queuedAnnouncement,delete s.queuedAnnouncementTimer)},a)))},buildAnnouncementMessage:function(t,e,i){var n=this.chart,o=n.options.accessibility.announceNewData;if(o.announcementFormatter){var r=o.announcementFormatter(t,e,i);if(!1!==r)return r.length?r:null}t=s.charts&&1<s.charts.length?"Multiple":"Single",r=e?"newSeriesAnnounce"+t:i?"newPointAnnounce"+t:"newDataAnnounce",t=l(n);return n.langFormat("accessibility.announceNewData."+r,{chartTitle:t,seriesDesc:e?h(e):null,pointDesc:i?u(i):null,point:i,series:e})}}),i}),e(t,"Accessibility/Components/SeriesComponent/ForcedMarkers.js",[t["Core/Series/Series.js"],t["Core/Utilities.js"]],function(t,e){var i=e.addEvent,r=e.merge;function s(t){return t._hasPointMarkers&&t.points&&t.points.length}function a(t){r(!0,t,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function c(t){for(var e,i=t.points.length;i--;){var n=t.points[i],o=n.options;delete n.hasForcedA11yMarker,o.marker&&(o.marker.enabled?(r(!0,(e=o).marker,{states:{normal:{opacity:(e=e).marker.states&&e.marker.states.normal&&e.marker.states.normal.opacity||1}}}),n.hasForcedA11yMarker=!1):(a(o),n.hasForcedA11yMarker=!0))}}return function(){i(t,"render",function(){var t,e,i,n=this,o=n.options;e=(t=n).chart.options.accessibility.enabled,i=!1!==(t.options.accessibility&&t.options.accessibility.enabled),e&&i&&(i=t.chart.options.accessibility,t.points.length<i.series.pointDescriptionEnabledThreshold||!1===i.series.pointDescriptionEnabledThreshold)?(o.marker&&!1===o.marker.enabled&&(n.a11yMarkersForced=!0,a(n.options)),s(n)&&c(n)):n.a11yMarkersForced&&(delete n.a11yMarkersForced,(n=(o=n).resetA11yMarkerOptions)&&r(!0,o.options,{marker:{enabled:n.enabled,states:{normal:{opacity:n.states&&n.states.normal&&n.states.normal.opacity}}}}))}),i(t,"afterSetOptions",function(t){this.resetA11yMarkerOptions=r(t.options.marker||{},this.userOptions.marker||{})}),i(t,"afterRender",function(){var t=this;t.chart.styledMode&&(t.markerGroup&&t.markerGroup[t.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),s(t)&&t.points.forEach(function(t){t.graphic&&(t.graphic[t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),t.graphic[!1===t.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}}),e(t,"Accessibility/Components/SeriesComponent/SeriesComponent.js",[t["Core/Globals.js"],t["Core/Utilities.js"],t["Accessibility/AccessibilityComponent.js"],t["Accessibility/Components/SeriesComponent/SeriesKeyboardNavigation.js"],t["Accessibility/Components/SeriesComponent/NewDataAnnouncer.js"],t["Accessibility/Components/SeriesComponent/ForcedMarkers.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Components/SeriesComponent/SeriesDescriber.js"],t["Core/Tooltip.js"]],function(t,e,i,n,o,r,s,a,c){var e=e.extend,l=s.hideSeriesFromAT,u=a.describeSeries;t.SeriesAccessibilityDescriber=a,r();r=function(){};return e(r.prototype=new i,{init:function(){this.newDataAnnouncer=new o(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new n(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var t=this;this.addEvent(c,"refresh",function(){this.chart===t.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(t){t.labelBySeries&&t.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){this.chart.series.forEach(function(t){(!1!==(t.options.accessibility&&t.options.accessibility.enabled)&&t.visible?u:l)(t)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}}),r}),e(t,"Accessibility/Components/ZoomComponent.js",[t["Accessibility/AccessibilityComponent.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Core/Globals.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Core/Utilities.js"]],function(t,e,i,n,s,o){var r=e.unhideChartElementFromAT,e=i.noop,a=n.removeElement,c=n.setElAttrs,n=o.extend,l=o.pick;i.Axis.prototype.panStep=function(t,e){var i=e||3,n=this.getExtremes(),o=(n.max-n.min)/i*t,e=n.max+o,i=n.min+o,o=e-i;t<0&&i<n.dataMin?e=(i=n.dataMin)+o:0<t&&e>n.dataMax&&(i=(e=n.dataMax)-o),this.setExtremes(i,e)};return e.prototype=new t,n(e.prototype,{init:function(){var e=this,i=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(t){e.addEvent(i,t,function(){e.updateProxyOverlays()})})},onChartUpdate:function(){var i=this.chart,n=this;i.mapNavButtons&&i.mapNavButtons.forEach(function(t,e){r(i,t.element),n.setMapNavButtonAttrs(t.element,"accessibility.zoom.mapZoom"+(e?"Out":"In"))})},setMapNavButtonAttrs:function(t,e){var i=this.chart,i=i.langFormat(e,{chart:i});c(t,{tabindex:-1,role:"button","aria-label":i})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var t=this.chart;a(this.drillUpProxyGroup),a(this.resetZoomProxyGroup),t.resetZoomButton&&this.recreateProxyButtonAndGroup(t.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",t.langFormat("accessibility.zoom.resetZoomButton",{chart:t})),t.drillUpButton&&this.recreateProxyButtonAndGroup(t.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",t.langFormat("accessibility.drillUpButton",{chart:t,buttonText:t.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(t,e,i,n){a(this[i]),this[i]=this.addProxyGroup(),this[e]=this.createProxyButton(t,this[i],{"aria-label":n,tabindex:-1})},getMapZoomNavigation:function(){var t=this.keyCodes,e=this.chart,i=this;return new s(e,{keyCodeMap:[[[t.up,t.down,t.left,t.right],function(t){return i.onMapKbdArrow(this,t)}],[[t.tab],function(t,e){return i.onMapKbdTab(this,e)}],[[t.space,t.enter],function(){return i.onMapKbdClick(this)}]],validate:function(){return!!((t=e).mapZoom&&t.mapNavButtons&&t.mapNavButtons.length);var t},init:function(t){return i.onMapNavInit(t)}})},onMapKbdArrow:function(t,e){var i=this.keyCodes,n=e===i.up||e===i.down?"yAxis":"xAxis",i=e===i.left||e===i.up?-1:1;return this.chart[n][0].panStep(i),t.response.success},onMapKbdTab:function(t,e){var i=this.chart,n=t.response,t=e.shiftKey,e=t&&!this.focusedMapNavButtonIx||!t&&this.focusedMapNavButtonIx;return i.mapNavButtons[this.focusedMapNavButtonIx].setState(0),e?(i.mapZoom(),n[t?"prev":"next"]):(this.focusedMapNavButtonIx+=t?-1:1,t=i.mapNavButtons[this.focusedMapNavButtonIx],i.setFocusToElement(t.box,t.element),t.setState(2),n.success)},onMapKbdClick:function(t){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),t.response.success},onMapNavInit:function(t){var e=this.chart,i=e.mapNavButtons[0],n=e.mapNavButtons[1],n=0<t?i:n;e.setFocusToElement(n.box,n.element),n.setState(2),this.focusedMapNavButtonIx=0<t?0:1},simpleButtonNavigation:function(t,e,i){var n=this.keyCodes,o=this,r=this.chart;return new s(r,{keyCodeMap:[[[n.tab,n.up,n.down,n.left,n.right],function(t,e){t=t===n.tab&&e.shiftKey||t===n.left||t===n.up;return this.response[t?"prev":"next"]}],[[n.space,n.enter],function(){var t=i(this,r);return l(t,this.response.success)}]],validate:function(){return r[t]&&r[t].box&&o[e]},init:function(){r.setFocusToElement(r[t].box,o[e])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(t,e){e.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(t,e){return e.drillUp(),t.response.prev}),this.getMapZoomNavigation()]}}),e}),e(t,"Extensions/RangeSelector.js",[t["Core/Axis/Axis.js"],t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/DefaultOptions.js"],t["Core/Color/Palette.js"],t["Core/Renderer/SVG/SVGElement.js"],t["Core/Utilities.js"]],function(b,t,p,e,m,n,i){var g=e.defaultOptions,y=i.addEvent,f=i.createElement,x=i.css,v=i.defined,o=i.destroyObjectProperties,r=i.discardElement,A=i.extend,s=i.find,w=i.fireEvent,S=i.isNumber,C=i.merge,a=i.objectEach,c=i.pad,T=i.pick,l=i.pInt,E=i.splat;A(g,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:m.highlightColor80,cursor:"pointer"},labelStyle:{color:m.neutralColor60}}}),A(g.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var u,h,d=(P.prototype.clickButton=function(t,e){var i,n,o,r,s,a=this,c=a.chart,l=a.buttonOptions[t],u=c.xAxis[0],h=c.scroller&&c.scroller.getUnionExtremes()||u||{},d=h.dataMin,p=h.dataMax,m=u&&Math.round(Math.min(u.max,T(p,u.max))),g=l.type,f=l._range,h=l.dataGrouping;if(null!==d&&null!==p){if(c.fixedRange=f,a.setSelected(t),h&&(this.forcedDataGrouping=!0,b.prototype.setDataGrouping.call(u||{chart:this.chart},h,!1),this.frozenStates=l.preserveDataGrouping),"month"===g||"year"===g)u?(h={range:l,max:m,chart:c,dataMin:d,dataMax:p},i=u.minFromRange.call(h),S(h.newMax)&&(m=h.newMax)):f=l;else if(f)i=Math.max(m-f,d),m=Math.min(i+f,p);else if("ytd"===g){if(!u)return void(a.deferredYTDClick=t);void 0===p&&(d=Number.MAX_VALUE,p=Number.MIN_VALUE,c.series.forEach(function(t){t=t.xData;d=Math.min(t[0],d),p=Math.max(t[t.length-1],p)}),e=!1),i=o=(a=a.getYTDExtremes(p,d,c.time.useUTC)).min,m=a.max}else"all"===g&&u&&(c.navigator&&c.navigator.baseSeries[0]&&(c.navigator.baseSeries[0].xAxis.options.range=void 0),i=d,m=p);v(i)&&(i+=l._offsetMin),v(m)&&(m+=l._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=t+1),u?u.setExtremes(i,m,T(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:l}):(n=E(c.options.xAxis)[0],s=n.range,n.range=f,r=n.min,n.min=o,y(c,"load",function(){n.range=s,n.min=r})),w(this,"afterBtnClick")}},P.prototype.setSelected=function(t){this.selected=this.options.selected=t},P.prototype.init=function(e){function t(){var t=i.minInput,e=i.maxInput;t&&t.blur&&w(t,"blur"),e&&e.blur&&w(e,"blur")}var i=this,n=e.options.rangeSelector,o=n.buttons||i.defaultButtons.slice(),r=n.selected;i.chart=e,i.options=n,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(y(e.container,"mousedown",t)),this.eventsToUnbind.push(y(e,"resize",t)),o.forEach(i.computeButtonRange),void 0!==r&&o[r]&&this.clickButton(r,!1),this.eventsToUnbind.push(y(e,"load",function(){e.xAxis&&e.xAxis[0]&&y(e.xAxis[0],"setExtremes",function(t){this.max-this.min!==e.fixedRange&&"rangeSelectorButton"!==t.trigger&&"updatedData"!==t.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})}))},P.prototype.updateButtonStates=function(){var d=this,t=this.chart,p=this.dropdown,m=t.xAxis[0],g=Math.round(m.max-m.min),f=!m.hasVisibleSeries,e=t.scroller&&t.scroller.getUnionExtremes()||m,b=e.dataMin,y=e.dataMax,t=d.getYTDExtremes(y,b,t.time.useUTC),x=t.min,v=t.max,A=d.selected,w=S(A),C=d.options.allButtonsEnabled,T=d.buttons;d.buttonOptions.forEach(function(t,e){var i=t._range,n=t.type,o=t.count||1,r=T[e],s=0,a=t._offsetMax-t._offsetMin,c=e===A,l=i<m.minRange,u=!1,h=!1,t=i===g;("month"===n||"year"===n)&&864e5*{month:28,year:365}[n]*o-a<=g+36e5&&g-36e5<=864e5*{month:31,year:366}[n]*o+a?t=!0:"ytd"===n?(t=v-x+a===g,u=!c):"all"===n&&(t=m.max-m.min>=y-b,h=!c&&w&&t),c=c&&t||t&&!w&&!u||c&&d.frozenStates,(h=!C&&(y-b<i||l||h||f))?s=3:c&&(w=!0,s=2),r.state!==s&&(r.setState(s),p&&(p.options[e+1].disabled=h,2===s&&(p.selectedIndex=e+1)),0===s&&A===e&&d.setSelected())})},P.prototype.computeButtonRange=function(t){var e=t.type,i=t.count||1,n={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};n[e]?t._range=n[e]*i:"month"!==e&&"year"!==e||(t._range=24*{month:30,year:365}[e]*36e5*i),t._offsetMin=T(t.offsetMin,0),t._offsetMax=T(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},P.prototype.getInputValue=function(t){var e="min"===t?this.minInput:this.maxInput,i=this.chart.options.rangeSelector,t=this.chart.time;return e?("text"===e.type&&i.inputDateParser||this.defaultInputDateParser)(e.value,t.useUTC,t):0},P.prototype.setInputValue=function(t,e){var i,n=this.options,o=this.chart.time,r="min"===t?this.minInput:this.maxInput,s="min"===t?this.minDateBox:this.maxDateBox;r&&(i=r.getAttribute("data-hc-time"),t=v(i)?Number(i):void 0,v(e)&&(v(i=t)&&r.setAttribute("data-hc-time-previous",i),r.setAttribute("data-hc-time",e),t=e),r.value=o.dateFormat(this.inputTypeFormats[r.type]||n.inputEditDateFormat,t),s&&s.attr({text:o.dateFormat(n.inputDateFormat,t)}))},P.prototype.setInputExtremes=function(t,e,i){var n,o="min"===t?this.minInput:this.maxInput;o&&(n=this.inputTypeFormats[o.type],t=this.chart.time,n&&(e=t.dateFormat(n,e),o.min!==e&&(o.min=e),i=t.dateFormat(n,i),o.max!==i&&(o.max=i)))},P.prototype.showInput=function(t){var e,i,n,o="min"===t?this.minDateBox:this.maxDateBox,r="min"===t?this.minInput:this.maxInput;r&&o&&this.inputGroup&&(e="text"===r.type,i=(n=this.inputGroup).translateX,t=n.translateY,n=this.options.inputBoxWidth,x(r,{width:e?o.width+(n?-2:20)+"px":"auto",height:e?o.height-2+"px":"auto",border:"2px solid silver"}),x(r,e&&n?{left:i+o.x+"px",top:t+"px"}:{left:Math.min(Math.round(o.x+i-(r.offsetWidth-o.width)/2),this.chart.chartWidth-r.offsetWidth)+"px",top:t-(r.offsetHeight-o.height)/2+"px"}))},P.prototype.hideInput=function(t){t="min"===t?this.minInput:this.maxInput;t&&x(t,{top:"-9999em",border:0,width:"1px",height:"1px"})},P.prototype.defaultInputDateParser=function(t,e,i){var n,o=t.split("/").join("-").split(" ").join("T");-1===o.indexOf("T")&&(o+="T00:00"),e?o+="Z":!p.isSafari||6<(n=o).length&&(n.lastIndexOf("-")===n.length-6||n.lastIndexOf("+")===n.length-6)||(o+=(r=new Date(o).getTimezoneOffset()/60)<=0?"+"+c(-r)+":00":"-"+c(r)+":00");var r=Date.parse(o);return S(r)||(t=t.split("-"),r=Date.UTC(l(t[0]),l(t[1])-1,l(t[2]))),i&&e&&S(r)&&(r+=i.getTimezoneOffset(r)),r},P.prototype.drawInput=function(s){var a=this.chart,t=this.div,e=this.inputGroup,c=this,i=a.renderer.style||{},n=a.renderer,o=a.options.rangeSelector,r=g.lang,l="min"===s;function u(){var t=c.getInputValue(s),e=a.xAxis[0],i=a.scroller&&a.scroller.xAxis?a.scroller.xAxis:e,n=i.dataMin,o=i.dataMax,r=c.maxInput,i=c.minInput;t!==Number(h.getAttribute("data-hc-time-previous"))&&S(t)&&(h.setAttribute("data-hc-time-previous",t),l&&r&&S(n)?t>Number(r.getAttribute("data-hc-time"))?t=void 0:t<n&&(t=n):i&&S(o)&&(t<Number(i.getAttribute("data-hc-time"))?t=void 0:o<t&&(t=o)),void 0!==t&&e.setExtremes(l?t:e.min,l?e.max:t,void 0,void 0,{trigger:"rangeSelectorInput"}))}r=r[l?"rangeSelectorFrom":"rangeSelectorTo"],r=n.label(r,0).addClass("highcharts-range-label").attr({padding:r?2:0,height:r?o.inputBoxHeight:0}).add(e),n=n.label("",0).addClass("highcharts-range-input").attr({padding:2,width:o.inputBoxWidth,height:o.inputBoxHeight,"text-align":"center"}).on("click",function(){c.showInput(s),c[s+"Input"].focus()});a.styledMode||n.attr({stroke:o.inputBoxBorderColor,"stroke-width":1}),n.add(e);var h=f("input",{name:s,className:"highcharts-range-selector"},void 0,t);h.setAttribute("type",function(e){if(-1!==e.indexOf("%L"))return"text";var t=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(t){return-1!==e.indexOf("%"+t)}),i=["H","k","I","l","M","S"].some(function(t){return-1!==e.indexOf("%"+t)});if(t&&i)return"datetime-local";if(t)return"date";if(i)return"time";return"text"}(o.inputDateFormat||"%b %e, %Y")),a.styledMode||(r.css(C(i,o.labelStyle)),n.css(C({color:m.neutralColor80},i,o.inputStyle)),x(h,A({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:i.fontSize,fontFamily:i.fontFamily,top:"-9999em"},o.inputStyle))),h.onfocus=function(){c.showInput(s)};var d=!(h.onblur=function(){h===p.doc.activeElement&&u(),c.hideInput(s),c.setInputValue(s),h.blur()});return h.onchange=function(){d||(u(),c.hideInput(s),h.blur())},h.onkeypress=function(t){13===t.keyCode&&u()},h.onkeydown=function(t){d=!0,38!==t.keyCode&&40!==t.keyCode||u()},h.onkeyup=function(){d=!1},{dateBox:n,input:h,label:r}},P.prototype.getPosition=function(){var t=this.chart,e=t.options.rangeSelector,t="top"===e.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:t+e.buttonPosition.y,inputTop:t+e.inputPosition.y-10}},P.prototype.getYTDExtremes=function(t,e,i){var n=this.chart.time,o=new n.Date(t),r=n.get("FullYear",o),r=i?n.Date.UTC(r,0,1):+new n.Date(r,0,1),r=Math.max(e,r),o=o.getTime();return{max:Math.min(t||o,o),min:r}},P.prototype.render=function(t,e){var i,n=this.chart,o=n.renderer,r=n.container,s=n.options,a=s.rangeSelector,c=T(s.chart.style&&s.chart.style.zIndex,0)+1,l=a.inputEnabled,s=this.rendered;!1!==a.enabled&&(s||(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=f("div",void 0,{position:"relative",height:0,zIndex:c}),this.buttonOptions.length&&this.renderButtons(),r.parentNode&&r.parentNode.insertBefore(this.div,r),l&&(this.inputGroup=o.g("input-group").add(this.group),o=this.drawInput("min"),this.minDateBox=o.dateBox,this.minLabel=o.label,this.minInput=o.input,o=this.drawInput("max"),this.maxDateBox=o.dateBox,this.maxLabel=o.label,this.maxInput=o.input)),l&&(this.setInputValue("min",t),this.setInputValue("max",e),e=n.scroller&&n.scroller.getUnionExtremes()||n.xAxis[0]||{},v(e.dataMin)&&v(e.dataMax)&&(n=n.xAxis[0].minRange||0,this.setInputExtremes("min",e.dataMin,Math.min(e.dataMax,this.getInputValue("max"))-n),this.setInputExtremes("max",Math.max(e.dataMin,this.getInputValue("min"))+n,e.dataMax)),this.inputGroup&&(i=0,[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){var e;!t||(e=t.getBBox().width)&&(t.attr({x:i}),i+=e+a.inputSpacing)}))),this.alignElements(),this.rendered=!0)},P.prototype.renderButtons=function(){var r=this,s=this.buttons,t=this.chart,e=this.options,i=g.lang,a=t.renderer,c=C(e.buttonTheme),l=c&&c.states,u=c.width||28;delete c.width,delete c.states,this.buttonGroup=a.g("range-selector-buttons").add(this.group);var h=this.dropdown=f("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);y(h,"touchstart",function(){h.style.fontSize="16px"}),[[p.isMS?"mouseover":"mouseenter"],[p.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(t){var e=t[0],i=t[1];y(h,e,function(){var t=s[r.currentButtonIndex()];t&&w(t.element,i||e)})}),this.zoomText=a.label(i&&i.rangeSelectorZoom||"",0).attr({padding:e.buttonTheme.padding,height:e.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(e.labelStyle),c["stroke-width"]=T(c["stroke-width"],0)),f("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,h),this.buttonOptions.forEach(function(n,o){f("option",{textContent:n.title||n.text},void 0,h),s[o]=a.button(n.text,0,0,function(t){var e,i=n.events&&n.events.click;!1!==(e=i?i.call(n,t):e)&&r.clickButton(o),r.isActive=!0},c,l&&l.hover,l&&l.select,l&&l.disabled).attr({"text-align":"center",width:u}).add(r.buttonGroup),n.title&&s[o].attr("title",n.title)})},P.prototype.alignElements=function(){function t(t,e){return d&&n.titleCollision(s)&&"top"===g&&"right"===e.align&&e.y-t.getBBox().height-12<(d.y||0)+(d.height||0)+s.spacing[0]?-40:0}var i,n=this,e=this,o=e.buttonGroup,r=e.buttons,s=e.chart,a=e.group,c=e.inputGroup,l=e.options,u=e.zoomText,h=s.options,d=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,p=l.buttonPosition,m=l.inputPosition,g=l.verticalAlign,e=s.plotLeft;a&&p&&m&&(h=p.x-s.spacing[3],o&&(this.positionButtons(),this.initialButtonGroupWidth||(i=0,u&&(i+=u.getBBox().width+5),r.forEach(function(t,e){i+=t.width,e!==r.length-1&&(i+=l.buttonSpacing)}),this.initialButtonGroupWidth=i),e-=s.spacing[3],this.updateButtonStates(),u=t(o,p),this.alignButtonGroup(u),a.placed=o.placed=s.hasLoaded),o=0,c&&(o=t(c,m),"left"===m.align?h=e:"right"===m.align&&(h=-Math.max(s.axisOffset[1],-o)),c.align({y:m.y,width:c.getBBox().width,align:m.align,x:m.x+h-2},!0,s.spacingBox),c.placed=s.hasLoaded),this.handleCollision(o),a.align({verticalAlign:g},!0,s.spacingBox),e=a.alignAttr.translateY,h=a.getBBox().height+20,c=0,"bottom"===g&&(c=e-(h=h+((o=s.legend&&s.legend.options)&&"bottom"===o.verticalAlign&&o.enabled&&!o.floating?s.legend.legendHeight+T(o.margin,10):0)-20)-(l.floating?0:l.y)-(s.titleOffset?s.titleOffset[2]:0)-10),"top"===g?(l.floating&&(c=0),s.titleOffset&&s.titleOffset[0]&&(c=s.titleOffset[0]),c+=s.margin[0]-s.spacing[0]||0):"middle"===g&&(m.y===p.y?c=e:(m.y||p.y)&&(m.y<0||p.y<0?c-=Math.min(m.y,p.y):c=e-h)),a.translate(l.x,l.y+Math.floor(c)),e=this.minInput,h=this.maxInput,c=this.dropdown,l.inputEnabled&&e&&h&&(e.style.marginTop=a.translateY+"px",h.style.marginTop=a.translateY+"px"),c&&(c.style.marginTop=a.translateY+"px"))},P.prototype.alignButtonGroup=function(t,e){var i=this.chart,n=this.options,o=this.buttonGroup,r=(this.buttons,n.buttonPosition),s=i.plotLeft-i.spacing[3],n=r.x-i.spacing[3];"right"===r.align?n+=t-s:"center"===r.align&&(n-=s/2),o&&o.align({y:r.y,width:T(e,this.initialButtonGroupWidth),align:r.align,x:n},!0,i.spacingBox)},P.prototype.positionButtons=function(){var i=this.buttons,t=this.chart,n=this.options,e=this.zoomText,o=t.hasLoaded?"animate":"attr",r=n.buttonPosition,s=t.plotLeft,a=s;e&&"hidden"!==e.visibility&&(e[o]({x:T(s+r.x,s)}),a+=r.x+e.getBBox().width+5),this.buttonOptions.forEach(function(t,e){"hidden"!==i[e].visibility?(i[e][o]({x:a}),a+=i[e].width+n.buttonSpacing):i[e][o]({x:s})})},P.prototype.handleCollision=function(o){function t(){var e=0;return i.buttons.forEach(function(t){t=t.getBBox();t.width>e&&(e=t.width)}),e}function e(t){if(s&&r){var e=s.alignAttr.translateX+s.alignOptions.x-o+s.getBBox().x+2,i=s.alignOptions.width,n=r.alignAttr.translateX+r.getBBox().x;return e<n+t&&n<e+i&&c.y<u.y+s.getBBox().height}}var i=this,n=this.chart,r=this.buttonGroup,s=this.inputGroup,a=this.options,c=a.buttonPosition,l=a.dropdown,u=a.inputPosition,a=function(){s&&r&&s.attr({translateX:s.alignAttr.translateX+(n.axisOffset[1]>=-o?0:-o),translateY:s.alignAttr.translateY+r.getBBox().height+10})};if(r){if("always"===l)return this.collapseButtons(o),void(e(t())&&a());"never"===l&&this.expandButtons()}s&&r?u.align===c.align||e(this.initialButtonGroupWidth+20)?"responsive"===l?(this.collapseButtons(o),e(t())&&a()):a():"responsive"===l&&this.expandButtons():r&&"responsive"===l&&(this.initialButtonGroupWidth>n.plotWidth?this.collapseButtons(o):this.expandButtons())},P.prototype.collapseButtons=function(t){function i(t){return{text:t?t+" ▾":"▾",width:"auto",paddingLeft:T(a.buttonTheme.paddingLeft,c.padding,8),paddingRight:T(a.buttonTheme.paddingRight,c.padding,8)}}var e=this,n=e.buttons,o=e.buttonOptions,r=e.chart,s=e.dropdown,a=e.options,e=e.zoomText,c=r.userOptions.rangeSelector&&r.userOptions.rangeSelector.buttonTheme||{};e&&e.hide();var l=!1;o.forEach(function(t,e){e=n[e];2!==e.state?e.hide():(e.show(),e.attr(i(t.text)),l=!0)}),l||(s&&(s.selectedIndex=0),n[0].show(),n[0].attr(i(this.zoomText&&this.zoomText.textStr)));s=a.buttonPosition.align;this.positionButtons(),"right"!==s&&"center"!==s||this.alignButtonGroup(t,n[this.currentButtonIndex()].getBBox().width),this.showDropdown()},P.prototype.expandButtons=function(){var i=this.buttons,t=this.buttonOptions,n=this.options,e=this.zoomText;this.hideDropdown(),e&&e.show(),t.forEach(function(t,e){e=i[e];e.show(),e.attr({text:t.text,width:n.buttonTheme.width||28,paddingLeft:T(n.buttonTheme.paddingLeft,"unset"),paddingRight:T(n.buttonTheme.paddingRight,"unset")}),e.state<2&&e.setState(0)}),this.positionButtons()},P.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&0<t.selectedIndex?t.selectedIndex-1:0},P.prototype.showDropdown=function(){var t,e=this.buttonGroup,i=this.buttons,n=this.chart,o=this.dropdown;e&&o&&(t=e.translateX,e=e.translateY,i=i[this.currentButtonIndex()].getBBox(),x(o,{left:n.plotLeft+t+"px",top:e+.5+"px",width:i.width+"px",height:i.height+"px"}),this.hasVisibleDropdown=!0)},P.prototype.hideDropdown=function(){var t=this.dropdown;t&&(x(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},P.prototype.getHeight=function(){var t=this.options,e=this.group,i=t.inputPosition,n=t.buttonPosition,o=t.y,r=n.y,n=i.y,i=0;return t.height||(this.alignElements(),i=e?e.getBBox(!0).height+13+o:0,o=Math.min(n,r),(n<0&&r<0||0<n&&0<r)&&(i+=Math.abs(o)),i)},P.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},P.prototype.update=function(t){var e=this.chart;C(!0,e.options.rangeSelector,t),this.destroy(),this.init(e),this.render()},P.prototype.destroy=function(){var i=this,t=i.minInput,e=i.maxInput;i.eventsToUnbind&&(i.eventsToUnbind.forEach(function(t){return t()}),i.eventsToUnbind=void 0),o(i.buttons),t&&(t.onfocus=t.onblur=t.onchange=null),e&&(e.onfocus=e.onblur=e.onchange=null),a(i,function(t,e){t&&"chart"!==e&&(t instanceof n?t.destroy():t instanceof window.HTMLElement&&r(t)),t!==P.prototype[e]&&(i[e]=null)},this)},P);function P(t){this.buttons=void 0,this.buttonOptions=P.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=t,this.init(t)}return d.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],d.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"},b.prototype.minFromRange=function(){function t(t,e){var i="year"===r?"FullYear":"Month",n=new a.Date(t),o=a.get(i,n);return a.set(i,n,o+e),o===a.get(i,n)&&a.set("Date",n,0),n.getTime()-t}var e,i,n,o=this.range,r=o.type,s=this.max,a=this.chart.time;return S(o)?(e=s-o,n=o):(e=s+t(s,-o.count),this.chart&&(this.chart.fixedRange=s-e)),i=T(this.dataMin,Number.MIN_VALUE),(e=!S(e)?i:e)<=i&&(e=i,void 0===n&&(n=t(e,o.count)),this.newMax=Math.min(e+n,this.dataMax)),e=!S(s)?void 0:e},p.RangeSelector||(u=[],h=function(e){var t,i,n,o=e.rangeSelector;function r(){o&&(t=e.xAxis[0].getExtremes(),i=e.legend,n=o&&o.options.verticalAlign,S(t.min)&&o.render(t.min,t.max),i.display&&"top"===n&&n===i.options.verticalAlign&&(n=C(e.spacingBox),"vertical"===i.options.layout?n.y=e.plotTop:n.y+=o.getHeight(),i.group.placed=!1,i.align(n)))}o&&(s(u,function(t){return t[0]===e})||u.push([e,[y(e.xAxis[0],"afterSetExtremes",function(t){o&&o.render(t.min,t.max)}),y(e,"redraw",r)]]),r())},y(t,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new d(this))}),y(t,"beforeRender",function(){var t=this.axes,e=this.rangeSelector;e&&(S(e.deferredYTDClick)&&(e.clickButton(e.deferredYTDClick),delete e.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),e.render(),t=e.options.verticalAlign,e.options.floating||("bottom"===t?this.extraBottomMargin=!0:"middle"!==t&&(this.extraTopMargin=!0)))}),y(t,"update",function(t){var e=t.options.rangeSelector,i=this.rangeSelector,n=this.extraBottomMargin,t=this.extraTopMargin;e&&e.enabled&&!v(i)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=i=new d(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,i&&(h(this),e=e&&e.verticalAlign||i.options&&i.options.verticalAlign,i.options.floating||("bottom"===e?this.extraBottomMargin=!0:"middle"!==e&&(this.extraTopMargin=!0)),this.extraBottomMargin===n&&this.extraTopMargin===t||(this.isDirtyBox=!0))}),y(t,"render",function(){var t=this.rangeSelector;t&&!t.options.floating&&(t.render(),"bottom"===(t=t.options.verticalAlign)?this.extraBottomMargin=!0:"middle"!==t&&(this.extraTopMargin=!0))}),y(t,"getMargins",function(){var t=this.rangeSelector;t&&(t=t.getHeight(),this.extraTopMargin&&(this.plotTop+=t),this.extraBottomMargin&&(this.marginBottom+=t))}),t.prototype.callbacks.push(h),y(t,"destroy",function(){for(var t=0;t<u.length;t++){var e=u[t];if(e[0]===this)return e[1].forEach(function(t){return t()}),void u.splice(t,1)}}),p.RangeSelector=d),d}),e(t,"Accessibility/Components/RangeSelectorComponent.js",[t["Accessibility/AccessibilityComponent.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Utils/Announcer.js"],t["Core/Chart/Chart.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Core/Utilities.js"],t["Extensions/RangeSelector.js"]],function(t,e,i,n,o,r,s,a){var c=e.unhideChartElementFromAT,l=e.getAxisRangeDescription,u=o.setElAttrs,h=s.addEvent,s=s.extend;n.prototype.highlightRangeSelectorButton=function(t){var e=this.rangeSelector&&this.rangeSelector.buttons||[],i=this.highlightedRangeSelectorItemIx,n=this.rangeSelector&&this.rangeSelector.selected;return void 0!==i&&e[i]&&i!==n&&e[i].setState(this.oldRangeSelectorItemState||0),!!e[this.highlightedRangeSelectorItemIx=t]&&(this.setFocusToElement(e[t].box,e[t].element),t!==n&&(this.oldRangeSelectorItemState=e[t].state,e[t].setState(1)),!0)},h(a,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});a=function(){};return s(a.prototype=new t,{init:function(){var t=this.chart;this.announcer=new i(t,"polite")},onChartUpdate:function(){var i=this.chart,n=this,o=i.rangeSelector;o&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),o.buttons&&o.buttons.length&&o.buttons.forEach(function(t){n.setRangeButtonAttrs(t)}),o.maxInput&&o.minInput&&["minInput","maxInput"].forEach(function(t,e){t=o[t];t&&(c(i,t),n.setRangeInputAttrs(t,"accessibility.rangeSelector."+(e?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){function e(t){return t.setAttribute("aria-hidden",!0)}var i=this.chart,t=i.rangeSelector,n=t&&t.dropdown,o=t&&t.buttons||[];t&&t.hasVisibleDropdown&&n?(c(i,n),o.forEach(function(t){return e(t.element)})):(n&&e(n),o.forEach(function(t){return c(i,t.element)}))},setDropdownAttrs:function(){var t=this.chart,e=t.rangeSelector&&t.rangeSelector.dropdown;e&&(t=t.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:t.options.lang.rangeSelectorZoom}),e.setAttribute("aria-label",t),e.setAttribute("tabindex",-1))},setRangeButtonAttrs:function(t){u(t.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(t,e){var i=this.chart;u(t,{tabindex:-1,"aria-label":i.langFormat(e,{chart:i})})},onButtonNavKbdArrowKey:function(t,e){var i=t.response,n=this.keyCodes,o=this.chart,r=o.options.accessibility.keyboardNavigation.wrapAround,n=e===n.left||e===n.up?-1:1;return o.highlightRangeSelectorButton(o.highlightedRangeSelectorItemIx+n)?i.success:r?(t.init(n),i.success):i[0<n?"next":"prev"]},onButtonNavKbdClick:function(t){var e=t.response,t=this.chart;return 3===t.oldRangeSelectorItemState||this.fakeClickEvent(t.rangeSelector.buttons[t.highlightedRangeSelectorItemIx].element),e.success},onAfterBtnClick:function(){var t=this.chart,e=l(t.xAxis[0]),e=t.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:t,axisRangeDescription:e});e&&this.announcer.announce(e)},onInputKbdMove:function(t){var e=this.chart,i=e.rangeSelector,n=e.highlightedInputRangeIx=(e.highlightedInputRangeIx||0)+t;1<n||n<0?e.accessibility&&(e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation[t<0?"prev":"next"]()):i&&(t=i[n?"maxDateBox":"minDateBox"],n=i[n?"maxInput":"minInput"],t&&n&&e.setFocusToElement(t,n))},onInputNavInit:function(t){var e,i,n=this,o=this,r=this.chart,s=0<t?0:1,a=r.rangeSelector,c=a&&a[s?"maxDateBox":"minDateBox"],l=a&&a.minInput,t=a&&a.maxInput,a=s?t:l;r.highlightedInputRangeIx=s,c&&l&&t&&(r.setFocusToElement(c,a),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),e=h(l,"keydown",l=function(t){(t.which||t.keyCode)===n.keyCodes.tab&&(t.preventDefault(),t.stopPropagation(),o.onInputKbdMove(t.shiftKey?-1:1))}),i=h(t,"keydown",l),this.removeInputKeydownHandler=function(){e(),i()})},onInputNavTerminate:function(){var t=this.chart.rangeSelector||{};t.maxInput&&t.hideInput("max"),t.minInput&&t.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var e=this,i=this.chart,t=i.rangeSelector,n=t&&t.dropdown;t&&n&&(i.setFocusToElement(t.buttonGroup,n),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=h(n,"keydown",function(t){(t.which||t.keyCode)===e.keyCodes.tab&&(t.preventDefault(),t.stopPropagation(),i.accessibility&&(i.accessibility.keyboardNavigation.tabindexContainer.focus(),i.accessibility.keyboardNavigation[t.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var i=this.chart,t=this.keyCodes,n=this;return new r(i,{keyCodeMap:[[[t.left,t.right,t.up,t.down],function(t){return n.onButtonNavKbdArrowKey(this,t)}],[[t.enter,t.space],function(){return n.onButtonNavKbdClick(this)}]],validate:function(){return!!(i.rangeSelector&&i.rangeSelector.buttons&&i.rangeSelector.buttons.length)},init:function(t){var e=i.rangeSelector;e&&e.hasVisibleDropdown?n.initDropdownNav():e&&(e=e.buttons.length-1,i.highlightRangeSelectorButton(0<t?0:e))},terminate:function(){n.removeDropdownKeydownHandler&&(n.removeDropdownKeydownHandler(),delete n.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var e=this.chart,i=this;return new r(e,{keyCodeMap:[],validate:function(){return t=e,Boolean(t.rangeSelector&&t.rangeSelector.inputGroup&&"hidden"!==t.rangeSelector.inputGroup.element.getAttribute("visibility")&&!1!==t.options.rangeSelector.inputEnabled&&t.rangeSelector.minInput&&t.rangeSelector.maxInput);var t},init:function(t){i.onInputNavInit(t)},terminate:function(){i.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}}),a}),e(t,"Accessibility/Components/InfoRegionsComponent.js",[t["Core/Renderer/HTML/AST.js"],t["Core/Chart/Chart.js"],t["Core/FormatUtilities.js"],t["Core/Globals.js"],t["Core/Utilities.js"],t["Accessibility/AccessibilityComponent.js"],t["Accessibility/Utils/Announcer.js"],t["Accessibility/Components/AnnotationsA11y.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Accessibility/Utils/HTMLUtilities.js"]],function(s,t,e,c,i,n,o,r,a,l){var u=e.format,h=c.doc,e=i.extend,d=i.pick,p=r.getAnnotationsInfoHTML,m=a.getAxisDescription,g=a.getAxisRangeDescription,f=a.getChartTitle,b=a.unhideChartElementFromAT,y=l.addClass,x=(l.escapeStringForHTML,l.getElement),v=l.getHeadingTagNameForElement,A=l.setElAttrs,w=l.stripHTMLTagsFromString,C=l.visuallyHideElement;function T(t){return t.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}t.prototype.getTypeDescription=function(t){var e,i,n=t[0],o=this.series&&this.series[0]||{},r={numSeries:this.series.length,numPoints:o.points&&o.points.length,chart:this,mapTitle:o.mapTitle};return n?"map"===n?(e=this,(i=r).mapTitle?e.langFormat("accessibility.chartTypes.mapTypeDescription",i):e.langFormat("accessibility.chartTypes.unknownMap",i)):1<this.types.length?this.langFormat("accessibility.chartTypes.combinationChart",r):(o=this,n=r,i=(e=t)[0],t=o.langFormat("accessibility.seriesTypeDescriptions."+i,n),e=o.series&&o.series.length<2?"Single":"Multiple",(o.langFormat("accessibility.chartTypes."+i+e,n)||o.langFormat("accessibility.chartTypes.default"+e,n))+(t?" "+t:"")):this.langFormat("accessibility.chartTypes.emptyChart",r)};t=function(){};return e(t.prototype=new n,{init:function(){var t=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(t,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(t,"afterViewData",function(t){e.dataTableDiv=t,setTimeout(function(){e.focusDataTable()},300)}),this.announcer=new o(t,"assertive")},initRegionsDefinitions:function(){var i=this;this.screenReaderSections={before:{element:null,buildContent:function(t){var e=t.options.accessibility.screenReaderSection.beforeChartFormatter;return e?e(t):i.defaultBeforeChartFormatter(t)},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.renderTo.firstChild)},afterInserted:function(){void 0!==i.sonifyButtonId&&i.initSonifyButton(i.sonifyButtonId),void 0!==i.dataTableButtonId&&i.initDataTableButton(i.dataTableButtonId)}},after:{element:null,buildContent:function(t){var e=t.options.accessibility.screenReaderSection.afterChartFormatter;return e?e(t):i.defaultAfterChartFormatter()},insertIntoDOM:function(t,e){e.renderTo.insertBefore(t,e.container.nextSibling)}}}},onChartRender:function(){var e=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(t){e.updateScreenReaderSection(t)})},getLinkedDescriptionElement:function(){var t=this.chart.options.accessibility.linkedDescription;if(t){if("string"!=typeof t)return t;t=u(t,this.chart),t=h.querySelectorAll(t);return 1===t.length?t[0]:void 0}},setLinkedDescriptionAttrs:function(){var t=this.linkedDescriptionElement;t&&(t.setAttribute("aria-hidden","true"),y(t,"highcharts-linked-description"))},updateScreenReaderSection:function(t){var e=this.chart,i=this.screenReaderSections[t],n=i.buildContent(e),o=i.element=i.element||this.createElement("div"),r=o.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(o,t),s.setElementHTML(r,n),o.appendChild(r),i.insertIntoDOM(o,e),C(r),b(e,r),i.afterInserted&&i.afterInserted()},setScreenReaderSectionAttribs:function(t,e){var i=this.chart,n=i.langFormat("accessibility.screenReaderSection."+e+"RegionLabel",{chart:i}),e="highcharts-screen-reader-region-"+e+"-"+i.index;A(t,{id:e,"aria-label":n}),t.style.position="relative","all"===i.options.accessibility.landmarkVerbosity&&n&&t.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var t=this.chart,e=t.options.accessibility.screenReaderSection.beforeChartFormat,i=this.getAxesDescription(),n=t.sonify&&t.options.sonification&&t.options.sonification.enabled,o="highcharts-a11y-sonify-data-btn-"+t.index,r="hc-linkto-highcharts-data-table-"+t.index,s=p(t),a=t.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:t}),s={headingTagName:v(t.renderTo),chartTitle:f(t),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:i.xAxis,yAxisDescription:i.yAxis,playAsSoundButton:n?this.getSonifyButtonText(o):"",viewTableButton:t.getCSV?this.getDataTableButtonText(r):"",annotationsTitle:s?a:"",annotationsList:s},t=c.i18nFormat(e,s,t);return this.dataTableButtonId=r,this.sonifyButtonId=o,T(t)},defaultAfterChartFormatter:function(){var t=this.chart,e=t.options.accessibility.screenReaderSection.afterChartFormat,i={endOfChartMarker:this.getEndOfChartMarkerText()};return T(c.i18nFormat(e,i,t))},getLinkedDescription:function(){var t=this.linkedDescriptionElement,t=t&&t.innerHTML||"";return w(t)},getLongdescText:function(){var t=this.chart.options,e=t.caption,i=e&&e.text,e=this.getLinkedDescription();return t.accessibility.description||e||i||""},getTypeDescriptionText:function(){var t=this.chart;return t.types?t.options.accessibility.typeDescription||t.getTypeDescription(t.types):""},getDataTableButtonText:function(t){var e=this.chart;return'<button id="'+t+'">'+e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:f(e)})+"</button>"},getSonifyButtonText:function(t){var e=this.chart;return e.options.sonification&&!1===e.options.sonification.enabled?"":'<button id="'+t+'">'+e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:f(e)})+"</button>"},getSubtitleText:function(){var t=this.chart.options.subtitle;return w(t&&t.text||"")},getEndOfChartMarkerText:function(){var t=this.chart,e=t.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:t});return'<div id="'+("highcharts-end-of-chart-marker-"+t.index)+'">'+e+"</div>"},onDataTableCreated:function(t){var e,i=this.chart;i.options.accessibility.enabled&&(this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true"),(e=t.tree.attributes||{}).tabindex=-1,e.summary=i.langFormat("accessibility.table.tableSummary",{chart:i}),t.tree.attributes=e)},focusDataTable:function(){var t=this.dataTableDiv,t=t&&t.getElementsByTagName("table")[0];t&&t.focus&&t.focus()},initSonifyButton:function(t){var e=this,i=this.sonifyButton=x(t),n=this.chart;i&&n&&(A(i,{tabindex:-1}),i.onclick=function(t){(n.options.accessibility&&n.options.accessibility.screenReaderSection.onPlayAsSoundClick||function(t){i&&(i.setAttribute("aria-hidden","true"),i.setAttribute("aria-label","")),t.preventDefault(),t.stopPropagation();t=n.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:n});e.announcer.announce(t),setTimeout(function(){i&&(i.removeAttribute("aria-hidden"),i.removeAttribute("aria-label")),n.sonify&&n.sonify()},1e3)}).call(this,t,n)})},initDataTableButton:function(t){var e=this.viewDataTableButton=x(t),i=this.chart,t=t.replace("hc-linkto-","");e&&(A(e,{tabindex:-1,"aria-expanded":!!x(t)}),e.onclick=i.options.accessibility.screenReaderSection.onViewDataTableClick||function(){i.viewData()})},getAxesDescription:function(){function t(t,e){return 1<(t=i[t]).length||t[0]&&d(t[0].options.accessibility&&t[0].options.accessibility.enabled,e)}var i=this.chart,e=!!i.types&&i.types.indexOf("map")<0,n=!!i.hasCartesianSeries,o=t("xAxis",!i.angular&&n&&e),n=t("yAxis",n&&e),e={};return o&&(e.xAxis=this.getAxisDescriptionText("xAxis")),n&&(e.yAxis=this.getAxisDescriptionText("yAxis")),e},getAxisDescriptionText:function(t){var e=this.chart,i=e[t];return e.langFormat("accessibility.axis."+t+"Description"+(1<i.length?"Plural":"Singular"),{chart:e,names:i.map(function(t){return m(t)}),ranges:i.map(function(t){return g(t)}),numAxes:i.length})},destroy:function(){this.announcer&&this.announcer.destroy()}}),t}),e(t,"Accessibility/Components/ContainerComponent.js",[t["Accessibility/AccessibilityComponent.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Core/Globals.js"],t["Accessibility/Utils/HTMLUtilities.js"],t["Core/Utilities.js"]],function(t,i,e,n,o,r){var s=e.unhideChartElementFromAT,a=e.getChartTitle,c=n.doc,l=o.stripHTMLTagsFromString,o=function(){};return(0,r.extend)(o.prototype=new t,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var t,e=this.chart,i="highcharts-title-"+e.index,n=l(e.langFormat("accessibility.svgContainerTitle",{chartTitle:a(e)}));n.length&&((t=this.svgTitleElement=this.svgTitleElement||c.createElementNS("http://www.w3.org/2000/svg","title")).textContent=n,t.id=i,e.renderTo.insertBefore(t,e.renderTo.firstChild))},setSVGContainerLabel:function(){var t=this.chart,e=t.langFormat("accessibility.svgContainerLabel",{chartTitle:a(t)});t.renderer.box&&e.length&&t.renderer.box.setAttribute("aria-label",e)},setGraphicContainerAttrs:function(){var t=this.chart,e=t.langFormat("accessibility.graphicContainerLabel",{chartTitle:a(t)});e.length&&t.container.setAttribute("aria-label",e)},setRenderToAttrs:function(){var t=this.chart;"disabled"!==t.options.accessibility.landmarkVerbosity?t.renderTo.setAttribute("role","region"):t.renderTo.removeAttribute("role"),t.renderTo.setAttribute("aria-label",t.langFormat("accessibility.chartContainerLabel",{title:a(t),chart:t}))},makeCreditsAccessible:function(){var t=this.chart,e=t.credits;e&&(e.textStr&&e.element.setAttribute("aria-label",t.langFormat("accessibility.credits",{creditsStr:l(e.textStr)})),s(t,e.element))},getKeyboardNavigation:function(){var e=this.chart;return new i(e,{keyCodeMap:[],validate:function(){return!0},init:function(){var t=e.accessibility;t&&t.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}}),o}),e(t,"Accessibility/HighContrastMode.js",[t["Core/Globals.js"]],function(t){var i=t.doc,n=t.isMS,o=t.win;return{isHighContrastModeActive:function(){var t=/(Edg)/.test(o.navigator.userAgent);if(o.matchMedia&&t)return o.matchMedia("(-ms-high-contrast: active)").matches;if(n&&o.getComputedStyle){var e=i.createElement("div");e.style.backgroundImage="url(data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==)",i.body.appendChild(e);t=(e.currentStyle||o.getComputedStyle(e)).backgroundImage;return i.body.removeChild(e),"none"===t}return!1},setHighContrastTheme:function(t){t.highContrastModeActive=!0;var i=t.options.accessibility.highContrastTheme;t.update(i,!1),t.series.forEach(function(t){var e=i.plotOptions[t.type]||{};t.update({color:e.color||"windowText",colors:[e.color||"windowText"],borderColor:e.borderColor||"window"}),t.points.forEach(function(t){t.options&&t.options.color&&t.update({color:e.color||"windowText",borderColor:e.borderColor||"window"},!1)})}),t.redraw()}}}),e(t,"Accessibility/HighContrastTheme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}}}),e(t,"Accessibility/Options/Options.js",[t["Core/Color/Palette.js"]],function(t){return{accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:t.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}}),e(t,"Accessibility/Options/LangOptions.js",[],function(){return{accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}}}),e(t,"Accessibility/Options/DeprecatedOptions.js",[t["Core/Utilities.js"]],function(t){var c=t.error,s=t.pick;function l(t,e,i){for(var n,o=t,r=0;r<e.length-1;++r)o=o[n=e[r]]=s(o[n],{});o[e[e.length-1]]=i}function a(i,n,o,r){function t(t,e){return e.reduce(function(t,e){return t[e]},t)}var s=t(i.options,n),a=t(i.options,o);Object.keys(r).forEach(function(t){var e=s[t];void 0!==e&&(l(a,r[t],e),c(32,!1,i,((e={})[n.join(".")+"."+t]=o.join(".")+"."+r[t].join("."),e)))})}return function(t){var i,n,o,e,r,s;n=(i=t).options.chart,o=i.options.accessibility||{},["description","typeDescription"].forEach(function(t){var e;n[t]&&(o[t]=n[t],c(32,!1,i,((e={})["chart."+t]="use accessibility."+t,e)))}),(e=t).axes.forEach(function(t){t=t.options;t&&t.description&&(t.accessibility=t.accessibility||{},t.accessibility.description=t.description,c(32,!1,e,{"axis.description":"use axis.accessibility.description"}))}),t.series&&(s={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]},(r=t).series.forEach(function(i){Object.keys(s).forEach(function(t){var e=i.options[t];void 0!==e&&(l(i.options,s[t],"skipKeyboardNavigation"===t?!e:e),c(32,!1,r,((e={})["series."+t]="series."+s[t].join("."),e)))})})),a(t,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]}),a(t,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]}),a(t,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}}),e(t,"Accessibility/A11yI18n.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/FormatUtilities.js"],t["Core/Utilities.js"]],function(t,r,e,i){var a=e.format,g=i.pick;r.i18nFormat=function(t,e,i){for(var n,o,r=[],s=0;n=function(t,e){var i=t.slice(e||0),n=i.indexOf("{"),t=i.indexOf("}");if(-1<n&&n<t)return{statement:i.substring(n+1,t),begin:e+n+1,end:e+t}}(t,s),(o=t.substring(s,n&&n.begin-1)).length&&r.push({value:o,type:"constant"}),n&&r.push({value:n.statement,type:"statement"}),s=n?n.end+1:s+1,n;);return r.forEach(function(t){"statement"===t.type&&(t.value=function(t,e){var i=t.indexOf("#each("),n=t.indexOf("#plural("),o=t.indexOf("["),r=t.indexOf("]");if(-1<i){var s,a=t.slice(i).indexOf(")")+i,c=t.substring(0,i),l=t.substring(a+1),i=t.substring(i+6,a).split(","),a=Number(i[1]),u="";if(s=e[i[0]])for(var h=(a=isNaN(a)?s.length:a)<0?s.length+a:Math.min(a,s.length),d=0;d<h;++d)u+=c+s[d]+l;return u.length?u:""}if(-1<n){var a=t.slice(n).indexOf(")")+n,p=t.substring(n+8,a).split(",");switch(Number(e[p[0]])){case 0:u=g(p[4],p[1]);break;case 1:u=g(p[2],p[1]);break;case 2:u=g(p[3],p[1]);break;default:u=p[1]}return u?(m=u).trim&&m.trim()||m.replace(/^\s+|\s+$/g,""):""}if(-1<o){var m=t.substring(0,o),o=Number(t.substring(o+1,r)),r=void 0;return s=e[m],!isNaN(o)&&s&&(o<0?void 0===(r=s[s.length+o])&&(r=s[0]):void 0===(r=s[o])&&(r=s[s.length-1])),void 0!==r?r:""}return"{"+t+"}"}(t.value,e))}),a(r.reduce(function(t,e){return t+e.value},""),e,i)},t.prototype.langFormat=function(t,e){for(var i=t.split("."),n=this.options.lang,o=0;o<i.length;++o)n=n&&n[i[o]];return"string"==typeof n?r.i18nFormat(n,e,this):""}}),e(t,"Accessibility/FocusBorder.js",[t["Core/Chart/Chart.js"],t["Core/Globals.js"],t["Core/Renderer/SVG/SVGElement.js"],t["Core/Renderer/SVG/SVGLabel.js"],t["Core/Utilities.js"]],function(t,y,e,x,i){var n=i.addEvent,o=i.extend,v=i.pick,A=["x","y","transform","width","height","r","d","stroke-width"];o(e.prototype,{addFocusBorder:function(t,e){this.focusBorder&&this.removeFocusBorder();var i=this.getBBox(),n=v(t,3);i.x+=this.translateX||0,i.y+=this.translateY||0;var o=i.x-n,r=i.y-n,s=i.width+2*n,a=i.height+2*n;var c,l,u,h,d,p,m,g,f,b=this instanceof x;"text"!==this.element.nodeName&&!b||(h=!!this.rotation,c=b?{x:h?1:0,y:0}:(m=p=0,"middle"===(d=this).attr("text-anchor")?(p=y.isFirefox&&d.rotation?.25:.5,m=y.isFirefox&&!d.rotation?.75:.5):d.rotation?p=.25:m=.75,{x:p,y:m}),l=+this.attr("x"),u=+this.attr("y"),isNaN(l)||(o=l-i.width*c.x-n),isNaN(u)||(r=u-i.height*c.y-n),b&&h&&(h=s,s=a,a=h,isNaN(l)||(o=l-i.height*c.x-n),isNaN(u)||(r=u-i.width*c.y-n))),this.focusBorder=this.renderer.rect(o,r,s,a,parseInt((e&&e.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:e&&e.stroke,"stroke-width":e&&e.strokeWidth}),function(i){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];i.focusBorderUpdateHooks||(i.focusBorderUpdateHooks={},A.forEach(function(t){var t=t+"Setter",e=i[t]||i._defaultSetter;i.focusBorderUpdateHooks[t]=e,i[t]=function(){var t=e.apply(i,arguments);return i.addFocusBorder.apply(i,n),t}}))}(this,t,e),(g=this).focusBorderDestroyHook||(f=g.destroy,g.destroy=function(){return g.focusBorder&&g.focusBorder.destroy&&g.focusBorder.destroy(),f.apply(g,arguments)},g.focusBorderDestroyHook=f)},removeFocusBorder:function(){var i,t;(i=this).focusBorderUpdateHooks&&(Object.keys(i.focusBorderUpdateHooks).forEach(function(t){var e=i.focusBorderUpdateHooks[t];e===i._defaultSetter?delete i[t]:i[t]=e}),delete i.focusBorderUpdateHooks),(t=this).focusBorderDestroyHook&&(t.destroy=t.focusBorderDestroyHook,delete t.focusBorderDestroyHook),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}}),t.prototype.renderFocusBorder=function(){var t=this.focusElement,e=this.options.accessibility.keyboardNavigation.focusBorder;t&&(t.removeFocusBorder(),e.enabled&&t.addFocusBorder(e.margin,{stroke:e.style.color,strokeWidth:e.style.lineWidth,r:e.style.borderRadius}))},t.prototype.setFocusToElement=function(t,e){var i=this.options.accessibility.keyboardNavigation.focusBorder,e=e||t.element;e&&e.focus&&(e.hcEvents&&e.hcEvents.focusin||n(e,"focusin",function(){}),e.focus(),i.hideBrowserFocusOutline&&(e.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=t,this.renderFocusBorder()}}),e(t,"Accessibility/Accessibility.js",[t["Core/Chart/Chart.js"],t["Accessibility/Utils/ChartUtilities.js"],t["Core/Globals.js"],t["Accessibility/KeyboardNavigationHandler.js"],t["Core/DefaultOptions.js"],t["Core/Series/Point.js"],t["Core/Series/Series.js"],t["Core/Utilities.js"],t["Accessibility/AccessibilityComponent.js"],t["Accessibility/KeyboardNavigation.js"],t["Accessibility/Components/LegendComponent.js"],t["Accessibility/Components/MenuComponent.js"],t["Accessibility/Components/SeriesComponent/SeriesComponent.js"],t["Accessibility/Components/ZoomComponent.js"],t["Accessibility/Components/RangeSelectorComponent.js"],t["Accessibility/Components/InfoRegionsComponent.js"],t["Accessibility/Components/ContainerComponent.js"],t["Accessibility/HighContrastMode.js"],t["Accessibility/HighContrastTheme.js"],t["Accessibility/Options/Options.js"],t["Accessibility/Options/LangOptions.js"],t["Accessibility/Options/DeprecatedOptions.js"],t["Accessibility/Utils/HTMLUtilities.js"]],function(e,t,i,n,o,r,s,a,c,l,u,h,d,p,m,g,f,b,y,x,v,A,w){var C=i.doc,o=o.defaultOptions,T=a.addEvent,S=a.extend,E=a.fireEvent,P=a.merge;function B(t){this.init(t)}P(!0,o,x,{accessibility:{highContrastTheme:y},lang:v}),i.A11yChartUtilities=t,i.A11yHTMLUtilities=w,i.KeyboardNavigationHandler=n,i.AccessibilityComponent=c,B.prototype={init:function(t){this.chart=t,C.addEventListener&&t.renderer.isSVG?(A(t),this.initComponents(),this.keyboardNavigation=new l(t,this.components),this.update()):t.renderTo.setAttribute("aria-hidden",!0)},initComponents:function(){var e=this.chart,t=e.options.accessibility;this.components={container:new f,infoRegions:new g,legend:new u,chartMenu:new h,rangeSelector:new m,series:new d,zoom:new p},t.customComponents&&S(this.components,t.customComponents);var i=this.components;this.getComponentOrder().forEach(function(t){i[t].initBase(e),i[t].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var t=Object.keys(this.components).filter(function(t){return"series"!==t});return["series"].concat(t)},update:function(){var e=this.components,i=this.chart,t=i.options.accessibility;E(i,"beforeA11yUpdate"),i.types=this.getChartTypes(),this.getComponentOrder().forEach(function(t){e[t].onChartUpdate(),E(i,"afterA11yComponentUpdate",{name:t,component:e[t]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!i.highContrastModeActive&&b.isHighContrastModeActive()&&b.setHighContrastTheme(i),E(i,"afterA11yUpdate",{accessibility:this})},destroy:function(){var t=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),t.renderTo&&t.renderTo.setAttribute("aria-hidden",!0),t.focusElement&&t.focusElement.removeFocusBorder()},getChartTypes:function(){var e={};return this.chart.series.forEach(function(t){e[t.type]=1}),Object.keys(e)}},e.prototype.updateA11yEnabled=function(){var t=this.accessibility,e=this.options.accessibility;e&&e.enabled?t?t.update():this.accessibility=t=new B(this):t?(t.destroy&&t.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)},T(e,"render",function(t){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var e=this.accessibility;e&&e.getComponentOrder().forEach(function(t){e.components[t].onChartRender()})}),T(e,"update",function(t){t=t.options.accessibility;t&&(t.customComponents&&(this.options.accessibility.customComponents=t.customComponents,delete t.customComponents),P(!0,this.options.accessibility,t),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0}),T(r,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)}),["addSeries","init"].forEach(function(t){T(e,t,function(){this.a11yDirty=!0})}),["update","updatedData","remove"].forEach(function(t){T(s,t,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})}),["afterDrilldown","drillupall"].forEach(function(t){T(e,t,function(){this.accessibility&&this.accessibility.update()})}),T(e,"destroy",function(){this.accessibility&&this.accessibility.destroy()})}),e(t,"masters/modules/accessibility.src.js",[],function(){})});